// Code generated by smithy-go-codegen DO NOT EDIT.

package drs

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/drs/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Updates a LaunchConfiguration by Source Server ID.
func (c *Client) UpdateLaunchConfiguration(ctx context.Context, params *UpdateLaunchConfigurationInput, optFns ...func(*Options)) (*UpdateLaunchConfigurationOutput, error) {
	if params == nil {
		params = &UpdateLaunchConfigurationInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateLaunchConfiguration", params, optFns, c.addOperationUpdateLaunchConfigurationMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateLaunchConfigurationOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateLaunchConfigurationInput struct {

	// The ID of the Source Server that we want to retrieve a Launch Configuration for.
	//
	// This member is required.
	SourceServerID *string

	// Whether we should copy the Private IP of the Source Server to the Recovery
	// Instance.
	CopyPrivateIp *bool

	// Whether we want to copy the tags of the Source Server to the EC2 machine of the
	// Recovery Instance.
	CopyTags *bool

	// The state of the Recovery Instance in EC2 after the recovery operation.
	LaunchDisposition types.LaunchDisposition

	// Launch into existing instance properties.
	LaunchIntoInstanceProperties *types.LaunchIntoInstanceProperties

	// The licensing configuration to be used for this launch configuration.
	Licensing *types.Licensing

	// The name of the launch configuration.
	Name *string

	// Whether we want to enable post-launch actions for the Source Server.
	PostLaunchEnabled *bool

	// Whether Elastic Disaster Recovery should try to automatically choose the
	// instance type that best matches the OS, CPU, and RAM of your Source Server.
	TargetInstanceTypeRightSizingMethod types.TargetInstanceTypeRightSizingMethod

	noSmithyDocumentSerde
}

type UpdateLaunchConfigurationOutput struct {

	// Whether we should copy the Private IP of the Source Server to the Recovery
	// Instance.
	CopyPrivateIp *bool

	// Whether we want to copy the tags of the Source Server to the EC2 machine of the
	// Recovery Instance.
	CopyTags *bool

	// The EC2 launch template ID of this launch configuration.
	Ec2LaunchTemplateID *string

	// The state of the Recovery Instance in EC2 after the recovery operation.
	LaunchDisposition types.LaunchDisposition

	// Launch into existing instance properties.
	LaunchIntoInstanceProperties *types.LaunchIntoInstanceProperties

	// The licensing configuration to be used for this launch configuration.
	Licensing *types.Licensing

	// The name of the launch configuration.
	Name *string

	// Whether we want to activate post-launch actions for the Source Server.
	PostLaunchEnabled *bool

	// The ID of the Source Server for this launch configuration.
	SourceServerID *string

	// Whether Elastic Disaster Recovery should try to automatically choose the
	// instance type that best matches the OS, CPU, and RAM of your Source Server.
	TargetInstanceTypeRightSizingMethod types.TargetInstanceTypeRightSizingMethod

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateLaunchConfigurationMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpUpdateLaunchConfiguration{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpUpdateLaunchConfiguration{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateLaunchConfiguration"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpUpdateLaunchConfigurationValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateLaunchConfiguration(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateLaunchConfiguration(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateLaunchConfiguration",
	}
}
