// Code generated by smithy-go-codegen DO NOT EDIT.

package datazone

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/datazone/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists asset filters.
func (c *Client) ListAssetFilters(ctx context.Context, params *ListAssetFiltersInput, optFns ...func(*Options)) (*ListAssetFiltersOutput, error) {
	if params == nil {
		params = &ListAssetFiltersInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListAssetFilters", params, optFns, c.addOperationListAssetFiltersMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListAssetFiltersOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListAssetFiltersInput struct {

	// The ID of the data asset.
	//
	// This member is required.
	AssetIdentifier *string

	// The ID of the domain where you want to list asset filters.
	//
	// This member is required.
	DomainIdentifier *string

	// The maximum number of asset filters to return in a single call to
	// ListAssetFilters . When the number of asset filters to be listed is greater than
	// the value of MaxResults , the response contains a NextToken value that you can
	// use in a subsequent call to ListAssetFilters to list the next set of asset
	// filters.
	MaxResults *int32

	// When the number of asset filters is greater than the default value for the
	// MaxResults parameter, or if you explicitly specify a value for MaxResults that
	// is less than the number of asset filters, the response includes a pagination
	// token named NextToken . You can specify this NextToken value in a subsequent
	// call to ListAssetFilters to list the next set of asset filters.
	NextToken *string

	// The status of the asset filter.
	Status types.FilterStatus

	noSmithyDocumentSerde
}

type ListAssetFiltersOutput struct {

	// The results of the ListAssetFilters action.
	//
	// This member is required.
	Items []types.AssetFilterSummary

	// When the number of asset filters is greater than the default value for the
	// MaxResults parameter, or if you explicitly specify a value for MaxResults that
	// is less than the number of asset filters, the response includes a pagination
	// token named NextToken . You can specify this NextToken value in a subsequent
	// call to ListAssetFilters to list the next set of asset filters.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListAssetFiltersMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListAssetFilters{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListAssetFilters{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListAssetFilters"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListAssetFiltersValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListAssetFilters(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListAssetFiltersPaginatorOptions is the paginator options for ListAssetFilters
type ListAssetFiltersPaginatorOptions struct {
	// The maximum number of asset filters to return in a single call to
	// ListAssetFilters . When the number of asset filters to be listed is greater than
	// the value of MaxResults , the response contains a NextToken value that you can
	// use in a subsequent call to ListAssetFilters to list the next set of asset
	// filters.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListAssetFiltersPaginator is a paginator for ListAssetFilters
type ListAssetFiltersPaginator struct {
	options   ListAssetFiltersPaginatorOptions
	client    ListAssetFiltersAPIClient
	params    *ListAssetFiltersInput
	nextToken *string
	firstPage bool
}

// NewListAssetFiltersPaginator returns a new ListAssetFiltersPaginator
func NewListAssetFiltersPaginator(client ListAssetFiltersAPIClient, params *ListAssetFiltersInput, optFns ...func(*ListAssetFiltersPaginatorOptions)) *ListAssetFiltersPaginator {
	if params == nil {
		params = &ListAssetFiltersInput{}
	}

	options := ListAssetFiltersPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListAssetFiltersPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListAssetFiltersPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListAssetFilters page.
func (p *ListAssetFiltersPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListAssetFiltersOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListAssetFilters(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListAssetFiltersAPIClient is a client that implements the ListAssetFilters
// operation.
type ListAssetFiltersAPIClient interface {
	ListAssetFilters(context.Context, *ListAssetFiltersInput, ...func(*Options)) (*ListAssetFiltersOutput, error)
}

var _ ListAssetFiltersAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListAssetFilters(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListAssetFilters",
	}
}
