// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Represents a single entry in a list (or array) of DataSync agents when you call
// the [ListAgents]operation.
//
// [ListAgents]: https://docs.aws.amazon.com/datasync/latest/userguide/API_ListAgents.html
type AgentListEntry struct {

	// The Amazon Resource Name (ARN) of a DataSync agent.
	AgentArn *string

	// The name of an agent.
	Name *string

	// The platform-related details about the agent, such as the version number.
	Platform *Platform

	// The status of an agent.
	//
	//   - If the status is ONLINE , the agent is configured properly and ready to use.
	//
	//   - If the status is OFFLINE , the agent has been out of contact with DataSync
	//   for five minutes or longer. This can happen for a few reasons. For more
	//   information, see [What do I do if my agent is offline?]
	//
	// [What do I do if my agent is offline?]: https://docs.aws.amazon.com/datasync/latest/userguide/troubleshooting-datasync-agents.html#troubleshoot-agent-offline
	Status AgentStatus

	noSmithyDocumentSerde
}

// The shared access signature (SAS) configuration that allows DataSync to access
// your Microsoft Azure Blob Storage.
//
// For more information, see [SAS tokens] for accessing your Azure Blob Storage.
//
// [SAS tokens]: https://docs.aws.amazon.com/datasync/latest/userguide/creating-azure-blob-location.html#azure-blob-sas-tokens
type AzureBlobSasConfiguration struct {

	// Specifies a SAS token that provides permissions to access your Azure Blob
	// Storage.
	//
	// The token is part of the SAS URI string that comes after the storage resource
	// URI and a question mark. A token looks something like this:
	//
	//     sp=r&st=2023-12-20T14:54:52Z&se=2023-12-20T22:54:52Z&spr=https&sv=2021-06-08&sr=c&sig=aBBKDWQvyuVcTPH9EBp%2FXTI9E%2F%2Fmq171%2BZU178wcwqU%3D
	//
	// This member is required.
	Token *string

	noSmithyDocumentSerde
}

// Specifies configuration information for a DataSync-managed secret, such as an
// authentication token or secret key that DataSync uses to access a specific
// storage location, with a customer-managed KMS key.
//
// You can use either CmkSecretConfig or CustomSecretConfig to provide credentials
// for a CreateLocation request. Do not provide both parameters for the same
// request.
type CmkSecretConfig struct {

	// Specifies the ARN for the customer-managed KMS key that DataSync uses to
	// encrypt the DataSync-managed secret stored for SecretArn . DataSync provides
	// this key to Secrets Manager.
	KmsKeyArn *string

	// Specifies the ARN for the DataSync-managed Secrets Manager secret that that is
	// used to access a specific storage location. This property is generated by
	// DataSync and is read-only. DataSync encrypts this secret with the KMS key that
	// you specify for KmsKeyArn .
	SecretArn *string

	noSmithyDocumentSerde
}

// Specifies configuration information for a customer-managed Secrets Manager
// secret where a storage location authentication token or secret key is stored in
// plain text. This configuration includes the secret ARN, and the ARN for an IAM
// role that provides access to the secret.
//
// You can use either CmkSecretConfig or CustomSecretConfig to provide credentials
// for a CreateLocation request. Do not provide both parameters for the same
// request.
type CustomSecretConfig struct {

	// Specifies the ARN for the Identity and Access Management role that DataSync
	// uses to access the secret specified for SecretArn .
	SecretAccessRoleArn *string

	// Specifies the ARN for an Secrets Manager secret.
	SecretArn *string

	noSmithyDocumentSerde
}

// The subnet and security groups that DataSync uses to connect to one of your
// Amazon EFS file system's [mount targets].
//
// [mount targets]: https://docs.aws.amazon.com/efs/latest/ug/accessing-fs.html
type Ec2Config struct {

	// Specifies the Amazon Resource Names (ARNs) of the security groups associated
	// with an Amazon EFS file system's mount target.
	//
	// This member is required.
	SecurityGroupArns []string

	// Specifies the ARN of a subnet where DataSync creates the [network interfaces] for managing traffic
	// during your transfer.
	//
	// The subnet must be located:
	//
	//   - In the same virtual private cloud (VPC) as the Amazon EFS file system.
	//
	//   - In the same Availability Zone as at least one mount target for the Amazon
	//   EFS file system.
	//
	// You don't need to specify a subnet that includes a file system mount target.
	//
	// [network interfaces]: https://docs.aws.amazon.com/datasync/latest/userguide/datasync-network.html#required-network-interfaces
	//
	// This member is required.
	SubnetArn *string

	noSmithyDocumentSerde
}

// Specifies which files, folders, and objects to include or exclude when
// transferring files from source to destination.
type FilterRule struct {

	// The type of filter rule to apply. DataSync only supports the SIMPLE_PATTERN
	// rule type.
	FilterType FilterType

	// A single filter string that consists of the patterns to include or exclude. The
	// patterns are delimited by "|" (that is, a pipe), for example: /folder1|/folder2
	Value *string

	noSmithyDocumentSerde
}

// Specifies the data transfer protocol that DataSync uses to access your Amazon
// FSx file system.
type FsxProtocol struct {

	// Specifies the Network File System (NFS) protocol configuration that DataSync
	// uses to access your FSx for OpenZFS file system or FSx for ONTAP file system's
	// storage virtual machine (SVM).
	NFS *FsxProtocolNfs

	// Specifies the Server Message Block (SMB) protocol configuration that DataSync
	// uses to access your FSx for ONTAP file system's SVM.
	SMB *FsxProtocolSmb

	noSmithyDocumentSerde
}

// Specifies the Network File System (NFS) protocol configuration that DataSync
// uses to access your FSx for OpenZFS file system or FSx for ONTAP file system's
// storage virtual machine (SVM).
type FsxProtocolNfs struct {

	// Specifies how DataSync can access a location using the NFS protocol.
	MountOptions *NfsMountOptions

	noSmithyDocumentSerde
}

// Specifies the Server Message Block (SMB) protocol configuration that DataSync
// uses to access your Amazon FSx for NetApp ONTAP file system's storage virtual
// machine (SVM). For more information, see [Providing DataSync access to FSx for ONTAP file systems].
//
// [Providing DataSync access to FSx for ONTAP file systems]: https://docs.aws.amazon.com/datasync/latest/userguide/create-ontap-location.html#create-ontap-location-access
type FsxProtocolSmb struct {

	// Specifies the password of a user who has permission to access your SVM.
	//
	// This member is required.
	Password *string

	// Specifies a user that can mount and access the files, folders, and metadata in
	// your SVM.
	//
	// For information about choosing a user with the right level of access for your
	// transfer, see [Using the SMB protocol].
	//
	// [Using the SMB protocol]: https://docs.aws.amazon.com/datasync/latest/userguide/create-ontap-location.html#create-ontap-location-smb
	//
	// This member is required.
	User *string

	// Specifies the name of the Windows domain that your storage virtual machine
	// (SVM) belongs to.
	//
	// If you have multiple domains in your environment, configuring this setting
	// makes sure that DataSync connects to the right SVM.
	//
	// If you have multiple Active Directory domains in your environment, configuring
	// this parameter makes sure that DataSync connects to the right SVM.
	Domain *string

	// Specifies the version of the Server Message Block (SMB) protocol that DataSync
	// uses to access an SMB file server.
	MountOptions *SmbMountOptions

	noSmithyDocumentSerde
}

// Specifies the data transfer protocol that DataSync uses to access your Amazon
// FSx file system.
//
// You can't update the Network File System (NFS) protocol configuration for FSx
// for ONTAP locations. DataSync currently only supports NFS version 3 with this
// location type.
type FsxUpdateProtocol struct {

	// Specifies the Network File System (NFS) protocol configuration that DataSync
	// uses to access your FSx for OpenZFS file system or FSx for ONTAP file system's
	// storage virtual machine (SVM).
	NFS *FsxProtocolNfs

	// Specifies the Server Message Block (SMB) protocol configuration that DataSync
	// uses to access your FSx for ONTAP file system's storage virtual machine (SVM).
	SMB *FsxUpdateProtocolSmb

	noSmithyDocumentSerde
}

// Specifies the Server Message Block (SMB) protocol configuration that DataSync
// uses to access your Amazon FSx for NetApp ONTAP file system's storage virtual
// machine (SVM). For more information, see [Providing DataSync access to FSx for ONTAP file systems].
//
// [Providing DataSync access to FSx for ONTAP file systems]: https://docs.aws.amazon.com/datasync/latest/userguide/create-ontap-location.html#create-ontap-location-access
type FsxUpdateProtocolSmb struct {

	// Specifies the name of the Windows domain that your storage virtual machine
	// (SVM) belongs to.
	//
	// If you have multiple Active Directory domains in your environment, configuring
	// this parameter makes sure that DataSync connects to the right SVM.
	Domain *string

	// Specifies the version of the Server Message Block (SMB) protocol that DataSync
	// uses to access an SMB file server.
	MountOptions *SmbMountOptions

	// Specifies the password of a user who has permission to access your SVM.
	Password *string

	// Specifies a user that can mount and access the files, folders, and metadata in
	// your SVM.
	//
	// For information about choosing a user with the right level of access for your
	// transfer, see [Using the SMB protocol].
	//
	// [Using the SMB protocol]: https://docs.aws.amazon.com/datasync/latest/userguide/create-ontap-location.html#create-ontap-location-smb
	User *string

	noSmithyDocumentSerde
}

// The NameNode of the Hadoop Distributed File System (HDFS). The NameNode manages
// the file system's namespace. The NameNode performs operations such as opening,
// closing, and renaming files and directories. The NameNode contains the
// information to map blocks of data to the DataNodes.
type HdfsNameNode struct {

	// The hostname of the NameNode in the HDFS cluster. This value is the IP address
	// or Domain Name Service (DNS) name of the NameNode. An agent that's installed
	// on-premises uses this hostname to communicate with the NameNode in the network.
	//
	// This member is required.
	Hostname *string

	// The port that the NameNode uses to listen to client requests.
	//
	// This member is required.
	Port *int32

	noSmithyDocumentSerde
}

// Narrow down the list of resources returned by ListLocations . For example, to
// see all your Amazon S3 locations, create a filter using "Name": "LocationType" ,
// "Operator": "Equals" , and "Values": "S3" .
//
// For more information, see [filtering resources].
//
// [filtering resources]: https://docs.aws.amazon.com/datasync/latest/userguide/query-resources.html
type LocationFilter struct {

	// The name of the filter being used. Each API call supports a list of filters
	// that are available for it (for example, LocationType for ListLocations ).
	//
	// This member is required.
	Name LocationFilterName

	// The operator that is used to compare filter values (for example, Equals or
	// Contains ).
	//
	// This member is required.
	Operator Operator

	// The values that you want to filter for. For example, you might want to display
	// only Amazon S3 locations.
	//
	// This member is required.
	Values []string

	noSmithyDocumentSerde
}

// Represents a single entry in a list of locations. LocationListEntry returns an
// array that contains a list of locations when the [ListLocations]operation is called.
//
// [ListLocations]: https://docs.aws.amazon.com/datasync/latest/userguide/API_ListLocations.html
type LocationListEntry struct {

	// The Amazon Resource Name (ARN) of the location. For Network File System (NFS)
	// or Amazon EFS, the location is the export path. For Amazon S3, the location is
	// the prefix path that you want to mount and use as the root of the location.
	LocationArn *string

	// Represents a list of URIs of a location. LocationUri returns an array that
	// contains a list of locations when the [ListLocations]operation is called.
	//
	// Format: TYPE://GLOBAL_ID/SUBDIR .
	//
	// TYPE designates the type of location (for example, nfs or s3 ).
	//
	// GLOBAL_ID is the globally unique identifier of the resource that backs the
	// location. An example for EFS is us-east-2.fs-abcd1234 . An example for Amazon S3
	// is the bucket name, such as myBucket . An example for NFS is a valid IPv4 or
	// IPv6 address or a hostname that is compliant with DNS.
	//
	// SUBDIR is a valid file system path, delimited by forward slashes as is the *nix
	// convention. For NFS and Amazon EFS, it's the export path to mount the location.
	// For Amazon S3, it's the prefix path that you mount to and treat as the root of
	// the location.
	//
	// [ListLocations]: https://docs.aws.amazon.com/datasync/latest/userguide/API_ListLocations.html
	LocationUri *string

	noSmithyDocumentSerde
}

// Specifies configuration information for a DataSync-managed secret, such as an
// authentication token or set of credentials that DataSync uses to access a
// specific transfer location. DataSync uses the default Amazon Web
// Services-managed KMS key to encrypt this secret in Secrets Manager.
type ManagedSecretConfig struct {

	// Specifies the ARN for an Secrets Manager secret.
	SecretArn *string

	noSmithyDocumentSerde
}

// Configures a manifest, which is a list of files or objects that you want
// DataSync to transfer. For more information and configuration examples, see [Specifying what DataSync transfers by using a manifest].
//
// [Specifying what DataSync transfers by using a manifest]: https://docs.aws.amazon.com/datasync/latest/userguide/transferring-with-manifest.html
type ManifestConfig struct {

	// Specifies what DataSync uses the manifest for.
	Action ManifestAction

	// Specifies the file format of your manifest. For more information, see [Creating a manifest].
	//
	// [Creating a manifest]: https://docs.aws.amazon.com/datasync/latest/userguide/transferring-with-manifest.html#transferring-with-manifest-create
	Format ManifestFormat

	// Specifies the manifest that you want DataSync to use and where it's hosted.
	//
	// You must specify this parameter if you're configuring a new manifest on or
	// after February 7, 2024.
	//
	// If you don't, you'll get a 400 status code and ValidationException error
	// stating that you're missing the IAM role for DataSync to access the S3 bucket
	// where you're hosting your manifest. For more information, see [Providing DataSync access to your manifest].
	//
	// [Providing DataSync access to your manifest]: https://docs.aws.amazon.com/datasync/latest/userguide/transferring-with-manifest.html#transferring-with-manifest-access
	Source *SourceManifestConfig

	noSmithyDocumentSerde
}

// Specifies how DataSync can access a location using the NFS protocol.
type NfsMountOptions struct {

	// Specifies the NFS version that you want DataSync to use when mounting your NFS
	// share. If the server refuses to use the version specified, the task fails.
	//
	// You can specify the following options:
	//
	//   - AUTOMATIC (default): DataSync chooses NFS version 4.1.
	//
	//   - NFS3 : Stateless protocol version that allows for asynchronous writes on the
	//   server.
	//
	//   - NFSv4_0 : Stateful, firewall-friendly protocol version that supports
	//   delegations and pseudo file systems.
	//
	//   - NFSv4_1 : Stateful protocol version that supports sessions, directory
	//   delegations, and parallel data processing. NFS version 4.1 also includes all
	//   features available in version 4.0.
	//
	// DataSync currently only supports NFS version 3 with Amazon FSx for NetApp ONTAP
	// locations.
	Version NfsVersion

	noSmithyDocumentSerde
}

// The DataSync agents that can connect to your Network File System (NFS) file
// server.
type OnPremConfig struct {

	// The Amazon Resource Names (ARNs) of the DataSync agents that can connect to
	// your NFS file server.
	//
	// You can specify more than one agent. For more information, see [Using multiple DataSync agents].
	//
	// [Using multiple DataSync agents]: https://docs.aws.amazon.com/datasync/latest/userguide/do-i-need-datasync-agent.html#multiple-agents
	//
	// This member is required.
	AgentArns []string

	noSmithyDocumentSerde
}

// Indicates how your transfer task is configured. These options include how
// DataSync handles files, objects, and their associated metadata during your
// transfer. You also can specify how to verify data integrity, set bandwidth
// limits for your task, among other options.
//
// Each option has a default value. Unless you need to, you don't have to
// configure any option before calling [StartTaskExecution].
//
// You also can override your task options for each task execution. For example,
// you might want to adjust the LogLevel for an individual execution.
//
// [StartTaskExecution]: https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html
type Options struct {

	// Specifies whether to preserve metadata indicating the last time a file was read
	// or written to.
	//
	// The behavior of Atime isn't fully standard across platforms, so DataSync can
	// only do this on a best-effort basis.
	//
	//   - BEST_EFFORT (default) - DataSync attempts to preserve the original Atime
	//   attribute on all source files (that is, the version before the PREPARING steps
	//   of the task execution). This option is recommended.
	//
	//   - NONE - Ignores Atime .
	//
	// If Atime is set to BEST_EFFORT , Mtime must be set to PRESERVE .
	//
	// If Atime is set to NONE , Mtime must also be NONE .
	Atime Atime

	// Limits the bandwidth used by a DataSync task. For example, if you want DataSync
	// to use a maximum of 1 MB, set this value to 1048576 ( =1024*1024 ).
	//
	// Not applicable to [Enhanced mode tasks].
	//
	// [Enhanced mode tasks]: https://docs.aws.amazon.com/datasync/latest/userguide/choosing-task-mode.html
	BytesPerSecond *int64

	// Specifies the POSIX group ID (GID) of the file's owners.
	//
	//   - INT_VALUE (default) - Preserves the integer value of user ID (UID) and GID,
	//   which is recommended.
	//
	//   - NONE - Ignores UID and GID.
	//
	// For more information, see [Understanding how DataSync handles file and object metadata].
	//
	// [Understanding how DataSync handles file and object metadata]: https://docs.aws.amazon.com/datasync/latest/userguide/metadata-copied.html
	Gid Gid

	// Specifies the type of logs that DataSync publishes to a Amazon CloudWatch Logs
	// log group. To specify the log group, see [CloudWatchLogGroupArn].
	//
	//   - BASIC - Publishes logs with only basic information (such as transfer errors).
	//
	//   - TRANSFER - Publishes logs for all files or objects that your DataSync task
	//   transfers and performs data-integrity checks on.
	//
	//   - OFF - No logs are published.
	//
	// [CloudWatchLogGroupArn]: https://docs.aws.amazon.com/datasync/latest/userguide/API_CreateTask.html#DataSync-CreateTask-request-CloudWatchLogGroupArn
	LogLevel LogLevel

	// Specifies whether to preserve metadata indicating the last time that a file was
	// written to before the PREPARING step of your task execution. This option is
	// required when you need to run the a task more than once.
	//
	//   - PRESERVE (default) - Preserves original Mtime , which is recommended.
	//
	//   - NONE - Ignores Mtime .
	//
	// If Mtime is set to PRESERVE , Atime must be set to BEST_EFFORT .
	//
	// If Mtime is set to NONE , Atime must also be set to NONE .
	Mtime Mtime

	// Specifies whether you want DataSync to PRESERVE object tags (default behavior)
	// when transferring between object storage systems. If you want your DataSync task
	// to ignore object tags, specify the NONE value.
	ObjectTags ObjectTags

	// Specifies whether DataSync should modify or preserve data at the destination
	// location.
	//
	//   - ALWAYS (default) - DataSync modifies data in the destination location when
	//   source data (including metadata) has changed.
	//
	// If DataSync overwrites objects, you might incur additional charges for certain
	//   Amazon S3 storage classes (for example, for retrieval or early deletion). For
	//   more information, see [Storage class considerations with Amazon S3 transfers].
	//
	//   - NEVER - DataSync doesn't overwrite data in the destination location even if
	//   the source data has changed. You can use this option to protect against
	//   overwriting changes made to files or objects in the destination.
	//
	// [Storage class considerations with Amazon S3 transfers]: https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#using-storage-classes
	OverwriteMode OverwriteMode

	// Specifies which users or groups can access a file for a specific purpose such
	// as reading, writing, or execution of the file.
	//
	// For more information, see [Understanding how DataSync handles file and object metadata].
	//
	//   - PRESERVE (default) - Preserves POSIX-style permissions, which is recommended.
	//
	//   - NONE - Ignores POSIX-style permissions.
	//
	// DataSync can preserve extant permissions of a source location.
	//
	// [Understanding how DataSync handles file and object metadata]: https://docs.aws.amazon.com/datasync/latest/userguide/metadata-copied.html
	PosixPermissions PosixPermissions

	// Specifies whether files in the destination location that don't exist in the
	// source should be preserved. This option can affect your Amazon S3 storage cost.
	// If your task deletes objects, you might incur minimum storage duration charges
	// for certain storage classes. For detailed information, see [Considerations when working with Amazon S3 storage classes in DataSync].
	//
	//   - PRESERVE (default) - Ignores such destination files, which is recommended.
	//
	//   - REMOVE - Deletes destination files that aren’t present in the source.
	//
	// If you set this parameter to REMOVE , you can't set TransferMode to ALL . When
	// you transfer all data, DataSync doesn't scan your destination location and
	// doesn't know what to delete.
	//
	// [Considerations when working with Amazon S3 storage classes in DataSync]: https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#using-storage-classes
	PreserveDeletedFiles PreserveDeletedFiles

	// Specifies whether DataSync should preserve the metadata of block and character
	// devices in the source location and recreate the files with that device name and
	// metadata on the destination. DataSync copies only the name and metadata of such
	// devices.
	//
	// DataSync can't copy the actual contents of these devices because they're
	// nonterminal and don't return an end-of-file (EOF) marker.
	//
	//   - NONE (default) - Ignores special devices (recommended).
	//
	//   - PRESERVE - Preserves character and block device metadata. This option
	//   currently isn't supported for Amazon EFS.
	PreserveDevices PreserveDevices

	// Specifies which components of the SMB security descriptor are copied from
	// source to destination objects.
	//
	// This value is only used for transfers between SMB and Amazon FSx for Windows
	// File Server locations or between two FSx for Windows File Server locations. For
	// more information, see [Understanding how DataSync handles file and object metadata].
	//
	//   - OWNER_DACL (default) - For each copied object, DataSync copies the following
	//   metadata:
	//
	//   - The object owner.
	//
	//   - NTFS discretionary access control lists (DACLs), which determine whether to
	//   grant access to an object.
	//
	// DataSync won't copy NTFS system access control lists (SACLs) with this option.
	//
	//   - OWNER_DACL_SACL - For each copied object, DataSync copies the following
	//   metadata:
	//
	//   - The object owner.
	//
	//   - NTFS discretionary access control lists (DACLs), which determine whether to
	//   grant access to an object.
	//
	//   - SACLs, which are used by administrators to log attempts to access a secured
	//   object.
	//
	// Copying SACLs requires granting additional permissions to the Windows user that
	//   DataSync uses to access your SMB location. For information about choosing a user
	//   with the right permissions, see required permissions for [SMB], [FSx for Windows File Server], or [FSx for ONTAP](depending on
	//   the type of location in your transfer).
	//
	//   - NONE - None of the SMB security descriptor components are copied.
	//   Destination objects are owned by the user that was provided for accessing the
	//   destination location. DACLs and SACLs are set based on the destination server’s
	//   configuration.
	//
	// [FSx for Windows File Server]: https://docs.aws.amazon.com/datasync/latest/userguide/create-fsx-location.html#create-fsx-windows-location-permissions
	// [Understanding how DataSync handles file and object metadata]: https://docs.aws.amazon.com/datasync/latest/userguide/metadata-copied.html
	// [SMB]: https://docs.aws.amazon.com/datasync/latest/userguide/create-smb-location.html#configuring-smb-permissions
	// [FSx for ONTAP]: https://docs.aws.amazon.com/datasync/latest/userguide/create-ontap-location.html#create-ontap-location-smb
	SecurityDescriptorCopyFlags SmbSecurityDescriptorCopyFlags

	// Specifies whether your transfer tasks should be put into a queue during certain
	// scenarios when [running multiple tasks]. This is ENABLED by default.
	//
	// [running multiple tasks]: https://docs.aws.amazon.com/datasync/latest/userguide/run-task.html#running-multiple-tasks
	TaskQueueing TaskQueueing

	// Specifies whether DataSync transfers only the data (including metadata) that
	// differs between locations following an initial copy or transfers all data every
	// time you run the task. If you're planning on recurring transfers, you might only
	// want to transfer what's changed since your previous task execution.
	//
	//   - CHANGED (default) - After your initial full transfer, DataSync copies only
	//   the data and metadata that differs between the source and destination location.
	//
	//   - ALL - DataSync copies everything in the source to the destination without
	//   comparing differences between the locations.
	TransferMode TransferMode

	// Specifies the POSIX user ID (UID) of the file's owner.
	//
	//   - INT_VALUE (default) - Preserves the integer value of UID and group ID (GID),
	//   which is recommended.
	//
	//   - NONE - Ignores UID and GID.
	//
	// For more information, see [Metadata copied by DataSync].
	//
	// [Metadata copied by DataSync]: https://docs.aws.amazon.com/datasync/latest/userguide/special-files.html#metadata-copied
	Uid Uid

	// Specifies if and how DataSync checks the integrity of your data at the end of
	// your transfer.
	//
	//   - ONLY_FILES_TRANSFERRED (recommended) - DataSync calculates the checksum of
	//   transferred data (including metadata) at the source location. At the end of the
	//   transfer, DataSync then compares this checksum to the checksum calculated on
	//   that data at the destination.
	//
	// This is the default option for [Enhanced mode tasks].
	//
	// We recommend this option when transferring to S3 Glacier Flexible Retrieval or
	//   S3 Glacier Deep Archive storage classes. For more information, see [Storage class considerations with Amazon S3 locations].
	//
	//   - POINT_IN_TIME_CONSISTENT - At the end of the transfer, DataSync checks the
	//   entire source and destination to verify that both locations are fully
	//   synchronized.
	//
	// The is the default option for [Basic mode tasks]and isn't currently supported with Enhanced mode
	//   tasks.
	//
	// If you use a [manifest], DataSync only scans and verifies what's listed in the manifest.
	//
	// You can't use this option when transferring to S3 Glacier Flexible Retrieval or
	//   S3 Glacier Deep Archive storage classes. For more information, see [Storage class considerations with Amazon S3 locations].
	//
	//   - NONE - DataSync performs data integrity checks only during your transfer.
	//   Unlike other options, there's no additional verification at the end of your
	//   transfer.
	//
	// [Storage class considerations with Amazon S3 locations]: https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#using-storage-classes
	// [manifest]: https://docs.aws.amazon.com/datasync/latest/userguide/transferring-with-manifest.html
	// [Enhanced mode tasks]: https://docs.aws.amazon.com/datasync/latest/userguide/choosing-task-mode.html
	// [Basic mode tasks]: https://docs.aws.amazon.com/datasync/latest/userguide/choosing-task-mode.html
	VerifyMode VerifyMode

	noSmithyDocumentSerde
}

// The platform-related details about the DataSync agent, such as the version
// number.
type Platform struct {

	// The version of the DataSync agent.
	Version *string

	noSmithyDocumentSerde
}

// Specifies how your DataSync agent connects to Amazon Web Services using a [virtual private cloud (VPC) service endpoint]. An
// agent that uses a VPC endpoint isn't accessible over the public internet.
//
// [virtual private cloud (VPC) service endpoint]: https://docs.aws.amazon.com/datasync/latest/userguide/choose-service-endpoint.html#choose-service-endpoint-vpc
type PrivateLinkConfig struct {

	// Specifies the VPC endpoint provided by [Amazon Web Services PrivateLink] that your agent connects to.
	//
	// [Amazon Web Services PrivateLink]: https://docs.aws.amazon.com/vpc/latest/privatelink/privatelink-share-your-services.html
	PrivateLinkEndpoint *string

	// Specifies the Amazon Resource Names (ARN) of the security group that provides
	// DataSync access to your VPC endpoint. You can only specify one ARN.
	SecurityGroupArns []string

	// Specifies the ARN of the subnet where your VPC endpoint is located. You can
	// only specify one ARN.
	SubnetArns []string

	// Specifies the ID of the VPC endpoint that your agent connects to.
	VpcEndpointId *string

	noSmithyDocumentSerde
}

// The Quality of Protection (QOP) configuration specifies the Remote Procedure
// Call (RPC) and data transfer privacy settings configured on the Hadoop
// Distributed File System (HDFS) cluster.
type QopConfiguration struct {

	// The data transfer protection setting configured on the HDFS cluster. This
	// setting corresponds to your dfs.data.transfer.protection setting in the
	// hdfs-site.xml file on your Hadoop cluster.
	DataTransferProtection HdfsDataTransferProtection

	// The RPC protection setting configured on the HDFS cluster. This setting
	// corresponds to your hadoop.rpc.protection setting in your core-site.xml file on
	// your Hadoop cluster.
	RpcProtection HdfsRpcProtection

	noSmithyDocumentSerde
}

// Specifies where DataSync uploads your [task report].
//
// [task report]: https://docs.aws.amazon.com/datasync/latest/userguide/task-reports.html
type ReportDestination struct {

	// Specifies the Amazon S3 bucket where DataSync uploads your task report.
	S3 *ReportDestinationS3

	noSmithyDocumentSerde
}

// Specifies the Amazon S3 bucket where DataSync uploads your [task report].
//
// [task report]: https://docs.aws.amazon.com/datasync/latest/userguide/task-reports.html
type ReportDestinationS3 struct {

	// Specifies the Amazon Resource Name (ARN) of the IAM policy that allows DataSync
	// to upload a task report to your S3 bucket. For more information, see [Allowing DataSync to upload a task report to an Amazon S3 bucket].
	//
	// [Allowing DataSync to upload a task report to an Amazon S3 bucket]: https://docs.aws.amazon.com/datasync/latest/userguide/task-reports.html
	//
	// This member is required.
	BucketAccessRoleArn *string

	// Specifies the ARN of the S3 bucket where DataSync uploads your report.
	//
	// This member is required.
	S3BucketArn *string

	// Specifies a bucket prefix for your report.
	Subdirectory *string

	noSmithyDocumentSerde
}

// Specifies the level of detail for a particular aspect of your DataSync [task report].
//
// [task report]: https://docs.aws.amazon.com/datasync/latest/userguide/task-reports.html
type ReportOverride struct {

	// Specifies whether your task report includes errors only or successes and errors.
	//
	// For example, your report might mostly include only what didn't go well in your
	// transfer ( ERRORS_ONLY ). At the same time, you want to verify that your [task filter] is
	// working correctly. In this situation, you can get a list of what files DataSync
	// successfully skipped and if something transferred that you didn't to transfer (
	// SUCCESSES_AND_ERRORS ).
	//
	// [task filter]: https://docs.aws.amazon.com/datasync/latest/userguide/filtering.html
	ReportLevel ReportLevel

	noSmithyDocumentSerde
}

// The level of detail included in each aspect of your DataSync [task report].
//
// [task report]: https://docs.aws.amazon.com/datasync/latest/userguide/task-reports.html
type ReportOverrides struct {

	// Specifies the level of reporting for the files, objects, and directories that
	// DataSync attempted to delete in your destination location. This only applies if
	// you [configure your task]to delete data in the destination that isn't in the source.
	//
	// [configure your task]: https://docs.aws.amazon.com/datasync/latest/userguide/configure-metadata.html
	Deleted *ReportOverride

	// Specifies the level of reporting for the files, objects, and directories that
	// DataSync attempted to skip during your transfer.
	Skipped *ReportOverride

	// Specifies the level of reporting for the files, objects, and directories that
	// DataSync attempted to transfer.
	Transferred *ReportOverride

	// Specifies the level of reporting for the files, objects, and directories that
	// DataSync attempted to verify at the end of your transfer.
	Verified *ReportOverride

	noSmithyDocumentSerde
}

// Indicates whether DataSync created a complete [task report] for your transfer.
//
// [task report]: https://docs.aws.amazon.com/datasync/latest/userguide/task-reports.html
type ReportResult struct {

	// Indicates the code associated with the error if DataSync can't create a
	// complete report.
	ErrorCode *string

	// Provides details about issues creating a report.
	ErrorDetail *string

	// Indicates whether DataSync is still working on your report, created a report,
	// or can't create a complete report.
	Status PhaseStatus

	noSmithyDocumentSerde
}

// Specifies the Amazon Resource Name (ARN) of the Identity and Access Management
// (IAM) role that DataSync uses to access your S3 bucket.
//
// For more information, see [Providing DataSync access to S3 buckets].
//
// [Providing DataSync access to S3 buckets]: https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#create-s3-location-access
type S3Config struct {

	// Specifies the ARN of the IAM role that DataSync uses to access your S3 bucket.
	//
	// This member is required.
	BucketAccessRoleArn *string

	noSmithyDocumentSerde
}

// Specifies the S3 bucket where you're hosting the manifest that you want
// DataSync to use. For more information and configuration examples, see [Specifying what DataSync transfers by using a manifest].
//
// [Specifying what DataSync transfers by using a manifest]: https://docs.aws.amazon.com/datasync/latest/userguide/transferring-with-manifest.html
type S3ManifestConfig struct {

	// Specifies the Identity and Access Management (IAM) role that allows DataSync to
	// access your manifest. For more information, see [Providing DataSync access to your manifest].
	//
	// [Providing DataSync access to your manifest]: https://docs.aws.amazon.com/datasync/latest/userguide/transferring-with-manifest.html#transferring-with-manifest-access
	//
	// This member is required.
	BucketAccessRoleArn *string

	// Specifies the Amazon S3 object key of your manifest. This can include a prefix
	// (for example, prefix/my-manifest.csv ).
	//
	// This member is required.
	ManifestObjectPath *string

	// Specifies the Amazon Resource Name (ARN) of the S3 bucket where you're hosting
	// your manifest.
	//
	// This member is required.
	S3BucketArn *string

	// Specifies the object version ID of the manifest that you want DataSync to use.
	// If you don't set this, DataSync uses the latest version of the object.
	ManifestObjectVersionId *string

	noSmithyDocumentSerde
}

// Specifies the version of the Server Message Block (SMB) protocol that DataSync
// uses to access an SMB file server.
type SmbMountOptions struct {

	// By default, DataSync automatically chooses an SMB protocol version based on
	// negotiation with your SMB file server. You also can configure DataSync to use a
	// specific SMB version, but we recommend doing this only if DataSync has trouble
	// negotiating with the SMB file server automatically.
	//
	// These are the following options for configuring the SMB version:
	//
	//   - AUTOMATIC (default): DataSync and the SMB file server negotiate the highest
	//   version of SMB that they mutually support between 2.1 and 3.1.1.
	//
	// This is the recommended option. If you instead choose a specific version that
	//   your file server doesn't support, you may get an Operation Not Supported error.
	//
	//   - SMB3 : Restricts the protocol negotiation to only SMB version 3.0.2.
	//
	//   - SMB2 : Restricts the protocol negotiation to only SMB version 2.1.
	//
	//   - SMB2_0 : Restricts the protocol negotiation to only SMB version 2.0.
	//
	//   - SMB1 : Restricts the protocol negotiation to only SMB version 1.0.
	//
	// The SMB1 option isn't available when [creating an Amazon FSx for NetApp ONTAP location].
	//
	// [creating an Amazon FSx for NetApp ONTAP location]: https://docs.aws.amazon.com/datasync/latest/userguide/API_CreateLocationFsxOntap.html
	Version SmbVersion

	noSmithyDocumentSerde
}

// Specifies the manifest that you want DataSync to use and where it's hosted. For
// more information and configuration examples, see [Specifying what DataSync transfers by using a manifest].
//
// [Specifying what DataSync transfers by using a manifest]: https://docs.aws.amazon.com/datasync/latest/userguide/transferring-with-manifest.html
type SourceManifestConfig struct {

	// Specifies the S3 bucket where you're hosting your manifest.
	//
	// This member is required.
	S3 *S3ManifestConfig

	noSmithyDocumentSerde
}

// A key-value pair representing a single tag that's been applied to an Amazon Web
// Services resource.
type TagListEntry struct {

	// The key for an Amazon Web Services resource tag.
	//
	// This member is required.
	Key *string

	// The value for an Amazon Web Services resource tag.
	Value *string

	noSmithyDocumentSerde
}

// The number of objects that DataSync fails to prepare, transfer, verify, and
// delete during your task execution.
//
// Applies only to [Enhanced mode tasks].
//
// [Enhanced mode tasks]: https://docs.aws.amazon.com/datasync/latest/userguide/choosing-task-mode.html
type TaskExecutionFilesFailedDetail struct {

	// The number of objects that DataSync fails to delete during your task execution.
	Delete int64

	// The number of objects that DataSync fails to prepare during your task execution.
	Prepare int64

	// The number of objects that DataSync fails to transfer during your task
	// execution.
	Transfer int64

	// The number of objects that DataSync fails to verify during your task execution.
	Verify int64

	noSmithyDocumentSerde
}

// The number of objects that DataSync finds at your locations.
//
// Applies only to [Enhanced mode tasks].
//
// [Enhanced mode tasks]: https://docs.aws.amazon.com/datasync/latest/userguide/choosing-task-mode.html
type TaskExecutionFilesListedDetail struct {

	// The number of objects that DataSync finds at your destination location. This
	// counter is only applicable if you [configure your task]to delete data in the destination that isn't
	// in the source.
	//
	// [configure your task]: https://docs.aws.amazon.com/datasync/latest/userguide/configure-metadata.html#task-option-file-object-handling
	AtDestinationForDelete int64

	// The number of objects that DataSync finds at your source location.
	//
	//   - With a [manifest], DataSync lists only what's in your manifest (and not everything at
	//   your source location).
	//
	//   - With an include [filter], DataSync lists only what matches the filter at your
	//   source location.
	//
	//   - With an exclude filter, DataSync lists everything at your source location
	//   before applying the filter.
	//
	// [filter]: https://docs.aws.amazon.com/datasync/latest/userguide/filtering.html
	// [manifest]: https://docs.aws.amazon.com/datasync/latest/userguide/transferring-with-manifest.html
	AtSource int64

	noSmithyDocumentSerde
}

// Represents a single entry in a list of DataSync task executions that's returned
// with the [ListTaskExecutions]operation.
//
// [ListTaskExecutions]: https://docs.aws.amazon.com/datasync/latest/userguide/API_ListTaskExecutions.html
type TaskExecutionListEntry struct {

	// The status of a task execution. For more information, see [Task execution statuses].
	//
	// [Task execution statuses]: https://docs.aws.amazon.com/datasync/latest/userguide/understand-task-statuses.html#understand-task-execution-statuses
	Status TaskExecutionStatus

	// The Amazon Resource Name (ARN) of a task execution.
	TaskExecutionArn *string

	// The task mode that you're using. For more information, see [Choosing a task mode for your data transfer].
	//
	// [Choosing a task mode for your data transfer]: https://docs.aws.amazon.com/datasync/latest/userguide/choosing-task-mode.html
	TaskMode TaskMode

	noSmithyDocumentSerde
}

// Provides detailed information about the result of your DataSync task execution.
type TaskExecutionResultDetail struct {

	// An error that DataSync encountered during your task execution. You can use this
	// information to help [troubleshoot issues].
	//
	// [troubleshoot issues]: https://docs.aws.amazon.com/datasync/latest/userguide/troubleshooting-datasync-locations-tasks.html
	ErrorCode *string

	// The detailed description of an error that DataSync encountered during your task
	// execution. You can use this information to help [troubleshoot issues].
	//
	// [troubleshoot issues]: https://docs.aws.amazon.com/datasync/latest/userguide/troubleshooting-datasync-locations-tasks.html
	ErrorDetail *string

	// The time in milliseconds that your task execution was in the PREPARING step.
	// For more information, see [Task execution statuses].
	//
	// For Enhanced mode tasks, the value is always 0 . For more information, see [How DataSync prepares your data transfer].
	//
	// [Task execution statuses]: https://docs.aws.amazon.com/datasync/latest/userguide/run-task.html#understand-task-execution-statuses
	// [How DataSync prepares your data transfer]: https://docs.aws.amazon.com/datasync/latest/userguide/how-datasync-transfer-works.html#how-datasync-prepares
	PrepareDuration *int64

	// The status of the PREPARING step for your task execution. For more information,
	// see [Task execution statuses].
	//
	// [Task execution statuses]: https://docs.aws.amazon.com/datasync/latest/userguide/run-task.html#understand-task-execution-statuses
	PrepareStatus PhaseStatus

	// The time in milliseconds that your task execution ran.
	TotalDuration *int64

	// The time in milliseconds that your task execution was in the TRANSFERRING step.
	// For more information, see [Task execution statuses].
	//
	// For Enhanced mode tasks, the value is always 0 . For more information, see [How DataSync transfers your data].
	//
	// [Task execution statuses]: https://docs.aws.amazon.com/datasync/latest/userguide/run-task.html#understand-task-execution-statuses
	// [How DataSync transfers your data]: https://docs.aws.amazon.com/datasync/latest/userguide/how-datasync-transfer-works.html#how-datasync-transfers
	TransferDuration *int64

	// The status of the TRANSFERRING step for your task execution. For more
	// information, see [Task execution statuses].
	//
	// [Task execution statuses]: https://docs.aws.amazon.com/datasync/latest/userguide/run-task.html#understand-task-execution-statuses
	TransferStatus PhaseStatus

	// The time in milliseconds that your task execution was in the VERIFYING step.
	// For more information, see [Task execution statuses].
	//
	// For Enhanced mode tasks, the value is always 0 . For more information, see [How DataSync verifies your data's integrity].
	//
	// [Task execution statuses]: https://docs.aws.amazon.com/datasync/latest/userguide/run-task.html#understand-task-execution-statuses
	// [How DataSync verifies your data's integrity]: https://docs.aws.amazon.com/datasync/latest/userguide/how-datasync-transfer-works.html#how-verifying-works
	VerifyDuration *int64

	// The status of the VERIFYING step for your task execution. For more information,
	// see [Task execution statuses].
	//
	// [Task execution statuses]: https://docs.aws.amazon.com/datasync/latest/userguide/run-task.html#understand-task-execution-statuses
	VerifyStatus PhaseStatus

	noSmithyDocumentSerde
}

// You can use API filters to narrow down the list of resources returned by
// ListTasks . For example, to retrieve all tasks on a source location, you can use
// ListTasks with filter name LocationId and Operator Equals with the ARN for the
// location.
//
// For more information, see [filtering DataSync resources].
//
// [filtering DataSync resources]: https://docs.aws.amazon.com/datasync/latest/userguide/query-resources.html
type TaskFilter struct {

	// The name of the filter being used. Each API call supports a list of filters
	// that are available for it. For example, LocationId for ListTasks .
	//
	// This member is required.
	Name TaskFilterName

	// The operator that is used to compare filter values (for example, Equals or
	// Contains ).
	//
	// This member is required.
	Operator Operator

	// The values that you want to filter for. For example, you might want to display
	// only tasks for a specific destination location.
	//
	// This member is required.
	Values []string

	noSmithyDocumentSerde
}

// Represents a single entry in a list of tasks. TaskListEntry returns an array
// that contains a list of tasks when the [ListTasks]operation is called. A task includes the
// source and destination file systems to sync and the options to use for the
// tasks.
//
// [ListTasks]: https://docs.aws.amazon.com/datasync/latest/userguide/API_ListTasks.html
type TaskListEntry struct {

	// The name of the task.
	Name *string

	// The status of the task.
	Status TaskStatus

	// The Amazon Resource Name (ARN) of the task.
	TaskArn *string

	// The task mode that you're using. For more information, see [Choosing a task mode for your data transfer].
	//
	// [Choosing a task mode for your data transfer]: https://docs.aws.amazon.com/datasync/latest/userguide/choosing-task-mode.html
	TaskMode TaskMode

	noSmithyDocumentSerde
}

// Specifies how you want to configure a task report, which provides detailed
// information about for your DataSync transfer.
//
// For more information, see [Task reports].
//
// [Task reports]: https://docs.aws.amazon.com/datasync/latest/userguide/task-reports.html
type TaskReportConfig struct {

	// Specifies the Amazon S3 bucket where DataSync uploads your task report. For
	// more information, see [Task reports].
	//
	// [Task reports]: https://docs.aws.amazon.com/datasync/latest/userguide/task-reports.html#task-report-access
	Destination *ReportDestination

	// Specifies whether your task report includes the new version of each object
	// transferred into an S3 bucket. This only applies if you [enable versioning on your bucket]. Keep in mind that
	// setting this to INCLUDE can increase the duration of your task execution.
	//
	// [enable versioning on your bucket]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/manage-versioning-examples.html
	ObjectVersionIds ObjectVersionIds

	// Specifies the type of task report that you want:
	//
	//   - SUMMARY_ONLY : Provides necessary details about your task, including the
	//   number of files, objects, and directories transferred and transfer duration.
	//
	//   - STANDARD : Provides complete details about your task, including a full list
	//   of files, objects, and directories that were transferred, skipped, verified, and
	//   more.
	OutputType ReportOutputType

	// Customizes the reporting level for aspects of your task report. For example,
	// your report might generally only include errors, but you could specify that you
	// want a list of successes and errors just for the files that DataSync attempted
	// to delete in your destination location.
	Overrides *ReportOverrides

	// Specifies whether you want your task report to include only what went wrong
	// with your transfer or a list of what succeeded and didn't.
	//
	//   - ERRORS_ONLY : A report shows what DataSync was unable to transfer, skip,
	//   verify, and delete.
	//
	//   - SUCCESSES_AND_ERRORS : A report shows what DataSync was able and unable to
	//   transfer, skip, verify, and delete.
	ReportLevel ReportLevel

	noSmithyDocumentSerde
}

// Configures your DataSync task to run on a [schedule] (at a minimum interval of 1 hour).
//
// [schedule]: https://docs.aws.amazon.com/datasync/latest/userguide/task-scheduling.html
type TaskSchedule struct {

	// Specifies your task schedule by using a cron or rate expression.
	//
	// Use cron expressions for task schedules that run on a specific time and day.
	// For example, the following cron expression creates a task schedule that runs at
	// 8 AM on the first Wednesday of every month:
	//
	//     cron(0 8 * * 3#1)
	//
	// Use rate expressions for task schedules that run on a regular interval. For
	// example, the following rate expression creates a task schedule that runs every
	// 12 hours:
	//
	//     rate(12 hours)
	//
	// For information about cron and rate expression syntax, see the [Amazon EventBridge User Guide].
	//
	// [Amazon EventBridge User Guide]: https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-scheduled-rule-pattern.html
	//
	// This member is required.
	ScheduleExpression *string

	// Specifies whether to enable or disable your task schedule. Your schedule is
	// enabled by default, but there can be situations where you need to disable it.
	// For example, you might need to pause a recurring transfer to fix an issue with
	// your task or perform maintenance on your storage system.
	//
	// DataSync might disable your schedule automatically if your task fails
	// repeatedly with the same error. For more information, see [TaskScheduleDetails].
	//
	// [TaskScheduleDetails]: https://docs.aws.amazon.com/datasync/latest/userguide/API_TaskScheduleDetails.html
	Status ScheduleStatus

	noSmithyDocumentSerde
}

// Provides information about your DataSync [task schedule].
//
// [task schedule]: https://docs.aws.amazon.com/datasync/latest/userguide/task-scheduling.html
type TaskScheduleDetails struct {

	// Indicates how your task schedule was disabled.
	//
	//   - USER - Your schedule was manually disabled by using the [UpdateTask]operation or
	//   DataSync console.
	//
	//   - SERVICE - Your schedule was automatically disabled by DataSync because the
	//   task failed repeatedly with the same error.
	//
	// [UpdateTask]: https://docs.aws.amazon.com/datasync/latest/userguide/API_UpdateTask.html
	DisabledBy ScheduleDisabledBy

	// Provides a reason if the task schedule is disabled.
	//
	// If your schedule is disabled by USER , you see a Manually disabled by user.
	// message.
	//
	// If your schedule is disabled by SERVICE , you see an error message to help you
	// understand why the task keeps failing. For information on resolving DataSync
	// errors, see [Troubleshooting issues with DataSync transfers].
	//
	// [Troubleshooting issues with DataSync transfers]: https://docs.aws.amazon.com/datasync/latest/userguide/troubleshooting-datasync-locations-tasks.html
	DisabledReason *string

	// Indicates the last time the status of your task schedule changed. For example,
	// if DataSync automatically disables your schedule because of a repeated error,
	// you can see when the schedule was disabled.
	StatusUpdateTime *time.Time

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
