// Code generated by smithy-go-codegen DO NOT EDIT.

package bedrockruntime

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/bedrockruntime/document"
	"github.com/aws/aws-sdk-go-v2/service/bedrockruntime/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Sends messages to the specified Amazon Bedrock model. Converse provides a
// consistent interface that works with all models that support messages. This
// allows you to write code once and use it with different models. If a model has
// unique inference parameters, you can also pass those unique parameters to the
// model.
//
// Amazon Bedrock doesn't store any text, images, or documents that you provide as
// content. The data is only used to generate the response.
//
// You can submit a prompt by including it in the messages field, specifying the
// modelId of a foundation model or inference profile to run inference on it, and
// including any other fields that are relevant to your use case.
//
// You can also submit a prompt from Prompt management by specifying the ARN of
// the prompt version and including a map of variables to values in the
// promptVariables field. You can append more messages to the prompt by using the
// messages field. If you use a prompt from Prompt management, you can't include
// the following fields in the request: additionalModelRequestFields ,
// inferenceConfig , system , or toolConfig . Instead, these fields must be defined
// through Prompt management. For more information, see [Use a prompt from Prompt management].
//
// For information about the Converse API, see Use the Converse API in the Amazon
// Bedrock User Guide. To use a guardrail, see Use a guardrail with the Converse
// API in the Amazon Bedrock User Guide. To use a tool with a model, see Tool use
// (Function calling) in the Amazon Bedrock User Guide
//
// For example code, see Converse API examples in the Amazon Bedrock User Guide.
//
// This operation requires permission for the bedrock:InvokeModel action.
//
// To deny all inference access to resources that you specify in the modelId
// field, you need to deny access to the bedrock:InvokeModel and
// bedrock:InvokeModelWithResponseStream actions. Doing this also denies access to
// the resource through the base inference actions ([InvokeModel] and [InvokeModelWithResponseStream]). For more information
// see [Deny access for inference on specific models].
//
// For troubleshooting some of the common errors you might encounter when using
// the Converse API, see [Troubleshooting Amazon Bedrock API Error Codes] in the Amazon Bedrock User Guide
//
// [InvokeModelWithResponseStream]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_InvokeModelWithResponseStream.html
// [Troubleshooting Amazon Bedrock API Error Codes]: https://docs.aws.amazon.com/bedrock/latest/userguide/troubleshooting-api-error-codes.html
// [Deny access for inference on specific models]: https://docs.aws.amazon.com/bedrock/latest/userguide/security_iam_id-based-policy-examples.html#security_iam_id-based-policy-examples-deny-inference
// [InvokeModel]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_InvokeModel.html
// [Use a prompt from Prompt management]: https://docs.aws.amazon.com/bedrock/latest/userguide/prompt-management-use.html
func (c *Client) Converse(ctx context.Context, params *ConverseInput, optFns ...func(*Options)) (*ConverseOutput, error) {
	if params == nil {
		params = &ConverseInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "Converse", params, optFns, c.addOperationConverseMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ConverseOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ConverseInput struct {

	// Specifies the model or throughput with which to run inference, or the prompt
	// resource to use in inference. The value depends on the resource that you use:
	//
	//   - If you use a base model, specify the model ID or its ARN. For a list of
	//   model IDs for base models, see [Amazon Bedrock base model IDs (on-demand throughput)]in the Amazon Bedrock User Guide.
	//
	//   - If you use an inference profile, specify the inference profile ID or its
	//   ARN. For a list of inference profile IDs, see [Supported Regions and models for cross-region inference]in the Amazon Bedrock User
	//   Guide.
	//
	//   - If you use a provisioned model, specify the ARN of the Provisioned
	//   Throughput. For more information, see [Run inference using a Provisioned Throughput]in the Amazon Bedrock User Guide.
	//
	//   - If you use a custom model, first purchase Provisioned Throughput for it.
	//   Then specify the ARN of the resulting provisioned model. For more information,
	//   see [Use a custom model in Amazon Bedrock]in the Amazon Bedrock User Guide.
	//
	//   - To include a prompt that was defined in [Prompt management], specify the ARN of the prompt
	//   version to use.
	//
	// The Converse API doesn't support [imported models].
	//
	// [Run inference using a Provisioned Throughput]: https://docs.aws.amazon.com/bedrock/latest/userguide/prov-thru-use.html
	// [Use a custom model in Amazon Bedrock]: https://docs.aws.amazon.com/bedrock/latest/userguide/model-customization-use.html
	// [Prompt management]: https://docs.aws.amazon.com/bedrock/latest/userguide/prompt-management.html
	// [Supported Regions and models for cross-region inference]: https://docs.aws.amazon.com/bedrock/latest/userguide/cross-region-inference-support.html
	// [imported models]: https://docs.aws.amazon.com/bedrock/latest/userguide/model-customization-import-model.html
	// [Amazon Bedrock base model IDs (on-demand throughput)]: https://docs.aws.amazon.com/bedrock/latest/userguide/model-ids.html#model-ids-arns
	//
	// This member is required.
	ModelId *string

	// Additional inference parameters that the model supports, beyond the base set of
	// inference parameters that Converse and ConverseStream support in the
	// inferenceConfig field. For more information, see [Model parameters].
	//
	// [Model parameters]: https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html
	AdditionalModelRequestFields document.Interface

	// Additional model parameters field paths to return in the response. Converse and
	// ConverseStream return the requested fields as a JSON Pointer object in the
	// additionalModelResponseFields field. The following is example JSON for
	// additionalModelResponseFieldPaths .
	//
	//     [ "/stop_sequence" ]
	//
	// For information about the JSON Pointer syntax, see the [Internet Engineering Task Force (IETF)] documentation.
	//
	// Converse and ConverseStream reject an empty JSON Pointer or incorrectly
	// structured JSON Pointer with a 400 error code. if the JSON Pointer is valid,
	// but the requested field is not in the model response, it is ignored by Converse .
	//
	// [Internet Engineering Task Force (IETF)]: https://datatracker.ietf.org/doc/html/rfc6901
	AdditionalModelResponseFieldPaths []string

	// Configuration information for a guardrail that you want to use in the request.
	// If you include guardContent blocks in the content field in the messages field,
	// the guardrail operates only on those messages. If you include no guardContent
	// blocks, the guardrail operates on all messages in the request body and in any
	// included prompt resource.
	GuardrailConfig *types.GuardrailConfiguration

	// Inference parameters to pass to the model. Converse and ConverseStream support
	// a base set of inference parameters. If you need to pass additional parameters
	// that the model supports, use the additionalModelRequestFields request field.
	InferenceConfig *types.InferenceConfiguration

	// The messages that you want to send to the model.
	Messages []types.Message

	// Model performance settings for the request.
	PerformanceConfig *types.PerformanceConfiguration

	// Contains a map of variables in a prompt from Prompt management to objects
	// containing the values to fill in for them when running model invocation. This
	// field is ignored if you don't specify a prompt resource in the modelId field.
	PromptVariables map[string]types.PromptVariableValues

	// Key-value pairs that you can use to filter invocation logs.
	RequestMetadata map[string]string

	// A prompt that provides instructions or context to the model about the task it
	// should perform, or the persona it should adopt during the conversation.
	System []types.SystemContentBlock

	// Configuration information for the tools that the model can use when generating
	// a response.
	//
	// For information about models that support tool use, see [Supported models and model features].
	//
	// [Supported models and model features]: https://docs.aws.amazon.com/bedrock/latest/userguide/conversation-inference.html#conversation-inference-supported-models-features
	ToolConfig *types.ToolConfiguration

	noSmithyDocumentSerde
}

type ConverseOutput struct {

	// Metrics for the call to Converse .
	//
	// This member is required.
	Metrics *types.ConverseMetrics

	// The result from the call to Converse .
	//
	// This member is required.
	Output types.ConverseOutput

	// The reason why the model stopped generating output.
	//
	// This member is required.
	StopReason types.StopReason

	// The total number of tokens used in the call to Converse . The total includes the
	// tokens input to the model and the tokens generated by the model.
	//
	// This member is required.
	Usage *types.TokenUsage

	// Additional fields in the response that are unique to the model.
	AdditionalModelResponseFields document.Interface

	// Model performance settings for the request.
	PerformanceConfig *types.PerformanceConfiguration

	// A trace object that contains information about the Guardrail behavior.
	Trace *types.ConverseTrace

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationConverseMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpConverse{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpConverse{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "Converse"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpConverseValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opConverse(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opConverse(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "Converse",
	}
}
