// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
)

// Describes a filter that returns a more specific list of recommended actions.
type ActionFilter struct {

	// The category to filter on. Valid values are FEATURE for feature type, SEVERITY
	// for severity level, and TYPE for recommendation type.
	//
	// This member is required.
	Key FilterName

	// Specifies how to apply the filter. Use EQUALS to include matching results or
	// NOT_EQUALS to exclude matching results.
	//
	// This member is required.
	MatchOption MatchOption

	// One or more values to match against the specified key.
	//
	// This member is required.
	Values []string

	noSmithyDocumentSerde
}

// Describes a specific recommended action.
type RecommendedAction struct {

	// The account that the recommended action is for.
	AccountId *string

	// Context that applies to the recommended action.
	Context map[string]string

	// The feature associated with the recommended action.
	Feature Feature

	// The ID for the recommended action.
	Id *string

	// The time when the recommended action status was last updated.
	LastUpdatedTimeStamp *string

	// The possible next steps to execute the recommended action.
	NextSteps []string

	// The severity associated with the recommended action.
	Severity Severity

	// The type of action you can take by adopting the recommended action.
	Type ActionType

	noSmithyDocumentSerde
}

// Enables filtering of results based on specified action criteria. You can define
// multiple action filters to refine results using combinations of feature type,
// severity level, and recommendation type.
type RequestFilter struct {

	// A list of action filters that define criteria for filtering results. Each
	// filter specifies a key, match option, and corresponding values to filter on.
	Actions []ActionFilter

	noSmithyDocumentSerde
}

// Provides specific details about why a particular field failed validation.
type ValidationExceptionField struct {

	// Provides a message explaining why the field failed validation.
	//
	// This member is required.
	Message *string

	// Provides the name of the field that failed validation.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
