// Code generated by smithy-go-codegen DO NOT EDIT.

package workmail

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

//	Requests details of a specific Personal Access Token within the WorkMail
//
// organization.
func (c *Client) GetPersonalAccessTokenMetadata(ctx context.Context, params *GetPersonalAccessTokenMetadataInput, optFns ...func(*Options)) (*GetPersonalAccessTokenMetadataOutput, error) {
	if params == nil {
		params = &GetPersonalAccessTokenMetadataInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetPersonalAccessTokenMetadata", params, optFns, c.addOperationGetPersonalAccessTokenMetadataMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetPersonalAccessTokenMetadataOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetPersonalAccessTokenMetadataInput struct {

	//  The Organization ID.
	//
	// This member is required.
	OrganizationId *string

	//  The Personal Access Token ID.
	//
	// This member is required.
	PersonalAccessTokenId *string

	noSmithyDocumentSerde
}

type GetPersonalAccessTokenMetadataOutput struct {

	//  The date when the Personal Access Token ID was created.
	DateCreated *time.Time

	//  The date when the Personal Access Token ID was last used.
	DateLastUsed *time.Time

	//  The time when the Personal Access Token ID will expire.
	ExpiresTime *time.Time

	//  The Personal Access Token name.
	Name *string

	//  The Personal Access Token ID.
	PersonalAccessTokenId *string

	//  Lists all the Personal Access Token permissions for a mailbox.
	Scopes []string

	//  The WorkMail User ID.
	UserId *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetPersonalAccessTokenMetadataMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpGetPersonalAccessTokenMetadata{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpGetPersonalAccessTokenMetadata{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetPersonalAccessTokenMetadata"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetPersonalAccessTokenMetadataValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetPersonalAccessTokenMetadata(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetPersonalAccessTokenMetadata(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetPersonalAccessTokenMetadata",
	}
}
