// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// A structure that contains the configuration for canary artifacts, including the
// encryption-at-rest settings for artifacts that the canary uploads to Amazon S3.
type ArtifactConfigInput struct {

	// A structure that contains the configuration of the encryption-at-rest settings
	// for artifacts that the canary uploads to Amazon S3. Artifact encryption
	// functionality is available only for canaries that use Synthetics runtime version
	// syn-nodejs-puppeteer-3.3 or later. For more information, see [Encrypting canary artifacts]
	//
	// [Encrypting canary artifacts]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_artifact_encryption.html
	S3Encryption *S3EncryptionConfig

	noSmithyDocumentSerde
}

// A structure that contains the configuration for canary artifacts, including the
// encryption-at-rest settings for artifacts that the canary uploads to Amazon S3.
type ArtifactConfigOutput struct {

	// A structure that contains the configuration of encryption settings for canary
	// artifacts that are stored in Amazon S3.
	S3Encryption *S3EncryptionConfig

	noSmithyDocumentSerde
}

// A structure representing a screenshot that is used as a baseline during visual
// monitoring comparisons made by the canary.
type BaseScreenshot struct {

	// The name of the screenshot. This is generated the first time the canary is run
	// after the UpdateCanary operation that specified for this canary to perform
	// visual monitoring.
	//
	// This member is required.
	ScreenshotName *string

	// Coordinates that define the part of a screen to ignore during screenshot
	// comparisons. To obtain the coordinates to use here, use the CloudWatch console
	// to draw the boundaries on the screen. For more information, see [Editing or deleting a canary]
	//
	// [Editing or deleting a canary]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/synthetics_canaries_deletion.html
	IgnoreCoordinates []string

	noSmithyDocumentSerde
}

// This structure contains all information about one canary in your account.
type Canary struct {

	// A structure that contains the configuration for canary artifacts, including the
	// encryption-at-rest settings for artifacts that the canary uploads to Amazon S3.
	ArtifactConfig *ArtifactConfigOutput

	// The location in Amazon S3 where Synthetics stores artifacts from the runs of
	// this canary. Artifacts include the log file, screenshots, and HAR files.
	ArtifactS3Location *string

	// This structure contains information about the canary's Lambda handler and where
	// its code is stored by CloudWatch Synthetics.
	Code *CanaryCodeOutput

	// Returns the dry run configurations for a canary.
	DryRunConfig *DryRunConfigOutput

	// The ARN of the Lambda function that is used as your canary's engine. For more
	// information about Lambda ARN format, see [Resources and Conditions for Lambda Actions].
	//
	// [Resources and Conditions for Lambda Actions]: https://docs.aws.amazon.com/lambda/latest/dg/lambda-api-permissions-ref.html
	EngineArn *string

	// The ARN of the IAM role used to run the canary. This role must include
	// lambda.amazonaws.com as a principal in the trust policy.
	ExecutionRoleArn *string

	// The number of days to retain data about failed runs of this canary.
	//
	// This setting affects the range of information returned by [GetCanaryRuns], as well as the
	// range of information displayed in the Synthetics console.
	//
	// [GetCanaryRuns]: https://docs.aws.amazon.com/AmazonSynthetics/latest/APIReference/API_GetCanaryRuns.html
	FailureRetentionPeriodInDays *int32

	// The unique ID of this canary.
	Id *string

	// The name of the canary.
	Name *string

	// Specifies whether to also delete the Lambda functions and layers used by this
	// canary when the canary is deleted. If it is AUTOMATIC , the Lambda functions and
	// layers will be deleted when the canary is deleted.
	//
	// If the value of this parameter is OFF , then the value of the DeleteLambda
	// parameter of the [DeleteCanary]operation determines whether the Lambda functions and layers
	// will be deleted.
	//
	// [DeleteCanary]: https://docs.aws.amazon.com/AmazonSynthetics/latest/APIReference/API_DeleteCanary.html
	ProvisionedResourceCleanup ProvisionedResourceCleanupSetting

	// A structure that contains information about a canary run.
	RunConfig *CanaryRunConfigOutput

	// Specifies the runtime version to use for the canary. For more information about
	// runtime versions, see [Canary Runtime Versions].
	//
	// [Canary Runtime Versions]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Library.html
	RuntimeVersion *string

	// A structure that contains information about how often the canary is to run, and
	// when these runs are to stop.
	Schedule *CanaryScheduleOutput

	// A structure that contains information about the canary's status.
	Status *CanaryStatus

	// The number of days to retain data about successful runs of this canary.
	//
	// This setting affects the range of information returned by [GetCanaryRuns], as well as the
	// range of information displayed in the Synthetics console.
	//
	// [GetCanaryRuns]: https://docs.aws.amazon.com/AmazonSynthetics/latest/APIReference/API_GetCanaryRuns.html
	SuccessRetentionPeriodInDays *int32

	// The list of key-value pairs that are associated with the canary.
	Tags map[string]string

	// A structure that contains information about when the canary was created,
	// modified, and most recently run.
	Timeline *CanaryTimeline

	// If this canary performs visual monitoring by comparing screenshots, this
	// structure contains the ID of the canary run to use as the baseline for
	// screenshots, and the coordinates of any parts of the screen to ignore during the
	// visual monitoring comparison.
	VisualReference *VisualReferenceOutput

	// If this canary is to test an endpoint in a VPC, this structure contains
	// information about the subnets and security groups of the VPC endpoint. For more
	// information, see [Running a Canary in a VPC].
	//
	// [Running a Canary in a VPC]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_VPC.html
	VpcConfig *VpcConfigOutput

	noSmithyDocumentSerde
}

// Use this structure to input your script code for the canary. This structure
// contains the Lambda handler with the location where the canary should start
// running the script. If the script is stored in an Amazon S3 bucket, the bucket
// name, key, and version are also included. If the script was passed into the
// canary directly, the script code is contained in the value of Zipfile .
//
// If you are uploading your canary scripts with an Amazon S3 bucket, your zip
// file should include your script in a certain folder structure.
//
//   - For Node.js canaries, the folder structure must be
//     nodejs/node_modules/myCanaryFilename.js For more information, see [Packaging your Node.js canary files]
//
//   - For Python canaries, the folder structure must be
//     python/myCanaryFilename.py or python/myFolder/myCanaryFilename.py For more
//     information, see [Packaging your Python canary files]
//
// [Packaging your Node.js canary files]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_WritingCanary_Nodejs.html#CloudWatch_Synthetics_Canaries_package
// [Packaging your Python canary files]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_WritingCanary_Python.html#CloudWatch_Synthetics_Canaries_WritingCanary_Python_package
type CanaryCodeInput struct {

	// The entry point to use for the source code when running the canary. For
	// canaries that use the syn-python-selenium-1.0 runtime or a syn-nodejs.puppeteer
	// runtime earlier than syn-nodejs.puppeteer-3.4 , the handler must be specified as
	// fileName.handler . For syn-python-selenium-1.1 , syn-nodejs.puppeteer-3.4 , and
	// later runtimes, the handler can be specified as fileName.functionName , or you
	// can specify a folder where canary scripts reside as
	// folder/fileName.functionName .
	//
	// This member is required.
	Handler *string

	// If your canary script is located in Amazon S3, specify the bucket name here. Do
	// not include s3:// as the start of the bucket name.
	S3Bucket *string

	// The Amazon S3 key of your script. For more information, see [Working with Amazon S3 Objects].
	//
	// [Working with Amazon S3 Objects]: https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingObjects.html
	S3Key *string

	// The Amazon S3 version ID of your script.
	S3Version *string

	// If you input your canary script directly into the canary instead of referring
	// to an Amazon S3 location, the value of this parameter is the base64-encoded
	// contents of the .zip file that contains the script. It must be smaller than 225
	// Kb.
	//
	// For large canary scripts, we recommend that you use an Amazon S3 location
	// instead of inputting it directly with this parameter.
	ZipFile []byte

	noSmithyDocumentSerde
}

// This structure contains information about the canary's Lambda handler and where
// its code is stored by CloudWatch Synthetics.
type CanaryCodeOutput struct {

	// The entry point to use for the source code when running the canary.
	Handler *string

	// The ARN of the Lambda layer where Synthetics stores the canary script code.
	SourceLocationArn *string

	noSmithyDocumentSerde
}

// Returns the dry run configurations set for a canary.
type CanaryDryRunConfigOutput struct {

	// The DryRunId associated with an existing canary’s dry run. You can use this
	// DryRunId to retrieve information about the dry run.
	DryRunId *string

	noSmithyDocumentSerde
}

// This structure contains information about the most recent run of a single
// canary.
type CanaryLastRun struct {

	// The name of the canary.
	CanaryName *string

	// The results from this canary's most recent run.
	LastRun *CanaryRun

	noSmithyDocumentSerde
}

// This structure contains the details about one run of one canary.
type CanaryRun struct {

	// The location where the canary stored artifacts from the run. Artifacts include
	// the log file, screenshots, and HAR files.
	ArtifactS3Location *string

	// Returns the dry run configurations for a canary.
	DryRunConfig *CanaryDryRunConfigOutput

	// A unique ID that identifies this canary run.
	Id *string

	// The name of the canary.
	Name *string

	// The count in number of the retry attempt.
	RetryAttempt *int32

	// The ID of the scheduled canary run.
	ScheduledRunId *string

	// The status of this run.
	Status *CanaryRunStatus

	// A structure that contains the start and end times of this run.
	Timeline *CanaryRunTimeline

	noSmithyDocumentSerde
}

// A structure that contains input information for a canary run.
type CanaryRunConfigInput struct {

	// Specifies whether this canary is to use active X-Ray tracing when it runs.
	// Active tracing enables this canary run to be displayed in the ServiceLens and
	// X-Ray service maps even if the canary does not hit an endpoint that has X-Ray
	// tracing enabled. Using X-Ray tracing incurs charges. For more information, see [Canaries and X-Ray tracing].
	//
	// You can enable active tracing only for canaries that use version syn-nodejs-2.0
	// or later for their canary runtime.
	//
	// [Canaries and X-Ray tracing]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_tracing.html
	ActiveTracing *bool

	// Specifies the keys and values to use for any environment variables used in the
	// canary script. Use the following format:
	//
	// { "key1" : "value1", "key2" : "value2", ...}
	//
	// Keys must start with a letter and be at least two characters. The total size of
	// your environment variables cannot exceed 4 KB. You can't specify any Lambda
	// reserved environment variables as the keys for your environment variables. For
	// more information about reserved keys, see [Runtime environment variables].
	//
	// Environment variable keys and values are encrypted at rest using Amazon Web
	// Services owned KMS keys. However, the environment variables are not encrypted on
	// the client side. Do not store sensitive information in them.
	//
	// [Runtime environment variables]: https://docs.aws.amazon.com/lambda/latest/dg/configuration-envvars.html#configuration-envvars-runtime
	EnvironmentVariables map[string]string

	// Specifies the amount of ephemeral storage (in MB) to allocate for the canary
	// run during execution. This temporary storage is used for storing canary run
	// artifacts (which are uploaded to an Amazon S3 bucket at the end of the run), and
	// any canary browser operations. This temporary storage is cleared after the run
	// is completed. Default storage value is 1024 MB.
	EphemeralStorage *int32

	// The maximum amount of memory available to the canary while it is running, in
	// MB. This value must be a multiple of 64.
	MemoryInMB *int32

	// How long the canary is allowed to run before it must stop. You can't set this
	// time to be longer than the frequency of the runs of this canary.
	//
	// If you omit this field, the frequency of the canary is used as this value, up
	// to a maximum of 14 minutes.
	TimeoutInSeconds *int32

	noSmithyDocumentSerde
}

// A structure that contains information about a canary run.
type CanaryRunConfigOutput struct {

	// Displays whether this canary run used active X-Ray tracing.
	ActiveTracing *bool

	// Specifies the amount of ephemeral storage (in MB) to allocate for the canary
	// run during execution. This temporary storage is used for storing canary run
	// artifacts (which are uploaded to an Amazon S3 bucket at the end of the run), and
	// any canary browser operations. This temporary storage is cleared after the run
	// is completed. Default storage value is 1024 MB.
	EphemeralStorage *int32

	// The maximum amount of memory available to the canary while it is running, in
	// MB. This value must be a multiple of 64.
	MemoryInMB *int32

	// How long the canary is allowed to run before it must stop.
	TimeoutInSeconds *int32

	noSmithyDocumentSerde
}

// This structure contains the status information about a canary run.
type CanaryRunStatus struct {

	// The current state of the run.
	State CanaryRunState

	// If run of the canary failed, this field contains the reason for the error.
	StateReason *string

	// If this value is CANARY_FAILURE , either the canary script failed or Synthetics
	// ran into a fatal error when running the canary. For example, a canary timeout
	// misconfiguration setting can cause the canary to timeout before Synthetics can
	// evaluate its status.
	//
	// If this value is EXECUTION_FAILURE , a non-critical failure occurred such as
	// failing to save generated debug artifacts (for example, screenshots or har
	// files).
	//
	// If both types of failures occurred, the CANARY_FAILURE takes precedence. To
	// understand the exact error, use the [StateReason]API.
	//
	// [StateReason]: https://docs.aws.amazon.com/AmazonSynthetics/latest/APIReference/API_CanaryRunStatus.html
	StateReasonCode CanaryRunStateReasonCode

	// Specifies the status of canary script for this run. When Synthetics tries to
	// determine the status but fails, the result is marked as UNKNOWN . For the
	// overall status of canary run, see [State].
	//
	// [State]: https://docs.aws.amazon.com/AmazonSynthetics/latest/APIReference/API_CanaryRunStatus.html
	TestResult CanaryRunTestResult

	noSmithyDocumentSerde
}

// This structure contains the start and end times of a single canary run.
type CanaryRunTimeline struct {

	// The end time of the run.
	Completed *time.Time

	// The time at which the metrics will be generated for this run or retries.
	MetricTimestampForRunAndRetries *time.Time

	// The start time of the run.
	Started *time.Time

	noSmithyDocumentSerde
}

// This structure specifies how often a canary is to make runs and the date and
// time when it should stop making runs.
type CanaryScheduleInput struct {

	// A rate expression or a cron expression that defines how often the canary is to
	// run.
	//
	// For a rate expression, The syntax is rate(number unit) . unit can be minute ,
	// minutes , or hour .
	//
	// For example, rate(1 minute) runs the canary once a minute, rate(10 minutes)
	// runs it once every 10 minutes, and rate(1 hour) runs it once every hour. You
	// can specify a frequency between rate(1 minute) and rate(1 hour) .
	//
	// Specifying rate(0 minute) or rate(0 hour) is a special value that causes the
	// canary to run only once when it is started.
	//
	// Use cron(expression) to specify a cron expression. You can't schedule a canary
	// to wait for more than a year before running. For information about the syntax
	// for cron expressions, see [Scheduling canary runs using cron].
	//
	// [Scheduling canary runs using cron]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_cron.html
	//
	// This member is required.
	Expression *string

	// How long, in seconds, for the canary to continue making regular runs according
	// to the schedule in the Expression value. If you specify 0, the canary continues
	// making runs until you stop it. If you omit this field, the default of 0 is used.
	DurationInSeconds *int64

	// A structure that contains the retry configuration for a canary
	RetryConfig *RetryConfigInput

	noSmithyDocumentSerde
}

// How long, in seconds, for the canary to continue making regular runs according
// to the schedule in the Expression value.
type CanaryScheduleOutput struct {

	// How long, in seconds, for the canary to continue making regular runs after it
	// was created. The runs are performed according to the schedule in the Expression
	// value.
	DurationInSeconds *int64

	// A rate expression or a cron expression that defines how often the canary is to
	// run.
	//
	// For a rate expression, The syntax is rate(number unit) . unit can be minute ,
	// minutes , or hour .
	//
	// For example, rate(1 minute) runs the canary once a minute, rate(10 minutes)
	// runs it once every 10 minutes, and rate(1 hour) runs it once every hour. You
	// can specify a frequency between rate(1 minute) and rate(1 hour) .
	//
	// Specifying rate(0 minute) or rate(0 hour) is a special value that causes the
	// canary to run only once when it is started.
	//
	// Use cron(expression) to specify a cron expression. For information about the
	// syntax for cron expressions, see [Scheduling canary runs using cron].
	//
	// [Scheduling canary runs using cron]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_cron.html
	Expression *string

	// A structure that contains the retry configuration for a canary
	RetryConfig *RetryConfigOutput

	noSmithyDocumentSerde
}

// A structure that contains the current state of the canary.
type CanaryStatus struct {

	// The current state of the canary.
	State CanaryState

	// If the canary creation or update failed, this field provides details on the
	// failure.
	StateReason *string

	// If the canary creation or update failed, this field displays the reason code.
	StateReasonCode CanaryStateReasonCode

	noSmithyDocumentSerde
}

// This structure contains information about when the canary was created and
// modified.
type CanaryTimeline struct {

	// The date and time the canary was created.
	Created *time.Time

	// The date and time the canary was most recently modified.
	LastModified *time.Time

	// The date and time that the canary's most recent run started.
	LastStarted *time.Time

	// The date and time that the canary's most recent run ended.
	LastStopped *time.Time

	noSmithyDocumentSerde
}

// Returns the dry run configurations set for a canary.
type DryRunConfigOutput struct {

	// The DryRunId associated with an existing canary’s dry run. You can use this
	// DryRunId to retrieve information about the dry run.
	DryRunId *string

	// Returns the last execution status for a canary's dry run.
	LastDryRunExecutionStatus *string

	noSmithyDocumentSerde
}

// This structure contains information about one group.
type Group struct {

	// The ARN of the group.
	Arn *string

	// The date and time that the group was created.
	CreatedTime *time.Time

	// The unique ID of the group.
	Id *string

	// The date and time that the group was most recently updated.
	LastModifiedTime *time.Time

	// The name of the group.
	Name *string

	// The list of key-value pairs that are associated with the canary.
	Tags map[string]string

	noSmithyDocumentSerde
}

// A structure containing some information about a group.
type GroupSummary struct {

	// The ARN of the group.
	Arn *string

	// The unique ID of the group.
	Id *string

	// The name of the group.
	Name *string

	noSmithyDocumentSerde
}

// This structure contains information about the canary's retry configuration.
//
// The default account level concurrent execution limit from Lambda is 1000. When
// you have more than 1000 canaries, it's possible there are more than 1000 Lambda
// invocations due to retries and the console might hang. For more information on
// the Lambda execution limit, see [Understanding Lambda function scaling].
//
// For canary with MaxRetries = 2 , you need to set the
// CanaryRunConfigInput.TimeoutInSeconds to less than 600 seconds to avoid
// validation errors.
//
// [Understanding Lambda function scaling]: https://docs.aws.amazon.com/lambda/latest/dg/lambda-concurrency.html#:~:text=As%20your%20functions%20receive%20more,functions%20in%20an%20AWS%20Region
type RetryConfigInput struct {

	// The maximum number of retries. The value must be less than or equal to 2.
	//
	// This member is required.
	MaxRetries *int32

	noSmithyDocumentSerde
}

// This structure contains information about the canary's retry configuration.
type RetryConfigOutput struct {

	// The maximum number of retries. The value must be less than or equal to 2.
	MaxRetries *int32

	noSmithyDocumentSerde
}

// This structure contains information about one canary runtime version. For more
// information about runtime versions, see [Canary Runtime Versions].
//
// [Canary Runtime Versions]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Library.html
type RuntimeVersion struct {

	// If this runtime version is deprecated, this value is the date of deprecation.
	DeprecationDate *time.Time

	// A description of the runtime version, created by Amazon.
	Description *string

	// The date that the runtime version was released.
	ReleaseDate *time.Time

	// The name of the runtime version. For a list of valid runtime versions, see [Canary Runtime Versions].
	//
	// [Canary Runtime Versions]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Library.html
	VersionName *string

	noSmithyDocumentSerde
}

// A structure that contains the configuration of encryption-at-rest settings for
// canary artifacts that the canary uploads to Amazon S3.
//
// For more information, see [Encrypting canary artifacts]
//
// [Encrypting canary artifacts]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_artifact_encryption.html
type S3EncryptionConfig struct {

	//  The encryption method to use for artifacts created by this canary. Specify
	// SSE_S3 to use server-side encryption (SSE) with an Amazon S3-managed key.
	// Specify SSE-KMS to use server-side encryption with a customer-managed KMS key.
	//
	// If you omit this parameter, an Amazon Web Services-managed KMS key is used.
	EncryptionMode EncryptionMode

	// The ARN of the customer-managed KMS key to use, if you specify SSE-KMS for
	// EncryptionMode
	KmsKeyArn *string

	noSmithyDocumentSerde
}

// An object that specifies what screenshots to use as a baseline for visual
// monitoring by this canary. It can optionally also specify parts of the
// screenshots to ignore during the visual monitoring comparison.
//
// Visual monitoring is supported only on canaries running the
// syn-puppeteer-node-3.2 runtime or later. For more information, see [Visual monitoring]and [Visual monitoring blueprint]
//
// [Visual monitoring]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_SyntheticsLogger_VisualTesting.html
// [Visual monitoring blueprint]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Blueprints_VisualTesting.html
type VisualReferenceInput struct {

	// Specifies which canary run to use the screenshots from as the baseline for
	// future visual monitoring with this canary. Valid values are nextrun to use the
	// screenshots from the next run after this update is made, lastrun to use the
	// screenshots from the most recent run before this update was made, or the value
	// of Id in the [CanaryRun] from a run of this a canary in the past 31 days. If you specify
	// the Id of a canary run older than 31 days, the operation returns a 400
	// validation exception error..
	//
	// [CanaryRun]: https://docs.aws.amazon.com/AmazonSynthetics/latest/APIReference/API_CanaryRun.html
	//
	// This member is required.
	BaseCanaryRunId *string

	// An array of screenshots that will be used as the baseline for visual monitoring
	// in future runs of this canary. If there is a screenshot that you don't want to
	// be used for visual monitoring, remove it from this array.
	BaseScreenshots []BaseScreenshot

	noSmithyDocumentSerde
}

// If this canary performs visual monitoring by comparing screenshots, this
// structure contains the ID of the canary run that is used as the baseline for
// screenshots, and the coordinates of any parts of those screenshots that are
// ignored during visual monitoring comparison.
//
// Visual monitoring is supported only on canaries running the
// syn-puppeteer-node-3.2 runtime or later.
type VisualReferenceOutput struct {

	// The ID of the canary run that produced the baseline screenshots that are used
	// for visual monitoring comparisons by this canary.
	BaseCanaryRunId *string

	// An array of screenshots that are used as the baseline for comparisons during
	// visual monitoring.
	BaseScreenshots []BaseScreenshot

	noSmithyDocumentSerde
}

// If this canary is to test an endpoint in a VPC, this structure contains
// information about the subnets and security groups of the VPC endpoint. For more
// information, see [Running a Canary in a VPC].
//
// [Running a Canary in a VPC]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_VPC.html
type VpcConfigInput struct {

	// Set this to true to allow outbound IPv6 traffic on VPC canaries that are
	// connected to dual-stack subnets. The default is false
	Ipv6AllowedForDualStack *bool

	// The IDs of the security groups for this canary.
	SecurityGroupIds []string

	// The IDs of the subnets where this canary is to run.
	SubnetIds []string

	noSmithyDocumentSerde
}

// If this canary is to test an endpoint in a VPC, this structure contains
// information about the subnets and security groups of the VPC endpoint. For more
// information, see [Running a Canary in a VPC].
//
// [Running a Canary in a VPC]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_VPC.html
type VpcConfigOutput struct {

	// Indicates whether this canary allows outbound IPv6 traffic if it is connected
	// to dual-stack subnets.
	Ipv6AllowedForDualStack *bool

	// The IDs of the security groups for this canary.
	SecurityGroupIds []string

	// The IDs of the subnets where this canary is to run.
	SubnetIds []string

	// The IDs of the VPC where this canary is to run.
	VpcId *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
