// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// The definition of a Quick Setup configuration.
type ConfigurationDefinition struct {

	// A list of key-value pairs containing the required parameters for the
	// configuration type.
	//
	// This member is required.
	Parameters map[string]string

	// The type of the Quick Setup configuration.
	//
	// This member is required.
	Type *string

	// The ID of the configuration definition.
	Id *string

	// The ARN of the IAM role used to administrate local configuration deployments.
	LocalDeploymentAdministrationRoleArn *string

	// The name of the IAM role used to deploy local configurations.
	LocalDeploymentExecutionRoleName *string

	// The version of the Quick Setup type used.
	TypeVersion *string

	noSmithyDocumentSerde
}

// Defines the preferences and options for a configuration definition.
type ConfigurationDefinitionInput struct {

	// The parameters for the configuration definition type. Parameters for
	// configuration definitions vary based the configuration type. The following
	// tables outline the parameters for each configuration type.
	//
	// OpsCenter (Type: Amazon Web ServicesQuickSetupType-SSMOpsCenter)
	//   - DelegatedAccountId
	//
	//   - Description: (Required) The ID of the delegated administrator account.
	//
	//   - TargetOrganizationalUnits
	//
	//   - Description: (Required) A comma separated list of organizational units
	//   (OUs) you want to deploy the configuration to.
	//
	//   - TargetRegions
	//
	//   - Description: (Required) A comma separated list of Amazon Web Services
	//   Regions you want to deploy the configuration to.
	//
	// Resource Scheduler (Type: Amazon Web ServicesQuickSetupType-Scheduler)
	//   - TargetTagKey
	//
	//   - Description: (Required) The tag key assigned to the instances you want to
	//   target.
	//
	//   - TargetTagValue
	//
	//   - Description: (Required) The value of the tag key assigned to the instances
	//   you want to target.
	//
	//   - ICalendarString
	//
	//   - Description: (Required) An iCalendar formatted string containing the
	//   schedule you want Change Manager to use.
	//
	//   - TargetAccounts
	//
	//   - Description: (Optional) The ID of the Amazon Web Services account
	//   initiating the configuration deployment. You only need to provide a value for
	//   this parameter if you want to deploy the configuration locally. A value must be
	//   provided for either TargetAccounts or TargetOrganizationalUnits .
	//
	//   - TargetOrganizationalUnits
	//
	//   - Description: (Optional) A comma separated list of organizational units
	//   (OUs) you want to deploy the configuration to.
	//
	//   - TargetRegions
	//
	//   - Description: (Required) A comma separated list of Amazon Web Services
	//   Regions you want to deploy the configuration to.
	//
	// Default Host Management Configuration (Type: Amazon Web
	// ServicesQuickSetupType-DHMC)
	//   - UpdateSSMAgent
	//
	//   - Description: (Optional) A boolean value that determines whether the SSM
	//   Agent is updated on the target instances every 2 weeks. The default value is "
	//   true ".
	//
	//   - TargetOrganizationalUnits
	//
	//   - Description: (Required) A comma separated list of organizational units
	//   (OUs) you want to deploy the configuration to.
	//
	//   - TargetRegions
	//
	//   - Description: (Required) A comma separated list of Amazon Web Services
	//   Regions you want to deploy the configuration to.
	//
	// Resource Explorer (Type: Amazon Web ServicesQuickSetupType-ResourceExplorer)
	//   - SelectedAggregatorRegion
	//
	//   - Description: (Required) The Amazon Web Services Region where you want to
	//   create the aggregator index.
	//
	//   - ReplaceExistingAggregator
	//
	//   - Description: (Required) A boolean value that determines whether to demote
	//   an existing aggregator if it is in a Region that differs from the value you
	//   specify for the SelectedAggregatorRegion .
	//
	//   - TargetOrganizationalUnits
	//
	//   - Description: (Required) A comma separated list of organizational units
	//   (OUs) you want to deploy the configuration to.
	//
	//   - TargetRegions
	//
	//   - Description: (Required) A comma separated list of Amazon Web Services
	//   Regions you want to deploy the configuration to.
	//
	// Change Manager (Type: Amazon Web ServicesQuickSetupType-SSMChangeMgr)
	//   - DelegatedAccountId
	//
	//   - Description: (Required) The ID of the delegated administrator account.
	//
	//   - JobFunction
	//
	//   - Description: (Required) The name for the Change Manager job function.
	//
	//   - PermissionType
	//
	//   - Description: (Optional) Specifies whether you want to use default
	//   administrator permissions for the job function role, or provide a custom IAM
	//   policy. The valid values are CustomPermissions and AdminPermissions . The
	//   default value for the parameter is CustomerPermissions .
	//
	//   - CustomPermissions
	//
	//   - Description: (Optional) A JSON string containing the IAM policy you want
	//   your job function to use. You must provide a value for this parameter if you
	//   specify CustomPermissions for the PermissionType parameter.
	//
	//   - TargetOrganizationalUnits
	//
	//   - Description: (Required) A comma separated list of organizational units
	//   (OUs) you want to deploy the configuration to.
	//
	//   - TargetRegions
	//
	//   - Description: (Required) A comma separated list of Amazon Web Services
	//   Regions you want to deploy the configuration to.
	//
	// DevOps Guru (Type: Amazon Web ServicesQuickSetupType-DevOpsGuru)
	//   - AnalyseAllResources
	//
	//   - Description: (Optional) A boolean value that determines whether DevOps Guru
	//   analyzes all CloudFormation stacks in the account. The default value is " false
	//   ".
	//
	//   - EnableSnsNotifications
	//
	//   - Description: (Optional) A boolean value that determines whether DevOps Guru
	//   sends notifications when an insight is created. The default value is " true ".
	//
	//   - EnableSsmOpsItems
	//
	//   - Description: (Optional) A boolean value that determines whether DevOps Guru
	//   creates an OpsCenter OpsItem when an insight is created. The default value is "
	//   true ".
	//
	//   - EnableDriftRemediation
	//
	//   - Description: (Optional) A boolean value that determines whether a drift
	//   remediation schedule is used. The default value is " false ".
	//
	//   - RemediationSchedule
	//
	//   - Description: (Optional) A rate expression that defines the schedule for
	//   drift remediation. The valid values are rate(30 days) , rate(14 days) ,
	//   rate(1 days) , and none . The default value is " none ".
	//
	//   - TargetAccounts
	//
	//   - Description: (Optional) The ID of the Amazon Web Services account
	//   initiating the configuration deployment. You only need to provide a value for
	//   this parameter if you want to deploy the configuration locally. A value must be
	//   provided for either TargetAccounts or TargetOrganizationalUnits .
	//
	//   - TargetOrganizationalUnits
	//
	//   - Description: (Optional) A comma separated list of organizational units
	//   (OUs) you want to deploy the configuration to.
	//
	//   - TargetRegions
	//
	//   - Description: (Required) A comma separated list of Amazon Web Services
	//   Regions you want to deploy the configuration to.
	//
	// Conformance Packs (Type: Amazon Web ServicesQuickSetupType-CFGCPacks)
	//   - DelegatedAccountId
	//
	//   - Description: (Optional) The ID of the delegated administrator account. This
	//   parameter is required for Organization deployments.
	//
	//   - RemediationSchedule
	//
	//   - Description: (Optional) A rate expression that defines the schedule for
	//   drift remediation. The valid values are rate(30 days) , rate(14 days) ,
	//   rate(2 days) , and none . The default value is " none ".
	//
	//   - CPackNames
	//
	//   - Description: (Required) A comma separated list of Config conformance packs.
	//
	//   - TargetAccounts
	//
	//   - Description: (Optional) The ID of the Amazon Web Services account
	//   initiating the configuration deployment. You only need to provide a value for
	//   this parameter if you want to deploy the configuration locally. A value must be
	//   provided for either TargetAccounts or TargetOrganizationalUnits .
	//
	//   - TargetOrganizationalUnits
	//
	//   - Description: (Optional) The ID of the root of your Organization. This
	//   configuration type doesn't currently support choosing specific OUs. The
	//   configuration will be deployed to all the OUs in the Organization.
	//
	//   - TargetRegions
	//
	//   - Description: (Required) A comma separated list of Amazon Web Services
	//   Regions you want to deploy the configuration to.
	//
	// Config Recording (Type: Amazon Web ServicesQuickSetupType-CFGRecording)
	//   - RecordAllResources
	//
	//   - Description: (Optional) A boolean value that determines whether all
	//   supported resources are recorded. The default value is " true ".
	//
	//   - ResourceTypesToRecord
	//
	//   - Description: (Optional) A comma separated list of resource types you want
	//   to record.
	//
	//   - RecordGlobalResourceTypes
	//
	//   - Description: (Optional) A boolean value that determines whether global
	//   resources are recorded with all resource configurations. The default value is "
	//   false ".
	//
	//   - GlobalResourceTypesRegion
	//
	//   - Description: (Optional) Determines the Amazon Web Services Region where
	//   global resources are recorded.
	//
	//   - UseCustomBucket
	//
	//   - Description: (Optional) A boolean value that determines whether a custom
	//   Amazon S3 bucket is used for delivery. The default value is " false ".
	//
	//   - DeliveryBucketName
	//
	//   - Description: (Optional) The name of the Amazon S3 bucket you want Config to
	//   deliver configuration snapshots and configuration history files to.
	//
	//   - DeliveryBucketPrefix
	//
	//   - Description: (Optional) The key prefix you want to use in the custom Amazon
	//   S3 bucket.
	//
	//   - NotificationOptions
	//
	//   - Description: (Optional) Determines the notification configuration for the
	//   recorder. The valid values are NoStreaming , UseExistingTopic , and
	//   CreateTopic . The default value is NoStreaming .
	//
	//   - CustomDeliveryTopicAccountId
	//
	//   - Description: (Optional) The ID of the Amazon Web Services account where the
	//   Amazon SNS topic you want to use for notifications resides. You must specify a
	//   value for this parameter if you use the UseExistingTopic notification option.
	//
	//   - CustomDeliveryTopicName
	//
	//   - Description: (Optional) The name of the Amazon SNS topic you want to use
	//   for notifications. You must specify a value for this parameter if you use the
	//   UseExistingTopic notification option.
	//
	//   - RemediationSchedule
	//
	//   - Description: (Optional) A rate expression that defines the schedule for
	//   drift remediation. The valid values are rate(30 days) , rate(7 days) , rate(1
	//   days) , and none . The default value is " none ".
	//
	//   - TargetAccounts
	//
	//   - Description: (Optional) The ID of the Amazon Web Services account
	//   initiating the configuration deployment. You only need to provide a value for
	//   this parameter if you want to deploy the configuration locally. A value must be
	//   provided for either TargetAccounts or TargetOrganizationalUnits .
	//
	//   - TargetOrganizationalUnits
	//
	//   - Description: (Optional) The ID of the root of your Organization. This
	//   configuration type doesn't currently support choosing specific OUs. The
	//   configuration will be deployed to all the OUs in the Organization.
	//
	//   - TargetRegions
	//
	//   - Description: (Required) A comma separated list of Amazon Web Services
	//   Regions you want to deploy the configuration to.
	//
	// Host Management (Type: Amazon Web ServicesQuickSetupType-SSMHostMgmt)
	//   - UpdateSSMAgent
	//
	//   - Description: (Optional) A boolean value that determines whether the SSM
	//   Agent is updated on the target instances every 2 weeks. The default value is "
	//   true ".
	//
	//   - UpdateEc2LaunchAgent
	//
	//   - Description: (Optional) A boolean value that determines whether the EC2
	//   Launch agent is updated on the target instances every month. The default value
	//   is " false ".
	//
	//   - CollectInventory
	//
	//   - Description: (Optional) A boolean value that determines whether the EC2
	//   Launch agent is updated on the target instances every month. The default value
	//   is " true ".
	//
	//   - ScanInstances
	//
	//   - Description: (Optional) A boolean value that determines whether the target
	//   instances are scanned daily for available patches. The default value is " true
	//   ".
	//
	//   - InstallCloudWatchAgent
	//
	//   - Description: (Optional) A boolean value that determines whether the Amazon
	//   CloudWatch agent is installed on the target instances. The default value is "
	//   false ".
	//
	//   - UpdateCloudWatchAgent
	//
	//   - Description: (Optional) A boolean value that determines whether the Amazon
	//   CloudWatch agent is updated on the target instances every month. The default
	//   value is " false ".
	//
	//   - IsPolicyAttachAllowed
	//
	//   - Description: (Optional) A boolean value that determines whether Quick Setup
	//   attaches policies to instances profiles already associated with the target
	//   instances. The default value is " false ".
	//
	//   - TargetType
	//
	//   - Description: (Optional) Determines how instances are targeted for local
	//   account deployments. Don't specify a value for this parameter if you're
	//   deploying to OUs. The valid values are * , InstanceIds , ResourceGroups , and
	//   Tags . Use * to target all instances in the account.
	//
	//   - TargetInstances
	//
	//   - Description: (Optional) A comma separated list of instance IDs. You must
	//   provide a value for this parameter if you specify InstanceIds for the
	//   TargetType parameter.
	//
	//   - TargetTagKey
	//
	//   - Description: (Optional) The tag key assigned to the instances you want to
	//   target. You must provide a value for this parameter if you specify Tags for
	//   the TargetType parameter.
	//
	//   - TargetTagValue
	//
	//   - Description: (Optional) The value of the tag key assigned to the instances
	//   you want to target. You must provide a value for this parameter if you specify
	//   Tags for the TargetType parameter.
	//
	//   - ResourceGroupName
	//
	//   - Description: (Optional) The name of the resource group associated with the
	//   instances you want to target. You must provide a value for this parameter if you
	//   specify ResourceGroups for the TargetType parameter.
	//
	//   - TargetAccounts
	//
	//   - Description: (Optional) The ID of the Amazon Web Services account
	//   initiating the configuration deployment. You only need to provide a value for
	//   this parameter if you want to deploy the configuration locally. A value must be
	//   provided for either TargetAccounts or TargetOrganizationalUnits .
	//
	//   - TargetOrganizationalUnits
	//
	//   - Description: (Optional) A comma separated list of organizational units
	//   (OUs) you want to deploy the configuration to.
	//
	//   - TargetRegions
	//
	//   - Description: (Required) A comma separated list of Amazon Web Services
	//   Regions you want to deploy the configuration to.
	//
	// Distributor (Type: Amazon Web ServicesQuickSetupType-Distributor)
	//   - PackagesToInstall
	//
	//   - Description: (Required) A comma separated list of packages you want to
	//   install on the target instances. The valid values are AWSEFSTools , AWSCWAgent
	//   , and AWSEC2LaunchAgent .
	//
	//   - RemediationSchedule
	//
	//   - Description: (Optional) A rate expression that defines the schedule for
	//   drift remediation. The valid values are rate(30 days) , rate(14 days) ,
	//   rate(2 days) , and none . The default value is " rate(30 days) ".
	//
	//   - IsPolicyAttachAllowed
	//
	//   - Description: (Optional) A boolean value that determines whether Quick Setup
	//   attaches policies to instances profiles already associated with the target
	//   instances. The default value is " false ".
	//
	//   - TargetType
	//
	//   - Description: (Optional) Determines how instances are targeted for local
	//   account deployments. Don't specify a value for this parameter if you're
	//   deploying to OUs. The valid values are * , InstanceIds , ResourceGroups , and
	//   Tags . Use * to target all instances in the account.
	//
	//   - TargetInstances
	//
	//   - Description: (Optional) A comma separated list of instance IDs. You must
	//   provide a value for this parameter if you specify InstanceIds for the
	//   TargetType parameter.
	//
	//   - TargetTagKey
	//
	//   - Description: (Required) The tag key assigned to the instances you want to
	//   target. You must provide a value for this parameter if you specify Tags for
	//   the TargetType parameter.
	//
	//   - TargetTagValue
	//
	//   - Description: (Required) The value of the tag key assigned to the instances
	//   you want to target. You must provide a value for this parameter if you specify
	//   Tags for the TargetType parameter.
	//
	//   - ResourceGroupName
	//
	//   - Description: (Required) The name of the resource group associated with the
	//   instances you want to target. You must provide a value for this parameter if you
	//   specify ResourceGroups for the TargetType parameter.
	//
	//   - TargetAccounts
	//
	//   - Description: (Optional) The ID of the Amazon Web Services account
	//   initiating the configuration deployment. You only need to provide a value for
	//   this parameter if you want to deploy the configuration locally. A value must be
	//   provided for either TargetAccounts or TargetOrganizationalUnits .
	//
	//   - TargetOrganizationalUnits
	//
	//   - Description: (Optional) A comma separated list of organizational units
	//   (OUs) you want to deploy the configuration to.
	//
	//   - TargetRegions
	//
	//   - Description: (Required) A comma separated list of Amazon Web Services
	//   Regions you want to deploy the configuration to.
	//
	// Patch Policy (Type: Amazon Web ServicesQuickSetupType-PatchPolicy)
	//   - PatchPolicyName
	//
	//   - Description: (Required) A name for the patch policy. The value you provide
	//   is applied to target Amazon EC2 instances as a tag.
	//
	//   - SelectedPatchBaselines
	//
	//   - Description: (Required) An array of JSON objects containing the information
	//   for the patch baselines to include in your patch policy.
	//
	//   - PatchBaselineUseDefault
	//
	//   - Description: (Optional) A boolean value that determines whether the
	//   selected patch baselines are all Amazon Web Services provided.
	//
	//   - ConfigurationOptionsPatchOperation
	//
	//   - Description: (Optional) Determines whether target instances scan for
	//   available patches, or scan and install available patches. The valid values are
	//   Scan and ScanAndInstall . The default value for the parameter is Scan .
	//
	//   - ConfigurationOptionsScanValue
	//
	//   - Description: (Optional) A cron expression that is used as the schedule for
	//   when instances scan for available patches.
	//
	//   - ConfigurationOptionsInstallValue
	//
	//   - Description: (Optional) A cron expression that is used as the schedule for
	//   when instances install available patches.
	//
	//   - ConfigurationOptionsScanNextInterval
	//
	//   - Description: (Optional) A boolean value that determines whether instances
	//   should scan for available patches at the next cron interval. The default value
	//   is " false ".
	//
	//   - ConfigurationOptionsInstallNextInterval
	//
	//   - Description: (Optional) A boolean value that determines whether instances
	//   should scan for available patches at the next cron interval. The default value
	//   is " false ".
	//
	//   - RebootOption
	//
	//   - Description: (Optional) Determines whether instances are rebooted after
	//   patches are installed. Valid values are RebootIfNeeded and NoReboot .
	//
	//   - IsPolicyAttachAllowed
	//
	//   - Description: (Optional) A boolean value that determines whether Quick Setup
	//   attaches policies to instances profiles already associated with the target
	//   instances. The default value is " false ".
	//
	//   - OutputLogEnableS3
	//
	//   - Description: (Optional) A boolean value that determines whether command
	//   output logs are sent to Amazon S3.
	//
	//   - OutputS3Location
	//
	//   - Description: (Optional) A JSON string containing information about the
	//   Amazon S3 bucket where you want to store the output details of the request.
	//
	//   - OutputS3BucketRegion
	//
	//   - Description: (Optional) The Amazon Web Services Region where the Amazon S3
	//   bucket you want Config to deliver command output to is located.
	//
	//   - OutputS3BucketName
	//
	//   - Description: (Optional) The name of the Amazon S3 bucket you want Config to
	//   deliver command output to.
	//
	//   - OutputS3KeyPrefix
	//
	//   - Description: (Optional) The key prefix you want to use in the custom Amazon
	//   S3 bucket.
	//
	//   - TargetType
	//
	//   - Description: (Optional) Determines how instances are targeted for local
	//   account deployments. Don't specify a value for this parameter if you're
	//   deploying to OUs. The valid values are * , InstanceIds , ResourceGroups , and
	//   Tags . Use * to target all instances in the account.
	//
	//   - TargetInstances
	//
	//   - Description: (Optional) A comma separated list of instance IDs. You must
	//   provide a value for this parameter if you specify InstanceIds for the
	//   TargetType parameter.
	//
	//   - TargetTagKey
	//
	//   - Description: (Required) The tag key assigned to the instances you want to
	//   target. You must provide a value for this parameter if you specify Tags for
	//   the TargetType parameter.
	//
	//   - TargetTagValue
	//
	//   - Description: (Required) The value of the tag key assigned to the instances
	//   you want to target. You must provide a value for this parameter if you specify
	//   Tags for the TargetType parameter.
	//
	//   - ResourceGroupName
	//
	//   - Description: (Required) The name of the resource group associated with the
	//   instances you want to target. You must provide a value for this parameter if you
	//   specify ResourceGroups for the TargetType parameter.
	//
	//   - TargetAccounts
	//
	//   - Description: (Optional) The ID of the Amazon Web Services account
	//   initiating the configuration deployment. You only need to provide a value for
	//   this parameter if you want to deploy the configuration locally. A value must be
	//   provided for either TargetAccounts or TargetOrganizationalUnits .
	//
	//   - TargetOrganizationalUnits
	//
	//   - Description: (Optional) A comma separated list of organizational units
	//   (OUs) you want to deploy the configuration to.
	//
	//   - TargetRegions
	//
	//   - Description: (Required) A comma separated list of Amazon Web Services
	//   Regions you want to deploy the configuration to.
	//
	// This member is required.
	Parameters map[string]string

	// The type of the Quick Setup configuration.
	//
	// This member is required.
	Type *string

	// The ARN of the IAM role used to administrate local configuration deployments.
	LocalDeploymentAdministrationRoleArn *string

	// The name of the IAM role used to deploy local configurations.
	LocalDeploymentExecutionRoleName *string

	// The version of the Quick Setup type to use.
	TypeVersion *string

	noSmithyDocumentSerde
}

// A summarized definition of a Quick Setup configuration definition.
type ConfigurationDefinitionSummary struct {

	// The common parameters and values for the configuration definition.
	FirstClassParameters map[string]string

	// The ID of the configuration definition.
	Id *string

	// The type of the Quick Setup configuration used by the configuration definition.
	Type *string

	// The version of the Quick Setup type used by the configuration definition.
	TypeVersion *string

	noSmithyDocumentSerde
}

// A summary of a Quick Setup configuration manager.
type ConfigurationManagerSummary struct {

	// The ARN of the Quick Setup configuration.
	//
	// This member is required.
	ManagerArn *string

	// A summary of the Quick Setup configuration definition.
	ConfigurationDefinitionSummaries []ConfigurationDefinitionSummary

	// The description of the configuration.
	Description *string

	// The name of the configuration
	Name *string

	// Summaries of the state of the configuration manager. These summaries include an
	// aggregate of the statuses from the configuration definition associated with the
	// configuration manager. This includes deployment statuses, association statuses,
	// drift statuses, health checks, and more.
	StatusSummaries []StatusSummary

	noSmithyDocumentSerde
}

// Details for a Quick Setup configuration.
type ConfigurationSummary struct {

	// The ID of the Amazon Web Services account where the configuration was deployed.
	Account *string

	// The ID of the configuration definition.
	ConfigurationDefinitionId *string

	// The datetime stamp when the configuration was created.
	CreatedAt *time.Time

	// The common parameters and values for the configuration definition.
	FirstClassParameters map[string]string

	// A service generated identifier for the configuration.
	Id *string

	// The ARN of the configuration manager.
	ManagerArn *string

	// The Amazon Web Services Region where the configuration was deployed.
	Region *string

	// A summary of the state of the configuration manager. This includes deployment
	// statuses, association statuses, drift statuses, health checks, and more.
	StatusSummaries []StatusSummary

	// The type of the Quick Setup configuration.
	Type *string

	// The version of the Quick Setup type used.
	TypeVersion *string

	noSmithyDocumentSerde
}

// A key-value pair to filter results.
type Filter struct {

	// The key for the filter.
	//
	// This member is required.
	Key *string

	// The values for the filter keys.
	//
	// This member is required.
	Values []string

	noSmithyDocumentSerde
}

// Information about the Quick Setup type.
type QuickSetupTypeOutput struct {

	// The latest version number of the configuration.
	LatestVersion *string

	// The type of the Quick Setup configuration.
	Type *string

	noSmithyDocumentSerde
}

// Settings configured for Quick Setup.
type ServiceSettings struct {

	// The IAM role used to enable Explorer.
	ExplorerEnablingRoleArn *string

	noSmithyDocumentSerde
}

// A summarized description of the status.
type StatusSummary struct {

	// The datetime stamp when the status was last updated.
	//
	// This member is required.
	LastUpdatedAt *time.Time

	// The type of a status summary.
	//
	// This member is required.
	StatusType StatusType

	// The current status.
	Status Status

	// Details about the status.
	StatusDetails map[string]string

	// When applicable, returns an informational message relevant to the current
	// status and status type of the status summary object. We don't recommend
	// implementing parsing logic around this value since the messages returned can
	// vary in format.
	StatusMessage *string

	noSmithyDocumentSerde
}

// Key-value pairs of metadata.
type TagEntry struct {

	// The key for the tag.
	Key *string

	// The value for the tag.
	Value *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
