// Code generated by smithy-go-codegen DO NOT EDIT.

package servicediscovery

import (
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/servicediscovery/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/middleware"
)

type validateOpCreateHttpNamespace struct {
}

func (*validateOpCreateHttpNamespace) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateHttpNamespace) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateHttpNamespaceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateHttpNamespaceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreatePrivateDnsNamespace struct {
}

func (*validateOpCreatePrivateDnsNamespace) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreatePrivateDnsNamespace) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreatePrivateDnsNamespaceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreatePrivateDnsNamespaceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreatePublicDnsNamespace struct {
}

func (*validateOpCreatePublicDnsNamespace) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreatePublicDnsNamespace) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreatePublicDnsNamespaceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreatePublicDnsNamespaceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateService struct {
}

func (*validateOpCreateService) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateService) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateServiceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateServiceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteNamespace struct {
}

func (*validateOpDeleteNamespace) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteNamespace) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteNamespaceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteNamespaceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteServiceAttributes struct {
}

func (*validateOpDeleteServiceAttributes) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteServiceAttributes) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteServiceAttributesInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteServiceAttributesInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteService struct {
}

func (*validateOpDeleteService) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteService) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteServiceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteServiceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeregisterInstance struct {
}

func (*validateOpDeregisterInstance) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeregisterInstance) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeregisterInstanceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeregisterInstanceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDiscoverInstances struct {
}

func (*validateOpDiscoverInstances) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDiscoverInstances) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DiscoverInstancesInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDiscoverInstancesInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDiscoverInstancesRevision struct {
}

func (*validateOpDiscoverInstancesRevision) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDiscoverInstancesRevision) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DiscoverInstancesRevisionInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDiscoverInstancesRevisionInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetInstance struct {
}

func (*validateOpGetInstance) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetInstance) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetInstanceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetInstanceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetInstancesHealthStatus struct {
}

func (*validateOpGetInstancesHealthStatus) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetInstancesHealthStatus) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetInstancesHealthStatusInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetInstancesHealthStatusInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetNamespace struct {
}

func (*validateOpGetNamespace) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetNamespace) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetNamespaceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetNamespaceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetOperation struct {
}

func (*validateOpGetOperation) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetOperation) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetOperationInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetOperationInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetServiceAttributes struct {
}

func (*validateOpGetServiceAttributes) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetServiceAttributes) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetServiceAttributesInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetServiceAttributesInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetService struct {
}

func (*validateOpGetService) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetService) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetServiceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetServiceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListInstances struct {
}

func (*validateOpListInstances) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListInstances) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListInstancesInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListInstancesInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListNamespaces struct {
}

func (*validateOpListNamespaces) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListNamespaces) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListNamespacesInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListNamespacesInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListOperations struct {
}

func (*validateOpListOperations) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListOperations) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListOperationsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListOperationsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListServices struct {
}

func (*validateOpListServices) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListServices) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListServicesInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListServicesInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListTagsForResource struct {
}

func (*validateOpListTagsForResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListTagsForResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListTagsForResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListTagsForResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpRegisterInstance struct {
}

func (*validateOpRegisterInstance) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpRegisterInstance) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*RegisterInstanceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpRegisterInstanceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpTagResource struct {
}

func (*validateOpTagResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpTagResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*TagResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpTagResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUntagResource struct {
}

func (*validateOpUntagResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUntagResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UntagResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUntagResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateHttpNamespace struct {
}

func (*validateOpUpdateHttpNamespace) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateHttpNamespace) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateHttpNamespaceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateHttpNamespaceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateInstanceCustomHealthStatus struct {
}

func (*validateOpUpdateInstanceCustomHealthStatus) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateInstanceCustomHealthStatus) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateInstanceCustomHealthStatusInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateInstanceCustomHealthStatusInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdatePrivateDnsNamespace struct {
}

func (*validateOpUpdatePrivateDnsNamespace) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdatePrivateDnsNamespace) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdatePrivateDnsNamespaceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdatePrivateDnsNamespaceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdatePublicDnsNamespace struct {
}

func (*validateOpUpdatePublicDnsNamespace) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdatePublicDnsNamespace) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdatePublicDnsNamespaceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdatePublicDnsNamespaceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateServiceAttributes struct {
}

func (*validateOpUpdateServiceAttributes) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateServiceAttributes) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateServiceAttributesInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateServiceAttributesInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateService struct {
}

func (*validateOpUpdateService) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateService) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateServiceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateServiceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

func addOpCreateHttpNamespaceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateHttpNamespace{}, middleware.After)
}

func addOpCreatePrivateDnsNamespaceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreatePrivateDnsNamespace{}, middleware.After)
}

func addOpCreatePublicDnsNamespaceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreatePublicDnsNamespace{}, middleware.After)
}

func addOpCreateServiceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateService{}, middleware.After)
}

func addOpDeleteNamespaceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteNamespace{}, middleware.After)
}

func addOpDeleteServiceAttributesValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteServiceAttributes{}, middleware.After)
}

func addOpDeleteServiceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteService{}, middleware.After)
}

func addOpDeregisterInstanceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeregisterInstance{}, middleware.After)
}

func addOpDiscoverInstancesValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDiscoverInstances{}, middleware.After)
}

func addOpDiscoverInstancesRevisionValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDiscoverInstancesRevision{}, middleware.After)
}

func addOpGetInstanceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetInstance{}, middleware.After)
}

func addOpGetInstancesHealthStatusValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetInstancesHealthStatus{}, middleware.After)
}

func addOpGetNamespaceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetNamespace{}, middleware.After)
}

func addOpGetOperationValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetOperation{}, middleware.After)
}

func addOpGetServiceAttributesValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetServiceAttributes{}, middleware.After)
}

func addOpGetServiceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetService{}, middleware.After)
}

func addOpListInstancesValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListInstances{}, middleware.After)
}

func addOpListNamespacesValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListNamespaces{}, middleware.After)
}

func addOpListOperationsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListOperations{}, middleware.After)
}

func addOpListServicesValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListServices{}, middleware.After)
}

func addOpListTagsForResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListTagsForResource{}, middleware.After)
}

func addOpRegisterInstanceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpRegisterInstance{}, middleware.After)
}

func addOpTagResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpTagResource{}, middleware.After)
}

func addOpUntagResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUntagResource{}, middleware.After)
}

func addOpUpdateHttpNamespaceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateHttpNamespace{}, middleware.After)
}

func addOpUpdateInstanceCustomHealthStatusValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateInstanceCustomHealthStatus{}, middleware.After)
}

func addOpUpdatePrivateDnsNamespaceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdatePrivateDnsNamespace{}, middleware.After)
}

func addOpUpdatePublicDnsNamespaceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdatePublicDnsNamespace{}, middleware.After)
}

func addOpUpdateServiceAttributesValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateServiceAttributes{}, middleware.After)
}

func addOpUpdateServiceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateService{}, middleware.After)
}

func validateDnsConfig(v *types.DnsConfig) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DnsConfig"}
	if v.DnsRecords == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DnsRecords"))
	} else if v.DnsRecords != nil {
		if err := validateDnsRecordList(v.DnsRecords); err != nil {
			invalidParams.AddNested("DnsRecords", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateDnsConfigChange(v *types.DnsConfigChange) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DnsConfigChange"}
	if v.DnsRecords == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DnsRecords"))
	} else if v.DnsRecords != nil {
		if err := validateDnsRecordList(v.DnsRecords); err != nil {
			invalidParams.AddNested("DnsRecords", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateDnsRecord(v *types.DnsRecord) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DnsRecord"}
	if len(v.Type) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Type"))
	}
	if v.TTL == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TTL"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateDnsRecordList(v []types.DnsRecord) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DnsRecordList"}
	for i := range v {
		if err := validateDnsRecord(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateHealthCheckConfig(v *types.HealthCheckConfig) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "HealthCheckConfig"}
	if len(v.Type) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Type"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateHttpNamespaceChange(v *types.HttpNamespaceChange) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "HttpNamespaceChange"}
	if v.Description == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Description"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateNamespaceFilter(v *types.NamespaceFilter) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "NamespaceFilter"}
	if len(v.Name) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if v.Values == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Values"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateNamespaceFilters(v []types.NamespaceFilter) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "NamespaceFilters"}
	for i := range v {
		if err := validateNamespaceFilter(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOperationFilter(v *types.OperationFilter) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "OperationFilter"}
	if len(v.Name) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if v.Values == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Values"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOperationFilters(v []types.OperationFilter) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "OperationFilters"}
	for i := range v {
		if err := validateOperationFilter(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validatePrivateDnsNamespaceChange(v *types.PrivateDnsNamespaceChange) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PrivateDnsNamespaceChange"}
	if v.Properties != nil {
		if err := validatePrivateDnsNamespacePropertiesChange(v.Properties); err != nil {
			invalidParams.AddNested("Properties", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validatePrivateDnsNamespaceProperties(v *types.PrivateDnsNamespaceProperties) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PrivateDnsNamespaceProperties"}
	if v.DnsProperties == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DnsProperties"))
	} else if v.DnsProperties != nil {
		if err := validatePrivateDnsPropertiesMutable(v.DnsProperties); err != nil {
			invalidParams.AddNested("DnsProperties", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validatePrivateDnsNamespacePropertiesChange(v *types.PrivateDnsNamespacePropertiesChange) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PrivateDnsNamespacePropertiesChange"}
	if v.DnsProperties == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DnsProperties"))
	} else if v.DnsProperties != nil {
		if err := validatePrivateDnsPropertiesMutableChange(v.DnsProperties); err != nil {
			invalidParams.AddNested("DnsProperties", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validatePrivateDnsPropertiesMutable(v *types.PrivateDnsPropertiesMutable) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PrivateDnsPropertiesMutable"}
	if v.SOA == nil {
		invalidParams.Add(smithy.NewErrParamRequired("SOA"))
	} else if v.SOA != nil {
		if err := validateSOA(v.SOA); err != nil {
			invalidParams.AddNested("SOA", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validatePrivateDnsPropertiesMutableChange(v *types.PrivateDnsPropertiesMutableChange) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PrivateDnsPropertiesMutableChange"}
	if v.SOA == nil {
		invalidParams.Add(smithy.NewErrParamRequired("SOA"))
	} else if v.SOA != nil {
		if err := validateSOAChange(v.SOA); err != nil {
			invalidParams.AddNested("SOA", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validatePublicDnsNamespaceChange(v *types.PublicDnsNamespaceChange) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PublicDnsNamespaceChange"}
	if v.Properties != nil {
		if err := validatePublicDnsNamespacePropertiesChange(v.Properties); err != nil {
			invalidParams.AddNested("Properties", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validatePublicDnsNamespaceProperties(v *types.PublicDnsNamespaceProperties) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PublicDnsNamespaceProperties"}
	if v.DnsProperties == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DnsProperties"))
	} else if v.DnsProperties != nil {
		if err := validatePublicDnsPropertiesMutable(v.DnsProperties); err != nil {
			invalidParams.AddNested("DnsProperties", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validatePublicDnsNamespacePropertiesChange(v *types.PublicDnsNamespacePropertiesChange) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PublicDnsNamespacePropertiesChange"}
	if v.DnsProperties == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DnsProperties"))
	} else if v.DnsProperties != nil {
		if err := validatePublicDnsPropertiesMutableChange(v.DnsProperties); err != nil {
			invalidParams.AddNested("DnsProperties", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validatePublicDnsPropertiesMutable(v *types.PublicDnsPropertiesMutable) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PublicDnsPropertiesMutable"}
	if v.SOA == nil {
		invalidParams.Add(smithy.NewErrParamRequired("SOA"))
	} else if v.SOA != nil {
		if err := validateSOA(v.SOA); err != nil {
			invalidParams.AddNested("SOA", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validatePublicDnsPropertiesMutableChange(v *types.PublicDnsPropertiesMutableChange) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PublicDnsPropertiesMutableChange"}
	if v.SOA == nil {
		invalidParams.Add(smithy.NewErrParamRequired("SOA"))
	} else if v.SOA != nil {
		if err := validateSOAChange(v.SOA); err != nil {
			invalidParams.AddNested("SOA", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateServiceChange(v *types.ServiceChange) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ServiceChange"}
	if v.DnsConfig != nil {
		if err := validateDnsConfigChange(v.DnsConfig); err != nil {
			invalidParams.AddNested("DnsConfig", err.(smithy.InvalidParamsError))
		}
	}
	if v.HealthCheckConfig != nil {
		if err := validateHealthCheckConfig(v.HealthCheckConfig); err != nil {
			invalidParams.AddNested("HealthCheckConfig", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateServiceFilter(v *types.ServiceFilter) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ServiceFilter"}
	if len(v.Name) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if v.Values == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Values"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateServiceFilters(v []types.ServiceFilter) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ServiceFilters"}
	for i := range v {
		if err := validateServiceFilter(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateSOA(v *types.SOA) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "SOA"}
	if v.TTL == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TTL"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateSOAChange(v *types.SOAChange) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "SOAChange"}
	if v.TTL == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TTL"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateTag(v *types.Tag) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Tag"}
	if v.Key == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Key"))
	}
	if v.Value == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Value"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateTagList(v []types.Tag) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TagList"}
	for i := range v {
		if err := validateTag(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateHttpNamespaceInput(v *CreateHttpNamespaceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateHttpNamespaceInput"}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if v.Tags != nil {
		if err := validateTagList(v.Tags); err != nil {
			invalidParams.AddNested("Tags", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreatePrivateDnsNamespaceInput(v *CreatePrivateDnsNamespaceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreatePrivateDnsNamespaceInput"}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if v.Vpc == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Vpc"))
	}
	if v.Tags != nil {
		if err := validateTagList(v.Tags); err != nil {
			invalidParams.AddNested("Tags", err.(smithy.InvalidParamsError))
		}
	}
	if v.Properties != nil {
		if err := validatePrivateDnsNamespaceProperties(v.Properties); err != nil {
			invalidParams.AddNested("Properties", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreatePublicDnsNamespaceInput(v *CreatePublicDnsNamespaceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreatePublicDnsNamespaceInput"}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if v.Tags != nil {
		if err := validateTagList(v.Tags); err != nil {
			invalidParams.AddNested("Tags", err.(smithy.InvalidParamsError))
		}
	}
	if v.Properties != nil {
		if err := validatePublicDnsNamespaceProperties(v.Properties); err != nil {
			invalidParams.AddNested("Properties", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateServiceInput(v *CreateServiceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateServiceInput"}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if v.DnsConfig != nil {
		if err := validateDnsConfig(v.DnsConfig); err != nil {
			invalidParams.AddNested("DnsConfig", err.(smithy.InvalidParamsError))
		}
	}
	if v.HealthCheckConfig != nil {
		if err := validateHealthCheckConfig(v.HealthCheckConfig); err != nil {
			invalidParams.AddNested("HealthCheckConfig", err.(smithy.InvalidParamsError))
		}
	}
	if v.Tags != nil {
		if err := validateTagList(v.Tags); err != nil {
			invalidParams.AddNested("Tags", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteNamespaceInput(v *DeleteNamespaceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteNamespaceInput"}
	if v.Id == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Id"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteServiceAttributesInput(v *DeleteServiceAttributesInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteServiceAttributesInput"}
	if v.ServiceId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ServiceId"))
	}
	if v.Attributes == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Attributes"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteServiceInput(v *DeleteServiceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteServiceInput"}
	if v.Id == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Id"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeregisterInstanceInput(v *DeregisterInstanceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeregisterInstanceInput"}
	if v.ServiceId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ServiceId"))
	}
	if v.InstanceId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("InstanceId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDiscoverInstancesInput(v *DiscoverInstancesInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DiscoverInstancesInput"}
	if v.NamespaceName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("NamespaceName"))
	}
	if v.ServiceName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ServiceName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDiscoverInstancesRevisionInput(v *DiscoverInstancesRevisionInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DiscoverInstancesRevisionInput"}
	if v.NamespaceName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("NamespaceName"))
	}
	if v.ServiceName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ServiceName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetInstanceInput(v *GetInstanceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetInstanceInput"}
	if v.ServiceId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ServiceId"))
	}
	if v.InstanceId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("InstanceId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetInstancesHealthStatusInput(v *GetInstancesHealthStatusInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetInstancesHealthStatusInput"}
	if v.ServiceId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ServiceId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetNamespaceInput(v *GetNamespaceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetNamespaceInput"}
	if v.Id == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Id"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetOperationInput(v *GetOperationInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetOperationInput"}
	if v.OperationId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("OperationId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetServiceAttributesInput(v *GetServiceAttributesInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetServiceAttributesInput"}
	if v.ServiceId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ServiceId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetServiceInput(v *GetServiceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetServiceInput"}
	if v.Id == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Id"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListInstancesInput(v *ListInstancesInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListInstancesInput"}
	if v.ServiceId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ServiceId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListNamespacesInput(v *ListNamespacesInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListNamespacesInput"}
	if v.Filters != nil {
		if err := validateNamespaceFilters(v.Filters); err != nil {
			invalidParams.AddNested("Filters", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListOperationsInput(v *ListOperationsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListOperationsInput"}
	if v.Filters != nil {
		if err := validateOperationFilters(v.Filters); err != nil {
			invalidParams.AddNested("Filters", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListServicesInput(v *ListServicesInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListServicesInput"}
	if v.Filters != nil {
		if err := validateServiceFilters(v.Filters); err != nil {
			invalidParams.AddNested("Filters", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListTagsForResourceInput(v *ListTagsForResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListTagsForResourceInput"}
	if v.ResourceARN == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceARN"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpRegisterInstanceInput(v *RegisterInstanceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RegisterInstanceInput"}
	if v.ServiceId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ServiceId"))
	}
	if v.InstanceId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("InstanceId"))
	}
	if v.Attributes == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Attributes"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpTagResourceInput(v *TagResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TagResourceInput"}
	if v.ResourceARN == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceARN"))
	}
	if v.Tags == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Tags"))
	} else if v.Tags != nil {
		if err := validateTagList(v.Tags); err != nil {
			invalidParams.AddNested("Tags", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUntagResourceInput(v *UntagResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UntagResourceInput"}
	if v.ResourceARN == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceARN"))
	}
	if v.TagKeys == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TagKeys"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateHttpNamespaceInput(v *UpdateHttpNamespaceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateHttpNamespaceInput"}
	if v.Id == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Id"))
	}
	if v.Namespace == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Namespace"))
	} else if v.Namespace != nil {
		if err := validateHttpNamespaceChange(v.Namespace); err != nil {
			invalidParams.AddNested("Namespace", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateInstanceCustomHealthStatusInput(v *UpdateInstanceCustomHealthStatusInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateInstanceCustomHealthStatusInput"}
	if v.ServiceId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ServiceId"))
	}
	if v.InstanceId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("InstanceId"))
	}
	if len(v.Status) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Status"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdatePrivateDnsNamespaceInput(v *UpdatePrivateDnsNamespaceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdatePrivateDnsNamespaceInput"}
	if v.Id == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Id"))
	}
	if v.Namespace == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Namespace"))
	} else if v.Namespace != nil {
		if err := validatePrivateDnsNamespaceChange(v.Namespace); err != nil {
			invalidParams.AddNested("Namespace", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdatePublicDnsNamespaceInput(v *UpdatePublicDnsNamespaceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdatePublicDnsNamespaceInput"}
	if v.Id == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Id"))
	}
	if v.Namespace == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Namespace"))
	} else if v.Namespace != nil {
		if err := validatePublicDnsNamespaceChange(v.Namespace); err != nil {
			invalidParams.AddNested("Namespace", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateServiceAttributesInput(v *UpdateServiceAttributesInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateServiceAttributesInput"}
	if v.ServiceId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ServiceId"))
	}
	if v.Attributes == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Attributes"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateServiceInput(v *UpdateServiceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateServiceInput"}
	if v.Id == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Id"))
	}
	if v.Service == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Service"))
	} else if v.Service != nil {
		if err := validateServiceChange(v.Service); err != nil {
			invalidParams.AddNested("Service", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}
