// Code generated by smithy-go-codegen DO NOT EDIT.

package servicecatalog

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/servicecatalog/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists all provisioning artifacts (also known as versions) for the specified
// self-service action.
func (c *Client) ListProvisioningArtifactsForServiceAction(ctx context.Context, params *ListProvisioningArtifactsForServiceActionInput, optFns ...func(*Options)) (*ListProvisioningArtifactsForServiceActionOutput, error) {
	if params == nil {
		params = &ListProvisioningArtifactsForServiceActionInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListProvisioningArtifactsForServiceAction", params, optFns, c.addOperationListProvisioningArtifactsForServiceActionMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListProvisioningArtifactsForServiceActionOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListProvisioningArtifactsForServiceActionInput struct {

	// The self-service action identifier. For example, act-fs7abcd89wxyz .
	//
	// This member is required.
	ServiceActionId *string

	// The language code.
	//
	//   - jp - Japanese
	//
	//   - zh - Chinese
	AcceptLanguage *string

	// The maximum number of items to return with this call.
	PageSize int32

	// The page token for the next set of results. To retrieve the first set of
	// results, use null.
	PageToken *string

	noSmithyDocumentSerde
}

type ListProvisioningArtifactsForServiceActionOutput struct {

	// The page token to use to retrieve the next set of results. If there are no
	// additional results, this value is null.
	NextPageToken *string

	// An array of objects with information about product views and provisioning
	// artifacts.
	ProvisioningArtifactViews []types.ProvisioningArtifactView

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListProvisioningArtifactsForServiceActionMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpListProvisioningArtifactsForServiceAction{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpListProvisioningArtifactsForServiceAction{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListProvisioningArtifactsForServiceAction"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListProvisioningArtifactsForServiceActionValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListProvisioningArtifactsForServiceAction(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListProvisioningArtifactsForServiceActionPaginatorOptions is the paginator
// options for ListProvisioningArtifactsForServiceAction
type ListProvisioningArtifactsForServiceActionPaginatorOptions struct {
	// The maximum number of items to return with this call.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListProvisioningArtifactsForServiceActionPaginator is a paginator for
// ListProvisioningArtifactsForServiceAction
type ListProvisioningArtifactsForServiceActionPaginator struct {
	options   ListProvisioningArtifactsForServiceActionPaginatorOptions
	client    ListProvisioningArtifactsForServiceActionAPIClient
	params    *ListProvisioningArtifactsForServiceActionInput
	nextToken *string
	firstPage bool
}

// NewListProvisioningArtifactsForServiceActionPaginator returns a new
// ListProvisioningArtifactsForServiceActionPaginator
func NewListProvisioningArtifactsForServiceActionPaginator(client ListProvisioningArtifactsForServiceActionAPIClient, params *ListProvisioningArtifactsForServiceActionInput, optFns ...func(*ListProvisioningArtifactsForServiceActionPaginatorOptions)) *ListProvisioningArtifactsForServiceActionPaginator {
	if params == nil {
		params = &ListProvisioningArtifactsForServiceActionInput{}
	}

	options := ListProvisioningArtifactsForServiceActionPaginatorOptions{}
	if params.PageSize != 0 {
		options.Limit = params.PageSize
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListProvisioningArtifactsForServiceActionPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.PageToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListProvisioningArtifactsForServiceActionPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListProvisioningArtifactsForServiceAction page.
func (p *ListProvisioningArtifactsForServiceActionPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListProvisioningArtifactsForServiceActionOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.PageToken = p.nextToken

	params.PageSize = p.options.Limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListProvisioningArtifactsForServiceAction(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextPageToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListProvisioningArtifactsForServiceActionAPIClient is a client that implements
// the ListProvisioningArtifactsForServiceAction operation.
type ListProvisioningArtifactsForServiceActionAPIClient interface {
	ListProvisioningArtifactsForServiceAction(context.Context, *ListProvisioningArtifactsForServiceActionInput, ...func(*Options)) (*ListProvisioningArtifactsForServiceActionOutput, error)
}

var _ ListProvisioningArtifactsForServiceActionAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListProvisioningArtifactsForServiceAction(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListProvisioningArtifactsForServiceAction",
	}
}
