// Code generated by smithy-go-codegen DO NOT EDIT.

package sagemaker

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/sagemaker/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Lists the data quality job definitions in your account.
func (c *Client) ListDataQualityJobDefinitions(ctx context.Context, params *ListDataQualityJobDefinitionsInput, optFns ...func(*Options)) (*ListDataQualityJobDefinitionsOutput, error) {
	if params == nil {
		params = &ListDataQualityJobDefinitionsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListDataQualityJobDefinitions", params, optFns, c.addOperationListDataQualityJobDefinitionsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListDataQualityJobDefinitionsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListDataQualityJobDefinitionsInput struct {

	// A filter that returns only data quality monitoring job definitions created
	// after the specified time.
	CreationTimeAfter *time.Time

	// A filter that returns only data quality monitoring job definitions created
	// before the specified time.
	CreationTimeBefore *time.Time

	// A filter that lists the data quality job definitions associated with the
	// specified endpoint.
	EndpointName *string

	// The maximum number of data quality monitoring job definitions to return in the
	// response.
	MaxResults *int32

	// A string in the data quality monitoring job definition name. This filter
	// returns only data quality monitoring job definitions whose name contains the
	// specified string.
	NameContains *string

	// If the result of the previous ListDataQualityJobDefinitions request was
	// truncated, the response includes a NextToken . To retrieve the next set of
	// transform jobs, use the token in the next request.>
	NextToken *string

	// The field to sort results by. The default is CreationTime .
	SortBy types.MonitoringJobDefinitionSortKey

	// Whether to sort the results in Ascending or Descending order. The default is
	// Descending .
	SortOrder types.SortOrder

	noSmithyDocumentSerde
}

type ListDataQualityJobDefinitionsOutput struct {

	// A list of data quality monitoring job definitions.
	//
	// This member is required.
	JobDefinitionSummaries []types.MonitoringJobDefinitionSummary

	// If the result of the previous ListDataQualityJobDefinitions request was
	// truncated, the response includes a NextToken . To retrieve the next set of data
	// quality monitoring job definitions, use the token in the next request.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListDataQualityJobDefinitionsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpListDataQualityJobDefinitions{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpListDataQualityJobDefinitions{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListDataQualityJobDefinitions"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListDataQualityJobDefinitions(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListDataQualityJobDefinitionsPaginatorOptions is the paginator options for
// ListDataQualityJobDefinitions
type ListDataQualityJobDefinitionsPaginatorOptions struct {
	// The maximum number of data quality monitoring job definitions to return in the
	// response.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListDataQualityJobDefinitionsPaginator is a paginator for
// ListDataQualityJobDefinitions
type ListDataQualityJobDefinitionsPaginator struct {
	options   ListDataQualityJobDefinitionsPaginatorOptions
	client    ListDataQualityJobDefinitionsAPIClient
	params    *ListDataQualityJobDefinitionsInput
	nextToken *string
	firstPage bool
}

// NewListDataQualityJobDefinitionsPaginator returns a new
// ListDataQualityJobDefinitionsPaginator
func NewListDataQualityJobDefinitionsPaginator(client ListDataQualityJobDefinitionsAPIClient, params *ListDataQualityJobDefinitionsInput, optFns ...func(*ListDataQualityJobDefinitionsPaginatorOptions)) *ListDataQualityJobDefinitionsPaginator {
	if params == nil {
		params = &ListDataQualityJobDefinitionsInput{}
	}

	options := ListDataQualityJobDefinitionsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListDataQualityJobDefinitionsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListDataQualityJobDefinitionsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListDataQualityJobDefinitions page.
func (p *ListDataQualityJobDefinitionsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListDataQualityJobDefinitionsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListDataQualityJobDefinitions(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListDataQualityJobDefinitionsAPIClient is a client that implements the
// ListDataQualityJobDefinitions operation.
type ListDataQualityJobDefinitionsAPIClient interface {
	ListDataQualityJobDefinitions(context.Context, *ListDataQualityJobDefinitionsInput, ...func(*Options)) (*ListDataQualityJobDefinitionsOutput, error)
}

var _ ListDataQualityJobDefinitionsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListDataQualityJobDefinitions(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListDataQualityJobDefinitions",
	}
}
