// Code generated by smithy-go-codegen DO NOT EDIT.

package resourcegroups

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/resourcegroups/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Returns information about a specified tag-sync task.
//
// # Minimum permissions
//
// To run this command, you must have the following permissions:
//
//   - resource-groups:GetTagSyncTask on the application group
func (c *Client) GetTagSyncTask(ctx context.Context, params *GetTagSyncTaskInput, optFns ...func(*Options)) (*GetTagSyncTaskOutput, error) {
	if params == nil {
		params = &GetTagSyncTaskInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetTagSyncTask", params, optFns, c.addOperationGetTagSyncTaskMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetTagSyncTaskOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetTagSyncTaskInput struct {

	// The Amazon resource name (ARN) of the tag-sync task.
	//
	// This member is required.
	TaskArn *string

	noSmithyDocumentSerde
}

type GetTagSyncTaskOutput struct {

	// The timestamp of when the tag-sync task was created.
	CreatedAt *time.Time

	// The specific error message in cases where the tag-sync task status is ERROR .
	ErrorMessage *string

	// The Amazon resource name (ARN) of the application group.
	GroupArn *string

	// The name of the application group.
	GroupName *string

	// The query you can use to define a resource group or a search for resources. A
	// ResourceQuery specifies both a query Type and a Query string as JSON string
	// objects. See the examples section for example JSON strings. For more information
	// about creating a resource group with a resource query, see [Build queries and groups in Resource Groups]in the Resource
	// Groups User Guide
	//
	// When you combine all of the elements together into a single string, any double
	// quotes that are embedded inside another double quote pair must be escaped by
	// preceding the embedded double quote with a backslash character (\). For example,
	// a complete ResourceQuery parameter must be formatted like the following CLI
	// parameter example:
	//
	//     --resource-query
	//     '{"Type":"TAG_FILTERS_1_0","Query":"{\"ResourceTypeFilters\":[\"AWS::AllSupported\"],\"TagFilters\":[{\"Key\":\"Stage\",\"Values\":[\"Test\"]}]}"}'
	//
	// In the preceding example, all of the double quote characters in the value part
	// of the Query element must be escaped because the value itself is surrounded by
	// double quotes. For more information, see [Quoting strings]in the Command Line Interface User
	// Guide.
	//
	// For the complete list of resource types that you can use in the array value for
	// ResourceTypeFilters , see [Resources you can use with Resource Groups and Tag Editor] in the Resource Groups User Guide. For example:
	//
	//     "ResourceTypeFilters":["AWS::S3::Bucket", "AWS::EC2::Instance"]
	//
	// [Quoting strings]: https://docs.aws.amazon.com/cli/latest/userguide/cli-usage-parameters-quoting-strings.html
	// [Resources you can use with Resource Groups and Tag Editor]: https://docs.aws.amazon.com/ARG/latest/userguide/supported-resources.html
	// [Build queries and groups in Resource Groups]: https://docs.aws.amazon.com/ARG/latest/userguide/gettingstarted-query.html
	ResourceQuery *types.ResourceQuery

	// The Amazon resource name (ARN) of the role assumed by Resource Groups to tag
	// and untag resources on your behalf.
	//
	// For more information about this role, review [Tag-sync required permissions].
	//
	// [Tag-sync required permissions]: https://docs.aws.amazon.com/servicecatalog/latest/arguide/app-tag-sync.html#tag-sync-role
	RoleArn *string

	// The status of the tag-sync task.
	//
	// Valid values include:
	//
	//   - ACTIVE - The tag-sync task is actively managing resources in the application
	//   by adding or removing the awsApplication tag from resources when they are
	//   tagged or untagged with the specified tag key-value pair.
	//
	//   - ERROR - The tag-sync task is not actively managing resources in the
	//   application. Review the ErrorMessage for more information about resolving the
	//   error.
	Status types.TagSyncTaskStatus

	// The tag key.
	TagKey *string

	// The tag value.
	TagValue *string

	// The Amazon resource name (ARN) of the tag-sync task.
	TaskArn *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetTagSyncTaskMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetTagSyncTask{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetTagSyncTask{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetTagSyncTask"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetTagSyncTaskValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetTagSyncTask(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetTagSyncTask(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetTagSyncTask",
	}
}
