// Code generated by smithy-go-codegen DO NOT EDIT.

package qconnect

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/qconnect/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists AI Prompt versions.
func (c *Client) ListAIPromptVersions(ctx context.Context, params *ListAIPromptVersionsInput, optFns ...func(*Options)) (*ListAIPromptVersionsOutput, error) {
	if params == nil {
		params = &ListAIPromptVersionsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListAIPromptVersions", params, optFns, c.addOperationListAIPromptVersionsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListAIPromptVersionsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListAIPromptVersionsInput struct {

	// The identifier of the Amazon Q in Connect AI prompt for which versions are to
	// be listed.
	//
	// This member is required.
	AiPromptId *string

	// The identifier of the Amazon Q in Connect assistant. Can be either the ID or
	// the ARN. URLs cannot contain the ARN.
	//
	// This member is required.
	AssistantId *string

	// The maximum number of results to return per page.
	MaxResults *int32

	// The token for the next set of results. Use the value returned in the previous
	// response in the next request to retrieve the next set of results.
	NextToken *string

	// The origin of the AI Prompt versions to be listed. SYSTEM for a default AI
	// Agent created by Q in Connect or CUSTOMER for an AI Agent created by calling AI
	// Agent creation APIs.
	Origin types.Origin

	noSmithyDocumentSerde
}

type ListAIPromptVersionsOutput struct {

	// The summaries of the AI Prompt versions.
	//
	// This member is required.
	AiPromptVersionSummaries []types.AIPromptVersionSummary

	// The token for the next set of results. Use the value returned in the previous
	// response in the next request to retrieve the next set of results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListAIPromptVersionsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListAIPromptVersions{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListAIPromptVersions{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListAIPromptVersions"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListAIPromptVersionsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListAIPromptVersions(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListAIPromptVersionsPaginatorOptions is the paginator options for
// ListAIPromptVersions
type ListAIPromptVersionsPaginatorOptions struct {
	// The maximum number of results to return per page.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListAIPromptVersionsPaginator is a paginator for ListAIPromptVersions
type ListAIPromptVersionsPaginator struct {
	options   ListAIPromptVersionsPaginatorOptions
	client    ListAIPromptVersionsAPIClient
	params    *ListAIPromptVersionsInput
	nextToken *string
	firstPage bool
}

// NewListAIPromptVersionsPaginator returns a new ListAIPromptVersionsPaginator
func NewListAIPromptVersionsPaginator(client ListAIPromptVersionsAPIClient, params *ListAIPromptVersionsInput, optFns ...func(*ListAIPromptVersionsPaginatorOptions)) *ListAIPromptVersionsPaginator {
	if params == nil {
		params = &ListAIPromptVersionsInput{}
	}

	options := ListAIPromptVersionsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListAIPromptVersionsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListAIPromptVersionsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListAIPromptVersions page.
func (p *ListAIPromptVersionsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListAIPromptVersionsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListAIPromptVersions(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListAIPromptVersionsAPIClient is a client that implements the
// ListAIPromptVersions operation.
type ListAIPromptVersionsAPIClient interface {
	ListAIPromptVersions(context.Context, *ListAIPromptVersionsInput, ...func(*Options)) (*ListAIPromptVersionsOutput, error)
}

var _ ListAIPromptVersionsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListAIPromptVersions(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListAIPromptVersions",
	}
}
