// Code generated by smithy-go-codegen DO NOT EDIT.

package qconnect

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/qconnect/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates a new Amazon Q in Connect message template version from the current
// content and configuration of a message template. Versions are immutable and
// monotonically increasing. Once a version is created, you can reference a
// specific version of the message template by passing in
// <message-template-id>:<versionNumber> as the message template identifier. An
// error is displayed if the supplied messageTemplateContentSha256 is different
// from the messageTemplateContentSha256 of the message template with $LATEST
// qualifier. If multiple CreateMessageTemplateVersion requests are made while the
// message template remains the same, only the first invocation creates a new
// version and the succeeding requests will return the same response as the first
// invocation.
func (c *Client) CreateMessageTemplateVersion(ctx context.Context, params *CreateMessageTemplateVersionInput, optFns ...func(*Options)) (*CreateMessageTemplateVersionOutput, error) {
	if params == nil {
		params = &CreateMessageTemplateVersionInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateMessageTemplateVersion", params, optFns, c.addOperationCreateMessageTemplateVersionMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateMessageTemplateVersionOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateMessageTemplateVersionInput struct {

	// The identifier of the knowledge base. Can be either the ID or the ARN. URLs
	// cannot contain the ARN.
	//
	// This member is required.
	KnowledgeBaseId *string

	// The identifier of the message template. Can be either the ID or the ARN. It
	// cannot contain any qualifier.
	//
	// This member is required.
	MessageTemplateId *string

	// The checksum value of the message template content that is referenced by the
	// $LATEST qualifier. It can be returned in MessageTemplateData or
	// ExtendedMessageTemplateData . It’s calculated by content, language,
	// defaultAttributes and Attachments of the message template. If not supplied, the
	// message template version will be created based on the message template content
	// that is referenced by the $LATEST qualifier by default.
	MessageTemplateContentSha256 *string

	noSmithyDocumentSerde
}

type CreateMessageTemplateVersionOutput struct {

	// The message template.
	MessageTemplate *types.ExtendedMessageTemplateData

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateMessageTemplateVersionMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreateMessageTemplateVersion{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreateMessageTemplateVersion{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateMessageTemplateVersion"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpCreateMessageTemplateVersionValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateMessageTemplateVersion(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateMessageTemplateVersion(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateMessageTemplateVersion",
	}
}
