// Code generated by smithy-go-codegen DO NOT EDIT.

package qbusiness

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/qbusiness/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists configured Amazon Q Business actions for a specific plugin in an Amazon Q
// Business application.
func (c *Client) ListPluginActions(ctx context.Context, params *ListPluginActionsInput, optFns ...func(*Options)) (*ListPluginActionsOutput, error) {
	if params == nil {
		params = &ListPluginActionsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListPluginActions", params, optFns, c.addOperationListPluginActionsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListPluginActionsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListPluginActionsInput struct {

	// The identifier of the Amazon Q Business application the plugin is attached to.
	//
	// This member is required.
	ApplicationId *string

	// The identifier of the Amazon Q Business plugin.
	//
	// This member is required.
	PluginId *string

	// The maximum number of plugin actions to return.
	MaxResults *int32

	// If the number of plugin actions returned exceeds maxResults , Amazon Q Business
	// returns a next token as a pagination token to retrieve the next set of plugin
	// actions.
	NextToken *string

	noSmithyDocumentSerde
}

type ListPluginActionsOutput struct {

	// An array of information on one or more plugin actions.
	Items []types.ActionSummary

	// If the response is truncated, Amazon Q Business returns this token, which you
	// can use in a later request to list the next set of plugin actions.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListPluginActionsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListPluginActions{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListPluginActions{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListPluginActions"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListPluginActionsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListPluginActions(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListPluginActionsPaginatorOptions is the paginator options for ListPluginActions
type ListPluginActionsPaginatorOptions struct {
	// The maximum number of plugin actions to return.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListPluginActionsPaginator is a paginator for ListPluginActions
type ListPluginActionsPaginator struct {
	options   ListPluginActionsPaginatorOptions
	client    ListPluginActionsAPIClient
	params    *ListPluginActionsInput
	nextToken *string
	firstPage bool
}

// NewListPluginActionsPaginator returns a new ListPluginActionsPaginator
func NewListPluginActionsPaginator(client ListPluginActionsAPIClient, params *ListPluginActionsInput, optFns ...func(*ListPluginActionsPaginatorOptions)) *ListPluginActionsPaginator {
	if params == nil {
		params = &ListPluginActionsInput{}
	}

	options := ListPluginActionsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListPluginActionsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListPluginActionsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListPluginActions page.
func (p *ListPluginActionsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListPluginActionsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListPluginActions(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListPluginActionsAPIClient is a client that implements the ListPluginActions
// operation.
type ListPluginActionsAPIClient interface {
	ListPluginActions(context.Context, *ListPluginActionsInput, ...func(*Options)) (*ListPluginActionsOutput, error)
}

var _ ListPluginActionsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListPluginActions(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListPluginActions",
	}
}
