// Code generated by smithy-go-codegen DO NOT EDIT.

package qbusiness

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/qbusiness/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Verifies if a user has access permissions for a specified document and returns
// the actual ACL attached to the document. Resolves user access on the document
// via user aliases and groups when verifying user access.
func (c *Client) CheckDocumentAccess(ctx context.Context, params *CheckDocumentAccessInput, optFns ...func(*Options)) (*CheckDocumentAccessOutput, error) {
	if params == nil {
		params = &CheckDocumentAccessInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CheckDocumentAccess", params, optFns, c.addOperationCheckDocumentAccessMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CheckDocumentAccessOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CheckDocumentAccessInput struct {

	// The unique identifier of the application. This is required to identify the
	// specific Amazon Q Business application context for the document access check.
	//
	// This member is required.
	ApplicationId *string

	// The unique identifier of the document. Specifies which document's access
	// permissions are being checked.
	//
	// This member is required.
	DocumentId *string

	// The unique identifier of the index. Used to locate the correct index within the
	// application where the document is stored.
	//
	// This member is required.
	IndexId *string

	// The unique identifier of the user. Used to check the access permissions for
	// this specific user against the document's ACL.
	//
	// This member is required.
	UserId *string

	// The unique identifier of the data source. Identifies the specific data source
	// from which the document originates. Should not be used when a document is
	// uploaded directly with BatchPutDocument, as no dataSourceId is available or
	// necessary.
	DataSourceId *string

	noSmithyDocumentSerde
}

type CheckDocumentAccessOutput struct {

	// The Access Control List (ACL) associated with the document. Includes allowlist
	// and denylist conditions that determine user access.
	DocumentAcl *types.DocumentAcl

	// A boolean value indicating whether the specified user has access to the
	// document, either direct access or transitive access via groups and aliases
	// attached to the document.
	HasAccess *bool

	// An array of aliases associated with the user. This includes both global and
	// local aliases, each with a name and type.
	UserAliases []types.AssociatedUser

	// An array of groups the user is part of for the specified data source. Each
	// group has a name and type.
	UserGroups []types.AssociatedGroup

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCheckDocumentAccessMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCheckDocumentAccess{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCheckDocumentAccess{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CheckDocumentAccess"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpCheckDocumentAccessValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCheckDocumentAccess(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCheckDocumentAccess(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CheckDocumentAccess",
	}
}
