// Code generated by smithy-go-codegen DO NOT EDIT.

package paymentcryptographydata

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/paymentcryptographydata/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Translates encrypted PIN block from and to ISO 9564 formats 0,1,3,4. For more
// information, see [Translate PIN data]in the Amazon Web Services Payment Cryptography User Guide.
//
// PIN block translation involves changing a PIN block from one encryption key to
// another and optionally change its format. PIN block translation occurs entirely
// within the HSM boundary and PIN data never enters or leaves Amazon Web Services
// Payment Cryptography in clear text. The encryption key transformation can be
// from PEK (Pin Encryption Key) to BDK (Base Derivation Key) for DUKPT or from BDK
// for DUKPT to PEK.
//
// Amazon Web Services Payment Cryptography also supports use of dynamic keys and
// ECDH (Elliptic Curve Diffie-Hellman) based key exchange for this operation.
//
// Dynamic keys allow you to pass a PEK as a TR-31 WrappedKeyBlock. They can be
// used when key material is frequently rotated, such as during every card
// transaction, and there is need to avoid importing short-lived keys into Amazon
// Web Services Payment Cryptography. To translate PIN block using dynamic keys,
// the keyARN is the Key Encryption Key (KEK) of the TR-31 wrapped PEK. The
// incoming wrapped key shall have a key purpose of P0 with a mode of use of B or
// D. For more information, see [Using Dynamic Keys]in the Amazon Web Services Payment Cryptography
// User Guide.
//
// Using ECDH key exchange, you can receive cardholder selectable PINs into Amazon
// Web Services Payment Cryptography. The ECDH derived key protects the incoming
// PIN block, which is translated to a PEK encrypted PIN block for use within the
// service. You can also use ECDH for reveal PIN, wherein the service translates
// the PIN block from PEK to a ECDH derived encryption key. For more information on
// establishing ECDH derived keys, see the [Generating keys]in the Amazon Web Services Payment
// Cryptography User Guide.
//
// The allowed combinations of PIN block format translations are guided by PCI. It
// is important to note that not all encrypted PIN block formats (example, format
// 1) require PAN (Primary Account Number) as input. And as such, PIN block format
// that requires PAN (example, formats 0,3,4) cannot be translated to a format
// (format 1) that does not require a PAN for generation.
//
// For information about valid keys for this operation, see [Understanding key attributes] and [Key types for specific data operations] in the Amazon
// Web Services Payment Cryptography User Guide.
//
// Amazon Web Services Payment Cryptography currently supports ISO PIN block 4
// translation for PIN block built using legacy PAN length. That is, PAN is the
// right most 12 digits excluding the check digits.
//
// Cross-account use: This operation can't be used across different Amazon Web
// Services accounts.
//
// Related operations:
//
// # GeneratePinData
//
// # VerifyPinData
//
// [Using Dynamic Keys]: https://docs.aws.amazon.com/payment-cryptography/latest/userguide/use-cases-acquirers-dynamickeys.html
// [Translate PIN data]: https://docs.aws.amazon.com/payment-cryptography/latest/userguide/translate-pin-data.html
// [Key types for specific data operations]: https://docs.aws.amazon.com/payment-cryptography/latest/userguide/crypto-ops-validkeys-ops.html
// [Understanding key attributes]: https://docs.aws.amazon.com/payment-cryptography/latest/userguide/keys-validattributes.html
// [Generating keys]: https://docs.aws.amazon.com/payment-cryptography/latest/userguide/create-keys.html
func (c *Client) TranslatePinData(ctx context.Context, params *TranslatePinDataInput, optFns ...func(*Options)) (*TranslatePinDataOutput, error) {
	if params == nil {
		params = &TranslatePinDataInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "TranslatePinData", params, optFns, c.addOperationTranslatePinDataMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*TranslatePinDataOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type TranslatePinDataInput struct {

	// The encrypted PIN block data that Amazon Web Services Payment Cryptography
	// translates.
	//
	// This member is required.
	EncryptedPinBlock *string

	// The keyARN of the encryption key under which incoming PIN block data is
	// encrypted. This key type can be PEK or BDK.
	//
	// For dynamic keys, it is the keyARN of KEK of the TR-31 wrapped PEK. For ECDH,
	// it is the keyARN of the asymmetric ECC key.
	//
	// This member is required.
	IncomingKeyIdentifier *string

	// The format of the incoming PIN block data for translation within Amazon Web
	// Services Payment Cryptography.
	//
	// This member is required.
	IncomingTranslationAttributes types.TranslationIsoFormats

	// The keyARN of the encryption key for encrypting outgoing PIN block data. This
	// key type can be PEK or BDK.
	//
	// For ECDH, it is the keyARN of the asymmetric ECC key.
	//
	// This member is required.
	OutgoingKeyIdentifier *string

	// The format of the outgoing PIN block data after translation by Amazon Web
	// Services Payment Cryptography.
	//
	// This member is required.
	OutgoingTranslationAttributes types.TranslationIsoFormats

	// The attributes and values to use for incoming DUKPT encryption key for PIN
	// block translation.
	IncomingDukptAttributes *types.DukptDerivationAttributes

	// The WrappedKeyBlock containing the encryption key under which incoming PIN
	// block data is encrypted.
	IncomingWrappedKey *types.WrappedKey

	// The attributes and values to use for outgoing DUKPT encryption key after PIN
	// block translation.
	OutgoingDukptAttributes *types.DukptDerivationAttributes

	// The WrappedKeyBlock containing the encryption key for encrypting outgoing PIN
	// block data.
	OutgoingWrappedKey *types.WrappedKey

	noSmithyDocumentSerde
}

type TranslatePinDataOutput struct {

	// The keyARN of the encryption key that Amazon Web Services Payment Cryptography
	// uses to encrypt outgoing PIN block data after translation.
	//
	// This member is required.
	KeyArn *string

	// The key check value (KCV) of the encryption key. The KCV is used to check if
	// all parties holding a given key have the same key or to detect that a key has
	// changed.
	//
	// Amazon Web Services Payment Cryptography computes the KCV according to the CMAC
	// specification.
	//
	// This member is required.
	KeyCheckValue *string

	// The outgoing encrypted PIN block data after translation.
	//
	// This member is required.
	PinBlock *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationTranslatePinDataMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpTranslatePinData{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpTranslatePinData{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "TranslatePinData"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpTranslatePinDataValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opTranslatePinData(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opTranslatePinData(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "TranslatePinData",
	}
}
