// Code generated by smithy-go-codegen DO NOT EDIT.

package types

type AccessStatus string

// Enum values for AccessStatus
const (
	AccessStatusEnabled  AccessStatus = "ENABLED"
	AccessStatusDisabled AccessStatus = "DISABLED"
	AccessStatusPending  AccessStatus = "PENDING"
)

// Values returns all known values for AccessStatus. Note that this can be
// expanded in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (AccessStatus) Values() []AccessStatus {
	return []AccessStatus{
		"ENABLED",
		"DISABLED",
		"PENDING",
	}
}

type AccountContactType string

// Enum values for AccountContactType
const (
	// Primary Contact managed by AWS Account Management Service.
	AccountContactTypeAccountPrimary AccountContactType = "ACCOUNT_PRIMARY"
	// Alternate Billing Contact managed by AWS Account Management Service.
	AccountContactTypeAccountAlternateBilling AccountContactType = "ACCOUNT_ALTERNATE_BILLING"
	// Alternate Operations Contact managed by AWS Account Management Service.
	AccountContactTypeAccountAlternateOperations AccountContactType = "ACCOUNT_ALTERNATE_OPERATIONS"
	// Alternate Security Contact managed by AWS Account Management Service.
	AccountContactTypeAccountAlternateSecurity AccountContactType = "ACCOUNT_ALTERNATE_SECURITY"
)

// Values returns all known values for AccountContactType. Note that this can be
// expanded in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (AccountContactType) Values() []AccountContactType {
	return []AccountContactType{
		"ACCOUNT_PRIMARY",
		"ACCOUNT_ALTERNATE_BILLING",
		"ACCOUNT_ALTERNATE_OPERATIONS",
		"ACCOUNT_ALTERNATE_SECURITY",
	}
}

type AggregationDuration string

// Enum values for AggregationDuration
const (
	// Aggregate notifications for long periods of time (12 hours)
	AggregationDurationLong AggregationDuration = "LONG"
	// Aggregate notifications for short periods of time (5 mins)
	AggregationDurationShort AggregationDuration = "SHORT"
	// Do not aggregate notifications sourced from a notification configuration
	AggregationDurationNone AggregationDuration = "NONE"
)

// Values returns all known values for AggregationDuration. Note that this can be
// expanded in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (AggregationDuration) Values() []AggregationDuration {
	return []AggregationDuration{
		"LONG",
		"SHORT",
		"NONE",
	}
}

type AggregationEventType string

// Enum values for AggregationEventType
const (
	AggregationEventTypeAggregate AggregationEventType = "AGGREGATE"
	AggregationEventTypeChild     AggregationEventType = "CHILD"
	AggregationEventTypeNone      AggregationEventType = "NONE"
)

// Values returns all known values for AggregationEventType. Note that this can be
// expanded in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (AggregationEventType) Values() []AggregationEventType {
	return []AggregationEventType{
		"AGGREGATE",
		"CHILD",
		"NONE",
	}
}

type ChannelAssociationOverrideOption string

// Enum values for ChannelAssociationOverrideOption
const (
	// AWS User Notification service users can associate or disassociate a Channel
	// with a notification configuration.
	ChannelAssociationOverrideOptionEnabled ChannelAssociationOverrideOption = "ENABLED"
	// AWS User Notification service users can not associate or disassociate a Channel
	// with a notification configuration.
	ChannelAssociationOverrideOptionDisabled ChannelAssociationOverrideOption = "DISABLED"
)

// Values returns all known values for ChannelAssociationOverrideOption. Note that
// this can be expanded in the future, and so it is only as up to date as the
// client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (ChannelAssociationOverrideOption) Values() []ChannelAssociationOverrideOption {
	return []ChannelAssociationOverrideOption{
		"ENABLED",
		"DISABLED",
	}
}

type ChannelType string

// Enum values for ChannelType
const (
	// AWS Console Mobile App sends notifications to mobile devices.
	// Link:https://aws.amazon.com/console/mobile/
	ChannelTypeMobile ChannelType = "MOBILE"
	// Chatbot sends notifications to group platforms, like Slack or Chime.
	// Link:https://aws.amazon.com/chatbot/
	ChannelTypeChatbot ChannelType = "CHATBOT"
	// Email sends notifications to email addresses.
	ChannelTypeEmail ChannelType = "EMAIL"
	// User Notification Service sends notifications to Account Managed contacts.
	ChannelTypeAccountContact ChannelType = "ACCOUNT_CONTACT"
)

// Values returns all known values for ChannelType. Note that this can be expanded
// in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (ChannelType) Values() []ChannelType {
	return []ChannelType{
		"MOBILE",
		"CHATBOT",
		"EMAIL",
		"ACCOUNT_CONTACT",
	}
}

type EventRuleStatus string

// Enum values for EventRuleStatus
const (
	// EventRule is processing events. Any call can be executed.
	EventRuleStatusActive EventRuleStatus = "ACTIVE"
	// EventRule is in a bad state and may not be processing events. Any call can be
	// executed.
	EventRuleStatusInactive EventRuleStatus = "INACTIVE"
	// This EventRule is being created. Only GET/LIST calls can be executed.
	EventRuleStatusCreating EventRuleStatus = "CREATING"
	// This EventRule is being updated. Only GET/LIST calls can be executed.
	EventRuleStatusUpdating EventRuleStatus = "UPDATING"
	// This EventRule is being deleted. Only GET/LIST calls can be executed.
	EventRuleStatusDeleting EventRuleStatus = "DELETING"
)

// Values returns all known values for EventRuleStatus. Note that this can be
// expanded in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (EventRuleStatus) Values() []EventRuleStatus {
	return []EventRuleStatus{
		"ACTIVE",
		"INACTIVE",
		"CREATING",
		"UPDATING",
		"DELETING",
	}
}

type EventStatus string

// Enum values for EventStatus
const (
	EventStatusHealthy   EventStatus = "HEALTHY"
	EventStatusUnhealthy EventStatus = "UNHEALTHY"
)

// Values returns all known values for EventStatus. Note that this can be expanded
// in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (EventStatus) Values() []EventStatus {
	return []EventStatus{
		"HEALTHY",
		"UNHEALTHY",
	}
}

type LocaleCode string

// Enum values for LocaleCode
const (
	// German (Germany)
	LocaleCodeDeDe LocaleCode = "de_DE"
	// English (Canada)
	LocaleCodeEnCa LocaleCode = "en_CA"
	// English (United States). This is the default locale.
	LocaleCodeEnUs LocaleCode = "en_US"
	// English (United Kingdom)
	LocaleCodeEnUk LocaleCode = "en_UK"
	// Spanish (Spain)
	LocaleCodeEsEs LocaleCode = "es_ES"
	// French (Canada)
	LocaleCodeFrCa LocaleCode = "fr_CA"
	// French (France)
	LocaleCodeFrFr LocaleCode = "fr_FR"
	// Bahasa Indonesian (Indonesia)
	LocaleCodeIdId LocaleCode = "id_ID"
	// Italian (Italy)
	LocaleCodeItIt LocaleCode = "it_IT"
	// Japanese (Japan)
	LocaleCodeJaJp LocaleCode = "ja_JP"
	// Korean (Korea)
	LocaleCodeKoKr LocaleCode = "ko_KR"
	// Portuguese (Brazil)
	LocaleCodePtBr LocaleCode = "pt_BR"
	// Turkish (Turkey)
	LocaleCodeTrTr LocaleCode = "tr_TR"
	// Chinese (China)
	LocaleCodeZhCn LocaleCode = "zh_CN"
	// Chinese (Taiwan)
	LocaleCodeZhTw LocaleCode = "zh_TW"
)

// Values returns all known values for LocaleCode. Note that this can be expanded
// in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (LocaleCode) Values() []LocaleCode {
	return []LocaleCode{
		"de_DE",
		"en_CA",
		"en_US",
		"en_UK",
		"es_ES",
		"fr_CA",
		"fr_FR",
		"id_ID",
		"it_IT",
		"ja_JP",
		"ko_KR",
		"pt_BR",
		"tr_TR",
		"zh_CN",
		"zh_TW",
	}
}

type MediaElementType string

// Enum values for MediaElementType
const (
	MediaElementTypeImage MediaElementType = "IMAGE"
)

// Values returns all known values for MediaElementType. Note that this can be
// expanded in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (MediaElementType) Values() []MediaElementType {
	return []MediaElementType{
		"IMAGE",
	}
}

type NotificationConfigurationStatus string

// Enum values for NotificationConfigurationStatus
const (
	// All of the EventRules are in ACTIVE Status. Any call can be executed.
	NotificationConfigurationStatusActive NotificationConfigurationStatus = "ACTIVE"
	// Some EventRules are in ACTIVE Status and some are INACTIVE. Any call can be
	// executed.
	NotificationConfigurationStatusPartiallyActive NotificationConfigurationStatus = "PARTIALLY_ACTIVE"
	// All of the EventRules are in INACTIVE Status. Any call can be executed.
	NotificationConfigurationStatusInactive NotificationConfigurationStatus = "INACTIVE"
	// This NotificationConfiguration is being deleted. Only GET/LIST calls can be
	// executed.
	NotificationConfigurationStatusDeleting NotificationConfigurationStatus = "DELETING"
)

// Values returns all known values for NotificationConfigurationStatus. Note that
// this can be expanded in the future, and so it is only as up to date as the
// client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (NotificationConfigurationStatus) Values() []NotificationConfigurationStatus {
	return []NotificationConfigurationStatus{
		"ACTIVE",
		"PARTIALLY_ACTIVE",
		"INACTIVE",
		"DELETING",
	}
}

type NotificationHubStatus string

// Enum values for NotificationHubStatus
const (
	// Incoming Notification Events are being replicated to this Notification Hub. A
	// Notification Hub with this status can be deregistered.
	NotificationHubStatusActive NotificationHubStatus = "ACTIVE"
	// Notification Hub is initializing. Cannot deregister a Notification Hub in this
	// status.
	NotificationHubStatusRegistering NotificationHubStatus = "REGISTERING"
	// Notification Hub is being deleted. Cannot register a Notification Hub in the
	// same region as one in this status.
	NotificationHubStatusDeregistering NotificationHubStatus = "DEREGISTERING"
	// Notification Hub is in a failure state. Incoming Notification Events are not
	// being replicated to this Hub.
	NotificationHubStatusInactive NotificationHubStatus = "INACTIVE"
)

// Values returns all known values for NotificationHubStatus. Note that this can
// be expanded in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (NotificationHubStatus) Values() []NotificationHubStatus {
	return []NotificationHubStatus{
		"ACTIVE",
		"REGISTERING",
		"DEREGISTERING",
		"INACTIVE",
	}
}

type NotificationType string

// Enum values for NotificationType
const (
	NotificationTypeAlert         NotificationType = "ALERT"
	NotificationTypeWarning       NotificationType = "WARNING"
	NotificationTypeAnnouncement  NotificationType = "ANNOUNCEMENT"
	NotificationTypeInformational NotificationType = "INFORMATIONAL"
)

// Values returns all known values for NotificationType. Note that this can be
// expanded in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (NotificationType) Values() []NotificationType {
	return []NotificationType{
		"ALERT",
		"WARNING",
		"ANNOUNCEMENT",
		"INFORMATIONAL",
	}
}

type SchemaVersion string

// Enum values for SchemaVersion
const (
	SchemaVersionSchemaVersion10 SchemaVersion = "v1.0"
)

// Values returns all known values for SchemaVersion. Note that this can be
// expanded in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (SchemaVersion) Values() []SchemaVersion {
	return []SchemaVersion{
		"v1.0",
	}
}

type TextPartType string

// Enum values for TextPartType
const (
	TextPartTypeLocalizedText TextPartType = "LOCALIZED_TEXT"
	TextPartTypePlainText     TextPartType = "PLAIN_TEXT"
	TextPartTypeUrl           TextPartType = "URL"
)

// Values returns all known values for TextPartType. Note that this can be
// expanded in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (TextPartType) Values() []TextPartType {
	return []TextPartType{
		"LOCALIZED_TEXT",
		"PLAIN_TEXT",
		"URL",
	}
}

type ValidationExceptionReason string

// Enum values for ValidationExceptionReason
const (
	ValidationExceptionReasonFieldValidationFailed ValidationExceptionReason = "fieldValidationFailed"
	ValidationExceptionReasonOther                 ValidationExceptionReason = "other"
)

// Values returns all known values for ValidationExceptionReason. Note that this
// can be expanded in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (ValidationExceptionReason) Values() []ValidationExceptionReason {
	return []ValidationExceptionReason{
		"fieldValidationFailed",
		"other",
	}
}
