// Code generated by smithy-go-codegen DO NOT EDIT.

package notifications

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/notifications/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns a list of NotificationHubs .
func (c *Client) ListNotificationHubs(ctx context.Context, params *ListNotificationHubsInput, optFns ...func(*Options)) (*ListNotificationHubsOutput, error) {
	if params == nil {
		params = &ListNotificationHubsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListNotificationHubs", params, optFns, c.addOperationListNotificationHubsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListNotificationHubsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListNotificationHubsInput struct {

	// The maximum number of records to list in a single response.
	MaxResults *int32

	// A pagination token. Set to null to start listing notification hubs from the
	// start.
	NextToken *string

	noSmithyDocumentSerde
}

type ListNotificationHubsOutput struct {

	// The NotificationHubs in the account.
	//
	// This member is required.
	NotificationHubs []types.NotificationHubOverview

	// A pagination token. If a non-null pagination token is returned in a result,
	// pass its value in another request to retrieve more entries.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListNotificationHubsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListNotificationHubs{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListNotificationHubs{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListNotificationHubs"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListNotificationHubs(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListNotificationHubsPaginatorOptions is the paginator options for
// ListNotificationHubs
type ListNotificationHubsPaginatorOptions struct {
	// The maximum number of records to list in a single response.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListNotificationHubsPaginator is a paginator for ListNotificationHubs
type ListNotificationHubsPaginator struct {
	options   ListNotificationHubsPaginatorOptions
	client    ListNotificationHubsAPIClient
	params    *ListNotificationHubsInput
	nextToken *string
	firstPage bool
}

// NewListNotificationHubsPaginator returns a new ListNotificationHubsPaginator
func NewListNotificationHubsPaginator(client ListNotificationHubsAPIClient, params *ListNotificationHubsInput, optFns ...func(*ListNotificationHubsPaginatorOptions)) *ListNotificationHubsPaginator {
	if params == nil {
		params = &ListNotificationHubsInput{}
	}

	options := ListNotificationHubsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListNotificationHubsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListNotificationHubsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListNotificationHubs page.
func (p *ListNotificationHubsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListNotificationHubsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListNotificationHubs(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListNotificationHubsAPIClient is a client that implements the
// ListNotificationHubs operation.
type ListNotificationHubsAPIClient interface {
	ListNotificationHubs(context.Context, *ListNotificationHubsInput, ...func(*Options)) (*ListNotificationHubsOutput, error)
}

var _ ListNotificationHubsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListNotificationHubs(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListNotificationHubs",
	}
}
