// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	"github.com/aws/aws-sdk-go-v2/service/kendra/document"
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Summary information on an access control configuration that you created for
// your documents in an index.
type AccessControlConfigurationSummary struct {

	// The identifier of the access control configuration.
	//
	// This member is required.
	Id *string

	noSmithyDocumentSerde
}

// Access Control List files for the documents in a data source. For the format of
// the file, see [Access control for S3 data sources].
//
// [Access control for S3 data sources]: https://docs.aws.amazon.com/kendra/latest/dg/s3-acl.html
type AccessControlListConfiguration struct {

	// Path to the Amazon S3 bucket that contains the ACL files.
	KeyPath *string

	noSmithyDocumentSerde
}

// Provides information about the column that should be used for filtering the
// query response by groups.
type AclConfiguration struct {

	// A list of groups, separated by semi-colons, that filters a query response based
	// on user context. The document is only returned to users that are in one of the
	// groups specified in the UserContext field of the Query API.
	//
	// This member is required.
	AllowedGroupsColumnName *string

	noSmithyDocumentSerde
}

// An attribute returned from an index query.
type AdditionalResultAttribute struct {

	// The key that identifies the attribute.
	//
	// This member is required.
	Key *string

	// An object that contains the attribute value.
	//
	// This member is required.
	Value *AdditionalResultAttributeValue

	// The data type of the Value property.
	//
	// This member is required.
	ValueType AdditionalResultAttributeValueType

	noSmithyDocumentSerde
}

// An attribute returned with a document from a search.
type AdditionalResultAttributeValue struct {

	// The text associated with the attribute and information about the highlight to
	// apply to the text.
	TextWithHighlightsValue *TextWithHighlights

	noSmithyDocumentSerde
}

// Provides the configuration information to connect to Alfresco as your data
// source.
//
// Support for AlfrescoConfiguration ended May 2023. We recommend migrating to or
// using the Alfresco data source template schema / [TemplateConfiguration]API.
//
// [TemplateConfiguration]: https://docs.aws.amazon.com/kendra/latest/APIReference/API_TemplateConfiguration.html
type AlfrescoConfiguration struct {

	// The Amazon Resource Name (ARN) of an Secrets Manager secret that contains the
	// key-value pairs required to connect to your Alfresco data source. The secret
	// must contain a JSON structure with the following keys:
	//
	//   - username—The user name of the Alfresco account.
	//
	//   - password—The password of the Alfresco account.
	//
	// This member is required.
	SecretArn *string

	// The identifier of the Alfresco site. For example, my-site.
	//
	// This member is required.
	SiteId *string

	// The URL of the Alfresco site. For example, https://hostname:8080.
	//
	// This member is required.
	SiteUrl *string

	// The path to the SSL certificate stored in an Amazon S3 bucket. You use this to
	// connect to Alfresco if you require a secure SSL connection.
	//
	// You can simply generate a self-signed X509 certificate on any computer using
	// OpenSSL. For an example of using OpenSSL to create an X509 certificate, see [Create and sign an X509 certificate].
	//
	// [Create and sign an X509 certificate]: https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/configuring-https-ssl.html
	//
	// This member is required.
	SslCertificateS3Path *S3Path

	// A list of DataSourceToIndexFieldMapping objects that map attributes or field
	// names of Alfresco blogs to Amazon Kendra index field names. To create custom
	// fields, use the UpdateIndex API before you map to Alfresco fields. For more
	// information, see [Mapping data source fields]. The Alfresco data source field names must exist in your
	// Alfresco custom metadata.
	//
	// [Mapping data source fields]: https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html
	BlogFieldMappings []DataSourceToIndexFieldMapping

	// TRUE to index comments of blogs and other content.
	CrawlComments bool

	// TRUE to index shared files.
	CrawlSystemFolders bool

	// A list of DataSourceToIndexFieldMapping objects that map attributes or field
	// names of Alfresco document libraries to Amazon Kendra index field names. To
	// create custom fields, use the UpdateIndex API before you map to Alfresco
	// fields. For more information, see [Mapping data source fields]. The Alfresco data source field names must
	// exist in your Alfresco custom metadata.
	//
	// [Mapping data source fields]: https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html
	DocumentLibraryFieldMappings []DataSourceToIndexFieldMapping

	// Specify whether to index document libraries, wikis, or blogs. You can specify
	// one or more of these options.
	EntityFilter []AlfrescoEntity

	// A list of regular expression patterns to exclude certain files in your Alfresco
	// data source. Files that match the patterns are excluded from the index. Files
	// that don't match the patterns are included in the index. If a file matches both
	// an inclusion pattern and an exclusion pattern, the exclusion pattern takes
	// precedence and the file isn't included in the index.
	ExclusionPatterns []string

	// A list of regular expression patterns to include certain files in your Alfresco
	// data source. Files that match the patterns are included in the index. Files that
	// don't match the patterns are excluded from the index. If a file matches both an
	// inclusion pattern and an exclusion pattern, the exclusion pattern takes
	// precedence and the file isn't included in the index.
	InclusionPatterns []string

	// Configuration information for an Amazon Virtual Private Cloud to connect to
	// your Alfresco. For more information, see [Configuring a VPC].
	//
	// [Configuring a VPC]: https://docs.aws.amazon.com/kendra/latest/dg/vpc-configuration.html
	VpcConfiguration *DataSourceVpcConfiguration

	// A list of DataSourceToIndexFieldMapping objects that map attributes or field
	// names of Alfresco wikis to Amazon Kendra index field names. To create custom
	// fields, use the UpdateIndex API before you map to Alfresco fields. For more
	// information, see [Mapping data source fields]. The Alfresco data source field names must exist in your
	// Alfresco custom metadata.
	//
	// [Mapping data source fields]: https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html
	WikiFieldMappings []DataSourceToIndexFieldMapping

	noSmithyDocumentSerde
}

// Filters the search results based on document attributes or fields.
//
// You can filter results using attributes for your particular documents. The
// attributes must exist in your index. For example, if your documents include the
// custom attribute "Department", you can filter documents that belong to the "HR"
// department. You would use the EqualsTo operation to filter results or documents
// with "Department" equals to "HR".
//
// You can use AndAllFilters and OrAllFilters in combination with each other or
// with other operations such as EqualsTo . For example:
//
//	  AndAllFilters
//
//	- EqualsTo : "Department", "HR"
//
//	- OrAllFilters
//
//	- ContainsAny : "Project Name", ["new hires", "new hiring"]
//
// This example filters results or documents that belong to the HR department AND
// belong to projects that contain "new hires" OR "new hiring" in the project name
// (must use ContainAny with StringListValue ). This example is filtering with a
// depth of 2.
//
// You cannot filter more than a depth of 2, otherwise you receive a
// ValidationException exception with the message "AttributeFilter cannot have a
// depth of more than 2." Also, if you use more than 10 attribute filters in a
// given list for AndAllFilters or OrAllFilters , you receive a ValidationException
// with the message "AttributeFilter cannot have a length of more than 10".
//
// For examples of using AttributeFilter , see [Using document attributes to filter search results].
//
// [Using document attributes to filter search results]: https://docs.aws.amazon.com/kendra/latest/dg/filtering.html#search-filtering
type AttributeFilter struct {

	// Performs a logical AND operation on all filters that you specify.
	AndAllFilters []AttributeFilter

	// Returns true when a document contains all of the specified document
	// attributes/fields. This filter is only applicable to [StringListValue].
	//
	// [StringListValue]: https://docs.aws.amazon.com/kendra/latest/APIReference/API_DocumentAttributeValue.html
	ContainsAll *DocumentAttribute

	// Returns true when a document contains any of the specified document
	// attributes/fields. This filter is only applicable to [StringListValue].
	//
	// [StringListValue]: https://docs.aws.amazon.com/kendra/latest/APIReference/API_DocumentAttributeValue.html
	ContainsAny *DocumentAttribute

	// Performs an equals operation on document attributes/fields and their values.
	EqualsTo *DocumentAttribute

	// Performs a greater than operation on document attributes/fields and their
	// values. Use with the [document attribute type]Date or Long .
	//
	// [document attribute type]: https://docs.aws.amazon.com/kendra/latest/APIReference/API_DocumentAttributeValue.html
	GreaterThan *DocumentAttribute

	// Performs a greater or equals than operation on document attributes/fields and
	// their values. Use with the [document attribute type]Date or Long .
	//
	// [document attribute type]: https://docs.aws.amazon.com/kendra/latest/APIReference/API_DocumentAttributeValue.html
	GreaterThanOrEquals *DocumentAttribute

	// Performs a less than operation on document attributes/fields and their values.
	// Use with the [document attribute type]Date or Long .
	//
	// [document attribute type]: https://docs.aws.amazon.com/kendra/latest/APIReference/API_DocumentAttributeValue.html
	LessThan *DocumentAttribute

	// Performs a less than or equals operation on document attributes/fields and
	// their values. Use with the [document attribute type]Date or Long .
	//
	// [document attribute type]: https://docs.aws.amazon.com/kendra/latest/APIReference/API_DocumentAttributeValue.html
	LessThanOrEquals *DocumentAttribute

	// Performs a logical NOT operation on all filters that you specify.
	NotFilter *AttributeFilter

	// Performs a logical OR operation on all filters that you specify.
	OrAllFilters []AttributeFilter

	noSmithyDocumentSerde
}

// Gets information on the configuration of document fields/attributes that you
// want to base query suggestions on. To change your configuration, use [AttributeSuggestionsUpdateConfig]and then
// call [UpdateQuerySuggestionsConfig].
//
// [UpdateQuerySuggestionsConfig]: https://docs.aws.amazon.com/kendra/latest/dg/API_UpdateQuerySuggestionsConfig.html
// [AttributeSuggestionsUpdateConfig]: https://docs.aws.amazon.com/kendra/latest/dg/API_AttributeSuggestionsUpdateConfig.html
type AttributeSuggestionsDescribeConfig struct {

	// The mode is set to either ACTIVE or INACTIVE . If the Mode for query history is
	// set to ENABLED when calling [UpdateQuerySuggestionsConfig] and AttributeSuggestionsMode to use
	// fields/attributes is set to ACTIVE , and you haven't set your SuggestionTypes
	// preference to DOCUMENT_ATTRIBUTES , then Amazon Kendra uses the query history.
	//
	// [UpdateQuerySuggestionsConfig]: https://docs.aws.amazon.com/kendra/latest/dg/API_UpdateQuerySuggestionsConfig.html
	AttributeSuggestionsMode AttributeSuggestionsMode

	// The list of fields/attributes that you want to set as suggestible for query
	// suggestions.
	SuggestableConfigList []SuggestableConfig

	noSmithyDocumentSerde
}

// Provides the configuration information for the document fields/attributes that
// you want to base query suggestions on.
type AttributeSuggestionsGetConfig struct {

	// The list of additional document field/attribute keys or field names to include
	// in the response. You can use additional fields to provide extra information in
	// the response. Additional fields are not used to based suggestions on.
	AdditionalResponseAttributes []string

	// Filters the search results based on document fields/attributes.
	AttributeFilter *AttributeFilter

	// The list of document field/attribute keys or field names to use for query
	// suggestions. If the content within any of the fields match what your user starts
	// typing as their query, then the field content is returned as a query suggestion.
	SuggestionAttributes []string

	// Applies user context filtering so that only users who are given access to
	// certain documents see these document in their search results.
	UserContext *UserContext

	noSmithyDocumentSerde
}

// Updates the configuration information for the document fields/attributes that
// you want to base query suggestions on.
//
// To deactivate using documents fields for query suggestions, set the mode to
// INACTIVE . You must also set SuggestionTypes as either QUERY or
// DOCUMENT_ATTRIBUTES and then call [GetQuerySuggestions]. If you set to QUERY , then Amazon Kendra
// uses the query history to base suggestions on. If you set to DOCUMENT_ATTRIBUTES
// , then Amazon Kendra uses the contents of document fields to base suggestions
// on.
//
// [GetQuerySuggestions]: https://docs.aws.amazon.com/kendra/latest/dg/API_GetQuerySuggestions.html
type AttributeSuggestionsUpdateConfig struct {

	// You can set the mode to ACTIVE or INACTIVE . You must also set SuggestionTypes
	// as either QUERY or DOCUMENT_ATTRIBUTES and then call [GetQuerySuggestions]. If Mode to use query
	// history is set to ENABLED when calling [UpdateQuerySuggestionsConfig] and AttributeSuggestionsMode to use
	// fields/attributes is set to ACTIVE , and you haven't set your SuggestionTypes
	// preference to DOCUMENT_ATTRIBUTES , then Amazon Kendra uses the query history.
	//
	// [UpdateQuerySuggestionsConfig]: https://docs.aws.amazon.com/kendra/latest/dg/API_UpdateQuerySuggestionsConfig.html
	// [GetQuerySuggestions]: https://docs.aws.amazon.com/kendra/latest/dg/API_GetQuerySuggestions.html
	AttributeSuggestionsMode AttributeSuggestionsMode

	// The list of fields/attributes that you want to set as suggestible for query
	// suggestions.
	SuggestableConfigList []SuggestableConfig

	noSmithyDocumentSerde
}

// Provides the configuration information to connect to websites that require user
// authentication.
type AuthenticationConfiguration struct {

	// The list of configuration information that's required to connect to and crawl a
	// website host using basic authentication credentials.
	//
	// The list includes the name and port number of the website host.
	BasicAuthentication []BasicAuthenticationConfiguration

	noSmithyDocumentSerde
}

// Provides the configuration information to connect to websites that require
// basic user authentication.
type BasicAuthenticationConfiguration struct {

	// The Amazon Resource Name (ARN) of an Secrets Manager secret. You create a
	// secret to store your credentials in [Secrets Manager]
	//
	// You use a secret if basic authentication credentials are required to connect to
	// a website. The secret stores your credentials of user name and password.
	//
	// [Secrets Manager]: https://docs.aws.amazon.com/secretsmanager/latest/userguide/intro.html
	//
	// This member is required.
	Credentials *string

	// The name of the website host you want to connect to using authentication
	// credentials.
	//
	// For example, the host name of https://a.example.com/page1.html is
	// "a.example.com".
	//
	// This member is required.
	Host *string

	// The port number of the website host you want to connect to using authentication
	// credentials.
	//
	// For example, the port for https://a.example.com/page1.html is 443, the standard
	// port for HTTPS.
	//
	// This member is required.
	Port *int32

	noSmithyDocumentSerde
}

// Provides information about documents that could not be removed from an index by
// the BatchDeleteDocument API.
type BatchDeleteDocumentResponseFailedDocument struct {

	//  The identifier of the data source connector that the document belongs to.
	DataSourceId *string

	// The error code for why the document couldn't be removed from the index.
	ErrorCode ErrorCode

	// An explanation for why the document couldn't be removed from the index.
	ErrorMessage *string

	// The identifier of the document that couldn't be removed from the index.
	Id *string

	noSmithyDocumentSerde
}

// Provides information about a set of featured results that couldn't be removed
// from an index by the [BatchDeleteFeaturedResultsSet]API.
//
// [BatchDeleteFeaturedResultsSet]: https://docs.aws.amazon.com/kendra/latest/dg/API_BatchDeleteFeaturedResultsSet.html
type BatchDeleteFeaturedResultsSetError struct {

	// The error code for why the set of featured results couldn't be removed from the
	// index.
	//
	// This member is required.
	ErrorCode ErrorCode

	// An explanation for why the set of featured results couldn't be removed from the
	// index.
	//
	// This member is required.
	ErrorMessage *string

	// The identifier of the set of featured results that couldn't be removed from the
	// index.
	//
	// This member is required.
	Id *string

	noSmithyDocumentSerde
}

// Provides a response when the status of a document could not be retrieved.
type BatchGetDocumentStatusResponseError struct {

	//  The identifier of the data source connector that the failed document belongs
	// to.
	DataSourceId *string

	// The identifier of the document whose status could not be retrieved.
	DocumentId *string

	// Indicates the source of the error.
	ErrorCode ErrorCode

	// States that the API could not get the status of a document. This could be
	// because the request is not valid or there is a system error.
	ErrorMessage *string

	noSmithyDocumentSerde
}

// Provides information about a document that could not be indexed.
type BatchPutDocumentResponseFailedDocument struct {

	//  The identifier of the data source connector that the failed document belongs
	// to.
	DataSourceId *string

	// The type of error that caused the document to fail to be indexed.
	ErrorCode ErrorCode

	// A description of the reason why the document could not be indexed.
	ErrorMessage *string

	// The identifier of the document.
	Id *string

	noSmithyDocumentSerde
}

// Provides the configuration information to connect to Box as your data source.
type BoxConfiguration struct {

	// The identifier of the Box Enterprise platform. You can find the enterprise ID
	// in the Box Developer Console settings or when you create an app in Box and
	// download your authentication credentials. For example, 801234567.
	//
	// This member is required.
	EnterpriseId *string

	// The Amazon Resource Name (ARN) of an Secrets Manager secret that contains the
	// key-value pairs required to connect to your Box platform. The secret must
	// contain a JSON structure with the following keys:
	//
	//   - clientID—The identifier of the client OAuth 2.0 authentication application
	//   created in Box.
	//
	//   - clientSecret—A set of characters known only to the OAuth 2.0 authentication
	//   application created in Box.
	//
	//   - publicKeyId—The identifier of the public key contained within an identity
	//   certificate.
	//
	//   - privateKey—A set of characters that make up an encryption key.
	//
	//   - passphrase—A set of characters that act like a password.
	//
	// You create an application in Box to generate the keys or credentials required
	// for the secret. For more information, see [Using a Box data source].
	//
	// [Using a Box data source]: https://docs.aws.amazon.com/kendra/latest/dg/data-source-box.html
	//
	// This member is required.
	SecretArn *string

	// A list of DataSourceToIndexFieldMapping objects that map attributes or field
	// names of Box comments to Amazon Kendra index field names. To create custom
	// fields, use the UpdateIndex API before you map to Box fields. For more
	// information, see [Mapping data source fields]. The Box field names must exist in your Box custom metadata.
	//
	// [Mapping data source fields]: https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html
	CommentFieldMappings []DataSourceToIndexFieldMapping

	// TRUE to index comments.
	CrawlComments bool

	// TRUE to index the contents of tasks.
	CrawlTasks bool

	// TRUE to index web links.
	CrawlWebLinks bool

	// A list of regular expression patterns to exclude certain files and folders from
	// your Box platform. Files and folders that match the patterns are excluded from
	// the index.Files and folders that don't match the patterns are included in the
	// index. If a file or folder matches both an inclusion and exclusion pattern, the
	// exclusion pattern takes precedence and the file or folder isn't included in the
	// index.
	ExclusionPatterns []string

	// A list of DataSourceToIndexFieldMapping objects that map attributes or field
	// names of Box files to Amazon Kendra index field names. To create custom fields,
	// use the UpdateIndex API before you map to Box fields. For more information, see [Mapping data source fields]
	// . The Box field names must exist in your Box custom metadata.
	//
	// [Mapping data source fields]: https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html
	FileFieldMappings []DataSourceToIndexFieldMapping

	// A list of regular expression patterns to include certain files and folders in
	// your Box platform. Files and folders that match the patterns are included in the
	// index. Files and folders that don't match the patterns are excluded from the
	// index. If a file or folder matches both an inclusion and exclusion pattern, the
	// exclusion pattern takes precedence and the file or folder isn't included in the
	// index.
	InclusionPatterns []string

	// A list of DataSourceToIndexFieldMapping objects that map attributes or field
	// names of Box tasks to Amazon Kendra index field names. To create custom fields,
	// use the UpdateIndex API before you map to Box fields. For more information, see [Mapping data source fields]
	// . The Box field names must exist in your Box custom metadata.
	//
	// [Mapping data source fields]: https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html
	TaskFieldMappings []DataSourceToIndexFieldMapping

	// TRUE to use the Slack change log to determine which documents require updating
	// in the index. Depending on the data source change log's size, it may take longer
	// for Amazon Kendra to use the change log than to scan all of your documents.
	UseChangeLog bool

	// Configuration information for an Amazon VPC to connect to your Box. For more
	// information, see [Configuring a VPC].
	//
	// [Configuring a VPC]: https://docs.aws.amazon.com/kendra/latest/dg/vpc-configuration.html
	VpcConfiguration *DataSourceVpcConfiguration

	// A list of DataSourceToIndexFieldMapping objects that map attributes or field
	// names of Box web links to Amazon Kendra index field names. To create custom
	// fields, use the UpdateIndex API before you map to Box fields. For more
	// information, see [Mapping data source fields]. The Box field names must exist in your Box custom metadata.
	//
	// [Mapping data source fields]: https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html
	WebLinkFieldMappings []DataSourceToIndexFieldMapping

	noSmithyDocumentSerde
}

// Specifies additional capacity units configured for your Enterprise Edition
// index. You can add and remove capacity units to fit your usage requirements.
type CapacityUnitsConfiguration struct {

	// The amount of extra query capacity for an index and [GetQuerySuggestions] capacity.
	//
	// A single extra capacity unit for an index provides 0.1 queries per second or
	// approximately 8,000 queries per day. You can add up to 100 extra capacity units.
	//
	// GetQuerySuggestions capacity is five times the provisioned query capacity for
	// an index, or the base capacity of 2.5 calls per second, whichever is higher. For
	// example, the base capacity for an index is 0.1 queries per second, and
	// GetQuerySuggestions capacity has a base of 2.5 calls per second. If you add
	// another 0.1 queries per second to total 0.2 queries per second for an index, the
	// GetQuerySuggestions capacity is 2.5 calls per second (higher than five times
	// 0.2 queries per second).
	//
	// [GetQuerySuggestions]: https://docs.aws.amazon.com/kendra/latest/dg/API_GetQuerySuggestions.html
	//
	// This member is required.
	QueryCapacityUnits *int32

	// The amount of extra storage capacity for an index. A single capacity unit
	// provides 30 GB of storage space or 100,000 documents, whichever is reached
	// first. You can add up to 100 extra capacity units.
	//
	// This member is required.
	StorageCapacityUnits *int32

	noSmithyDocumentSerde
}

// Gathers information about when a particular result was clicked by a user. Your
// application uses the SubmitFeedback API to provide click information.
type ClickFeedback struct {

	// The Unix timestamp when the result was clicked.
	//
	// This member is required.
	ClickTime *time.Time

	// The identifier of the search result that was clicked.
	//
	// This member is required.
	ResultId *string

	noSmithyDocumentSerde
}

// Specifies how to group results by document attribute value, and how to display
// them collapsed/expanded under a designated primary document for each group.
type CollapseConfiguration struct {

	// The document attribute used to group search results. You can use any attribute
	// that has the Sortable flag set to true. You can also sort by any of the
	// following built-in attributes:"_category","_created_at", "_last_updated_at",
	// "_version", "_view_count".
	//
	// This member is required.
	DocumentAttributeKey *string

	// Specifies whether to expand the collapsed results.
	Expand bool

	// Provides configuration information to customize expansion options for a
	// collapsed group.
	ExpandConfiguration *ExpandConfiguration

	// Specifies the behavior for documents without a value for the collapse attribute.
	//
	// Amazon Kendra offers three customization options:
	//
	//   - Choose to COLLAPSE all documents with null or missing values in one group.
	//   This is the default configuration.
	//
	//   - Choose to IGNORE documents with null or missing values. Ignored documents
	//   will not appear in query results.
	//
	//   - Choose to EXPAND each document with a null or missing value into a group of
	//   its own.
	MissingAttributeKeyStrategy MissingAttributeKeyStrategy

	// A prioritized list of document attributes/fields that determine the primary
	// document among those in a collapsed group.
	SortingConfigurations []SortingConfiguration

	noSmithyDocumentSerde
}

// Provides details about a collapsed group of search results.
type CollapsedResultDetail struct {

	// The value of the document attribute that results are collapsed on.
	//
	// This member is required.
	DocumentAttribute *DocumentAttribute

	// A list of results in the collapsed group.
	ExpandedResults []ExpandedResultItem

	noSmithyDocumentSerde
}

// Provides information about how Amazon Kendra should use the columns of a
// database in an index.
type ColumnConfiguration struct {

	// One to five columns that indicate when a document in the database has changed.
	//
	// This member is required.
	ChangeDetectingColumns []string

	// The column that contains the contents of the document.
	//
	// This member is required.
	DocumentDataColumnName *string

	// The column that provides the document's identifier.
	//
	// This member is required.
	DocumentIdColumnName *string

	// The column that contains the title of the document.
	DocumentTitleColumnName *string

	// An array of objects that map database column names to the corresponding fields
	// in an index. You must first create the fields in the index using the UpdateIndex
	// API.
	FieldMappings []DataSourceToIndexFieldMapping

	noSmithyDocumentSerde
}

// Information about a conflicting query used across different sets of featured
// results. When you create a featured results set, you must check that the queries
// are unique per featured results set for each index.
type ConflictingItem struct {

	// The text of the conflicting query.
	QueryText *string

	// The identifier of the set of featured results that the conflicting query
	// belongs to.
	SetId *string

	// The name for the set of featured results that the conflicting query belongs to.
	SetName *string

	noSmithyDocumentSerde
}

// Configuration of attachment settings for the Confluence data source. Attachment
// settings are optional, if you don't specify settings attachments, Amazon Kendra
// won't index them.
type ConfluenceAttachmentConfiguration struct {

	// Maps attributes or field names of Confluence attachments to Amazon Kendra index
	// field names. To create custom fields, use the UpdateIndex API before you map to
	// Confluence fields. For more information, see [Mapping data source fields]. The Confluence data source field
	// names must exist in your Confluence custom metadata.
	//
	// If you specify the AttachentFieldMappings parameter, you must specify at least
	// one field mapping.
	//
	// [Mapping data source fields]: https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html
	AttachmentFieldMappings []ConfluenceAttachmentToIndexFieldMapping

	// TRUE to index attachments of pages and blogs in Confluence.
	CrawlAttachments bool

	noSmithyDocumentSerde
}

// Maps attributes or field names of Confluence attachments to Amazon Kendra index
// field names. To create custom fields, use the UpdateIndex API before you map to
// Confluence fields. For more information, see [Mapping data source fields]. The Confuence data source field
// names must exist in your Confluence custom metadata.
//
// [Mapping data source fields]: https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html
type ConfluenceAttachmentToIndexFieldMapping struct {

	// The name of the field in the data source.
	//
	// You must first create the index field using the UpdateIndex API.
	DataSourceFieldName ConfluenceAttachmentFieldName

	// The format for date fields in the data source. If the field specified in
	// DataSourceFieldName is a date field you must specify the date format. If the
	// field is not a date field, an exception is thrown.
	DateFieldFormat *string

	// The name of the index field to map to the Confluence data source field. The
	// index field type must match the Confluence field type.
	IndexFieldName *string

	noSmithyDocumentSerde
}

// Configuration of blog settings for the Confluence data source. Blogs are always
// indexed unless filtered from the index by the ExclusionPatterns or
// InclusionPatterns fields in the ConfluenceConfiguration object.
type ConfluenceBlogConfiguration struct {

	// Maps attributes or field names of Confluence blogs to Amazon Kendra index field
	// names. To create custom fields, use the UpdateIndex API before you map to
	// Confluence fields. For more information, see [Mapping data source fields]. The Confluence data source field
	// names must exist in your Confluence custom metadata.
	//
	// If you specify the BlogFieldMappings parameter, you must specify at least one
	// field mapping.
	//
	// [Mapping data source fields]: https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html
	BlogFieldMappings []ConfluenceBlogToIndexFieldMapping

	noSmithyDocumentSerde
}

// Maps attributes or field names of Confluence blog to Amazon Kendra index field
// names. To create custom fields, use the UpdateIndex API before you map to
// Confluence fields. For more information, see [Mapping data source fields]. The Confluence data source field
// names must exist in your Confluence custom metadata.
//
// [Mapping data source fields]: https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html
type ConfluenceBlogToIndexFieldMapping struct {

	// The name of the field in the data source.
	DataSourceFieldName ConfluenceBlogFieldName

	// The format for date fields in the data source. If the field specified in
	// DataSourceFieldName is a date field you must specify the date format. If the
	// field is not a date field, an exception is thrown.
	DateFieldFormat *string

	// The name of the index field to map to the Confluence data source field. The
	// index field type must match the Confluence field type.
	IndexFieldName *string

	noSmithyDocumentSerde
}

// Provides the configuration information to connect to Confluence as your data
// source.
type ConfluenceConfiguration struct {

	// The Amazon Resource Name (ARN) of an Secrets Manager secret that contains the
	// user name and password required to connect to the Confluence instance. If you
	// use Confluence Cloud, you use a generated API token as the password.
	//
	// You can also provide authentication credentials in the form of a personal
	// access token. For more information, see [Using a Confluence data source].
	//
	// [Using a Confluence data source]: https://docs.aws.amazon.com/kendra/latest/dg/data-source-confluence.html
	//
	// This member is required.
	SecretArn *string

	// The URL of your Confluence instance. Use the full URL of the server. For
	// example, https://server.example.com:port/. You can also use an IP address, for
	// example, https://192.168.1.113/.
	//
	// This member is required.
	ServerUrl *string

	// The version or the type of Confluence installation to connect to.
	//
	// This member is required.
	Version ConfluenceVersion

	// Configuration information for indexing attachments to Confluence blogs and
	// pages.
	AttachmentConfiguration *ConfluenceAttachmentConfiguration

	// Whether you want to connect to Confluence using basic authentication of user
	// name and password, or a personal access token. You can use a personal access
	// token for Confluence Server.
	AuthenticationType ConfluenceAuthenticationType

	// Configuration information for indexing Confluence blogs.
	BlogConfiguration *ConfluenceBlogConfiguration

	// A list of regular expression patterns to exclude certain blog posts, pages,
	// spaces, or attachments in your Confluence. Content that matches the patterns are
	// excluded from the index. Content that doesn't match the patterns is included in
	// the index. If content matches both an inclusion and exclusion pattern, the
	// exclusion pattern takes precedence and the content isn't included in the index.
	ExclusionPatterns []string

	// A list of regular expression patterns to include certain blog posts, pages,
	// spaces, or attachments in your Confluence. Content that matches the patterns are
	// included in the index. Content that doesn't match the patterns is excluded from
	// the index. If content matches both an inclusion and exclusion pattern, the
	// exclusion pattern takes precedence and the content isn't included in the index.
	InclusionPatterns []string

	// Configuration information for indexing Confluence pages.
	PageConfiguration *ConfluencePageConfiguration

	// Configuration information to connect to your Confluence URL instance via a web
	// proxy. You can use this option for Confluence Server.
	//
	// You must provide the website host name and port number. For example, the host
	// name of https://a.example.com/page1.html is "a.example.com" and the port is 443,
	// the standard port for HTTPS.
	//
	// Web proxy credentials are optional and you can use them to connect to a web
	// proxy server that requires basic authentication of user name and password. To
	// store web proxy credentials, you use a secret in Secrets Manager.
	//
	// It is recommended that you follow best security practices when configuring your
	// web proxy. This includes setting up throttling, setting up logging and
	// monitoring, and applying security patches on a regular basis. If you use your
	// web proxy with multiple data sources, sync jobs that occur at the same time
	// could strain the load on your proxy. It is recommended you prepare your proxy
	// beforehand for any security and load requirements.
	ProxyConfiguration *ProxyConfiguration

	// Configuration information for indexing Confluence spaces.
	SpaceConfiguration *ConfluenceSpaceConfiguration

	// Configuration information for an Amazon Virtual Private Cloud to connect to
	// your Confluence. For more information, see [Configuring a VPC].
	//
	// [Configuring a VPC]: https://docs.aws.amazon.com/kendra/latest/dg/vpc-configuration.html
	VpcConfiguration *DataSourceVpcConfiguration

	noSmithyDocumentSerde
}

// Configuration of the page settings for the Confluence data source.
type ConfluencePageConfiguration struct {

	// Maps attributes or field names of Confluence pages to Amazon Kendra index field
	// names. To create custom fields, use the UpdateIndex API before you map to
	// Confluence fields. For more information, see [Mapping data source fields]. The Confluence data source field
	// names must exist in your Confluence custom metadata.
	//
	// If you specify the PageFieldMappings parameter, you must specify at least one
	// field mapping.
	//
	// [Mapping data source fields]: https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html
	PageFieldMappings []ConfluencePageToIndexFieldMapping

	noSmithyDocumentSerde
}

// Maps attributes or field names of Confluence pages to Amazon Kendra index field
// names. To create custom fields, use the UpdateIndex API before you map to
// Confluence fields. For more information, see [Mapping data source fields]. The Confluence data source field
// names must exist in your Confluence custom metadata.
//
// [Mapping data source fields]: https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html
type ConfluencePageToIndexFieldMapping struct {

	// The name of the field in the data source.
	DataSourceFieldName ConfluencePageFieldName

	// The format for date fields in the data source. If the field specified in
	// DataSourceFieldName is a date field you must specify the date format. If the
	// field is not a date field, an exception is thrown.
	DateFieldFormat *string

	// The name of the index field to map to the Confluence data source field. The
	// index field type must match the Confluence field type.
	IndexFieldName *string

	noSmithyDocumentSerde
}

// Configuration information for indexing Confluence spaces.
type ConfluenceSpaceConfiguration struct {

	// TRUE to index archived spaces.
	CrawlArchivedSpaces bool

	// TRUE to index personal spaces. You can add restrictions to items in personal
	// spaces. If personal spaces are indexed, queries without user context information
	// may return restricted items from a personal space in their results. For more
	// information, see [Filtering on user context].
	//
	// [Filtering on user context]: https://docs.aws.amazon.com/kendra/latest/dg/user-context-filter.html
	CrawlPersonalSpaces bool

	// A list of space keys of Confluence spaces. If you include a key, the blogs,
	// documents, and attachments in the space are not indexed. If a space is in both
	// the ExcludeSpaces and the IncludeSpaces list, the space is excluded.
	ExcludeSpaces []string

	// A list of space keys for Confluence spaces. If you include a key, the blogs,
	// documents, and attachments in the space are indexed. Spaces that aren't in the
	// list aren't indexed. A space in the list must exist. Otherwise, Amazon Kendra
	// logs an error when the data source is synchronized. If a space is in both the
	// IncludeSpaces and the ExcludeSpaces list, the space is excluded.
	IncludeSpaces []string

	// Maps attributes or field names of Confluence spaces to Amazon Kendra index
	// field names. To create custom fields, use the UpdateIndex API before you map to
	// Confluence fields. For more information, see [Mapping data source fields]. The Confluence data source field
	// names must exist in your Confluence custom metadata.
	//
	// If you specify the SpaceFieldMappings parameter, you must specify at least one
	// field mapping.
	//
	// [Mapping data source fields]: https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html
	SpaceFieldMappings []ConfluenceSpaceToIndexFieldMapping

	noSmithyDocumentSerde
}

// Maps attributes or field names of Confluence spaces to Amazon Kendra index
// field names. To create custom fields, use the UpdateIndex API before you map to
// Confluence fields. For more information, see [Mapping data source fields]. The Confluence data source field
// names must exist in your Confluence custom metadata.
//
// [Mapping data source fields]: https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html
type ConfluenceSpaceToIndexFieldMapping struct {

	// The name of the field in the data source.
	DataSourceFieldName ConfluenceSpaceFieldName

	// The format for date fields in the data source. If the field specified in
	// DataSourceFieldName is a date field you must specify the date format. If the
	// field is not a date field, an exception is thrown.
	DateFieldFormat *string

	// The name of the index field to map to the Confluence data source field. The
	// index field type must match the Confluence field type.
	IndexFieldName *string

	noSmithyDocumentSerde
}

// Provides the configuration information that's required to connect to a database.
type ConnectionConfiguration struct {

	// The name of the host for the database. Can be either a string
	// (host.subdomain.domain.tld) or an IPv4 or IPv6 address.
	//
	// This member is required.
	DatabaseHost *string

	// The name of the database containing the document data.
	//
	// This member is required.
	DatabaseName *string

	// The port that the database uses for connections.
	//
	// This member is required.
	DatabasePort *int32

	// The Amazon Resource Name (ARN) of an Secrets Manager secret that stores the
	// credentials. The credentials should be a user-password pair. For more
	// information, see [Using a Database Data Source]. For more information about Secrets Manager, see [What Is Secrets Manager] in the
	// Secrets Manager user guide.
	//
	// [Using a Database Data Source]: https://docs.aws.amazon.com/kendra/latest/dg/data-source-database.html
	// [What Is Secrets Manager]: https://docs.aws.amazon.com/secretsmanager/latest/userguide/intro.html
	//
	// This member is required.
	SecretArn *string

	// The name of the table that contains the document data.
	//
	// This member is required.
	TableName *string

	noSmithyDocumentSerde
}

// Provides the configuration information for your content sources, such as data
// sources, FAQs, and content indexed directly via [BatchPutDocument].
//
// [BatchPutDocument]: https://docs.aws.amazon.com/kendra/latest/dg/API_BatchPutDocument.html
type ContentSourceConfiguration struct {

	// The identifier of the data sources you want to use for your Amazon Kendra
	// experience.
	DataSourceIds []string

	// TRUE to use documents you indexed directly using the BatchPutDocument API.
	DirectPutContent bool

	// The identifier of the FAQs that you want to use for your Amazon Kendra
	// experience.
	FaqIds []string

	noSmithyDocumentSerde
}

// A corrected misspelled word in a query.
type Correction struct {

	// The zero-based location in the response string or text where the corrected word
	// starts.
	BeginOffset *int32

	// The string or text of a corrected misspelled word in a query.
	CorrectedTerm *string

	// The zero-based location in the response string or text where the corrected word
	// ends.
	EndOffset *int32

	// The string or text of a misspelled word in a query.
	Term *string

	noSmithyDocumentSerde
}

// Provides the configuration information for altering document metadata and
// content during the document ingestion process.
//
// For more information, see [Customizing document metadata during the ingestion process].
//
// [Customizing document metadata during the ingestion process]: https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html
type CustomDocumentEnrichmentConfiguration struct {

	// Configuration information to alter document attributes or metadata fields and
	// content when ingesting documents into Amazon Kendra.
	InlineConfigurations []InlineCustomDocumentEnrichmentConfiguration

	// Configuration information for invoking a Lambda function in Lambda on the
	// structured documents with their metadata and text extracted. You can use a
	// Lambda function to apply advanced logic for creating, modifying, or deleting
	// document metadata and content. For more information, see [Advanced data manipulation].
	//
	// [Advanced data manipulation]: https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html#advanced-data-manipulation
	PostExtractionHookConfiguration *HookConfiguration

	// Configuration information for invoking a Lambda function in Lambda on the
	// original or raw documents before extracting their metadata and text. You can use
	// a Lambda function to apply advanced logic for creating, modifying, or deleting
	// document metadata and content. For more information, see [Advanced data manipulation].
	//
	// [Advanced data manipulation]: https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html#advanced-data-manipulation
	PreExtractionHookConfiguration *HookConfiguration

	// The Amazon Resource Name (ARN) of an IAM role with permission to run
	// PreExtractionHookConfiguration and PostExtractionHookConfiguration for altering
	// document metadata and content during the document ingestion process. For more
	// information, see [an IAM roles for Amazon Kendra].
	//
	// [an IAM roles for Amazon Kendra]: https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html
	RoleArn *string

	noSmithyDocumentSerde
}

// Provides the configuration information to an [Amazon Kendra supported database].
//
// [Amazon Kendra supported database]: https://docs.aws.amazon.com/kendra/latest/dg/data-source-database.html
type DatabaseConfiguration struct {

	// Information about where the index should get the document information from the
	// database.
	//
	// This member is required.
	ColumnConfiguration *ColumnConfiguration

	// Configuration information that's required to connect to a database.
	//
	// This member is required.
	ConnectionConfiguration *ConnectionConfiguration

	// The type of database engine that runs the database.
	//
	// This member is required.
	DatabaseEngineType DatabaseEngineType

	// Information about the database column that provides information for user
	// context filtering.
	AclConfiguration *AclConfiguration

	// Provides information about how Amazon Kendra uses quote marks around SQL
	// identifiers when querying a database data source.
	SqlConfiguration *SqlConfiguration

	// Provides the configuration information to connect to an Amazon VPC.
	VpcConfiguration *DataSourceVpcConfiguration

	noSmithyDocumentSerde
}

// Provides the configuration information for an Amazon Kendra data source.
type DataSourceConfiguration struct {

	// Provides the configuration information to connect to Alfresco as your data
	// source.
	//
	// Support for AlfrescoConfiguration ended May 2023. We recommend migrating to or
	// using the Alfresco data source template schema / [TemplateConfiguration]API.
	//
	// [TemplateConfiguration]: https://docs.aws.amazon.com/kendra/latest/APIReference/API_TemplateConfiguration.html
	//
	// Deprecated: Deprecated AlfrescoConfiguration in favor of TemplateConfiguration
	AlfrescoConfiguration *AlfrescoConfiguration

	// Provides the configuration information to connect to Box as your data source.
	BoxConfiguration *BoxConfiguration

	// Provides the configuration information to connect to Confluence as your data
	// source.
	ConfluenceConfiguration *ConfluenceConfiguration

	// Provides the configuration information to connect to a database as your data
	// source.
	DatabaseConfiguration *DatabaseConfiguration

	// Provides the configuration information to connect to Amazon FSx as your data
	// source.
	//
	// Amazon Kendra now supports an upgraded Amazon FSx Windows connector.
	//
	// You must now use the [TemplateConfiguration] object instead of the FsxConfiguration object to
	// configure your connector.
	//
	// Connectors configured using the older console and API architecture will
	// continue to function as configured. However, you won't be able to edit or update
	// them. If you want to edit or update your connector configuration, you must
	// create a new connector.
	//
	// We recommended migrating your connector workflow to the upgraded version.
	// Support for connectors configured using the older architecture is scheduled to
	// end by June 2024.
	//
	// [TemplateConfiguration]: https://docs.aws.amazon.com/kendra/latest/APIReference/API_TemplateConfiguration.html
	FsxConfiguration *FsxConfiguration

	// Provides the configuration information to connect to GitHub as your data source.
	//
	// Amazon Kendra now supports an upgraded GitHub connector.
	//
	// You must now use the [TemplateConfiguration] object instead of the GitHubConfiguration object to
	// configure your connector.
	//
	// Connectors configured using the older console and API architecture will
	// continue to function as configured. However, you won’t be able to edit or update
	// them. If you want to edit or update your connector configuration, you must
	// create a new connector.
	//
	// We recommended migrating your connector workflow to the upgraded version.
	// Support for connectors configured using the older architecture is scheduled to
	// end by June 2024.
	//
	// [TemplateConfiguration]: https://docs.aws.amazon.com/kendra/latest/APIReference/API_TemplateConfiguration.html
	GitHubConfiguration *GitHubConfiguration

	// Provides the configuration information to connect to Google Drive as your data
	// source.
	GoogleDriveConfiguration *GoogleDriveConfiguration

	// Provides the configuration information to connect to Jira as your data source.
	JiraConfiguration *JiraConfiguration

	// Provides the configuration information to connect to Microsoft OneDrive as your
	// data source.
	OneDriveConfiguration *OneDriveConfiguration

	// Provides the configuration information to connect to Quip as your data source.
	QuipConfiguration *QuipConfiguration

	// Provides the configuration information to connect to an Amazon S3 bucket as
	// your data source.
	//
	// Amazon Kendra now supports an upgraded Amazon S3 connector.
	//
	// You must now use the [TemplateConfiguration] object instead of the S3DataSourceConfiguration object to
	// configure your connector.
	//
	// Connectors configured using the older console and API architecture will
	// continue to function as configured. However, you won't be able to edit or update
	// them. If you want to edit or update your connector configuration, you must
	// create a new connector.
	//
	// We recommended migrating your connector workflow to the upgraded version.
	// Support for connectors configured using the older architecture is scheduled to
	// end by June 2024.
	//
	// [TemplateConfiguration]: https://docs.aws.amazon.com/kendra/latest/APIReference/API_TemplateConfiguration.html
	S3Configuration *S3DataSourceConfiguration

	// Provides the configuration information to connect to Salesforce as your data
	// source.
	SalesforceConfiguration *SalesforceConfiguration

	// Provides the configuration information to connect to ServiceNow as your data
	// source.
	ServiceNowConfiguration *ServiceNowConfiguration

	// Provides the configuration information to connect to Microsoft SharePoint as
	// your data source.
	SharePointConfiguration *SharePointConfiguration

	// Provides the configuration information to connect to Slack as your data source.
	//
	// Amazon Kendra now supports an upgraded Slack connector.
	//
	// You must now use the [TemplateConfiguration] object instead of the SlackConfiguration object to
	// configure your connector.
	//
	// Connectors configured using the older console and API architecture will
	// continue to function as configured. However, you won't be able to edit or update
	// them. If you want to edit or update your connector configuration, you must
	// create a new connector.
	//
	// We recommended migrating your connector workflow to the upgraded version.
	// Support for connectors configured using the older architecture is scheduled to
	// end by June 2024.
	//
	// [TemplateConfiguration]: https://docs.aws.amazon.com/kendra/latest/APIReference/API_TemplateConfiguration.html
	SlackConfiguration *SlackConfiguration

	// Provides a template for the configuration information to connect to your data
	// source.
	TemplateConfiguration *TemplateConfiguration

	// Provides the configuration information required for Amazon Kendra Web Crawler.
	WebCrawlerConfiguration *WebCrawlerConfiguration

	// Provides the configuration information to connect to Amazon WorkDocs as your
	// data source.
	WorkDocsConfiguration *WorkDocsConfiguration

	noSmithyDocumentSerde
}

// Data source information for user context filtering.
type DataSourceGroup struct {

	// The identifier of the data source group you want to add to your list of data
	// source groups. This is for filtering search results based on the groups' access
	// to documents in that data source.
	//
	// This member is required.
	DataSourceId *string

	// The identifier of the group you want to add to your list of groups. This is for
	// filtering search results based on the groups' access to documents.
	//
	// This member is required.
	GroupId *string

	noSmithyDocumentSerde
}

// Summary information for a Amazon Kendra data source.
type DataSourceSummary struct {

	// The Unix timestamp when the data source connector was created.
	CreatedAt *time.Time

	// The identifier for the data source.
	Id *string

	// The code for a language. This shows a supported language for all documents in
	// the data source. English is supported by default. For more information on
	// supported languages, including their codes, see [Adding documents in languages other than English].
	//
	// [Adding documents in languages other than English]: https://docs.aws.amazon.com/kendra/latest/dg/in-adding-languages.html
	LanguageCode *string

	// The name of the data source.
	Name *string

	// The status of the data source. When the status is ACTIVE the data source is
	// ready to use.
	Status DataSourceStatus

	// The type of the data source.
	Type DataSourceType

	// The Unix timestamp when the data source connector was last updated.
	UpdatedAt *time.Time

	noSmithyDocumentSerde
}

// Provides information about a data source synchronization job.
type DataSourceSyncJob struct {

	// If the reason that the synchronization failed is due to an error with the
	// underlying data source, this field contains a code that identifies the error.
	DataSourceErrorCode *string

	// The Unix timestamp when the synchronization job completed.
	EndTime *time.Time

	// If the Status field is set to FAILED , the ErrorCode field indicates the reason
	// the synchronization failed.
	ErrorCode ErrorCode

	// If the Status field is set to ERROR , the ErrorMessage field contains a
	// description of the error that caused the synchronization to fail.
	ErrorMessage *string

	// A identifier for the synchronization job.
	ExecutionId *string

	// Maps a batch delete document request to a specific data source sync job. This
	// is optional and should only be supplied when documents are deleted by a data
	// source connector.
	Metrics *DataSourceSyncJobMetrics

	// The Unix timestamp when the synchronization job started.
	StartTime *time.Time

	// The execution status of the synchronization job. When the Status field is set
	// to SUCCEEDED , the synchronization job is done. If the status code is set to
	// FAILED , the ErrorCode and ErrorMessage fields give you the reason for the
	// failure.
	Status DataSourceSyncJobStatus

	noSmithyDocumentSerde
}

// Maps a batch delete document request to a specific data source sync job. This
// is optional and should only be supplied when documents are deleted by a data
// source connector.
type DataSourceSyncJobMetrics struct {

	// The number of documents added from the data source up to now in the data source
	// sync.
	DocumentsAdded *string

	// The number of documents deleted from the data source up to now in the data
	// source sync run.
	DocumentsDeleted *string

	// The number of documents that failed to sync from the data source up to now in
	// the data source sync run.
	DocumentsFailed *string

	// The number of documents modified in the data source up to now in the data
	// source sync run.
	DocumentsModified *string

	// The current number of documents crawled by the current sync job in the data
	// source.
	DocumentsScanned *string

	noSmithyDocumentSerde
}

// Maps a particular data source sync job to a particular data source.
type DataSourceSyncJobMetricTarget struct {

	// The ID of the data source that is running the sync job.
	//
	// This member is required.
	DataSourceId *string

	// The ID of the sync job that is running on the data source.
	//
	// If the ID of a sync job is not provided and there is a sync job running, then
	// the ID of this sync job is used and metrics are generated for this sync job.
	//
	// If the ID of a sync job is not provided and there is no sync job running, then
	// no metrics are generated and documents are indexed/deleted at the index level
	// without sync job metrics included.
	DataSourceSyncJobId *string

	noSmithyDocumentSerde
}

// Maps attributes or field names of the documents synced from the data source to
// Amazon Kendra index field names. You can set up field mappings for each data
// source when calling [CreateDataSource]or [UpdateDataSource] API. To create custom fields, use the UpdateIndex API
// to first create an index field and then map to the data source field. For more
// information, see [Mapping data source fields].
//
// [Mapping data source fields]: https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html
// [UpdateDataSource]: https://docs.aws.amazon.com/kendra/latest/APIReference/API_UpdateDataSource.html
// [CreateDataSource]: https://docs.aws.amazon.com/kendra/latest/APIReference/API_CreateDataSource.html
type DataSourceToIndexFieldMapping struct {

	// The name of the field in the data source. You must first create the index field
	// using the UpdateIndex API.
	//
	// This member is required.
	DataSourceFieldName *string

	// The name of the index field to map to the data source field. The index field
	// type must match the data source field type.
	//
	// This member is required.
	IndexFieldName *string

	// The format for date fields in the data source. If the field specified in
	// DataSourceFieldName is a date field, you must specify the date format. If the
	// field is not a date field, an exception is thrown.
	DateFieldFormat *string

	noSmithyDocumentSerde
}

// Provides the configuration information to connect to an Amazon VPC.
type DataSourceVpcConfiguration struct {

	// A list of identifiers of security groups within your Amazon VPC. The security
	// groups should enable Amazon Kendra to connect to the data source.
	//
	// This member is required.
	SecurityGroupIds []string

	// A list of identifiers for subnets within your Amazon VPC. The subnets should be
	// able to connect to each other in the VPC, and they should have outgoing access
	// to the Internet through a NAT device.
	//
	// This member is required.
	SubnetIds []string

	noSmithyDocumentSerde
}

// A document in an index.
type Document struct {

	// A identifier of the document in the index.
	//
	// Note, each document ID must be unique per index. You cannot create a data
	// source to index your documents with their unique IDs and then use the
	// BatchPutDocument API to index the same documents, or vice versa. You can delete
	// a data source and then use the BatchPutDocument API to index the same
	// documents, or vice versa.
	//
	// This member is required.
	Id *string

	// The identifier of the access control configuration that you want to apply to
	// the document.
	AccessControlConfigurationId *string

	// Information on principals (users and/or groups) and which documents they should
	// have access to. This is useful for user context filtering, where search results
	// are filtered based on the user or their group access to documents.
	AccessControlList []Principal

	// Custom attributes to apply to the document. Use the custom attributes to
	// provide additional information for searching, to provide facets for refining
	// searches, and to provide additional information in the query response.
	//
	// For example, 'DataSourceId' and 'DataSourceSyncJobId' are custom attributes
	// that provide information on the synchronization of documents running on a data
	// source. Note, 'DataSourceSyncJobId' could be an optional custom attribute as
	// Amazon Kendra will use the ID of a running sync job.
	Attributes []DocumentAttribute

	// The contents of the document.
	//
	// Documents passed to the Blob parameter must be base64 encoded. Your code might
	// not need to encode the document file bytes if you're using an Amazon Web
	// Services SDK to call Amazon Kendra APIs. If you are calling the Amazon Kendra
	// endpoint directly using REST, you must base64 encode the contents before
	// sending.
	Blob []byte

	// The file type of the document in the Blob field.
	//
	// If you want to index snippets or subsets of HTML documents instead of the
	// entirety of the HTML documents, you must add the HTML start and closing tags (
	// content ) around the content.
	ContentType ContentType

	// The list of [principal] lists that define the hierarchy for which documents users should
	// have access to.
	//
	// [principal]: https://docs.aws.amazon.com/kendra/latest/dg/API_Principal.html
	HierarchicalAccessControlList []HierarchicalPrincipal

	// Information required to find a specific file in an Amazon S3 bucket.
	S3Path *S3Path

	// The title of the document.
	Title *string

	noSmithyDocumentSerde
}

// A document attribute or metadata field. To create custom document attributes,
// see [Custom attributes].
//
// [Custom attributes]: https://docs.aws.amazon.com/kendra/latest/dg/custom-attributes.html
type DocumentAttribute struct {

	// The identifier for the attribute.
	//
	// This member is required.
	Key *string

	// The value of the attribute.
	//
	// This member is required.
	Value *DocumentAttributeValue

	noSmithyDocumentSerde
}

// The condition used for the target document attribute or metadata field when
// ingesting documents into Amazon Kendra. You use this with [DocumentAttributeTarget to apply the condition].
//
// For example, you can create the 'Department' target field and have it prefill
// department names associated with the documents based on information in the
// 'Source_URI' field. Set the condition that if the 'Source_URI' field contains
// 'financial' in its URI value, then prefill the target field 'Department' with
// the target value 'Finance' for the document.
//
// Amazon Kendra cannot create a target field if it has not already been created
// as an index field. After you create your index field, you can create a document
// metadata field using DocumentAttributeTarget . Amazon Kendra then will map your
// newly created metadata field to your index field.
//
// [DocumentAttributeTarget to apply the condition]: https://docs.aws.amazon.com/kendra/latest/dg/API_DocumentAttributeTarget.html
type DocumentAttributeCondition struct {

	// The identifier of the document attribute used for the condition.
	//
	// For example, 'Source_URI' could be an identifier for the attribute or metadata
	// field that contains source URIs associated with the documents.
	//
	// Amazon Kendra currently does not support _document_body as an attribute key
	// used for the condition.
	//
	// This member is required.
	ConditionDocumentAttributeKey *string

	// The condition operator.
	//
	// For example, you can use 'Contains' to partially match a string.
	//
	// This member is required.
	Operator ConditionOperator

	// The value used by the operator.
	//
	// For example, you can specify the value 'financial' for strings in the
	// 'Source_URI' field that partially match or contain this value.
	ConditionOnValue *DocumentAttributeValue

	noSmithyDocumentSerde
}

// The target document attribute or metadata field you want to alter when
// ingesting documents into Amazon Kendra.
//
// For example, you can delete customer identification numbers associated with the
// documents, stored in the document metadata field called 'Customer_ID'. You set
// the target key as 'Customer_ID' and the deletion flag to TRUE . This removes all
// customer ID values in the field 'Customer_ID'. This would scrub personally
// identifiable information from each document's metadata.
//
// Amazon Kendra cannot create a target field if it has not already been created
// as an index field. After you create your index field, you can create a document
// metadata field using DocumentAttributeTarget . Amazon Kendra then will map your
// newly created metadata field to your index field.
//
// You can also use this with [DocumentAttributeCondition].
//
// [DocumentAttributeCondition]: https://docs.aws.amazon.com/kendra/latest/dg/API_DocumentAttributeCondition.html
type DocumentAttributeTarget struct {

	// The identifier of the target document attribute or metadata field.
	//
	// For example, 'Department' could be an identifier for the target attribute or
	// metadata field that includes the department names associated with the documents.
	TargetDocumentAttributeKey *string

	// The target value you want to create for the target attribute.
	//
	// For example, 'Finance' could be the target value for the target attribute key
	// 'Department'.
	TargetDocumentAttributeValue *DocumentAttributeValue

	// TRUE to delete the existing target value for your specified target attribute
	// key. You cannot create a target value and set this to TRUE . To create a target
	// value ( TargetDocumentAttributeValue ), set this to FALSE .
	TargetDocumentAttributeValueDeletion bool

	noSmithyDocumentSerde
}

// The value of a document attribute. You can only provide one value for a
// document attribute.
type DocumentAttributeValue struct {

	// A date expressed as an ISO 8601 string.
	//
	// It is important for the time zone to be included in the ISO 8601 date-time
	// format. For example, 2012-03-25T12:30:10+01:00 is the ISO 8601 date-time format
	// for March 25th 2012 at 12:30PM (plus 10 seconds) in Central European Time.
	DateValue *time.Time

	// A long integer value.
	LongValue *int64

	// A list of strings. The default maximum length or number of strings is 10.
	StringListValue []string

	// A string, such as "department".
	StringValue *string

	noSmithyDocumentSerde
}

// Provides the count of documents that match a particular document attribute or
// field when doing a faceted search.
type DocumentAttributeValueCountPair struct {

	// The number of documents in the response that have the attribute/field value for
	// the key.
	Count *int32

	// The value of the attribute/field. For example, "HR".
	DocumentAttributeValue *DocumentAttributeValue

	// Contains the results of a document attribute/field that is a nested facet. A
	// FacetResult contains the counts for each facet nested within a facet.
	//
	// For example, the document attribute or facet "Department" includes a value
	// called "Engineering". In addition, the document attribute or facet
	// "SubDepartment" includes the values "Frontend" and "Backend" for documents
	// assigned to "Engineering". You can display nested facets in the search results
	// so that documents can be searched not only by department but also by a sub
	// department within a department. The counts for documents that belong to
	// "Frontend" and "Backend" within "Engineering" are returned for a query.
	FacetResults []FacetResult

	noSmithyDocumentSerde
}

// Identifies a document for which to retrieve status information
type DocumentInfo struct {

	// The identifier of the document.
	//
	// This member is required.
	DocumentId *string

	// Attributes that identify a specific version of a document to check.
	//
	// The only valid attributes are:
	//
	//   - version
	//
	//   - datasourceId
	//
	//   - jobExecutionId
	//
	// The attributes follow these rules:
	//
	//   - dataSourceId and jobExecutionId must be used together.
	//
	//   - version is ignored if dataSourceId and jobExecutionId are not provided.
	//
	//   - If dataSourceId and jobExecutionId are provided, but version is not, the
	//   version defaults to "0".
	Attributes []DocumentAttribute

	noSmithyDocumentSerde
}

// Specifies the properties, such as relevance tuning and searchability, of an
// index field.
type DocumentMetadataConfiguration struct {

	// The name of the index field.
	//
	// This member is required.
	Name *string

	// The data type of the index field.
	//
	// This member is required.
	Type DocumentAttributeValueType

	// Provides tuning parameters to determine how the field affects the search
	// results.
	Relevance *Relevance

	// Provides information about how the field is used during a search.
	Search *Search

	noSmithyDocumentSerde
}

// Overrides the document relevance properties of a custom index field.
type DocumentRelevanceConfiguration struct {

	// The name of the index field.
	//
	// This member is required.
	Name *string

	// Provides information for tuning the relevance of a field in a search. When a
	// query includes terms that match the field, the results are given a boost in the
	// response based on these tuning parameters.
	//
	// This member is required.
	Relevance *Relevance

	noSmithyDocumentSerde
}

// Document metadata files that contain information such as the document access
// control information, source URI, document author, and custom attributes. Each
// metadata file contains metadata about a single document.
type DocumentsMetadataConfiguration struct {

	// A prefix used to filter metadata configuration files in the Amazon Web Services
	// S3 bucket. The S3 bucket might contain multiple metadata files. Use S3Prefix to
	// include only the desired metadata files.
	S3Prefix *string

	noSmithyDocumentSerde
}

// Provides the configuration information for users or groups in your IAM Identity
// Center identity source to grant access your Amazon Kendra experience.
type EntityConfiguration struct {

	// The identifier of a user or group in your IAM Identity Center identity source.
	// For example, a user ID could be an email.
	//
	// This member is required.
	EntityId *string

	// Specifies whether you are configuring a User or a Group .
	//
	// This member is required.
	EntityType EntityType

	noSmithyDocumentSerde
}

// Information about the user entity.
type EntityDisplayData struct {

	// The first name of the user.
	FirstName *string

	// The name of the group.
	GroupName *string

	// The user name of the user.
	IdentifiedUserName *string

	// The last name of the user.
	LastName *string

	// The name of the user.
	UserName *string

	noSmithyDocumentSerde
}

// Provides the configuration information for users or groups in your IAM Identity
// Center identity source for access to your Amazon Kendra experience. Specific
// permissions are defined for each user or group once they are granted access to
// your Amazon Kendra experience.
type EntityPersonaConfiguration struct {

	// The identifier of a user or group in your IAM Identity Center identity source.
	// For example, a user ID could be an email.
	//
	// This member is required.
	EntityId *string

	// The persona that defines the specific permissions of the user or group in your
	// IAM Identity Center identity source. The available personas or access roles are
	// Owner and Viewer . For more information on these personas, see [Providing access to your search page].
	//
	// [Providing access to your search page]: https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html#access-search-experience
	//
	// This member is required.
	Persona Persona

	noSmithyDocumentSerde
}

// Specifies the configuration information needed to customize how collapsed
// search result groups expand.
type ExpandConfiguration struct {

	// The number of expanded results to show per collapsed primary document. For
	// instance, if you set this value to 3, then at most 3 results per collapsed group
	// will be displayed.
	MaxExpandedResultsPerItem *int32

	// The number of collapsed search result groups to expand. If you set this value
	// to 10, for example, only the first 10 out of 100 result groups will have expand
	// functionality.
	MaxResultItemsToExpand *int32

	noSmithyDocumentSerde
}

//	A single expanded result in a collapsed group of search results.
//
// An expanded result item contains information about an expanded result document
// within a collapsed group of search results. This includes the original location
// of the document, a list of attributes assigned to the document, and relevant
// text from the document that satisfies the query.
type ExpandedResultItem struct {

	// An array of document attributes assigned to a document in the search results.
	// For example, the document author ("_author") or the source URI ("_source_uri")
	// of the document.
	DocumentAttributes []DocumentAttribute

	// Provides text and information about where to highlight the text.
	DocumentExcerpt *TextWithHighlights

	// The idenitifier of the document.
	DocumentId *string

	// Provides text and information about where to highlight the text.
	DocumentTitle *TextWithHighlights

	// The URI of the original location of the document.
	DocumentURI *string

	// The identifier for the expanded result.
	Id *string

	noSmithyDocumentSerde
}

// Provides the configuration information for your Amazon Kendra experience. This
// includes the data source IDs and/or FAQ IDs, and user or group information to
// grant access to your Amazon Kendra experience.
type ExperienceConfiguration struct {

	// The identifiers of your data sources and FAQs. Or, you can specify that you
	// want to use documents indexed via the BatchPutDocument API. This is the content
	// you want to use for your Amazon Kendra experience.
	ContentSourceConfiguration *ContentSourceConfiguration

	// The IAM Identity Center field name that contains the identifiers of your users,
	// such as their emails.
	UserIdentityConfiguration *UserIdentityConfiguration

	noSmithyDocumentSerde
}

// Provides the configuration information for the endpoint for your Amazon Kendra
// experience.
type ExperienceEndpoint struct {

	// The endpoint of your Amazon Kendra experience.
	Endpoint *string

	// The type of endpoint for your Amazon Kendra experience. The type currently
	// available is HOME , which is a unique and fully hosted URL to the home page of
	// your Amazon Kendra experience.
	EndpointType EndpointType

	noSmithyDocumentSerde
}

// Summary information for users or groups in your IAM Identity Center identity
// source with granted access to your Amazon Kendra experience. You can create an
// Amazon Kendra experience such as a search application. For more information on
// creating a search application experience, see [Building a search experience with no code].
//
// [Building a search experience with no code]: https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html
type ExperienceEntitiesSummary struct {

	// Information about the user entity.
	DisplayData *EntityDisplayData

	// The identifier of a user or group in your IAM Identity Center identity source.
	// For example, a user ID could be an email.
	EntityId *string

	// Shows the type as User or Group .
	EntityType EntityType

	noSmithyDocumentSerde
}

// Summary information for your Amazon Kendra experience. You can create an Amazon
// Kendra experience such as a search application. For more information on creating
// a search application experience, see [Building a search experience with no code].
//
// [Building a search experience with no code]: https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html
type ExperiencesSummary struct {

	// The Unix timestamp when your Amazon Kendra experience was created.
	CreatedAt *time.Time

	// The endpoint URLs for your Amazon Kendra experiences. The URLs are unique and
	// fully hosted by Amazon Web Services.
	Endpoints []ExperienceEndpoint

	// The identifier of your Amazon Kendra experience.
	Id *string

	// The name of your Amazon Kendra experience.
	Name *string

	// The processing status of your Amazon Kendra experience.
	Status ExperienceStatus

	noSmithyDocumentSerde
}

// Information about a document attribute or field. You can use document
// attributes as facets.
//
// For example, the document attribute or facet "Department" includes the values
// "HR", "Engineering", and "Accounting". You can display these values in the
// search results so that documents can be searched by department.
//
// You can display up to 10 facet values per facet for a query. If you want to
// increase this limit, contact [Support].
//
// [Support]: http://aws.amazon.com/contact-us/
type Facet struct {

	// The unique key for the document attribute.
	DocumentAttributeKey *string

	// An array of document attributes that are nested facets within a facet.
	//
	// For example, the document attribute or facet "Department" includes a value
	// called "Engineering". In addition, the document attribute or facet
	// "SubDepartment" includes the values "Frontend" and "Backend" for documents
	// assigned to "Engineering". You can display nested facets in the search results
	// so that documents can be searched not only by department but also by a sub
	// department within a department. This helps your users further narrow their
	// search.
	//
	// You can only have one nested facet within a facet. If you want to increase this
	// limit, contact [Support].
	//
	// [Support]: http://aws.amazon.com/contact-us/
	Facets []Facet

	// Maximum number of facet values per facet. The default is 10. You can use this
	// to limit the number of facet values to less than 10. If you want to increase the
	// default, contact [Support].
	//
	// [Support]: http://aws.amazon.com/contact-us/
	MaxResults int32

	noSmithyDocumentSerde
}

// The facet values for the documents in the response.
type FacetResult struct {

	// The key for the facet values. This is the same as the DocumentAttributeKey
	// provided in the query.
	DocumentAttributeKey *string

	// An array of key/value pairs, where the key is the value of the attribute and
	// the count is the number of documents that share the key value.
	DocumentAttributeValueCountPairs []DocumentAttributeValueCountPair

	// The data type of the facet value. This is the same as the type defined for the
	// index field when it was created.
	DocumentAttributeValueType DocumentAttributeValueType

	noSmithyDocumentSerde
}

// Information on the users or groups in your IAM Identity Center identity source
// that failed to properly configure with your Amazon Kendra experience.
type FailedEntity struct {

	// The identifier of the user or group in your IAM Identity Center identity
	// source. For example, a user ID could be an email.
	EntityId *string

	// The reason the user or group in your IAM Identity Center identity source failed
	// to properly configure with your Amazon Kendra experience.
	ErrorMessage *string

	noSmithyDocumentSerde
}

// Provides statistical information about the FAQ questions and answers for an
// index.
type FaqStatistics struct {

	// The total number of FAQ questions and answers for an index.
	//
	// This member is required.
	IndexedQuestionAnswersCount int32

	noSmithyDocumentSerde
}

// Summary information for frequently asked questions and answers included in an
// index.
type FaqSummary struct {

	// The Unix timestamp when the FAQ was created.
	CreatedAt *time.Time

	// The file type used to create the FAQ.
	FileFormat FaqFileFormat

	// The identifier of the FAQ.
	Id *string

	// The code for a language. This shows a supported language for the FAQ document
	// as part of the summary information for FAQs. English is supported by default.
	// For more information on supported languages, including their codes, see [Adding documents in languages other than English].
	//
	// [Adding documents in languages other than English]: https://docs.aws.amazon.com/kendra/latest/dg/in-adding-languages.html
	LanguageCode *string

	// The name that you assigned the FAQ when you created or updated the FAQ.
	Name *string

	// The current status of the FAQ. When the status is ACTIVE the FAQ is ready for
	// use.
	Status FaqStatus

	// The Unix timestamp when the FAQ was last updated.
	UpdatedAt *time.Time

	noSmithyDocumentSerde
}

// A featured document. This document is displayed at the top of the search
// results page, placed above all other results for certain queries. If there's an
// exact match of a query, then the document is featured in the search results.
type FeaturedDocument struct {

	// The identifier of the document to feature in the search results. You can use
	// the [Query]API to search for specific documents with their document IDs included in
	// the result items, or you can use the console.
	//
	// [Query]: https://docs.aws.amazon.com/kendra/latest/dg/API_Query.html
	Id *string

	noSmithyDocumentSerde
}

// A document ID doesn't exist but you have specified as a featured document.
// Amazon Kendra cannot feature the document if it doesn't exist in the index. You
// can check the status of a document and its ID or check for documents with status
// errors using the [BatchGetDocumentStatus]API.
//
// [BatchGetDocumentStatus]: https://docs.aws.amazon.com/kendra/latest/dg/API_BatchGetDocumentStatus.html
type FeaturedDocumentMissing struct {

	// The identifier of the document that doesn't exist but you have specified as a
	// featured document.
	Id *string

	noSmithyDocumentSerde
}

// A featured document with its metadata information. This document is displayed
// at the top of the search results page, placed above all other results for
// certain queries. If there's an exact match of a query, then the document is
// featured in the search results.
type FeaturedDocumentWithMetadata struct {

	// The identifier of the featured document with its metadata. You can use the [Query] API
	// to search for specific documents with their document IDs included in the result
	// items, or you can use the console.
	//
	// [Query]: https://docs.aws.amazon.com/kendra/latest/dg/API_Query.html
	Id *string

	// The main title of the featured document.
	Title *string

	// The source URI location of the featured document.
	URI *string

	noSmithyDocumentSerde
}

// A single featured result item. A featured result is displayed at the top of the
// search results page, placed above all other results for certain queries. If
// there's an exact match of a query, then certain documents are featured in the
// search results.
type FeaturedResultsItem struct {

	// One or more additional attributes associated with the featured result.
	AdditionalAttributes []AdditionalResultAttribute

	// An array of document attributes assigned to a featured document in the search
	// results. For example, the document author ( _author ) or the source URI (
	// _source_uri ) of the document.
	DocumentAttributes []DocumentAttribute

	// Provides text and information about where to highlight the text.
	DocumentExcerpt *TextWithHighlights

	// The identifier of the featured document.
	DocumentId *string

	// Provides text and information about where to highlight the text.
	DocumentTitle *TextWithHighlights

	// The source URI location of the featured document.
	DocumentURI *string

	// A token that identifies a particular featured result from a particular query.
	// Use this token to provide click-through feedback for the result. For more
	// information, see [Submitting feedback].
	//
	// [Submitting feedback]: https://docs.aws.amazon.com/kendra/latest/dg/submitting-feedback.html
	FeedbackToken *string

	// The identifier of the featured result.
	Id *string

	// The type of document within the featured result response. For example, a
	// response could include a question-answer type that's relevant to the query.
	Type QueryResultType

	noSmithyDocumentSerde
}

// A set of featured results that are displayed at the top of your search results.
// Featured results are placed above all other results for certain queries. If
// there's an exact match of a query, then one or more specific documents are
// featured in the search results.
type FeaturedResultsSet struct {

	// The Unix timestamp when the set of featured results was created.
	CreationTimestamp *int64

	// The description for the set of featured results.
	Description *string

	// The list of document IDs for the documents you want to feature at the top of
	// the search results page. You can use the [Query]API to search for specific documents
	// with their document IDs included in the result items, or you can use the
	// console.
	//
	// You can add up to four featured documents. You can request to increase this
	// limit by contacting [Support].
	//
	// Specific queries are mapped to specific documents for featuring in the results.
	// If a query contains an exact match, then one or more specific documents are
	// featured in the results. The exact match applies to the full query. For example,
	// if you only specify 'Kendra', queries such as 'How does kendra semantically rank
	// results?' will not render the featured results. Featured results are designed
	// for specific queries, rather than queries that are too broad in scope.
	//
	// [Query]: https://docs.aws.amazon.com/kendra/latest/dg/API_Query.html
	// [Support]: http://aws.amazon.com/contact-us/
	FeaturedDocuments []FeaturedDocument

	// The identifier of the set of featured results.
	FeaturedResultsSetId *string

	// The name for the set of featured results.
	FeaturedResultsSetName *string

	// The Unix timestamp when the set of featured results was last updated.
	LastUpdatedTimestamp *int64

	// The list of queries for featuring results.
	//
	// Specific queries are mapped to specific documents for featuring in the results.
	// If a query contains an exact match, then one or more specific documents are
	// featured in the results. The exact match applies to the full query. For example,
	// if you only specify 'Kendra', queries such as 'How does kendra semantically rank
	// results?' will not render the featured results. Featured results are designed
	// for specific queries, rather than queries that are too broad in scope.
	QueryTexts []string

	// The current status of the set of featured results. When the value is ACTIVE ,
	// featured results are ready for use. You can still configure your settings before
	// setting the status to ACTIVE . You can set the status to ACTIVE or INACTIVE
	// using the [UpdateFeaturedResultsSet]API. The queries you specify for featured results must be unique per
	// featured results set for each index, whether the status is ACTIVE or INACTIVE .
	//
	// [UpdateFeaturedResultsSet]: https://docs.aws.amazon.com/kendra/latest/dg/API_UpdateFeaturedResultsSet.html
	Status FeaturedResultsSetStatus

	noSmithyDocumentSerde
}

// Summary information for a set of featured results. Featured results are placed
// above all other results for certain queries. If there's an exact match of a
// query, then one or more specific documents are featured in the search results.
type FeaturedResultsSetSummary struct {

	// The Unix timestamp when the set of featured results was created.
	CreationTimestamp *int64

	// The identifier of the set of featured results.
	FeaturedResultsSetId *string

	// The name for the set of featured results.
	FeaturedResultsSetName *string

	// The Unix timestamp when the set of featured results was last updated.
	LastUpdatedTimestamp *int64

	// The current status of the set of featured results. When the value is ACTIVE ,
	// featured results are ready for use. You can still configure your settings before
	// setting the status to ACTIVE . You can set the status to ACTIVE or INACTIVE
	// using the [UpdateFeaturedResultsSet]API. The queries you specify for featured results must be unique per
	// featured results set for each index, whether the status is ACTIVE or INACTIVE .
	//
	// [UpdateFeaturedResultsSet]: https://docs.aws.amazon.com/kendra/latest/dg/API_UpdateFeaturedResultsSet.html
	Status FeaturedResultsSetStatus

	noSmithyDocumentSerde
}

// Provides the configuration information to connect to Amazon FSx as your data
// source.
//
// Amazon Kendra now supports an upgraded Amazon FSx Windows connector.
//
// You must now use the [TemplateConfiguration] object instead of the FsxConfiguration object to
// configure your connector.
//
// Connectors configured using the older console and API architecture will
// continue to function as configured. However, you won't be able to edit or update
// them. If you want to edit or update your connector configuration, you must
// create a new connector.
//
// We recommended migrating your connector workflow to the upgraded version.
// Support for connectors configured using the older architecture is scheduled to
// end by June 2024.
//
// [TemplateConfiguration]: https://docs.aws.amazon.com/kendra/latest/APIReference/API_TemplateConfiguration.html
type FsxConfiguration struct {

	// The identifier of the Amazon FSx file system.
	//
	// You can find your file system ID on the file system dashboard in the Amazon FSx
	// console. For information on how to create a file system in Amazon FSx console,
	// using Windows File Server as an example, see [Amazon FSx Getting started guide].
	//
	// [Amazon FSx Getting started guide]: https://docs.aws.amazon.com/fsx/latest/WindowsGuide/getting-started-step1.html
	//
	// This member is required.
	FileSystemId *string

	// The Amazon FSx file system type. Windows is currently the only supported type.
	//
	// This member is required.
	FileSystemType FsxFileSystemType

	// Configuration information for an Amazon Virtual Private Cloud to connect to
	// your Amazon FSx. Your Amazon FSx instance must reside inside your VPC.
	//
	// This member is required.
	VpcConfiguration *DataSourceVpcConfiguration

	// A list of regular expression patterns to exclude certain files in your Amazon
	// FSx file system. Files that match the patterns are excluded from the index.
	// Files that don't match the patterns are included in the index. If a file matches
	// both an inclusion and exclusion pattern, the exclusion pattern takes precedence
	// and the file isn't included in the index.
	ExclusionPatterns []string

	// A list of DataSourceToIndexFieldMapping objects that map Amazon FSx data source
	// attributes or field names to Amazon Kendra index field names. To create custom
	// fields, use the UpdateIndex API before you map to Amazon FSx fields. For more
	// information, see [Mapping data source fields]. The Amazon FSx data source field names must exist in your
	// Amazon FSx custom metadata.
	//
	// [Mapping data source fields]: https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html
	FieldMappings []DataSourceToIndexFieldMapping

	// A list of regular expression patterns to include certain files in your Amazon
	// FSx file system. Files that match the patterns are included in the index. Files
	// that don't match the patterns are excluded from the index. If a file matches
	// both an inclusion and exclusion pattern, the exclusion pattern takes precedence
	// and the file isn't included in the index.
	InclusionPatterns []string

	// The Amazon Resource Name (ARN) of an Secrets Manager secret that contains the
	// key-value pairs required to connect to your Amazon FSx file system. Windows is
	// currently the only supported type. The secret must contain a JSON structure with
	// the following keys:
	//
	//   - username—The Active Directory user name, along with the Domain Name System
	//   (DNS) domain name. For example, user@corp.example.com. The Active Directory user
	//   account must have read and mounting access to the Amazon FSx file system for
	//   Windows.
	//
	//   - password—The password of the Active Directory user account with read and
	//   mounting access to the Amazon FSx Windows file system.
	SecretArn *string

	noSmithyDocumentSerde
}

// Provides the configuration information to connect to GitHub as your data source.
//
// Amazon Kendra now supports an upgraded GitHub connector.
//
// You must now use the [TemplateConfiguration] object instead of the GitHubConfiguration object to
// configure your connector.
//
// Connectors configured using the older console and API architecture will
// continue to function as configured. However, you won’t be able to edit or update
// them. If you want to edit or update your connector configuration, you must
// create a new connector.
//
// We recommended migrating your connector workflow to the upgraded version.
// Support for connectors configured using the older architecture is scheduled to
// end by June 2024.
//
// [TemplateConfiguration]: https://docs.aws.amazon.com/kendra/latest/APIReference/API_TemplateConfiguration.html
type GitHubConfiguration struct {

	// The Amazon Resource Name (ARN) of an Secrets Manager secret that contains the
	// key-value pairs required to connect to your GitHub. The secret must contain a
	// JSON structure with the following keys:
	//
	//   - personalToken—The access token created in GitHub. For more information on
	//   creating a token in GitHub, see [Using a GitHub data source].
	//
	// [Using a GitHub data source]: https://docs.aws.amazon.com/kendra/latest/dg/data-source-github.html
	//
	// This member is required.
	SecretArn *string

	// A list of regular expression patterns to exclude certain file names in your
	// GitHub repository or repositories. File names that match the patterns are
	// excluded from the index. File names that don't match the patterns are included
	// in the index. If a file matches both an exclusion and inclusion pattern, the
	// exclusion pattern takes precedence and the file isn't included in the index.
	ExclusionFileNamePatterns []string

	// A list of regular expression patterns to exclude certain file types in your
	// GitHub repository or repositories. File types that match the patterns are
	// excluded from the index. File types that don't match the patterns are included
	// in the index. If a file matches both an exclusion and inclusion pattern, the
	// exclusion pattern takes precedence and the file isn't included in the index.
	ExclusionFileTypePatterns []string

	// A list of regular expression patterns to exclude certain folder names in your
	// GitHub repository or repositories. Folder names that match the patterns are
	// excluded from the index. Folder names that don't match the patterns are included
	// in the index. If a folder matches both an exclusion and inclusion pattern, the
	// exclusion pattern takes precedence and the folder isn't included in the index.
	ExclusionFolderNamePatterns []string

	// A list of DataSourceToIndexFieldMapping objects that map attributes or field
	// names of GitHub commits to Amazon Kendra index field names. To create custom
	// fields, use the UpdateIndex API before you map to GitHub fields. For more
	// information, see [Mapping data source fields]. The GitHub data source field names must exist in your GitHub
	// custom metadata.
	//
	// [Mapping data source fields]: https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html
	GitHubCommitConfigurationFieldMappings []DataSourceToIndexFieldMapping

	// Configuration information to include certain types of GitHub content. You can
	// configure to index repository files only, or also include issues and pull
	// requests, comments, and comment attachments.
	GitHubDocumentCrawlProperties *GitHubDocumentCrawlProperties

	// A list of DataSourceToIndexFieldMapping objects that map attributes or field
	// names of GitHub issue attachments to Amazon Kendra index field names. To create
	// custom fields, use the UpdateIndex API before you map to GitHub fields. For
	// more information, see [Mapping data source fields]. The GitHub data source field names must exist in your
	// GitHub custom metadata.
	//
	// [Mapping data source fields]: https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html
	GitHubIssueAttachmentConfigurationFieldMappings []DataSourceToIndexFieldMapping

	// A list of DataSourceToIndexFieldMapping objects that map attributes or field
	// names of GitHub issue comments to Amazon Kendra index field names. To create
	// custom fields, use the UpdateIndex API before you map to GitHub fields. For
	// more information, see [Mapping data source fields]. The GitHub data source field names must exist in your
	// GitHub custom metadata.
	//
	// [Mapping data source fields]: https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html
	GitHubIssueCommentConfigurationFieldMappings []DataSourceToIndexFieldMapping

	// A list of DataSourceToIndexFieldMapping objects that map attributes or field
	// names of GitHub issues to Amazon Kendra index field names. To create custom
	// fields, use the UpdateIndex API before you map to GitHub fields. For more
	// information, see [Mapping data source fields]. The GitHub data source field names must exist in your GitHub
	// custom metadata.
	//
	// [Mapping data source fields]: https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html
	GitHubIssueDocumentConfigurationFieldMappings []DataSourceToIndexFieldMapping

	// A list of DataSourceToIndexFieldMapping objects that map attributes or field
	// names of GitHub pull request comments to Amazon Kendra index field names. To
	// create custom fields, use the UpdateIndex API before you map to GitHub fields.
	// For more information, see [Mapping data source fields]. The GitHub data source field names must exist in
	// your GitHub custom metadata.
	//
	// [Mapping data source fields]: https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html
	GitHubPullRequestCommentConfigurationFieldMappings []DataSourceToIndexFieldMapping

	// A list of DataSourceToIndexFieldMapping objects that map attributes or field
	// names of GitHub pull request attachments to Amazon Kendra index field names. To
	// create custom fields, use the UpdateIndex API before you map to GitHub fields.
	// For more information, see [Mapping data source fields]. The GitHub data source field names must exist in
	// your GitHub custom metadata.
	//
	// [Mapping data source fields]: https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html
	GitHubPullRequestDocumentAttachmentConfigurationFieldMappings []DataSourceToIndexFieldMapping

	// A list of DataSourceToIndexFieldMapping objects that map attributes or field
	// names of GitHub pull requests to Amazon Kendra index field names. To create
	// custom fields, use the UpdateIndex API before you map to GitHub fields. For
	// more information, see [Mapping data source fields]. The GitHub data source field names must exist in your
	// GitHub custom metadata.
	//
	// [Mapping data source fields]: https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html
	GitHubPullRequestDocumentConfigurationFieldMappings []DataSourceToIndexFieldMapping

	// A list of DataSourceToIndexFieldMapping objects that map GitHub repository
	// attributes or field names to Amazon Kendra index field names. To create custom
	// fields, use the UpdateIndex API before you map to GitHub fields. For more
	// information, see [Mapping data source fields]. The GitHub data source field names must exist in your GitHub
	// custom metadata.
	//
	// [Mapping data source fields]: https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html
	GitHubRepositoryConfigurationFieldMappings []DataSourceToIndexFieldMapping

	// A list of regular expression patterns to include certain file names in your
	// GitHub repository or repositories. File names that match the patterns are
	// included in the index. File names that don't match the patterns are excluded
	// from the index. If a file matches both an inclusion and exclusion pattern, the
	// exclusion pattern takes precedence and the file isn't included in the index.
	InclusionFileNamePatterns []string

	// A list of regular expression patterns to include certain file types in your
	// GitHub repository or repositories. File types that match the patterns are
	// included in the index. File types that don't match the patterns are excluded
	// from the index. If a file matches both an inclusion and exclusion pattern, the
	// exclusion pattern takes precedence and the file isn't included in the index.
	InclusionFileTypePatterns []string

	// A list of regular expression patterns to include certain folder names in your
	// GitHub repository or repositories. Folder names that match the patterns are
	// included in the index. Folder names that don't match the patterns are excluded
	// from the index. If a folder matches both an inclusion and exclusion pattern, the
	// exclusion pattern takes precedence and the folder isn't included in the index.
	InclusionFolderNamePatterns []string

	// Configuration information to connect to GitHub Enterprise Server (on premises).
	OnPremiseConfiguration *OnPremiseConfiguration

	// A list of names of the specific repositories you want to index.
	RepositoryFilter []string

	// Configuration information to connect to GitHub Enterprise Cloud (SaaS).
	SaaSConfiguration *SaaSConfiguration

	// The type of GitHub service you want to connect to—GitHub Enterprise Cloud
	// (SaaS) or GitHub Enterprise Server (on premises).
	Type Type

	// TRUE to use the GitHub change log to determine which documents require updating
	// in the index. Depending on the GitHub change log's size, it may take longer for
	// Amazon Kendra to use the change log than to scan all of your documents in
	// GitHub.
	UseChangeLog bool

	// Configuration information of an Amazon Virtual Private Cloud to connect to your
	// GitHub. For more information, see [Configuring a VPC].
	//
	// [Configuring a VPC]: https://docs.aws.amazon.com/kendra/latest/dg/vpc-configuration.html
	VpcConfiguration *DataSourceVpcConfiguration

	noSmithyDocumentSerde
}

// Provides the configuration information to include certain types of GitHub
// content. You can configure to index repository files only, or also include
// issues and pull requests, comments, and comment attachments.
type GitHubDocumentCrawlProperties struct {

	// TRUE to index all issues within a repository.
	CrawlIssue bool

	// TRUE to index all comments on issues.
	CrawlIssueComment bool

	// TRUE to include all comment attachments for issues.
	CrawlIssueCommentAttachment bool

	// TRUE to index all pull requests within a repository.
	CrawlPullRequest bool

	// TRUE to index all comments on pull requests.
	CrawlPullRequestComment bool

	// TRUE to include all comment attachments for pull requests.
	CrawlPullRequestCommentAttachment bool

	// TRUE to index all files with a repository.
	CrawlRepositoryDocuments bool

	noSmithyDocumentSerde
}

// Provides the configuration information to connect to Google Drive as your data
// source.
type GoogleDriveConfiguration struct {

	// The Amazon Resource Name (ARN) of a Secrets Managersecret that contains the
	// credentials required to connect to Google Drive. For more information, see [Using a Google Workspace Drive data source].
	//
	// [Using a Google Workspace Drive data source]: https://docs.aws.amazon.com/kendra/latest/dg/data-source-google-drive.html
	//
	// This member is required.
	SecretArn *string

	// A list of MIME types to exclude from the index. All documents matching the
	// specified MIME type are excluded.
	//
	// For a list of MIME types, see [Using a Google Workspace Drive data source].
	//
	// [Using a Google Workspace Drive data source]: https://docs.aws.amazon.com/kendra/latest/dg/data-source-google-drive.html
	ExcludeMimeTypes []string

	// A list of identifiers or shared drives to exclude from the index. All files and
	// folders stored on the shared drive are excluded.
	ExcludeSharedDrives []string

	// A list of email addresses of the users. Documents owned by these users are
	// excluded from the index. Documents shared with excluded users are indexed unless
	// they are excluded in another way.
	ExcludeUserAccounts []string

	// A list of regular expression patterns to exclude certain items in your Google
	// Drive, including shared drives and users' My Drives. Items that match the
	// patterns are excluded from the index. Items that don't match the patterns are
	// included in the index. If an item matches both an inclusion and exclusion
	// pattern, the exclusion pattern takes precedence and the item isn't included in
	// the index.
	ExclusionPatterns []string

	// Maps Google Drive data source attributes or field names to Amazon Kendra index
	// field names. To create custom fields, use the UpdateIndex API before you map to
	// Google Drive fields. For more information, see [Mapping data source fields]. The Google Drive data source
	// field names must exist in your Google Drive custom metadata.
	//
	// [Mapping data source fields]: https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html
	FieldMappings []DataSourceToIndexFieldMapping

	// A list of regular expression patterns to include certain items in your Google
	// Drive, including shared drives and users' My Drives. Items that match the
	// patterns are included in the index. Items that don't match the patterns are
	// excluded from the index. If an item matches both an inclusion and exclusion
	// pattern, the exclusion pattern takes precedence and the item isn't included in
	// the index.
	InclusionPatterns []string

	noSmithyDocumentSerde
}

// A list of users that belong to a group. This is useful for user context
// filtering, where search results are filtered based on the user or their group
// access to documents.
type GroupMembers struct {

	// A list of users that belong to a group. This can also include sub groups. For
	// example, the sub groups "Research", "Engineering", and "Sales and Marketing" all
	// belong to the group "Company A".
	MemberGroups []MemberGroup

	// A list of users that belong to a group. For example, a list of interns all
	// belong to the "Interns" group.
	MemberUsers []MemberUser

	// If you have more than 1000 users and/or sub groups for a single group, you need
	// to provide the path to the S3 file that lists your users and sub groups for a
	// group. Your sub groups can contain more than 1000 users, but the list of sub
	// groups that belong to a group (and/or users) must be no more than 1000.
	//
	// You can download this [example S3 file] that uses the correct format for listing group members.
	// Note, dataSourceId is optional. The value of type for a group is always GROUP
	// and for a user it is always USER .
	//
	// [example S3 file]: https://docs.aws.amazon.com/kendra/latest/dg/samples/group_members.zip
	S3PathforGroupMembers *S3Path

	noSmithyDocumentSerde
}

// Summary information on the processing of PUT and DELETE actions for mapping
// users to their groups.
type GroupOrderingIdSummary struct {

	// The reason an action could not be processed. An action can be a PUT or DELETE
	// action for mapping users to their groups.
	FailureReason *string

	// The Unix timestamp when an action was last updated. An action can be a PUT or
	// DELETE action for mapping users to their groups.
	LastUpdatedAt *time.Time

	// The order in which actions should complete processing. An action can be a PUT
	// or DELETE action for mapping users to their groups.
	OrderingId *int64

	// The Unix timestamp when an action was received by Amazon Kendra. An action can
	// be a PUT or DELETE action for mapping users to their groups.
	ReceivedAt *time.Time

	// The current processing status of actions for mapping users to their groups. The
	// status can be either PROCESSING , SUCCEEDED , DELETING , DELETED , or FAILED .
	Status PrincipalMappingStatus

	noSmithyDocumentSerde
}

// Summary information for groups.
type GroupSummary struct {

	// The identifier of the group you want group summary information on.
	GroupId *string

	// The timestamp identifier used for the latest PUT or DELETE action.
	OrderingId *int64

	noSmithyDocumentSerde
}

//	Information to define the hierarchy for which documents users should have
//
// access to.
type HierarchicalPrincipal struct {

	// A list of [principal] lists that define the hierarchy for which documents users should
	// have access to. Each hierarchical list specifies which user or group has allow
	// or deny access for each document.
	//
	// [principal]: https://docs.aws.amazon.com/kendra/latest/dg/API_Principal.html
	//
	// This member is required.
	PrincipalList []Principal

	noSmithyDocumentSerde
}

// Provides information that you can use to highlight a search result so that your
// users can quickly identify terms in the response.
type Highlight struct {

	// The zero-based location in the response string where the highlight starts.
	//
	// This member is required.
	BeginOffset *int32

	// The zero-based location in the response string where the highlight ends.
	//
	// This member is required.
	EndOffset *int32

	// Indicates whether the response is the best response. True if this is the best
	// response; otherwise, false.
	TopAnswer bool

	// The highlight type.
	Type HighlightType

	noSmithyDocumentSerde
}

// Provides the configuration information for invoking a Lambda function in Lambda
// to alter document metadata and content when ingesting documents into Amazon
// Kendra. You can configure your Lambda function using [PreExtractionHookConfiguration]if you want to apply
// advanced alterations on the original or raw documents. If you want to apply
// advanced alterations on the Amazon Kendra structured documents, you must
// configure your Lambda function using [PostExtractionHookConfiguration]. You can only invoke one Lambda function.
// However, this function can invoke other functions it requires.
//
// For more information, see [Customizing document metadata during the ingestion process].
//
// [Customizing document metadata during the ingestion process]: https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html
// [PreExtractionHookConfiguration]: https://docs.aws.amazon.com/kendra/latest/dg/API_CustomDocumentEnrichmentConfiguration.html
// [PostExtractionHookConfiguration]: https://docs.aws.amazon.com/kendra/latest/dg/API_CustomDocumentEnrichmentConfiguration.html
type HookConfiguration struct {

	// The Amazon Resource Name (ARN) of an IAM role with permission to run a Lambda
	// function during ingestion. For more information, see [an IAM roles for Amazon Kendra].
	//
	// [an IAM roles for Amazon Kendra]: https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html
	//
	// This member is required.
	LambdaArn *string

	// Stores the original, raw documents or the structured, parsed documents before
	// and after altering them. For more information, see [Data contracts for Lambda functions].
	//
	// [Data contracts for Lambda functions]: https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html#cde-data-contracts-lambda
	//
	// This member is required.
	S3Bucket *string

	// The condition used for when a Lambda function should be invoked.
	//
	// For example, you can specify a condition that if there are empty date-time
	// values, then Amazon Kendra should invoke a function that inserts the current
	// date-time.
	InvocationCondition *DocumentAttributeCondition

	noSmithyDocumentSerde
}

// Summary information on the configuration of an index.
type IndexConfigurationSummary struct {

	// The Unix timestamp when the index was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The current status of the index. When the status is ACTIVE , the index is ready
	// to search.
	//
	// This member is required.
	Status IndexStatus

	// The Unix timestamp when the index was last updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	// Indicates whether the index is a Enterprise Edition index or a Developer
	// Edition index.
	Edition IndexEdition

	// A identifier for the index. Use this to identify the index when you are using
	// APIs such as Query , DescribeIndex , UpdateIndex , and DeleteIndex .
	Id *string

	// The name of the index.
	Name *string

	noSmithyDocumentSerde
}

// Provides information about the number of documents and the number of questions
// and answers in an index.
type IndexStatistics struct {

	// The number of question and answer topics in the index.
	//
	// This member is required.
	FaqStatistics *FaqStatistics

	// The number of text documents indexed.
	//
	// This member is required.
	TextDocumentStatistics *TextDocumentStatistics

	noSmithyDocumentSerde
}

// Provides the configuration information for applying basic logic to alter
// document metadata and content when ingesting documents into Amazon Kendra. To
// apply advanced logic, to go beyond what you can do with basic logic, see [HookConfiguration].
//
// For more information, see [Customizing document metadata during the ingestion process].
//
// [Customizing document metadata during the ingestion process]: https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html
// [HookConfiguration]: https://docs.aws.amazon.com/kendra/latest/dg/API_HookConfiguration.html
type InlineCustomDocumentEnrichmentConfiguration struct {

	// Configuration of the condition used for the target document attribute or
	// metadata field when ingesting documents into Amazon Kendra.
	Condition *DocumentAttributeCondition

	// TRUE to delete content if the condition used for the target attribute is met.
	DocumentContentDeletion bool

	// Configuration of the target document attribute or metadata field when ingesting
	// documents into Amazon Kendra. You can also include a value.
	Target *DocumentAttributeTarget

	noSmithyDocumentSerde
}

// Provides the configuration information to connect to Jira as your data source.
type JiraConfiguration struct {

	// The URL of the Jira account. For example, company.atlassian.net.
	//
	// This member is required.
	JiraAccountUrl *string

	// The Amazon Resource Name (ARN) of a secret in Secrets Manager contains the
	// key-value pairs required to connect to your Jira data source. The secret must
	// contain a JSON structure with the following keys:
	//
	//   - jiraId—The Jira user name or email.
	//
	//   - jiraCredentials—The Jira API token. For more information, see [Using a Jira data source].
	//
	// [Using a Jira data source]: https://docs.aws.amazon.com/kendra/latest/dg/data-source-jira.html
	//
	// This member is required.
	SecretArn *string

	// A list of DataSourceToIndexFieldMapping objects that map attributes or field
	// names of Jira attachments to Amazon Kendra index field names. To create custom
	// fields, use the UpdateIndex API before you map to Jira fields. For more
	// information, see [Mapping data source fields]. The Jira data source field names must exist in your Jira
	// custom metadata.
	//
	// [Mapping data source fields]: https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html
	AttachmentFieldMappings []DataSourceToIndexFieldMapping

	// A list of DataSourceToIndexFieldMapping objects that map attributes or field
	// names of Jira comments to Amazon Kendra index field names. To create custom
	// fields, use the UpdateIndex API before you map to Jira fields. For more
	// information, see [Mapping data source fields]. The Jira data source field names must exist in your Jira
	// custom metadata.
	//
	// [Mapping data source fields]: https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html
	CommentFieldMappings []DataSourceToIndexFieldMapping

	// A list of regular expression patterns to exclude certain file paths, file
	// names, and file types in your Jira data source. Files that match the patterns
	// are excluded from the index. Files that don’t match the patterns are included in
	// the index. If a file matches both an inclusion pattern and an exclusion pattern,
	// the exclusion pattern takes precedence and the file isn't included in the index.
	ExclusionPatterns []string

	// A list of regular expression patterns to include certain file paths, file
	// names, and file types in your Jira data source. Files that match the patterns
	// are included in the index. Files that don't match the patterns are excluded from
	// the index. If a file matches both an inclusion pattern and an exclusion pattern,
	// the exclusion pattern takes precedence and the file isn't included in the index.
	InclusionPatterns []string

	// A list of DataSourceToIndexFieldMapping objects that map attributes or field
	// names of Jira issues to Amazon Kendra index field names. To create custom
	// fields, use the UpdateIndex API before you map to Jira fields. For more
	// information, see [Mapping data source fields]. The Jira data source field names must exist in your Jira
	// custom metadata.
	//
	// [Mapping data source fields]: https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html
	IssueFieldMappings []DataSourceToIndexFieldMapping

	// Specify whether to crawl comments, attachments, and work logs. You can specify
	// one or more of these options.
	IssueSubEntityFilter []IssueSubEntity

	// Specify which issue types to crawl in your Jira data source. You can specify
	// one or more of these options to crawl.
	IssueType []string

	// Specify which projects to crawl in your Jira data source. You can specify one
	// or more Jira project IDs.
	Project []string

	// A list of DataSourceToIndexFieldMapping objects that map attributes or field
	// names of Jira projects to Amazon Kendra index field names. To create custom
	// fields, use the UpdateIndex API before you map to Jira fields. For more
	// information, see [Mapping data source fields]. The Jira data source field names must exist in your Jira
	// custom metadata.
	//
	// [Mapping data source fields]: https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html
	ProjectFieldMappings []DataSourceToIndexFieldMapping

	// Specify which statuses to crawl in your Jira data source. You can specify one
	// or more of these options to crawl.
	Status []string

	// TRUE to use the Jira change log to determine which documents require updating
	// in the index. Depending on the change log's size, it may take longer for Amazon
	// Kendra to use the change log than to scan all of your documents in Jira.
	UseChangeLog bool

	// Configuration information for an Amazon Virtual Private Cloud to connect to
	// your Jira. For more information, see [Configuring a VPC].
	//
	// [Configuring a VPC]: https://docs.aws.amazon.com/kendra/latest/dg/vpc-configuration.html
	VpcConfiguration *DataSourceVpcConfiguration

	// A list of DataSourceToIndexFieldMapping objects that map attributes or field
	// names of Jira work logs to Amazon Kendra index field names. To create custom
	// fields, use the UpdateIndex API before you map to Jira fields. For more
	// information, see [Mapping data source fields]. The Jira data source field names must exist in your Jira
	// custom metadata.
	//
	// [Mapping data source fields]: https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html
	WorkLogFieldMappings []DataSourceToIndexFieldMapping

	noSmithyDocumentSerde
}

// Provides the configuration information for the JSON token type.
type JsonTokenTypeConfiguration struct {

	// The group attribute field.
	//
	// This member is required.
	GroupAttributeField *string

	// The user name attribute field.
	//
	// This member is required.
	UserNameAttributeField *string

	noSmithyDocumentSerde
}

// Provides the configuration information for the JWT token type.
type JwtTokenTypeConfiguration struct {

	// The location of the key.
	//
	// This member is required.
	KeyLocation KeyLocation

	// The regular expression that identifies the claim.
	ClaimRegex *string

	// The group attribute field.
	GroupAttributeField *string

	// The issuer of the token.
	Issuer *string

	// The Amazon Resource Name (arn) of the secret.
	SecretManagerArn *string

	// The signing key URL.
	URL *string

	// The user name attribute field.
	UserNameAttributeField *string

	noSmithyDocumentSerde
}

// The sub groups that belong to a group.
type MemberGroup struct {

	// The identifier of the sub group you want to map to a group.
	//
	// This member is required.
	GroupId *string

	// The identifier of the data source for the sub group you want to map to a group.
	DataSourceId *string

	noSmithyDocumentSerde
}

// The users that belong to a group.
type MemberUser struct {

	// The identifier of the user you want to map to a group.
	//
	// This member is required.
	UserId *string

	noSmithyDocumentSerde
}

// Provides the configuration information to connect to OneDrive as your data
// source.
type OneDriveConfiguration struct {

	// A list of user accounts whose documents should be indexed.
	//
	// This member is required.
	OneDriveUsers *OneDriveUsers

	// The Amazon Resource Name (ARN) of an Secrets Managersecret that contains the
	// user name and password to connect to OneDrive. The user name should be the
	// application ID for the OneDrive application, and the password is the application
	// key for the OneDrive application.
	//
	// This member is required.
	SecretArn *string

	// The Azure Active Directory domain of the organization.
	//
	// This member is required.
	TenantDomain *string

	// TRUE to disable local groups information.
	DisableLocalGroups bool

	// A list of regular expression patterns to exclude certain documents in your
	// OneDrive. Documents that match the patterns are excluded from the index.
	// Documents that don't match the patterns are included in the index. If a document
	// matches both an inclusion and exclusion pattern, the exclusion pattern takes
	// precedence and the document isn't included in the index.
	//
	// The pattern is applied to the file name.
	ExclusionPatterns []string

	// A list of DataSourceToIndexFieldMapping objects that map OneDrive data source
	// attributes or field names to Amazon Kendra index field names. To create custom
	// fields, use the UpdateIndex API before you map to OneDrive fields. For more
	// information, see [Mapping data source fields]. The OneDrive data source field names must exist in your
	// OneDrive custom metadata.
	//
	// [Mapping data source fields]: https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html
	FieldMappings []DataSourceToIndexFieldMapping

	// A list of regular expression patterns to include certain documents in your
	// OneDrive. Documents that match the patterns are included in the index. Documents
	// that don't match the patterns are excluded from the index. If a document matches
	// both an inclusion and exclusion pattern, the exclusion pattern takes precedence
	// and the document isn't included in the index.
	//
	// The pattern is applied to the file name.
	InclusionPatterns []string

	noSmithyDocumentSerde
}

// User accounts whose documents should be indexed.
type OneDriveUsers struct {

	// A list of users whose documents should be indexed. Specify the user names in
	// email format, for example, username@tenantdomain . If you need to index the
	// documents of more than 10 users, use the OneDriveUserS3Path field to specify
	// the location of a file containing a list of users.
	OneDriveUserList []string

	// The S3 bucket location of a file containing a list of users whose documents
	// should be indexed.
	OneDriveUserS3Path *S3Path

	noSmithyDocumentSerde
}

// Provides the configuration information to connect to GitHub Enterprise Server
// (on premises).
type OnPremiseConfiguration struct {

	// The GitHub host URL or API endpoint URL. For example,
	// https://on-prem-host-url/api/v3/
	//
	// This member is required.
	HostUrl *string

	// The name of the organization of the GitHub Enterprise Server (on-premises)
	// account you want to connect to. You can find your organization name by logging
	// into GitHub desktop and selecting Your organizations under your profile picture
	// dropdown.
	//
	// This member is required.
	OrganizationName *string

	// The path to the SSL certificate stored in an Amazon S3 bucket. You use this to
	// connect to GitHub if you require a secure SSL connection.
	//
	// You can simply generate a self-signed X509 certificate on any computer using
	// OpenSSL. For an example of using OpenSSL to create an X509 certificate, see [Create and sign an X509 certificate].
	//
	// [Create and sign an X509 certificate]: https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/configuring-https-ssl.html
	//
	// This member is required.
	SslCertificateS3Path *S3Path

	noSmithyDocumentSerde
}

// Summary information for users or groups in your IAM Identity Center identity
// source. This applies to users and groups with specific permissions that define
// their level of access to your Amazon Kendra experience. You can create an Amazon
// Kendra experience such as a search application. For more information on creating
// a search application experience, see [Building a search experience with no code].
//
// [Building a search experience with no code]: https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html
type PersonasSummary struct {

	// The Unix timestamp when the summary information was created.
	CreatedAt *time.Time

	// The identifier of a user or group in your IAM Identity Center identity source.
	// For example, a user ID could be an email.
	EntityId *string

	// The persona that defines the specific permissions of the user or group in your
	// IAM Identity Center identity source. The available personas or access roles are
	// Owner and Viewer . For more information on these personas, see [Providing access to your search page].
	//
	// [Providing access to your search page]: https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html#access-search-experience
	Persona Persona

	// The Unix timestamp when the summary information was last updated.
	UpdatedAt *time.Time

	noSmithyDocumentSerde
}

// Provides user and group information for [user context filtering].
//
// [user context filtering]: https://docs.aws.amazon.com/kendra/latest/dg/user-context-filter.html
type Principal struct {

	// Whether to allow or deny document access to the principal.
	//
	// This member is required.
	Access ReadAccessType

	// The name of the user or group.
	//
	// This member is required.
	Name *string

	// The type of principal.
	//
	// This member is required.
	Type PrincipalType

	// The identifier of the data source the principal should access documents from.
	DataSourceId *string

	noSmithyDocumentSerde
}

// Provides the configuration information for a web proxy to connect to website
// hosts.
type ProxyConfiguration struct {

	// The name of the website host you want to connect to via a web proxy server.
	//
	// For example, the host name of https://a.example.com/page1.html is
	// "a.example.com".
	//
	// This member is required.
	Host *string

	// The port number of the website host you want to connect to via a web proxy
	// server.
	//
	// For example, the port for https://a.example.com/page1.html is 443, the standard
	// port for HTTPS.
	//
	// This member is required.
	Port *int32

	// The Amazon Resource Name (ARN) of an Secrets Manager secret. You create a
	// secret to store your credentials in [Secrets Manager]
	//
	// The credentials are optional. You use a secret if web proxy credentials are
	// required to connect to a website host. Amazon Kendra currently support basic
	// authentication to connect to a web proxy server. The secret stores your
	// credentials.
	//
	// [Secrets Manager]: https://docs.aws.amazon.com/secretsmanager/latest/userguide/intro.html
	Credentials *string

	noSmithyDocumentSerde
}

// A single query result.
//
// A query result contains information about a document returned by the query.
// This includes the original location of the document, a list of attributes
// assigned to the document, and relevant text from the document that satisfies the
// query.
type QueryResultItem struct {

	// One or more additional fields/attributes associated with the query result.
	AdditionalAttributes []AdditionalResultAttribute

	// Provides details about a collapsed group of search results.
	CollapsedResultDetail *CollapsedResultDetail

	// An array of document fields/attributes assigned to a document in the search
	// results. For example, the document author ( _author ) or the source URI (
	// _source_uri ) of the document.
	DocumentAttributes []DocumentAttribute

	// An extract of the text in the document. Contains information about highlighting
	// the relevant terms in the excerpt.
	DocumentExcerpt *TextWithHighlights

	// The identifier for the document.
	DocumentId *string

	// The title of the document. Contains the text of the title and information for
	// highlighting the relevant terms in the title.
	DocumentTitle *TextWithHighlights

	// The URI of the original location of the document.
	DocumentURI *string

	// A token that identifies a particular result from a particular query. Use this
	// token to provide click-through feedback for the result. For more information,
	// see [Submitting feedback].
	//
	// [Submitting feedback]: https://docs.aws.amazon.com/kendra/latest/dg/submitting-feedback.html
	FeedbackToken *string

	// If the Type of document within the response is ANSWER , then it is either a
	// TABLE answer or TEXT answer. If it's a table answer, a table excerpt is
	// returned in TableExcerpt . If it's a text answer, a text excerpt is returned in
	// DocumentExcerpt .
	Format QueryResultFormat

	// The unique identifier for the query result item id ( Id ) and the query result
	// item document id ( DocumentId ) combined. The value of this field changes with
	// every request, even when you have the same documents.
	Id *string

	// Indicates the confidence level of Amazon Kendra providing a relevant result for
	// the query. Each result is placed into a bin that indicates the confidence,
	// VERY_HIGH , HIGH , MEDIUM and LOW . You can use the score to determine if a
	// response meets the confidence needed for your application.
	//
	// The field is only set to LOW when the Type field is set to DOCUMENT and Amazon
	// Kendra is not confident that the result is relevant to the query.
	ScoreAttributes *ScoreAttributes

	// An excerpt from a table within a document.
	TableExcerpt *TableExcerpt

	// The type of document within the response. For example, a response could include
	// a question-answer that's relevant to the query.
	Type QueryResultType

	noSmithyDocumentSerde
}

// Summary information on a query suggestions block list.
//
// This includes information on the block list ID, block list name, when the block
// list was created, when the block list was last updated, and the count of block
// words/phrases in the block list.
//
// For information on the current quota limits for block lists, see [Quotas for Amazon Kendra].
//
// [Quotas for Amazon Kendra]: https://docs.aws.amazon.com/kendra/latest/dg/quotas.html
type QuerySuggestionsBlockListSummary struct {

	// The Unix timestamp when the block list was created.
	CreatedAt *time.Time

	// The identifier of a block list.
	Id *string

	// The number of items in the block list file.
	ItemCount *int32

	// The name of the block list.
	Name *string

	// The status of the block list.
	Status QuerySuggestionsBlockListStatus

	// The Unix timestamp when the block list was last updated.
	UpdatedAt *time.Time

	noSmithyDocumentSerde
}

// Provides the configuration information to connect to Quip as your data source.
type QuipConfiguration struct {

	// The Quip site domain. For example, https://quip-company.quipdomain.com/browse.
	// The domain in this example is "quipdomain".
	//
	// This member is required.
	Domain *string

	// The Amazon Resource Name (ARN) of an Secrets Manager secret that contains the
	// key-value pairs that are required to connect to your Quip. The secret must
	// contain a JSON structure with the following keys:
	//
	//   - accessToken—The token created in Quip. For more information, see [Using a Quip data source].
	//
	// [Using a Quip data source]: https://docs.aws.amazon.com/kendra/latest/dg/data-source-slack.html
	//
	// This member is required.
	SecretArn *string

	// A list of DataSourceToIndexFieldMapping objects that map attributes or field
	// names of Quip attachments to Amazon Kendra index field names. To create custom
	// fields, use the UpdateIndex API before you map to Quip fields. For more
	// information, see [Mapping data source fields]. The Quip field names must exist in your Quip custom metadata.
	//
	// [Mapping data source fields]: https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html
	AttachmentFieldMappings []DataSourceToIndexFieldMapping

	// TRUE to index attachments.
	CrawlAttachments bool

	// TRUE to index the contents of chat rooms.
	CrawlChatRooms bool

	// TRUE to index file comments.
	CrawlFileComments bool

	// A list of regular expression patterns to exclude certain files in your Quip
	// file system. Files that match the patterns are excluded from the index. Files
	// that don’t match the patterns are included in the index. If a file matches both
	// an inclusion pattern and an exclusion pattern, the exclusion pattern takes
	// precedence, and the file isn't included in the index.
	ExclusionPatterns []string

	// The identifiers of the Quip folders you want to index. You can find the folder
	// ID in your browser URL when you access your folder in Quip. For example,
	// https://quip-company.quipdomain.com/zlLuOVNSarTL/folder-name. The folder ID in
	// this example is "zlLuOVNSarTL".
	FolderIds []string

	// A list of regular expression patterns to include certain files in your Quip
	// file system. Files that match the patterns are included in the index. Files that
	// don't match the patterns are excluded from the index. If a file matches both an
	// inclusion pattern and an exclusion pattern, the exclusion pattern takes
	// precedence, and the file isn't included in the index.
	InclusionPatterns []string

	// A list of DataSourceToIndexFieldMapping objects that map attributes or field
	// names of Quip messages to Amazon Kendra index field names. To create custom
	// fields, use the UpdateIndex API before you map to Quip fields. For more
	// information, see [Mapping data source fields]. The Quip field names must exist in your Quip custom metadata.
	//
	// [Mapping data source fields]: https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html
	MessageFieldMappings []DataSourceToIndexFieldMapping

	// A list of DataSourceToIndexFieldMapping objects that map attributes or field
	// names of Quip threads to Amazon Kendra index field names. To create custom
	// fields, use the UpdateIndex API before you map to Quip fields. For more
	// information, see [Mapping data source fields]. The Quip field names must exist in your Quip custom metadata.
	//
	// [Mapping data source fields]: https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html
	ThreadFieldMappings []DataSourceToIndexFieldMapping

	// Configuration information for an Amazon Virtual Private Cloud (VPC) to connect
	// to your Quip. For more information, see [Configuring a VPC].
	//
	// [Configuring a VPC]: https://docs.aws.amazon.com/kendra/latest/dg/vpc-configuration.html
	VpcConfiguration *DataSourceVpcConfiguration

	noSmithyDocumentSerde
}

// Provides information for tuning the relevance of a field in a search. When a
// query includes terms that match the field, the results are given a boost in the
// response based on these tuning parameters.
type Relevance struct {

	// Specifies the time period that the boost applies to. For example, to make the
	// boost apply to documents with the field value within the last month, you would
	// use "2628000s". Once the field value is beyond the specified range, the effect
	// of the boost drops off. The higher the importance, the faster the effect drops
	// off. If you don't specify a value, the default is 3 months. The value of the
	// field is a numeric string followed by the character "s", for example "86400s"
	// for one day, or "604800s" for one week.
	//
	// Only applies to DATE fields.
	Duration *string

	// Indicates that this field determines how "fresh" a document is. For example, if
	// document 1 was created on November 5, and document 2 was created on October 31,
	// document 1 is "fresher" than document 2. Only applies to DATE fields.
	Freshness *bool

	// The relative importance of the field in the search. Larger numbers provide more
	// of a boost than smaller numbers.
	Importance *int32

	// Determines how values should be interpreted.
	//
	// When the RankOrder field is ASCENDING , higher numbers are better. For example,
	// a document with a rating score of 10 is higher ranking than a document with a
	// rating score of 1.
	//
	// When the RankOrder field is DESCENDING , lower numbers are better. For example,
	// in a task tracking application, a priority 1 task is more important than a
	// priority 5 task.
	//
	// Only applies to LONG fields.
	RankOrder Order

	// A list of values that should be given a different boost when they appear in the
	// result list. For example, if you are boosting a field called "department", query
	// terms that match the department field are boosted in the result. However, you
	// can add entries from the department field to boost documents with those values
	// higher.
	//
	// For example, you can add entries to the map with names of departments. If you
	// add "HR",5 and "Legal",3 those departments are given special attention when they
	// appear in the metadata of a document. When those terms appear they are given the
	// specified importance instead of the regular importance for the boost.
	ValueImportanceMap map[string]int32

	noSmithyDocumentSerde
}

// Provides feedback on how relevant a document is to a search. Your application
// uses the SubmitFeedback API to provide relevance information.
type RelevanceFeedback struct {

	// Whether the document was relevant or not relevant to the search.
	//
	// This member is required.
	RelevanceValue RelevanceType

	// The identifier of the search result that the user provided relevance feedback
	// for.
	//
	// This member is required.
	ResultId *string

	noSmithyDocumentSerde
}

// A single retrieved relevant passage result.
type RetrieveResultItem struct {

	// The contents of the relevant passage.
	Content *string

	// An array of document fields/attributes assigned to a document in the search
	// results. For example, the document author ( _author ) or the source URI (
	// _source_uri ) of the document.
	DocumentAttributes []DocumentAttribute

	// The identifier of the document.
	DocumentId *string

	// The title of the document.
	DocumentTitle *string

	// The URI of the original location of the document.
	DocumentURI *string

	// The identifier of the relevant passage result.
	Id *string

	// The confidence score bucket for a retrieved passage result. The confidence
	// bucket provides a relative ranking that indicates how confident Amazon Kendra is
	// that the response is relevant to the query.
	ScoreAttributes *ScoreAttributes

	noSmithyDocumentSerde
}

// Provides the configuration information to connect to an Amazon S3 bucket.
//
// Amazon Kendra now supports an upgraded Amazon S3 connector.
//
// You must now use the [TemplateConfiguration] object instead of the S3DataSourceConfiguration object to
// configure your connector.
//
// Connectors configured using the older console and API architecture will
// continue to function as configured. However, you won't be able to edit or update
// them. If you want to edit or update your connector configuration, you must
// create a new connector.
//
// We recommended migrating your connector workflow to the upgraded version.
// Support for connectors configured using the older architecture is scheduled to
// end by June 2024.
//
// [TemplateConfiguration]: https://docs.aws.amazon.com/kendra/latest/APIReference/API_TemplateConfiguration.html
type S3DataSourceConfiguration struct {

	// The name of the bucket that contains the documents.
	//
	// This member is required.
	BucketName *string

	// Provides the path to the S3 bucket that contains the user context filtering
	// files for the data source. For the format of the file, see [Access control for S3 data sources].
	//
	// [Access control for S3 data sources]: https://docs.aws.amazon.com/kendra/latest/dg/s3-acl.html
	AccessControlListConfiguration *AccessControlListConfiguration

	// Document metadata files that contain information such as the document access
	// control information, source URI, document author, and custom attributes. Each
	// metadata file contains metadata about a single document.
	DocumentsMetadataConfiguration *DocumentsMetadataConfiguration

	// A list of glob patterns (patterns that can expand a wildcard pattern into a
	// list of path names that match the given pattern) for certain file names and file
	// types to exclude from your index. If a document matches both an inclusion and
	// exclusion prefix or pattern, the exclusion prefix takes precendence and the
	// document is not indexed. Examples of glob patterns include:
	//
	//   - /myapp/config/*—All files inside config directory.
	//
	//   - **/*.png—All .png files in all directories.
	//
	//   - **/*.{png, ico, md}—All .png, .ico or .md files in all directories.
	//
	//   - /myapp/src/**/*.ts—All .ts files inside src directory (and all its
	//   subdirectories).
	//
	//   - **/!(*.module).ts—All .ts files but not .module.ts
	//
	//   - *.png , *.jpg—All PNG and JPEG image files in a directory (files with the
	//   extensions .png and .jpg).
	//
	//   - *internal*—All files in a directory that contain 'internal' in the file
	//   name, such as 'internal', 'internal_only', 'company_internal'.
	//
	//   - **/*internal*—All internal-related files in a directory and its
	//   subdirectories.
	//
	// For more examples, see [Use of Exclude and Include Filters] in the Amazon Web Services CLI Command Reference.
	//
	// [Use of Exclude and Include Filters]: https://docs.aws.amazon.com/cli/latest/reference/s3/#use-of-exclude-and-include-filters
	ExclusionPatterns []string

	// A list of glob patterns (patterns that can expand a wildcard pattern into a
	// list of path names that match the given pattern) for certain file names and file
	// types to include in your index. If a document matches both an inclusion and
	// exclusion prefix or pattern, the exclusion prefix takes precendence and the
	// document is not indexed. Examples of glob patterns include:
	//
	//   - /myapp/config/*—All files inside config directory.
	//
	//   - **/*.png—All .png files in all directories.
	//
	//   - **/*.{png, ico, md}—All .png, .ico or .md files in all directories.
	//
	//   - /myapp/src/**/*.ts—All .ts files inside src directory (and all its
	//   subdirectories).
	//
	//   - **/!(*.module).ts—All .ts files but not .module.ts
	//
	//   - *.png , *.jpg—All PNG and JPEG image files in a directory (files with the
	//   extensions .png and .jpg).
	//
	//   - *internal*—All files in a directory that contain 'internal' in the file
	//   name, such as 'internal', 'internal_only', 'company_internal'.
	//
	//   - **/*internal*—All internal-related files in a directory and its
	//   subdirectories.
	//
	// For more examples, see [Use of Exclude and Include Filters] in the Amazon Web Services CLI Command Reference.
	//
	// [Use of Exclude and Include Filters]: https://docs.aws.amazon.com/cli/latest/reference/s3/#use-of-exclude-and-include-filters
	InclusionPatterns []string

	// A list of S3 prefixes for the documents that should be included in the index.
	InclusionPrefixes []string

	noSmithyDocumentSerde
}

// Information required to find a specific file in an Amazon S3 bucket.
type S3Path struct {

	// The name of the S3 bucket that contains the file.
	//
	// This member is required.
	Bucket *string

	// The name of the file.
	//
	// This member is required.
	Key *string

	noSmithyDocumentSerde
}

// Provides the configuration information to connect to GitHub Enterprise Cloud
// (SaaS).
type SaaSConfiguration struct {

	// The GitHub host URL or API endpoint URL. For example, https://api.github.com.
	//
	// This member is required.
	HostUrl *string

	// The name of the organization of the GitHub Enterprise Cloud (SaaS) account you
	// want to connect to. You can find your organization name by logging into GitHub
	// desktop and selecting Your organizations under your profile picture dropdown.
	//
	// This member is required.
	OrganizationName *string

	noSmithyDocumentSerde
}

// The configuration information for syncing a Salesforce chatter feed. The
// contents of the object comes from the Salesforce FeedItem table.
type SalesforceChatterFeedConfiguration struct {

	// The name of the column in the Salesforce FeedItem table that contains the
	// content to index. Typically this is the Body column.
	//
	// This member is required.
	DocumentDataFieldName *string

	// The name of the column in the Salesforce FeedItem table that contains the title
	// of the document. This is typically the Title column.
	DocumentTitleFieldName *string

	// Maps fields from a Salesforce chatter feed into Amazon Kendra index fields.
	FieldMappings []DataSourceToIndexFieldMapping

	// Filters the documents in the feed based on status of the user. When you specify
	// ACTIVE_USERS only documents from users who have an active account are indexed.
	// When you specify STANDARD_USER only documents for Salesforce standard users are
	// documented. You can specify both.
	IncludeFilterTypes []SalesforceChatterFeedIncludeFilterType

	noSmithyDocumentSerde
}

// Provides the configuration information to connect to Salesforce as your data
// source.
type SalesforceConfiguration struct {

	// The Amazon Resource Name (ARN) of an Secrets Managersecret that contains the
	// key/value pairs required to connect to your Salesforce instance. The secret must
	// contain a JSON structure with the following keys:
	//
	//   - authenticationUrl - The OAUTH endpoint that Amazon Kendra connects to get
	//   an OAUTH token.
	//
	//   - consumerKey - The application public key generated when you created your
	//   Salesforce application.
	//
	//   - consumerSecret - The application private key generated when you created
	//   your Salesforce application.
	//
	//   - password - The password associated with the user logging in to the
	//   Salesforce instance.
	//
	//   - securityToken - The token associated with the user logging in to the
	//   Salesforce instance.
	//
	//   - username - The user name of the user logging in to the Salesforce instance.
	//
	// This member is required.
	SecretArn *string

	// The instance URL for the Salesforce site that you want to index.
	//
	// This member is required.
	ServerUrl *string

	// Configuration information for Salesforce chatter feeds.
	ChatterFeedConfiguration *SalesforceChatterFeedConfiguration

	// Indicates whether Amazon Kendra should index attachments to Salesforce objects.
	CrawlAttachments bool

	// A list of regular expression patterns to exclude certain documents in your
	// Salesforce. Documents that match the patterns are excluded from the index.
	// Documents that don't match the patterns are included in the index. If a document
	// matches both an inclusion and exclusion pattern, the exclusion pattern takes
	// precedence and the document isn't included in the index.
	//
	// The pattern is applied to the name of the attached file.
	ExcludeAttachmentFilePatterns []string

	// A list of regular expression patterns to include certain documents in your
	// Salesforce. Documents that match the patterns are included in the index.
	// Documents that don't match the patterns are excluded from the index. If a
	// document matches both an inclusion and exclusion pattern, the exclusion pattern
	// takes precedence and the document isn't included in the index.
	//
	// The pattern is applied to the name of the attached file.
	IncludeAttachmentFilePatterns []string

	// Configuration information for the knowledge article types that Amazon Kendra
	// indexes. Amazon Kendra indexes standard knowledge articles and the standard
	// fields of knowledge articles, or the custom fields of custom knowledge articles,
	// but not both.
	KnowledgeArticleConfiguration *SalesforceKnowledgeArticleConfiguration

	// Configuration information for processing attachments to Salesforce standard
	// objects.
	StandardObjectAttachmentConfiguration *SalesforceStandardObjectAttachmentConfiguration

	// Configuration of the Salesforce standard objects that Amazon Kendra indexes.
	StandardObjectConfigurations []SalesforceStandardObjectConfiguration

	noSmithyDocumentSerde
}

// Provides the configuration information for indexing Salesforce custom articles.
type SalesforceCustomKnowledgeArticleTypeConfiguration struct {

	// The name of the field in the custom knowledge article that contains the
	// document data to index.
	//
	// This member is required.
	DocumentDataFieldName *string

	// The name of the configuration.
	//
	// This member is required.
	Name *string

	// The name of the field in the custom knowledge article that contains the
	// document title.
	DocumentTitleFieldName *string

	// Maps attributes or field names of the custom knowledge article to Amazon Kendra
	// index field names. To create custom fields, use the UpdateIndex API before you
	// map to Salesforce fields. For more information, see [Mapping data source fields]. The Salesforce data
	// source field names must exist in your Salesforce custom metadata.
	//
	// [Mapping data source fields]: https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html
	FieldMappings []DataSourceToIndexFieldMapping

	noSmithyDocumentSerde
}

// Provides the configuration information for the knowledge article types that
// Amazon Kendra indexes. Amazon Kendra indexes standard knowledge articles and the
// standard fields of knowledge articles, or the custom fields of custom knowledge
// articles, but not both
type SalesforceKnowledgeArticleConfiguration struct {

	// Specifies the document states that should be included when Amazon Kendra
	// indexes knowledge articles. You must specify at least one state.
	//
	// This member is required.
	IncludedStates []SalesforceKnowledgeArticleState

	// Configuration information for custom Salesforce knowledge articles.
	CustomKnowledgeArticleTypeConfigurations []SalesforceCustomKnowledgeArticleTypeConfiguration

	// Configuration information for standard Salesforce knowledge articles.
	StandardKnowledgeArticleTypeConfiguration *SalesforceStandardKnowledgeArticleTypeConfiguration

	noSmithyDocumentSerde
}

// Provides the configuration information for standard Salesforce knowledge
// articles.
type SalesforceStandardKnowledgeArticleTypeConfiguration struct {

	// The name of the field that contains the document data to index.
	//
	// This member is required.
	DocumentDataFieldName *string

	// The name of the field that contains the document title.
	DocumentTitleFieldName *string

	// Maps attributes or field names of the knowledge article to Amazon Kendra index
	// field names. To create custom fields, use the UpdateIndex API before you map to
	// Salesforce fields. For more information, see [Mapping data source fields]. The Salesforce data source field
	// names must exist in your Salesforce custom metadata.
	//
	// [Mapping data source fields]: https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html
	FieldMappings []DataSourceToIndexFieldMapping

	noSmithyDocumentSerde
}

// Provides the configuration information for processing attachments to Salesforce
// standard objects.
type SalesforceStandardObjectAttachmentConfiguration struct {

	// The name of the field used for the document title.
	DocumentTitleFieldName *string

	// One or more objects that map fields in attachments to Amazon Kendra index
	// fields.
	FieldMappings []DataSourceToIndexFieldMapping

	noSmithyDocumentSerde
}

// Provides the configuration information for indexing a single standard object.
type SalesforceStandardObjectConfiguration struct {

	// The name of the field in the standard object table that contains the document
	// contents.
	//
	// This member is required.
	DocumentDataFieldName *string

	// The name of the standard object.
	//
	// This member is required.
	Name SalesforceStandardObjectName

	// The name of the field in the standard object table that contains the document
	// title.
	DocumentTitleFieldName *string

	// Maps attributes or field names of the standard object to Amazon Kendra index
	// field names. To create custom fields, use the UpdateIndex API before you map to
	// Salesforce fields. For more information, see [Mapping data source fields]. The Salesforce data source field
	// names must exist in your Salesforce custom metadata.
	//
	// [Mapping data source fields]: https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html
	FieldMappings []DataSourceToIndexFieldMapping

	noSmithyDocumentSerde
}

// Provides a relative ranking that indicates how confident Amazon Kendra is that
// the response is relevant to the query.
type ScoreAttributes struct {

	// A relative ranking for how relevant the response is to the query.
	ScoreConfidence ScoreConfidence

	noSmithyDocumentSerde
}

// Provides information about how a custom index field is used during a search.
type Search struct {

	// Determines whether the field is returned in the query response. The default is
	// true .
	Displayable bool

	// Indicates that the field can be used to create search facets, a count of
	// results for each value in the field. The default is false .
	Facetable bool

	// Determines whether the field is used in the search. If the Searchable field is
	// true , you can use relevance tuning to manually tune how Amazon Kendra weights
	// the field in the search. The default is true for string fields and false for
	// number and date fields.
	Searchable bool

	// Determines whether the field can be used to sort the results of a query. If you
	// specify sorting on a field that does not have Sortable set to true , Amazon
	// Kendra returns an exception. The default is false .
	Sortable bool

	noSmithyDocumentSerde
}

// Provides the configuration information for the seed or starting point URLs to
// crawl.
//
// When selecting websites to index, you must adhere to the [Amazon Acceptable Use Policy] and all other Amazon
// terms. Remember that you must only use Amazon Kendra Web Crawler to index your
// own web pages, or web pages that you have authorization to index.
//
// [Amazon Acceptable Use Policy]: https://aws.amazon.com/aup/
type SeedUrlConfiguration struct {

	// The list of seed or starting point URLs of the websites you want to crawl.
	//
	// The list can include a maximum of 100 seed URLs.
	//
	// This member is required.
	SeedUrls []string

	// You can choose one of the following modes:
	//
	//   - HOST_ONLY —crawl only the website host names. For example, if the seed URL
	//   is "abc.example.com", then only URLs with host name "abc.example.com" are
	//   crawled.
	//
	//   - SUBDOMAINS —crawl the website host names with subdomains. For example, if
	//   the seed URL is "abc.example.com", then "a.abc.example.com" and
	//   "b.abc.example.com" are also crawled.
	//
	//   - EVERYTHING —crawl the website host names with subdomains and other domains
	//   that the web pages link to.
	//
	// The default mode is set to HOST_ONLY .
	WebCrawlerMode WebCrawlerMode

	noSmithyDocumentSerde
}

// Provides the identifier of the KMS key used to encrypt data indexed by Amazon
// Kendra. Amazon Kendra doesn't support asymmetric keys.
type ServerSideEncryptionConfiguration struct {

	// The identifier of the KMS key. Amazon Kendra doesn't support asymmetric keys.
	KmsKeyId *string

	noSmithyDocumentSerde
}

// Provides the configuration information to connect to ServiceNow as your data
// source.
type ServiceNowConfiguration struct {

	// The ServiceNow instance that the data source connects to. The host endpoint
	// should look like the following: {instance}.service-now.com.
	//
	// This member is required.
	HostUrl *string

	// The Amazon Resource Name (ARN) of the Secrets Manager secret that contains the
	// user name and password required to connect to the ServiceNow instance. You can
	// also provide OAuth authentication credentials of user name, password, client ID,
	// and client secret. For more information, see [Using a ServiceNow data source].
	//
	// [Using a ServiceNow data source]: https://docs.aws.amazon.com/kendra/latest/dg/data-source-servicenow.html
	//
	// This member is required.
	SecretArn *string

	// The identifier of the release that the ServiceNow host is running. If the host
	// is not running the LONDON release, use OTHERS .
	//
	// This member is required.
	ServiceNowBuildVersion ServiceNowBuildVersionType

	// The type of authentication used to connect to the ServiceNow instance. If you
	// choose HTTP_BASIC , Amazon Kendra is authenticated using the user name and
	// password provided in the Secrets Manager secret in the SecretArn field. If you
	// choose OAUTH2 , Amazon Kendra is authenticated using the credentials of client
	// ID, client secret, user name and password.
	//
	// When you use OAUTH2 authentication, you must generate a token and a client
	// secret using the ServiceNow console. For more information, see [Using a ServiceNow data source].
	//
	// [Using a ServiceNow data source]: https://docs.aws.amazon.com/kendra/latest/dg/data-source-servicenow.html
	AuthenticationType ServiceNowAuthenticationType

	// Configuration information for crawling knowledge articles in the ServiceNow
	// site.
	KnowledgeArticleConfiguration *ServiceNowKnowledgeArticleConfiguration

	// Configuration information for crawling service catalogs in the ServiceNow site.
	ServiceCatalogConfiguration *ServiceNowServiceCatalogConfiguration

	noSmithyDocumentSerde
}

// Provides the configuration information for crawling knowledge articles in the
// ServiceNow site.
type ServiceNowKnowledgeArticleConfiguration struct {

	// The name of the ServiceNow field that is mapped to the index document contents
	// field in the Amazon Kendra index.
	//
	// This member is required.
	DocumentDataFieldName *string

	// TRUE to index attachments to knowledge articles.
	CrawlAttachments bool

	// The name of the ServiceNow field that is mapped to the index document title
	// field.
	DocumentTitleFieldName *string

	// A list of regular expression patterns applied to exclude certain knowledge
	// article attachments. Attachments that match the patterns are excluded from the
	// index. Items that don't match the patterns are included in the index. If an item
	// matches both an inclusion and exclusion pattern, the exclusion pattern takes
	// precedence and the item isn't included in the index.
	ExcludeAttachmentFilePatterns []string

	// Maps attributes or field names of knoweldge articles to Amazon Kendra index
	// field names. To create custom fields, use the UpdateIndex API before you map to
	// ServiceNow fields. For more information, see [Mapping data source fields]. The ServiceNow data source field
	// names must exist in your ServiceNow custom metadata.
	//
	// [Mapping data source fields]: https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html
	FieldMappings []DataSourceToIndexFieldMapping

	// A query that selects the knowledge articles to index. The query can return
	// articles from multiple knowledge bases, and the knowledge bases can be public or
	// private.
	//
	// The query string must be one generated by the ServiceNow console. For more
	// information, see [Specifying documents to index with a query].
	//
	// [Specifying documents to index with a query]: https://docs.aws.amazon.com/kendra/latest/dg/servicenow-query.html
	FilterQuery *string

	// A list of regular expression patterns applied to include knowledge article
	// attachments. Attachments that match the patterns are included in the index.
	// Items that don't match the patterns are excluded from the index. If an item
	// matches both an inclusion and exclusion pattern, the exclusion pattern takes
	// precedence and the item isn't included in the index.
	IncludeAttachmentFilePatterns []string

	noSmithyDocumentSerde
}

// Provides the configuration information for crawling service catalog items in
// the ServiceNow site
type ServiceNowServiceCatalogConfiguration struct {

	// The name of the ServiceNow field that is mapped to the index document contents
	// field in the Amazon Kendra index.
	//
	// This member is required.
	DocumentDataFieldName *string

	// TRUE to index attachments to service catalog items.
	CrawlAttachments bool

	// The name of the ServiceNow field that is mapped to the index document title
	// field.
	DocumentTitleFieldName *string

	// A list of regular expression patterns to exclude certain attachments of
	// catalogs in your ServiceNow. Item that match the patterns are excluded from the
	// index. Items that don't match the patterns are included in the index. If an item
	// matches both an inclusion and exclusion pattern, the exclusion pattern takes
	// precedence and the item isn't included in the index.
	//
	// The regex is applied to the file name of the attachment.
	ExcludeAttachmentFilePatterns []string

	// Maps attributes or field names of catalogs to Amazon Kendra index field names.
	// To create custom fields, use the UpdateIndex API before you map to ServiceNow
	// fields. For more information, see [Mapping data source fields]. The ServiceNow data source field names must
	// exist in your ServiceNow custom metadata.
	//
	// [Mapping data source fields]: https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html
	FieldMappings []DataSourceToIndexFieldMapping

	// A list of regular expression patterns to include certain attachments of
	// catalogs in your ServiceNow. Item that match the patterns are included in the
	// index. Items that don't match the patterns are excluded from the index. If an
	// item matches both an inclusion and exclusion pattern, the exclusion pattern
	// takes precedence and the item isn't included in the index.
	//
	// The regex is applied to the file name of the attachment.
	IncludeAttachmentFilePatterns []string

	noSmithyDocumentSerde
}

// Provides the configuration information to connect to Microsoft SharePoint as
// your data source.
type SharePointConfiguration struct {

	// The Amazon Resource Name (ARN) of an Secrets Manager secret that contains the
	// user name and password required to connect to the SharePoint instance. For more
	// information, see [Microsoft SharePoint].
	//
	// [Microsoft SharePoint]: https://docs.aws.amazon.com/kendra/latest/dg/data-source-sharepoint.html
	//
	// This member is required.
	SecretArn *string

	// The version of Microsoft SharePoint that you use.
	//
	// This member is required.
	SharePointVersion SharePointVersion

	// The Microsoft SharePoint site URLs for the documents you want to index.
	//
	// This member is required.
	Urls []string

	// Whether you want to connect to SharePoint Online using basic authentication of
	// user name and password, or OAuth authentication of user name, password, client
	// ID, and client secret, or AD App-only authentication of client secret.
	AuthenticationType SharePointOnlineAuthenticationType

	// TRUE to index document attachments.
	CrawlAttachments bool

	// TRUE to disable local groups information.
	DisableLocalGroups bool

	// The Microsoft SharePoint attribute field that contains the title of the
	// document.
	DocumentTitleFieldName *string

	// A list of regular expression patterns to exclude certain documents in your
	// SharePoint. Documents that match the patterns are excluded from the index.
	// Documents that don't match the patterns are included in the index. If a document
	// matches both an inclusion and exclusion pattern, the exclusion pattern takes
	// precedence and the document isn't included in the index.
	//
	// The regex applies to the display URL of the SharePoint document.
	ExclusionPatterns []string

	// A list of DataSourceToIndexFieldMapping objects that map SharePoint data source
	// attributes or field names to Amazon Kendra index field names. To create custom
	// fields, use the UpdateIndex API before you map to SharePoint fields. For more
	// information, see [Mapping data source fields]. The SharePoint data source field names must exist in your
	// SharePoint custom metadata.
	//
	// [Mapping data source fields]: https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html
	FieldMappings []DataSourceToIndexFieldMapping

	// A list of regular expression patterns to include certain documents in your
	// SharePoint. Documents that match the patterns are included in the index.
	// Documents that don't match the patterns are excluded from the index. If a
	// document matches both an inclusion and exclusion pattern, the exclusion pattern
	// takes precedence and the document isn't included in the index.
	//
	// The regex applies to the display URL of the SharePoint document.
	InclusionPatterns []string

	// Configuration information to connect to your Microsoft SharePoint site URLs via
	// instance via a web proxy. You can use this option for SharePoint Server.
	//
	// You must provide the website host name and port number. For example, the host
	// name of https://a.example.com/page1.html is "a.example.com" and the port is 443,
	// the standard port for HTTPS.
	//
	// Web proxy credentials are optional and you can use them to connect to a web
	// proxy server that requires basic authentication of user name and password. To
	// store web proxy credentials, you use a secret in Secrets Manager.
	//
	// It is recommended that you follow best security practices when configuring your
	// web proxy. This includes setting up throttling, setting up logging and
	// monitoring, and applying security patches on a regular basis. If you use your
	// web proxy with multiple data sources, sync jobs that occur at the same time
	// could strain the load on your proxy. It is recommended you prepare your proxy
	// beforehand for any security and load requirements.
	ProxyConfiguration *ProxyConfiguration

	// The path to the SSL certificate stored in an Amazon S3 bucket. You use this to
	// connect to SharePoint Server if you require a secure SSL connection.
	//
	// You can generate a self-signed X509 certificate on any computer using OpenSSL.
	// For an example of using OpenSSL to create an X509 certificate, see [Create and sign an X509 certificate].
	//
	// [Create and sign an X509 certificate]: https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/configuring-https-ssl.html
	SslCertificateS3Path *S3Path

	// TRUE to use the SharePoint change log to determine which documents require
	// updating in the index. Depending on the change log's size, it may take longer
	// for Amazon Kendra to use the change log than to scan all of your documents in
	// SharePoint.
	UseChangeLog bool

	// Configuration information for an Amazon Virtual Private Cloud to connect to
	// your Microsoft SharePoint. For more information, see [Configuring a VPC].
	//
	// [Configuring a VPC]: https://docs.aws.amazon.com/kendra/latest/dg/vpc-configuration.html
	VpcConfiguration *DataSourceVpcConfiguration

	noSmithyDocumentSerde
}

// Provides the configuration information for the sitemap URLs to crawl.
//
// When selecting websites to index, you must adhere to the [Amazon Acceptable Use Policy] and all other Amazon
// terms. Remember that you must only use Amazon Kendra Web Crawler to index your
// own web pages, or web pages that you have authorization to index.
//
// [Amazon Acceptable Use Policy]: https://aws.amazon.com/aup/
type SiteMapsConfiguration struct {

	// The list of sitemap URLs of the websites you want to crawl.
	//
	// The list can include a maximum of three sitemap URLs.
	//
	// This member is required.
	SiteMaps []string

	noSmithyDocumentSerde
}

// Provides the configuration information to connect to Slack as your data source.
//
// Amazon Kendra now supports an upgraded Slack connector.
//
// You must now use the [TemplateConfiguration] object instead of the SlackConfiguration object to
// configure your connector.
//
// Connectors configured using the older console and API architecture will
// continue to function as configured. However, you won’t be able to edit or update
// them. If you want to edit or update your connector configuration, you must
// create a new connector.
//
// We recommended migrating your connector workflow to the upgraded version.
// Support for connectors configured using the older architecture is scheduled to
// end by June 2024.
//
// [TemplateConfiguration]: https://docs.aws.amazon.com/kendra/latest/APIReference/API_TemplateConfiguration.html
type SlackConfiguration struct {

	// The Amazon Resource Name (ARN) of an Secrets Manager secret that contains the
	// key-value pairs required to connect to your Slack workspace team. The secret
	// must contain a JSON structure with the following keys:
	//
	//   - slackToken—The user or bot token created in Slack. For more information on
	//   creating a token in Slack, see [Authentication for a Slack data source].
	//
	// [Authentication for a Slack data source]: https://docs.aws.amazon.com/kendra/latest/dg/data-source-slack.html#slack-authentication
	//
	// This member is required.
	SecretArn *string

	// The date to start crawling your data from your Slack workspace team. The date
	// must follow this format: yyyy-mm-dd .
	//
	// This member is required.
	SinceCrawlDate *string

	// Specify whether to index public channels, private channels, group messages, and
	// direct messages. You can specify one or more of these options.
	//
	// This member is required.
	SlackEntityList []SlackEntity

	// The identifier of the team in the Slack workspace. For example, T0123456789.
	//
	// You can find your team ID in the URL of the main page of your Slack workspace.
	// When you log in to Slack via a browser, you are directed to the URL of the main
	// page. For example, https://app.slack.com/client/T0123456789/....
	//
	// This member is required.
	TeamId *string

	// TRUE to index bot messages from your Slack workspace team.
	CrawlBotMessage bool

	// TRUE to exclude archived messages to index from your Slack workspace team.
	ExcludeArchived bool

	// A list of regular expression patterns to exclude certain attached files in your
	// Slack workspace team. Files that match the patterns are excluded from the index.
	// Files that don’t match the patterns are included in the index. If a file matches
	// both an inclusion and exclusion pattern, the exclusion pattern takes precedence
	// and the file isn't included in the index.
	ExclusionPatterns []string

	// A list of DataSourceToIndexFieldMapping objects that map Slack data source
	// attributes or field names to Amazon Kendra index field names. To create custom
	// fields, use the UpdateIndex API before you map to Slack fields. For more
	// information, see [Mapping data source fields]. The Slack data source field names must exist in your Slack
	// custom metadata.
	//
	// [Mapping data source fields]: https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html
	FieldMappings []DataSourceToIndexFieldMapping

	// A list of regular expression patterns to include certain attached files in your
	// Slack workspace team. Files that match the patterns are included in the index.
	// Files that don't match the patterns are excluded from the index. If a file
	// matches both an inclusion and exclusion pattern, the exclusion pattern takes
	// precedence and the file isn't included in the index.
	InclusionPatterns []string

	// The number of hours for change log to look back from when you last synchronized
	// your data. You can look back up to 7 days or 168 hours.
	//
	// Change log updates your index only if new content was added since you last
	// synced your data. Updated or deleted content from before you last synced does
	// not get updated in your index. To capture updated or deleted content before you
	// last synced, set the LookBackPeriod to the number of hours you want change log
	// to look back.
	LookBackPeriod *int32

	// The list of private channel names from your Slack workspace team. You use this
	// if you want to index specific private channels, not all private channels. You
	// can also use regular expression patterns to filter private channels.
	PrivateChannelFilter []string

	// The list of public channel names to index from your Slack workspace team. You
	// use this if you want to index specific public channels, not all public channels.
	// You can also use regular expression patterns to filter public channels.
	PublicChannelFilter []string

	// TRUE to use the Slack change log to determine which documents require updating
	// in the index. Depending on the Slack change log's size, it may take longer for
	// Amazon Kendra to use the change log than to scan all of your documents in Slack.
	UseChangeLog bool

	// Configuration information for an Amazon Virtual Private Cloud to connect to
	// your Slack. For more information, see [Configuring a VPC].
	//
	// [Configuring a VPC]: https://docs.aws.amazon.com/kendra/latest/dg/vpc-configuration.html
	VpcConfiguration *DataSourceVpcConfiguration

	noSmithyDocumentSerde
}

// Specifies the document attribute to use to sort the response to a Amazon Kendra
// query. You can specify a single attribute for sorting. The attribute must have
// the Sortable flag set to true , otherwise Amazon Kendra returns an exception.
//
// You can sort attributes of the following types.
//
//   - Date value
//
//   - Long value
//
//   - String value
//
// You can't sort attributes of the following type.
//
//   - String list value
type SortingConfiguration struct {

	// The name of the document attribute used to sort the response. You can use any
	// field that has the Sortable flag set to true.
	//
	// You can also sort by any of the following built-in attributes:
	//
	//   - _category
	//
	//   - _created_at
	//
	//   - _last_updated_at
	//
	//   - _version
	//
	//   - _view_count
	//
	// This member is required.
	DocumentAttributeKey *string

	// The order that the results should be returned in. In case of ties, the
	// relevance assigned to the result by Amazon Kendra is used as the tie-breaker.
	//
	// This member is required.
	SortOrder SortOrder

	noSmithyDocumentSerde
}

// The document ID and its fields/attributes that are used for a query suggestion,
// if document fields set to use for query suggestions.
type SourceDocument struct {

	// The additional fields/attributes to include in the response. You can use
	// additional fields to provide extra information in the response. Additional
	// fields are not used to based suggestions on.
	AdditionalAttributes []DocumentAttribute

	// The identifier of the document used for a query suggestion.
	DocumentId *string

	// The document fields/attributes used for a query suggestion.
	SuggestionAttributes []string

	noSmithyDocumentSerde
}

// A query with suggested spell corrections.
type SpellCorrectedQuery struct {

	// The corrected misspelled word or words in a query.
	Corrections []Correction

	// The query with the suggested spell corrections.
	SuggestedQueryText *string

	noSmithyDocumentSerde
}

// Provides the configuration information for suggested query spell corrections.
//
// Suggested spell corrections are based on words that appear in your indexed
// documents and how closely a corrected word matches a misspelled word.
//
// This feature is designed with certain defaults or limits. For information on
// the current limits and how to request more support for some limits, see the [Spell Checker documentation].
//
// [Spell Checker documentation]: https://docs.aws.amazon.com/kendra/latest/dg/query-spell-check.html
type SpellCorrectionConfiguration struct {

	// TRUE to suggest spell corrections for queries.
	//
	// This member is required.
	IncludeQuerySpellCheckSuggestions bool

	noSmithyDocumentSerde
}

// Provides the configuration information to use a SQL database.
type SqlConfiguration struct {

	// Determines whether Amazon Kendra encloses SQL identifiers for tables and column
	// names in double quotes (") when making a database query.
	//
	// By default, Amazon Kendra passes SQL identifiers the way that they are entered
	// into the data source configuration. It does not change the case of identifiers
	// or enclose them in quotes.
	//
	// PostgreSQL internally converts uppercase characters to lower case characters in
	// identifiers unless they are quoted. Choosing this option encloses identifiers in
	// quotes so that PostgreSQL does not convert the character's case.
	//
	// For MySQL databases, you must enable the ansi_quotes option when you set this
	// field to DOUBLE_QUOTES .
	QueryIdentifiersEnclosingOption QueryIdentifiersEnclosingOption

	noSmithyDocumentSerde
}

// Provides information about the status of documents submitted for indexing.
type Status struct {

	// The identifier of the document.
	DocumentId *string

	// The current status of a document.
	//
	// If the document was submitted for deletion, the status is NOT_FOUND after the
	// document is deleted.
	DocumentStatus DocumentStatus

	// Indicates the source of the error.
	FailureCode *string

	// Provides detailed information about why the document couldn't be indexed. Use
	// this information to correct the error before you resubmit the document for
	// indexing.
	FailureReason *string

	noSmithyDocumentSerde
}

// Provides the configuration information for a document field/attribute that you
// want to base query suggestions on.
type SuggestableConfig struct {

	// The name of the document field/attribute.
	AttributeName *string

	// TRUE means the document field/attribute is suggestible, so the contents within
	// the field can be used for query suggestions.
	Suggestable *bool

	noSmithyDocumentSerde
}

// A single query suggestion.
type Suggestion struct {

	// The UUID (universally unique identifier) of a single query suggestion.
	Id *string

	// The list of document IDs and their fields/attributes that are used for a single
	// query suggestion, if document fields set to use for query suggestions.
	SourceDocuments []SourceDocument

	// The value for the UUID (universally unique identifier) of a single query
	// suggestion.
	//
	// The value is the text string of a suggestion.
	Value *SuggestionValue

	noSmithyDocumentSerde
}

// The text highlights for a single query suggestion.
type SuggestionHighlight struct {

	// The zero-based location in the response string where the highlight starts.
	BeginOffset *int32

	// The zero-based location in the response string where the highlight ends.
	EndOffset *int32

	noSmithyDocumentSerde
}

// Provides text and information about where to highlight the query suggestion
// text.
type SuggestionTextWithHighlights struct {

	// The beginning and end of the query suggestion text that should be highlighted.
	Highlights []SuggestionHighlight

	// The query suggestion text to display to the user.
	Text *string

	noSmithyDocumentSerde
}

// The SuggestionTextWithHighlights structure information.
type SuggestionValue struct {

	// The SuggestionTextWithHighlights structure that contains the query suggestion
	// text and highlights.
	Text *SuggestionTextWithHighlights

	noSmithyDocumentSerde
}

// Provides information about a table cell in a table excerpt.
type TableCell struct {

	// TRUE means that the table cell should be treated as a header.
	Header bool

	// TRUE means that the table cell has a high enough confidence and is relevant to
	// the query, so the value or content should be highlighted.
	Highlighted bool

	// TRUE if the response of the table cell is the top answer. This is the cell
	// value or content with the highest confidence score or is the most relevant to
	// the query.
	TopAnswer bool

	// The actual value or content within a table cell. A table cell could contain a
	// date value of a year, or a string value of text, for example.
	Value *string

	noSmithyDocumentSerde
}

// An excerpt from a table within a document. The table excerpt displays up to
// five columns and three rows, depending on how many table cells are relevant to
// the query and how many columns are available in the original table. The top most
// relevant cell is displayed in the table excerpt, along with the next most
// relevant cells.
type TableExcerpt struct {

	// A list of rows in the table excerpt.
	Rows []TableRow

	// A count of the number of rows in the original table within the document.
	TotalNumberOfRows *int32

	noSmithyDocumentSerde
}

// Information about a row in a table excerpt.
type TableRow struct {

	// A list of table cells in a row.
	Cells []TableCell

	noSmithyDocumentSerde
}

// A key-value pair that identifies or categorizes an index, FAQ, data source, or
// other resource. TA tag key and value can consist of Unicode letters, digits,
// white space, and any of the following symbols: _ . : / = + - @.
type Tag struct {

	// The key for the tag. Keys are not case sensitive and must be unique for the
	// index, FAQ, data source, or other resource.
	//
	// This member is required.
	Key *string

	// The value associated with the tag. The value may be an empty string but it
	// can't be null.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// Provides a template for the configuration information to connect to your data
// source.
type TemplateConfiguration struct {

	// The template schema used for the data source, where templates schemas are
	// supported.
	//
	// See [Data source template schemas].
	//
	// [Data source template schemas]: https://docs.aws.amazon.com/kendra/latest/dg/ds-schemas.html
	Template document.Interface

	noSmithyDocumentSerde
}

// Provides information about text documents indexed in an index.
type TextDocumentStatistics struct {

	// The total size, in bytes, of the indexed documents.
	//
	// This member is required.
	IndexedTextBytes int64

	// The number of text documents indexed.
	//
	// This member is required.
	IndexedTextDocumentsCount int32

	noSmithyDocumentSerde
}

// Provides text and information about where to highlight the text.
type TextWithHighlights struct {

	// The beginning and end of the text that should be highlighted.
	Highlights []Highlight

	// The text to display to the user.
	Text *string

	noSmithyDocumentSerde
}

// An array of summary information for a thesaurus or multiple thesauri.
type ThesaurusSummary struct {

	// The Unix timestamp when the thesaurus was created.
	CreatedAt *time.Time

	// The identifier of the thesaurus.
	Id *string

	// The name of the thesaurus.
	Name *string

	// The status of the thesaurus.
	Status ThesaurusStatus

	// The Unix timestamp when the thesaurus was last updated.
	UpdatedAt *time.Time

	noSmithyDocumentSerde
}

// Provides a range of time.
type TimeRange struct {

	// The Unix timestamp for the end of the time range.
	EndTime *time.Time

	// The Unix timestamp for the beginning of the time range.
	StartTime *time.Time

	noSmithyDocumentSerde
}

// Provides the configuration information of the URLs to crawl.
//
// You can only crawl websites that use the secure communication protocol,
// Hypertext Transfer Protocol Secure (HTTPS). If you receive an error when
// crawling a website, it could be that the website is blocked from crawling.
//
// When selecting websites to index, you must adhere to the [Amazon Acceptable Use Policy] and all other Amazon
// terms. Remember that you must only use Amazon Kendra Web Crawler to index your
// own web pages, or web pages that you have authorization to index.
//
// [Amazon Acceptable Use Policy]: https://aws.amazon.com/aup/
type Urls struct {

	// Configuration of the seed or starting point URLs of the websites you want to
	// crawl.
	//
	// You can choose to crawl only the website host names, or the website host names
	// with subdomains, or the website host names with subdomains and other domains
	// that the web pages link to.
	//
	// You can list up to 100 seed URLs.
	SeedUrlConfiguration *SeedUrlConfiguration

	// Configuration of the sitemap URLs of the websites you want to crawl.
	//
	// Only URLs belonging to the same website host names are crawled. You can list up
	// to three sitemap URLs.
	SiteMapsConfiguration *SiteMapsConfiguration

	noSmithyDocumentSerde
}

// Provides information about the user context for an Amazon Kendra index.
//
// User context filtering is a kind of personalized search with the benefit of
// controlling access to documents. For example, not all teams that search the
// company portal for information should access top-secret company documents, nor
// are these documents relevant to all users. Only specific users or groups of
// teams given access to top-secret documents should see these documents in their
// search results.
//
// You provide one of the following:
//
//   - User token
//
//   - User ID, the groups the user belongs to, and any data sources the groups
//     can access.
//
// If you provide both, an exception is thrown.
//
// If you're using an Amazon Kendra Gen AI Enterprise Edition index, you can use
// UserId , Groups , and DataSourceGroups to filter content. If you set the UserId
// to a particular user ID, it also includes all public documents.
//
// Amazon Kendra Gen AI Enterprise Edition indices don't support token based
// document filtering. If you're using an Amazon Kendra Gen AI Enterprise Edition
// index, Amazon Kendra returns a ValidationException error if the Token field has
// a non-null value.
type UserContext struct {

	// The list of data source groups you want to filter search results based on
	// groups' access to documents in that data source.
	DataSourceGroups []DataSourceGroup

	// The list of groups you want to filter search results based on the groups'
	// access to documents.
	Groups []string

	// The user context token for filtering search results for a user. It must be a
	// JWT or a JSON token.
	Token *string

	// The identifier of the user you want to filter search results based on their
	// access to documents.
	UserId *string

	noSmithyDocumentSerde
}

// Provides the configuration information to get users and groups from an IAM
// Identity Center identity source. This is useful for user context filtering,
// where search results are filtered based on the user or their group access to
// documents. You can also use the [PutPrincipalMapping]API to map users to their groups so that you
// only need to provide the user ID when you issue the query.
//
// To set up an IAM Identity Center identity source in the console to use with
// Amazon Kendra, see [Getting started with an IAM Identity Center identity source]. You must also grant the required permissions to use IAM
// Identity Center with Amazon Kendra. For more information, see [IAM roles for IAM Identity Center].
//
// Amazon Kendra currently does not support using UserGroupResolutionConfiguration
// with an Amazon Web Services organization member account for your IAM Identity
// Center identify source. You must create your index in the management account for
// the organization in order to use UserGroupResolutionConfiguration .
//
// If you're using an Amazon Kendra Gen AI Enterprise Edition index,
// UserGroupResolutionConfiguration isn't supported.
//
// [Getting started with an IAM Identity Center identity source]: https://docs.aws.amazon.com/kendra/latest/dg/getting-started-aws-sso.html
// [IAM roles for IAM Identity Center]: https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html#iam-roles-aws-sso
// [PutPrincipalMapping]: https://docs.aws.amazon.com/kendra/latest/dg/API_PutPrincipalMapping.html
type UserGroupResolutionConfiguration struct {

	// The identity store provider (mode) you want to use to get users and groups. IAM
	// Identity Center is currently the only available mode. Your users and groups must
	// exist in an IAM Identity Center identity source in order to use this mode.
	//
	// This member is required.
	UserGroupResolutionMode UserGroupResolutionMode

	noSmithyDocumentSerde
}

// Provides the configuration information for the identifiers of your users.
type UserIdentityConfiguration struct {

	// The IAM Identity Center field name that contains the identifiers of your users,
	// such as their emails. This is used for [user context filtering]and for granting access to your Amazon
	// Kendra experience. You must set up IAM Identity Center with Amazon Kendra. You
	// must include your users and groups in your Access Control List when you ingest
	// documents into your index. For more information, see [Getting started with an IAM Identity Center identity source].
	//
	// [Getting started with an IAM Identity Center identity source]: https://docs.aws.amazon.com/kendra/latest/dg/getting-started-aws-sso.html
	// [user context filtering]: https://docs.aws.amazon.com/kendra/latest/dg/user-context-filter.html
	IdentityAttributeName *string

	noSmithyDocumentSerde
}

// Provides the configuration information for a token.
//
// If you're using an Amazon Kendra Gen AI Enterprise Edition index and you try to
// use UserTokenConfigurations to configure user context policy, Amazon Kendra
// returns a ValidationException error.
type UserTokenConfiguration struct {

	// Information about the JSON token type configuration.
	JsonTokenTypeConfiguration *JsonTokenTypeConfiguration

	// Information about the JWT token type configuration.
	JwtTokenTypeConfiguration *JwtTokenTypeConfiguration

	noSmithyDocumentSerde
}

// The warning code and message that explains a problem with a query.
type Warning struct {

	// The code used to show the type of warning for the query.
	Code WarningCode

	// The message that explains the problem with the query.
	Message *string

	noSmithyDocumentSerde
}

// Provides the configuration information required for Amazon Kendra Web Crawler.
type WebCrawlerConfiguration struct {

	// Specifies the seed or starting point URLs of the websites or the sitemap URLs
	// of the websites you want to crawl.
	//
	// You can include website subdomains. You can list up to 100 seed URLs and up to
	// three sitemap URLs.
	//
	// You can only crawl websites that use the secure communication protocol,
	// Hypertext Transfer Protocol Secure (HTTPS). If you receive an error when
	// crawling a website, it could be that the website is blocked from crawling.
	//
	// When selecting websites to index, you must adhere to the [Amazon Acceptable Use Policy] and all other Amazon
	// terms. Remember that you must only use Amazon Kendra Web Crawler to index your
	// own web pages, or web pages that you have authorization to index.
	//
	// [Amazon Acceptable Use Policy]: https://aws.amazon.com/aup/
	//
	// This member is required.
	Urls *Urls

	// Configuration information required to connect to websites using authentication.
	//
	// You can connect to websites using basic authentication of user name and
	// password. You use a secret in [Secrets Manager]to store your authentication credentials.
	//
	// You must provide the website host name and port number. For example, the host
	// name of https://a.example.com/page1.html is "a.example.com" and the port is 443,
	// the standard port for HTTPS.
	//
	// [Secrets Manager]: https://docs.aws.amazon.com/secretsmanager/latest/userguide/intro.html
	AuthenticationConfiguration *AuthenticationConfiguration

	// The 'depth' or number of levels from the seed level to crawl. For example, the
	// seed URL page is depth 1 and any hyperlinks on this page that are also crawled
	// are depth 2.
	CrawlDepth *int32

	// The maximum size (in MB) of a web page or attachment to crawl.
	//
	// Files larger than this size (in MB) are skipped/not crawled.
	//
	// The default maximum size of a web page or attachment is set to 50 MB.
	MaxContentSizePerPageInMegaBytes *float32

	// The maximum number of URLs on a web page to include when crawling a website.
	// This number is per web page.
	//
	// As a website’s web pages are crawled, any URLs the web pages link to are also
	// crawled. URLs on a web page are crawled in order of appearance.
	//
	// The default maximum links per page is 100.
	MaxLinksPerPage *int32

	// The maximum number of URLs crawled per website host per minute.
	//
	// A minimum of one URL is required.
	//
	// The default maximum number of URLs crawled per website host per minute is 300.
	MaxUrlsPerMinuteCrawlRate *int32

	// Configuration information required to connect to your internal websites via a
	// web proxy.
	//
	// You must provide the website host name and port number. For example, the host
	// name of https://a.example.com/page1.html is "a.example.com" and the port is 443,
	// the standard port for HTTPS.
	//
	// Web proxy credentials are optional and you can use them to connect to a web
	// proxy server that requires basic authentication. To store web proxy credentials,
	// you use a secret in [Secrets Manager].
	//
	// [Secrets Manager]: https://docs.aws.amazon.com/secretsmanager/latest/userguide/intro.html
	ProxyConfiguration *ProxyConfiguration

	// A list of regular expression patterns to exclude certain URLs to crawl. URLs
	// that match the patterns are excluded from the index. URLs that don't match the
	// patterns are included in the index. If a URL matches both an inclusion and
	// exclusion pattern, the exclusion pattern takes precedence and the URL file isn't
	// included in the index.
	UrlExclusionPatterns []string

	// A list of regular expression patterns to include certain URLs to crawl. URLs
	// that match the patterns are included in the index. URLs that don't match the
	// patterns are excluded from the index. If a URL matches both an inclusion and
	// exclusion pattern, the exclusion pattern takes precedence and the URL file isn't
	// included in the index.
	UrlInclusionPatterns []string

	noSmithyDocumentSerde
}

// Provides the configuration information to connect to Amazon WorkDocs as your
// data source.
//
// Amazon WorkDocs connector is available in Oregon, North Virginia, Sydney,
// Singapore and Ireland regions.
type WorkDocsConfiguration struct {

	// The identifier of the directory corresponding to your Amazon WorkDocs site
	// repository.
	//
	// You can find the organization ID in the [Directory Service] by going to Active Directory, then
	// Directories. Your Amazon WorkDocs site directory has an ID, which is the
	// organization ID. You can also set up a new Amazon WorkDocs directory in the
	// Directory Service console and enable a Amazon WorkDocs site for the directory in
	// the Amazon WorkDocs console.
	//
	// [Directory Service]: https://console.aws.amazon.com/directoryservicev2/
	//
	// This member is required.
	OrganizationId *string

	// TRUE to include comments on documents in your index. Including comments in your
	// index means each comment is a document that can be searched on.
	//
	// The default is set to FALSE .
	CrawlComments bool

	// A list of regular expression patterns to exclude certain files in your Amazon
	// WorkDocs site repository. Files that match the patterns are excluded from the
	// index. Files that don’t match the patterns are included in the index. If a file
	// matches both an inclusion and exclusion pattern, the exclusion pattern takes
	// precedence and the file isn't included in the index.
	ExclusionPatterns []string

	// A list of DataSourceToIndexFieldMapping objects that map Amazon WorkDocs data
	// source attributes or field names to Amazon Kendra index field names. To create
	// custom fields, use the UpdateIndex API before you map to Amazon WorkDocs
	// fields. For more information, see [Mapping data source fields]. The Amazon WorkDocs data source field names
	// must exist in your Amazon WorkDocs custom metadata.
	//
	// [Mapping data source fields]: https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html
	FieldMappings []DataSourceToIndexFieldMapping

	// A list of regular expression patterns to include certain files in your Amazon
	// WorkDocs site repository. Files that match the patterns are included in the
	// index. Files that don't match the patterns are excluded from the index. If a
	// file matches both an inclusion and exclusion pattern, the exclusion pattern
	// takes precedence and the file isn't included in the index.
	InclusionPatterns []string

	// TRUE to use the Amazon WorkDocs change log to determine which documents require
	// updating in the index. Depending on the change log's size, it may take longer
	// for Amazon Kendra to use the change log than to scan all of your documents in
	// Amazon WorkDocs.
	UseChangeLog bool

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
