// Code generated by smithy-go-codegen DO NOT EDIT.

package kafka

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/kafka/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists the replicators.
func (c *Client) ListReplicators(ctx context.Context, params *ListReplicatorsInput, optFns ...func(*Options)) (*ListReplicatorsOutput, error) {
	if params == nil {
		params = &ListReplicatorsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListReplicators", params, optFns, c.addOperationListReplicatorsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListReplicatorsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListReplicatorsInput struct {

	// The maximum number of results to return in the response. If there are more
	// results, the response includes a NextToken parameter.
	MaxResults *int32

	// If the response of ListReplicators is truncated, it returns a NextToken in the
	// response. This NextToken should be sent in the subsequent request to
	// ListReplicators.
	NextToken *string

	// Returns replicators starting with given name.
	ReplicatorNameFilter *string

	noSmithyDocumentSerde
}

type ListReplicatorsOutput struct {

	// If the response of ListReplicators is truncated, it returns a NextToken in the
	// response. This NextToken should be sent in the subsequent request to
	// ListReplicators.
	NextToken *string

	// List containing information of each of the replicators in the account.
	Replicators []types.ReplicatorSummary

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListReplicatorsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListReplicators{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListReplicators{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListReplicators"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListReplicators(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListReplicatorsPaginatorOptions is the paginator options for ListReplicators
type ListReplicatorsPaginatorOptions struct {
	// The maximum number of results to return in the response. If there are more
	// results, the response includes a NextToken parameter.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListReplicatorsPaginator is a paginator for ListReplicators
type ListReplicatorsPaginator struct {
	options   ListReplicatorsPaginatorOptions
	client    ListReplicatorsAPIClient
	params    *ListReplicatorsInput
	nextToken *string
	firstPage bool
}

// NewListReplicatorsPaginator returns a new ListReplicatorsPaginator
func NewListReplicatorsPaginator(client ListReplicatorsAPIClient, params *ListReplicatorsInput, optFns ...func(*ListReplicatorsPaginatorOptions)) *ListReplicatorsPaginator {
	if params == nil {
		params = &ListReplicatorsInput{}
	}

	options := ListReplicatorsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListReplicatorsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListReplicatorsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListReplicators page.
func (p *ListReplicatorsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListReplicatorsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListReplicators(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListReplicatorsAPIClient is a client that implements the ListReplicators
// operation.
type ListReplicatorsAPIClient interface {
	ListReplicators(context.Context, *ListReplicatorsInput, ...func(*Options)) (*ListReplicatorsOutput, error)
}

var _ ListReplicatorsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListReplicators(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListReplicators",
	}
}
