// Code generated by smithy-go-codegen DO NOT EDIT.

package ivsrealtime

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/ivsrealtime/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists all IngestConfigurations in your account, in the AWS region where the API
// request is processed.
func (c *Client) ListIngestConfigurations(ctx context.Context, params *ListIngestConfigurationsInput, optFns ...func(*Options)) (*ListIngestConfigurationsOutput, error) {
	if params == nil {
		params = &ListIngestConfigurationsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListIngestConfigurations", params, optFns, c.addOperationListIngestConfigurationsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListIngestConfigurationsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListIngestConfigurationsInput struct {

	// Filters the response list to match the specified stage ARN. Only one filter (by
	// stage ARN or by state) can be used at a time.
	FilterByStageArn *string

	// Filters the response list to match the specified state. Only one filter (by
	// stage ARN or by state) can be used at a time.
	FilterByState types.IngestConfigurationState

	// Maximum number of results to return. Default: 50.
	MaxResults *int32

	// The first IngestConfiguration to retrieve. This is used for pagination; see the
	// nextToken response field.
	NextToken *string

	noSmithyDocumentSerde
}

type ListIngestConfigurationsOutput struct {

	// List of the matching ingest configurations (summary information only).
	//
	// This member is required.
	IngestConfigurations []types.IngestConfigurationSummary

	// If there are more IngestConfigurations than maxResults , use nextToken in the
	// request to get the next set.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListIngestConfigurationsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListIngestConfigurations{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListIngestConfigurations{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListIngestConfigurations"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListIngestConfigurations(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListIngestConfigurationsPaginatorOptions is the paginator options for
// ListIngestConfigurations
type ListIngestConfigurationsPaginatorOptions struct {
	// Maximum number of results to return. Default: 50.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListIngestConfigurationsPaginator is a paginator for ListIngestConfigurations
type ListIngestConfigurationsPaginator struct {
	options   ListIngestConfigurationsPaginatorOptions
	client    ListIngestConfigurationsAPIClient
	params    *ListIngestConfigurationsInput
	nextToken *string
	firstPage bool
}

// NewListIngestConfigurationsPaginator returns a new
// ListIngestConfigurationsPaginator
func NewListIngestConfigurationsPaginator(client ListIngestConfigurationsAPIClient, params *ListIngestConfigurationsInput, optFns ...func(*ListIngestConfigurationsPaginatorOptions)) *ListIngestConfigurationsPaginator {
	if params == nil {
		params = &ListIngestConfigurationsInput{}
	}

	options := ListIngestConfigurationsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListIngestConfigurationsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListIngestConfigurationsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListIngestConfigurations page.
func (p *ListIngestConfigurationsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListIngestConfigurationsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListIngestConfigurations(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListIngestConfigurationsAPIClient is a client that implements the
// ListIngestConfigurations operation.
type ListIngestConfigurationsAPIClient interface {
	ListIngestConfigurations(context.Context, *ListIngestConfigurationsInput, ...func(*Options)) (*ListIngestConfigurationsOutput, error)
}

var _ ListIngestConfigurationsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListIngestConfigurations(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListIngestConfigurations",
	}
}
