// Code generated by smithy-go-codegen DO NOT EDIT.

package iotmanagedintegrations

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/iotmanagedintegrations/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Get the current state of a device discovery.
func (c *Client) GetDeviceDiscovery(ctx context.Context, params *GetDeviceDiscoveryInput, optFns ...func(*Options)) (*GetDeviceDiscoveryOutput, error) {
	if params == nil {
		params = &GetDeviceDiscoveryInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetDeviceDiscovery", params, optFns, c.addOperationGetDeviceDiscoveryMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetDeviceDiscoveryOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetDeviceDiscoveryInput struct {

	// The id of the device discovery job request.
	//
	// This member is required.
	Identifier *string

	noSmithyDocumentSerde
}

type GetDeviceDiscoveryOutput struct {

	// The Amazon Resource Name (ARN) of the device discovery job request.
	//
	// This member is required.
	Arn *string

	// The discovery type supporting the type of device to be discovered in the device
	// discovery job request.
	//
	// This member is required.
	DiscoveryType types.DiscoveryType

	// The id of the device discovery job request.
	//
	// This member is required.
	Id *string

	// The timestamp value for the start time of the device discovery.
	//
	// This member is required.
	StartedAt *time.Time

	// The status of the device discovery job request.
	//
	// This member is required.
	Status types.DeviceDiscoveryStatus

	// The ID tracking the current discovery process for one connector association.
	ConnectorAssociationId *string

	// The id of the end-user's IoT hub.
	ControllerId *string

	// The timestamp value for the completion time of the device discovery.
	FinishedAt *time.Time

	// A set of key/value pairs that are used to manage the device discovery request.
	Tags map[string]string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetDeviceDiscoveryMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetDeviceDiscovery{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetDeviceDiscovery{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetDeviceDiscovery"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetDeviceDiscoveryValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetDeviceDiscovery(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetDeviceDiscovery(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetDeviceDiscovery",
	}
}
