// Code generated by smithy-go-codegen DO NOT EDIT.

package iotfleetwise

import (
	"bytes"
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/iotfleetwise/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/encoding/httpbinding"
	smithyjson "github.com/aws/smithy-go/encoding/json"
	"github.com/aws/smithy-go/middleware"
	smithytime "github.com/aws/smithy-go/time"
	"github.com/aws/smithy-go/tracing"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"math"
	"path"
)

type awsAwsjson10_serializeOpAssociateVehicleFleet struct {
}

func (*awsAwsjson10_serializeOpAssociateVehicleFleet) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpAssociateVehicleFleet) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AssociateVehicleFleetInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("IoTAutobahnControlPlane.AssociateVehicleFleet")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentAssociateVehicleFleetInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpBatchCreateVehicle struct {
}

func (*awsAwsjson10_serializeOpBatchCreateVehicle) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpBatchCreateVehicle) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*BatchCreateVehicleInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("IoTAutobahnControlPlane.BatchCreateVehicle")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentBatchCreateVehicleInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpBatchUpdateVehicle struct {
}

func (*awsAwsjson10_serializeOpBatchUpdateVehicle) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpBatchUpdateVehicle) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*BatchUpdateVehicleInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("IoTAutobahnControlPlane.BatchUpdateVehicle")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentBatchUpdateVehicleInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpCreateCampaign struct {
}

func (*awsAwsjson10_serializeOpCreateCampaign) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpCreateCampaign) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateCampaignInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("IoTAutobahnControlPlane.CreateCampaign")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentCreateCampaignInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpCreateDecoderManifest struct {
}

func (*awsAwsjson10_serializeOpCreateDecoderManifest) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpCreateDecoderManifest) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateDecoderManifestInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("IoTAutobahnControlPlane.CreateDecoderManifest")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentCreateDecoderManifestInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpCreateFleet struct {
}

func (*awsAwsjson10_serializeOpCreateFleet) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpCreateFleet) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateFleetInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("IoTAutobahnControlPlane.CreateFleet")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentCreateFleetInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpCreateModelManifest struct {
}

func (*awsAwsjson10_serializeOpCreateModelManifest) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpCreateModelManifest) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateModelManifestInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("IoTAutobahnControlPlane.CreateModelManifest")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentCreateModelManifestInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpCreateSignalCatalog struct {
}

func (*awsAwsjson10_serializeOpCreateSignalCatalog) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpCreateSignalCatalog) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateSignalCatalogInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("IoTAutobahnControlPlane.CreateSignalCatalog")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentCreateSignalCatalogInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpCreateStateTemplate struct {
}

func (*awsAwsjson10_serializeOpCreateStateTemplate) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpCreateStateTemplate) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateStateTemplateInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("IoTAutobahnControlPlane.CreateStateTemplate")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentCreateStateTemplateInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpCreateVehicle struct {
}

func (*awsAwsjson10_serializeOpCreateVehicle) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpCreateVehicle) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateVehicleInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("IoTAutobahnControlPlane.CreateVehicle")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentCreateVehicleInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpDeleteCampaign struct {
}

func (*awsAwsjson10_serializeOpDeleteCampaign) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpDeleteCampaign) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteCampaignInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("IoTAutobahnControlPlane.DeleteCampaign")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentDeleteCampaignInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpDeleteDecoderManifest struct {
}

func (*awsAwsjson10_serializeOpDeleteDecoderManifest) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpDeleteDecoderManifest) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteDecoderManifestInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("IoTAutobahnControlPlane.DeleteDecoderManifest")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentDeleteDecoderManifestInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpDeleteFleet struct {
}

func (*awsAwsjson10_serializeOpDeleteFleet) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpDeleteFleet) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteFleetInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("IoTAutobahnControlPlane.DeleteFleet")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentDeleteFleetInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpDeleteModelManifest struct {
}

func (*awsAwsjson10_serializeOpDeleteModelManifest) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpDeleteModelManifest) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteModelManifestInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("IoTAutobahnControlPlane.DeleteModelManifest")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentDeleteModelManifestInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpDeleteSignalCatalog struct {
}

func (*awsAwsjson10_serializeOpDeleteSignalCatalog) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpDeleteSignalCatalog) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteSignalCatalogInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("IoTAutobahnControlPlane.DeleteSignalCatalog")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentDeleteSignalCatalogInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpDeleteStateTemplate struct {
}

func (*awsAwsjson10_serializeOpDeleteStateTemplate) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpDeleteStateTemplate) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteStateTemplateInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("IoTAutobahnControlPlane.DeleteStateTemplate")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentDeleteStateTemplateInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpDeleteVehicle struct {
}

func (*awsAwsjson10_serializeOpDeleteVehicle) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpDeleteVehicle) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteVehicleInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("IoTAutobahnControlPlane.DeleteVehicle")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentDeleteVehicleInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpDisassociateVehicleFleet struct {
}

func (*awsAwsjson10_serializeOpDisassociateVehicleFleet) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpDisassociateVehicleFleet) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DisassociateVehicleFleetInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("IoTAutobahnControlPlane.DisassociateVehicleFleet")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentDisassociateVehicleFleetInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpGetCampaign struct {
}

func (*awsAwsjson10_serializeOpGetCampaign) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpGetCampaign) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetCampaignInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("IoTAutobahnControlPlane.GetCampaign")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentGetCampaignInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpGetDecoderManifest struct {
}

func (*awsAwsjson10_serializeOpGetDecoderManifest) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpGetDecoderManifest) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetDecoderManifestInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("IoTAutobahnControlPlane.GetDecoderManifest")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentGetDecoderManifestInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpGetEncryptionConfiguration struct {
}

func (*awsAwsjson10_serializeOpGetEncryptionConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpGetEncryptionConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetEncryptionConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("IoTAutobahnControlPlane.GetEncryptionConfiguration")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentGetEncryptionConfigurationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpGetFleet struct {
}

func (*awsAwsjson10_serializeOpGetFleet) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpGetFleet) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetFleetInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("IoTAutobahnControlPlane.GetFleet")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentGetFleetInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpGetLoggingOptions struct {
}

func (*awsAwsjson10_serializeOpGetLoggingOptions) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpGetLoggingOptions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetLoggingOptionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("IoTAutobahnControlPlane.GetLoggingOptions")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentGetLoggingOptionsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpGetModelManifest struct {
}

func (*awsAwsjson10_serializeOpGetModelManifest) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpGetModelManifest) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetModelManifestInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("IoTAutobahnControlPlane.GetModelManifest")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentGetModelManifestInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpGetRegisterAccountStatus struct {
}

func (*awsAwsjson10_serializeOpGetRegisterAccountStatus) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpGetRegisterAccountStatus) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetRegisterAccountStatusInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("IoTAutobahnControlPlane.GetRegisterAccountStatus")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentGetRegisterAccountStatusInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpGetSignalCatalog struct {
}

func (*awsAwsjson10_serializeOpGetSignalCatalog) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpGetSignalCatalog) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetSignalCatalogInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("IoTAutobahnControlPlane.GetSignalCatalog")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentGetSignalCatalogInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpGetStateTemplate struct {
}

func (*awsAwsjson10_serializeOpGetStateTemplate) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpGetStateTemplate) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetStateTemplateInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("IoTAutobahnControlPlane.GetStateTemplate")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentGetStateTemplateInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpGetVehicle struct {
}

func (*awsAwsjson10_serializeOpGetVehicle) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpGetVehicle) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetVehicleInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("IoTAutobahnControlPlane.GetVehicle")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentGetVehicleInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpGetVehicleStatus struct {
}

func (*awsAwsjson10_serializeOpGetVehicleStatus) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpGetVehicleStatus) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetVehicleStatusInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("IoTAutobahnControlPlane.GetVehicleStatus")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentGetVehicleStatusInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpImportDecoderManifest struct {
}

func (*awsAwsjson10_serializeOpImportDecoderManifest) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpImportDecoderManifest) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ImportDecoderManifestInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("IoTAutobahnControlPlane.ImportDecoderManifest")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentImportDecoderManifestInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpImportSignalCatalog struct {
}

func (*awsAwsjson10_serializeOpImportSignalCatalog) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpImportSignalCatalog) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ImportSignalCatalogInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("IoTAutobahnControlPlane.ImportSignalCatalog")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentImportSignalCatalogInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpListCampaigns struct {
}

func (*awsAwsjson10_serializeOpListCampaigns) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpListCampaigns) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListCampaignsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("IoTAutobahnControlPlane.ListCampaigns")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentListCampaignsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpListDecoderManifestNetworkInterfaces struct {
}

func (*awsAwsjson10_serializeOpListDecoderManifestNetworkInterfaces) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpListDecoderManifestNetworkInterfaces) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListDecoderManifestNetworkInterfacesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("IoTAutobahnControlPlane.ListDecoderManifestNetworkInterfaces")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentListDecoderManifestNetworkInterfacesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpListDecoderManifests struct {
}

func (*awsAwsjson10_serializeOpListDecoderManifests) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpListDecoderManifests) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListDecoderManifestsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("IoTAutobahnControlPlane.ListDecoderManifests")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentListDecoderManifestsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpListDecoderManifestSignals struct {
}

func (*awsAwsjson10_serializeOpListDecoderManifestSignals) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpListDecoderManifestSignals) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListDecoderManifestSignalsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("IoTAutobahnControlPlane.ListDecoderManifestSignals")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentListDecoderManifestSignalsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpListFleets struct {
}

func (*awsAwsjson10_serializeOpListFleets) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpListFleets) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListFleetsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("IoTAutobahnControlPlane.ListFleets")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentListFleetsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpListFleetsForVehicle struct {
}

func (*awsAwsjson10_serializeOpListFleetsForVehicle) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpListFleetsForVehicle) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListFleetsForVehicleInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("IoTAutobahnControlPlane.ListFleetsForVehicle")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentListFleetsForVehicleInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpListModelManifestNodes struct {
}

func (*awsAwsjson10_serializeOpListModelManifestNodes) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpListModelManifestNodes) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListModelManifestNodesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("IoTAutobahnControlPlane.ListModelManifestNodes")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentListModelManifestNodesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpListModelManifests struct {
}

func (*awsAwsjson10_serializeOpListModelManifests) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpListModelManifests) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListModelManifestsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("IoTAutobahnControlPlane.ListModelManifests")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentListModelManifestsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpListSignalCatalogNodes struct {
}

func (*awsAwsjson10_serializeOpListSignalCatalogNodes) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpListSignalCatalogNodes) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListSignalCatalogNodesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("IoTAutobahnControlPlane.ListSignalCatalogNodes")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentListSignalCatalogNodesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpListSignalCatalogs struct {
}

func (*awsAwsjson10_serializeOpListSignalCatalogs) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpListSignalCatalogs) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListSignalCatalogsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("IoTAutobahnControlPlane.ListSignalCatalogs")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentListSignalCatalogsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpListStateTemplates struct {
}

func (*awsAwsjson10_serializeOpListStateTemplates) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpListStateTemplates) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListStateTemplatesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("IoTAutobahnControlPlane.ListStateTemplates")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentListStateTemplatesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpListTagsForResource struct {
}

func (*awsAwsjson10_serializeOpListTagsForResource) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpListTagsForResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListTagsForResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("IoTAutobahnControlPlane.ListTagsForResource")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentListTagsForResourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpListVehicles struct {
}

func (*awsAwsjson10_serializeOpListVehicles) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpListVehicles) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListVehiclesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("IoTAutobahnControlPlane.ListVehicles")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentListVehiclesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpListVehiclesInFleet struct {
}

func (*awsAwsjson10_serializeOpListVehiclesInFleet) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpListVehiclesInFleet) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListVehiclesInFleetInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("IoTAutobahnControlPlane.ListVehiclesInFleet")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentListVehiclesInFleetInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpPutEncryptionConfiguration struct {
}

func (*awsAwsjson10_serializeOpPutEncryptionConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpPutEncryptionConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutEncryptionConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("IoTAutobahnControlPlane.PutEncryptionConfiguration")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentPutEncryptionConfigurationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpPutLoggingOptions struct {
}

func (*awsAwsjson10_serializeOpPutLoggingOptions) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpPutLoggingOptions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutLoggingOptionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("IoTAutobahnControlPlane.PutLoggingOptions")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentPutLoggingOptionsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpRegisterAccount struct {
}

func (*awsAwsjson10_serializeOpRegisterAccount) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpRegisterAccount) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*RegisterAccountInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("IoTAutobahnControlPlane.RegisterAccount")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentRegisterAccountInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpTagResource struct {
}

func (*awsAwsjson10_serializeOpTagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpTagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*TagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("IoTAutobahnControlPlane.TagResource")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentTagResourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpUntagResource struct {
}

func (*awsAwsjson10_serializeOpUntagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpUntagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UntagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("IoTAutobahnControlPlane.UntagResource")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentUntagResourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpUpdateCampaign struct {
}

func (*awsAwsjson10_serializeOpUpdateCampaign) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpUpdateCampaign) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateCampaignInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("IoTAutobahnControlPlane.UpdateCampaign")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentUpdateCampaignInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpUpdateDecoderManifest struct {
}

func (*awsAwsjson10_serializeOpUpdateDecoderManifest) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpUpdateDecoderManifest) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateDecoderManifestInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("IoTAutobahnControlPlane.UpdateDecoderManifest")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentUpdateDecoderManifestInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpUpdateFleet struct {
}

func (*awsAwsjson10_serializeOpUpdateFleet) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpUpdateFleet) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateFleetInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("IoTAutobahnControlPlane.UpdateFleet")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentUpdateFleetInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpUpdateModelManifest struct {
}

func (*awsAwsjson10_serializeOpUpdateModelManifest) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpUpdateModelManifest) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateModelManifestInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("IoTAutobahnControlPlane.UpdateModelManifest")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentUpdateModelManifestInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpUpdateSignalCatalog struct {
}

func (*awsAwsjson10_serializeOpUpdateSignalCatalog) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpUpdateSignalCatalog) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateSignalCatalogInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("IoTAutobahnControlPlane.UpdateSignalCatalog")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentUpdateSignalCatalogInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpUpdateStateTemplate struct {
}

func (*awsAwsjson10_serializeOpUpdateStateTemplate) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpUpdateStateTemplate) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateStateTemplateInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("IoTAutobahnControlPlane.UpdateStateTemplate")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentUpdateStateTemplateInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpUpdateVehicle struct {
}

func (*awsAwsjson10_serializeOpUpdateVehicle) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpUpdateVehicle) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateVehicleInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("IoTAutobahnControlPlane.UpdateVehicle")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentUpdateVehicleInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsAwsjson10_serializeDocumentActuator(v *types.Actuator, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AllowedValues != nil {
		ok := object.Key("allowedValues")
		if err := awsAwsjson10_serializeDocumentListOfStrings(v.AllowedValues, ok); err != nil {
			return err
		}
	}

	if v.AssignedValue != nil {
		ok := object.Key("assignedValue")
		ok.String(*v.AssignedValue)
	}

	if v.Comment != nil {
		ok := object.Key("comment")
		ok.String(*v.Comment)
	}

	if len(v.DataType) > 0 {
		ok := object.Key("dataType")
		ok.String(string(v.DataType))
	}

	if v.DeprecationMessage != nil {
		ok := object.Key("deprecationMessage")
		ok.String(*v.DeprecationMessage)
	}

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.FullyQualifiedName != nil {
		ok := object.Key("fullyQualifiedName")
		ok.String(*v.FullyQualifiedName)
	}

	if v.Max != nil {
		ok := object.Key("max")
		switch {
		case math.IsNaN(*v.Max):
			ok.String("NaN")

		case math.IsInf(*v.Max, 1):
			ok.String("Infinity")

		case math.IsInf(*v.Max, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.Max)

		}
	}

	if v.Min != nil {
		ok := object.Key("min")
		switch {
		case math.IsNaN(*v.Min):
			ok.String("NaN")

		case math.IsInf(*v.Min, 1):
			ok.String("Infinity")

		case math.IsInf(*v.Min, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.Min)

		}
	}

	if v.StructFullyQualifiedName != nil {
		ok := object.Key("structFullyQualifiedName")
		ok.String(*v.StructFullyQualifiedName)
	}

	if v.Unit != nil {
		ok := object.Key("unit")
		ok.String(*v.Unit)
	}

	return nil
}

func awsAwsjson10_serializeDocumentAttribute(v *types.Attribute, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AllowedValues != nil {
		ok := object.Key("allowedValues")
		if err := awsAwsjson10_serializeDocumentListOfStrings(v.AllowedValues, ok); err != nil {
			return err
		}
	}

	if v.AssignedValue != nil {
		ok := object.Key("assignedValue")
		ok.String(*v.AssignedValue)
	}

	if v.Comment != nil {
		ok := object.Key("comment")
		ok.String(*v.Comment)
	}

	if len(v.DataType) > 0 {
		ok := object.Key("dataType")
		ok.String(string(v.DataType))
	}

	if v.DefaultValue != nil {
		ok := object.Key("defaultValue")
		ok.String(*v.DefaultValue)
	}

	if v.DeprecationMessage != nil {
		ok := object.Key("deprecationMessage")
		ok.String(*v.DeprecationMessage)
	}

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.FullyQualifiedName != nil {
		ok := object.Key("fullyQualifiedName")
		ok.String(*v.FullyQualifiedName)
	}

	if v.Max != nil {
		ok := object.Key("max")
		switch {
		case math.IsNaN(*v.Max):
			ok.String("NaN")

		case math.IsInf(*v.Max, 1):
			ok.String("Infinity")

		case math.IsInf(*v.Max, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.Max)

		}
	}

	if v.Min != nil {
		ok := object.Key("min")
		switch {
		case math.IsNaN(*v.Min):
			ok.String("NaN")

		case math.IsInf(*v.Min, 1):
			ok.String("Infinity")

		case math.IsInf(*v.Min, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.Min)

		}
	}

	if v.Unit != nil {
		ok := object.Key("unit")
		ok.String(*v.Unit)
	}

	return nil
}

func awsAwsjson10_serializeDocumentAttributeNamesList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson10_serializeDocumentAttributesMap(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsAwsjson10_serializeDocumentAttributeValuesList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson10_serializeDocumentBranch(v *types.Branch, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Comment != nil {
		ok := object.Key("comment")
		ok.String(*v.Comment)
	}

	if v.DeprecationMessage != nil {
		ok := object.Key("deprecationMessage")
		ok.String(*v.DeprecationMessage)
	}

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.FullyQualifiedName != nil {
		ok := object.Key("fullyQualifiedName")
		ok.String(*v.FullyQualifiedName)
	}

	return nil
}

func awsAwsjson10_serializeDocumentCanDbcDefinition(v *types.CanDbcDefinition, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CanDbcFiles != nil {
		ok := object.Key("canDbcFiles")
		if err := awsAwsjson10_serializeDocumentNetworkFilesList(v.CanDbcFiles, ok); err != nil {
			return err
		}
	}

	if v.NetworkInterface != nil {
		ok := object.Key("networkInterface")
		ok.String(*v.NetworkInterface)
	}

	if v.SignalsMap != nil {
		ok := object.Key("signalsMap")
		if err := awsAwsjson10_serializeDocumentModelSignalsMap(v.SignalsMap, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson10_serializeDocumentCanInterface(v *types.CanInterface, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.ProtocolName != nil {
		ok := object.Key("protocolName")
		ok.String(*v.ProtocolName)
	}

	if v.ProtocolVersion != nil {
		ok := object.Key("protocolVersion")
		ok.String(*v.ProtocolVersion)
	}

	return nil
}

func awsAwsjson10_serializeDocumentCanSignal(v *types.CanSignal, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Factor != nil {
		ok := object.Key("factor")
		switch {
		case math.IsNaN(*v.Factor):
			ok.String("NaN")

		case math.IsInf(*v.Factor, 1):
			ok.String("Infinity")

		case math.IsInf(*v.Factor, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.Factor)

		}
	}

	{
		ok := object.Key("isBigEndian")
		ok.Boolean(v.IsBigEndian)
	}

	{
		ok := object.Key("isSigned")
		ok.Boolean(v.IsSigned)
	}

	{
		ok := object.Key("length")
		ok.Integer(v.Length)
	}

	{
		ok := object.Key("messageId")
		ok.Integer(v.MessageId)
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.Offset != nil {
		ok := object.Key("offset")
		switch {
		case math.IsNaN(*v.Offset):
			ok.String("NaN")

		case math.IsInf(*v.Offset, 1):
			ok.String("Infinity")

		case math.IsInf(*v.Offset, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.Offset)

		}
	}

	if len(v.SignalValueType) > 0 {
		ok := object.Key("signalValueType")
		ok.String(string(v.SignalValueType))
	}

	{
		ok := object.Key("startBit")
		ok.Integer(v.StartBit)
	}

	return nil
}

func awsAwsjson10_serializeDocumentCloudWatchLogDeliveryOptions(v *types.CloudWatchLogDeliveryOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.LogGroupName != nil {
		ok := object.Key("logGroupName")
		ok.String(*v.LogGroupName)
	}

	if len(v.LogType) > 0 {
		ok := object.Key("logType")
		ok.String(string(v.LogType))
	}

	return nil
}

func awsAwsjson10_serializeDocumentCollectionScheme(v types.CollectionScheme, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.CollectionSchemeMemberConditionBasedCollectionScheme:
		av := object.Key("conditionBasedCollectionScheme")
		if err := awsAwsjson10_serializeDocumentConditionBasedCollectionScheme(&uv.Value, av); err != nil {
			return err
		}

	case *types.CollectionSchemeMemberTimeBasedCollectionScheme:
		av := object.Key("timeBasedCollectionScheme")
		if err := awsAwsjson10_serializeDocumentTimeBasedCollectionScheme(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsAwsjson10_serializeDocumentConditionBasedCollectionScheme(v *types.ConditionBasedCollectionScheme, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ConditionLanguageVersion != nil {
		ok := object.Key("conditionLanguageVersion")
		ok.Integer(*v.ConditionLanguageVersion)
	}

	if v.Expression != nil {
		ok := object.Key("expression")
		ok.String(*v.Expression)
	}

	if v.MinimumTriggerIntervalMs != nil {
		ok := object.Key("minimumTriggerIntervalMs")
		ok.Long(*v.MinimumTriggerIntervalMs)
	}

	if len(v.TriggerMode) > 0 {
		ok := object.Key("triggerMode")
		ok.String(string(v.TriggerMode))
	}

	return nil
}

func awsAwsjson10_serializeDocumentConditionBasedSignalFetchConfig(v *types.ConditionBasedSignalFetchConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ConditionExpression != nil {
		ok := object.Key("conditionExpression")
		ok.String(*v.ConditionExpression)
	}

	if len(v.TriggerMode) > 0 {
		ok := object.Key("triggerMode")
		ok.String(string(v.TriggerMode))
	}

	return nil
}

func awsAwsjson10_serializeDocumentCreateVehicleRequestItem(v *types.CreateVehicleRequestItem, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.AssociationBehavior) > 0 {
		ok := object.Key("associationBehavior")
		ok.String(string(v.AssociationBehavior))
	}

	if v.Attributes != nil {
		ok := object.Key("attributes")
		if err := awsAwsjson10_serializeDocumentAttributesMap(v.Attributes, ok); err != nil {
			return err
		}
	}

	if v.DecoderManifestArn != nil {
		ok := object.Key("decoderManifestArn")
		ok.String(*v.DecoderManifestArn)
	}

	if v.ModelManifestArn != nil {
		ok := object.Key("modelManifestArn")
		ok.String(*v.ModelManifestArn)
	}

	if v.StateTemplates != nil {
		ok := object.Key("stateTemplates")
		if err := awsAwsjson10_serializeDocumentStateTemplateAssociations(v.StateTemplates, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsAwsjson10_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	if v.VehicleName != nil {
		ok := object.Key("vehicleName")
		ok.String(*v.VehicleName)
	}

	return nil
}

func awsAwsjson10_serializeDocumentCreateVehicleRequestItems(v []types.CreateVehicleRequestItem, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson10_serializeDocumentCreateVehicleRequestItem(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson10_serializeDocumentCustomDecodingInterface(v *types.CustomDecodingInterface, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	return nil
}

func awsAwsjson10_serializeDocumentCustomDecodingSignal(v *types.CustomDecodingSignal, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Id != nil {
		ok := object.Key("id")
		ok.String(*v.Id)
	}

	return nil
}

func awsAwsjson10_serializeDocumentCustomProperty(v *types.CustomProperty, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Comment != nil {
		ok := object.Key("comment")
		ok.String(*v.Comment)
	}

	if len(v.DataEncoding) > 0 {
		ok := object.Key("dataEncoding")
		ok.String(string(v.DataEncoding))
	}

	if len(v.DataType) > 0 {
		ok := object.Key("dataType")
		ok.String(string(v.DataType))
	}

	if v.DeprecationMessage != nil {
		ok := object.Key("deprecationMessage")
		ok.String(*v.DeprecationMessage)
	}

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.FullyQualifiedName != nil {
		ok := object.Key("fullyQualifiedName")
		ok.String(*v.FullyQualifiedName)
	}

	if v.StructFullyQualifiedName != nil {
		ok := object.Key("structFullyQualifiedName")
		ok.String(*v.StructFullyQualifiedName)
	}

	return nil
}

func awsAwsjson10_serializeDocumentCustomStruct(v *types.CustomStruct, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Comment != nil {
		ok := object.Key("comment")
		ok.String(*v.Comment)
	}

	if v.DeprecationMessage != nil {
		ok := object.Key("deprecationMessage")
		ok.String(*v.DeprecationMessage)
	}

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.FullyQualifiedName != nil {
		ok := object.Key("fullyQualifiedName")
		ok.String(*v.FullyQualifiedName)
	}

	return nil
}

func awsAwsjson10_serializeDocumentDataDestinationConfig(v types.DataDestinationConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.DataDestinationConfigMemberMqttTopicConfig:
		av := object.Key("mqttTopicConfig")
		if err := awsAwsjson10_serializeDocumentMqttTopicConfig(&uv.Value, av); err != nil {
			return err
		}

	case *types.DataDestinationConfigMemberS3Config:
		av := object.Key("s3Config")
		if err := awsAwsjson10_serializeDocumentS3Config(&uv.Value, av); err != nil {
			return err
		}

	case *types.DataDestinationConfigMemberTimestreamConfig:
		av := object.Key("timestreamConfig")
		if err := awsAwsjson10_serializeDocumentTimestreamConfig(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsAwsjson10_serializeDocumentDataDestinationConfigs(v []types.DataDestinationConfig, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if vv := v[i]; vv == nil {
			continue
		}
		if err := awsAwsjson10_serializeDocumentDataDestinationConfig(v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson10_serializeDocumentDataExtraDimensionNodePathList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson10_serializeDocumentDataPartition(v *types.DataPartition, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Id != nil {
		ok := object.Key("id")
		ok.String(*v.Id)
	}

	if v.StorageOptions != nil {
		ok := object.Key("storageOptions")
		if err := awsAwsjson10_serializeDocumentDataPartitionStorageOptions(v.StorageOptions, ok); err != nil {
			return err
		}
	}

	if v.UploadOptions != nil {
		ok := object.Key("uploadOptions")
		if err := awsAwsjson10_serializeDocumentDataPartitionUploadOptions(v.UploadOptions, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson10_serializeDocumentDataPartitions(v []types.DataPartition, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson10_serializeDocumentDataPartition(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson10_serializeDocumentDataPartitionStorageOptions(v *types.DataPartitionStorageOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaximumSize != nil {
		ok := object.Key("maximumSize")
		if err := awsAwsjson10_serializeDocumentStorageMaximumSize(v.MaximumSize, ok); err != nil {
			return err
		}
	}

	if v.MinimumTimeToLive != nil {
		ok := object.Key("minimumTimeToLive")
		if err := awsAwsjson10_serializeDocumentStorageMinimumTimeToLive(v.MinimumTimeToLive, ok); err != nil {
			return err
		}
	}

	if v.StorageLocation != nil {
		ok := object.Key("storageLocation")
		ok.String(*v.StorageLocation)
	}

	return nil
}

func awsAwsjson10_serializeDocumentDataPartitionUploadOptions(v *types.DataPartitionUploadOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ConditionLanguageVersion != nil {
		ok := object.Key("conditionLanguageVersion")
		ok.Integer(*v.ConditionLanguageVersion)
	}

	if v.Expression != nil {
		ok := object.Key("expression")
		ok.String(*v.Expression)
	}

	return nil
}

func awsAwsjson10_serializeDocumentEventExpressionList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson10_serializeDocumentFormattedVss(v types.FormattedVss, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.FormattedVssMemberVssJson:
		av := object.Key("vssJson")
		av.String(uv.Value)

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsAwsjson10_serializeDocumentFqns(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson10_serializeDocumentIamResources(v *types.IamResources, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.RoleArn != nil {
		ok := object.Key("roleArn")
		ok.String(*v.RoleArn)
	}

	return nil
}

func awsAwsjson10_serializeDocumentInterfaceIds(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson10_serializeDocumentListOfStrings(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson10_serializeDocumentMessageSignal(v *types.MessageSignal, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.StructuredMessage != nil {
		ok := object.Key("structuredMessage")
		if err := awsAwsjson10_serializeDocumentStructuredMessage(v.StructuredMessage, ok); err != nil {
			return err
		}
	}

	if v.TopicName != nil {
		ok := object.Key("topicName")
		ok.String(*v.TopicName)
	}

	return nil
}

func awsAwsjson10_serializeDocumentModelSignalsMap(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsAwsjson10_serializeDocumentMqttTopicConfig(v *types.MqttTopicConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ExecutionRoleArn != nil {
		ok := object.Key("executionRoleArn")
		ok.String(*v.ExecutionRoleArn)
	}

	if v.MqttTopicArn != nil {
		ok := object.Key("mqttTopicArn")
		ok.String(*v.MqttTopicArn)
	}

	return nil
}

func awsAwsjson10_serializeDocumentNetworkFileDefinition(v types.NetworkFileDefinition, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.NetworkFileDefinitionMemberCanDbc:
		av := object.Key("canDbc")
		if err := awsAwsjson10_serializeDocumentCanDbcDefinition(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsAwsjson10_serializeDocumentNetworkFileDefinitions(v []types.NetworkFileDefinition, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if vv := v[i]; vv == nil {
			continue
		}
		if err := awsAwsjson10_serializeDocumentNetworkFileDefinition(v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson10_serializeDocumentNetworkFilesList(v [][]byte, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if vv := v[i]; vv == nil {
			continue
		}
		av.Base64EncodeBytes(v[i])
	}
	return nil
}

func awsAwsjson10_serializeDocumentNetworkInterface(v *types.NetworkInterface, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CanInterface != nil {
		ok := object.Key("canInterface")
		if err := awsAwsjson10_serializeDocumentCanInterface(v.CanInterface, ok); err != nil {
			return err
		}
	}

	if v.CustomDecodingInterface != nil {
		ok := object.Key("customDecodingInterface")
		if err := awsAwsjson10_serializeDocumentCustomDecodingInterface(v.CustomDecodingInterface, ok); err != nil {
			return err
		}
	}

	if v.InterfaceId != nil {
		ok := object.Key("interfaceId")
		ok.String(*v.InterfaceId)
	}

	if v.ObdInterface != nil {
		ok := object.Key("obdInterface")
		if err := awsAwsjson10_serializeDocumentObdInterface(v.ObdInterface, ok); err != nil {
			return err
		}
	}

	if len(v.Type) > 0 {
		ok := object.Key("type")
		ok.String(string(v.Type))
	}

	if v.VehicleMiddleware != nil {
		ok := object.Key("vehicleMiddleware")
		if err := awsAwsjson10_serializeDocumentVehicleMiddleware(v.VehicleMiddleware, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson10_serializeDocumentNetworkInterfaces(v []types.NetworkInterface, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson10_serializeDocumentNetworkInterface(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson10_serializeDocumentNode(v types.Node, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.NodeMemberActuator:
		av := object.Key("actuator")
		if err := awsAwsjson10_serializeDocumentActuator(&uv.Value, av); err != nil {
			return err
		}

	case *types.NodeMemberAttribute:
		av := object.Key("attribute")
		if err := awsAwsjson10_serializeDocumentAttribute(&uv.Value, av); err != nil {
			return err
		}

	case *types.NodeMemberBranch:
		av := object.Key("branch")
		if err := awsAwsjson10_serializeDocumentBranch(&uv.Value, av); err != nil {
			return err
		}

	case *types.NodeMemberProperty:
		av := object.Key("property")
		if err := awsAwsjson10_serializeDocumentCustomProperty(&uv.Value, av); err != nil {
			return err
		}

	case *types.NodeMemberSensor:
		av := object.Key("sensor")
		if err := awsAwsjson10_serializeDocumentSensor(&uv.Value, av); err != nil {
			return err
		}

	case *types.NodeMemberStruct:
		av := object.Key("struct")
		if err := awsAwsjson10_serializeDocumentCustomStruct(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsAwsjson10_serializeDocumentNodePaths(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson10_serializeDocumentNodes(v []types.Node, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if vv := v[i]; vv == nil {
			continue
		}
		if err := awsAwsjson10_serializeDocumentNode(v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson10_serializeDocumentObdInterface(v *types.ObdInterface, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DtcRequestIntervalSeconds != 0 {
		ok := object.Key("dtcRequestIntervalSeconds")
		ok.Integer(v.DtcRequestIntervalSeconds)
	}

	if v.HasTransmissionEcu {
		ok := object.Key("hasTransmissionEcu")
		ok.Boolean(v.HasTransmissionEcu)
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.ObdStandard != nil {
		ok := object.Key("obdStandard")
		ok.String(*v.ObdStandard)
	}

	if v.PidRequestIntervalSeconds != 0 {
		ok := object.Key("pidRequestIntervalSeconds")
		ok.Integer(v.PidRequestIntervalSeconds)
	}

	{
		ok := object.Key("requestMessageId")
		ok.Integer(v.RequestMessageId)
	}

	if v.UseExtendedIds {
		ok := object.Key("useExtendedIds")
		ok.Boolean(v.UseExtendedIds)
	}

	return nil
}

func awsAwsjson10_serializeDocumentObdSignal(v *types.ObdSignal, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BitMaskLength != nil {
		ok := object.Key("bitMaskLength")
		ok.Integer(*v.BitMaskLength)
	}

	if v.BitRightShift != 0 {
		ok := object.Key("bitRightShift")
		ok.Integer(v.BitRightShift)
	}

	if v.ByteLength != nil {
		ok := object.Key("byteLength")
		ok.Integer(*v.ByteLength)
	}

	if v.IsSigned != nil {
		ok := object.Key("isSigned")
		ok.Boolean(*v.IsSigned)
	}

	if v.Offset != nil {
		ok := object.Key("offset")
		switch {
		case math.IsNaN(*v.Offset):
			ok.String("NaN")

		case math.IsInf(*v.Offset, 1):
			ok.String("Infinity")

		case math.IsInf(*v.Offset, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.Offset)

		}
	}

	{
		ok := object.Key("pid")
		ok.Integer(v.Pid)
	}

	if v.PidResponseLength != nil {
		ok := object.Key("pidResponseLength")
		ok.Integer(*v.PidResponseLength)
	}

	if v.Scaling != nil {
		ok := object.Key("scaling")
		switch {
		case math.IsNaN(*v.Scaling):
			ok.String("NaN")

		case math.IsInf(*v.Scaling, 1):
			ok.String("Infinity")

		case math.IsInf(*v.Scaling, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.Scaling)

		}
	}

	{
		ok := object.Key("serviceMode")
		ok.Integer(v.ServiceMode)
	}

	if len(v.SignalValueType) > 0 {
		ok := object.Key("signalValueType")
		ok.String(string(v.SignalValueType))
	}

	{
		ok := object.Key("startByte")
		ok.Integer(v.StartByte)
	}

	return nil
}

func awsAwsjson10_serializeDocumentOnChangeStateTemplateUpdateStrategy(v *types.OnChangeStateTemplateUpdateStrategy, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	return nil
}

func awsAwsjson10_serializeDocumentPeriodicStateTemplateUpdateStrategy(v *types.PeriodicStateTemplateUpdateStrategy, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.StateTemplateUpdateRate != nil {
		ok := object.Key("stateTemplateUpdateRate")
		if err := awsAwsjson10_serializeDocumentTimePeriod(v.StateTemplateUpdateRate, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson10_serializeDocumentPrimitiveMessageDefinition(v types.PrimitiveMessageDefinition, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.PrimitiveMessageDefinitionMemberRos2PrimitiveMessageDefinition:
		av := object.Key("ros2PrimitiveMessageDefinition")
		if err := awsAwsjson10_serializeDocumentROS2PrimitiveMessageDefinition(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsAwsjson10_serializeDocumentROS2PrimitiveMessageDefinition(v *types.ROS2PrimitiveMessageDefinition, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Offset != nil {
		ok := object.Key("offset")
		switch {
		case math.IsNaN(*v.Offset):
			ok.String("NaN")

		case math.IsInf(*v.Offset, 1):
			ok.String("Infinity")

		case math.IsInf(*v.Offset, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.Offset)

		}
	}

	if len(v.PrimitiveType) > 0 {
		ok := object.Key("primitiveType")
		ok.String(string(v.PrimitiveType))
	}

	if v.Scaling != nil {
		ok := object.Key("scaling")
		switch {
		case math.IsNaN(*v.Scaling):
			ok.String("NaN")

		case math.IsInf(*v.Scaling, 1):
			ok.String("Infinity")

		case math.IsInf(*v.Scaling, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.Scaling)

		}
	}

	if v.UpperBound != nil {
		ok := object.Key("upperBound")
		ok.Long(*v.UpperBound)
	}

	return nil
}

func awsAwsjson10_serializeDocumentS3Config(v *types.S3Config, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BucketArn != nil {
		ok := object.Key("bucketArn")
		ok.String(*v.BucketArn)
	}

	if len(v.DataFormat) > 0 {
		ok := object.Key("dataFormat")
		ok.String(string(v.DataFormat))
	}

	if v.Prefix != nil {
		ok := object.Key("prefix")
		ok.String(*v.Prefix)
	}

	if len(v.StorageCompressionFormat) > 0 {
		ok := object.Key("storageCompressionFormat")
		ok.String(string(v.StorageCompressionFormat))
	}

	return nil
}

func awsAwsjson10_serializeDocumentSensor(v *types.Sensor, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AllowedValues != nil {
		ok := object.Key("allowedValues")
		if err := awsAwsjson10_serializeDocumentListOfStrings(v.AllowedValues, ok); err != nil {
			return err
		}
	}

	if v.Comment != nil {
		ok := object.Key("comment")
		ok.String(*v.Comment)
	}

	if len(v.DataType) > 0 {
		ok := object.Key("dataType")
		ok.String(string(v.DataType))
	}

	if v.DeprecationMessage != nil {
		ok := object.Key("deprecationMessage")
		ok.String(*v.DeprecationMessage)
	}

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.FullyQualifiedName != nil {
		ok := object.Key("fullyQualifiedName")
		ok.String(*v.FullyQualifiedName)
	}

	if v.Max != nil {
		ok := object.Key("max")
		switch {
		case math.IsNaN(*v.Max):
			ok.String("NaN")

		case math.IsInf(*v.Max, 1):
			ok.String("Infinity")

		case math.IsInf(*v.Max, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.Max)

		}
	}

	if v.Min != nil {
		ok := object.Key("min")
		switch {
		case math.IsNaN(*v.Min):
			ok.String("NaN")

		case math.IsInf(*v.Min, 1):
			ok.String("Infinity")

		case math.IsInf(*v.Min, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.Min)

		}
	}

	if v.StructFullyQualifiedName != nil {
		ok := object.Key("structFullyQualifiedName")
		ok.String(*v.StructFullyQualifiedName)
	}

	if v.Unit != nil {
		ok := object.Key("unit")
		ok.String(*v.Unit)
	}

	return nil
}

func awsAwsjson10_serializeDocumentSignalDecoder(v *types.SignalDecoder, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CanSignal != nil {
		ok := object.Key("canSignal")
		if err := awsAwsjson10_serializeDocumentCanSignal(v.CanSignal, ok); err != nil {
			return err
		}
	}

	if v.CustomDecodingSignal != nil {
		ok := object.Key("customDecodingSignal")
		if err := awsAwsjson10_serializeDocumentCustomDecodingSignal(v.CustomDecodingSignal, ok); err != nil {
			return err
		}
	}

	if v.FullyQualifiedName != nil {
		ok := object.Key("fullyQualifiedName")
		ok.String(*v.FullyQualifiedName)
	}

	if v.InterfaceId != nil {
		ok := object.Key("interfaceId")
		ok.String(*v.InterfaceId)
	}

	if v.MessageSignal != nil {
		ok := object.Key("messageSignal")
		if err := awsAwsjson10_serializeDocumentMessageSignal(v.MessageSignal, ok); err != nil {
			return err
		}
	}

	if v.ObdSignal != nil {
		ok := object.Key("obdSignal")
		if err := awsAwsjson10_serializeDocumentObdSignal(v.ObdSignal, ok); err != nil {
			return err
		}
	}

	if len(v.Type) > 0 {
		ok := object.Key("type")
		ok.String(string(v.Type))
	}

	return nil
}

func awsAwsjson10_serializeDocumentSignalDecoders(v []types.SignalDecoder, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson10_serializeDocumentSignalDecoder(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson10_serializeDocumentSignalFetchConfig(v types.SignalFetchConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.SignalFetchConfigMemberConditionBased:
		av := object.Key("conditionBased")
		if err := awsAwsjson10_serializeDocumentConditionBasedSignalFetchConfig(&uv.Value, av); err != nil {
			return err
		}

	case *types.SignalFetchConfigMemberTimeBased:
		av := object.Key("timeBased")
		if err := awsAwsjson10_serializeDocumentTimeBasedSignalFetchConfig(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsAwsjson10_serializeDocumentSignalFetchInformation(v *types.SignalFetchInformation, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Actions != nil {
		ok := object.Key("actions")
		if err := awsAwsjson10_serializeDocumentEventExpressionList(v.Actions, ok); err != nil {
			return err
		}
	}

	if v.ConditionLanguageVersion != nil {
		ok := object.Key("conditionLanguageVersion")
		ok.Integer(*v.ConditionLanguageVersion)
	}

	if v.FullyQualifiedName != nil {
		ok := object.Key("fullyQualifiedName")
		ok.String(*v.FullyQualifiedName)
	}

	if v.SignalFetchConfig != nil {
		ok := object.Key("signalFetchConfig")
		if err := awsAwsjson10_serializeDocumentSignalFetchConfig(v.SignalFetchConfig, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson10_serializeDocumentSignalFetchInformationList(v []types.SignalFetchInformation, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson10_serializeDocumentSignalFetchInformation(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson10_serializeDocumentSignalInformation(v *types.SignalInformation, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DataPartitionId != nil {
		ok := object.Key("dataPartitionId")
		ok.String(*v.DataPartitionId)
	}

	if v.MaxSampleCount != nil {
		ok := object.Key("maxSampleCount")
		ok.Long(*v.MaxSampleCount)
	}

	if v.MinimumSamplingIntervalMs != nil {
		ok := object.Key("minimumSamplingIntervalMs")
		ok.Long(*v.MinimumSamplingIntervalMs)
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	return nil
}

func awsAwsjson10_serializeDocumentSignalInformationList(v []types.SignalInformation, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson10_serializeDocumentSignalInformation(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson10_serializeDocumentStateTemplateAssociation(v *types.StateTemplateAssociation, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Identifier != nil {
		ok := object.Key("identifier")
		ok.String(*v.Identifier)
	}

	if v.StateTemplateUpdateStrategy != nil {
		ok := object.Key("stateTemplateUpdateStrategy")
		if err := awsAwsjson10_serializeDocumentStateTemplateUpdateStrategy(v.StateTemplateUpdateStrategy, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson10_serializeDocumentStateTemplateAssociationIdentifiers(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson10_serializeDocumentStateTemplateAssociations(v []types.StateTemplateAssociation, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson10_serializeDocumentStateTemplateAssociation(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson10_serializeDocumentStateTemplateDataExtraDimensionNodePathList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson10_serializeDocumentStateTemplateMetadataExtraDimensionNodePathList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson10_serializeDocumentStateTemplateProperties(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson10_serializeDocumentStateTemplateUpdateStrategy(v types.StateTemplateUpdateStrategy, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.StateTemplateUpdateStrategyMemberOnChange:
		av := object.Key("onChange")
		if err := awsAwsjson10_serializeDocumentOnChangeStateTemplateUpdateStrategy(&uv.Value, av); err != nil {
			return err
		}

	case *types.StateTemplateUpdateStrategyMemberPeriodic:
		av := object.Key("periodic")
		if err := awsAwsjson10_serializeDocumentPeriodicStateTemplateUpdateStrategy(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsAwsjson10_serializeDocumentStorageMaximumSize(v *types.StorageMaximumSize, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Unit) > 0 {
		ok := object.Key("unit")
		ok.String(string(v.Unit))
	}

	if v.Value != nil {
		ok := object.Key("value")
		ok.Integer(*v.Value)
	}

	return nil
}

func awsAwsjson10_serializeDocumentStorageMinimumTimeToLive(v *types.StorageMinimumTimeToLive, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Unit) > 0 {
		ok := object.Key("unit")
		ok.String(string(v.Unit))
	}

	if v.Value != nil {
		ok := object.Key("value")
		ok.Integer(*v.Value)
	}

	return nil
}

func awsAwsjson10_serializeDocumentStructuredMessage(v types.StructuredMessage, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.StructuredMessageMemberPrimitiveMessageDefinition:
		av := object.Key("primitiveMessageDefinition")
		if err := awsAwsjson10_serializeDocumentPrimitiveMessageDefinition(uv.Value, av); err != nil {
			return err
		}

	case *types.StructuredMessageMemberStructuredMessageDefinition:
		av := object.Key("structuredMessageDefinition")
		if err := awsAwsjson10_serializeDocumentStructuredMessageDefinition(uv.Value, av); err != nil {
			return err
		}

	case *types.StructuredMessageMemberStructuredMessageListDefinition:
		av := object.Key("structuredMessageListDefinition")
		if err := awsAwsjson10_serializeDocumentStructuredMessageListDefinition(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsAwsjson10_serializeDocumentStructuredMessageDefinition(v []types.StructuredMessageFieldNameAndDataTypePair, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson10_serializeDocumentStructuredMessageFieldNameAndDataTypePair(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson10_serializeDocumentStructuredMessageFieldNameAndDataTypePair(v *types.StructuredMessageFieldNameAndDataTypePair, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DataType != nil {
		ok := object.Key("dataType")
		if err := awsAwsjson10_serializeDocumentStructuredMessage(v.DataType, ok); err != nil {
			return err
		}
	}

	if v.FieldName != nil {
		ok := object.Key("fieldName")
		ok.String(*v.FieldName)
	}

	return nil
}

func awsAwsjson10_serializeDocumentStructuredMessageListDefinition(v *types.StructuredMessageListDefinition, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Capacity != 0 {
		ok := object.Key("capacity")
		ok.Integer(v.Capacity)
	}

	if len(v.ListType) > 0 {
		ok := object.Key("listType")
		ok.String(string(v.ListType))
	}

	if v.MemberType != nil {
		ok := object.Key("memberType")
		if err := awsAwsjson10_serializeDocumentStructuredMessage(v.MemberType, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	return nil
}

func awsAwsjson10_serializeDocumentTag(v *types.Tag, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Key != nil {
		ok := object.Key("Key")
		ok.String(*v.Key)
	}

	if v.Value != nil {
		ok := object.Key("Value")
		ok.String(*v.Value)
	}

	return nil
}

func awsAwsjson10_serializeDocumentTagKeyList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson10_serializeDocumentTagList(v []types.Tag, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson10_serializeDocumentTag(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson10_serializeDocumentTimeBasedCollectionScheme(v *types.TimeBasedCollectionScheme, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.PeriodMs != nil {
		ok := object.Key("periodMs")
		ok.Long(*v.PeriodMs)
	}

	return nil
}

func awsAwsjson10_serializeDocumentTimeBasedSignalFetchConfig(v *types.TimeBasedSignalFetchConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ExecutionFrequencyMs != nil {
		ok := object.Key("executionFrequencyMs")
		ok.Long(*v.ExecutionFrequencyMs)
	}

	return nil
}

func awsAwsjson10_serializeDocumentTimePeriod(v *types.TimePeriod, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Unit) > 0 {
		ok := object.Key("unit")
		ok.String(string(v.Unit))
	}

	if v.Value != nil {
		ok := object.Key("value")
		ok.Integer(*v.Value)
	}

	return nil
}

func awsAwsjson10_serializeDocumentTimestreamConfig(v *types.TimestreamConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ExecutionRoleArn != nil {
		ok := object.Key("executionRoleArn")
		ok.String(*v.ExecutionRoleArn)
	}

	if v.TimestreamTableArn != nil {
		ok := object.Key("timestreamTableArn")
		ok.String(*v.TimestreamTableArn)
	}

	return nil
}

func awsAwsjson10_serializeDocumentTimestreamResources(v *types.TimestreamResources, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.TimestreamDatabaseName != nil {
		ok := object.Key("timestreamDatabaseName")
		ok.String(*v.TimestreamDatabaseName)
	}

	if v.TimestreamTableName != nil {
		ok := object.Key("timestreamTableName")
		ok.String(*v.TimestreamTableName)
	}

	return nil
}

func awsAwsjson10_serializeDocumentUpdateVehicleRequestItem(v *types.UpdateVehicleRequestItem, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Attributes != nil {
		ok := object.Key("attributes")
		if err := awsAwsjson10_serializeDocumentAttributesMap(v.Attributes, ok); err != nil {
			return err
		}
	}

	if len(v.AttributeUpdateMode) > 0 {
		ok := object.Key("attributeUpdateMode")
		ok.String(string(v.AttributeUpdateMode))
	}

	if v.DecoderManifestArn != nil {
		ok := object.Key("decoderManifestArn")
		ok.String(*v.DecoderManifestArn)
	}

	if v.ModelManifestArn != nil {
		ok := object.Key("modelManifestArn")
		ok.String(*v.ModelManifestArn)
	}

	if v.StateTemplatesToAdd != nil {
		ok := object.Key("stateTemplatesToAdd")
		if err := awsAwsjson10_serializeDocumentStateTemplateAssociations(v.StateTemplatesToAdd, ok); err != nil {
			return err
		}
	}

	if v.StateTemplatesToRemove != nil {
		ok := object.Key("stateTemplatesToRemove")
		if err := awsAwsjson10_serializeDocumentStateTemplateAssociationIdentifiers(v.StateTemplatesToRemove, ok); err != nil {
			return err
		}
	}

	if v.StateTemplatesToUpdate != nil {
		ok := object.Key("stateTemplatesToUpdate")
		if err := awsAwsjson10_serializeDocumentStateTemplateAssociations(v.StateTemplatesToUpdate, ok); err != nil {
			return err
		}
	}

	if v.VehicleName != nil {
		ok := object.Key("vehicleName")
		ok.String(*v.VehicleName)
	}

	return nil
}

func awsAwsjson10_serializeDocumentUpdateVehicleRequestItems(v []types.UpdateVehicleRequestItem, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson10_serializeDocumentUpdateVehicleRequestItem(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson10_serializeDocumentVehicleMiddleware(v *types.VehicleMiddleware, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if len(v.ProtocolName) > 0 {
		ok := object.Key("protocolName")
		ok.String(string(v.ProtocolName))
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentAssociateVehicleFleetInput(v *AssociateVehicleFleetInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FleetId != nil {
		ok := object.Key("fleetId")
		ok.String(*v.FleetId)
	}

	if v.VehicleName != nil {
		ok := object.Key("vehicleName")
		ok.String(*v.VehicleName)
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentBatchCreateVehicleInput(v *BatchCreateVehicleInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Vehicles != nil {
		ok := object.Key("vehicles")
		if err := awsAwsjson10_serializeDocumentCreateVehicleRequestItems(v.Vehicles, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentBatchUpdateVehicleInput(v *BatchUpdateVehicleInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Vehicles != nil {
		ok := object.Key("vehicles")
		if err := awsAwsjson10_serializeDocumentUpdateVehicleRequestItems(v.Vehicles, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentCreateCampaignInput(v *CreateCampaignInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CollectionScheme != nil {
		ok := object.Key("collectionScheme")
		if err := awsAwsjson10_serializeDocumentCollectionScheme(v.CollectionScheme, ok); err != nil {
			return err
		}
	}

	if len(v.Compression) > 0 {
		ok := object.Key("compression")
		ok.String(string(v.Compression))
	}

	if v.DataDestinationConfigs != nil {
		ok := object.Key("dataDestinationConfigs")
		if err := awsAwsjson10_serializeDocumentDataDestinationConfigs(v.DataDestinationConfigs, ok); err != nil {
			return err
		}
	}

	if v.DataExtraDimensions != nil {
		ok := object.Key("dataExtraDimensions")
		if err := awsAwsjson10_serializeDocumentDataExtraDimensionNodePathList(v.DataExtraDimensions, ok); err != nil {
			return err
		}
	}

	if v.DataPartitions != nil {
		ok := object.Key("dataPartitions")
		if err := awsAwsjson10_serializeDocumentDataPartitions(v.DataPartitions, ok); err != nil {
			return err
		}
	}

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if len(v.DiagnosticsMode) > 0 {
		ok := object.Key("diagnosticsMode")
		ok.String(string(v.DiagnosticsMode))
	}

	if v.ExpiryTime != nil {
		ok := object.Key("expiryTime")
		ok.Double(smithytime.FormatEpochSeconds(*v.ExpiryTime))
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.PostTriggerCollectionDuration != nil {
		ok := object.Key("postTriggerCollectionDuration")
		ok.Long(*v.PostTriggerCollectionDuration)
	}

	if v.Priority != nil {
		ok := object.Key("priority")
		ok.Integer(*v.Priority)
	}

	if v.SignalCatalogArn != nil {
		ok := object.Key("signalCatalogArn")
		ok.String(*v.SignalCatalogArn)
	}

	if v.SignalsToCollect != nil {
		ok := object.Key("signalsToCollect")
		if err := awsAwsjson10_serializeDocumentSignalInformationList(v.SignalsToCollect, ok); err != nil {
			return err
		}
	}

	if v.SignalsToFetch != nil {
		ok := object.Key("signalsToFetch")
		if err := awsAwsjson10_serializeDocumentSignalFetchInformationList(v.SignalsToFetch, ok); err != nil {
			return err
		}
	}

	if len(v.SpoolingMode) > 0 {
		ok := object.Key("spoolingMode")
		ok.String(string(v.SpoolingMode))
	}

	if v.StartTime != nil {
		ok := object.Key("startTime")
		ok.Double(smithytime.FormatEpochSeconds(*v.StartTime))
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsAwsjson10_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	if v.TargetArn != nil {
		ok := object.Key("targetArn")
		ok.String(*v.TargetArn)
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentCreateDecoderManifestInput(v *CreateDecoderManifestInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.DefaultForUnmappedSignals) > 0 {
		ok := object.Key("defaultForUnmappedSignals")
		ok.String(string(v.DefaultForUnmappedSignals))
	}

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.ModelManifestArn != nil {
		ok := object.Key("modelManifestArn")
		ok.String(*v.ModelManifestArn)
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.NetworkInterfaces != nil {
		ok := object.Key("networkInterfaces")
		if err := awsAwsjson10_serializeDocumentNetworkInterfaces(v.NetworkInterfaces, ok); err != nil {
			return err
		}
	}

	if v.SignalDecoders != nil {
		ok := object.Key("signalDecoders")
		if err := awsAwsjson10_serializeDocumentSignalDecoders(v.SignalDecoders, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsAwsjson10_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentCreateFleetInput(v *CreateFleetInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.FleetId != nil {
		ok := object.Key("fleetId")
		ok.String(*v.FleetId)
	}

	if v.SignalCatalogArn != nil {
		ok := object.Key("signalCatalogArn")
		ok.String(*v.SignalCatalogArn)
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsAwsjson10_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentCreateModelManifestInput(v *CreateModelManifestInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.Nodes != nil {
		ok := object.Key("nodes")
		if err := awsAwsjson10_serializeDocumentListOfStrings(v.Nodes, ok); err != nil {
			return err
		}
	}

	if v.SignalCatalogArn != nil {
		ok := object.Key("signalCatalogArn")
		ok.String(*v.SignalCatalogArn)
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsAwsjson10_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentCreateSignalCatalogInput(v *CreateSignalCatalogInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.Nodes != nil {
		ok := object.Key("nodes")
		if err := awsAwsjson10_serializeDocumentNodes(v.Nodes, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsAwsjson10_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentCreateStateTemplateInput(v *CreateStateTemplateInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DataExtraDimensions != nil {
		ok := object.Key("dataExtraDimensions")
		if err := awsAwsjson10_serializeDocumentStateTemplateDataExtraDimensionNodePathList(v.DataExtraDimensions, ok); err != nil {
			return err
		}
	}

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.MetadataExtraDimensions != nil {
		ok := object.Key("metadataExtraDimensions")
		if err := awsAwsjson10_serializeDocumentStateTemplateMetadataExtraDimensionNodePathList(v.MetadataExtraDimensions, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.SignalCatalogArn != nil {
		ok := object.Key("signalCatalogArn")
		ok.String(*v.SignalCatalogArn)
	}

	if v.StateTemplateProperties != nil {
		ok := object.Key("stateTemplateProperties")
		if err := awsAwsjson10_serializeDocumentStateTemplateProperties(v.StateTemplateProperties, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsAwsjson10_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentCreateVehicleInput(v *CreateVehicleInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.AssociationBehavior) > 0 {
		ok := object.Key("associationBehavior")
		ok.String(string(v.AssociationBehavior))
	}

	if v.Attributes != nil {
		ok := object.Key("attributes")
		if err := awsAwsjson10_serializeDocumentAttributesMap(v.Attributes, ok); err != nil {
			return err
		}
	}

	if v.DecoderManifestArn != nil {
		ok := object.Key("decoderManifestArn")
		ok.String(*v.DecoderManifestArn)
	}

	if v.ModelManifestArn != nil {
		ok := object.Key("modelManifestArn")
		ok.String(*v.ModelManifestArn)
	}

	if v.StateTemplates != nil {
		ok := object.Key("stateTemplates")
		if err := awsAwsjson10_serializeDocumentStateTemplateAssociations(v.StateTemplates, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsAwsjson10_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	if v.VehicleName != nil {
		ok := object.Key("vehicleName")
		ok.String(*v.VehicleName)
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentDeleteCampaignInput(v *DeleteCampaignInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentDeleteDecoderManifestInput(v *DeleteDecoderManifestInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentDeleteFleetInput(v *DeleteFleetInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FleetId != nil {
		ok := object.Key("fleetId")
		ok.String(*v.FleetId)
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentDeleteModelManifestInput(v *DeleteModelManifestInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentDeleteSignalCatalogInput(v *DeleteSignalCatalogInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentDeleteStateTemplateInput(v *DeleteStateTemplateInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Identifier != nil {
		ok := object.Key("identifier")
		ok.String(*v.Identifier)
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentDeleteVehicleInput(v *DeleteVehicleInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.VehicleName != nil {
		ok := object.Key("vehicleName")
		ok.String(*v.VehicleName)
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentDisassociateVehicleFleetInput(v *DisassociateVehicleFleetInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FleetId != nil {
		ok := object.Key("fleetId")
		ok.String(*v.FleetId)
	}

	if v.VehicleName != nil {
		ok := object.Key("vehicleName")
		ok.String(*v.VehicleName)
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentGetCampaignInput(v *GetCampaignInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentGetDecoderManifestInput(v *GetDecoderManifestInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentGetEncryptionConfigurationInput(v *GetEncryptionConfigurationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	return nil
}

func awsAwsjson10_serializeOpDocumentGetFleetInput(v *GetFleetInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FleetId != nil {
		ok := object.Key("fleetId")
		ok.String(*v.FleetId)
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentGetLoggingOptionsInput(v *GetLoggingOptionsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	return nil
}

func awsAwsjson10_serializeOpDocumentGetModelManifestInput(v *GetModelManifestInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentGetRegisterAccountStatusInput(v *GetRegisterAccountStatusInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	return nil
}

func awsAwsjson10_serializeOpDocumentGetSignalCatalogInput(v *GetSignalCatalogInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentGetStateTemplateInput(v *GetStateTemplateInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Identifier != nil {
		ok := object.Key("identifier")
		ok.String(*v.Identifier)
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentGetVehicleInput(v *GetVehicleInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.VehicleName != nil {
		ok := object.Key("vehicleName")
		ok.String(*v.VehicleName)
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentGetVehicleStatusInput(v *GetVehicleStatusInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("maxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("nextToken")
		ok.String(*v.NextToken)
	}

	if v.VehicleName != nil {
		ok := object.Key("vehicleName")
		ok.String(*v.VehicleName)
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentImportDecoderManifestInput(v *ImportDecoderManifestInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.NetworkFileDefinitions != nil {
		ok := object.Key("networkFileDefinitions")
		if err := awsAwsjson10_serializeDocumentNetworkFileDefinitions(v.NetworkFileDefinitions, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentImportSignalCatalogInput(v *ImportSignalCatalogInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsAwsjson10_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	if v.Vss != nil {
		ok := object.Key("vss")
		if err := awsAwsjson10_serializeDocumentFormattedVss(v.Vss, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentListCampaignsInput(v *ListCampaignsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.ListResponseScope) > 0 {
		ok := object.Key("listResponseScope")
		ok.String(string(v.ListResponseScope))
	}

	if v.MaxResults != nil {
		ok := object.Key("maxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("nextToken")
		ok.String(*v.NextToken)
	}

	if v.Status != nil {
		ok := object.Key("status")
		ok.String(*v.Status)
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentListDecoderManifestNetworkInterfacesInput(v *ListDecoderManifestNetworkInterfacesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("maxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.NextToken != nil {
		ok := object.Key("nextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentListDecoderManifestSignalsInput(v *ListDecoderManifestSignalsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("maxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.NextToken != nil {
		ok := object.Key("nextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentListDecoderManifestsInput(v *ListDecoderManifestsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.ListResponseScope) > 0 {
		ok := object.Key("listResponseScope")
		ok.String(string(v.ListResponseScope))
	}

	if v.MaxResults != nil {
		ok := object.Key("maxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.ModelManifestArn != nil {
		ok := object.Key("modelManifestArn")
		ok.String(*v.ModelManifestArn)
	}

	if v.NextToken != nil {
		ok := object.Key("nextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentListFleetsForVehicleInput(v *ListFleetsForVehicleInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("maxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("nextToken")
		ok.String(*v.NextToken)
	}

	if v.VehicleName != nil {
		ok := object.Key("vehicleName")
		ok.String(*v.VehicleName)
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentListFleetsInput(v *ListFleetsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.ListResponseScope) > 0 {
		ok := object.Key("listResponseScope")
		ok.String(string(v.ListResponseScope))
	}

	if v.MaxResults != nil {
		ok := object.Key("maxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("nextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentListModelManifestNodesInput(v *ListModelManifestNodesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("maxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.NextToken != nil {
		ok := object.Key("nextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentListModelManifestsInput(v *ListModelManifestsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.ListResponseScope) > 0 {
		ok := object.Key("listResponseScope")
		ok.String(string(v.ListResponseScope))
	}

	if v.MaxResults != nil {
		ok := object.Key("maxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("nextToken")
		ok.String(*v.NextToken)
	}

	if v.SignalCatalogArn != nil {
		ok := object.Key("signalCatalogArn")
		ok.String(*v.SignalCatalogArn)
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentListSignalCatalogNodesInput(v *ListSignalCatalogNodesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("maxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.NextToken != nil {
		ok := object.Key("nextToken")
		ok.String(*v.NextToken)
	}

	if len(v.SignalNodeType) > 0 {
		ok := object.Key("signalNodeType")
		ok.String(string(v.SignalNodeType))
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentListSignalCatalogsInput(v *ListSignalCatalogsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("maxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("nextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentListStateTemplatesInput(v *ListStateTemplatesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.ListResponseScope) > 0 {
		ok := object.Key("listResponseScope")
		ok.String(string(v.ListResponseScope))
	}

	if v.MaxResults != nil {
		ok := object.Key("maxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("nextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentListTagsForResourceInput(v *ListTagsForResourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ResourceARN != nil {
		ok := object.Key("ResourceARN")
		ok.String(*v.ResourceARN)
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentListVehiclesInFleetInput(v *ListVehiclesInFleetInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FleetId != nil {
		ok := object.Key("fleetId")
		ok.String(*v.FleetId)
	}

	if v.MaxResults != nil {
		ok := object.Key("maxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("nextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentListVehiclesInput(v *ListVehiclesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AttributeNames != nil {
		ok := object.Key("attributeNames")
		if err := awsAwsjson10_serializeDocumentAttributeNamesList(v.AttributeNames, ok); err != nil {
			return err
		}
	}

	if v.AttributeValues != nil {
		ok := object.Key("attributeValues")
		if err := awsAwsjson10_serializeDocumentAttributeValuesList(v.AttributeValues, ok); err != nil {
			return err
		}
	}

	if len(v.ListResponseScope) > 0 {
		ok := object.Key("listResponseScope")
		ok.String(string(v.ListResponseScope))
	}

	if v.MaxResults != nil {
		ok := object.Key("maxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.ModelManifestArn != nil {
		ok := object.Key("modelManifestArn")
		ok.String(*v.ModelManifestArn)
	}

	if v.NextToken != nil {
		ok := object.Key("nextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentPutEncryptionConfigurationInput(v *PutEncryptionConfigurationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.EncryptionType) > 0 {
		ok := object.Key("encryptionType")
		ok.String(string(v.EncryptionType))
	}

	if v.KmsKeyId != nil {
		ok := object.Key("kmsKeyId")
		ok.String(*v.KmsKeyId)
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentPutLoggingOptionsInput(v *PutLoggingOptionsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CloudWatchLogDelivery != nil {
		ok := object.Key("cloudWatchLogDelivery")
		if err := awsAwsjson10_serializeDocumentCloudWatchLogDeliveryOptions(v.CloudWatchLogDelivery, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentRegisterAccountInput(v *RegisterAccountInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.IamResources != nil {
		ok := object.Key("iamResources")
		if err := awsAwsjson10_serializeDocumentIamResources(v.IamResources, ok); err != nil {
			return err
		}
	}

	if v.TimestreamResources != nil {
		ok := object.Key("timestreamResources")
		if err := awsAwsjson10_serializeDocumentTimestreamResources(v.TimestreamResources, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentTagResourceInput(v *TagResourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ResourceARN != nil {
		ok := object.Key("ResourceARN")
		ok.String(*v.ResourceARN)
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsAwsjson10_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentUntagResourceInput(v *UntagResourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ResourceARN != nil {
		ok := object.Key("ResourceARN")
		ok.String(*v.ResourceARN)
	}

	if v.TagKeys != nil {
		ok := object.Key("TagKeys")
		if err := awsAwsjson10_serializeDocumentTagKeyList(v.TagKeys, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentUpdateCampaignInput(v *UpdateCampaignInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Action) > 0 {
		ok := object.Key("action")
		ok.String(string(v.Action))
	}

	if v.DataExtraDimensions != nil {
		ok := object.Key("dataExtraDimensions")
		if err := awsAwsjson10_serializeDocumentDataExtraDimensionNodePathList(v.DataExtraDimensions, ok); err != nil {
			return err
		}
	}

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentUpdateDecoderManifestInput(v *UpdateDecoderManifestInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.DefaultForUnmappedSignals) > 0 {
		ok := object.Key("defaultForUnmappedSignals")
		ok.String(string(v.DefaultForUnmappedSignals))
	}

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.NetworkInterfacesToAdd != nil {
		ok := object.Key("networkInterfacesToAdd")
		if err := awsAwsjson10_serializeDocumentNetworkInterfaces(v.NetworkInterfacesToAdd, ok); err != nil {
			return err
		}
	}

	if v.NetworkInterfacesToRemove != nil {
		ok := object.Key("networkInterfacesToRemove")
		if err := awsAwsjson10_serializeDocumentInterfaceIds(v.NetworkInterfacesToRemove, ok); err != nil {
			return err
		}
	}

	if v.NetworkInterfacesToUpdate != nil {
		ok := object.Key("networkInterfacesToUpdate")
		if err := awsAwsjson10_serializeDocumentNetworkInterfaces(v.NetworkInterfacesToUpdate, ok); err != nil {
			return err
		}
	}

	if v.SignalDecodersToAdd != nil {
		ok := object.Key("signalDecodersToAdd")
		if err := awsAwsjson10_serializeDocumentSignalDecoders(v.SignalDecodersToAdd, ok); err != nil {
			return err
		}
	}

	if v.SignalDecodersToRemove != nil {
		ok := object.Key("signalDecodersToRemove")
		if err := awsAwsjson10_serializeDocumentFqns(v.SignalDecodersToRemove, ok); err != nil {
			return err
		}
	}

	if v.SignalDecodersToUpdate != nil {
		ok := object.Key("signalDecodersToUpdate")
		if err := awsAwsjson10_serializeDocumentSignalDecoders(v.SignalDecodersToUpdate, ok); err != nil {
			return err
		}
	}

	if len(v.Status) > 0 {
		ok := object.Key("status")
		ok.String(string(v.Status))
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentUpdateFleetInput(v *UpdateFleetInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.FleetId != nil {
		ok := object.Key("fleetId")
		ok.String(*v.FleetId)
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentUpdateModelManifestInput(v *UpdateModelManifestInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.NodesToAdd != nil {
		ok := object.Key("nodesToAdd")
		if err := awsAwsjson10_serializeDocumentNodePaths(v.NodesToAdd, ok); err != nil {
			return err
		}
	}

	if v.NodesToRemove != nil {
		ok := object.Key("nodesToRemove")
		if err := awsAwsjson10_serializeDocumentNodePaths(v.NodesToRemove, ok); err != nil {
			return err
		}
	}

	if len(v.Status) > 0 {
		ok := object.Key("status")
		ok.String(string(v.Status))
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentUpdateSignalCatalogInput(v *UpdateSignalCatalogInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.NodesToAdd != nil {
		ok := object.Key("nodesToAdd")
		if err := awsAwsjson10_serializeDocumentNodes(v.NodesToAdd, ok); err != nil {
			return err
		}
	}

	if v.NodesToRemove != nil {
		ok := object.Key("nodesToRemove")
		if err := awsAwsjson10_serializeDocumentNodePaths(v.NodesToRemove, ok); err != nil {
			return err
		}
	}

	if v.NodesToUpdate != nil {
		ok := object.Key("nodesToUpdate")
		if err := awsAwsjson10_serializeDocumentNodes(v.NodesToUpdate, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentUpdateStateTemplateInput(v *UpdateStateTemplateInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DataExtraDimensions != nil {
		ok := object.Key("dataExtraDimensions")
		if err := awsAwsjson10_serializeDocumentStateTemplateDataExtraDimensionNodePathList(v.DataExtraDimensions, ok); err != nil {
			return err
		}
	}

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.Identifier != nil {
		ok := object.Key("identifier")
		ok.String(*v.Identifier)
	}

	if v.MetadataExtraDimensions != nil {
		ok := object.Key("metadataExtraDimensions")
		if err := awsAwsjson10_serializeDocumentStateTemplateMetadataExtraDimensionNodePathList(v.MetadataExtraDimensions, ok); err != nil {
			return err
		}
	}

	if v.StateTemplatePropertiesToAdd != nil {
		ok := object.Key("stateTemplatePropertiesToAdd")
		if err := awsAwsjson10_serializeDocumentStateTemplateProperties(v.StateTemplatePropertiesToAdd, ok); err != nil {
			return err
		}
	}

	if v.StateTemplatePropertiesToRemove != nil {
		ok := object.Key("stateTemplatePropertiesToRemove")
		if err := awsAwsjson10_serializeDocumentStateTemplateProperties(v.StateTemplatePropertiesToRemove, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentUpdateVehicleInput(v *UpdateVehicleInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Attributes != nil {
		ok := object.Key("attributes")
		if err := awsAwsjson10_serializeDocumentAttributesMap(v.Attributes, ok); err != nil {
			return err
		}
	}

	if len(v.AttributeUpdateMode) > 0 {
		ok := object.Key("attributeUpdateMode")
		ok.String(string(v.AttributeUpdateMode))
	}

	if v.DecoderManifestArn != nil {
		ok := object.Key("decoderManifestArn")
		ok.String(*v.DecoderManifestArn)
	}

	if v.ModelManifestArn != nil {
		ok := object.Key("modelManifestArn")
		ok.String(*v.ModelManifestArn)
	}

	if v.StateTemplatesToAdd != nil {
		ok := object.Key("stateTemplatesToAdd")
		if err := awsAwsjson10_serializeDocumentStateTemplateAssociations(v.StateTemplatesToAdd, ok); err != nil {
			return err
		}
	}

	if v.StateTemplatesToRemove != nil {
		ok := object.Key("stateTemplatesToRemove")
		if err := awsAwsjson10_serializeDocumentStateTemplateAssociationIdentifiers(v.StateTemplatesToRemove, ok); err != nil {
			return err
		}
	}

	if v.StateTemplatesToUpdate != nil {
		ok := object.Key("stateTemplatesToUpdate")
		if err := awsAwsjson10_serializeDocumentStateTemplateAssociations(v.StateTemplatesToUpdate, ok); err != nil {
			return err
		}
	}

	if v.VehicleName != nil {
		ok := object.Key("vehicleName")
		ok.String(*v.VehicleName)
	}

	return nil
}
