// Code generated by smithy-go-codegen DO NOT EDIT.

package inspector2

import (
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/inspector2/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/middleware"
)

type validateOpAssociateMember struct {
}

func (*validateOpAssociateMember) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpAssociateMember) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*AssociateMemberInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpAssociateMemberInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpBatchGetCodeSnippet struct {
}

func (*validateOpBatchGetCodeSnippet) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpBatchGetCodeSnippet) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*BatchGetCodeSnippetInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpBatchGetCodeSnippetInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpBatchGetFindingDetails struct {
}

func (*validateOpBatchGetFindingDetails) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpBatchGetFindingDetails) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*BatchGetFindingDetailsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpBatchGetFindingDetailsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpBatchGetFreeTrialInfo struct {
}

func (*validateOpBatchGetFreeTrialInfo) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpBatchGetFreeTrialInfo) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*BatchGetFreeTrialInfoInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpBatchGetFreeTrialInfoInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpBatchUpdateMemberEc2DeepInspectionStatus struct {
}

func (*validateOpBatchUpdateMemberEc2DeepInspectionStatus) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpBatchUpdateMemberEc2DeepInspectionStatus) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*BatchUpdateMemberEc2DeepInspectionStatusInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpBatchUpdateMemberEc2DeepInspectionStatusInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCancelFindingsReport struct {
}

func (*validateOpCancelFindingsReport) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCancelFindingsReport) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CancelFindingsReportInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCancelFindingsReportInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCancelSbomExport struct {
}

func (*validateOpCancelSbomExport) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCancelSbomExport) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CancelSbomExportInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCancelSbomExportInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateCisScanConfiguration struct {
}

func (*validateOpCreateCisScanConfiguration) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateCisScanConfiguration) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateCisScanConfigurationInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateCisScanConfigurationInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateFilter struct {
}

func (*validateOpCreateFilter) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateFilter) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateFilterInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateFilterInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateFindingsReport struct {
}

func (*validateOpCreateFindingsReport) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateFindingsReport) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateFindingsReportInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateFindingsReportInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateSbomExport struct {
}

func (*validateOpCreateSbomExport) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateSbomExport) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateSbomExportInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateSbomExportInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteCisScanConfiguration struct {
}

func (*validateOpDeleteCisScanConfiguration) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteCisScanConfiguration) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteCisScanConfigurationInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteCisScanConfigurationInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteFilter struct {
}

func (*validateOpDeleteFilter) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteFilter) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteFilterInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteFilterInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDisableDelegatedAdminAccount struct {
}

func (*validateOpDisableDelegatedAdminAccount) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDisableDelegatedAdminAccount) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DisableDelegatedAdminAccountInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDisableDelegatedAdminAccountInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDisassociateMember struct {
}

func (*validateOpDisassociateMember) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDisassociateMember) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DisassociateMemberInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDisassociateMemberInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpEnableDelegatedAdminAccount struct {
}

func (*validateOpEnableDelegatedAdminAccount) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpEnableDelegatedAdminAccount) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*EnableDelegatedAdminAccountInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpEnableDelegatedAdminAccountInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpEnable struct {
}

func (*validateOpEnable) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpEnable) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*EnableInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpEnableInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetCisScanReport struct {
}

func (*validateOpGetCisScanReport) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetCisScanReport) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetCisScanReportInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetCisScanReportInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetCisScanResultDetails struct {
}

func (*validateOpGetCisScanResultDetails) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetCisScanResultDetails) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetCisScanResultDetailsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetCisScanResultDetailsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetClustersForImage struct {
}

func (*validateOpGetClustersForImage) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetClustersForImage) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetClustersForImageInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetClustersForImageInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetEncryptionKey struct {
}

func (*validateOpGetEncryptionKey) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetEncryptionKey) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetEncryptionKeyInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetEncryptionKeyInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetMember struct {
}

func (*validateOpGetMember) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetMember) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetMemberInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetMemberInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetSbomExport struct {
}

func (*validateOpGetSbomExport) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetSbomExport) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetSbomExportInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetSbomExportInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListCisScanConfigurations struct {
}

func (*validateOpListCisScanConfigurations) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListCisScanConfigurations) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListCisScanConfigurationsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListCisScanConfigurationsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListCisScanResultsAggregatedByChecks struct {
}

func (*validateOpListCisScanResultsAggregatedByChecks) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListCisScanResultsAggregatedByChecks) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListCisScanResultsAggregatedByChecksInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListCisScanResultsAggregatedByChecksInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListCisScanResultsAggregatedByTargetResource struct {
}

func (*validateOpListCisScanResultsAggregatedByTargetResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListCisScanResultsAggregatedByTargetResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListCisScanResultsAggregatedByTargetResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListCisScanResultsAggregatedByTargetResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListCisScans struct {
}

func (*validateOpListCisScans) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListCisScans) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListCisScansInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListCisScansInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListCoverage struct {
}

func (*validateOpListCoverage) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListCoverage) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListCoverageInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListCoverageInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListCoverageStatistics struct {
}

func (*validateOpListCoverageStatistics) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListCoverageStatistics) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListCoverageStatisticsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListCoverageStatisticsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListFindingAggregations struct {
}

func (*validateOpListFindingAggregations) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListFindingAggregations) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListFindingAggregationsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListFindingAggregationsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListFindings struct {
}

func (*validateOpListFindings) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListFindings) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListFindingsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListFindingsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListTagsForResource struct {
}

func (*validateOpListTagsForResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListTagsForResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListTagsForResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListTagsForResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpResetEncryptionKey struct {
}

func (*validateOpResetEncryptionKey) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpResetEncryptionKey) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ResetEncryptionKeyInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpResetEncryptionKeyInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpSearchVulnerabilities struct {
}

func (*validateOpSearchVulnerabilities) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpSearchVulnerabilities) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*SearchVulnerabilitiesInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpSearchVulnerabilitiesInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpSendCisSessionHealth struct {
}

func (*validateOpSendCisSessionHealth) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpSendCisSessionHealth) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*SendCisSessionHealthInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpSendCisSessionHealthInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpSendCisSessionTelemetry struct {
}

func (*validateOpSendCisSessionTelemetry) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpSendCisSessionTelemetry) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*SendCisSessionTelemetryInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpSendCisSessionTelemetryInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpStartCisSession struct {
}

func (*validateOpStartCisSession) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpStartCisSession) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*StartCisSessionInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpStartCisSessionInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpStopCisSession struct {
}

func (*validateOpStopCisSession) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpStopCisSession) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*StopCisSessionInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpStopCisSessionInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpTagResource struct {
}

func (*validateOpTagResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpTagResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*TagResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpTagResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUntagResource struct {
}

func (*validateOpUntagResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUntagResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UntagResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUntagResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateCisScanConfiguration struct {
}

func (*validateOpUpdateCisScanConfiguration) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateCisScanConfiguration) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateCisScanConfigurationInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateCisScanConfigurationInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateConfiguration struct {
}

func (*validateOpUpdateConfiguration) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateConfiguration) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateConfigurationInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateConfigurationInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateEncryptionKey struct {
}

func (*validateOpUpdateEncryptionKey) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateEncryptionKey) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateEncryptionKeyInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateEncryptionKeyInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateFilter struct {
}

func (*validateOpUpdateFilter) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateFilter) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateFilterInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateFilterInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateOrganizationConfiguration struct {
}

func (*validateOpUpdateOrganizationConfiguration) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateOrganizationConfiguration) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateOrganizationConfigurationInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateOrganizationConfigurationInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateOrgEc2DeepInspectionConfiguration struct {
}

func (*validateOpUpdateOrgEc2DeepInspectionConfiguration) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateOrgEc2DeepInspectionConfiguration) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateOrgEc2DeepInspectionConfigurationInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateOrgEc2DeepInspectionConfigurationInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

func addOpAssociateMemberValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpAssociateMember{}, middleware.After)
}

func addOpBatchGetCodeSnippetValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpBatchGetCodeSnippet{}, middleware.After)
}

func addOpBatchGetFindingDetailsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpBatchGetFindingDetails{}, middleware.After)
}

func addOpBatchGetFreeTrialInfoValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpBatchGetFreeTrialInfo{}, middleware.After)
}

func addOpBatchUpdateMemberEc2DeepInspectionStatusValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpBatchUpdateMemberEc2DeepInspectionStatus{}, middleware.After)
}

func addOpCancelFindingsReportValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCancelFindingsReport{}, middleware.After)
}

func addOpCancelSbomExportValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCancelSbomExport{}, middleware.After)
}

func addOpCreateCisScanConfigurationValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateCisScanConfiguration{}, middleware.After)
}

func addOpCreateFilterValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateFilter{}, middleware.After)
}

func addOpCreateFindingsReportValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateFindingsReport{}, middleware.After)
}

func addOpCreateSbomExportValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateSbomExport{}, middleware.After)
}

func addOpDeleteCisScanConfigurationValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteCisScanConfiguration{}, middleware.After)
}

func addOpDeleteFilterValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteFilter{}, middleware.After)
}

func addOpDisableDelegatedAdminAccountValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDisableDelegatedAdminAccount{}, middleware.After)
}

func addOpDisassociateMemberValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDisassociateMember{}, middleware.After)
}

func addOpEnableDelegatedAdminAccountValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpEnableDelegatedAdminAccount{}, middleware.After)
}

func addOpEnableValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpEnable{}, middleware.After)
}

func addOpGetCisScanReportValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetCisScanReport{}, middleware.After)
}

func addOpGetCisScanResultDetailsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetCisScanResultDetails{}, middleware.After)
}

func addOpGetClustersForImageValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetClustersForImage{}, middleware.After)
}

func addOpGetEncryptionKeyValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetEncryptionKey{}, middleware.After)
}

func addOpGetMemberValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetMember{}, middleware.After)
}

func addOpGetSbomExportValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetSbomExport{}, middleware.After)
}

func addOpListCisScanConfigurationsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListCisScanConfigurations{}, middleware.After)
}

func addOpListCisScanResultsAggregatedByChecksValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListCisScanResultsAggregatedByChecks{}, middleware.After)
}

func addOpListCisScanResultsAggregatedByTargetResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListCisScanResultsAggregatedByTargetResource{}, middleware.After)
}

func addOpListCisScansValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListCisScans{}, middleware.After)
}

func addOpListCoverageValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListCoverage{}, middleware.After)
}

func addOpListCoverageStatisticsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListCoverageStatistics{}, middleware.After)
}

func addOpListFindingAggregationsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListFindingAggregations{}, middleware.After)
}

func addOpListFindingsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListFindings{}, middleware.After)
}

func addOpListTagsForResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListTagsForResource{}, middleware.After)
}

func addOpResetEncryptionKeyValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpResetEncryptionKey{}, middleware.After)
}

func addOpSearchVulnerabilitiesValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpSearchVulnerabilities{}, middleware.After)
}

func addOpSendCisSessionHealthValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpSendCisSessionHealth{}, middleware.After)
}

func addOpSendCisSessionTelemetryValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpSendCisSessionTelemetry{}, middleware.After)
}

func addOpStartCisSessionValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpStartCisSession{}, middleware.After)
}

func addOpStopCisSessionValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpStopCisSession{}, middleware.After)
}

func addOpTagResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpTagResource{}, middleware.After)
}

func addOpUntagResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUntagResource{}, middleware.After)
}

func addOpUpdateCisScanConfigurationValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateCisScanConfiguration{}, middleware.After)
}

func addOpUpdateConfigurationValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateConfiguration{}, middleware.After)
}

func addOpUpdateEncryptionKeyValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateEncryptionKey{}, middleware.After)
}

func addOpUpdateFilterValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateFilter{}, middleware.After)
}

func addOpUpdateOrganizationConfigurationValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateOrganizationConfiguration{}, middleware.After)
}

func addOpUpdateOrgEc2DeepInspectionConfigurationValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateOrgEc2DeepInspectionConfiguration{}, middleware.After)
}

func validateAccountIdFilterList(v []types.CisStringFilter) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AccountIdFilterList"}
	for i := range v {
		if err := validateCisStringFilter(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateAggregationRequest(v types.AggregationRequest) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AggregationRequest"}
	switch uv := v.(type) {
	case *types.AggregationRequestMemberAmiAggregation:
		if err := validateAmiAggregation(&uv.Value); err != nil {
			invalidParams.AddNested("[amiAggregation]", err.(smithy.InvalidParamsError))
		}

	case *types.AggregationRequestMemberAwsEcrContainerAggregation:
		if err := validateAwsEcrContainerAggregation(&uv.Value); err != nil {
			invalidParams.AddNested("[awsEcrContainerAggregation]", err.(smithy.InvalidParamsError))
		}

	case *types.AggregationRequestMemberEc2InstanceAggregation:
		if err := validateEc2InstanceAggregation(&uv.Value); err != nil {
			invalidParams.AddNested("[ec2InstanceAggregation]", err.(smithy.InvalidParamsError))
		}

	case *types.AggregationRequestMemberImageLayerAggregation:
		if err := validateImageLayerAggregation(&uv.Value); err != nil {
			invalidParams.AddNested("[imageLayerAggregation]", err.(smithy.InvalidParamsError))
		}

	case *types.AggregationRequestMemberLambdaFunctionAggregation:
		if err := validateLambdaFunctionAggregation(&uv.Value); err != nil {
			invalidParams.AddNested("[lambdaFunctionAggregation]", err.(smithy.InvalidParamsError))
		}

	case *types.AggregationRequestMemberLambdaLayerAggregation:
		if err := validateLambdaLayerAggregation(&uv.Value); err != nil {
			invalidParams.AddNested("[lambdaLayerAggregation]", err.(smithy.InvalidParamsError))
		}

	case *types.AggregationRequestMemberPackageAggregation:
		if err := validatePackageAggregation(&uv.Value); err != nil {
			invalidParams.AddNested("[packageAggregation]", err.(smithy.InvalidParamsError))
		}

	case *types.AggregationRequestMemberRepositoryAggregation:
		if err := validateRepositoryAggregation(&uv.Value); err != nil {
			invalidParams.AddNested("[repositoryAggregation]", err.(smithy.InvalidParamsError))
		}

	case *types.AggregationRequestMemberTitleAggregation:
		if err := validateTitleAggregation(&uv.Value); err != nil {
			invalidParams.AddNested("[titleAggregation]", err.(smithy.InvalidParamsError))
		}

	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateAmiAggregation(v *types.AmiAggregation) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AmiAggregation"}
	if v.Amis != nil {
		if err := validateStringFilterList(v.Amis); err != nil {
			invalidParams.AddNested("Amis", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateAutoEnable(v *types.AutoEnable) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AutoEnable"}
	if v.Ec2 == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Ec2"))
	}
	if v.Ecr == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Ecr"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateAwsEcrContainerAggregation(v *types.AwsEcrContainerAggregation) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AwsEcrContainerAggregation"}
	if v.ResourceIds != nil {
		if err := validateStringFilterList(v.ResourceIds); err != nil {
			invalidParams.AddNested("ResourceIds", err.(smithy.InvalidParamsError))
		}
	}
	if v.ImageShas != nil {
		if err := validateStringFilterList(v.ImageShas); err != nil {
			invalidParams.AddNested("ImageShas", err.(smithy.InvalidParamsError))
		}
	}
	if v.Repositories != nil {
		if err := validateStringFilterList(v.Repositories); err != nil {
			invalidParams.AddNested("Repositories", err.(smithy.InvalidParamsError))
		}
	}
	if v.Architectures != nil {
		if err := validateStringFilterList(v.Architectures); err != nil {
			invalidParams.AddNested("Architectures", err.(smithy.InvalidParamsError))
		}
	}
	if v.ImageTags != nil {
		if err := validateStringFilterList(v.ImageTags); err != nil {
			invalidParams.AddNested("ImageTags", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateCheckIdFilterList(v []types.CisStringFilter) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CheckIdFilterList"}
	for i := range v {
		if err := validateCisStringFilter(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateCisFindingArnFilterList(v []types.CisStringFilter) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CisFindingArnFilterList"}
	for i := range v {
		if err := validateCisStringFilter(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateCisFindingStatusFilter(v *types.CisFindingStatusFilter) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CisFindingStatusFilter"}
	if len(v.Comparison) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Comparison"))
	}
	if len(v.Value) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Value"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateCisFindingStatusFilterList(v []types.CisFindingStatusFilter) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CisFindingStatusFilterList"}
	for i := range v {
		if err := validateCisFindingStatusFilter(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateCisResultStatusFilter(v *types.CisResultStatusFilter) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CisResultStatusFilter"}
	if len(v.Comparison) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Comparison"))
	}
	if len(v.Value) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Value"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateCisResultStatusFilterList(v []types.CisResultStatusFilter) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CisResultStatusFilterList"}
	for i := range v {
		if err := validateCisResultStatusFilter(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateCisScanArnFilterList(v []types.CisStringFilter) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CisScanArnFilterList"}
	for i := range v {
		if err := validateCisStringFilter(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateCisScanConfigurationArnFilterList(v []types.CisStringFilter) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CisScanConfigurationArnFilterList"}
	for i := range v {
		if err := validateCisStringFilter(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateCisScanNameFilterList(v []types.CisStringFilter) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CisScanNameFilterList"}
	for i := range v {
		if err := validateCisStringFilter(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateCisScanResultDetailsFilterCriteria(v *types.CisScanResultDetailsFilterCriteria) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CisScanResultDetailsFilterCriteria"}
	if v.FindingStatusFilters != nil {
		if err := validateCisFindingStatusFilterList(v.FindingStatusFilters); err != nil {
			invalidParams.AddNested("FindingStatusFilters", err.(smithy.InvalidParamsError))
		}
	}
	if v.CheckIdFilters != nil {
		if err := validateCheckIdFilterList(v.CheckIdFilters); err != nil {
			invalidParams.AddNested("CheckIdFilters", err.(smithy.InvalidParamsError))
		}
	}
	if v.TitleFilters != nil {
		if err := validateTitleFilterList(v.TitleFilters); err != nil {
			invalidParams.AddNested("TitleFilters", err.(smithy.InvalidParamsError))
		}
	}
	if v.SecurityLevelFilters != nil {
		if err := validateCisSecurityLevelFilterList(v.SecurityLevelFilters); err != nil {
			invalidParams.AddNested("SecurityLevelFilters", err.(smithy.InvalidParamsError))
		}
	}
	if v.FindingArnFilters != nil {
		if err := validateCisFindingArnFilterList(v.FindingArnFilters); err != nil {
			invalidParams.AddNested("FindingArnFilters", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateCisScanResultsAggregatedByChecksFilterCriteria(v *types.CisScanResultsAggregatedByChecksFilterCriteria) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CisScanResultsAggregatedByChecksFilterCriteria"}
	if v.AccountIdFilters != nil {
		if err := validateOneAccountIdFilterList(v.AccountIdFilters); err != nil {
			invalidParams.AddNested("AccountIdFilters", err.(smithy.InvalidParamsError))
		}
	}
	if v.CheckIdFilters != nil {
		if err := validateCheckIdFilterList(v.CheckIdFilters); err != nil {
			invalidParams.AddNested("CheckIdFilters", err.(smithy.InvalidParamsError))
		}
	}
	if v.TitleFilters != nil {
		if err := validateTitleFilterList(v.TitleFilters); err != nil {
			invalidParams.AddNested("TitleFilters", err.(smithy.InvalidParamsError))
		}
	}
	if v.PlatformFilters != nil {
		if err := validatePlatformFilterList(v.PlatformFilters); err != nil {
			invalidParams.AddNested("PlatformFilters", err.(smithy.InvalidParamsError))
		}
	}
	if v.SecurityLevelFilters != nil {
		if err := validateCisSecurityLevelFilterList(v.SecurityLevelFilters); err != nil {
			invalidParams.AddNested("SecurityLevelFilters", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateCisScanResultsAggregatedByTargetResourceFilterCriteria(v *types.CisScanResultsAggregatedByTargetResourceFilterCriteria) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CisScanResultsAggregatedByTargetResourceFilterCriteria"}
	if v.AccountIdFilters != nil {
		if err := validateAccountIdFilterList(v.AccountIdFilters); err != nil {
			invalidParams.AddNested("AccountIdFilters", err.(smithy.InvalidParamsError))
		}
	}
	if v.StatusFilters != nil {
		if err := validateCisResultStatusFilterList(v.StatusFilters); err != nil {
			invalidParams.AddNested("StatusFilters", err.(smithy.InvalidParamsError))
		}
	}
	if v.CheckIdFilters != nil {
		if err := validateCheckIdFilterList(v.CheckIdFilters); err != nil {
			invalidParams.AddNested("CheckIdFilters", err.(smithy.InvalidParamsError))
		}
	}
	if v.TargetResourceIdFilters != nil {
		if err := validateResourceIdFilterList(v.TargetResourceIdFilters); err != nil {
			invalidParams.AddNested("TargetResourceIdFilters", err.(smithy.InvalidParamsError))
		}
	}
	if v.TargetResourceTagFilters != nil {
		if err := validateResourceTagFilterList(v.TargetResourceTagFilters); err != nil {
			invalidParams.AddNested("TargetResourceTagFilters", err.(smithy.InvalidParamsError))
		}
	}
	if v.PlatformFilters != nil {
		if err := validatePlatformFilterList(v.PlatformFilters); err != nil {
			invalidParams.AddNested("PlatformFilters", err.(smithy.InvalidParamsError))
		}
	}
	if v.TargetStatusFilters != nil {
		if err := validateTargetStatusFilterList(v.TargetStatusFilters); err != nil {
			invalidParams.AddNested("TargetStatusFilters", err.(smithy.InvalidParamsError))
		}
	}
	if v.TargetStatusReasonFilters != nil {
		if err := validateTargetStatusReasonFilterList(v.TargetStatusReasonFilters); err != nil {
			invalidParams.AddNested("TargetStatusReasonFilters", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateCisScanStatusFilter(v *types.CisScanStatusFilter) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CisScanStatusFilter"}
	if len(v.Comparison) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Comparison"))
	}
	if len(v.Value) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Value"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateCisScanStatusFilterList(v []types.CisScanStatusFilter) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CisScanStatusFilterList"}
	for i := range v {
		if err := validateCisScanStatusFilter(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateCisScheduledByFilterList(v []types.CisStringFilter) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CisScheduledByFilterList"}
	for i := range v {
		if err := validateCisStringFilter(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateCisSecurityLevelFilter(v *types.CisSecurityLevelFilter) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CisSecurityLevelFilter"}
	if len(v.Comparison) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Comparison"))
	}
	if len(v.Value) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Value"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateCisSecurityLevelFilterList(v []types.CisSecurityLevelFilter) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CisSecurityLevelFilterList"}
	for i := range v {
		if err := validateCisSecurityLevelFilter(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateCisSessionMessage(v *types.CisSessionMessage) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CisSessionMessage"}
	if v.RuleId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RuleId"))
	}
	if len(v.Status) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Status"))
	}
	if v.CisRuleDetails == nil {
		invalidParams.Add(smithy.NewErrParamRequired("CisRuleDetails"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateCisSessionMessages(v []types.CisSessionMessage) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CisSessionMessages"}
	for i := range v {
		if err := validateCisSessionMessage(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateCisStringFilter(v *types.CisStringFilter) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CisStringFilter"}
	if len(v.Comparison) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Comparison"))
	}
	if v.Value == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Value"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateCisTargetStatusFilter(v *types.CisTargetStatusFilter) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CisTargetStatusFilter"}
	if len(v.Comparison) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Comparison"))
	}
	if len(v.Value) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Value"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateCisTargetStatusReasonFilter(v *types.CisTargetStatusReasonFilter) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CisTargetStatusReasonFilter"}
	if len(v.Comparison) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Comparison"))
	}
	if len(v.Value) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Value"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateClusterForImageFilterCriteria(v *types.ClusterForImageFilterCriteria) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ClusterForImageFilterCriteria"}
	if v.ResourceId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateCoverageFilterCriteria(v *types.CoverageFilterCriteria) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CoverageFilterCriteria"}
	if v.ScanStatusCode != nil {
		if err := validateCoverageStringFilterList(v.ScanStatusCode); err != nil {
			invalidParams.AddNested("ScanStatusCode", err.(smithy.InvalidParamsError))
		}
	}
	if v.ScanStatusReason != nil {
		if err := validateCoverageStringFilterList(v.ScanStatusReason); err != nil {
			invalidParams.AddNested("ScanStatusReason", err.(smithy.InvalidParamsError))
		}
	}
	if v.AccountId != nil {
		if err := validateCoverageStringFilterList(v.AccountId); err != nil {
			invalidParams.AddNested("AccountId", err.(smithy.InvalidParamsError))
		}
	}
	if v.ResourceId != nil {
		if err := validateCoverageStringFilterList(v.ResourceId); err != nil {
			invalidParams.AddNested("ResourceId", err.(smithy.InvalidParamsError))
		}
	}
	if v.ResourceType != nil {
		if err := validateCoverageStringFilterList(v.ResourceType); err != nil {
			invalidParams.AddNested("ResourceType", err.(smithy.InvalidParamsError))
		}
	}
	if v.ScanType != nil {
		if err := validateCoverageStringFilterList(v.ScanType); err != nil {
			invalidParams.AddNested("ScanType", err.(smithy.InvalidParamsError))
		}
	}
	if v.EcrRepositoryName != nil {
		if err := validateCoverageStringFilterList(v.EcrRepositoryName); err != nil {
			invalidParams.AddNested("EcrRepositoryName", err.(smithy.InvalidParamsError))
		}
	}
	if v.EcrImageTags != nil {
		if err := validateCoverageStringFilterList(v.EcrImageTags); err != nil {
			invalidParams.AddNested("EcrImageTags", err.(smithy.InvalidParamsError))
		}
	}
	if v.Ec2InstanceTags != nil {
		if err := validateCoverageMapFilterList(v.Ec2InstanceTags); err != nil {
			invalidParams.AddNested("Ec2InstanceTags", err.(smithy.InvalidParamsError))
		}
	}
	if v.LambdaFunctionName != nil {
		if err := validateCoverageStringFilterList(v.LambdaFunctionName); err != nil {
			invalidParams.AddNested("LambdaFunctionName", err.(smithy.InvalidParamsError))
		}
	}
	if v.LambdaFunctionTags != nil {
		if err := validateCoverageMapFilterList(v.LambdaFunctionTags); err != nil {
			invalidParams.AddNested("LambdaFunctionTags", err.(smithy.InvalidParamsError))
		}
	}
	if v.LambdaFunctionRuntime != nil {
		if err := validateCoverageStringFilterList(v.LambdaFunctionRuntime); err != nil {
			invalidParams.AddNested("LambdaFunctionRuntime", err.(smithy.InvalidParamsError))
		}
	}
	if v.ScanMode != nil {
		if err := validateCoverageStringFilterList(v.ScanMode); err != nil {
			invalidParams.AddNested("ScanMode", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateCoverageMapFilter(v *types.CoverageMapFilter) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CoverageMapFilter"}
	if len(v.Comparison) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Comparison"))
	}
	if v.Key == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Key"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateCoverageMapFilterList(v []types.CoverageMapFilter) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CoverageMapFilterList"}
	for i := range v {
		if err := validateCoverageMapFilter(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateCoverageStringFilter(v *types.CoverageStringFilter) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CoverageStringFilter"}
	if len(v.Comparison) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Comparison"))
	}
	if v.Value == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Value"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateCoverageStringFilterList(v []types.CoverageStringFilter) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CoverageStringFilterList"}
	for i := range v {
		if err := validateCoverageStringFilter(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateCreateCisTargets(v *types.CreateCisTargets) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateCisTargets"}
	if v.AccountIds == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AccountIds"))
	}
	if v.TargetResourceTags == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TargetResourceTags"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateDailySchedule(v *types.DailySchedule) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DailySchedule"}
	if v.StartTime == nil {
		invalidParams.Add(smithy.NewErrParamRequired("StartTime"))
	} else if v.StartTime != nil {
		if err := validateTime(v.StartTime); err != nil {
			invalidParams.AddNested("StartTime", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateDestination(v *types.Destination) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Destination"}
	if v.BucketName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("BucketName"))
	}
	if v.KmsKeyArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("KmsKeyArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateEc2Configuration(v *types.Ec2Configuration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Ec2Configuration"}
	if len(v.ScanMode) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("ScanMode"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateEc2InstanceAggregation(v *types.Ec2InstanceAggregation) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Ec2InstanceAggregation"}
	if v.Amis != nil {
		if err := validateStringFilterList(v.Amis); err != nil {
			invalidParams.AddNested("Amis", err.(smithy.InvalidParamsError))
		}
	}
	if v.OperatingSystems != nil {
		if err := validateStringFilterList(v.OperatingSystems); err != nil {
			invalidParams.AddNested("OperatingSystems", err.(smithy.InvalidParamsError))
		}
	}
	if v.InstanceIds != nil {
		if err := validateStringFilterList(v.InstanceIds); err != nil {
			invalidParams.AddNested("InstanceIds", err.(smithy.InvalidParamsError))
		}
	}
	if v.InstanceTags != nil {
		if err := validateMapFilterList(v.InstanceTags); err != nil {
			invalidParams.AddNested("InstanceTags", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateEcrConfiguration(v *types.EcrConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "EcrConfiguration"}
	if len(v.RescanDuration) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("RescanDuration"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateFilterCriteria(v *types.FilterCriteria) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "FilterCriteria"}
	if v.FindingArn != nil {
		if err := validateStringFilterList(v.FindingArn); err != nil {
			invalidParams.AddNested("FindingArn", err.(smithy.InvalidParamsError))
		}
	}
	if v.AwsAccountId != nil {
		if err := validateStringFilterList(v.AwsAccountId); err != nil {
			invalidParams.AddNested("AwsAccountId", err.(smithy.InvalidParamsError))
		}
	}
	if v.FindingType != nil {
		if err := validateStringFilterList(v.FindingType); err != nil {
			invalidParams.AddNested("FindingType", err.(smithy.InvalidParamsError))
		}
	}
	if v.Severity != nil {
		if err := validateStringFilterList(v.Severity); err != nil {
			invalidParams.AddNested("Severity", err.(smithy.InvalidParamsError))
		}
	}
	if v.FindingStatus != nil {
		if err := validateStringFilterList(v.FindingStatus); err != nil {
			invalidParams.AddNested("FindingStatus", err.(smithy.InvalidParamsError))
		}
	}
	if v.Title != nil {
		if err := validateStringFilterList(v.Title); err != nil {
			invalidParams.AddNested("Title", err.(smithy.InvalidParamsError))
		}
	}
	if v.ResourceType != nil {
		if err := validateStringFilterList(v.ResourceType); err != nil {
			invalidParams.AddNested("ResourceType", err.(smithy.InvalidParamsError))
		}
	}
	if v.ResourceId != nil {
		if err := validateStringFilterList(v.ResourceId); err != nil {
			invalidParams.AddNested("ResourceId", err.(smithy.InvalidParamsError))
		}
	}
	if v.ResourceTags != nil {
		if err := validateMapFilterList(v.ResourceTags); err != nil {
			invalidParams.AddNested("ResourceTags", err.(smithy.InvalidParamsError))
		}
	}
	if v.Ec2InstanceImageId != nil {
		if err := validateStringFilterList(v.Ec2InstanceImageId); err != nil {
			invalidParams.AddNested("Ec2InstanceImageId", err.(smithy.InvalidParamsError))
		}
	}
	if v.Ec2InstanceVpcId != nil {
		if err := validateStringFilterList(v.Ec2InstanceVpcId); err != nil {
			invalidParams.AddNested("Ec2InstanceVpcId", err.(smithy.InvalidParamsError))
		}
	}
	if v.Ec2InstanceSubnetId != nil {
		if err := validateStringFilterList(v.Ec2InstanceSubnetId); err != nil {
			invalidParams.AddNested("Ec2InstanceSubnetId", err.(smithy.InvalidParamsError))
		}
	}
	if v.EcrImageArchitecture != nil {
		if err := validateStringFilterList(v.EcrImageArchitecture); err != nil {
			invalidParams.AddNested("EcrImageArchitecture", err.(smithy.InvalidParamsError))
		}
	}
	if v.EcrImageRegistry != nil {
		if err := validateStringFilterList(v.EcrImageRegistry); err != nil {
			invalidParams.AddNested("EcrImageRegistry", err.(smithy.InvalidParamsError))
		}
	}
	if v.EcrImageRepositoryName != nil {
		if err := validateStringFilterList(v.EcrImageRepositoryName); err != nil {
			invalidParams.AddNested("EcrImageRepositoryName", err.(smithy.InvalidParamsError))
		}
	}
	if v.EcrImageTags != nil {
		if err := validateStringFilterList(v.EcrImageTags); err != nil {
			invalidParams.AddNested("EcrImageTags", err.(smithy.InvalidParamsError))
		}
	}
	if v.EcrImageHash != nil {
		if err := validateStringFilterList(v.EcrImageHash); err != nil {
			invalidParams.AddNested("EcrImageHash", err.(smithy.InvalidParamsError))
		}
	}
	if v.NetworkProtocol != nil {
		if err := validateStringFilterList(v.NetworkProtocol); err != nil {
			invalidParams.AddNested("NetworkProtocol", err.(smithy.InvalidParamsError))
		}
	}
	if v.ComponentId != nil {
		if err := validateStringFilterList(v.ComponentId); err != nil {
			invalidParams.AddNested("ComponentId", err.(smithy.InvalidParamsError))
		}
	}
	if v.ComponentType != nil {
		if err := validateStringFilterList(v.ComponentType); err != nil {
			invalidParams.AddNested("ComponentType", err.(smithy.InvalidParamsError))
		}
	}
	if v.VulnerabilityId != nil {
		if err := validateStringFilterList(v.VulnerabilityId); err != nil {
			invalidParams.AddNested("VulnerabilityId", err.(smithy.InvalidParamsError))
		}
	}
	if v.VulnerabilitySource != nil {
		if err := validateStringFilterList(v.VulnerabilitySource); err != nil {
			invalidParams.AddNested("VulnerabilitySource", err.(smithy.InvalidParamsError))
		}
	}
	if v.VendorSeverity != nil {
		if err := validateStringFilterList(v.VendorSeverity); err != nil {
			invalidParams.AddNested("VendorSeverity", err.(smithy.InvalidParamsError))
		}
	}
	if v.VulnerablePackages != nil {
		if err := validatePackageFilterList(v.VulnerablePackages); err != nil {
			invalidParams.AddNested("VulnerablePackages", err.(smithy.InvalidParamsError))
		}
	}
	if v.RelatedVulnerabilities != nil {
		if err := validateStringFilterList(v.RelatedVulnerabilities); err != nil {
			invalidParams.AddNested("RelatedVulnerabilities", err.(smithy.InvalidParamsError))
		}
	}
	if v.FixAvailable != nil {
		if err := validateStringFilterList(v.FixAvailable); err != nil {
			invalidParams.AddNested("FixAvailable", err.(smithy.InvalidParamsError))
		}
	}
	if v.LambdaFunctionName != nil {
		if err := validateStringFilterList(v.LambdaFunctionName); err != nil {
			invalidParams.AddNested("LambdaFunctionName", err.(smithy.InvalidParamsError))
		}
	}
	if v.LambdaFunctionLayers != nil {
		if err := validateStringFilterList(v.LambdaFunctionLayers); err != nil {
			invalidParams.AddNested("LambdaFunctionLayers", err.(smithy.InvalidParamsError))
		}
	}
	if v.LambdaFunctionRuntime != nil {
		if err := validateStringFilterList(v.LambdaFunctionRuntime); err != nil {
			invalidParams.AddNested("LambdaFunctionRuntime", err.(smithy.InvalidParamsError))
		}
	}
	if v.LambdaFunctionExecutionRoleArn != nil {
		if err := validateStringFilterList(v.LambdaFunctionExecutionRoleArn); err != nil {
			invalidParams.AddNested("LambdaFunctionExecutionRoleArn", err.(smithy.InvalidParamsError))
		}
	}
	if v.ExploitAvailable != nil {
		if err := validateStringFilterList(v.ExploitAvailable); err != nil {
			invalidParams.AddNested("ExploitAvailable", err.(smithy.InvalidParamsError))
		}
	}
	if v.CodeVulnerabilityDetectorName != nil {
		if err := validateStringFilterList(v.CodeVulnerabilityDetectorName); err != nil {
			invalidParams.AddNested("CodeVulnerabilityDetectorName", err.(smithy.InvalidParamsError))
		}
	}
	if v.CodeVulnerabilityDetectorTags != nil {
		if err := validateStringFilterList(v.CodeVulnerabilityDetectorTags); err != nil {
			invalidParams.AddNested("CodeVulnerabilityDetectorTags", err.(smithy.InvalidParamsError))
		}
	}
	if v.CodeVulnerabilityFilePath != nil {
		if err := validateStringFilterList(v.CodeVulnerabilityFilePath); err != nil {
			invalidParams.AddNested("CodeVulnerabilityFilePath", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateImageLayerAggregation(v *types.ImageLayerAggregation) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ImageLayerAggregation"}
	if v.Repositories != nil {
		if err := validateStringFilterList(v.Repositories); err != nil {
			invalidParams.AddNested("Repositories", err.(smithy.InvalidParamsError))
		}
	}
	if v.ResourceIds != nil {
		if err := validateStringFilterList(v.ResourceIds); err != nil {
			invalidParams.AddNested("ResourceIds", err.(smithy.InvalidParamsError))
		}
	}
	if v.LayerHashes != nil {
		if err := validateStringFilterList(v.LayerHashes); err != nil {
			invalidParams.AddNested("LayerHashes", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateLambdaFunctionAggregation(v *types.LambdaFunctionAggregation) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "LambdaFunctionAggregation"}
	if v.ResourceIds != nil {
		if err := validateStringFilterList(v.ResourceIds); err != nil {
			invalidParams.AddNested("ResourceIds", err.(smithy.InvalidParamsError))
		}
	}
	if v.FunctionNames != nil {
		if err := validateStringFilterList(v.FunctionNames); err != nil {
			invalidParams.AddNested("FunctionNames", err.(smithy.InvalidParamsError))
		}
	}
	if v.Runtimes != nil {
		if err := validateStringFilterList(v.Runtimes); err != nil {
			invalidParams.AddNested("Runtimes", err.(smithy.InvalidParamsError))
		}
	}
	if v.FunctionTags != nil {
		if err := validateMapFilterList(v.FunctionTags); err != nil {
			invalidParams.AddNested("FunctionTags", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateLambdaLayerAggregation(v *types.LambdaLayerAggregation) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "LambdaLayerAggregation"}
	if v.FunctionNames != nil {
		if err := validateStringFilterList(v.FunctionNames); err != nil {
			invalidParams.AddNested("FunctionNames", err.(smithy.InvalidParamsError))
		}
	}
	if v.ResourceIds != nil {
		if err := validateStringFilterList(v.ResourceIds); err != nil {
			invalidParams.AddNested("ResourceIds", err.(smithy.InvalidParamsError))
		}
	}
	if v.LayerArns != nil {
		if err := validateStringFilterList(v.LayerArns); err != nil {
			invalidParams.AddNested("LayerArns", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateListCisScanConfigurationsFilterCriteria(v *types.ListCisScanConfigurationsFilterCriteria) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListCisScanConfigurationsFilterCriteria"}
	if v.ScanNameFilters != nil {
		if err := validateCisScanNameFilterList(v.ScanNameFilters); err != nil {
			invalidParams.AddNested("ScanNameFilters", err.(smithy.InvalidParamsError))
		}
	}
	if v.TargetResourceTagFilters != nil {
		if err := validateResourceTagFilterList(v.TargetResourceTagFilters); err != nil {
			invalidParams.AddNested("TargetResourceTagFilters", err.(smithy.InvalidParamsError))
		}
	}
	if v.ScanConfigurationArnFilters != nil {
		if err := validateCisScanConfigurationArnFilterList(v.ScanConfigurationArnFilters); err != nil {
			invalidParams.AddNested("ScanConfigurationArnFilters", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateListCisScansFilterCriteria(v *types.ListCisScansFilterCriteria) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListCisScansFilterCriteria"}
	if v.ScanNameFilters != nil {
		if err := validateCisScanNameFilterList(v.ScanNameFilters); err != nil {
			invalidParams.AddNested("ScanNameFilters", err.(smithy.InvalidParamsError))
		}
	}
	if v.TargetResourceTagFilters != nil {
		if err := validateResourceTagFilterList(v.TargetResourceTagFilters); err != nil {
			invalidParams.AddNested("TargetResourceTagFilters", err.(smithy.InvalidParamsError))
		}
	}
	if v.TargetResourceIdFilters != nil {
		if err := validateResourceIdFilterList(v.TargetResourceIdFilters); err != nil {
			invalidParams.AddNested("TargetResourceIdFilters", err.(smithy.InvalidParamsError))
		}
	}
	if v.ScanStatusFilters != nil {
		if err := validateCisScanStatusFilterList(v.ScanStatusFilters); err != nil {
			invalidParams.AddNested("ScanStatusFilters", err.(smithy.InvalidParamsError))
		}
	}
	if v.ScanConfigurationArnFilters != nil {
		if err := validateCisScanConfigurationArnFilterList(v.ScanConfigurationArnFilters); err != nil {
			invalidParams.AddNested("ScanConfigurationArnFilters", err.(smithy.InvalidParamsError))
		}
	}
	if v.ScanArnFilters != nil {
		if err := validateCisScanArnFilterList(v.ScanArnFilters); err != nil {
			invalidParams.AddNested("ScanArnFilters", err.(smithy.InvalidParamsError))
		}
	}
	if v.ScheduledByFilters != nil {
		if err := validateCisScheduledByFilterList(v.ScheduledByFilters); err != nil {
			invalidParams.AddNested("ScheduledByFilters", err.(smithy.InvalidParamsError))
		}
	}
	if v.TargetAccountIdFilters != nil {
		if err := validateAccountIdFilterList(v.TargetAccountIdFilters); err != nil {
			invalidParams.AddNested("TargetAccountIdFilters", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateMapFilter(v *types.MapFilter) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "MapFilter"}
	if len(v.Comparison) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Comparison"))
	}
	if v.Key == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Key"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateMapFilterList(v []types.MapFilter) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "MapFilterList"}
	for i := range v {
		if err := validateMapFilter(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateMemberAccountEc2DeepInspectionStatus(v *types.MemberAccountEc2DeepInspectionStatus) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "MemberAccountEc2DeepInspectionStatus"}
	if v.AccountId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AccountId"))
	}
	if v.ActivateDeepInspection == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ActivateDeepInspection"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateMemberAccountEc2DeepInspectionStatusList(v []types.MemberAccountEc2DeepInspectionStatus) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "MemberAccountEc2DeepInspectionStatusList"}
	for i := range v {
		if err := validateMemberAccountEc2DeepInspectionStatus(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateMonthlySchedule(v *types.MonthlySchedule) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "MonthlySchedule"}
	if v.StartTime == nil {
		invalidParams.Add(smithy.NewErrParamRequired("StartTime"))
	} else if v.StartTime != nil {
		if err := validateTime(v.StartTime); err != nil {
			invalidParams.AddNested("StartTime", err.(smithy.InvalidParamsError))
		}
	}
	if len(v.Day) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Day"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOneAccountIdFilterList(v []types.CisStringFilter) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "OneAccountIdFilterList"}
	for i := range v {
		if err := validateCisStringFilter(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validatePackageAggregation(v *types.PackageAggregation) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PackageAggregation"}
	if v.PackageNames != nil {
		if err := validateStringFilterList(v.PackageNames); err != nil {
			invalidParams.AddNested("PackageNames", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validatePackageFilter(v *types.PackageFilter) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PackageFilter"}
	if v.Name != nil {
		if err := validateStringFilter(v.Name); err != nil {
			invalidParams.AddNested("Name", err.(smithy.InvalidParamsError))
		}
	}
	if v.Version != nil {
		if err := validateStringFilter(v.Version); err != nil {
			invalidParams.AddNested("Version", err.(smithy.InvalidParamsError))
		}
	}
	if v.Release != nil {
		if err := validateStringFilter(v.Release); err != nil {
			invalidParams.AddNested("Release", err.(smithy.InvalidParamsError))
		}
	}
	if v.Architecture != nil {
		if err := validateStringFilter(v.Architecture); err != nil {
			invalidParams.AddNested("Architecture", err.(smithy.InvalidParamsError))
		}
	}
	if v.SourceLayerHash != nil {
		if err := validateStringFilter(v.SourceLayerHash); err != nil {
			invalidParams.AddNested("SourceLayerHash", err.(smithy.InvalidParamsError))
		}
	}
	if v.SourceLambdaLayerArn != nil {
		if err := validateStringFilter(v.SourceLambdaLayerArn); err != nil {
			invalidParams.AddNested("SourceLambdaLayerArn", err.(smithy.InvalidParamsError))
		}
	}
	if v.FilePath != nil {
		if err := validateStringFilter(v.FilePath); err != nil {
			invalidParams.AddNested("FilePath", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validatePackageFilterList(v []types.PackageFilter) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PackageFilterList"}
	for i := range v {
		if err := validatePackageFilter(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validatePlatformFilterList(v []types.CisStringFilter) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PlatformFilterList"}
	for i := range v {
		if err := validateCisStringFilter(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateRepositoryAggregation(v *types.RepositoryAggregation) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RepositoryAggregation"}
	if v.Repositories != nil {
		if err := validateStringFilterList(v.Repositories); err != nil {
			invalidParams.AddNested("Repositories", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateResourceFilterCriteria(v *types.ResourceFilterCriteria) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ResourceFilterCriteria"}
	if v.AccountId != nil {
		if err := validateResourceStringFilterList(v.AccountId); err != nil {
			invalidParams.AddNested("AccountId", err.(smithy.InvalidParamsError))
		}
	}
	if v.ResourceId != nil {
		if err := validateResourceStringFilterList(v.ResourceId); err != nil {
			invalidParams.AddNested("ResourceId", err.(smithy.InvalidParamsError))
		}
	}
	if v.ResourceType != nil {
		if err := validateResourceStringFilterList(v.ResourceType); err != nil {
			invalidParams.AddNested("ResourceType", err.(smithy.InvalidParamsError))
		}
	}
	if v.EcrRepositoryName != nil {
		if err := validateResourceStringFilterList(v.EcrRepositoryName); err != nil {
			invalidParams.AddNested("EcrRepositoryName", err.(smithy.InvalidParamsError))
		}
	}
	if v.LambdaFunctionName != nil {
		if err := validateResourceStringFilterList(v.LambdaFunctionName); err != nil {
			invalidParams.AddNested("LambdaFunctionName", err.(smithy.InvalidParamsError))
		}
	}
	if v.EcrImageTags != nil {
		if err := validateResourceStringFilterList(v.EcrImageTags); err != nil {
			invalidParams.AddNested("EcrImageTags", err.(smithy.InvalidParamsError))
		}
	}
	if v.Ec2InstanceTags != nil {
		if err := validateResourceMapFilterList(v.Ec2InstanceTags); err != nil {
			invalidParams.AddNested("Ec2InstanceTags", err.(smithy.InvalidParamsError))
		}
	}
	if v.LambdaFunctionTags != nil {
		if err := validateResourceMapFilterList(v.LambdaFunctionTags); err != nil {
			invalidParams.AddNested("LambdaFunctionTags", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateResourceIdFilterList(v []types.CisStringFilter) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ResourceIdFilterList"}
	for i := range v {
		if err := validateCisStringFilter(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateResourceMapFilter(v *types.ResourceMapFilter) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ResourceMapFilter"}
	if len(v.Comparison) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Comparison"))
	}
	if v.Key == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Key"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateResourceMapFilterList(v []types.ResourceMapFilter) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ResourceMapFilterList"}
	for i := range v {
		if err := validateResourceMapFilter(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateResourceStringFilter(v *types.ResourceStringFilter) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ResourceStringFilter"}
	if len(v.Comparison) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Comparison"))
	}
	if v.Value == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Value"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateResourceStringFilterList(v []types.ResourceStringFilter) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ResourceStringFilterList"}
	for i := range v {
		if err := validateResourceStringFilter(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateResourceTagFilterList(v []types.TagFilter) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ResourceTagFilterList"}
	for i := range v {
		if err := validateTagFilter(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateSchedule(v types.Schedule) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Schedule"}
	switch uv := v.(type) {
	case *types.ScheduleMemberDaily:
		if err := validateDailySchedule(&uv.Value); err != nil {
			invalidParams.AddNested("[daily]", err.(smithy.InvalidParamsError))
		}

	case *types.ScheduleMemberMonthly:
		if err := validateMonthlySchedule(&uv.Value); err != nil {
			invalidParams.AddNested("[monthly]", err.(smithy.InvalidParamsError))
		}

	case *types.ScheduleMemberWeekly:
		if err := validateWeeklySchedule(&uv.Value); err != nil {
			invalidParams.AddNested("[weekly]", err.(smithy.InvalidParamsError))
		}

	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateSearchVulnerabilitiesFilterCriteria(v *types.SearchVulnerabilitiesFilterCriteria) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "SearchVulnerabilitiesFilterCriteria"}
	if v.VulnerabilityIds == nil {
		invalidParams.Add(smithy.NewErrParamRequired("VulnerabilityIds"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateSortCriteria(v *types.SortCriteria) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "SortCriteria"}
	if len(v.Field) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Field"))
	}
	if len(v.SortOrder) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("SortOrder"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateStartCisSessionMessage(v *types.StartCisSessionMessage) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "StartCisSessionMessage"}
	if v.SessionToken == nil {
		invalidParams.Add(smithy.NewErrParamRequired("SessionToken"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateStopCisSessionMessage(v *types.StopCisSessionMessage) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "StopCisSessionMessage"}
	if len(v.Status) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Status"))
	}
	if v.Progress == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Progress"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateStringFilter(v *types.StringFilter) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "StringFilter"}
	if len(v.Comparison) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Comparison"))
	}
	if v.Value == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Value"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateStringFilterList(v []types.StringFilter) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "StringFilterList"}
	for i := range v {
		if err := validateStringFilter(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateTagFilter(v *types.TagFilter) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TagFilter"}
	if len(v.Comparison) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Comparison"))
	}
	if v.Key == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Key"))
	}
	if v.Value == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Value"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateTargetStatusFilterList(v []types.CisTargetStatusFilter) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TargetStatusFilterList"}
	for i := range v {
		if err := validateCisTargetStatusFilter(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateTargetStatusReasonFilterList(v []types.CisTargetStatusReasonFilter) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TargetStatusReasonFilterList"}
	for i := range v {
		if err := validateCisTargetStatusReasonFilter(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateTime(v *types.Time) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Time"}
	if v.TimeOfDay == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TimeOfDay"))
	}
	if v.Timezone == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Timezone"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateTitleAggregation(v *types.TitleAggregation) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TitleAggregation"}
	if v.Titles != nil {
		if err := validateStringFilterList(v.Titles); err != nil {
			invalidParams.AddNested("Titles", err.(smithy.InvalidParamsError))
		}
	}
	if v.VulnerabilityIds != nil {
		if err := validateStringFilterList(v.VulnerabilityIds); err != nil {
			invalidParams.AddNested("VulnerabilityIds", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateTitleFilterList(v []types.CisStringFilter) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TitleFilterList"}
	for i := range v {
		if err := validateCisStringFilter(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateWeeklySchedule(v *types.WeeklySchedule) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "WeeklySchedule"}
	if v.StartTime == nil {
		invalidParams.Add(smithy.NewErrParamRequired("StartTime"))
	} else if v.StartTime != nil {
		if err := validateTime(v.StartTime); err != nil {
			invalidParams.AddNested("StartTime", err.(smithy.InvalidParamsError))
		}
	}
	if v.Days == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Days"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpAssociateMemberInput(v *AssociateMemberInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AssociateMemberInput"}
	if v.AccountId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AccountId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpBatchGetCodeSnippetInput(v *BatchGetCodeSnippetInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "BatchGetCodeSnippetInput"}
	if v.FindingArns == nil {
		invalidParams.Add(smithy.NewErrParamRequired("FindingArns"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpBatchGetFindingDetailsInput(v *BatchGetFindingDetailsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "BatchGetFindingDetailsInput"}
	if v.FindingArns == nil {
		invalidParams.Add(smithy.NewErrParamRequired("FindingArns"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpBatchGetFreeTrialInfoInput(v *BatchGetFreeTrialInfoInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "BatchGetFreeTrialInfoInput"}
	if v.AccountIds == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AccountIds"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpBatchUpdateMemberEc2DeepInspectionStatusInput(v *BatchUpdateMemberEc2DeepInspectionStatusInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "BatchUpdateMemberEc2DeepInspectionStatusInput"}
	if v.AccountIds == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AccountIds"))
	} else if v.AccountIds != nil {
		if err := validateMemberAccountEc2DeepInspectionStatusList(v.AccountIds); err != nil {
			invalidParams.AddNested("AccountIds", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCancelFindingsReportInput(v *CancelFindingsReportInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CancelFindingsReportInput"}
	if v.ReportId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ReportId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCancelSbomExportInput(v *CancelSbomExportInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CancelSbomExportInput"}
	if v.ReportId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ReportId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateCisScanConfigurationInput(v *CreateCisScanConfigurationInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateCisScanConfigurationInput"}
	if v.ScanName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ScanName"))
	}
	if len(v.SecurityLevel) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("SecurityLevel"))
	}
	if v.Schedule == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Schedule"))
	} else if v.Schedule != nil {
		if err := validateSchedule(v.Schedule); err != nil {
			invalidParams.AddNested("Schedule", err.(smithy.InvalidParamsError))
		}
	}
	if v.Targets == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Targets"))
	} else if v.Targets != nil {
		if err := validateCreateCisTargets(v.Targets); err != nil {
			invalidParams.AddNested("Targets", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateFilterInput(v *CreateFilterInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateFilterInput"}
	if len(v.Action) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Action"))
	}
	if v.FilterCriteria == nil {
		invalidParams.Add(smithy.NewErrParamRequired("FilterCriteria"))
	} else if v.FilterCriteria != nil {
		if err := validateFilterCriteria(v.FilterCriteria); err != nil {
			invalidParams.AddNested("FilterCriteria", err.(smithy.InvalidParamsError))
		}
	}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateFindingsReportInput(v *CreateFindingsReportInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateFindingsReportInput"}
	if v.FilterCriteria != nil {
		if err := validateFilterCriteria(v.FilterCriteria); err != nil {
			invalidParams.AddNested("FilterCriteria", err.(smithy.InvalidParamsError))
		}
	}
	if len(v.ReportFormat) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("ReportFormat"))
	}
	if v.S3Destination == nil {
		invalidParams.Add(smithy.NewErrParamRequired("S3Destination"))
	} else if v.S3Destination != nil {
		if err := validateDestination(v.S3Destination); err != nil {
			invalidParams.AddNested("S3Destination", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateSbomExportInput(v *CreateSbomExportInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateSbomExportInput"}
	if v.ResourceFilterCriteria != nil {
		if err := validateResourceFilterCriteria(v.ResourceFilterCriteria); err != nil {
			invalidParams.AddNested("ResourceFilterCriteria", err.(smithy.InvalidParamsError))
		}
	}
	if len(v.ReportFormat) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("ReportFormat"))
	}
	if v.S3Destination == nil {
		invalidParams.Add(smithy.NewErrParamRequired("S3Destination"))
	} else if v.S3Destination != nil {
		if err := validateDestination(v.S3Destination); err != nil {
			invalidParams.AddNested("S3Destination", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteCisScanConfigurationInput(v *DeleteCisScanConfigurationInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteCisScanConfigurationInput"}
	if v.ScanConfigurationArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ScanConfigurationArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteFilterInput(v *DeleteFilterInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteFilterInput"}
	if v.Arn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Arn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDisableDelegatedAdminAccountInput(v *DisableDelegatedAdminAccountInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DisableDelegatedAdminAccountInput"}
	if v.DelegatedAdminAccountId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DelegatedAdminAccountId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDisassociateMemberInput(v *DisassociateMemberInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DisassociateMemberInput"}
	if v.AccountId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AccountId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpEnableDelegatedAdminAccountInput(v *EnableDelegatedAdminAccountInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "EnableDelegatedAdminAccountInput"}
	if v.DelegatedAdminAccountId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DelegatedAdminAccountId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpEnableInput(v *EnableInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "EnableInput"}
	if v.ResourceTypes == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceTypes"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetCisScanReportInput(v *GetCisScanReportInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetCisScanReportInput"}
	if v.ScanArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ScanArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetCisScanResultDetailsInput(v *GetCisScanResultDetailsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetCisScanResultDetailsInput"}
	if v.ScanArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ScanArn"))
	}
	if v.TargetResourceId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TargetResourceId"))
	}
	if v.AccountId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AccountId"))
	}
	if v.FilterCriteria != nil {
		if err := validateCisScanResultDetailsFilterCriteria(v.FilterCriteria); err != nil {
			invalidParams.AddNested("FilterCriteria", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetClustersForImageInput(v *GetClustersForImageInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetClustersForImageInput"}
	if v.Filter == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Filter"))
	} else if v.Filter != nil {
		if err := validateClusterForImageFilterCriteria(v.Filter); err != nil {
			invalidParams.AddNested("Filter", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetEncryptionKeyInput(v *GetEncryptionKeyInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetEncryptionKeyInput"}
	if len(v.ScanType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("ScanType"))
	}
	if len(v.ResourceType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceType"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetMemberInput(v *GetMemberInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetMemberInput"}
	if v.AccountId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AccountId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetSbomExportInput(v *GetSbomExportInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetSbomExportInput"}
	if v.ReportId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ReportId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListCisScanConfigurationsInput(v *ListCisScanConfigurationsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListCisScanConfigurationsInput"}
	if v.FilterCriteria != nil {
		if err := validateListCisScanConfigurationsFilterCriteria(v.FilterCriteria); err != nil {
			invalidParams.AddNested("FilterCriteria", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListCisScanResultsAggregatedByChecksInput(v *ListCisScanResultsAggregatedByChecksInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListCisScanResultsAggregatedByChecksInput"}
	if v.ScanArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ScanArn"))
	}
	if v.FilterCriteria != nil {
		if err := validateCisScanResultsAggregatedByChecksFilterCriteria(v.FilterCriteria); err != nil {
			invalidParams.AddNested("FilterCriteria", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListCisScanResultsAggregatedByTargetResourceInput(v *ListCisScanResultsAggregatedByTargetResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListCisScanResultsAggregatedByTargetResourceInput"}
	if v.ScanArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ScanArn"))
	}
	if v.FilterCriteria != nil {
		if err := validateCisScanResultsAggregatedByTargetResourceFilterCriteria(v.FilterCriteria); err != nil {
			invalidParams.AddNested("FilterCriteria", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListCisScansInput(v *ListCisScansInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListCisScansInput"}
	if v.FilterCriteria != nil {
		if err := validateListCisScansFilterCriteria(v.FilterCriteria); err != nil {
			invalidParams.AddNested("FilterCriteria", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListCoverageInput(v *ListCoverageInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListCoverageInput"}
	if v.FilterCriteria != nil {
		if err := validateCoverageFilterCriteria(v.FilterCriteria); err != nil {
			invalidParams.AddNested("FilterCriteria", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListCoverageStatisticsInput(v *ListCoverageStatisticsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListCoverageStatisticsInput"}
	if v.FilterCriteria != nil {
		if err := validateCoverageFilterCriteria(v.FilterCriteria); err != nil {
			invalidParams.AddNested("FilterCriteria", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListFindingAggregationsInput(v *ListFindingAggregationsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListFindingAggregationsInput"}
	if len(v.AggregationType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("AggregationType"))
	}
	if v.AccountIds != nil {
		if err := validateStringFilterList(v.AccountIds); err != nil {
			invalidParams.AddNested("AccountIds", err.(smithy.InvalidParamsError))
		}
	}
	if v.AggregationRequest != nil {
		if err := validateAggregationRequest(v.AggregationRequest); err != nil {
			invalidParams.AddNested("AggregationRequest", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListFindingsInput(v *ListFindingsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListFindingsInput"}
	if v.FilterCriteria != nil {
		if err := validateFilterCriteria(v.FilterCriteria); err != nil {
			invalidParams.AddNested("FilterCriteria", err.(smithy.InvalidParamsError))
		}
	}
	if v.SortCriteria != nil {
		if err := validateSortCriteria(v.SortCriteria); err != nil {
			invalidParams.AddNested("SortCriteria", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListTagsForResourceInput(v *ListTagsForResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListTagsForResourceInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpResetEncryptionKeyInput(v *ResetEncryptionKeyInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ResetEncryptionKeyInput"}
	if len(v.ScanType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("ScanType"))
	}
	if len(v.ResourceType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceType"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpSearchVulnerabilitiesInput(v *SearchVulnerabilitiesInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "SearchVulnerabilitiesInput"}
	if v.FilterCriteria == nil {
		invalidParams.Add(smithy.NewErrParamRequired("FilterCriteria"))
	} else if v.FilterCriteria != nil {
		if err := validateSearchVulnerabilitiesFilterCriteria(v.FilterCriteria); err != nil {
			invalidParams.AddNested("FilterCriteria", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpSendCisSessionHealthInput(v *SendCisSessionHealthInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "SendCisSessionHealthInput"}
	if v.ScanJobId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ScanJobId"))
	}
	if v.SessionToken == nil {
		invalidParams.Add(smithy.NewErrParamRequired("SessionToken"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpSendCisSessionTelemetryInput(v *SendCisSessionTelemetryInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "SendCisSessionTelemetryInput"}
	if v.ScanJobId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ScanJobId"))
	}
	if v.SessionToken == nil {
		invalidParams.Add(smithy.NewErrParamRequired("SessionToken"))
	}
	if v.Messages == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Messages"))
	} else if v.Messages != nil {
		if err := validateCisSessionMessages(v.Messages); err != nil {
			invalidParams.AddNested("Messages", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpStartCisSessionInput(v *StartCisSessionInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "StartCisSessionInput"}
	if v.ScanJobId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ScanJobId"))
	}
	if v.Message == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Message"))
	} else if v.Message != nil {
		if err := validateStartCisSessionMessage(v.Message); err != nil {
			invalidParams.AddNested("Message", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpStopCisSessionInput(v *StopCisSessionInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "StopCisSessionInput"}
	if v.ScanJobId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ScanJobId"))
	}
	if v.SessionToken == nil {
		invalidParams.Add(smithy.NewErrParamRequired("SessionToken"))
	}
	if v.Message == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Message"))
	} else if v.Message != nil {
		if err := validateStopCisSessionMessage(v.Message); err != nil {
			invalidParams.AddNested("Message", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpTagResourceInput(v *TagResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TagResourceInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if v.Tags == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Tags"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUntagResourceInput(v *UntagResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UntagResourceInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if v.TagKeys == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TagKeys"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateCisScanConfigurationInput(v *UpdateCisScanConfigurationInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateCisScanConfigurationInput"}
	if v.ScanConfigurationArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ScanConfigurationArn"))
	}
	if v.Schedule != nil {
		if err := validateSchedule(v.Schedule); err != nil {
			invalidParams.AddNested("Schedule", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateConfigurationInput(v *UpdateConfigurationInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateConfigurationInput"}
	if v.EcrConfiguration != nil {
		if err := validateEcrConfiguration(v.EcrConfiguration); err != nil {
			invalidParams.AddNested("EcrConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if v.Ec2Configuration != nil {
		if err := validateEc2Configuration(v.Ec2Configuration); err != nil {
			invalidParams.AddNested("Ec2Configuration", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateEncryptionKeyInput(v *UpdateEncryptionKeyInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateEncryptionKeyInput"}
	if v.KmsKeyId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("KmsKeyId"))
	}
	if len(v.ScanType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("ScanType"))
	}
	if len(v.ResourceType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceType"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateFilterInput(v *UpdateFilterInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateFilterInput"}
	if v.FilterCriteria != nil {
		if err := validateFilterCriteria(v.FilterCriteria); err != nil {
			invalidParams.AddNested("FilterCriteria", err.(smithy.InvalidParamsError))
		}
	}
	if v.FilterArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("FilterArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateOrganizationConfigurationInput(v *UpdateOrganizationConfigurationInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateOrganizationConfigurationInput"}
	if v.AutoEnable == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AutoEnable"))
	} else if v.AutoEnable != nil {
		if err := validateAutoEnable(v.AutoEnable); err != nil {
			invalidParams.AddNested("AutoEnable", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateOrgEc2DeepInspectionConfigurationInput(v *UpdateOrgEc2DeepInspectionConfigurationInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateOrgEc2DeepInspectionConfigurationInput"}
	if v.OrgPackagePaths == nil {
		invalidParams.Add(smithy.NewErrParamRequired("OrgPackagePaths"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}
