// Code generated by smithy-go-codegen DO NOT EDIT.

package geoplaces

import (
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/geoplaces/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/middleware"
)

type validateOpAutocomplete struct {
}

func (*validateOpAutocomplete) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpAutocomplete) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*AutocompleteInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpAutocompleteInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetPlace struct {
}

func (*validateOpGetPlace) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetPlace) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetPlaceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetPlaceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpReverseGeocode struct {
}

func (*validateOpReverseGeocode) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpReverseGeocode) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ReverseGeocodeInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpReverseGeocodeInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpSearchNearby struct {
}

func (*validateOpSearchNearby) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpSearchNearby) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*SearchNearbyInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpSearchNearbyInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpSearchText struct {
}

func (*validateOpSearchText) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpSearchText) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*SearchTextInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpSearchTextInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpSuggest struct {
}

func (*validateOpSuggest) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpSuggest) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*SuggestInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpSuggestInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

func addOpAutocompleteValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpAutocomplete{}, middleware.After)
}

func addOpGetPlaceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetPlace{}, middleware.After)
}

func addOpReverseGeocodeValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpReverseGeocode{}, middleware.After)
}

func addOpSearchNearbyValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpSearchNearby{}, middleware.After)
}

func addOpSearchTextValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpSearchText{}, middleware.After)
}

func addOpSuggestValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpSuggest{}, middleware.After)
}

func validateAutocompleteFilter(v *types.AutocompleteFilter) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AutocompleteFilter"}
	if v.Circle != nil {
		if err := validateFilterCircle(v.Circle); err != nil {
			invalidParams.AddNested("Circle", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateFilterCircle(v *types.FilterCircle) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "FilterCircle"}
	if v.Center == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Center"))
	}
	if v.Radius == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Radius"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateSearchTextFilter(v *types.SearchTextFilter) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "SearchTextFilter"}
	if v.Circle != nil {
		if err := validateFilterCircle(v.Circle); err != nil {
			invalidParams.AddNested("Circle", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateSuggestFilter(v *types.SuggestFilter) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "SuggestFilter"}
	if v.Circle != nil {
		if err := validateFilterCircle(v.Circle); err != nil {
			invalidParams.AddNested("Circle", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpAutocompleteInput(v *AutocompleteInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AutocompleteInput"}
	if v.QueryText == nil {
		invalidParams.Add(smithy.NewErrParamRequired("QueryText"))
	}
	if v.Filter != nil {
		if err := validateAutocompleteFilter(v.Filter); err != nil {
			invalidParams.AddNested("Filter", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetPlaceInput(v *GetPlaceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetPlaceInput"}
	if v.PlaceId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PlaceId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpReverseGeocodeInput(v *ReverseGeocodeInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ReverseGeocodeInput"}
	if v.QueryPosition == nil {
		invalidParams.Add(smithy.NewErrParamRequired("QueryPosition"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpSearchNearbyInput(v *SearchNearbyInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "SearchNearbyInput"}
	if v.QueryPosition == nil {
		invalidParams.Add(smithy.NewErrParamRequired("QueryPosition"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpSearchTextInput(v *SearchTextInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "SearchTextInput"}
	if v.Filter != nil {
		if err := validateSearchTextFilter(v.Filter); err != nil {
			invalidParams.AddNested("Filter", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpSuggestInput(v *SuggestInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "SuggestInput"}
	if v.QueryText == nil {
		invalidParams.Add(smithy.NewErrParamRequired("QueryText"))
	}
	if v.Filter != nil {
		if err := validateSuggestFilter(v.Filter); err != nil {
			invalidParams.AddNested("Filter", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}
