// Code generated by smithy-go-codegen DO NOT EDIT.

package gameliftstreams

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/gameliftstreams/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

//	Updates the configuration settings for an Amazon GameLift Streams stream group
//
// resource. You can change the description, the set of locations, and the
// requested capacity of a stream group per location. If you want to change the
// stream class, create a new stream group.
//
// Stream capacity represents the number of concurrent streams that can be active
// at a time. You set stream capacity per location, per stream group. There are two
// types of capacity, always-on and on-demand:
//
//   - Always-on: The streaming capacity that is allocated and ready to handle
//     stream requests without delay. You pay for this capacity whether it's in use or
//     not. Best for quickest time from streaming request to streaming session.
//
//   - On-demand: The streaming capacity that Amazon GameLift Streams can allocate
//     in response to stream requests, and then de-allocate when the session has
//     terminated. This offers a cost control measure at the expense of a greater
//     startup time (typically under 5 minutes).
//
// To update a stream group, specify the stream group's Amazon Resource Name (ARN)
// and provide the new values. If the request is successful, Amazon GameLift
// Streams returns the complete updated metadata for the stream group.
func (c *Client) UpdateStreamGroup(ctx context.Context, params *UpdateStreamGroupInput, optFns ...func(*Options)) (*UpdateStreamGroupOutput, error) {
	if params == nil {
		params = &UpdateStreamGroupInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateStreamGroup", params, optFns, c.addOperationUpdateStreamGroupMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateStreamGroupOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateStreamGroupInput struct {

	// An [Amazon Resource Name (ARN)] or ID that uniquely identifies the stream group resource. Example ARN:
	// arn:aws:gameliftstreams:us-west-2:111122223333:streamgroup/sg-1AB2C3De4 .
	// Example ID: sg-1AB2C3De4 .
	//
	// [Amazon Resource Name (ARN)]: https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html
	//
	// This member is required.
	Identifier *string

	// A descriptive label for the stream group.
	Description *string

	//  A set of one or more locations and the streaming capacity for each location.
	LocationConfigurations []types.LocationConfiguration

	noSmithyDocumentSerde
}

type UpdateStreamGroupOutput struct {

	// The [Amazon Resource Name (ARN)] that is assigned to the stream group resource and that uniquely identifies
	// the group across all Amazon Web Services Regions. Format is
	// arn:aws:gameliftstreams:[AWS Region]:[AWS account]:streamgroup/[resource ID] .
	//
	// [Amazon Resource Name (ARN)]: https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html
	//
	// This member is required.
	Arn *string

	//  A set of applications that this stream group is associated with. You can
	// stream any of these applications with the stream group.
	//
	// This value is a set of [Amazon Resource Names (ARNs)] that uniquely identify application resources. Example
	// ARN: arn:aws:gameliftstreams:us-west-2:111122223333:application/a-9ZY8X7Wv6 .
	//
	// [Amazon Resource Names (ARNs)]: https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html
	AssociatedApplications []string

	// A timestamp that indicates when this resource was created. Timestamps are
	// expressed using in ISO8601 format, such as: 2022-12-27T22:29:40+00:00 (UTC).
	CreatedAt *time.Time

	// The default Amazon GameLift Streams application that is associated with this
	// stream group.
	DefaultApplication *types.DefaultApplication

	// A descriptive label for the stream group.
	Description *string

	// A unique ID value that is assigned to the resource when it's created. Format
	// example: sg-1AB2C3De4 .
	Id *string

	// A timestamp that indicates when this resource was last updated. Timestamps are
	// expressed using in ISO8601 format, such as: 2022-12-27T22:29:40+00:00 (UTC).
	LastUpdatedAt *time.Time

	// This value is set of locations, including their name, current status, and
	// capacities.
	//
	// A location can be in one of the following states:
	//
	//   - ACTIVATING: Amazon GameLift Streams is preparing the location. You cannot
	//   stream from, scale the capacity of, or remove this location yet.
	//
	//   - ACTIVE: The location is provisioned with initial capacity. You can now
	//   stream from, scale the capacity of, or remove this location.
	//
	//   - ERROR: Amazon GameLift Streams failed to set up this location. The
	//   StatusReason field describes the error. You can remove this location and try to
	//   add it again.
	//
	//   - REMOVING: Amazon GameLift Streams is working to remove this location. It
	//   releases all provisioned capacity for this location in this stream group.
	LocationStates []types.LocationState

	// The current status of the stream group resource. Possible statuses include the
	// following:
	//
	//   - ACTIVATING : The stream group is deploying and isn't ready to host streams.
	//
	//   - ACTIVE : The stream group is ready to host streams.
	//
	//   - ACTIVE_WITH_ERRORS : One or more locations in the stream group are in an
	//   error state. Verify the details of individual locations and remove any locations
	//   which are in error.
	//
	//   - ERROR : An error occurred when the stream group deployed. See StatusReason
	//   for more information.
	//
	//   - DELETING : Amazon GameLift Streams is in the process of deleting the stream
	//   group.
	//
	//   - UPDATING_LOCATIONS : One or more locations in the stream group are in the
	//   process of updating (either activating or deleting).
	Status types.StreamGroupStatus

	//  A short description of the reason that the stream group is in ERROR status.
	// The possible reasons can be one of the following:
	//
	//   - internalError : The request can't process right now bcause of an issue with
	//   the server. Try again later. Reach out to the Amazon GameLift Streams team for
	//   more help.
	//
	//   - noAvailableInstances : Amazon GameLift Streams does not currently have
	//   enough available On-Demand capacity to fulfill your request. Wait a few minutes
	//   and retry the request as capacity can shift frequently. You can also try to make
	//   the request using a different stream class or in another region.
	StatusReason types.StreamGroupStatusReason

	// The target stream quality for the stream group.
	//
	// A stream class can be one of the following:
	//
	//   - gen5n_win2022 (NVIDIA, ultra) Supports applications with extremely high 3D
	//   scene complexity. Runs applications on Microsoft Windows Server 2022 Base and
	//   supports DirectX 12. Compatible with Unreal Engine versions up through 5.4, 32
	//   and 64-bit applications, and anti-cheat technology. Uses NVIDIA A10G Tensor GPU.
	//
	//   - Reference resolution: 1080p
	//
	//   - Reference frame rate: 60 fps
	//
	//   - Workload specifications: 8 vCPUs, 32 GB RAM, 24 GB VRAM
	//
	//   - Tenancy: Supports 1 concurrent stream session
	//
	//   - gen5n_high (NVIDIA, high) Supports applications with moderate to high 3D
	//   scene complexity. Uses NVIDIA A10G Tensor GPU.
	//
	//   - Reference resolution: 1080p
	//
	//   - Reference frame rate: 60 fps
	//
	//   - Workload specifications: 4 vCPUs, 16 GB RAM, 12 GB VRAM
	//
	//   - Tenancy: Supports up to 2 concurrent stream sessions
	//
	//   - gen5n_ultra (NVIDIA, ultra) Supports applications with extremely high 3D
	//   scene complexity. Uses dedicated NVIDIA A10G Tensor GPU.
	//
	//   - Reference resolution: 1080p
	//
	//   - Reference frame rate: 60 fps
	//
	//   - Workload specifications: 8 vCPUs, 32 GB RAM, 24 GB VRAM
	//
	//   - Tenancy: Supports 1 concurrent stream session
	//
	//   - gen4n_win2022 (NVIDIA, ultra) Supports applications with extremely high 3D
	//   scene complexity. Runs applications on Microsoft Windows Server 2022 Base and
	//   supports DirectX 12. Compatible with Unreal Engine versions up through 5.4, 32
	//   and 64-bit applications, and anti-cheat technology. Uses NVIDIA T4 Tensor GPU.
	//
	//   - Reference resolution: 1080p
	//
	//   - Reference frame rate: 60 fps
	//
	//   - Workload specifications: 8 vCPUs, 32 GB RAM, 16 GB VRAM
	//
	//   - Tenancy: Supports 1 concurrent stream session
	//
	//   - gen4n_high (NVIDIA, high) Supports applications with moderate to high 3D
	//   scene complexity. Uses NVIDIA T4 Tensor GPU.
	//
	//   - Reference resolution: 1080p
	//
	//   - Reference frame rate: 60 fps
	//
	//   - Workload specifications: 4 vCPUs, 16 GB RAM, 8 GB VRAM
	//
	//   - Tenancy: Supports up to 2 concurrent stream sessions
	//
	//   - gen4n_ultra (NVIDIA, ultra) Supports applications with high 3D scene
	//   complexity. Uses dedicated NVIDIA T4 Tensor GPU.
	//
	//   - Reference resolution: 1080p
	//
	//   - Reference frame rate: 60 fps
	//
	//   - Workload specifications: 8 vCPUs, 32 GB RAM, 16 GB VRAM
	//
	//   - Tenancy: Supports 1 concurrent stream session
	StreamClass types.StreamClass

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateStreamGroupMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpUpdateStreamGroup{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpUpdateStreamGroup{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateStreamGroup"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpUpdateStreamGroupValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateStreamGroup(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateStreamGroup(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateStreamGroup",
	}
}
