// Code generated by smithy-go-codegen DO NOT EDIT.

package fsx

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/fsx/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns the DNS aliases that are associated with the specified Amazon FSx for
// Windows File Server file system. A history of all DNS aliases that have been
// associated with and disassociated from the file system is available in the list
// of AdministrativeActionprovided in the DescribeFileSystems operation response.
func (c *Client) DescribeFileSystemAliases(ctx context.Context, params *DescribeFileSystemAliasesInput, optFns ...func(*Options)) (*DescribeFileSystemAliasesOutput, error) {
	if params == nil {
		params = &DescribeFileSystemAliasesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeFileSystemAliases", params, optFns, c.addOperationDescribeFileSystemAliasesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeFileSystemAliasesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// The request object for DescribeFileSystemAliases operation.
type DescribeFileSystemAliasesInput struct {

	// The ID of the file system to return the associated DNS aliases for (String).
	//
	// This member is required.
	FileSystemId *string

	// (Optional) An idempotency token for resource creation, in a string of up to 63
	// ASCII characters. This token is automatically filled on your behalf when you use
	// the Command Line Interface (CLI) or an Amazon Web Services SDK.
	ClientRequestToken *string

	// Maximum number of DNS aliases to return in the response (integer). This
	// parameter value must be greater than 0. The number of items that Amazon FSx
	// returns is the minimum of the MaxResults parameter specified in the request and
	// the service's internal maximum number of items per page.
	MaxResults *int32

	// Opaque pagination token returned from a previous DescribeFileSystemAliases
	// operation (String). If a token is included in the request, the action continues
	// the list from where the previous returning call left off.
	NextToken *string

	noSmithyDocumentSerde
}

// The response object for DescribeFileSystemAliases operation.
type DescribeFileSystemAliasesOutput struct {

	// An array of one or more DNS aliases currently associated with the specified
	// file system.
	Aliases []types.Alias

	// Present if there are more DNS aliases than returned in the response (String).
	// You can use the NextToken value in a later request to fetch additional
	// descriptions.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeFileSystemAliasesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpDescribeFileSystemAliases{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpDescribeFileSystemAliases{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DescribeFileSystemAliases"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opDescribeFileSystemAliasesMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpDescribeFileSystemAliasesValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeFileSystemAliases(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// DescribeFileSystemAliasesPaginatorOptions is the paginator options for
// DescribeFileSystemAliases
type DescribeFileSystemAliasesPaginatorOptions struct {
	// Maximum number of DNS aliases to return in the response (integer). This
	// parameter value must be greater than 0. The number of items that Amazon FSx
	// returns is the minimum of the MaxResults parameter specified in the request and
	// the service's internal maximum number of items per page.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// DescribeFileSystemAliasesPaginator is a paginator for DescribeFileSystemAliases
type DescribeFileSystemAliasesPaginator struct {
	options   DescribeFileSystemAliasesPaginatorOptions
	client    DescribeFileSystemAliasesAPIClient
	params    *DescribeFileSystemAliasesInput
	nextToken *string
	firstPage bool
}

// NewDescribeFileSystemAliasesPaginator returns a new
// DescribeFileSystemAliasesPaginator
func NewDescribeFileSystemAliasesPaginator(client DescribeFileSystemAliasesAPIClient, params *DescribeFileSystemAliasesInput, optFns ...func(*DescribeFileSystemAliasesPaginatorOptions)) *DescribeFileSystemAliasesPaginator {
	if params == nil {
		params = &DescribeFileSystemAliasesInput{}
	}

	options := DescribeFileSystemAliasesPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &DescribeFileSystemAliasesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *DescribeFileSystemAliasesPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next DescribeFileSystemAliases page.
func (p *DescribeFileSystemAliasesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*DescribeFileSystemAliasesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.DescribeFileSystemAliases(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// DescribeFileSystemAliasesAPIClient is a client that implements the
// DescribeFileSystemAliases operation.
type DescribeFileSystemAliasesAPIClient interface {
	DescribeFileSystemAliases(context.Context, *DescribeFileSystemAliasesInput, ...func(*Options)) (*DescribeFileSystemAliasesOutput, error)
}

var _ DescribeFileSystemAliasesAPIClient = (*Client)(nil)

type idempotencyToken_initializeOpDescribeFileSystemAliases struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpDescribeFileSystemAliases) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpDescribeFileSystemAliases) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*DescribeFileSystemAliasesInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *DescribeFileSystemAliasesInput ")
	}

	if input.ClientRequestToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientRequestToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opDescribeFileSystemAliasesMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpDescribeFileSystemAliases{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opDescribeFileSystemAliases(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DescribeFileSystemAliases",
	}
}
