// Code generated by smithy-go-codegen DO NOT EDIT.

package emr

import (
	"bytes"
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/emr/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/encoding/httpbinding"
	smithyjson "github.com/aws/smithy-go/encoding/json"
	"github.com/aws/smithy-go/middleware"
	smithytime "github.com/aws/smithy-go/time"
	"github.com/aws/smithy-go/tracing"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"math"
	"path"
)

type awsAwsjson11_serializeOpAddInstanceFleet struct {
}

func (*awsAwsjson11_serializeOpAddInstanceFleet) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpAddInstanceFleet) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AddInstanceFleetInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("ElasticMapReduce.AddInstanceFleet")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentAddInstanceFleetInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpAddInstanceGroups struct {
}

func (*awsAwsjson11_serializeOpAddInstanceGroups) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpAddInstanceGroups) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AddInstanceGroupsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("ElasticMapReduce.AddInstanceGroups")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentAddInstanceGroupsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpAddJobFlowSteps struct {
}

func (*awsAwsjson11_serializeOpAddJobFlowSteps) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpAddJobFlowSteps) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AddJobFlowStepsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("ElasticMapReduce.AddJobFlowSteps")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentAddJobFlowStepsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpAddTags struct {
}

func (*awsAwsjson11_serializeOpAddTags) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpAddTags) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AddTagsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("ElasticMapReduce.AddTags")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentAddTagsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpCancelSteps struct {
}

func (*awsAwsjson11_serializeOpCancelSteps) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpCancelSteps) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CancelStepsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("ElasticMapReduce.CancelSteps")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentCancelStepsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpCreatePersistentAppUI struct {
}

func (*awsAwsjson11_serializeOpCreatePersistentAppUI) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpCreatePersistentAppUI) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreatePersistentAppUIInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("ElasticMapReduce.CreatePersistentAppUI")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentCreatePersistentAppUIInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpCreateSecurityConfiguration struct {
}

func (*awsAwsjson11_serializeOpCreateSecurityConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpCreateSecurityConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateSecurityConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("ElasticMapReduce.CreateSecurityConfiguration")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentCreateSecurityConfigurationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpCreateStudio struct {
}

func (*awsAwsjson11_serializeOpCreateStudio) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpCreateStudio) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateStudioInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("ElasticMapReduce.CreateStudio")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentCreateStudioInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpCreateStudioSessionMapping struct {
}

func (*awsAwsjson11_serializeOpCreateStudioSessionMapping) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpCreateStudioSessionMapping) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateStudioSessionMappingInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("ElasticMapReduce.CreateStudioSessionMapping")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentCreateStudioSessionMappingInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDeleteSecurityConfiguration struct {
}

func (*awsAwsjson11_serializeOpDeleteSecurityConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDeleteSecurityConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteSecurityConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("ElasticMapReduce.DeleteSecurityConfiguration")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDeleteSecurityConfigurationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDeleteStudio struct {
}

func (*awsAwsjson11_serializeOpDeleteStudio) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDeleteStudio) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteStudioInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("ElasticMapReduce.DeleteStudio")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDeleteStudioInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDeleteStudioSessionMapping struct {
}

func (*awsAwsjson11_serializeOpDeleteStudioSessionMapping) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDeleteStudioSessionMapping) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteStudioSessionMappingInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("ElasticMapReduce.DeleteStudioSessionMapping")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDeleteStudioSessionMappingInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDescribeCluster struct {
}

func (*awsAwsjson11_serializeOpDescribeCluster) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDescribeCluster) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeClusterInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("ElasticMapReduce.DescribeCluster")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDescribeClusterInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDescribeJobFlows struct {
}

func (*awsAwsjson11_serializeOpDescribeJobFlows) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDescribeJobFlows) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeJobFlowsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("ElasticMapReduce.DescribeJobFlows")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDescribeJobFlowsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDescribeNotebookExecution struct {
}

func (*awsAwsjson11_serializeOpDescribeNotebookExecution) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDescribeNotebookExecution) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeNotebookExecutionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("ElasticMapReduce.DescribeNotebookExecution")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDescribeNotebookExecutionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDescribePersistentAppUI struct {
}

func (*awsAwsjson11_serializeOpDescribePersistentAppUI) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDescribePersistentAppUI) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribePersistentAppUIInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("ElasticMapReduce.DescribePersistentAppUI")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDescribePersistentAppUIInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDescribeReleaseLabel struct {
}

func (*awsAwsjson11_serializeOpDescribeReleaseLabel) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDescribeReleaseLabel) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeReleaseLabelInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("ElasticMapReduce.DescribeReleaseLabel")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDescribeReleaseLabelInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDescribeSecurityConfiguration struct {
}

func (*awsAwsjson11_serializeOpDescribeSecurityConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDescribeSecurityConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeSecurityConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("ElasticMapReduce.DescribeSecurityConfiguration")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDescribeSecurityConfigurationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDescribeStep struct {
}

func (*awsAwsjson11_serializeOpDescribeStep) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDescribeStep) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeStepInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("ElasticMapReduce.DescribeStep")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDescribeStepInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDescribeStudio struct {
}

func (*awsAwsjson11_serializeOpDescribeStudio) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDescribeStudio) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeStudioInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("ElasticMapReduce.DescribeStudio")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDescribeStudioInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetAutoTerminationPolicy struct {
}

func (*awsAwsjson11_serializeOpGetAutoTerminationPolicy) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetAutoTerminationPolicy) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetAutoTerminationPolicyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("ElasticMapReduce.GetAutoTerminationPolicy")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetAutoTerminationPolicyInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetBlockPublicAccessConfiguration struct {
}

func (*awsAwsjson11_serializeOpGetBlockPublicAccessConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetBlockPublicAccessConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetBlockPublicAccessConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("ElasticMapReduce.GetBlockPublicAccessConfiguration")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetBlockPublicAccessConfigurationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetClusterSessionCredentials struct {
}

func (*awsAwsjson11_serializeOpGetClusterSessionCredentials) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetClusterSessionCredentials) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetClusterSessionCredentialsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("ElasticMapReduce.GetClusterSessionCredentials")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetClusterSessionCredentialsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetManagedScalingPolicy struct {
}

func (*awsAwsjson11_serializeOpGetManagedScalingPolicy) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetManagedScalingPolicy) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetManagedScalingPolicyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("ElasticMapReduce.GetManagedScalingPolicy")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetManagedScalingPolicyInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetOnClusterAppUIPresignedURL struct {
}

func (*awsAwsjson11_serializeOpGetOnClusterAppUIPresignedURL) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetOnClusterAppUIPresignedURL) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetOnClusterAppUIPresignedURLInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("ElasticMapReduce.GetOnClusterAppUIPresignedURL")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetOnClusterAppUIPresignedURLInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetPersistentAppUIPresignedURL struct {
}

func (*awsAwsjson11_serializeOpGetPersistentAppUIPresignedURL) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetPersistentAppUIPresignedURL) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetPersistentAppUIPresignedURLInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("ElasticMapReduce.GetPersistentAppUIPresignedURL")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetPersistentAppUIPresignedURLInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetStudioSessionMapping struct {
}

func (*awsAwsjson11_serializeOpGetStudioSessionMapping) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetStudioSessionMapping) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetStudioSessionMappingInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("ElasticMapReduce.GetStudioSessionMapping")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetStudioSessionMappingInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpListBootstrapActions struct {
}

func (*awsAwsjson11_serializeOpListBootstrapActions) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpListBootstrapActions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListBootstrapActionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("ElasticMapReduce.ListBootstrapActions")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentListBootstrapActionsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpListClusters struct {
}

func (*awsAwsjson11_serializeOpListClusters) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpListClusters) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListClustersInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("ElasticMapReduce.ListClusters")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentListClustersInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpListInstanceFleets struct {
}

func (*awsAwsjson11_serializeOpListInstanceFleets) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpListInstanceFleets) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListInstanceFleetsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("ElasticMapReduce.ListInstanceFleets")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentListInstanceFleetsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpListInstanceGroups struct {
}

func (*awsAwsjson11_serializeOpListInstanceGroups) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpListInstanceGroups) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListInstanceGroupsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("ElasticMapReduce.ListInstanceGroups")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentListInstanceGroupsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpListInstances struct {
}

func (*awsAwsjson11_serializeOpListInstances) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpListInstances) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListInstancesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("ElasticMapReduce.ListInstances")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentListInstancesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpListNotebookExecutions struct {
}

func (*awsAwsjson11_serializeOpListNotebookExecutions) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpListNotebookExecutions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListNotebookExecutionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("ElasticMapReduce.ListNotebookExecutions")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentListNotebookExecutionsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpListReleaseLabels struct {
}

func (*awsAwsjson11_serializeOpListReleaseLabels) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpListReleaseLabels) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListReleaseLabelsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("ElasticMapReduce.ListReleaseLabels")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentListReleaseLabelsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpListSecurityConfigurations struct {
}

func (*awsAwsjson11_serializeOpListSecurityConfigurations) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpListSecurityConfigurations) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListSecurityConfigurationsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("ElasticMapReduce.ListSecurityConfigurations")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentListSecurityConfigurationsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpListSteps struct {
}

func (*awsAwsjson11_serializeOpListSteps) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpListSteps) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListStepsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("ElasticMapReduce.ListSteps")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentListStepsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpListStudios struct {
}

func (*awsAwsjson11_serializeOpListStudios) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpListStudios) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListStudiosInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("ElasticMapReduce.ListStudios")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentListStudiosInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpListStudioSessionMappings struct {
}

func (*awsAwsjson11_serializeOpListStudioSessionMappings) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpListStudioSessionMappings) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListStudioSessionMappingsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("ElasticMapReduce.ListStudioSessionMappings")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentListStudioSessionMappingsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpListSupportedInstanceTypes struct {
}

func (*awsAwsjson11_serializeOpListSupportedInstanceTypes) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpListSupportedInstanceTypes) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListSupportedInstanceTypesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("ElasticMapReduce.ListSupportedInstanceTypes")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentListSupportedInstanceTypesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpModifyCluster struct {
}

func (*awsAwsjson11_serializeOpModifyCluster) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpModifyCluster) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ModifyClusterInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("ElasticMapReduce.ModifyCluster")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentModifyClusterInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpModifyInstanceFleet struct {
}

func (*awsAwsjson11_serializeOpModifyInstanceFleet) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpModifyInstanceFleet) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ModifyInstanceFleetInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("ElasticMapReduce.ModifyInstanceFleet")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentModifyInstanceFleetInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpModifyInstanceGroups struct {
}

func (*awsAwsjson11_serializeOpModifyInstanceGroups) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpModifyInstanceGroups) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ModifyInstanceGroupsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("ElasticMapReduce.ModifyInstanceGroups")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentModifyInstanceGroupsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpPutAutoScalingPolicy struct {
}

func (*awsAwsjson11_serializeOpPutAutoScalingPolicy) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpPutAutoScalingPolicy) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutAutoScalingPolicyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("ElasticMapReduce.PutAutoScalingPolicy")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentPutAutoScalingPolicyInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpPutAutoTerminationPolicy struct {
}

func (*awsAwsjson11_serializeOpPutAutoTerminationPolicy) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpPutAutoTerminationPolicy) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutAutoTerminationPolicyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("ElasticMapReduce.PutAutoTerminationPolicy")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentPutAutoTerminationPolicyInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpPutBlockPublicAccessConfiguration struct {
}

func (*awsAwsjson11_serializeOpPutBlockPublicAccessConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpPutBlockPublicAccessConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutBlockPublicAccessConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("ElasticMapReduce.PutBlockPublicAccessConfiguration")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentPutBlockPublicAccessConfigurationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpPutManagedScalingPolicy struct {
}

func (*awsAwsjson11_serializeOpPutManagedScalingPolicy) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpPutManagedScalingPolicy) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutManagedScalingPolicyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("ElasticMapReduce.PutManagedScalingPolicy")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentPutManagedScalingPolicyInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpRemoveAutoScalingPolicy struct {
}

func (*awsAwsjson11_serializeOpRemoveAutoScalingPolicy) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpRemoveAutoScalingPolicy) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*RemoveAutoScalingPolicyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("ElasticMapReduce.RemoveAutoScalingPolicy")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentRemoveAutoScalingPolicyInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpRemoveAutoTerminationPolicy struct {
}

func (*awsAwsjson11_serializeOpRemoveAutoTerminationPolicy) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpRemoveAutoTerminationPolicy) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*RemoveAutoTerminationPolicyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("ElasticMapReduce.RemoveAutoTerminationPolicy")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentRemoveAutoTerminationPolicyInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpRemoveManagedScalingPolicy struct {
}

func (*awsAwsjson11_serializeOpRemoveManagedScalingPolicy) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpRemoveManagedScalingPolicy) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*RemoveManagedScalingPolicyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("ElasticMapReduce.RemoveManagedScalingPolicy")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentRemoveManagedScalingPolicyInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpRemoveTags struct {
}

func (*awsAwsjson11_serializeOpRemoveTags) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpRemoveTags) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*RemoveTagsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("ElasticMapReduce.RemoveTags")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentRemoveTagsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpRunJobFlow struct {
}

func (*awsAwsjson11_serializeOpRunJobFlow) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpRunJobFlow) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*RunJobFlowInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("ElasticMapReduce.RunJobFlow")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentRunJobFlowInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpSetKeepJobFlowAliveWhenNoSteps struct {
}

func (*awsAwsjson11_serializeOpSetKeepJobFlowAliveWhenNoSteps) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpSetKeepJobFlowAliveWhenNoSteps) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*SetKeepJobFlowAliveWhenNoStepsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("ElasticMapReduce.SetKeepJobFlowAliveWhenNoSteps")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentSetKeepJobFlowAliveWhenNoStepsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpSetTerminationProtection struct {
}

func (*awsAwsjson11_serializeOpSetTerminationProtection) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpSetTerminationProtection) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*SetTerminationProtectionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("ElasticMapReduce.SetTerminationProtection")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentSetTerminationProtectionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpSetUnhealthyNodeReplacement struct {
}

func (*awsAwsjson11_serializeOpSetUnhealthyNodeReplacement) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpSetUnhealthyNodeReplacement) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*SetUnhealthyNodeReplacementInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("ElasticMapReduce.SetUnhealthyNodeReplacement")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentSetUnhealthyNodeReplacementInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpSetVisibleToAllUsers struct {
}

func (*awsAwsjson11_serializeOpSetVisibleToAllUsers) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpSetVisibleToAllUsers) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*SetVisibleToAllUsersInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("ElasticMapReduce.SetVisibleToAllUsers")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentSetVisibleToAllUsersInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpStartNotebookExecution struct {
}

func (*awsAwsjson11_serializeOpStartNotebookExecution) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpStartNotebookExecution) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StartNotebookExecutionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("ElasticMapReduce.StartNotebookExecution")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentStartNotebookExecutionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpStopNotebookExecution struct {
}

func (*awsAwsjson11_serializeOpStopNotebookExecution) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpStopNotebookExecution) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StopNotebookExecutionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("ElasticMapReduce.StopNotebookExecution")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentStopNotebookExecutionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpTerminateJobFlows struct {
}

func (*awsAwsjson11_serializeOpTerminateJobFlows) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpTerminateJobFlows) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*TerminateJobFlowsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("ElasticMapReduce.TerminateJobFlows")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentTerminateJobFlowsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpUpdateStudio struct {
}

func (*awsAwsjson11_serializeOpUpdateStudio) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpUpdateStudio) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateStudioInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("ElasticMapReduce.UpdateStudio")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentUpdateStudioInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpUpdateStudioSessionMapping struct {
}

func (*awsAwsjson11_serializeOpUpdateStudioSessionMapping) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpUpdateStudioSessionMapping) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateStudioSessionMappingInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("ElasticMapReduce.UpdateStudioSessionMapping")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentUpdateStudioSessionMappingInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsAwsjson11_serializeDocumentApplication(v *types.Application, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AdditionalInfo != nil {
		ok := object.Key("AdditionalInfo")
		if err := awsAwsjson11_serializeDocumentStringMap(v.AdditionalInfo, ok); err != nil {
			return err
		}
	}

	if v.Args != nil {
		ok := object.Key("Args")
		if err := awsAwsjson11_serializeDocumentStringList(v.Args, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.Version != nil {
		ok := object.Key("Version")
		ok.String(*v.Version)
	}

	return nil
}

func awsAwsjson11_serializeDocumentApplicationList(v []types.Application, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentApplication(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentAutoScalingPolicy(v *types.AutoScalingPolicy, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Constraints != nil {
		ok := object.Key("Constraints")
		if err := awsAwsjson11_serializeDocumentScalingConstraints(v.Constraints, ok); err != nil {
			return err
		}
	}

	if v.Rules != nil {
		ok := object.Key("Rules")
		if err := awsAwsjson11_serializeDocumentScalingRuleList(v.Rules, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentAutoTerminationPolicy(v *types.AutoTerminationPolicy, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.IdleTimeout != nil {
		ok := object.Key("IdleTimeout")
		ok.Long(*v.IdleTimeout)
	}

	return nil
}

func awsAwsjson11_serializeDocumentBlockPublicAccessConfiguration(v *types.BlockPublicAccessConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BlockPublicSecurityGroupRules != nil {
		ok := object.Key("BlockPublicSecurityGroupRules")
		ok.Boolean(*v.BlockPublicSecurityGroupRules)
	}

	if v.Classification != nil {
		ok := object.Key("Classification")
		ok.String(*v.Classification)
	}

	if v.Configurations != nil {
		ok := object.Key("Configurations")
		if err := awsAwsjson11_serializeDocumentConfigurationList(v.Configurations, ok); err != nil {
			return err
		}
	}

	if v.PermittedPublicSecurityGroupRuleRanges != nil {
		ok := object.Key("PermittedPublicSecurityGroupRuleRanges")
		if err := awsAwsjson11_serializeDocumentPortRanges(v.PermittedPublicSecurityGroupRuleRanges, ok); err != nil {
			return err
		}
	}

	if v.Properties != nil {
		ok := object.Key("Properties")
		if err := awsAwsjson11_serializeDocumentStringMap(v.Properties, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentBootstrapActionConfig(v *types.BootstrapActionConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.ScriptBootstrapAction != nil {
		ok := object.Key("ScriptBootstrapAction")
		if err := awsAwsjson11_serializeDocumentScriptBootstrapActionConfig(v.ScriptBootstrapAction, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentBootstrapActionConfigList(v []types.BootstrapActionConfig, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentBootstrapActionConfig(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentCloudWatchAlarmDefinition(v *types.CloudWatchAlarmDefinition, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.ComparisonOperator) > 0 {
		ok := object.Key("ComparisonOperator")
		ok.String(string(v.ComparisonOperator))
	}

	if v.Dimensions != nil {
		ok := object.Key("Dimensions")
		if err := awsAwsjson11_serializeDocumentMetricDimensionList(v.Dimensions, ok); err != nil {
			return err
		}
	}

	if v.EvaluationPeriods != nil {
		ok := object.Key("EvaluationPeriods")
		ok.Integer(*v.EvaluationPeriods)
	}

	if v.MetricName != nil {
		ok := object.Key("MetricName")
		ok.String(*v.MetricName)
	}

	if v.Namespace != nil {
		ok := object.Key("Namespace")
		ok.String(*v.Namespace)
	}

	if v.Period != nil {
		ok := object.Key("Period")
		ok.Integer(*v.Period)
	}

	if len(v.Statistic) > 0 {
		ok := object.Key("Statistic")
		ok.String(string(v.Statistic))
	}

	if v.Threshold != nil {
		ok := object.Key("Threshold")
		switch {
		case math.IsNaN(*v.Threshold):
			ok.String("NaN")

		case math.IsInf(*v.Threshold, 1):
			ok.String("Infinity")

		case math.IsInf(*v.Threshold, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.Threshold)

		}
	}

	if len(v.Unit) > 0 {
		ok := object.Key("Unit")
		ok.String(string(v.Unit))
	}

	return nil
}

func awsAwsjson11_serializeDocumentClusterStateList(v []types.ClusterState, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsAwsjson11_serializeDocumentComputeLimits(v *types.ComputeLimits, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaximumCapacityUnits != nil {
		ok := object.Key("MaximumCapacityUnits")
		ok.Integer(*v.MaximumCapacityUnits)
	}

	if v.MaximumCoreCapacityUnits != nil {
		ok := object.Key("MaximumCoreCapacityUnits")
		ok.Integer(*v.MaximumCoreCapacityUnits)
	}

	if v.MaximumOnDemandCapacityUnits != nil {
		ok := object.Key("MaximumOnDemandCapacityUnits")
		ok.Integer(*v.MaximumOnDemandCapacityUnits)
	}

	if v.MinimumCapacityUnits != nil {
		ok := object.Key("MinimumCapacityUnits")
		ok.Integer(*v.MinimumCapacityUnits)
	}

	if len(v.UnitType) > 0 {
		ok := object.Key("UnitType")
		ok.String(string(v.UnitType))
	}

	return nil
}

func awsAwsjson11_serializeDocumentConfiguration(v *types.Configuration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Classification != nil {
		ok := object.Key("Classification")
		ok.String(*v.Classification)
	}

	if v.Configurations != nil {
		ok := object.Key("Configurations")
		if err := awsAwsjson11_serializeDocumentConfigurationList(v.Configurations, ok); err != nil {
			return err
		}
	}

	if v.Properties != nil {
		ok := object.Key("Properties")
		if err := awsAwsjson11_serializeDocumentStringMap(v.Properties, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentConfigurationList(v []types.Configuration, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentConfiguration(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentEbsBlockDeviceConfig(v *types.EbsBlockDeviceConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.VolumeSpecification != nil {
		ok := object.Key("VolumeSpecification")
		if err := awsAwsjson11_serializeDocumentVolumeSpecification(v.VolumeSpecification, ok); err != nil {
			return err
		}
	}

	if v.VolumesPerInstance != nil {
		ok := object.Key("VolumesPerInstance")
		ok.Integer(*v.VolumesPerInstance)
	}

	return nil
}

func awsAwsjson11_serializeDocumentEbsBlockDeviceConfigList(v []types.EbsBlockDeviceConfig, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentEbsBlockDeviceConfig(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentEbsConfiguration(v *types.EbsConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EbsBlockDeviceConfigs != nil {
		ok := object.Key("EbsBlockDeviceConfigs")
		if err := awsAwsjson11_serializeDocumentEbsBlockDeviceConfigList(v.EbsBlockDeviceConfigs, ok); err != nil {
			return err
		}
	}

	if v.EbsOptimized != nil {
		ok := object.Key("EbsOptimized")
		ok.Boolean(*v.EbsOptimized)
	}

	return nil
}

func awsAwsjson11_serializeDocumentEC2InstanceIdsList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentEC2InstanceIdsToTerminateList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentEMRContainersConfig(v *types.EMRContainersConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.JobRunId != nil {
		ok := object.Key("JobRunId")
		ok.String(*v.JobRunId)
	}

	return nil
}

func awsAwsjson11_serializeDocumentEnvironmentVariablesMap(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsAwsjson11_serializeDocumentExecutionEngineConfig(v *types.ExecutionEngineConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ExecutionRoleArn != nil {
		ok := object.Key("ExecutionRoleArn")
		ok.String(*v.ExecutionRoleArn)
	}

	if v.Id != nil {
		ok := object.Key("Id")
		ok.String(*v.Id)
	}

	if v.MasterInstanceSecurityGroupId != nil {
		ok := object.Key("MasterInstanceSecurityGroupId")
		ok.String(*v.MasterInstanceSecurityGroupId)
	}

	if len(v.Type) > 0 {
		ok := object.Key("Type")
		ok.String(string(v.Type))
	}

	return nil
}

func awsAwsjson11_serializeDocumentHadoopJarStepConfig(v *types.HadoopJarStepConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Args != nil {
		ok := object.Key("Args")
		if err := awsAwsjson11_serializeDocumentXmlStringList(v.Args, ok); err != nil {
			return err
		}
	}

	if v.Jar != nil {
		ok := object.Key("Jar")
		ok.String(*v.Jar)
	}

	if v.MainClass != nil {
		ok := object.Key("MainClass")
		ok.String(*v.MainClass)
	}

	if v.Properties != nil {
		ok := object.Key("Properties")
		if err := awsAwsjson11_serializeDocumentKeyValueList(v.Properties, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentInstanceFleetConfig(v *types.InstanceFleetConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Context != nil {
		ok := object.Key("Context")
		ok.String(*v.Context)
	}

	if len(v.InstanceFleetType) > 0 {
		ok := object.Key("InstanceFleetType")
		ok.String(string(v.InstanceFleetType))
	}

	if v.InstanceTypeConfigs != nil {
		ok := object.Key("InstanceTypeConfigs")
		if err := awsAwsjson11_serializeDocumentInstanceTypeConfigList(v.InstanceTypeConfigs, ok); err != nil {
			return err
		}
	}

	if v.LaunchSpecifications != nil {
		ok := object.Key("LaunchSpecifications")
		if err := awsAwsjson11_serializeDocumentInstanceFleetProvisioningSpecifications(v.LaunchSpecifications, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.ResizeSpecifications != nil {
		ok := object.Key("ResizeSpecifications")
		if err := awsAwsjson11_serializeDocumentInstanceFleetResizingSpecifications(v.ResizeSpecifications, ok); err != nil {
			return err
		}
	}

	if v.TargetOnDemandCapacity != nil {
		ok := object.Key("TargetOnDemandCapacity")
		ok.Integer(*v.TargetOnDemandCapacity)
	}

	if v.TargetSpotCapacity != nil {
		ok := object.Key("TargetSpotCapacity")
		ok.Integer(*v.TargetSpotCapacity)
	}

	return nil
}

func awsAwsjson11_serializeDocumentInstanceFleetConfigList(v []types.InstanceFleetConfig, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentInstanceFleetConfig(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentInstanceFleetModifyConfig(v *types.InstanceFleetModifyConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Context != nil {
		ok := object.Key("Context")
		ok.String(*v.Context)
	}

	if v.InstanceFleetId != nil {
		ok := object.Key("InstanceFleetId")
		ok.String(*v.InstanceFleetId)
	}

	if v.InstanceTypeConfigs != nil {
		ok := object.Key("InstanceTypeConfigs")
		if err := awsAwsjson11_serializeDocumentInstanceTypeConfigList(v.InstanceTypeConfigs, ok); err != nil {
			return err
		}
	}

	if v.ResizeSpecifications != nil {
		ok := object.Key("ResizeSpecifications")
		if err := awsAwsjson11_serializeDocumentInstanceFleetResizingSpecifications(v.ResizeSpecifications, ok); err != nil {
			return err
		}
	}

	if v.TargetOnDemandCapacity != nil {
		ok := object.Key("TargetOnDemandCapacity")
		ok.Integer(*v.TargetOnDemandCapacity)
	}

	if v.TargetSpotCapacity != nil {
		ok := object.Key("TargetSpotCapacity")
		ok.Integer(*v.TargetSpotCapacity)
	}

	return nil
}

func awsAwsjson11_serializeDocumentInstanceFleetProvisioningSpecifications(v *types.InstanceFleetProvisioningSpecifications, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.OnDemandSpecification != nil {
		ok := object.Key("OnDemandSpecification")
		if err := awsAwsjson11_serializeDocumentOnDemandProvisioningSpecification(v.OnDemandSpecification, ok); err != nil {
			return err
		}
	}

	if v.SpotSpecification != nil {
		ok := object.Key("SpotSpecification")
		if err := awsAwsjson11_serializeDocumentSpotProvisioningSpecification(v.SpotSpecification, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentInstanceFleetResizingSpecifications(v *types.InstanceFleetResizingSpecifications, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.OnDemandResizeSpecification != nil {
		ok := object.Key("OnDemandResizeSpecification")
		if err := awsAwsjson11_serializeDocumentOnDemandResizingSpecification(v.OnDemandResizeSpecification, ok); err != nil {
			return err
		}
	}

	if v.SpotResizeSpecification != nil {
		ok := object.Key("SpotResizeSpecification")
		if err := awsAwsjson11_serializeDocumentSpotResizingSpecification(v.SpotResizeSpecification, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentInstanceGroupConfig(v *types.InstanceGroupConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AutoScalingPolicy != nil {
		ok := object.Key("AutoScalingPolicy")
		if err := awsAwsjson11_serializeDocumentAutoScalingPolicy(v.AutoScalingPolicy, ok); err != nil {
			return err
		}
	}

	if v.BidPrice != nil {
		ok := object.Key("BidPrice")
		ok.String(*v.BidPrice)
	}

	if v.Configurations != nil {
		ok := object.Key("Configurations")
		if err := awsAwsjson11_serializeDocumentConfigurationList(v.Configurations, ok); err != nil {
			return err
		}
	}

	if v.CustomAmiId != nil {
		ok := object.Key("CustomAmiId")
		ok.String(*v.CustomAmiId)
	}

	if v.EbsConfiguration != nil {
		ok := object.Key("EbsConfiguration")
		if err := awsAwsjson11_serializeDocumentEbsConfiguration(v.EbsConfiguration, ok); err != nil {
			return err
		}
	}

	if v.InstanceCount != nil {
		ok := object.Key("InstanceCount")
		ok.Integer(*v.InstanceCount)
	}

	if len(v.InstanceRole) > 0 {
		ok := object.Key("InstanceRole")
		ok.String(string(v.InstanceRole))
	}

	if v.InstanceType != nil {
		ok := object.Key("InstanceType")
		ok.String(*v.InstanceType)
	}

	if len(v.Market) > 0 {
		ok := object.Key("Market")
		ok.String(string(v.Market))
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	return nil
}

func awsAwsjson11_serializeDocumentInstanceGroupConfigList(v []types.InstanceGroupConfig, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentInstanceGroupConfig(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentInstanceGroupModifyConfig(v *types.InstanceGroupModifyConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Configurations != nil {
		ok := object.Key("Configurations")
		if err := awsAwsjson11_serializeDocumentConfigurationList(v.Configurations, ok); err != nil {
			return err
		}
	}

	if v.EC2InstanceIdsToTerminate != nil {
		ok := object.Key("EC2InstanceIdsToTerminate")
		if err := awsAwsjson11_serializeDocumentEC2InstanceIdsToTerminateList(v.EC2InstanceIdsToTerminate, ok); err != nil {
			return err
		}
	}

	if v.InstanceCount != nil {
		ok := object.Key("InstanceCount")
		ok.Integer(*v.InstanceCount)
	}

	if v.InstanceGroupId != nil {
		ok := object.Key("InstanceGroupId")
		ok.String(*v.InstanceGroupId)
	}

	if len(v.ReconfigurationType) > 0 {
		ok := object.Key("ReconfigurationType")
		ok.String(string(v.ReconfigurationType))
	}

	if v.ShrinkPolicy != nil {
		ok := object.Key("ShrinkPolicy")
		if err := awsAwsjson11_serializeDocumentShrinkPolicy(v.ShrinkPolicy, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentInstanceGroupModifyConfigList(v []types.InstanceGroupModifyConfig, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentInstanceGroupModifyConfig(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentInstanceGroupTypeList(v []types.InstanceGroupType, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsAwsjson11_serializeDocumentInstanceResizePolicy(v *types.InstanceResizePolicy, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.InstancesToProtect != nil {
		ok := object.Key("InstancesToProtect")
		if err := awsAwsjson11_serializeDocumentEC2InstanceIdsList(v.InstancesToProtect, ok); err != nil {
			return err
		}
	}

	if v.InstancesToTerminate != nil {
		ok := object.Key("InstancesToTerminate")
		if err := awsAwsjson11_serializeDocumentEC2InstanceIdsList(v.InstancesToTerminate, ok); err != nil {
			return err
		}
	}

	if v.InstanceTerminationTimeout != nil {
		ok := object.Key("InstanceTerminationTimeout")
		ok.Integer(*v.InstanceTerminationTimeout)
	}

	return nil
}

func awsAwsjson11_serializeDocumentInstanceStateList(v []types.InstanceState, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsAwsjson11_serializeDocumentInstanceTypeConfig(v *types.InstanceTypeConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BidPrice != nil {
		ok := object.Key("BidPrice")
		ok.String(*v.BidPrice)
	}

	if v.BidPriceAsPercentageOfOnDemandPrice != nil {
		ok := object.Key("BidPriceAsPercentageOfOnDemandPrice")
		switch {
		case math.IsNaN(*v.BidPriceAsPercentageOfOnDemandPrice):
			ok.String("NaN")

		case math.IsInf(*v.BidPriceAsPercentageOfOnDemandPrice, 1):
			ok.String("Infinity")

		case math.IsInf(*v.BidPriceAsPercentageOfOnDemandPrice, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.BidPriceAsPercentageOfOnDemandPrice)

		}
	}

	if v.Configurations != nil {
		ok := object.Key("Configurations")
		if err := awsAwsjson11_serializeDocumentConfigurationList(v.Configurations, ok); err != nil {
			return err
		}
	}

	if v.CustomAmiId != nil {
		ok := object.Key("CustomAmiId")
		ok.String(*v.CustomAmiId)
	}

	if v.EbsConfiguration != nil {
		ok := object.Key("EbsConfiguration")
		if err := awsAwsjson11_serializeDocumentEbsConfiguration(v.EbsConfiguration, ok); err != nil {
			return err
		}
	}

	if v.InstanceType != nil {
		ok := object.Key("InstanceType")
		ok.String(*v.InstanceType)
	}

	if v.Priority != nil {
		ok := object.Key("Priority")
		switch {
		case math.IsNaN(*v.Priority):
			ok.String("NaN")

		case math.IsInf(*v.Priority, 1):
			ok.String("Infinity")

		case math.IsInf(*v.Priority, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.Priority)

		}
	}

	if v.WeightedCapacity != nil {
		ok := object.Key("WeightedCapacity")
		ok.Integer(*v.WeightedCapacity)
	}

	return nil
}

func awsAwsjson11_serializeDocumentInstanceTypeConfigList(v []types.InstanceTypeConfig, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentInstanceTypeConfig(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentJobFlowExecutionStateList(v []types.JobFlowExecutionState, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsAwsjson11_serializeDocumentJobFlowInstancesConfig(v *types.JobFlowInstancesConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AdditionalMasterSecurityGroups != nil {
		ok := object.Key("AdditionalMasterSecurityGroups")
		if err := awsAwsjson11_serializeDocumentSecurityGroupsList(v.AdditionalMasterSecurityGroups, ok); err != nil {
			return err
		}
	}

	if v.AdditionalSlaveSecurityGroups != nil {
		ok := object.Key("AdditionalSlaveSecurityGroups")
		if err := awsAwsjson11_serializeDocumentSecurityGroupsList(v.AdditionalSlaveSecurityGroups, ok); err != nil {
			return err
		}
	}

	if v.Ec2KeyName != nil {
		ok := object.Key("Ec2KeyName")
		ok.String(*v.Ec2KeyName)
	}

	if v.Ec2SubnetId != nil {
		ok := object.Key("Ec2SubnetId")
		ok.String(*v.Ec2SubnetId)
	}

	if v.Ec2SubnetIds != nil {
		ok := object.Key("Ec2SubnetIds")
		if err := awsAwsjson11_serializeDocumentXmlStringMaxLen256List(v.Ec2SubnetIds, ok); err != nil {
			return err
		}
	}

	if v.EmrManagedMasterSecurityGroup != nil {
		ok := object.Key("EmrManagedMasterSecurityGroup")
		ok.String(*v.EmrManagedMasterSecurityGroup)
	}

	if v.EmrManagedSlaveSecurityGroup != nil {
		ok := object.Key("EmrManagedSlaveSecurityGroup")
		ok.String(*v.EmrManagedSlaveSecurityGroup)
	}

	if v.HadoopVersion != nil {
		ok := object.Key("HadoopVersion")
		ok.String(*v.HadoopVersion)
	}

	if v.InstanceCount != nil {
		ok := object.Key("InstanceCount")
		ok.Integer(*v.InstanceCount)
	}

	if v.InstanceFleets != nil {
		ok := object.Key("InstanceFleets")
		if err := awsAwsjson11_serializeDocumentInstanceFleetConfigList(v.InstanceFleets, ok); err != nil {
			return err
		}
	}

	if v.InstanceGroups != nil {
		ok := object.Key("InstanceGroups")
		if err := awsAwsjson11_serializeDocumentInstanceGroupConfigList(v.InstanceGroups, ok); err != nil {
			return err
		}
	}

	if v.KeepJobFlowAliveWhenNoSteps != nil {
		ok := object.Key("KeepJobFlowAliveWhenNoSteps")
		ok.Boolean(*v.KeepJobFlowAliveWhenNoSteps)
	}

	if v.MasterInstanceType != nil {
		ok := object.Key("MasterInstanceType")
		ok.String(*v.MasterInstanceType)
	}

	if v.Placement != nil {
		ok := object.Key("Placement")
		if err := awsAwsjson11_serializeDocumentPlacementType(v.Placement, ok); err != nil {
			return err
		}
	}

	if v.ServiceAccessSecurityGroup != nil {
		ok := object.Key("ServiceAccessSecurityGroup")
		ok.String(*v.ServiceAccessSecurityGroup)
	}

	if v.SlaveInstanceType != nil {
		ok := object.Key("SlaveInstanceType")
		ok.String(*v.SlaveInstanceType)
	}

	if v.TerminationProtected != nil {
		ok := object.Key("TerminationProtected")
		ok.Boolean(*v.TerminationProtected)
	}

	if v.UnhealthyNodeReplacement != nil {
		ok := object.Key("UnhealthyNodeReplacement")
		ok.Boolean(*v.UnhealthyNodeReplacement)
	}

	return nil
}

func awsAwsjson11_serializeDocumentKerberosAttributes(v *types.KerberosAttributes, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ADDomainJoinPassword != nil {
		ok := object.Key("ADDomainJoinPassword")
		ok.String(*v.ADDomainJoinPassword)
	}

	if v.ADDomainJoinUser != nil {
		ok := object.Key("ADDomainJoinUser")
		ok.String(*v.ADDomainJoinUser)
	}

	if v.CrossRealmTrustPrincipalPassword != nil {
		ok := object.Key("CrossRealmTrustPrincipalPassword")
		ok.String(*v.CrossRealmTrustPrincipalPassword)
	}

	if v.KdcAdminPassword != nil {
		ok := object.Key("KdcAdminPassword")
		ok.String(*v.KdcAdminPassword)
	}

	if v.Realm != nil {
		ok := object.Key("Realm")
		ok.String(*v.Realm)
	}

	return nil
}

func awsAwsjson11_serializeDocumentKeyValue(v *types.KeyValue, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Key != nil {
		ok := object.Key("Key")
		ok.String(*v.Key)
	}

	if v.Value != nil {
		ok := object.Key("Value")
		ok.String(*v.Value)
	}

	return nil
}

func awsAwsjson11_serializeDocumentKeyValueList(v []types.KeyValue, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentKeyValue(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentManagedScalingPolicy(v *types.ManagedScalingPolicy, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ComputeLimits != nil {
		ok := object.Key("ComputeLimits")
		if err := awsAwsjson11_serializeDocumentComputeLimits(v.ComputeLimits, ok); err != nil {
			return err
		}
	}

	if len(v.ScalingStrategy) > 0 {
		ok := object.Key("ScalingStrategy")
		ok.String(string(v.ScalingStrategy))
	}

	if v.UtilizationPerformanceIndex != nil {
		ok := object.Key("UtilizationPerformanceIndex")
		ok.Integer(*v.UtilizationPerformanceIndex)
	}

	return nil
}

func awsAwsjson11_serializeDocumentMetricDimension(v *types.MetricDimension, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Key != nil {
		ok := object.Key("Key")
		ok.String(*v.Key)
	}

	if v.Value != nil {
		ok := object.Key("Value")
		ok.String(*v.Value)
	}

	return nil
}

func awsAwsjson11_serializeDocumentMetricDimensionList(v []types.MetricDimension, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentMetricDimension(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentNewSupportedProductsList(v []types.SupportedProductConfig, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentSupportedProductConfig(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentNotebookS3LocationFromInput(v *types.NotebookS3LocationFromInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Bucket != nil {
		ok := object.Key("Bucket")
		ok.String(*v.Bucket)
	}

	if v.Key != nil {
		ok := object.Key("Key")
		ok.String(*v.Key)
	}

	return nil
}

func awsAwsjson11_serializeDocumentOnDemandCapacityReservationOptions(v *types.OnDemandCapacityReservationOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.CapacityReservationPreference) > 0 {
		ok := object.Key("CapacityReservationPreference")
		ok.String(string(v.CapacityReservationPreference))
	}

	if v.CapacityReservationResourceGroupArn != nil {
		ok := object.Key("CapacityReservationResourceGroupArn")
		ok.String(*v.CapacityReservationResourceGroupArn)
	}

	if len(v.UsageStrategy) > 0 {
		ok := object.Key("UsageStrategy")
		ok.String(string(v.UsageStrategy))
	}

	return nil
}

func awsAwsjson11_serializeDocumentOnDemandProvisioningSpecification(v *types.OnDemandProvisioningSpecification, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.AllocationStrategy) > 0 {
		ok := object.Key("AllocationStrategy")
		ok.String(string(v.AllocationStrategy))
	}

	if v.CapacityReservationOptions != nil {
		ok := object.Key("CapacityReservationOptions")
		if err := awsAwsjson11_serializeDocumentOnDemandCapacityReservationOptions(v.CapacityReservationOptions, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentOnDemandResizingSpecification(v *types.OnDemandResizingSpecification, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.AllocationStrategy) > 0 {
		ok := object.Key("AllocationStrategy")
		ok.String(string(v.AllocationStrategy))
	}

	if v.CapacityReservationOptions != nil {
		ok := object.Key("CapacityReservationOptions")
		if err := awsAwsjson11_serializeDocumentOnDemandCapacityReservationOptions(v.CapacityReservationOptions, ok); err != nil {
			return err
		}
	}

	if v.TimeoutDurationMinutes != nil {
		ok := object.Key("TimeoutDurationMinutes")
		ok.Integer(*v.TimeoutDurationMinutes)
	}

	return nil
}

func awsAwsjson11_serializeDocumentOutputNotebookS3LocationFromInput(v *types.OutputNotebookS3LocationFromInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Bucket != nil {
		ok := object.Key("Bucket")
		ok.String(*v.Bucket)
	}

	if v.Key != nil {
		ok := object.Key("Key")
		ok.String(*v.Key)
	}

	return nil
}

func awsAwsjson11_serializeDocumentPlacementGroupConfig(v *types.PlacementGroupConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.InstanceRole) > 0 {
		ok := object.Key("InstanceRole")
		ok.String(string(v.InstanceRole))
	}

	if len(v.PlacementStrategy) > 0 {
		ok := object.Key("PlacementStrategy")
		ok.String(string(v.PlacementStrategy))
	}

	return nil
}

func awsAwsjson11_serializeDocumentPlacementGroupConfigList(v []types.PlacementGroupConfig, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentPlacementGroupConfig(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentPlacementType(v *types.PlacementType, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AvailabilityZone != nil {
		ok := object.Key("AvailabilityZone")
		ok.String(*v.AvailabilityZone)
	}

	if v.AvailabilityZones != nil {
		ok := object.Key("AvailabilityZones")
		if err := awsAwsjson11_serializeDocumentXmlStringMaxLen256List(v.AvailabilityZones, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentPortRange(v *types.PortRange, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxRange != nil {
		ok := object.Key("MaxRange")
		ok.Integer(*v.MaxRange)
	}

	if v.MinRange != nil {
		ok := object.Key("MinRange")
		ok.Integer(*v.MinRange)
	}

	return nil
}

func awsAwsjson11_serializeDocumentPortRanges(v []types.PortRange, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentPortRange(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentReleaseLabelFilter(v *types.ReleaseLabelFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Application != nil {
		ok := object.Key("Application")
		ok.String(*v.Application)
	}

	if v.Prefix != nil {
		ok := object.Key("Prefix")
		ok.String(*v.Prefix)
	}

	return nil
}

func awsAwsjson11_serializeDocumentScalingAction(v *types.ScalingAction, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Market) > 0 {
		ok := object.Key("Market")
		ok.String(string(v.Market))
	}

	if v.SimpleScalingPolicyConfiguration != nil {
		ok := object.Key("SimpleScalingPolicyConfiguration")
		if err := awsAwsjson11_serializeDocumentSimpleScalingPolicyConfiguration(v.SimpleScalingPolicyConfiguration, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentScalingConstraints(v *types.ScalingConstraints, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxCapacity != nil {
		ok := object.Key("MaxCapacity")
		ok.Integer(*v.MaxCapacity)
	}

	if v.MinCapacity != nil {
		ok := object.Key("MinCapacity")
		ok.Integer(*v.MinCapacity)
	}

	return nil
}

func awsAwsjson11_serializeDocumentScalingRule(v *types.ScalingRule, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Action != nil {
		ok := object.Key("Action")
		if err := awsAwsjson11_serializeDocumentScalingAction(v.Action, ok); err != nil {
			return err
		}
	}

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.Trigger != nil {
		ok := object.Key("Trigger")
		if err := awsAwsjson11_serializeDocumentScalingTrigger(v.Trigger, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentScalingRuleList(v []types.ScalingRule, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentScalingRule(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentScalingTrigger(v *types.ScalingTrigger, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CloudWatchAlarmDefinition != nil {
		ok := object.Key("CloudWatchAlarmDefinition")
		if err := awsAwsjson11_serializeDocumentCloudWatchAlarmDefinition(v.CloudWatchAlarmDefinition, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentScriptBootstrapActionConfig(v *types.ScriptBootstrapActionConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Args != nil {
		ok := object.Key("Args")
		if err := awsAwsjson11_serializeDocumentXmlStringList(v.Args, ok); err != nil {
			return err
		}
	}

	if v.Path != nil {
		ok := object.Key("Path")
		ok.String(*v.Path)
	}

	return nil
}

func awsAwsjson11_serializeDocumentSecurityGroupsList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentShrinkPolicy(v *types.ShrinkPolicy, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DecommissionTimeout != nil {
		ok := object.Key("DecommissionTimeout")
		ok.Integer(*v.DecommissionTimeout)
	}

	if v.InstanceResizePolicy != nil {
		ok := object.Key("InstanceResizePolicy")
		if err := awsAwsjson11_serializeDocumentInstanceResizePolicy(v.InstanceResizePolicy, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentSimpleScalingPolicyConfiguration(v *types.SimpleScalingPolicyConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.AdjustmentType) > 0 {
		ok := object.Key("AdjustmentType")
		ok.String(string(v.AdjustmentType))
	}

	if v.CoolDown != nil {
		ok := object.Key("CoolDown")
		ok.Integer(*v.CoolDown)
	}

	if v.ScalingAdjustment != nil {
		ok := object.Key("ScalingAdjustment")
		ok.Integer(*v.ScalingAdjustment)
	}

	return nil
}

func awsAwsjson11_serializeDocumentSpotProvisioningSpecification(v *types.SpotProvisioningSpecification, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.AllocationStrategy) > 0 {
		ok := object.Key("AllocationStrategy")
		ok.String(string(v.AllocationStrategy))
	}

	if v.BlockDurationMinutes != nil {
		ok := object.Key("BlockDurationMinutes")
		ok.Integer(*v.BlockDurationMinutes)
	}

	if len(v.TimeoutAction) > 0 {
		ok := object.Key("TimeoutAction")
		ok.String(string(v.TimeoutAction))
	}

	if v.TimeoutDurationMinutes != nil {
		ok := object.Key("TimeoutDurationMinutes")
		ok.Integer(*v.TimeoutDurationMinutes)
	}

	return nil
}

func awsAwsjson11_serializeDocumentSpotResizingSpecification(v *types.SpotResizingSpecification, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.AllocationStrategy) > 0 {
		ok := object.Key("AllocationStrategy")
		ok.String(string(v.AllocationStrategy))
	}

	if v.TimeoutDurationMinutes != nil {
		ok := object.Key("TimeoutDurationMinutes")
		ok.Integer(*v.TimeoutDurationMinutes)
	}

	return nil
}

func awsAwsjson11_serializeDocumentStepConfig(v *types.StepConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.ActionOnFailure) > 0 {
		ok := object.Key("ActionOnFailure")
		ok.String(string(v.ActionOnFailure))
	}

	if v.HadoopJarStep != nil {
		ok := object.Key("HadoopJarStep")
		if err := awsAwsjson11_serializeDocumentHadoopJarStepConfig(v.HadoopJarStep, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	return nil
}

func awsAwsjson11_serializeDocumentStepConfigList(v []types.StepConfig, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentStepConfig(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentStepIdsList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentStepStateList(v []types.StepState, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsAwsjson11_serializeDocumentStringList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentStringMap(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsAwsjson11_serializeDocumentSubnetIdList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentSupportedProductConfig(v *types.SupportedProductConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Args != nil {
		ok := object.Key("Args")
		if err := awsAwsjson11_serializeDocumentXmlStringList(v.Args, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	return nil
}

func awsAwsjson11_serializeDocumentSupportedProductsList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentTag(v *types.Tag, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Key != nil {
		ok := object.Key("Key")
		ok.String(*v.Key)
	}

	if v.Value != nil {
		ok := object.Key("Value")
		ok.String(*v.Value)
	}

	return nil
}

func awsAwsjson11_serializeDocumentTagList(v []types.Tag, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentTag(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentVolumeSpecification(v *types.VolumeSpecification, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Iops != nil {
		ok := object.Key("Iops")
		ok.Integer(*v.Iops)
	}

	if v.SizeInGB != nil {
		ok := object.Key("SizeInGB")
		ok.Integer(*v.SizeInGB)
	}

	if v.Throughput != nil {
		ok := object.Key("Throughput")
		ok.Integer(*v.Throughput)
	}

	if v.VolumeType != nil {
		ok := object.Key("VolumeType")
		ok.String(*v.VolumeType)
	}

	return nil
}

func awsAwsjson11_serializeDocumentXmlStringList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentXmlStringMaxLen256List(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeOpDocumentAddInstanceFleetInput(v *AddInstanceFleetInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClusterId != nil {
		ok := object.Key("ClusterId")
		ok.String(*v.ClusterId)
	}

	if v.InstanceFleet != nil {
		ok := object.Key("InstanceFleet")
		if err := awsAwsjson11_serializeDocumentInstanceFleetConfig(v.InstanceFleet, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentAddInstanceGroupsInput(v *AddInstanceGroupsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.InstanceGroups != nil {
		ok := object.Key("InstanceGroups")
		if err := awsAwsjson11_serializeDocumentInstanceGroupConfigList(v.InstanceGroups, ok); err != nil {
			return err
		}
	}

	if v.JobFlowId != nil {
		ok := object.Key("JobFlowId")
		ok.String(*v.JobFlowId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentAddJobFlowStepsInput(v *AddJobFlowStepsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ExecutionRoleArn != nil {
		ok := object.Key("ExecutionRoleArn")
		ok.String(*v.ExecutionRoleArn)
	}

	if v.JobFlowId != nil {
		ok := object.Key("JobFlowId")
		ok.String(*v.JobFlowId)
	}

	if v.Steps != nil {
		ok := object.Key("Steps")
		if err := awsAwsjson11_serializeDocumentStepConfigList(v.Steps, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentAddTagsInput(v *AddTagsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ResourceId != nil {
		ok := object.Key("ResourceId")
		ok.String(*v.ResourceId)
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsAwsjson11_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentCancelStepsInput(v *CancelStepsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClusterId != nil {
		ok := object.Key("ClusterId")
		ok.String(*v.ClusterId)
	}

	if len(v.StepCancellationOption) > 0 {
		ok := object.Key("StepCancellationOption")
		ok.String(string(v.StepCancellationOption))
	}

	if v.StepIds != nil {
		ok := object.Key("StepIds")
		if err := awsAwsjson11_serializeDocumentStepIdsList(v.StepIds, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentCreatePersistentAppUIInput(v *CreatePersistentAppUIInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EMRContainersConfig != nil {
		ok := object.Key("EMRContainersConfig")
		if err := awsAwsjson11_serializeDocumentEMRContainersConfig(v.EMRContainersConfig, ok); err != nil {
			return err
		}
	}

	if len(v.ProfilerType) > 0 {
		ok := object.Key("ProfilerType")
		ok.String(string(v.ProfilerType))
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsAwsjson11_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	if v.TargetResourceArn != nil {
		ok := object.Key("TargetResourceArn")
		ok.String(*v.TargetResourceArn)
	}

	if v.XReferer != nil {
		ok := object.Key("XReferer")
		ok.String(*v.XReferer)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentCreateSecurityConfigurationInput(v *CreateSecurityConfigurationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.SecurityConfiguration != nil {
		ok := object.Key("SecurityConfiguration")
		ok.String(*v.SecurityConfiguration)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentCreateStudioInput(v *CreateStudioInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.AuthMode) > 0 {
		ok := object.Key("AuthMode")
		ok.String(string(v.AuthMode))
	}

	if v.DefaultS3Location != nil {
		ok := object.Key("DefaultS3Location")
		ok.String(*v.DefaultS3Location)
	}

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if v.EncryptionKeyArn != nil {
		ok := object.Key("EncryptionKeyArn")
		ok.String(*v.EncryptionKeyArn)
	}

	if v.EngineSecurityGroupId != nil {
		ok := object.Key("EngineSecurityGroupId")
		ok.String(*v.EngineSecurityGroupId)
	}

	if v.IdcInstanceArn != nil {
		ok := object.Key("IdcInstanceArn")
		ok.String(*v.IdcInstanceArn)
	}

	if len(v.IdcUserAssignment) > 0 {
		ok := object.Key("IdcUserAssignment")
		ok.String(string(v.IdcUserAssignment))
	}

	if v.IdpAuthUrl != nil {
		ok := object.Key("IdpAuthUrl")
		ok.String(*v.IdpAuthUrl)
	}

	if v.IdpRelayStateParameterName != nil {
		ok := object.Key("IdpRelayStateParameterName")
		ok.String(*v.IdpRelayStateParameterName)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.ServiceRole != nil {
		ok := object.Key("ServiceRole")
		ok.String(*v.ServiceRole)
	}

	if v.SubnetIds != nil {
		ok := object.Key("SubnetIds")
		if err := awsAwsjson11_serializeDocumentSubnetIdList(v.SubnetIds, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsAwsjson11_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	if v.TrustedIdentityPropagationEnabled != nil {
		ok := object.Key("TrustedIdentityPropagationEnabled")
		ok.Boolean(*v.TrustedIdentityPropagationEnabled)
	}

	if v.UserRole != nil {
		ok := object.Key("UserRole")
		ok.String(*v.UserRole)
	}

	if v.VpcId != nil {
		ok := object.Key("VpcId")
		ok.String(*v.VpcId)
	}

	if v.WorkspaceSecurityGroupId != nil {
		ok := object.Key("WorkspaceSecurityGroupId")
		ok.String(*v.WorkspaceSecurityGroupId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentCreateStudioSessionMappingInput(v *CreateStudioSessionMappingInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.IdentityId != nil {
		ok := object.Key("IdentityId")
		ok.String(*v.IdentityId)
	}

	if v.IdentityName != nil {
		ok := object.Key("IdentityName")
		ok.String(*v.IdentityName)
	}

	if len(v.IdentityType) > 0 {
		ok := object.Key("IdentityType")
		ok.String(string(v.IdentityType))
	}

	if v.SessionPolicyArn != nil {
		ok := object.Key("SessionPolicyArn")
		ok.String(*v.SessionPolicyArn)
	}

	if v.StudioId != nil {
		ok := object.Key("StudioId")
		ok.String(*v.StudioId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDeleteSecurityConfigurationInput(v *DeleteSecurityConfigurationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDeleteStudioInput(v *DeleteStudioInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.StudioId != nil {
		ok := object.Key("StudioId")
		ok.String(*v.StudioId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDeleteStudioSessionMappingInput(v *DeleteStudioSessionMappingInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.IdentityId != nil {
		ok := object.Key("IdentityId")
		ok.String(*v.IdentityId)
	}

	if v.IdentityName != nil {
		ok := object.Key("IdentityName")
		ok.String(*v.IdentityName)
	}

	if len(v.IdentityType) > 0 {
		ok := object.Key("IdentityType")
		ok.String(string(v.IdentityType))
	}

	if v.StudioId != nil {
		ok := object.Key("StudioId")
		ok.String(*v.StudioId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDescribeClusterInput(v *DescribeClusterInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClusterId != nil {
		ok := object.Key("ClusterId")
		ok.String(*v.ClusterId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDescribeJobFlowsInput(v *DescribeJobFlowsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CreatedAfter != nil {
		ok := object.Key("CreatedAfter")
		ok.Double(smithytime.FormatEpochSeconds(*v.CreatedAfter))
	}

	if v.CreatedBefore != nil {
		ok := object.Key("CreatedBefore")
		ok.Double(smithytime.FormatEpochSeconds(*v.CreatedBefore))
	}

	if v.JobFlowIds != nil {
		ok := object.Key("JobFlowIds")
		if err := awsAwsjson11_serializeDocumentXmlStringList(v.JobFlowIds, ok); err != nil {
			return err
		}
	}

	if v.JobFlowStates != nil {
		ok := object.Key("JobFlowStates")
		if err := awsAwsjson11_serializeDocumentJobFlowExecutionStateList(v.JobFlowStates, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDescribeNotebookExecutionInput(v *DescribeNotebookExecutionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.NotebookExecutionId != nil {
		ok := object.Key("NotebookExecutionId")
		ok.String(*v.NotebookExecutionId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDescribePersistentAppUIInput(v *DescribePersistentAppUIInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.PersistentAppUIId != nil {
		ok := object.Key("PersistentAppUIId")
		ok.String(*v.PersistentAppUIId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDescribeReleaseLabelInput(v *DescribeReleaseLabelInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	if v.ReleaseLabel != nil {
		ok := object.Key("ReleaseLabel")
		ok.String(*v.ReleaseLabel)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDescribeSecurityConfigurationInput(v *DescribeSecurityConfigurationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDescribeStepInput(v *DescribeStepInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClusterId != nil {
		ok := object.Key("ClusterId")
		ok.String(*v.ClusterId)
	}

	if v.StepId != nil {
		ok := object.Key("StepId")
		ok.String(*v.StepId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDescribeStudioInput(v *DescribeStudioInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.StudioId != nil {
		ok := object.Key("StudioId")
		ok.String(*v.StudioId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetAutoTerminationPolicyInput(v *GetAutoTerminationPolicyInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClusterId != nil {
		ok := object.Key("ClusterId")
		ok.String(*v.ClusterId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetBlockPublicAccessConfigurationInput(v *GetBlockPublicAccessConfigurationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	return nil
}

func awsAwsjson11_serializeOpDocumentGetClusterSessionCredentialsInput(v *GetClusterSessionCredentialsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClusterId != nil {
		ok := object.Key("ClusterId")
		ok.String(*v.ClusterId)
	}

	if v.ExecutionRoleArn != nil {
		ok := object.Key("ExecutionRoleArn")
		ok.String(*v.ExecutionRoleArn)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetManagedScalingPolicyInput(v *GetManagedScalingPolicyInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClusterId != nil {
		ok := object.Key("ClusterId")
		ok.String(*v.ClusterId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetOnClusterAppUIPresignedURLInput(v *GetOnClusterAppUIPresignedURLInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ApplicationId != nil {
		ok := object.Key("ApplicationId")
		ok.String(*v.ApplicationId)
	}

	if v.ClusterId != nil {
		ok := object.Key("ClusterId")
		ok.String(*v.ClusterId)
	}

	if v.DryRun != nil {
		ok := object.Key("DryRun")
		ok.Boolean(*v.DryRun)
	}

	if v.ExecutionRoleArn != nil {
		ok := object.Key("ExecutionRoleArn")
		ok.String(*v.ExecutionRoleArn)
	}

	if len(v.OnClusterAppUIType) > 0 {
		ok := object.Key("OnClusterAppUIType")
		ok.String(string(v.OnClusterAppUIType))
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetPersistentAppUIPresignedURLInput(v *GetPersistentAppUIPresignedURLInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ApplicationId != nil {
		ok := object.Key("ApplicationId")
		ok.String(*v.ApplicationId)
	}

	if v.AuthProxyCall != nil {
		ok := object.Key("AuthProxyCall")
		ok.Boolean(*v.AuthProxyCall)
	}

	if v.ExecutionRoleArn != nil {
		ok := object.Key("ExecutionRoleArn")
		ok.String(*v.ExecutionRoleArn)
	}

	if v.PersistentAppUIId != nil {
		ok := object.Key("PersistentAppUIId")
		ok.String(*v.PersistentAppUIId)
	}

	if len(v.PersistentAppUIType) > 0 {
		ok := object.Key("PersistentAppUIType")
		ok.String(string(v.PersistentAppUIType))
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetStudioSessionMappingInput(v *GetStudioSessionMappingInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.IdentityId != nil {
		ok := object.Key("IdentityId")
		ok.String(*v.IdentityId)
	}

	if v.IdentityName != nil {
		ok := object.Key("IdentityName")
		ok.String(*v.IdentityName)
	}

	if len(v.IdentityType) > 0 {
		ok := object.Key("IdentityType")
		ok.String(string(v.IdentityType))
	}

	if v.StudioId != nil {
		ok := object.Key("StudioId")
		ok.String(*v.StudioId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentListBootstrapActionsInput(v *ListBootstrapActionsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClusterId != nil {
		ok := object.Key("ClusterId")
		ok.String(*v.ClusterId)
	}

	if v.Marker != nil {
		ok := object.Key("Marker")
		ok.String(*v.Marker)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentListClustersInput(v *ListClustersInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClusterStates != nil {
		ok := object.Key("ClusterStates")
		if err := awsAwsjson11_serializeDocumentClusterStateList(v.ClusterStates, ok); err != nil {
			return err
		}
	}

	if v.CreatedAfter != nil {
		ok := object.Key("CreatedAfter")
		ok.Double(smithytime.FormatEpochSeconds(*v.CreatedAfter))
	}

	if v.CreatedBefore != nil {
		ok := object.Key("CreatedBefore")
		ok.Double(smithytime.FormatEpochSeconds(*v.CreatedBefore))
	}

	if v.Marker != nil {
		ok := object.Key("Marker")
		ok.String(*v.Marker)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentListInstanceFleetsInput(v *ListInstanceFleetsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClusterId != nil {
		ok := object.Key("ClusterId")
		ok.String(*v.ClusterId)
	}

	if v.Marker != nil {
		ok := object.Key("Marker")
		ok.String(*v.Marker)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentListInstanceGroupsInput(v *ListInstanceGroupsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClusterId != nil {
		ok := object.Key("ClusterId")
		ok.String(*v.ClusterId)
	}

	if v.Marker != nil {
		ok := object.Key("Marker")
		ok.String(*v.Marker)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentListInstancesInput(v *ListInstancesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClusterId != nil {
		ok := object.Key("ClusterId")
		ok.String(*v.ClusterId)
	}

	if v.InstanceFleetId != nil {
		ok := object.Key("InstanceFleetId")
		ok.String(*v.InstanceFleetId)
	}

	if len(v.InstanceFleetType) > 0 {
		ok := object.Key("InstanceFleetType")
		ok.String(string(v.InstanceFleetType))
	}

	if v.InstanceGroupId != nil {
		ok := object.Key("InstanceGroupId")
		ok.String(*v.InstanceGroupId)
	}

	if v.InstanceGroupTypes != nil {
		ok := object.Key("InstanceGroupTypes")
		if err := awsAwsjson11_serializeDocumentInstanceGroupTypeList(v.InstanceGroupTypes, ok); err != nil {
			return err
		}
	}

	if v.InstanceStates != nil {
		ok := object.Key("InstanceStates")
		if err := awsAwsjson11_serializeDocumentInstanceStateList(v.InstanceStates, ok); err != nil {
			return err
		}
	}

	if v.Marker != nil {
		ok := object.Key("Marker")
		ok.String(*v.Marker)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentListNotebookExecutionsInput(v *ListNotebookExecutionsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EditorId != nil {
		ok := object.Key("EditorId")
		ok.String(*v.EditorId)
	}

	if v.ExecutionEngineId != nil {
		ok := object.Key("ExecutionEngineId")
		ok.String(*v.ExecutionEngineId)
	}

	if v.From != nil {
		ok := object.Key("From")
		ok.Double(smithytime.FormatEpochSeconds(*v.From))
	}

	if v.Marker != nil {
		ok := object.Key("Marker")
		ok.String(*v.Marker)
	}

	if len(v.Status) > 0 {
		ok := object.Key("Status")
		ok.String(string(v.Status))
	}

	if v.To != nil {
		ok := object.Key("To")
		ok.Double(smithytime.FormatEpochSeconds(*v.To))
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentListReleaseLabelsInput(v *ListReleaseLabelsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Filters != nil {
		ok := object.Key("Filters")
		if err := awsAwsjson11_serializeDocumentReleaseLabelFilter(v.Filters, ok); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentListSecurityConfigurationsInput(v *ListSecurityConfigurationsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Marker != nil {
		ok := object.Key("Marker")
		ok.String(*v.Marker)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentListStepsInput(v *ListStepsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClusterId != nil {
		ok := object.Key("ClusterId")
		ok.String(*v.ClusterId)
	}

	if v.Marker != nil {
		ok := object.Key("Marker")
		ok.String(*v.Marker)
	}

	if v.StepIds != nil {
		ok := object.Key("StepIds")
		if err := awsAwsjson11_serializeDocumentXmlStringList(v.StepIds, ok); err != nil {
			return err
		}
	}

	if v.StepStates != nil {
		ok := object.Key("StepStates")
		if err := awsAwsjson11_serializeDocumentStepStateList(v.StepStates, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentListStudioSessionMappingsInput(v *ListStudioSessionMappingsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.IdentityType) > 0 {
		ok := object.Key("IdentityType")
		ok.String(string(v.IdentityType))
	}

	if v.Marker != nil {
		ok := object.Key("Marker")
		ok.String(*v.Marker)
	}

	if v.StudioId != nil {
		ok := object.Key("StudioId")
		ok.String(*v.StudioId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentListStudiosInput(v *ListStudiosInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Marker != nil {
		ok := object.Key("Marker")
		ok.String(*v.Marker)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentListSupportedInstanceTypesInput(v *ListSupportedInstanceTypesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Marker != nil {
		ok := object.Key("Marker")
		ok.String(*v.Marker)
	}

	if v.ReleaseLabel != nil {
		ok := object.Key("ReleaseLabel")
		ok.String(*v.ReleaseLabel)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentModifyClusterInput(v *ModifyClusterInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClusterId != nil {
		ok := object.Key("ClusterId")
		ok.String(*v.ClusterId)
	}

	if v.StepConcurrencyLevel != nil {
		ok := object.Key("StepConcurrencyLevel")
		ok.Integer(*v.StepConcurrencyLevel)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentModifyInstanceFleetInput(v *ModifyInstanceFleetInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClusterId != nil {
		ok := object.Key("ClusterId")
		ok.String(*v.ClusterId)
	}

	if v.InstanceFleet != nil {
		ok := object.Key("InstanceFleet")
		if err := awsAwsjson11_serializeDocumentInstanceFleetModifyConfig(v.InstanceFleet, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentModifyInstanceGroupsInput(v *ModifyInstanceGroupsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClusterId != nil {
		ok := object.Key("ClusterId")
		ok.String(*v.ClusterId)
	}

	if v.InstanceGroups != nil {
		ok := object.Key("InstanceGroups")
		if err := awsAwsjson11_serializeDocumentInstanceGroupModifyConfigList(v.InstanceGroups, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentPutAutoScalingPolicyInput(v *PutAutoScalingPolicyInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AutoScalingPolicy != nil {
		ok := object.Key("AutoScalingPolicy")
		if err := awsAwsjson11_serializeDocumentAutoScalingPolicy(v.AutoScalingPolicy, ok); err != nil {
			return err
		}
	}

	if v.ClusterId != nil {
		ok := object.Key("ClusterId")
		ok.String(*v.ClusterId)
	}

	if v.InstanceGroupId != nil {
		ok := object.Key("InstanceGroupId")
		ok.String(*v.InstanceGroupId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentPutAutoTerminationPolicyInput(v *PutAutoTerminationPolicyInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AutoTerminationPolicy != nil {
		ok := object.Key("AutoTerminationPolicy")
		if err := awsAwsjson11_serializeDocumentAutoTerminationPolicy(v.AutoTerminationPolicy, ok); err != nil {
			return err
		}
	}

	if v.ClusterId != nil {
		ok := object.Key("ClusterId")
		ok.String(*v.ClusterId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentPutBlockPublicAccessConfigurationInput(v *PutBlockPublicAccessConfigurationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BlockPublicAccessConfiguration != nil {
		ok := object.Key("BlockPublicAccessConfiguration")
		if err := awsAwsjson11_serializeDocumentBlockPublicAccessConfiguration(v.BlockPublicAccessConfiguration, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentPutManagedScalingPolicyInput(v *PutManagedScalingPolicyInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClusterId != nil {
		ok := object.Key("ClusterId")
		ok.String(*v.ClusterId)
	}

	if v.ManagedScalingPolicy != nil {
		ok := object.Key("ManagedScalingPolicy")
		if err := awsAwsjson11_serializeDocumentManagedScalingPolicy(v.ManagedScalingPolicy, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentRemoveAutoScalingPolicyInput(v *RemoveAutoScalingPolicyInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClusterId != nil {
		ok := object.Key("ClusterId")
		ok.String(*v.ClusterId)
	}

	if v.InstanceGroupId != nil {
		ok := object.Key("InstanceGroupId")
		ok.String(*v.InstanceGroupId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentRemoveAutoTerminationPolicyInput(v *RemoveAutoTerminationPolicyInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClusterId != nil {
		ok := object.Key("ClusterId")
		ok.String(*v.ClusterId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentRemoveManagedScalingPolicyInput(v *RemoveManagedScalingPolicyInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClusterId != nil {
		ok := object.Key("ClusterId")
		ok.String(*v.ClusterId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentRemoveTagsInput(v *RemoveTagsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ResourceId != nil {
		ok := object.Key("ResourceId")
		ok.String(*v.ResourceId)
	}

	if v.TagKeys != nil {
		ok := object.Key("TagKeys")
		if err := awsAwsjson11_serializeDocumentStringList(v.TagKeys, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentRunJobFlowInput(v *RunJobFlowInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AdditionalInfo != nil {
		ok := object.Key("AdditionalInfo")
		ok.String(*v.AdditionalInfo)
	}

	if v.AmiVersion != nil {
		ok := object.Key("AmiVersion")
		ok.String(*v.AmiVersion)
	}

	if v.Applications != nil {
		ok := object.Key("Applications")
		if err := awsAwsjson11_serializeDocumentApplicationList(v.Applications, ok); err != nil {
			return err
		}
	}

	if v.AutoScalingRole != nil {
		ok := object.Key("AutoScalingRole")
		ok.String(*v.AutoScalingRole)
	}

	if v.AutoTerminationPolicy != nil {
		ok := object.Key("AutoTerminationPolicy")
		if err := awsAwsjson11_serializeDocumentAutoTerminationPolicy(v.AutoTerminationPolicy, ok); err != nil {
			return err
		}
	}

	if v.BootstrapActions != nil {
		ok := object.Key("BootstrapActions")
		if err := awsAwsjson11_serializeDocumentBootstrapActionConfigList(v.BootstrapActions, ok); err != nil {
			return err
		}
	}

	if v.Configurations != nil {
		ok := object.Key("Configurations")
		if err := awsAwsjson11_serializeDocumentConfigurationList(v.Configurations, ok); err != nil {
			return err
		}
	}

	if v.CustomAmiId != nil {
		ok := object.Key("CustomAmiId")
		ok.String(*v.CustomAmiId)
	}

	if v.EbsRootVolumeIops != nil {
		ok := object.Key("EbsRootVolumeIops")
		ok.Integer(*v.EbsRootVolumeIops)
	}

	if v.EbsRootVolumeSize != nil {
		ok := object.Key("EbsRootVolumeSize")
		ok.Integer(*v.EbsRootVolumeSize)
	}

	if v.EbsRootVolumeThroughput != nil {
		ok := object.Key("EbsRootVolumeThroughput")
		ok.Integer(*v.EbsRootVolumeThroughput)
	}

	if v.Instances != nil {
		ok := object.Key("Instances")
		if err := awsAwsjson11_serializeDocumentJobFlowInstancesConfig(v.Instances, ok); err != nil {
			return err
		}
	}

	if v.JobFlowRole != nil {
		ok := object.Key("JobFlowRole")
		ok.String(*v.JobFlowRole)
	}

	if v.KerberosAttributes != nil {
		ok := object.Key("KerberosAttributes")
		if err := awsAwsjson11_serializeDocumentKerberosAttributes(v.KerberosAttributes, ok); err != nil {
			return err
		}
	}

	if v.LogEncryptionKmsKeyId != nil {
		ok := object.Key("LogEncryptionKmsKeyId")
		ok.String(*v.LogEncryptionKmsKeyId)
	}

	if v.LogUri != nil {
		ok := object.Key("LogUri")
		ok.String(*v.LogUri)
	}

	if v.ManagedScalingPolicy != nil {
		ok := object.Key("ManagedScalingPolicy")
		if err := awsAwsjson11_serializeDocumentManagedScalingPolicy(v.ManagedScalingPolicy, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.NewSupportedProducts != nil {
		ok := object.Key("NewSupportedProducts")
		if err := awsAwsjson11_serializeDocumentNewSupportedProductsList(v.NewSupportedProducts, ok); err != nil {
			return err
		}
	}

	if v.OSReleaseLabel != nil {
		ok := object.Key("OSReleaseLabel")
		ok.String(*v.OSReleaseLabel)
	}

	if v.PlacementGroupConfigs != nil {
		ok := object.Key("PlacementGroupConfigs")
		if err := awsAwsjson11_serializeDocumentPlacementGroupConfigList(v.PlacementGroupConfigs, ok); err != nil {
			return err
		}
	}

	if v.ReleaseLabel != nil {
		ok := object.Key("ReleaseLabel")
		ok.String(*v.ReleaseLabel)
	}

	if len(v.RepoUpgradeOnBoot) > 0 {
		ok := object.Key("RepoUpgradeOnBoot")
		ok.String(string(v.RepoUpgradeOnBoot))
	}

	if len(v.ScaleDownBehavior) > 0 {
		ok := object.Key("ScaleDownBehavior")
		ok.String(string(v.ScaleDownBehavior))
	}

	if v.SecurityConfiguration != nil {
		ok := object.Key("SecurityConfiguration")
		ok.String(*v.SecurityConfiguration)
	}

	if v.ServiceRole != nil {
		ok := object.Key("ServiceRole")
		ok.String(*v.ServiceRole)
	}

	if v.StepConcurrencyLevel != nil {
		ok := object.Key("StepConcurrencyLevel")
		ok.Integer(*v.StepConcurrencyLevel)
	}

	if v.Steps != nil {
		ok := object.Key("Steps")
		if err := awsAwsjson11_serializeDocumentStepConfigList(v.Steps, ok); err != nil {
			return err
		}
	}

	if v.SupportedProducts != nil {
		ok := object.Key("SupportedProducts")
		if err := awsAwsjson11_serializeDocumentSupportedProductsList(v.SupportedProducts, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsAwsjson11_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	if v.VisibleToAllUsers != nil {
		ok := object.Key("VisibleToAllUsers")
		ok.Boolean(*v.VisibleToAllUsers)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentSetKeepJobFlowAliveWhenNoStepsInput(v *SetKeepJobFlowAliveWhenNoStepsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.JobFlowIds != nil {
		ok := object.Key("JobFlowIds")
		if err := awsAwsjson11_serializeDocumentXmlStringList(v.JobFlowIds, ok); err != nil {
			return err
		}
	}

	if v.KeepJobFlowAliveWhenNoSteps != nil {
		ok := object.Key("KeepJobFlowAliveWhenNoSteps")
		ok.Boolean(*v.KeepJobFlowAliveWhenNoSteps)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentSetTerminationProtectionInput(v *SetTerminationProtectionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.JobFlowIds != nil {
		ok := object.Key("JobFlowIds")
		if err := awsAwsjson11_serializeDocumentXmlStringList(v.JobFlowIds, ok); err != nil {
			return err
		}
	}

	if v.TerminationProtected != nil {
		ok := object.Key("TerminationProtected")
		ok.Boolean(*v.TerminationProtected)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentSetUnhealthyNodeReplacementInput(v *SetUnhealthyNodeReplacementInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.JobFlowIds != nil {
		ok := object.Key("JobFlowIds")
		if err := awsAwsjson11_serializeDocumentXmlStringList(v.JobFlowIds, ok); err != nil {
			return err
		}
	}

	if v.UnhealthyNodeReplacement != nil {
		ok := object.Key("UnhealthyNodeReplacement")
		ok.Boolean(*v.UnhealthyNodeReplacement)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentSetVisibleToAllUsersInput(v *SetVisibleToAllUsersInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.JobFlowIds != nil {
		ok := object.Key("JobFlowIds")
		if err := awsAwsjson11_serializeDocumentXmlStringList(v.JobFlowIds, ok); err != nil {
			return err
		}
	}

	if v.VisibleToAllUsers != nil {
		ok := object.Key("VisibleToAllUsers")
		ok.Boolean(*v.VisibleToAllUsers)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentStartNotebookExecutionInput(v *StartNotebookExecutionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EditorId != nil {
		ok := object.Key("EditorId")
		ok.String(*v.EditorId)
	}

	if v.EnvironmentVariables != nil {
		ok := object.Key("EnvironmentVariables")
		if err := awsAwsjson11_serializeDocumentEnvironmentVariablesMap(v.EnvironmentVariables, ok); err != nil {
			return err
		}
	}

	if v.ExecutionEngine != nil {
		ok := object.Key("ExecutionEngine")
		if err := awsAwsjson11_serializeDocumentExecutionEngineConfig(v.ExecutionEngine, ok); err != nil {
			return err
		}
	}

	if v.NotebookExecutionName != nil {
		ok := object.Key("NotebookExecutionName")
		ok.String(*v.NotebookExecutionName)
	}

	if v.NotebookInstanceSecurityGroupId != nil {
		ok := object.Key("NotebookInstanceSecurityGroupId")
		ok.String(*v.NotebookInstanceSecurityGroupId)
	}

	if v.NotebookParams != nil {
		ok := object.Key("NotebookParams")
		ok.String(*v.NotebookParams)
	}

	if v.NotebookS3Location != nil {
		ok := object.Key("NotebookS3Location")
		if err := awsAwsjson11_serializeDocumentNotebookS3LocationFromInput(v.NotebookS3Location, ok); err != nil {
			return err
		}
	}

	if len(v.OutputNotebookFormat) > 0 {
		ok := object.Key("OutputNotebookFormat")
		ok.String(string(v.OutputNotebookFormat))
	}

	if v.OutputNotebookS3Location != nil {
		ok := object.Key("OutputNotebookS3Location")
		if err := awsAwsjson11_serializeDocumentOutputNotebookS3LocationFromInput(v.OutputNotebookS3Location, ok); err != nil {
			return err
		}
	}

	if v.RelativePath != nil {
		ok := object.Key("RelativePath")
		ok.String(*v.RelativePath)
	}

	if v.ServiceRole != nil {
		ok := object.Key("ServiceRole")
		ok.String(*v.ServiceRole)
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsAwsjson11_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentStopNotebookExecutionInput(v *StopNotebookExecutionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.NotebookExecutionId != nil {
		ok := object.Key("NotebookExecutionId")
		ok.String(*v.NotebookExecutionId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentTerminateJobFlowsInput(v *TerminateJobFlowsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.JobFlowIds != nil {
		ok := object.Key("JobFlowIds")
		if err := awsAwsjson11_serializeDocumentXmlStringList(v.JobFlowIds, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentUpdateStudioInput(v *UpdateStudioInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DefaultS3Location != nil {
		ok := object.Key("DefaultS3Location")
		ok.String(*v.DefaultS3Location)
	}

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if v.EncryptionKeyArn != nil {
		ok := object.Key("EncryptionKeyArn")
		ok.String(*v.EncryptionKeyArn)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.StudioId != nil {
		ok := object.Key("StudioId")
		ok.String(*v.StudioId)
	}

	if v.SubnetIds != nil {
		ok := object.Key("SubnetIds")
		if err := awsAwsjson11_serializeDocumentSubnetIdList(v.SubnetIds, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentUpdateStudioSessionMappingInput(v *UpdateStudioSessionMappingInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.IdentityId != nil {
		ok := object.Key("IdentityId")
		ok.String(*v.IdentityId)
	}

	if v.IdentityName != nil {
		ok := object.Key("IdentityName")
		ok.String(*v.IdentityName)
	}

	if len(v.IdentityType) > 0 {
		ok := object.Key("IdentityType")
		ok.String(string(v.IdentityType))
	}

	if v.SessionPolicyArn != nil {
		ok := object.Key("SessionPolicyArn")
		ok.String(*v.SessionPolicyArn)
	}

	if v.StudioId != nil {
		ok := object.Key("StudioId")
		ok.String(*v.StudioId)
	}

	return nil
}
