// Code generated by smithy-go-codegen DO NOT EDIT.

package eks

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/eks/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists available Kubernetes versions for Amazon EKS clusters.
func (c *Client) DescribeClusterVersions(ctx context.Context, params *DescribeClusterVersionsInput, optFns ...func(*Options)) (*DescribeClusterVersionsOutput, error) {
	if params == nil {
		params = &DescribeClusterVersionsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeClusterVersions", params, optFns, c.addOperationDescribeClusterVersionsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeClusterVersionsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeClusterVersionsInput struct {

	// The type of cluster to filter versions by.
	ClusterType *string

	// List of specific cluster versions to describe.
	ClusterVersions []string

	// Filter to show only default versions.
	DefaultOnly *bool

	// Include all available versions in the response.
	IncludeAll *bool

	// Maximum number of results to return.
	MaxResults *int32

	// Pagination token for the next set of results.
	NextToken *string

	// This field is deprecated. Use versionStatus instead, as that field matches for
	// input and output of this action.
	//
	// Filter versions by their current status.
	//
	// Deprecated: status has been replaced by versionStatus
	Status types.ClusterVersionStatus

	// Filter versions by their current status.
	VersionStatus types.VersionStatus

	noSmithyDocumentSerde
}

type DescribeClusterVersionsOutput struct {

	// List of cluster version information objects.
	ClusterVersions []types.ClusterVersionInformation

	// Pagination token for the next set of results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeClusterVersionsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpDescribeClusterVersions{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpDescribeClusterVersions{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DescribeClusterVersions"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeClusterVersions(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// DescribeClusterVersionsPaginatorOptions is the paginator options for
// DescribeClusterVersions
type DescribeClusterVersionsPaginatorOptions struct {
	// Maximum number of results to return.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// DescribeClusterVersionsPaginator is a paginator for DescribeClusterVersions
type DescribeClusterVersionsPaginator struct {
	options   DescribeClusterVersionsPaginatorOptions
	client    DescribeClusterVersionsAPIClient
	params    *DescribeClusterVersionsInput
	nextToken *string
	firstPage bool
}

// NewDescribeClusterVersionsPaginator returns a new
// DescribeClusterVersionsPaginator
func NewDescribeClusterVersionsPaginator(client DescribeClusterVersionsAPIClient, params *DescribeClusterVersionsInput, optFns ...func(*DescribeClusterVersionsPaginatorOptions)) *DescribeClusterVersionsPaginator {
	if params == nil {
		params = &DescribeClusterVersionsInput{}
	}

	options := DescribeClusterVersionsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &DescribeClusterVersionsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *DescribeClusterVersionsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next DescribeClusterVersions page.
func (p *DescribeClusterVersionsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*DescribeClusterVersionsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.DescribeClusterVersions(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// DescribeClusterVersionsAPIClient is a client that implements the
// DescribeClusterVersions operation.
type DescribeClusterVersionsAPIClient interface {
	DescribeClusterVersions(context.Context, *DescribeClusterVersionsInput, ...func(*Options)) (*DescribeClusterVersionsOutput, error)
}

var _ DescribeClusterVersionsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opDescribeClusterVersions(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DescribeClusterVersions",
	}
}
