// Code generated by smithy-go-codegen DO NOT EDIT.

package datazone

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/datazone/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Updates a rule. In Amazon DataZone, a rule is a formal agreement that enforces
// specific requirements across user workflows (e.g., publishing assets to the
// catalog, requesting subscriptions, creating projects) within the Amazon DataZone
// data portal. These rules help maintain consistency, ensure compliance, and
// uphold governance standards in data management processes. For instance, a
// metadata enforcement rule can specify the required information for creating a
// subscription request or publishing a data asset to the catalog, ensuring
// alignment with organizational standards.
func (c *Client) UpdateRule(ctx context.Context, params *UpdateRuleInput, optFns ...func(*Options)) (*UpdateRuleOutput, error) {
	if params == nil {
		params = &UpdateRuleInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateRule", params, optFns, c.addOperationUpdateRuleMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateRuleOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateRuleInput struct {

	// The ID of the domain in which a rule is to be updated.
	//
	// This member is required.
	DomainIdentifier *string

	// The ID of the rule that is to be updated
	//
	// This member is required.
	Identifier *string

	// The description of the rule.
	Description *string

	// The detail of the rule.
	Detail types.RuleDetail

	// Specifies whether to update this rule in the child domain units.
	IncludeChildDomainUnits *bool

	// The name of the rule.
	Name *string

	// The scrope of the rule.
	Scope *types.RuleScope

	noSmithyDocumentSerde
}

type UpdateRuleOutput struct {

	// The action of the rule.
	//
	// This member is required.
	Action types.RuleAction

	// The timestamp at which the rule was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The user who created the rule.
	//
	// This member is required.
	CreatedBy *string

	// The detail of the rule.
	//
	// This member is required.
	Detail types.RuleDetail

	// The ID of the rule.
	//
	// This member is required.
	Identifier *string

	// The timestamp at which the rule was last updated.
	//
	// This member is required.
	LastUpdatedBy *string

	// The name of the rule.
	//
	// This member is required.
	Name *string

	// The revision of the rule.
	//
	// This member is required.
	Revision *string

	// The type of the rule.
	//
	// This member is required.
	RuleType types.RuleType

	// The scope of the rule.
	//
	// This member is required.
	Scope *types.RuleScope

	// The target of the rule.
	//
	// This member is required.
	Target types.RuleTarget

	// The timestamp at which the rule was last updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	// The description of the rule.
	Description *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateRuleMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpUpdateRule{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpUpdateRule{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateRule"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpUpdateRuleValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateRule(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateRule(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateRule",
	}
}
