// Code generated by smithy-go-codegen DO NOT EDIT.

package connect

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/connect/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Searches UserHierarchyGroups in an Amazon Connect instance, with optional
// filtering.
//
// The UserHierarchyGroup with "LevelId": "0" is the foundation for building
// levels on top of an instance. It is not user-definable, nor is it visible in the
// UI.
func (c *Client) SearchUserHierarchyGroups(ctx context.Context, params *SearchUserHierarchyGroupsInput, optFns ...func(*Options)) (*SearchUserHierarchyGroupsOutput, error) {
	if params == nil {
		params = &SearchUserHierarchyGroupsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "SearchUserHierarchyGroups", params, optFns, c.addOperationSearchUserHierarchyGroupsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*SearchUserHierarchyGroupsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type SearchUserHierarchyGroupsInput struct {

	// The identifier of the Amazon Connect instance. You can find the instanceId in
	// the ARN of the instance.
	//
	// This member is required.
	InstanceId *string

	// The maximum number of results to return per page.
	MaxResults *int32

	// The token for the next set of results. Use the value returned in the previous
	// response in the next request to retrieve the next set of results.
	NextToken *string

	// The search criteria to be used to return UserHierarchyGroups.
	SearchCriteria *types.UserHierarchyGroupSearchCriteria

	// Filters to be applied to search results.
	SearchFilter *types.UserHierarchyGroupSearchFilter

	noSmithyDocumentSerde
}

type SearchUserHierarchyGroupsOutput struct {

	// The total number of userHierarchyGroups which matched your search query.
	ApproximateTotalCount *int64

	// If there are additional results, this is the token for the next set of results.
	NextToken *string

	// Information about the userHierarchyGroups.
	UserHierarchyGroups []types.HierarchyGroup

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationSearchUserHierarchyGroupsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpSearchUserHierarchyGroups{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpSearchUserHierarchyGroups{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "SearchUserHierarchyGroups"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpSearchUserHierarchyGroupsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opSearchUserHierarchyGroups(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// SearchUserHierarchyGroupsPaginatorOptions is the paginator options for
// SearchUserHierarchyGroups
type SearchUserHierarchyGroupsPaginatorOptions struct {
	// The maximum number of results to return per page.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// SearchUserHierarchyGroupsPaginator is a paginator for SearchUserHierarchyGroups
type SearchUserHierarchyGroupsPaginator struct {
	options   SearchUserHierarchyGroupsPaginatorOptions
	client    SearchUserHierarchyGroupsAPIClient
	params    *SearchUserHierarchyGroupsInput
	nextToken *string
	firstPage bool
}

// NewSearchUserHierarchyGroupsPaginator returns a new
// SearchUserHierarchyGroupsPaginator
func NewSearchUserHierarchyGroupsPaginator(client SearchUserHierarchyGroupsAPIClient, params *SearchUserHierarchyGroupsInput, optFns ...func(*SearchUserHierarchyGroupsPaginatorOptions)) *SearchUserHierarchyGroupsPaginator {
	if params == nil {
		params = &SearchUserHierarchyGroupsInput{}
	}

	options := SearchUserHierarchyGroupsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &SearchUserHierarchyGroupsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *SearchUserHierarchyGroupsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next SearchUserHierarchyGroups page.
func (p *SearchUserHierarchyGroupsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*SearchUserHierarchyGroupsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.SearchUserHierarchyGroups(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// SearchUserHierarchyGroupsAPIClient is a client that implements the
// SearchUserHierarchyGroups operation.
type SearchUserHierarchyGroupsAPIClient interface {
	SearchUserHierarchyGroups(context.Context, *SearchUserHierarchyGroupsInput, ...func(*Options)) (*SearchUserHierarchyGroupsOutput, error)
}

var _ SearchUserHierarchyGroupsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opSearchUserHierarchyGroups(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "SearchUserHierarchyGroups",
	}
}
