// Code generated by smithy-go-codegen DO NOT EDIT.

package codedeploy

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/codedeploy/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Changes information about a deployment group.
func (c *Client) UpdateDeploymentGroup(ctx context.Context, params *UpdateDeploymentGroupInput, optFns ...func(*Options)) (*UpdateDeploymentGroupOutput, error) {
	if params == nil {
		params = &UpdateDeploymentGroupInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateDeploymentGroup", params, optFns, c.addOperationUpdateDeploymentGroupMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateDeploymentGroupOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// Represents the input of an UpdateDeploymentGroup operation.
type UpdateDeploymentGroupInput struct {

	// The application name that corresponds to the deployment group to update.
	//
	// This member is required.
	ApplicationName *string

	// The current name of the deployment group.
	//
	// This member is required.
	CurrentDeploymentGroupName *string

	// Information to add or change about Amazon CloudWatch alarms when the deployment
	// group is updated.
	AlarmConfiguration *types.AlarmConfiguration

	// Information for an automatic rollback configuration that is added or changed
	// when a deployment group is updated.
	AutoRollbackConfiguration *types.AutoRollbackConfiguration

	// The replacement list of Auto Scaling groups to be included in the deployment
	// group, if you want to change them.
	//
	//   - To keep the Auto Scaling groups, enter their names or do not specify this
	//   parameter.
	//
	//   - To remove Auto Scaling groups, specify a non-null empty list of Auto
	//   Scaling group names to detach all CodeDeploy-managed Auto Scaling lifecycle
	//   hooks. For examples, see [Amazon EC2 instances in an Amazon EC2 Auto Scaling group fail to launch and receive the error "Heartbeat Timeout"]in the CodeDeploy User Guide.
	//
	// [Amazon EC2 instances in an Amazon EC2 Auto Scaling group fail to launch and receive the error "Heartbeat Timeout"]: https://docs.aws.amazon.com/codedeploy/latest/userguide/troubleshooting-auto-scaling.html#troubleshooting-auto-scaling-heartbeat
	AutoScalingGroups []string

	// Information about blue/green deployment options for a deployment group.
	BlueGreenDeploymentConfiguration *types.BlueGreenDeploymentConfiguration

	// The replacement deployment configuration name to use, if you want to change it.
	DeploymentConfigName *string

	// Information about the type of deployment, either in-place or blue/green, you
	// want to run and whether to route deployment traffic behind a load balancer.
	DeploymentStyle *types.DeploymentStyle

	// The replacement set of Amazon EC2 tags on which to filter, if you want to
	// change them. To keep the existing tags, enter their names. To remove tags, do
	// not enter any tag names.
	Ec2TagFilters []types.EC2TagFilter

	// Information about groups of tags applied to on-premises instances. The
	// deployment group includes only Amazon EC2 instances identified by all the tag
	// groups.
	Ec2TagSet *types.EC2TagSet

	//  The target Amazon ECS services in the deployment group. This applies only to
	// deployment groups that use the Amazon ECS compute platform. A target Amazon ECS
	// service is specified as an Amazon ECS cluster and service name pair using the
	// format : .
	EcsServices []types.ECSService

	// Information about the load balancer used in a deployment.
	LoadBalancerInfo *types.LoadBalancerInfo

	// The new name of the deployment group, if you want to change it.
	NewDeploymentGroupName *string

	// The replacement set of on-premises instance tags on which to filter, if you
	// want to change them. To keep the existing tags, enter their names. To remove
	// tags, do not enter any tag names.
	OnPremisesInstanceTagFilters []types.TagFilter

	// Information about an on-premises instance tag set. The deployment group
	// includes only on-premises instances identified by all the tag groups.
	OnPremisesTagSet *types.OnPremisesTagSet

	// Indicates what happens when new Amazon EC2 instances are launched
	// mid-deployment and do not receive the deployed application revision.
	//
	// If this option is set to UPDATE or is unspecified, CodeDeploy initiates one or
	// more 'auto-update outdated instances' deployments to apply the deployed
	// application revision to the new Amazon EC2 instances.
	//
	// If this option is set to IGNORE , CodeDeploy does not initiate a deployment to
	// update the new Amazon EC2 instances. This may result in instances having
	// different revisions.
	OutdatedInstancesStrategy types.OutdatedInstancesStrategy

	// A replacement ARN for the service role, if you want to change it.
	ServiceRoleArn *string

	// This parameter only applies if you are using CodeDeploy with Amazon EC2 Auto
	// Scaling. For more information, see [Integrating CodeDeploy with Amazon EC2 Auto Scaling]in the CodeDeploy User Guide.
	//
	// Set terminationHookEnabled to true to have CodeDeploy install a termination
	// hook into your Auto Scaling group when you update a deployment group. When this
	// hook is installed, CodeDeploy will perform termination deployments.
	//
	// For information about termination deployments, see [Enabling termination deployments during Auto Scaling scale-in events] in the CodeDeploy User
	// Guide.
	//
	// For more information about Auto Scaling scale-in events, see the [Scale in] topic in the
	// Amazon EC2 Auto Scaling User Guide.
	//
	// [Enabling termination deployments during Auto Scaling scale-in events]: https://docs.aws.amazon.com/codedeploy/latest/userguide/integrations-aws-auto-scaling.html#integrations-aws-auto-scaling-behaviors-hook-enable
	// [Integrating CodeDeploy with Amazon EC2 Auto Scaling]: https://docs.aws.amazon.com/codedeploy/latest/userguide/integrations-aws-auto-scaling.html
	// [Scale in]: https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-lifecycle.html#as-lifecycle-scale-in
	TerminationHookEnabled *bool

	// Information about triggers to change when the deployment group is updated. For
	// examples, see [Edit a Trigger in a CodeDeploy Deployment Group]in the CodeDeploy User Guide.
	//
	// [Edit a Trigger in a CodeDeploy Deployment Group]: https://docs.aws.amazon.com/codedeploy/latest/userguide/how-to-notify-edit.html
	TriggerConfigurations []types.TriggerConfig

	noSmithyDocumentSerde
}

// Represents the output of an UpdateDeploymentGroup operation.
type UpdateDeploymentGroupOutput struct {

	// If the output contains no data, and the corresponding deployment group
	// contained at least one Auto Scaling group, CodeDeploy successfully removed all
	// corresponding Auto Scaling lifecycle event hooks from the Amazon Web Services
	// account. If the output contains data, CodeDeploy could not remove some Auto
	// Scaling lifecycle event hooks from the Amazon Web Services account.
	HooksNotCleanedUp []types.AutoScalingGroup

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateDeploymentGroupMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpUpdateDeploymentGroup{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpUpdateDeploymentGroup{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateDeploymentGroup"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpUpdateDeploymentGroupValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateDeploymentGroup(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateDeploymentGroup(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateDeploymentGroup",
	}
}
