// Code generated by smithy-go-codegen DO NOT EDIT.

package cloudfront

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/cloudfront/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists existing domain associations that conflict with the domain that you
// specify.
//
// You can use this API operation when transferring domains to identify potential
// domain conflicts. Domain conflicts must be resolved first before they can be
// moved.
func (c *Client) ListDomainConflicts(ctx context.Context, params *ListDomainConflictsInput, optFns ...func(*Options)) (*ListDomainConflictsOutput, error) {
	if params == nil {
		params = &ListDomainConflictsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListDomainConflicts", params, optFns, c.addOperationListDomainConflictsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListDomainConflictsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListDomainConflictsInput struct {

	// The domain to check for conflicts.
	//
	// This member is required.
	Domain *string

	// The distribution resource identifier. This can be the distribution or
	// distribution tenant that has a valid certificate, which covers the domain that
	// you specify.
	//
	// This member is required.
	DomainControlValidationResource *types.DistributionResourceId

	// The marker for the next set of domain conflicts.
	Marker *string

	// The maximum number of domain conflicts to return.
	MaxItems *int32

	noSmithyDocumentSerde
}

type ListDomainConflictsOutput struct {

	// Contains details about the domain conflicts.
	DomainConflicts []types.DomainConflict

	// A token used for pagination of results returned in the response. You can use
	// the token from the previous request to define where the current request should
	// begin.
	NextMarker *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListDomainConflictsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestxml_serializeOpListDomainConflicts{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestxml_deserializeOpListDomainConflicts{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListDomainConflicts"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListDomainConflictsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListDomainConflicts(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListDomainConflictsPaginatorOptions is the paginator options for
// ListDomainConflicts
type ListDomainConflictsPaginatorOptions struct {
	// The maximum number of domain conflicts to return.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListDomainConflictsPaginator is a paginator for ListDomainConflicts
type ListDomainConflictsPaginator struct {
	options   ListDomainConflictsPaginatorOptions
	client    ListDomainConflictsAPIClient
	params    *ListDomainConflictsInput
	nextToken *string
	firstPage bool
}

// NewListDomainConflictsPaginator returns a new ListDomainConflictsPaginator
func NewListDomainConflictsPaginator(client ListDomainConflictsAPIClient, params *ListDomainConflictsInput, optFns ...func(*ListDomainConflictsPaginatorOptions)) *ListDomainConflictsPaginator {
	if params == nil {
		params = &ListDomainConflictsInput{}
	}

	options := ListDomainConflictsPaginatorOptions{}
	if params.MaxItems != nil {
		options.Limit = *params.MaxItems
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListDomainConflictsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.Marker,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListDomainConflictsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListDomainConflicts page.
func (p *ListDomainConflictsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListDomainConflictsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.Marker = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxItems = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListDomainConflicts(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextMarker

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListDomainConflictsAPIClient is a client that implements the
// ListDomainConflicts operation.
type ListDomainConflictsAPIClient interface {
	ListDomainConflicts(context.Context, *ListDomainConflictsInput, ...func(*Options)) (*ListDomainConflictsOutput, error)
}

var _ ListDomainConflictsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListDomainConflicts(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListDomainConflicts",
	}
}
