// Code generated by smithy-go-codegen DO NOT EDIT.

package chimesdkvoice

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/chimesdkvoice/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates an Amazon Chime SDK Voice Connector. For more information about Voice
// Connectors, see [Managing Amazon Chime SDK Voice Connector groups]in the Amazon Chime SDK Administrator Guide.
//
// [Managing Amazon Chime SDK Voice Connector groups]: https://docs.aws.amazon.com/chime-sdk/latest/ag/voice-connector-groups.html
func (c *Client) CreateVoiceConnector(ctx context.Context, params *CreateVoiceConnectorInput, optFns ...func(*Options)) (*CreateVoiceConnectorOutput, error) {
	if params == nil {
		params = &CreateVoiceConnectorInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateVoiceConnector", params, optFns, c.addOperationCreateVoiceConnectorMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateVoiceConnectorOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateVoiceConnectorInput struct {

	// The name of the Voice Connector.
	//
	// This member is required.
	Name *string

	// Enables or disables encryption for the Voice Connector.
	//
	// This member is required.
	RequireEncryption *bool

	// The AWS Region in which the Amazon Chime SDK Voice Connector is created.
	// Default value: us-east-1 .
	AwsRegion types.VoiceConnectorAwsRegion

	// The connectors for use with Amazon Connect.
	//
	// The following options are available:
	//
	//   - CONNECT_CALL_TRANSFER_CONNECTOR - Enables enterprises to integrate Amazon
	//   Connect with other voice systems to directly transfer voice calls and metadata
	//   without using the public telephone network. They can use Amazon Connect
	//   telephony and Interactive Voice Response (IVR) with their existing voice systems
	//   to modernize the IVR experience of their existing contact center and their
	//   enterprise and branch voice systems. Additionally, enterprises migrating their
	//   contact center to Amazon Connect can start with Connect telephony and IVR for
	//   immediate modernization ahead of agent migration.
	//
	//   - CONNECT_ANALYTICS_CONNECTOR - Enables enterprises to integrate Amazon
	//   Connect with other voice systems for real-time and post-call analytics. They can
	//   use Amazon Connect Contact Lens with their existing voice systems to provides
	//   call recordings, conversational analytics (including contact transcript,
	//   sensitive data redaction, content categorization, theme detection, sentiment
	//   analysis, real-time alerts, and post-contact summary), and agent performance
	//   evaluations (including evaluation forms, automated evaluation, supervisor
	//   review) with a rich user experience to display, search and filter customer
	//   interactions, and programmatic access to data streams and the data lake.
	//   Additionally, enterprises migrating their contact center to Amazon Connect can
	//   start with Contact Lens analytics and performance insights ahead of agent
	//   migration.
	IntegrationType types.VoiceConnectorIntegrationType

	// The tags assigned to the Voice Connector.
	Tags []types.Tag

	noSmithyDocumentSerde
}

type CreateVoiceConnectorOutput struct {

	// The details of the Voice Connector.
	VoiceConnector *types.VoiceConnector

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateVoiceConnectorMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreateVoiceConnector{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreateVoiceConnector{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateVoiceConnector"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpCreateVoiceConnectorValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateVoiceConnector(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateVoiceConnector(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateVoiceConnector",
	}
}
