// Code generated by smithy-go-codegen DO NOT EDIT.

package bedrockagent

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/bedrockagent/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Ingests documents directly into the knowledge base that is connected to the
// data source. The dataSourceType specified in the content for each document must
// match the type of the data source that you specify in the header. For more
// information, see [Ingest changes directly into a knowledge base]in the Amazon Bedrock User Guide.
//
// [Ingest changes directly into a knowledge base]: https://docs.aws.amazon.com/bedrock/latest/userguide/kb-direct-ingestion.html
func (c *Client) IngestKnowledgeBaseDocuments(ctx context.Context, params *IngestKnowledgeBaseDocumentsInput, optFns ...func(*Options)) (*IngestKnowledgeBaseDocumentsOutput, error) {
	if params == nil {
		params = &IngestKnowledgeBaseDocumentsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "IngestKnowledgeBaseDocuments", params, optFns, c.addOperationIngestKnowledgeBaseDocumentsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*IngestKnowledgeBaseDocumentsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type IngestKnowledgeBaseDocumentsInput struct {

	// The unique identifier of the data source connected to the knowledge base that
	// you're adding documents to.
	//
	// This member is required.
	DataSourceId *string

	// A list of objects, each of which contains information about the documents to
	// add.
	//
	// This member is required.
	Documents []types.KnowledgeBaseDocument

	// The unique identifier of the knowledge base to ingest the documents into.
	//
	// This member is required.
	KnowledgeBaseId *string

	// A unique, case-sensitive identifier to ensure that the API request completes no
	// more than one time. If this token matches a previous request, Amazon Bedrock
	// ignores the request, but does not return an error. For more information, see [Ensuring idempotency].
	//
	// [Ensuring idempotency]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html
	ClientToken *string

	noSmithyDocumentSerde
}

type IngestKnowledgeBaseDocumentsOutput struct {

	// A list of objects, each of which contains information about the documents that
	// were ingested.
	DocumentDetails []types.KnowledgeBaseDocumentDetail

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationIngestKnowledgeBaseDocumentsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpIngestKnowledgeBaseDocuments{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpIngestKnowledgeBaseDocuments{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "IngestKnowledgeBaseDocuments"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opIngestKnowledgeBaseDocumentsMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpIngestKnowledgeBaseDocumentsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opIngestKnowledgeBaseDocuments(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpIngestKnowledgeBaseDocuments struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpIngestKnowledgeBaseDocuments) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpIngestKnowledgeBaseDocuments) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*IngestKnowledgeBaseDocumentsInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *IngestKnowledgeBaseDocumentsInput ")
	}

	if input.ClientToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opIngestKnowledgeBaseDocumentsMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpIngestKnowledgeBaseDocuments{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opIngestKnowledgeBaseDocuments(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "IngestKnowledgeBaseDocuments",
	}
}
