// Code generated by smithy-go-codegen DO NOT EDIT.

package bedrock

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/bedrock/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Retrieves the properties associated with a model-customization job, including
// the status of the job. For more information, see [Custom models]in the [Amazon Bedrock User Guide].
//
// [Custom models]: https://docs.aws.amazon.com/bedrock/latest/userguide/custom-models.html
// [Amazon Bedrock User Guide]: https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html
func (c *Client) GetModelCustomizationJob(ctx context.Context, params *GetModelCustomizationJobInput, optFns ...func(*Options)) (*GetModelCustomizationJobOutput, error) {
	if params == nil {
		params = &GetModelCustomizationJobInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetModelCustomizationJob", params, optFns, c.addOperationGetModelCustomizationJobMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetModelCustomizationJobOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetModelCustomizationJobInput struct {

	// Identifier for the customization job.
	//
	// This member is required.
	JobIdentifier *string

	noSmithyDocumentSerde
}

type GetModelCustomizationJobOutput struct {

	// Amazon Resource Name (ARN) of the base model.
	//
	// This member is required.
	BaseModelArn *string

	// Time that the resource was created.
	//
	// This member is required.
	CreationTime *time.Time

	// The Amazon Resource Name (ARN) of the customization job.
	//
	// This member is required.
	JobArn *string

	// The name of the customization job.
	//
	// This member is required.
	JobName *string

	// Output data configuration
	//
	// This member is required.
	OutputDataConfig *types.OutputDataConfig

	// The name of the output model.
	//
	// This member is required.
	OutputModelName *string

	// The Amazon Resource Name (ARN) of the IAM role.
	//
	// This member is required.
	RoleArn *string

	// Contains information about the training dataset.
	//
	// This member is required.
	TrainingDataConfig *types.TrainingDataConfig

	// Contains information about the validation dataset.
	//
	// This member is required.
	ValidationDataConfig *types.ValidationDataConfig

	// The token that you specified in the CreateCustomizationJob request.
	ClientRequestToken *string

	// The customization configuration for the model customization job.
	CustomizationConfig types.CustomizationConfig

	// The type of model customization.
	CustomizationType types.CustomizationType

	// Time that the resource transitioned to terminal state.
	EndTime *time.Time

	// Information about why the job failed.
	FailureMessage *string

	// The hyperparameter values for the job. For details on the format for different
	// models, see [Custom model hyperparameters].
	//
	// [Custom model hyperparameters]: https://docs.aws.amazon.com/bedrock/latest/userguide/custom-models-hp.html
	HyperParameters map[string]string

	// Time that the resource was last modified.
	LastModifiedTime *time.Time

	// The Amazon Resource Name (ARN) of the output model.
	OutputModelArn *string

	// The custom model is encrypted at rest using this key.
	OutputModelKmsKeyArn *string

	// The status of the job. A successful job transitions from in-progress to
	// completed when the output model is ready to use. If the job failed, the failure
	// message contains information about why the job failed.
	Status types.ModelCustomizationJobStatus

	// For a Distillation job, the details about the statuses of the sub-tasks of the
	// customization job.
	StatusDetails *types.StatusDetails

	// Contains training metrics from the job creation.
	TrainingMetrics *types.TrainingMetrics

	// The loss metric for each validator that you provided in the createjob request.
	ValidationMetrics []types.ValidatorMetric

	// VPC configuration for the custom model job.
	VpcConfig *types.VpcConfig

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetModelCustomizationJobMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetModelCustomizationJob{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetModelCustomizationJob{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetModelCustomizationJob"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetModelCustomizationJobValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetModelCustomizationJob(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetModelCustomizationJob(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetModelCustomizationJob",
	}
}
