// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Summary information about the Application Association.
type ApplicationAssociationSummary struct {

	// The Amazon Resource Name (ARN) of the Application.
	ApplicationArn *string

	// The Amazon Resource Name (ARN) of the Application Association.
	ApplicationAssociationArn *string

	// The identifier for the client that is associated with the Application
	// Association.
	ClientId *string

	noSmithyDocumentSerde
}

// The configuration for where the application should be loaded from.
type ApplicationSourceConfig struct {

	// The external URL source for the application.
	ExternalUrlConfig *ExternalUrlConfig

	noSmithyDocumentSerde
}

// Summary information about the Application.
type ApplicationSummary struct {

	// The Amazon Resource Name (ARN) of the Application.
	Arn *string

	// The time when the application was created.
	CreatedTime *time.Time

	// A unique identifier for the Application.
	Id *string

	// The time when the application was last modified.
	LastModifiedTime *time.Time

	// The name of the application.
	Name *string

	// The namespace of the application.
	Namespace *string

	noSmithyDocumentSerde
}

// Summary information about the DataIntegration association.
type DataIntegrationAssociationSummary struct {

	// The identifier for the client that is associated with the DataIntegration
	// association.
	ClientId *string

	// The Amazon Resource Name (ARN) of the DataIntegration.
	DataIntegrationArn *string

	// The Amazon Resource Name (ARN) of the DataIntegration association.
	DataIntegrationAssociationArn *string

	// The URI of the data destination.
	DestinationURI *string

	// The configuration for how the files should be pulled from the source.
	ExecutionConfiguration *ExecutionConfiguration

	// The execution status of the last job.
	LastExecutionStatus *LastExecutionStatus

	noSmithyDocumentSerde
}

// Summary information about the DataIntegration.
type DataIntegrationSummary struct {

	// The Amazon Resource Name (ARN) of the DataIntegration.
	Arn *string

	// The name of the DataIntegration.
	Name *string

	// The URI of the data source.
	SourceURI *string

	noSmithyDocumentSerde
}

// The event filter.
type EventFilter struct {

	// The source of the events.
	//
	// This member is required.
	Source *string

	noSmithyDocumentSerde
}

// The event integration.
type EventIntegration struct {

	// The event integration description.
	Description *string

	// The Amazon EventBridge bus for the event integration.
	EventBridgeBus *string

	// The event integration filter.
	EventFilter *EventFilter

	// The Amazon Resource Name (ARN) of the event integration.
	EventIntegrationArn *string

	// The name of the event integration.
	Name *string

	// The tags used to organize, track, or control access for this resource. For
	// example, { "tags": {"key1":"value1", "key2":"value2"} }.
	Tags map[string]string

	noSmithyDocumentSerde
}

// The event integration association.
type EventIntegrationAssociation struct {

	// The metadata associated with the client.
	ClientAssociationMetadata map[string]string

	// The identifier for the client that is associated with the event integration.
	ClientId *string

	// The name of the EventBridge rule.
	EventBridgeRuleName *string

	// The Amazon Resource Name (ARN) for the event integration association.
	EventIntegrationAssociationArn *string

	// The identifier for the event integration association.
	EventIntegrationAssociationId *string

	// The name of the event integration.
	EventIntegrationName *string

	noSmithyDocumentSerde
}

// The configuration for how the files should be pulled from the source.
type ExecutionConfiguration struct {

	// The mode for data import/export execution.
	//
	// This member is required.
	ExecutionMode ExecutionMode

	// The start and end time for data pull from the source.
	OnDemandConfiguration *OnDemandConfiguration

	// The name of the data and how often it should be pulled from the source.
	ScheduleConfiguration *ScheduleConfiguration

	noSmithyDocumentSerde
}

// The external URL source for the application.
type ExternalUrlConfig struct {

	// The URL to access the application.
	//
	// This member is required.
	AccessUrl *string

	// Additional URLs to allow list if different than the access URL.
	ApprovedOrigins []string

	noSmithyDocumentSerde
}

// The configuration for what files should be pulled from the source.
type FileConfiguration struct {

	// Identifiers for the source folders to pull all files from recursively.
	//
	// This member is required.
	Folders []string

	// Restrictions for what files should be pulled from the source.
	Filters map[string][]string

	noSmithyDocumentSerde
}

// The execution status of the last job.
type LastExecutionStatus struct {

	// The job status enum string.
	ExecutionStatus ExecutionStatus

	// The status message of a job.
	StatusMessage *string

	noSmithyDocumentSerde
}

// The start and end time for data pull from the source.
type OnDemandConfiguration struct {

	// The start time for data pull from the source as an Unix/epoch string in
	// milliseconds
	//
	// This member is required.
	StartTime *string

	// The end time for data pull from the source as an Unix/epoch string in
	// milliseconds
	EndTime *string

	noSmithyDocumentSerde
}

// The configuration of an event that the application publishes.
type Publication struct {

	// The name of the publication.
	//
	// This member is required.
	Event *string

	// The JSON schema of the publication event.
	//
	// This member is required.
	Schema *string

	// The description of the publication.
	Description *string

	noSmithyDocumentSerde
}

// The name of the data and how often it should be pulled from the source.
type ScheduleConfiguration struct {

	// How often the data should be pulled from data source.
	//
	// This member is required.
	ScheduleExpression *string

	// The start date for objects to import in the first flow run as an Unix/epoch
	// timestamp in milliseconds or in ISO-8601 format.
	FirstExecutionFrom *string

	// The name of the object to pull from the data source.
	Object *string

	noSmithyDocumentSerde
}

// The configuration of an event that the application subscribes.
type Subscription struct {

	// The name of the subscription.
	//
	// This member is required.
	Event *string

	// The description of the subscription.
	Description *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
