# v2.2 to 2.3

## Argo CD Notifications and ApplicationSet Are Bundled into Argo CD

The Argo CD Notifications and ApplicationSet are part of Argo CD now. You no longer need to install them separately.
The Notifications and ApplicationSet components are bundled into default Argo CD installation manifests.

The bundled manifests are drop-in replacements for the previous versions. If you are using Kustomize to bundle the manifests together then just
remove references to https://github.com/argoproj-labs/argocd-notifications and https://github.com/argoproj-labs/applicationset.

If you are using [the argocd-notifications helm chart](https://github.com/argoproj/argo-helm/tree/argocd-notifications-1.8.1/charts/argocd-notifications), you can move the chart [values](https://github.com/argoproj/argo-helm/blob/argocd-notifications-1.8.1/charts/argocd-notifications/values.yaml) to the `notifications` section of the argo-cd chart [values](https://github.com/argoproj/argo-helm/blob/main/charts/argo-cd/values.yaml#L2152). Although most values remain as is, for details please look up the values that are relevant to you.

No action is required if you are using `kubectl apply`.

## Configure Additional Argo CD Binaries

We have removed non-Linux Argo CD binaries (Darwin amd64 and Windows amd64) from the image ([#7668](https://github.com/argoproj/argo-cd/pull/7668)) and the associated download buttons in the help page in the UI.

Those removed binaries will still be included in the release assets and we made those configurable in [#7755](https://github.com/argoproj/argo-cd/pull/7755). You can add download buttons for other OS architectures by adding the following to your `argocd-cm` ConfigMap:

```yaml
apiVersion: v1
kind: ConfigMap
metadata:
  name: argocd-cm
  namespace: argocd
  labels:
    app.kubernetes.io/name: argocd-cm
    app.kubernetes.io/part-of: argocd
data:
  help.download.linux-arm64: "path-or-url-to-download"
  help.download.darwin-amd64: "path-or-url-to-download"
  help.download.darwin-arm64: "path-or-url-to-download"
  help.download.windows-amd64: "path-or-url-to-download"
```

## Removed Python from the base image

If you are using a [Config Management Plugin](../config-management-plugins.md) that relies on Python, you
will need to build a custom image on the Argo CD base to install Python.

## Upgraded Kustomize Version

Note that bundled Kustomize version has been upgraded from 4.2.0 to 4.4.1.

## Upgraded Helm Version

Note that bundled Helm version has been upgraded from 3.7.1 to 3.8.0.

## Support for private repo SSH keys using the SHA-1 signature hash algorithm is removed in 2.3.7

Argo CD 2.3.7 upgraded its base image from Ubuntu 21.04 to Ubuntu 22.04, which upgraded OpenSSH to 8.9. OpenSSH starting
with 8.8 [dropped support for the `ssh-rsa` SHA-1 key signature algorithm](https://www.openssh.com/txt/release-8.8).

The signature algorithm is _not_ the same as the algorithm used when generating the key. There is no need to update
keys.

The signature algorithm is negotiated with the SSH server when the connection is being set up. The client offers its
list of accepted signature algorithms, and if the server has a match, the connection proceeds. For most SSH servers on
up-to-date git providers, acceptable algorithms other than `ssh-rsa` should be available.

Before upgrading to Argo CD 2.3.7, check whether your git provider(s) using SSH authentication support algorithms newer
than `rsa-ssh`.

1. Make sure your version of SSH >= 8.9 (the version used by Argo CD). If not, upgrade it before proceeding.

   ```shell
   ssh -V
   ```

   Example output: `OpenSSH_8.9p1 Ubuntu-3, OpenSSL 3.0.2 15 Mar 2022`

2. Once you have a recent version of OpenSSH, follow the directions from the [OpenSSH 8.8 release notes](https://www.openssh.com/txt/release-8.7):

   > To check whether a server is using the weak ssh-rsa public key
   > algorithm, for host authentication, try to connect to it after
   > removing the ssh-rsa algorithm from ssh(1)'s allowed list:
   >
   > ```shell
   > ssh -oHostKeyAlgorithms=-ssh-rsa user@host
   > ```
   >
   > If the host key verification fails and no other supported host key
   > types are available, the server software on that host should be
   > upgraded.

   If the server does not support an acceptable version, you will get an error similar to this;

   ```
   $ ssh -oHostKeyAlgorithms=-ssh-rsa vs-ssh.visualstudio.com
   Unable to negotiate with 20.42.134.1 port 22: no matching host key type found. Their offer: ssh-rsa
   ```

   This indicates that the server needs to update its supported key signature algorithms, and Argo CD will not connect
   to it.

### Workaround

The [OpenSSH 8.8 release notes](https://www.openssh.com/txt/release-8.8) describe a workaround if you cannot change the
server's key signature algorithms configuration.

> Incompatibility is more likely when connecting to older SSH
> implementations that have not been upgraded or have not closely tracked
> improvements in the SSH protocol. For these cases, it may be necessary
> to selectively re-enable RSA/SHA1 to allow connection and/or user
> authentication via the HostkeyAlgorithms and PubkeyAcceptedAlgorithms
> options. For example, the following stanza in ~/.ssh/config will enable
> RSA/SHA1 for host and user authentication for a single destination host:
>
> ```
> Host old-host
>     HostkeyAlgorithms +ssh-rsa
>     PubkeyAcceptedAlgorithms +ssh-rsa
> ```
>
> We recommend enabling RSA/SHA1 only as a stopgap measure until legacy
> implementations can be upgraded or reconfigured with another key type
> (such as ECDSA or Ed25519).

To apply this to Argo CD, you could create a ConfigMap with the desired ssh config file and then mount it at
`/home/argocd/.ssh/config`.

