// Code generated by go generate. DO NOT EDIT.

package opt

import "encoding/json"

// PageOption is a wrapper for an Page option parameter. It holds
// the actual value of the option that can be accessed by calling Get.
type PageOption struct {
	value int
}

// Page wraps the given value into a PageOption.
func Page(v int) *PageOption {
	return &PageOption{v}
}

// Get retrieves the actual value of the option parameter.
func (o *PageOption) Get() int {
	if o == nil {
		return 0
	}
	return o.value
}

// MarshalJSON implements the json.Marshaler interface for
// PageOption.
func (o PageOption) MarshalJSON() ([]byte, error) {
	return json.Marshal(o.value)
}

// UnmarshalJSON implements the json.Unmarshaler interface for
// PageOption.
func (o *PageOption) UnmarshalJSON(data []byte) error {
	if string(data) == "null" {
		o.value = 0
		return nil
	}
	return json.Unmarshal(data, &o.value)
}

// Equal returns true if the given option is equal to the instance one. In case
// the given option is nil, we checked the instance one is set to the default
// value of the option.
func (o *PageOption) Equal(o2 *PageOption) bool {
	if o == nil {
		return o2 == nil || o2.value == 0
	}
	if o2 == nil {
		return o == nil || o.value == 0
	}
	return o.value == o2.value
}

// PageEqual returns true if the two options are equal.
// In case of one option being nil, the value of the other must be nil as well
// or be set to the default value of this option.
func PageEqual(o1, o2 *PageOption) bool {
	return o1.Equal(o2)
}
