// Code generated by go generate. DO NOT EDIT.

package opt

import "encoding/json"

// AdvancedOption is a wrapper for an Advanced option parameter. It holds
// the actual value of the option that can be accessed by calling Get.
type AdvancedOption struct {
	value int
}

// Advanced wraps the given value into a AdvancedOption.
func Advanced(v int) *AdvancedOption {
	return &AdvancedOption{v}
}

// Get retrieves the actual value of the option parameter.
func (o *AdvancedOption) Get() int {
	if o == nil {
		return 0
	}
	return o.value
}

// MarshalJSON implements the json.Marshaler interface for
// AdvancedOption.
func (o AdvancedOption) MarshalJSON() ([]byte, error) {
	return json.Marshal(o.value)
}

// UnmarshalJSON implements the json.Unmarshaler interface for
// AdvancedOption.
func (o *AdvancedOption) UnmarshalJSON(data []byte) error {
	if string(data) == "null" {
		o.value = 0
		return nil
	}
	return json.Unmarshal(data, &o.value)
}

// Equal returns true if the given option is equal to the instance one. In case
// the given option is nil, we checked the instance one is set to the default
// value of the option.
func (o *AdvancedOption) Equal(o2 *AdvancedOption) bool {
	if o == nil {
		return o2 == nil || o2.value == 0
	}
	if o2 == nil {
		return o == nil || o.value == 0
	}
	return o.value == o2.value
}

// AdvancedEqual returns true if the two options are equal.
// In case of one option being nil, the value of the other must be nil as well
// or be set to the default value of this option.
func AdvancedEqual(o1, o2 *AdvancedOption) bool {
	return o1.Equal(o2)
}
