// Code generated by go generate. DO NOT EDIT.

package opt

import (
	"encoding/json"
	"testing"

	"github.com/algolia/algoliasearch-client-go/v3/algolia/opt"
	"github.com/stretchr/testify/require"
)

func TestAttributesToTransliterate(t *testing.T) {
	for _, c := range []struct {
		opts     []interface{}
		expected *opt.AttributesToTransliterateOption
	}{
		{
			opts:     []interface{}{nil},
			expected: opt.AttributesToTransliterate([]string{"*"}...),
		},
		{
			opts:     []interface{}{opt.AttributesToTransliterate("value1")},
			expected: opt.AttributesToTransliterate("value1"),
		},
		{
			opts:     []interface{}{opt.AttributesToTransliterate("value1", "value2", "value3")},
			expected: opt.AttributesToTransliterate("value1", "value2", "value3"),
		},
	} {
		var (
			in  = ExtractAttributesToTransliterate(c.opts...)
			out opt.AttributesToTransliterateOption
		)
		data, err := json.Marshal(&in)
		require.NoError(t, err)
		err = json.Unmarshal(data, &out)
		require.NoError(t, err)
		require.ElementsMatch(t, c.expected.Get(), out.Get())
	}
}

func TestAttributesToTransliterate_CommaSeparatedString(t *testing.T) {
	for _, c := range []struct {
		payload  string
		expected *opt.AttributesToTransliterateOption
	}{
		{
			payload:  `""`,
			expected: opt.AttributesToTransliterate([]string{}...),
		},
		{
			payload:  `"value1"`,
			expected: opt.AttributesToTransliterate("value1"),
		},
		{
			payload:  `"value1,value2,value3"`,
			expected: opt.AttributesToTransliterate("value1", "value2", "value3"),
		},
	} {
		var got opt.AttributesToTransliterateOption
		err := json.Unmarshal([]byte(c.payload), &got)
		require.NoError(t, err)
		require.ElementsMatch(t, c.expected.Get(), got.Get())
	}
}
