// Code generated by go generate. DO NOT EDIT.

package opt

import "encoding/json"

// SynonymsOption is a wrapper for an Synonyms option parameter. It holds
// the actual value of the option that can be accessed by calling Get.
type SynonymsOption struct {
	value bool
}

// Synonyms wraps the given value into a SynonymsOption.
func Synonyms(v bool) *SynonymsOption {
	return &SynonymsOption{v}
}

// Get retrieves the actual value of the option parameter.
func (o *SynonymsOption) Get() bool {
	if o == nil {
		return true
	}
	return o.value
}

// MarshalJSON implements the json.Marshaler interface for
// SynonymsOption.
func (o SynonymsOption) MarshalJSON() ([]byte, error) {
	return json.Marshal(o.value)
}

// UnmarshalJSON implements the json.Unmarshaler interface for
// SynonymsOption.
func (o *SynonymsOption) UnmarshalJSON(data []byte) error {
	if string(data) == "null" {
		o.value = true
		return nil
	}
	return json.Unmarshal(data, &o.value)
}

// Equal returns true if the given option is equal to the instance one. In case
// the given option is nil, we checked the instance one is set to the default
// value of the option.
func (o *SynonymsOption) Equal(o2 *SynonymsOption) bool {
	if o == nil {
		return o2 == nil || o2.value == true
	}
	if o2 == nil {
		return o == nil || o.value == true
	}
	return o.value == o2.value
}

// SynonymsEqual returns true if the two options are equal.
// In case of one option being nil, the value of the other must be nil as well
// or be set to the default value of this option.
func SynonymsEqual(o1, o2 *SynonymsOption) bool {
	return o1.Equal(o2)
}
