// Code generated by go generate. DO NOT EDIT.

package opt

import (
	"encoding/json"
	"testing"

	"github.com/algolia/algoliasearch-client-go/v3/algolia/opt"
	"github.com/stretchr/testify/require"
)

func TestRestrictSearchableAttributes(t *testing.T) {
	for _, c := range []struct {
		opts     []interface{}
		expected *opt.RestrictSearchableAttributesOption
	}{
		{
			opts:     []interface{}{nil},
			expected: opt.RestrictSearchableAttributes([]string{}...),
		},
		{
			opts:     []interface{}{opt.RestrictSearchableAttributes("value1")},
			expected: opt.RestrictSearchableAttributes("value1"),
		},
		{
			opts:     []interface{}{opt.RestrictSearchableAttributes("value1", "value2", "value3")},
			expected: opt.RestrictSearchableAttributes("value1", "value2", "value3"),
		},
	} {
		var (
			in  = ExtractRestrictSearchableAttributes(c.opts...)
			out opt.RestrictSearchableAttributesOption
		)
		data, err := json.Marshal(&in)
		require.NoError(t, err)
		err = json.Unmarshal(data, &out)
		require.NoError(t, err)
		require.ElementsMatch(t, c.expected.Get(), out.Get())
	}
}

func TestRestrictSearchableAttributes_CommaSeparatedString(t *testing.T) {
	for _, c := range []struct {
		payload  string
		expected *opt.RestrictSearchableAttributesOption
	}{
		{
			payload:  `""`,
			expected: opt.RestrictSearchableAttributes([]string{}...),
		},
		{
			payload:  `"value1"`,
			expected: opt.RestrictSearchableAttributes("value1"),
		},
		{
			payload:  `"value1,value2,value3"`,
			expected: opt.RestrictSearchableAttributes("value1", "value2", "value3"),
		},
	} {
		var got opt.RestrictSearchableAttributesOption
		err := json.Unmarshal([]byte(c.payload), &got)
		require.NoError(t, err)
		require.ElementsMatch(t, c.expected.Get(), got.Get())
	}
}
