// Code generated by go generate. DO NOT EDIT.

package opt

import (
	"encoding/json"
	"testing"

	"github.com/algolia/algoliasearch-client-go/v3/algolia/opt"
	"github.com/stretchr/testify/require"
)

func TestExtractDisableStandardEntries(t *testing.T) {
	for _, c := range []struct {
		opts     []interface{}
		expected *opt.DisableStandardEntriesOption
	}{
		{
			opts:     []interface{}{nil},
			expected: opt.DisableStandardEntries(map[string]map[string]bool{}),
		},
		{
			opts:     []interface{}{opt.DisableStandardEntries(map[string]map[string]bool{})},
			expected: opt.DisableStandardEntries(map[string]map[string]bool{}),
		},
		{
			opts:     []interface{}{opt.DisableStandardEntries(map[string]map[string]bool{"outer1": map[string]bool{"k1": true, "k2": false}, "outer2": map[string]bool{"k3": true}})},
			expected: opt.DisableStandardEntries(map[string]map[string]bool{"outer1": map[string]bool{"k1": true, "k2": false}, "outer2": map[string]bool{"k3": true}}),
		},
	} {
		var (
			in  = ExtractDisableStandardEntries(c.opts...)
			out opt.DisableStandardEntriesOption
		)
		data, err := json.Marshal(&in)
		require.NoError(t, err)
		err = json.Unmarshal(data, &out)
		require.NoError(t, err)
		require.Equal(t, *c.expected, out)
	}
}
