// Code generated by 'go generate'; DO NOT EDIT.

package winpowrprof

import (
	"syscall"
	"unsafe"

	"golang.org/x/sys/windows"
)

var _ unsafe.Pointer

// Do the interface allocations only once for common
// Errno values.
const (
	errnoERROR_IO_PENDING = 997
)

var (
	errERROR_IO_PENDING error = syscall.Errno(errnoERROR_IO_PENDING)
	errERROR_EINVAL     error = syscall.EINVAL
)

// errnoErr returns common boxed Errno values, to prevent
// allocations at runtime.
func errnoErr(e syscall.Errno) error {
	switch e {
	case 0:
		return errERROR_EINVAL
	case errnoERROR_IO_PENDING:
		return errERROR_IO_PENDING
	}
	// TODO: add more here, after collecting data on the common
	// error values see on Windows. (perhaps when running
	// all.bat?)
	return e
}

var (
	modpowrprof = windows.NewLazySystemDLL("powrprof.dll")

	procPowerRegisterSuspendResumeNotification   = modpowrprof.NewProc("PowerRegisterSuspendResumeNotification")
	procPowerUnregisterSuspendResumeNotification = modpowrprof.NewProc("PowerUnregisterSuspendResumeNotification")
)

func PowerRegisterSuspendResumeNotification(flags uint32, recipient *DEVICE_NOTIFY_SUBSCRIBE_PARAMETERS, registrationHandle *uintptr) (ret error) {
	r0, _, _ := syscall.Syscall(procPowerRegisterSuspendResumeNotification.Addr(), 3, uintptr(flags), uintptr(unsafe.Pointer(recipient)), uintptr(unsafe.Pointer(registrationHandle)))
	if r0 != 0 {
		ret = syscall.Errno(r0)
	}
	return
}

func PowerUnregisterSuspendResumeNotification(handle uintptr) (ret error) {
	r0, _, _ := syscall.Syscall(procPowerUnregisterSuspendResumeNotification.Addr(), 1, uintptr(handle), 0, 0)
	if r0 != 0 {
		ret = syscall.Errno(r0)
	}
	return
}
