//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/trafficmanager/armtrafficmanager"
	"net/http"
	"regexp"
)

// UserMetricsKeysServer is a fake server for instances of the armtrafficmanager.UserMetricsKeysClient type.
type UserMetricsKeysServer struct {
	// CreateOrUpdate is the fake for method UserMetricsKeysClient.CreateOrUpdate
	// HTTP status codes to indicate success: http.StatusCreated
	CreateOrUpdate func(ctx context.Context, options *armtrafficmanager.UserMetricsKeysClientCreateOrUpdateOptions) (resp azfake.Responder[armtrafficmanager.UserMetricsKeysClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// Delete is the fake for method UserMetricsKeysClient.Delete
	// HTTP status codes to indicate success: http.StatusOK
	Delete func(ctx context.Context, options *armtrafficmanager.UserMetricsKeysClientDeleteOptions) (resp azfake.Responder[armtrafficmanager.UserMetricsKeysClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method UserMetricsKeysClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, options *armtrafficmanager.UserMetricsKeysClientGetOptions) (resp azfake.Responder[armtrafficmanager.UserMetricsKeysClientGetResponse], errResp azfake.ErrorResponder)
}

// NewUserMetricsKeysServerTransport creates a new instance of UserMetricsKeysServerTransport with the provided implementation.
// The returned UserMetricsKeysServerTransport instance is connected to an instance of armtrafficmanager.UserMetricsKeysClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewUserMetricsKeysServerTransport(srv *UserMetricsKeysServer) *UserMetricsKeysServerTransport {
	return &UserMetricsKeysServerTransport{srv: srv}
}

// UserMetricsKeysServerTransport connects instances of armtrafficmanager.UserMetricsKeysClient to instances of UserMetricsKeysServer.
// Don't use this type directly, use NewUserMetricsKeysServerTransport instead.
type UserMetricsKeysServerTransport struct {
	srv *UserMetricsKeysServer
}

// Do implements the policy.Transporter interface for UserMetricsKeysServerTransport.
func (u *UserMetricsKeysServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "UserMetricsKeysClient.CreateOrUpdate":
		resp, err = u.dispatchCreateOrUpdate(req)
	case "UserMetricsKeysClient.Delete":
		resp, err = u.dispatchDelete(req)
	case "UserMetricsKeysClient.Get":
		resp, err = u.dispatchGet(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (u *UserMetricsKeysServerTransport) dispatchCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if u.srv.CreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrUpdate not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/trafficManagerUserMetricsKeys/default`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	respr, errRespr := u.srv.CreateOrUpdate(req.Context(), nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusCreated}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusCreated", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).UserMetricsModel, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (u *UserMetricsKeysServerTransport) dispatchDelete(req *http.Request) (*http.Response, error) {
	if u.srv.Delete == nil {
		return nil, &nonRetriableError{errors.New("fake for method Delete not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/trafficManagerUserMetricsKeys/default`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	respr, errRespr := u.srv.Delete(req.Context(), nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).DeleteOperationResult, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (u *UserMetricsKeysServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if u.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/trafficManagerUserMetricsKeys/default`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	respr, errRespr := u.srv.Get(req.Context(), nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).UserMetricsModel, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
