//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armtestbase

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// FavoriteProcessesClient contains the methods for the FavoriteProcesses group.
// Don't use this type directly, use NewFavoriteProcessesClient() instead.
type FavoriteProcessesClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewFavoriteProcessesClient creates a new instance of FavoriteProcessesClient with the specified values.
//   - subscriptionID - The Azure subscription ID. This is a GUID-formatted string.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewFavoriteProcessesClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*FavoriteProcessesClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &FavoriteProcessesClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// Create - Create or replace a favorite process for a Test Base Package.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2020-12-16-preview
//   - resourceGroupName - The name of the resource group that contains the resource.
//   - testBaseAccountName - The resource name of the Test Base Account.
//   - packageName - The resource name of the Test Base Package.
//   - favoriteProcessResourceName - The resource name of a favorite process in a package. If the process name contains characters
//     that are not allowed in Azure Resource Name, we use 'actualProcessName' in request body to submit the
//     name.
//   - parameters - Parameters supplied to create a favorite process in a package.
//   - options - FavoriteProcessesClientCreateOptions contains the optional parameters for the FavoriteProcessesClient.Create
//     method.
func (client *FavoriteProcessesClient) Create(ctx context.Context, resourceGroupName string, testBaseAccountName string, packageName string, favoriteProcessResourceName string, parameters FavoriteProcessResource, options *FavoriteProcessesClientCreateOptions) (FavoriteProcessesClientCreateResponse, error) {
	var err error
	const operationName = "FavoriteProcessesClient.Create"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.createCreateRequest(ctx, resourceGroupName, testBaseAccountName, packageName, favoriteProcessResourceName, parameters, options)
	if err != nil {
		return FavoriteProcessesClientCreateResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return FavoriteProcessesClientCreateResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return FavoriteProcessesClientCreateResponse{}, err
	}
	resp, err := client.createHandleResponse(httpResp)
	return resp, err
}

// createCreateRequest creates the Create request.
func (client *FavoriteProcessesClient) createCreateRequest(ctx context.Context, resourceGroupName string, testBaseAccountName string, packageName string, favoriteProcessResourceName string, parameters FavoriteProcessResource, options *FavoriteProcessesClientCreateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.TestBase/testBaseAccounts/{testBaseAccountName}/packages/{packageName}/favoriteProcesses/{favoriteProcessResourceName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if testBaseAccountName == "" {
		return nil, errors.New("parameter testBaseAccountName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{testBaseAccountName}", url.PathEscape(testBaseAccountName))
	if packageName == "" {
		return nil, errors.New("parameter packageName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{packageName}", url.PathEscape(packageName))
	if favoriteProcessResourceName == "" {
		return nil, errors.New("parameter favoriteProcessResourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{favoriteProcessResourceName}", url.PathEscape(favoriteProcessResourceName))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-12-16-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, parameters); err != nil {
		return nil, err
	}
	return req, nil
}

// createHandleResponse handles the Create response.
func (client *FavoriteProcessesClient) createHandleResponse(resp *http.Response) (FavoriteProcessesClientCreateResponse, error) {
	result := FavoriteProcessesClientCreateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.FavoriteProcessResource); err != nil {
		return FavoriteProcessesClientCreateResponse{}, err
	}
	return result, nil
}

// Delete - Deletes a favorite process for a specific package.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2020-12-16-preview
//   - resourceGroupName - The name of the resource group that contains the resource.
//   - testBaseAccountName - The resource name of the Test Base Account.
//   - packageName - The resource name of the Test Base Package.
//   - favoriteProcessResourceName - The resource name of a favorite process in a package. If the process name contains characters
//     that are not allowed in Azure Resource Name, we use 'actualProcessName' in request body to submit the
//     name.
//   - options - FavoriteProcessesClientDeleteOptions contains the optional parameters for the FavoriteProcessesClient.Delete
//     method.
func (client *FavoriteProcessesClient) Delete(ctx context.Context, resourceGroupName string, testBaseAccountName string, packageName string, favoriteProcessResourceName string, options *FavoriteProcessesClientDeleteOptions) (FavoriteProcessesClientDeleteResponse, error) {
	var err error
	const operationName = "FavoriteProcessesClient.Delete"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.deleteCreateRequest(ctx, resourceGroupName, testBaseAccountName, packageName, favoriteProcessResourceName, options)
	if err != nil {
		return FavoriteProcessesClientDeleteResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return FavoriteProcessesClientDeleteResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return FavoriteProcessesClientDeleteResponse{}, err
	}
	return FavoriteProcessesClientDeleteResponse{}, nil
}

// deleteCreateRequest creates the Delete request.
func (client *FavoriteProcessesClient) deleteCreateRequest(ctx context.Context, resourceGroupName string, testBaseAccountName string, packageName string, favoriteProcessResourceName string, options *FavoriteProcessesClientDeleteOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.TestBase/testBaseAccounts/{testBaseAccountName}/packages/{packageName}/favoriteProcesses/{favoriteProcessResourceName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if testBaseAccountName == "" {
		return nil, errors.New("parameter testBaseAccountName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{testBaseAccountName}", url.PathEscape(testBaseAccountName))
	if packageName == "" {
		return nil, errors.New("parameter packageName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{packageName}", url.PathEscape(packageName))
	if favoriteProcessResourceName == "" {
		return nil, errors.New("parameter favoriteProcessResourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{favoriteProcessResourceName}", url.PathEscape(favoriteProcessResourceName))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-12-16-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// Get - Gets a favorite process for a Test Base Package.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2020-12-16-preview
//   - resourceGroupName - The name of the resource group that contains the resource.
//   - testBaseAccountName - The resource name of the Test Base Account.
//   - packageName - The resource name of the Test Base Package.
//   - favoriteProcessResourceName - The resource name of a favorite process in a package. If the process name contains characters
//     that are not allowed in Azure Resource Name, we use 'actualProcessName' in request body to submit the
//     name.
//   - options - FavoriteProcessesClientGetOptions contains the optional parameters for the FavoriteProcessesClient.Get method.
func (client *FavoriteProcessesClient) Get(ctx context.Context, resourceGroupName string, testBaseAccountName string, packageName string, favoriteProcessResourceName string, options *FavoriteProcessesClientGetOptions) (FavoriteProcessesClientGetResponse, error) {
	var err error
	const operationName = "FavoriteProcessesClient.Get"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getCreateRequest(ctx, resourceGroupName, testBaseAccountName, packageName, favoriteProcessResourceName, options)
	if err != nil {
		return FavoriteProcessesClientGetResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return FavoriteProcessesClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return FavoriteProcessesClientGetResponse{}, err
	}
	resp, err := client.getHandleResponse(httpResp)
	return resp, err
}

// getCreateRequest creates the Get request.
func (client *FavoriteProcessesClient) getCreateRequest(ctx context.Context, resourceGroupName string, testBaseAccountName string, packageName string, favoriteProcessResourceName string, options *FavoriteProcessesClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.TestBase/testBaseAccounts/{testBaseAccountName}/packages/{packageName}/favoriteProcesses/{favoriteProcessResourceName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if testBaseAccountName == "" {
		return nil, errors.New("parameter testBaseAccountName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{testBaseAccountName}", url.PathEscape(testBaseAccountName))
	if packageName == "" {
		return nil, errors.New("parameter packageName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{packageName}", url.PathEscape(packageName))
	if favoriteProcessResourceName == "" {
		return nil, errors.New("parameter favoriteProcessResourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{favoriteProcessResourceName}", url.PathEscape(favoriteProcessResourceName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-12-16-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *FavoriteProcessesClient) getHandleResponse(resp *http.Response) (FavoriteProcessesClientGetResponse, error) {
	result := FavoriteProcessesClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.FavoriteProcessResource); err != nil {
		return FavoriteProcessesClientGetResponse{}, err
	}
	return result, nil
}

// NewListPager - Lists the favorite processes for a specific package.
//
// Generated from API version 2020-12-16-preview
//   - resourceGroupName - The name of the resource group that contains the resource.
//   - testBaseAccountName - The resource name of the Test Base Account.
//   - packageName - The resource name of the Test Base Package.
//   - options - FavoriteProcessesClientListOptions contains the optional parameters for the FavoriteProcessesClient.NewListPager
//     method.
func (client *FavoriteProcessesClient) NewListPager(resourceGroupName string, testBaseAccountName string, packageName string, options *FavoriteProcessesClientListOptions) *runtime.Pager[FavoriteProcessesClientListResponse] {
	return runtime.NewPager(runtime.PagingHandler[FavoriteProcessesClientListResponse]{
		More: func(page FavoriteProcessesClientListResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *FavoriteProcessesClientListResponse) (FavoriteProcessesClientListResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "FavoriteProcessesClient.NewListPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listCreateRequest(ctx, resourceGroupName, testBaseAccountName, packageName, options)
			}, nil)
			if err != nil {
				return FavoriteProcessesClientListResponse{}, err
			}
			return client.listHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listCreateRequest creates the List request.
func (client *FavoriteProcessesClient) listCreateRequest(ctx context.Context, resourceGroupName string, testBaseAccountName string, packageName string, options *FavoriteProcessesClientListOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.TestBase/testBaseAccounts/{testBaseAccountName}/packages/{packageName}/favoriteProcesses"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if testBaseAccountName == "" {
		return nil, errors.New("parameter testBaseAccountName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{testBaseAccountName}", url.PathEscape(testBaseAccountName))
	if packageName == "" {
		return nil, errors.New("parameter packageName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{packageName}", url.PathEscape(packageName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-12-16-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listHandleResponse handles the List response.
func (client *FavoriteProcessesClient) listHandleResponse(resp *http.Response) (FavoriteProcessesClientListResponse, error) {
	result := FavoriteProcessesClientListResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.FavoriteProcessListResult); err != nil {
		return FavoriteProcessesClientListResponse{}, err
	}
	return result, nil
}
