//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armstreamanalytics_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/streamanalytics/armstreamanalytics/v2"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/fa469a1157c33837a46c9bcd524527e94125189a/specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Output_Create_DeltaLake.json
func ExampleOutputsClient_CreateOrReplace_createADeltaLakeOutput() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstreamanalytics.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewOutputsClient().CreateOrReplace(ctx, "sjrg", "sjName", "output1221", armstreamanalytics.Output{
		Properties: &armstreamanalytics.OutputProperties{
			Datasource: &armstreamanalytics.BlobOutputDataSource{
				Type: to.Ptr("Microsoft.Storage/Blob"),
				Properties: &armstreamanalytics.BlobOutputDataSourceProperties{
					Container: to.Ptr("deltaoutput"),
					StorageAccounts: []*armstreamanalytics.StorageAccount{
						{
							AccountKey:  to.Ptr("accountKey=="),
							AccountName: to.Ptr("someAccountName"),
						}},
				},
			},
			Serialization: &armstreamanalytics.DeltaSerialization{
				Type: to.Ptr(armstreamanalytics.EventSerializationTypeDelta),
				Properties: &armstreamanalytics.DeltaSerializationProperties{
					DeltaTablePath: to.Ptr("/folder1/table1"),
					PartitionColumns: []*string{
						to.Ptr("column1")},
				},
			},
		},
	}, &armstreamanalytics.OutputsClientCreateOrReplaceOptions{IfMatch: nil,
		IfNoneMatch: nil,
	})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Output = armstreamanalytics.Output{
	// 	Name: to.Ptr("output1221"),
	// 	Type: to.Ptr("Microsoft.StreamAnalytics/streamingjobs/outputs"),
	// 	ID: to.Ptr("/subscriptions/56b5e0a9-b645-407d-99b0-c64f86013e3d/resourceGroups/sjrg/providers/Microsoft.StreamAnalytics/streamingjobs/sjName/outputs/output1221"),
	// 	Properties: &armstreamanalytics.OutputProperties{
	// 		Datasource: &armstreamanalytics.BlobOutputDataSource{
	// 			Type: to.Ptr("Microsoft.Storage/Blob"),
	// 			Properties: &armstreamanalytics.BlobOutputDataSourceProperties{
	// 				Container: to.Ptr("deltaoutput"),
	// 				StorageAccounts: []*armstreamanalytics.StorageAccount{
	// 					{
	// 						AccountName: to.Ptr("someAccountName"),
	// 				}},
	// 			},
	// 		},
	// 		Serialization: &armstreamanalytics.DeltaSerialization{
	// 			Type: to.Ptr(armstreamanalytics.EventSerializationTypeDelta),
	// 			Properties: &armstreamanalytics.DeltaSerializationProperties{
	// 				DeltaTablePath: to.Ptr("/folder1/table1"),
	// 				PartitionColumns: []*string{
	// 					to.Ptr("column1")},
	// 				},
	// 			},
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/fa469a1157c33837a46c9bcd524527e94125189a/specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Output_Create_DocumentDB.json
func ExampleOutputsClient_CreateOrReplace_createADocumentDbOutput() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstreamanalytics.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewOutputsClient().CreateOrReplace(ctx, "sjrg7983", "sj2331", "output3022", armstreamanalytics.Output{
		Properties: &armstreamanalytics.OutputProperties{
			Datasource: &armstreamanalytics.DocumentDbOutputDataSource{
				Type: to.Ptr("Microsoft.Storage/DocumentDB"),
				Properties: &armstreamanalytics.DocumentDbOutputDataSourceProperties{
					AccountID:             to.Ptr("someAccountId"),
					AccountKey:            to.Ptr("accountKey=="),
					AuthenticationMode:    to.Ptr(armstreamanalytics.AuthenticationModeMsi),
					CollectionNamePattern: to.Ptr("collection"),
					Database:              to.Ptr("db01"),
					DocumentID:            to.Ptr("documentId"),
					PartitionKey:          to.Ptr("key"),
				},
			},
		},
	}, &armstreamanalytics.OutputsClientCreateOrReplaceOptions{IfMatch: nil,
		IfNoneMatch: nil,
	})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Output = armstreamanalytics.Output{
	// 	Name: to.Ptr("output3022"),
	// 	Type: to.Ptr("Microsoft.StreamAnalytics/streamingjobs/outputs"),
	// 	ID: to.Ptr("/subscriptions/56b5e0a9-b645-407d-99b0-c64f86013e3d/resourceGroups/sjrg7983/providers/Microsoft.StreamAnalytics/streamingjobs/sj2331/outputs/output3022"),
	// 	Properties: &armstreamanalytics.OutputProperties{
	// 		Datasource: &armstreamanalytics.DocumentDbOutputDataSource{
	// 			Type: to.Ptr("Microsoft.Storage/DocumentDB"),
	// 			Properties: &armstreamanalytics.DocumentDbOutputDataSourceProperties{
	// 				AccountID: to.Ptr("someAccountId"),
	// 				CollectionNamePattern: to.Ptr("collection"),
	// 				Database: to.Ptr("db01"),
	// 				DocumentID: to.Ptr("documentId"),
	// 				PartitionKey: to.Ptr("key"),
	// 			},
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/fa469a1157c33837a46c9bcd524527e94125189a/specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Output_Create_GatewayMessageBus.json
func ExampleOutputsClient_CreateOrReplace_createAGatewayMessageBusOutput() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstreamanalytics.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewOutputsClient().CreateOrReplace(ctx, "sjrg7983", "sj2331", "output3022", armstreamanalytics.Output{
		Properties: &armstreamanalytics.OutputProperties{
			Datasource: &armstreamanalytics.GatewayMessageBusOutputDataSource{
				Type: to.Ptr("GatewayMessageBus"),
				Properties: &armstreamanalytics.GatewayMessageBusOutputDataSourceProperties{
					Topic: to.Ptr("EdgeTopic1"),
				},
			},
		},
	}, &armstreamanalytics.OutputsClientCreateOrReplaceOptions{IfMatch: nil,
		IfNoneMatch: nil,
	})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Output = armstreamanalytics.Output{
	// 	Name: to.Ptr("output3022"),
	// 	Type: to.Ptr("Microsoft.StreamAnalytics/streamingjobs/outputs"),
	// 	ID: to.Ptr("/subscriptions/56b5e0a9-b645-407d-99b0-c64f86013e3d/resourceGroups/sjrg7983/providers/Microsoft.StreamAnalytics/streamingjobs/sj2331/outputs/output3022"),
	// 	Properties: &armstreamanalytics.OutputProperties{
	// 		Datasource: &armstreamanalytics.GatewayMessageBusOutputDataSource{
	// 			Type: to.Ptr("GatewayMessageBus"),
	// 			Properties: &armstreamanalytics.GatewayMessageBusOutputDataSourceProperties{
	// 				Topic: to.Ptr("EdgeTopic1"),
	// 			},
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/fa469a1157c33837a46c9bcd524527e94125189a/specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Output_Create_PostgreSQL.json
func ExampleOutputsClient_CreateOrReplace_createAPostgreSqlOutput() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstreamanalytics.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewOutputsClient().CreateOrReplace(ctx, "sjrg7983", "sj2331", "output3022", armstreamanalytics.Output{
		Properties: &armstreamanalytics.OutputProperties{
			Datasource: &armstreamanalytics.PostgreSQLOutputDataSource{
				Type: to.Ptr("Microsoft.DBForPostgreSQL/servers/databases"),
				Properties: &armstreamanalytics.PostgreSQLOutputDataSourceProperties{
					AuthenticationMode: to.Ptr(armstreamanalytics.AuthenticationModeMsi),
					Database:           to.Ptr("someDatabase"),
					MaxWriterCount:     to.Ptr[float32](1),
					Password:           to.Ptr("somePassword"),
					Server:             to.Ptr("someServer"),
					Table:              to.Ptr("someTable"),
					User:               to.Ptr("user"),
				},
			},
		},
	}, &armstreamanalytics.OutputsClientCreateOrReplaceOptions{IfMatch: nil,
		IfNoneMatch: nil,
	})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Output = armstreamanalytics.Output{
	// 	Name: to.Ptr("output3022"),
	// 	Type: to.Ptr("Microsoft.StreamAnalytics/streamingjobs/outputs"),
	// 	ID: to.Ptr("/subscriptions/56b5e0a9-b645-407d-99b0-c64f86013e3d/resourceGroups/sjrg7983/providers/Microsoft.StreamAnalytics/streamingjobs/sj2331/outputs/output3022"),
	// 	Properties: &armstreamanalytics.OutputProperties{
	// 		Datasource: &armstreamanalytics.PostgreSQLOutputDataSource{
	// 			Type: to.Ptr("Microsoft.DBForPostgreSQL/servers/databases"),
	// 			Properties: &armstreamanalytics.PostgreSQLOutputDataSourceProperties{
	// 				AuthenticationMode: to.Ptr(armstreamanalytics.AuthenticationModeMsi),
	// 				Database: to.Ptr("someDatabase"),
	// 				MaxWriterCount: to.Ptr[float32](1),
	// 				Server: to.Ptr("someServer"),
	// 				Table: to.Ptr("someTable"),
	// 				User: to.Ptr("user"),
	// 			},
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/fa469a1157c33837a46c9bcd524527e94125189a/specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Output_Create_PowerBI.json
func ExampleOutputsClient_CreateOrReplace_createAPowerBiOutput() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstreamanalytics.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewOutputsClient().CreateOrReplace(ctx, "sjrg7983", "sj2331", "output3022", armstreamanalytics.Output{
		Properties: &armstreamanalytics.OutputProperties{
			Datasource: &armstreamanalytics.PowerBIOutputDataSource{
				Type: to.Ptr("PowerBI"),
				Properties: &armstreamanalytics.PowerBIOutputDataSourceProperties{
					RefreshToken:           to.Ptr("someRefreshToken=="),
					TokenUserDisplayName:   to.Ptr("Bob Smith"),
					TokenUserPrincipalName: to.Ptr("bobsmith@contoso.com"),
					Dataset:                to.Ptr("someDataset"),
					GroupID:                to.Ptr("ac40305e-3e8d-43ac-8161-c33799f43e95"),
					GroupName:              to.Ptr("MyPowerBIGroup"),
					Table:                  to.Ptr("someTable"),
				},
			},
		},
	}, &armstreamanalytics.OutputsClientCreateOrReplaceOptions{IfMatch: nil,
		IfNoneMatch: nil,
	})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Output = armstreamanalytics.Output{
	// 	Name: to.Ptr("output3022"),
	// 	Type: to.Ptr("Microsoft.StreamAnalytics/streamingjobs/outputs"),
	// 	ID: to.Ptr("/subscriptions/56b5e0a9-b645-407d-99b0-c64f86013e3d/resourceGroups/sjrg7983/providers/Microsoft.StreamAnalytics/streamingjobs/sj2331/outputs/output3022"),
	// 	Properties: &armstreamanalytics.OutputProperties{
	// 		Datasource: &armstreamanalytics.PowerBIOutputDataSource{
	// 			Type: to.Ptr("PowerBI"),
	// 			Properties: &armstreamanalytics.PowerBIOutputDataSourceProperties{
	// 				TokenUserDisplayName: to.Ptr("Bob Smith"),
	// 				TokenUserPrincipalName: to.Ptr("bobsmith@contoso.com"),
	// 				Dataset: to.Ptr("someDataset"),
	// 				GroupID: to.Ptr("ac40305e-3e8d-43ac-8161-c33799f43e95"),
	// 				GroupName: to.Ptr("MyPowerBIGroup"),
	// 				Table: to.Ptr("someTable"),
	// 			},
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/fa469a1157c33837a46c9bcd524527e94125189a/specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Output_Create_ServiceBusQueue_Avro.json
func ExampleOutputsClient_CreateOrReplace_createAServiceBusQueueOutputWithAvroSerialization() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstreamanalytics.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewOutputsClient().CreateOrReplace(ctx, "sjrg3410", "sj5095", "output3456", armstreamanalytics.Output{
		Properties: &armstreamanalytics.OutputProperties{
			Datasource: &armstreamanalytics.ServiceBusQueueOutputDataSource{
				Type: to.Ptr("Microsoft.ServiceBus/Queue"),
				Properties: &armstreamanalytics.ServiceBusQueueOutputDataSourceProperties{
					ServiceBusNamespace:    to.Ptr("sdktest"),
					SharedAccessPolicyKey:  to.Ptr("sharedAccessPolicyKey="),
					SharedAccessPolicyName: to.Ptr("RootManageSharedAccessKey"),
					PropertyColumns: []*string{
						to.Ptr("column1"),
						to.Ptr("column2")},
					QueueName: to.Ptr("sdkqueue"),
					SystemPropertyColumns: map[string]any{
						"MessageId":    "col3",
						"PartitionKey": "col4",
					},
				},
			},
			Serialization: &armstreamanalytics.AvroSerialization{
				Type: to.Ptr(armstreamanalytics.EventSerializationTypeAvro),
			},
		},
	}, &armstreamanalytics.OutputsClientCreateOrReplaceOptions{IfMatch: nil,
		IfNoneMatch: nil,
	})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Output = armstreamanalytics.Output{
	// 	Name: to.Ptr("output3456"),
	// 	Type: to.Ptr("Microsoft.StreamAnalytics/streamingjobs/outputs"),
	// 	ID: to.Ptr("/subscriptions/56b5e0a9-b645-407d-99b0-c64f86013e3d/resourceGroups/sjrg3410/providers/Microsoft.StreamAnalytics/streamingjobs/sj5095/outputs/output3456"),
	// 	Properties: &armstreamanalytics.OutputProperties{
	// 		Datasource: &armstreamanalytics.ServiceBusQueueOutputDataSource{
	// 			Type: to.Ptr("Microsoft.ServiceBus/Queue"),
	// 			Properties: &armstreamanalytics.ServiceBusQueueOutputDataSourceProperties{
	// 				ServiceBusNamespace: to.Ptr("sdktest"),
	// 				SharedAccessPolicyName: to.Ptr("RootManageSharedAccessKey"),
	// 				PropertyColumns: []*string{
	// 					to.Ptr("column1"),
	// 					to.Ptr("column2")},
	// 					QueueName: to.Ptr("sdkqueue"),
	// 				},
	// 			},
	// 			Serialization: &armstreamanalytics.AvroSerialization{
	// 				Type: to.Ptr(armstreamanalytics.EventSerializationTypeAvro),
	// 				Properties: map[string]any{
	// 				},
	// 			},
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/fa469a1157c33837a46c9bcd524527e94125189a/specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Output_Create_ServiceBusTopic_CSV.json
func ExampleOutputsClient_CreateOrReplace_createAServiceBusTopicOutputWithCsvSerialization() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstreamanalytics.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewOutputsClient().CreateOrReplace(ctx, "sjrg6450", "sj7094", "output7886", armstreamanalytics.Output{
		Properties: &armstreamanalytics.OutputProperties{
			Datasource: &armstreamanalytics.ServiceBusTopicOutputDataSource{
				Type: to.Ptr("Microsoft.ServiceBus/Topic"),
				Properties: &armstreamanalytics.ServiceBusTopicOutputDataSourceProperties{
					ServiceBusNamespace:    to.Ptr("sdktest"),
					SharedAccessPolicyKey:  to.Ptr("sharedAccessPolicyKey="),
					SharedAccessPolicyName: to.Ptr("RootManageSharedAccessKey"),
					PropertyColumns: []*string{
						to.Ptr("column1"),
						to.Ptr("column2")},
					TopicName: to.Ptr("sdktopic"),
				},
			},
			Serialization: &armstreamanalytics.CSVSerialization{
				Type: to.Ptr(armstreamanalytics.EventSerializationTypeCSV),
				Properties: &armstreamanalytics.CSVSerializationProperties{
					Encoding:       to.Ptr(armstreamanalytics.EncodingUTF8),
					FieldDelimiter: to.Ptr(","),
				},
			},
		},
	}, &armstreamanalytics.OutputsClientCreateOrReplaceOptions{IfMatch: nil,
		IfNoneMatch: nil,
	})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Output = armstreamanalytics.Output{
	// 	Name: to.Ptr("output7886"),
	// 	Type: to.Ptr("Microsoft.StreamAnalytics/streamingjobs/outputs"),
	// 	ID: to.Ptr("/subscriptions/56b5e0a9-b645-407d-99b0-c64f86013e3d/resourceGroups/sjrg6450/providers/Microsoft.StreamAnalytics/streamingjobs/sj7094/outputs/output7886"),
	// 	Properties: &armstreamanalytics.OutputProperties{
	// 		Datasource: &armstreamanalytics.ServiceBusTopicOutputDataSource{
	// 			Type: to.Ptr("Microsoft.ServiceBus/Topic"),
	// 			Properties: &armstreamanalytics.ServiceBusTopicOutputDataSourceProperties{
	// 				ServiceBusNamespace: to.Ptr("sdktest"),
	// 				SharedAccessPolicyName: to.Ptr("RootManageSharedAccessKey"),
	// 				PropertyColumns: []*string{
	// 					to.Ptr("column1"),
	// 					to.Ptr("column2")},
	// 					TopicName: to.Ptr("sdktopic"),
	// 				},
	// 			},
	// 			Serialization: &armstreamanalytics.CSVSerialization{
	// 				Type: to.Ptr(armstreamanalytics.EventSerializationTypeCSV),
	// 				Properties: &armstreamanalytics.CSVSerializationProperties{
	// 					Encoding: to.Ptr(armstreamanalytics.EncodingUTF8),
	// 					FieldDelimiter: to.Ptr(","),
	// 				},
	// 			},
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/fa469a1157c33837a46c9bcd524527e94125189a/specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Output_Create_Blob_CSV.json
func ExampleOutputsClient_CreateOrReplace_createABlobOutputWithCsvSerialization() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstreamanalytics.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewOutputsClient().CreateOrReplace(ctx, "sjrg5023", "sj900", "output1623", armstreamanalytics.Output{
		Properties: &armstreamanalytics.OutputProperties{
			Datasource: &armstreamanalytics.BlobOutputDataSource{
				Type: to.Ptr("Microsoft.Storage/Blob"),
				Properties: &armstreamanalytics.BlobOutputDataSourceProperties{
					Container:   to.Ptr("state"),
					DateFormat:  to.Ptr("yyyy/MM/dd"),
					PathPattern: to.Ptr("{date}/{time}"),
					StorageAccounts: []*armstreamanalytics.StorageAccount{
						{
							AccountKey:  to.Ptr("accountKey=="),
							AccountName: to.Ptr("someAccountName"),
						}},
					TimeFormat:     to.Ptr("HH"),
					BlobPathPrefix: to.Ptr("my/path"),
					BlobWriteMode:  to.Ptr(armstreamanalytics.BlobWriteModeOnce),
				},
			},
			Serialization: &armstreamanalytics.CSVSerialization{
				Type: to.Ptr(armstreamanalytics.EventSerializationTypeCSV),
				Properties: &armstreamanalytics.CSVSerializationProperties{
					Encoding:       to.Ptr(armstreamanalytics.EncodingUTF8),
					FieldDelimiter: to.Ptr(","),
				},
			},
		},
	}, &armstreamanalytics.OutputsClientCreateOrReplaceOptions{IfMatch: nil,
		IfNoneMatch: nil,
	})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Output = armstreamanalytics.Output{
	// 	Name: to.Ptr("output1623"),
	// 	Type: to.Ptr("Microsoft.StreamAnalytics/streamingjobs/outputs"),
	// 	ID: to.Ptr("/subscriptions/56b5e0a9-b645-407d-99b0-c64f86013e3d/resourceGroups/sjrg5023/providers/Microsoft.StreamAnalytics/streamingjobs/sj900/outputs/output1623"),
	// 	Properties: &armstreamanalytics.OutputProperties{
	// 		Datasource: &armstreamanalytics.BlobOutputDataSource{
	// 			Type: to.Ptr("Microsoft.Storage/Blob"),
	// 			Properties: &armstreamanalytics.BlobOutputDataSourceProperties{
	// 				Container: to.Ptr("state"),
	// 				DateFormat: to.Ptr("yyyy/MM/dd"),
	// 				PathPattern: to.Ptr("{date}/{time}"),
	// 				StorageAccounts: []*armstreamanalytics.StorageAccount{
	// 					{
	// 						AccountName: to.Ptr("someAccountName"),
	// 				}},
	// 				TimeFormat: to.Ptr("HH"),
	// 			},
	// 		},
	// 		Serialization: &armstreamanalytics.CSVSerialization{
	// 			Type: to.Ptr(armstreamanalytics.EventSerializationTypeCSV),
	// 			Properties: &armstreamanalytics.CSVSerializationProperties{
	// 				Encoding: to.Ptr(armstreamanalytics.EncodingUTF8),
	// 				FieldDelimiter: to.Ptr(","),
	// 			},
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/fa469a1157c33837a46c9bcd524527e94125189a/specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Output_Create_AzureDataExplorer.json
func ExampleOutputsClient_CreateOrReplace_createAnAzureDataExplorerOutput() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstreamanalytics.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewOutputsClient().CreateOrReplace(ctx, "sjrg", "sjName", "adxOutput", armstreamanalytics.Output{
		Properties: &armstreamanalytics.OutputProperties{
			Datasource: &armstreamanalytics.AzureDataExplorerOutputDataSource{
				Type: to.Ptr("Microsoft.Kusto/clusters/databases"),
				Properties: &armstreamanalytics.AzureDataExplorerOutputDataSourceProperties{
					AuthenticationMode: to.Ptr(armstreamanalytics.AuthenticationModeMsi),
					Cluster:            to.Ptr("https://asakustotest.eastus.kusto.windows.net"),
					Database:           to.Ptr("dbname"),
					Table:              to.Ptr("mytable"),
				},
			},
		},
	}, &armstreamanalytics.OutputsClientCreateOrReplaceOptions{IfMatch: nil,
		IfNoneMatch: nil,
	})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Output = armstreamanalytics.Output{
	// 	Name: to.Ptr("adxOutput"),
	// 	Type: to.Ptr("Microsoft.StreamAnalytics/streamingjobs/outputs"),
	// 	ID: to.Ptr("/subscriptions/7f31cba8-b597-4129-b158-8f21a7395bd0/resourceGroups/sjrg/providers/Microsoft.StreamAnalytics/streamingjobs/sjName/outputs/adxOutput"),
	// 	Properties: &armstreamanalytics.OutputProperties{
	// 		Datasource: &armstreamanalytics.AzureDataExplorerOutputDataSource{
	// 			Type: to.Ptr("Microsoft.Kusto/clusters/databases"),
	// 			Properties: &armstreamanalytics.AzureDataExplorerOutputDataSourceProperties{
	// 				AuthenticationMode: to.Ptr(armstreamanalytics.AuthenticationModeMsi),
	// 				Cluster: to.Ptr("https://asakustotest.eastus.kusto.windows.net"),
	// 				Database: to.Ptr("dbname"),
	// 				Table: to.Ptr("mytable"),
	// 			},
	// 		},
	// 		Etag: to.Ptr("7b912929-346d-432e-9495-6972dbd63179"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/fa469a1157c33837a46c9bcd524527e94125189a/specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Output_Create_AzureDataLakeStore_JSON.json
func ExampleOutputsClient_CreateOrReplace_createAnAzureDataLakeStoreOutputWithJsonSerialization() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstreamanalytics.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewOutputsClient().CreateOrReplace(ctx, "sjrg6912", "sj3310", "output5195", armstreamanalytics.Output{
		Properties: &armstreamanalytics.OutputProperties{
			Datasource: &armstreamanalytics.AzureDataLakeStoreOutputDataSource{
				Type: to.Ptr("Microsoft.DataLake/Accounts"),
				Properties: &armstreamanalytics.AzureDataLakeStoreOutputDataSourceProperties{
					RefreshToken:           to.Ptr("someRefreshToken=="),
					TokenUserDisplayName:   to.Ptr("Bob Smith"),
					TokenUserPrincipalName: to.Ptr("bobsmith@contoso.com"),
					AccountName:            to.Ptr("someaccount"),
					DateFormat:             to.Ptr("yyyy/MM/dd"),
					FilePathPrefix:         to.Ptr("{date}/{time}"),
					TenantID:               to.Ptr("cea4e98b-c798-49e7-8c40-4a2b3beb47dd"),
					TimeFormat:             to.Ptr("HH"),
				},
			},
			Serialization: &armstreamanalytics.JSONSerialization{
				Type: to.Ptr(armstreamanalytics.EventSerializationTypeJSON),
				Properties: &armstreamanalytics.JSONSerializationProperties{
					Format:   to.Ptr(armstreamanalytics.JSONOutputSerializationFormatArray),
					Encoding: to.Ptr(armstreamanalytics.EncodingUTF8),
				},
			},
		},
	}, &armstreamanalytics.OutputsClientCreateOrReplaceOptions{IfMatch: nil,
		IfNoneMatch: nil,
	})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Output = armstreamanalytics.Output{
	// 	Name: to.Ptr("output5195"),
	// 	Type: to.Ptr("Microsoft.StreamAnalytics/streamingjobs/outputs"),
	// 	ID: to.Ptr("/subscriptions/56b5e0a9-b645-407d-99b0-c64f86013e3d/resourceGroups/sjrg6912/providers/Microsoft.StreamAnalytics/streamingjobs/sj3310/outputs/output5195"),
	// 	Properties: &armstreamanalytics.OutputProperties{
	// 		Datasource: &armstreamanalytics.AzureDataLakeStoreOutputDataSource{
	// 			Type: to.Ptr("Microsoft.DataLake/Accounts"),
	// 			Properties: &armstreamanalytics.AzureDataLakeStoreOutputDataSourceProperties{
	// 				TokenUserDisplayName: to.Ptr("Bob Smith"),
	// 				TokenUserPrincipalName: to.Ptr("bobsmith@contoso.com"),
	// 				AccountName: to.Ptr("someaccount"),
	// 				DateFormat: to.Ptr("yyyy/MM/dd"),
	// 				FilePathPrefix: to.Ptr("{date}/{time}"),
	// 				TenantID: to.Ptr("cea4e98b-c798-49e7-8c40-4a2b3beb47dd"),
	// 				TimeFormat: to.Ptr("HH"),
	// 			},
	// 		},
	// 		Serialization: &armstreamanalytics.JSONSerialization{
	// 			Type: to.Ptr(armstreamanalytics.EventSerializationTypeJSON),
	// 			Properties: &armstreamanalytics.JSONSerializationProperties{
	// 				Format: to.Ptr(armstreamanalytics.JSONOutputSerializationFormatArray),
	// 				Encoding: to.Ptr(armstreamanalytics.EncodingUTF8),
	// 			},
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/fa469a1157c33837a46c9bcd524527e94125189a/specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Output_Create_DataWarehouse.json
func ExampleOutputsClient_CreateOrReplace_createAnAzureDataWarehouseOutput() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstreamanalytics.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewOutputsClient().CreateOrReplace(ctx, "sjrg", "sjName", "dwOutput", armstreamanalytics.Output{
		Properties: &armstreamanalytics.OutputProperties{
			Datasource: &armstreamanalytics.AzureSynapseOutputDataSource{
				Type: to.Ptr("Microsoft.Sql/Server/DataWarehouse"),
				Properties: &armstreamanalytics.AzureSynapseOutputDataSourceProperties{
					AuthenticationMode: to.Ptr(armstreamanalytics.AuthenticationModeMsi),
					Database:           to.Ptr("zhayaSQLpool"),
					Password:           to.Ptr("password123"),
					Server:             to.Ptr("asatestserver"),
					Table:              to.Ptr("test2"),
					User:               to.Ptr("tolladmin"),
				},
			},
		},
	}, &armstreamanalytics.OutputsClientCreateOrReplaceOptions{IfMatch: nil,
		IfNoneMatch: nil,
	})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Output = armstreamanalytics.Output{
	// 	Name: to.Ptr("dwOutput"),
	// 	Type: to.Ptr("Microsoft.StreamAnalytics/streamingjobs/outputs"),
	// 	ID: to.Ptr("/subscriptions/56b5e0a9-b645-407d-99b0-c64f86013e3d/resourceGroups/sjrg/providers/Microsoft.StreamAnalytics/streamingjobs/sjName/outputs/dwOutput"),
	// 	Properties: &armstreamanalytics.OutputProperties{
	// 		Datasource: &armstreamanalytics.AzureSynapseOutputDataSource{
	// 			Type: to.Ptr("Microsoft.Sql/Server/DataWarehouse"),
	// 			Properties: &armstreamanalytics.AzureSynapseOutputDataSourceProperties{
	// 				Database: to.Ptr("zhayaSQLpool"),
	// 				Server: to.Ptr("asatestserver"),
	// 				Table: to.Ptr("test2"),
	// 				User: to.Ptr("tolladmin"),
	// 			},
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/fa469a1157c33837a46c9bcd524527e94125189a/specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Output_Create_AzureFunction.json
func ExampleOutputsClient_CreateOrReplace_createAnAzureFunctionOutput() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstreamanalytics.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewOutputsClient().CreateOrReplace(ctx, "sjrg", "sjName", "azureFunction1", armstreamanalytics.Output{
		Properties: &armstreamanalytics.OutputProperties{
			Datasource: &armstreamanalytics.AzureFunctionOutputDataSource{
				Type: to.Ptr("Microsoft.AzureFunction"),
				Properties: &armstreamanalytics.AzureFunctionOutputDataSourceProperties{
					FunctionAppName: to.Ptr("functionappforasaautomation"),
					FunctionName:    to.Ptr("HttpTrigger2"),
					MaxBatchCount:   to.Ptr[float32](100),
					MaxBatchSize:    to.Ptr[float32](256),
				},
			},
		},
	}, &armstreamanalytics.OutputsClientCreateOrReplaceOptions{IfMatch: nil,
		IfNoneMatch: nil,
	})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Output = armstreamanalytics.Output{
	// 	Name: to.Ptr("azureFunction1"),
	// 	Type: to.Ptr("Microsoft.StreamAnalytics/streamingjobs/outputs"),
	// 	ID: to.Ptr("/subscriptions/7f31cba8-b597-4129-b158-8f21a7395bd0/resourceGroups/sjrg/providers/Microsoft.StreamAnalytics/streamingjobs/sjName/outputs/azureFunction1"),
	// 	Properties: &armstreamanalytics.OutputProperties{
	// 		Datasource: &armstreamanalytics.AzureFunctionOutputDataSource{
	// 			Type: to.Ptr("Microsoft.AzureFunction"),
	// 			Properties: &armstreamanalytics.AzureFunctionOutputDataSourceProperties{
	// 				FunctionAppName: to.Ptr("functionappforasaautomation"),
	// 				FunctionName: to.Ptr("HttpTrigger2"),
	// 				MaxBatchCount: to.Ptr[float32](100),
	// 				MaxBatchSize: to.Ptr[float32](256),
	// 			},
	// 		},
	// 		Etag: to.Ptr("7b912929-346d-432e-9495-6972dbd63179"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/fa469a1157c33837a46c9bcd524527e94125189a/specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Output_Create_AzureSQL.json
func ExampleOutputsClient_CreateOrReplace_createAnAzureSqlDatabaseOutput() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstreamanalytics.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewOutputsClient().CreateOrReplace(ctx, "sjrg2157", "sj6458", "output1755", armstreamanalytics.Output{
		Properties: &armstreamanalytics.OutputProperties{
			Datasource: &armstreamanalytics.AzureSQLDatabaseOutputDataSource{
				Type: to.Ptr("Microsoft.Sql/Server/Database"),
				Properties: &armstreamanalytics.AzureSQLDatabaseOutputDataSourceProperties{
					Database: to.Ptr("someDatabase"),
					Password: to.Ptr("somePassword"),
					Server:   to.Ptr("someServer"),
					Table:    to.Ptr("someTable"),
					User:     to.Ptr("<user>"),
				},
			},
		},
	}, &armstreamanalytics.OutputsClientCreateOrReplaceOptions{IfMatch: nil,
		IfNoneMatch: nil,
	})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Output = armstreamanalytics.Output{
	// 	Name: to.Ptr("output1755"),
	// 	Type: to.Ptr("Microsoft.StreamAnalytics/streamingjobs/outputs"),
	// 	ID: to.Ptr("/subscriptions/56b5e0a9-b645-407d-99b0-c64f86013e3d/resourceGroups/sjrg2157/providers/Microsoft.StreamAnalytics/streamingjobs/sj6458/outputs/output1755"),
	// 	Properties: &armstreamanalytics.OutputProperties{
	// 		Datasource: &armstreamanalytics.AzureSQLDatabaseOutputDataSource{
	// 			Type: to.Ptr("Microsoft.Sql/Server/Database"),
	// 			Properties: &armstreamanalytics.AzureSQLDatabaseOutputDataSourceProperties{
	// 				Database: to.Ptr("someDatabase"),
	// 				Server: to.Ptr("someServer"),
	// 				Table: to.Ptr("someTable"),
	// 				User: to.Ptr("someUser"),
	// 			},
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/fa469a1157c33837a46c9bcd524527e94125189a/specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Output_Create_AzureTable.json
func ExampleOutputsClient_CreateOrReplace_createAnAzureTableOutput() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstreamanalytics.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewOutputsClient().CreateOrReplace(ctx, "sjrg5176", "sj2790", "output958", armstreamanalytics.Output{
		Properties: &armstreamanalytics.OutputProperties{
			Datasource: &armstreamanalytics.AzureTableOutputDataSource{
				Type: to.Ptr("Microsoft.Storage/Table"),
				Properties: &armstreamanalytics.AzureTableOutputDataSourceProperties{
					AccountKey:  to.Ptr("accountKey=="),
					AccountName: to.Ptr("someAccountName"),
					BatchSize:   to.Ptr[int32](25),
					ColumnsToRemove: []*string{
						to.Ptr("column1"),
						to.Ptr("column2")},
					PartitionKey: to.Ptr("partitionKey"),
					RowKey:       to.Ptr("rowKey"),
					Table:        to.Ptr("samples"),
				},
			},
		},
	}, &armstreamanalytics.OutputsClientCreateOrReplaceOptions{IfMatch: nil,
		IfNoneMatch: nil,
	})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Output = armstreamanalytics.Output{
	// 	Name: to.Ptr("output958"),
	// 	Type: to.Ptr("Microsoft.StreamAnalytics/streamingjobs/outputs"),
	// 	ID: to.Ptr("/subscriptions/56b5e0a9-b645-407d-99b0-c64f86013e3d/resourceGroups/sjrg5176/providers/Microsoft.StreamAnalytics/streamingjobs/sj2790/outputs/output958"),
	// 	Properties: &armstreamanalytics.OutputProperties{
	// 		Datasource: &armstreamanalytics.AzureTableOutputDataSource{
	// 			Type: to.Ptr("Microsoft.Storage/Table"),
	// 			Properties: &armstreamanalytics.AzureTableOutputDataSourceProperties{
	// 				AccountName: to.Ptr("someAccountName"),
	// 				BatchSize: to.Ptr[int32](25),
	// 				ColumnsToRemove: []*string{
	// 					to.Ptr("column1"),
	// 					to.Ptr("column2")},
	// 					PartitionKey: to.Ptr("partitionKey"),
	// 					RowKey: to.Ptr("rowKey"),
	// 					Table: to.Ptr("samples"),
	// 				},
	// 			},
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/fa469a1157c33837a46c9bcd524527e94125189a/specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Output_Create_EventHub_JSON.json
func ExampleOutputsClient_CreateOrReplace_createAnEventHubOutputWithJsonSerialization() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstreamanalytics.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewOutputsClient().CreateOrReplace(ctx, "sjrg6912", "sj3310", "output5195", armstreamanalytics.Output{
		Properties: &armstreamanalytics.OutputProperties{
			Datasource: &armstreamanalytics.EventHubOutputDataSource{
				Type: to.Ptr("Microsoft.ServiceBus/EventHub"),
				Properties: &armstreamanalytics.EventHubOutputDataSourceProperties{
					ServiceBusNamespace:    to.Ptr("sdktest"),
					SharedAccessPolicyKey:  to.Ptr("sharedAccessPolicyKey="),
					SharedAccessPolicyName: to.Ptr("RootManageSharedAccessKey"),
					EventHubName:           to.Ptr("sdkeventhub"),
					PartitionKey:           to.Ptr("partitionKey"),
				},
			},
			Serialization: &armstreamanalytics.JSONSerialization{
				Type: to.Ptr(armstreamanalytics.EventSerializationTypeJSON),
				Properties: &armstreamanalytics.JSONSerializationProperties{
					Format:   to.Ptr(armstreamanalytics.JSONOutputSerializationFormatArray),
					Encoding: to.Ptr(armstreamanalytics.EncodingUTF8),
				},
			},
			WatermarkSettings: &armstreamanalytics.OutputWatermarkProperties{
				MaxWatermarkDifferenceAcrossPartitions: to.Ptr("16:14:30"),
				WatermarkMode:                          to.Ptr(armstreamanalytics.OutputWatermarkModeSendCurrentPartitionWatermark),
			},
		},
	}, &armstreamanalytics.OutputsClientCreateOrReplaceOptions{IfMatch: nil,
		IfNoneMatch: nil,
	})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Output = armstreamanalytics.Output{
	// 	Name: to.Ptr("output5195"),
	// 	Type: to.Ptr("Microsoft.StreamAnalytics/streamingjobs/outputs"),
	// 	ID: to.Ptr("/subscriptions/56b5e0a9-b645-407d-99b0-c64f86013e3d/resourceGroups/sjrg6912/providers/Microsoft.StreamAnalytics/streamingjobs/sj3310/outputs/output5195"),
	// 	Properties: &armstreamanalytics.OutputProperties{
	// 		Datasource: &armstreamanalytics.EventHubOutputDataSource{
	// 			Type: to.Ptr("Microsoft.ServiceBus/EventHub"),
	// 			Properties: &armstreamanalytics.EventHubOutputDataSourceProperties{
	// 				ServiceBusNamespace: to.Ptr("sdktest"),
	// 				SharedAccessPolicyName: to.Ptr("RootManageSharedAccessKey"),
	// 				EventHubName: to.Ptr("sdkeventhub"),
	// 				PartitionKey: to.Ptr("partitionKey"),
	// 			},
	// 		},
	// 		Serialization: &armstreamanalytics.JSONSerialization{
	// 			Type: to.Ptr(armstreamanalytics.EventSerializationTypeJSON),
	// 			Properties: &armstreamanalytics.JSONSerializationProperties{
	// 				Format: to.Ptr(armstreamanalytics.JSONOutputSerializationFormatArray),
	// 				Encoding: to.Ptr(armstreamanalytics.EncodingUTF8),
	// 			},
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/fa469a1157c33837a46c9bcd524527e94125189a/specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Output_Update_DeltaLake.json
func ExampleOutputsClient_Update_updateADeltaLakeOutput() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstreamanalytics.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewOutputsClient().Update(ctx, "sjrg", "sjName", "output1221", armstreamanalytics.Output{
		Properties: &armstreamanalytics.OutputProperties{
			Datasource: &armstreamanalytics.BlobOutputDataSource{
				Type: to.Ptr("Microsoft.Storage/Blob"),
				Properties: &armstreamanalytics.BlobOutputDataSourceProperties{
					Container: to.Ptr("deltaoutput2"),
				},
			},
			Serialization: &armstreamanalytics.DeltaSerialization{
				Type: to.Ptr(armstreamanalytics.EventSerializationTypeDelta),
				Properties: &armstreamanalytics.DeltaSerializationProperties{
					DeltaTablePath: to.Ptr("/folder1/table2"),
					PartitionColumns: []*string{
						to.Ptr("column2")},
				},
			},
		},
	}, &armstreamanalytics.OutputsClientUpdateOptions{IfMatch: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Output = armstreamanalytics.Output{
	// 	Name: to.Ptr("output1221"),
	// 	Type: to.Ptr("Microsoft.StreamAnalytics/streamingjobs/outputs"),
	// 	ID: to.Ptr("/subscriptions/56b5e0a9-b645-407d-99b0-c64f86013e3d/resourceGroups/sjrg/providers/Microsoft.StreamAnalytics/streamingjobs/sjName/outputs/output1221"),
	// 	Properties: &armstreamanalytics.OutputProperties{
	// 		Datasource: &armstreamanalytics.BlobOutputDataSource{
	// 			Type: to.Ptr("Microsoft.Storage/Blob"),
	// 			Properties: &armstreamanalytics.BlobOutputDataSourceProperties{
	// 				Container: to.Ptr("deltaoutput2"),
	// 				StorageAccounts: []*armstreamanalytics.StorageAccount{
	// 					{
	// 						AccountName: to.Ptr("someAccountName"),
	// 				}},
	// 			},
	// 		},
	// 		Serialization: &armstreamanalytics.DeltaSerialization{
	// 			Type: to.Ptr(armstreamanalytics.EventSerializationTypeDelta),
	// 			Properties: &armstreamanalytics.DeltaSerializationProperties{
	// 				DeltaTablePath: to.Ptr("/folder1/table2"),
	// 				PartitionColumns: []*string{
	// 					to.Ptr("column2")},
	// 				},
	// 			},
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/fa469a1157c33837a46c9bcd524527e94125189a/specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Output_Update_DocumentDB.json
func ExampleOutputsClient_Update_updateADocumentDbOutput() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstreamanalytics.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewOutputsClient().Update(ctx, "sjrg7983", "sj2331", "output3022", armstreamanalytics.Output{
		Properties: &armstreamanalytics.OutputProperties{
			Datasource: &armstreamanalytics.DocumentDbOutputDataSource{
				Type: to.Ptr("Microsoft.Storage/DocumentDB"),
				Properties: &armstreamanalytics.DocumentDbOutputDataSourceProperties{
					PartitionKey: to.Ptr("differentPartitionKey"),
				},
			},
		},
	}, &armstreamanalytics.OutputsClientUpdateOptions{IfMatch: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Output = armstreamanalytics.Output{
	// 	Name: to.Ptr("output3022"),
	// 	Type: to.Ptr("Microsoft.StreamAnalytics/streamingjobs/outputs"),
	// 	ID: to.Ptr("/subscriptions/56b5e0a9-b645-407d-99b0-c64f86013e3d/resourceGroups/sjrg7983/providers/Microsoft.StreamAnalytics/streamingjobs/sj2331/outputs/output3022"),
	// 	Properties: &armstreamanalytics.OutputProperties{
	// 		Datasource: &armstreamanalytics.DocumentDbOutputDataSource{
	// 			Type: to.Ptr("Microsoft.Storage/DocumentDB"),
	// 			Properties: &armstreamanalytics.DocumentDbOutputDataSourceProperties{
	// 				AccountID: to.Ptr("someAccountId"),
	// 				CollectionNamePattern: to.Ptr("collection"),
	// 				Database: to.Ptr("db01"),
	// 				DocumentID: to.Ptr("documentId"),
	// 				PartitionKey: to.Ptr("differentPartitionKey"),
	// 			},
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/fa469a1157c33837a46c9bcd524527e94125189a/specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Output_Update_PowerBI.json
func ExampleOutputsClient_Update_updateAPowerBiOutput() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstreamanalytics.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewOutputsClient().Update(ctx, "sjrg7983", "sj2331", "output3022", armstreamanalytics.Output{
		Properties: &armstreamanalytics.OutputProperties{
			Datasource: &armstreamanalytics.PowerBIOutputDataSource{
				Type: to.Ptr("PowerBI"),
				Properties: &armstreamanalytics.PowerBIOutputDataSourceProperties{
					Dataset: to.Ptr("differentDataset"),
				},
			},
		},
	}, &armstreamanalytics.OutputsClientUpdateOptions{IfMatch: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Output = armstreamanalytics.Output{
	// 	Name: to.Ptr("output3022"),
	// 	Type: to.Ptr("Microsoft.StreamAnalytics/streamingjobs/outputs"),
	// 	ID: to.Ptr("/subscriptions/56b5e0a9-b645-407d-99b0-c64f86013e3d/resourceGroups/sjrg7983/providers/Microsoft.StreamAnalytics/streamingjobs/sj2331/outputs/output3022"),
	// 	Properties: &armstreamanalytics.OutputProperties{
	// 		Datasource: &armstreamanalytics.PowerBIOutputDataSource{
	// 			Type: to.Ptr("PowerBI"),
	// 			Properties: &armstreamanalytics.PowerBIOutputDataSourceProperties{
	// 				TokenUserDisplayName: to.Ptr("Bob Smith"),
	// 				TokenUserPrincipalName: to.Ptr("bobsmith@contoso.com"),
	// 				Dataset: to.Ptr("differentDataset"),
	// 				GroupID: to.Ptr("ac40305e-3e8d-43ac-8161-c33799f43e95"),
	// 				GroupName: to.Ptr("MyPowerBIGroup"),
	// 				Table: to.Ptr("someTable"),
	// 			},
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/fa469a1157c33837a46c9bcd524527e94125189a/specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Output_Update_ServiceBusQueue.json
func ExampleOutputsClient_Update_updateAServiceBusQueueOutputWithAvroSerialization() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstreamanalytics.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewOutputsClient().Update(ctx, "sjrg3410", "sj5095", "output3456", armstreamanalytics.Output{
		Properties: &armstreamanalytics.OutputProperties{
			Datasource: &armstreamanalytics.ServiceBusQueueOutputDataSource{
				Type: to.Ptr("Microsoft.ServiceBus/Queue"),
				Properties: &armstreamanalytics.ServiceBusQueueOutputDataSourceProperties{
					QueueName: to.Ptr("differentQueueName"),
				},
			},
			Serialization: &armstreamanalytics.JSONSerialization{
				Type: to.Ptr(armstreamanalytics.EventSerializationTypeJSON),
				Properties: &armstreamanalytics.JSONSerializationProperties{
					Format:   to.Ptr(armstreamanalytics.JSONOutputSerializationFormatLineSeparated),
					Encoding: to.Ptr(armstreamanalytics.EncodingUTF8),
				},
			},
		},
	}, &armstreamanalytics.OutputsClientUpdateOptions{IfMatch: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Output = armstreamanalytics.Output{
	// 	Name: to.Ptr("output3456"),
	// 	Type: to.Ptr("Microsoft.StreamAnalytics/streamingjobs/outputs"),
	// 	ID: to.Ptr("/subscriptions/56b5e0a9-b645-407d-99b0-c64f86013e3d/resourceGroups/sjrg3410/providers/Microsoft.StreamAnalytics/streamingjobs/sj5095/outputs/output3456"),
	// 	Properties: &armstreamanalytics.OutputProperties{
	// 		Datasource: &armstreamanalytics.ServiceBusQueueOutputDataSource{
	// 			Type: to.Ptr("Microsoft.ServiceBus/Queue"),
	// 			Properties: &armstreamanalytics.ServiceBusQueueOutputDataSourceProperties{
	// 				ServiceBusNamespace: to.Ptr("sdktest"),
	// 				SharedAccessPolicyName: to.Ptr("RootManageSharedAccessKey"),
	// 				PropertyColumns: []*string{
	// 					to.Ptr("column1"),
	// 					to.Ptr("column2")},
	// 					QueueName: to.Ptr("differentQueueName"),
	// 				},
	// 			},
	// 			Serialization: &armstreamanalytics.JSONSerialization{
	// 				Type: to.Ptr(armstreamanalytics.EventSerializationTypeJSON),
	// 				Properties: &armstreamanalytics.JSONSerializationProperties{
	// 					Format: to.Ptr(armstreamanalytics.JSONOutputSerializationFormatLineSeparated),
	// 					Encoding: to.Ptr(armstreamanalytics.EncodingUTF8),
	// 				},
	// 			},
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/fa469a1157c33837a46c9bcd524527e94125189a/specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Output_Update_ServiceBusTopic.json
func ExampleOutputsClient_Update_updateAServiceBusTopicOutputWithCsvSerialization() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstreamanalytics.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewOutputsClient().Update(ctx, "sjrg6450", "sj7094", "output7886", armstreamanalytics.Output{
		Properties: &armstreamanalytics.OutputProperties{
			Datasource: &armstreamanalytics.ServiceBusTopicOutputDataSource{
				Type: to.Ptr("Microsoft.ServiceBus/Topic"),
				Properties: &armstreamanalytics.ServiceBusTopicOutputDataSourceProperties{
					TopicName: to.Ptr("differentTopicName"),
				},
			},
			Serialization: &armstreamanalytics.CSVSerialization{
				Type: to.Ptr(armstreamanalytics.EventSerializationTypeCSV),
				Properties: &armstreamanalytics.CSVSerializationProperties{
					Encoding:       to.Ptr(armstreamanalytics.EncodingUTF8),
					FieldDelimiter: to.Ptr("|"),
				},
			},
		},
	}, &armstreamanalytics.OutputsClientUpdateOptions{IfMatch: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Output = armstreamanalytics.Output{
	// 	Name: to.Ptr("output7886"),
	// 	Type: to.Ptr("Microsoft.StreamAnalytics/streamingjobs/outputs"),
	// 	ID: to.Ptr("/subscriptions/56b5e0a9-b645-407d-99b0-c64f86013e3d/resourceGroups/sjrg6450/providers/Microsoft.StreamAnalytics/streamingjobs/sj7094/outputs/output7886"),
	// 	Properties: &armstreamanalytics.OutputProperties{
	// 		Datasource: &armstreamanalytics.ServiceBusTopicOutputDataSource{
	// 			Type: to.Ptr("Microsoft.ServiceBus/Topic"),
	// 			Properties: &armstreamanalytics.ServiceBusTopicOutputDataSourceProperties{
	// 				ServiceBusNamespace: to.Ptr("sdktest"),
	// 				SharedAccessPolicyName: to.Ptr("RootManageSharedAccessKey"),
	// 				PropertyColumns: []*string{
	// 					to.Ptr("column1"),
	// 					to.Ptr("column2")},
	// 					TopicName: to.Ptr("differentTopicName"),
	// 				},
	// 			},
	// 			Serialization: &armstreamanalytics.CSVSerialization{
	// 				Type: to.Ptr(armstreamanalytics.EventSerializationTypeCSV),
	// 				Properties: &armstreamanalytics.CSVSerializationProperties{
	// 					Encoding: to.Ptr(armstreamanalytics.EncodingUTF8),
	// 					FieldDelimiter: to.Ptr("|"),
	// 				},
	// 			},
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/fa469a1157c33837a46c9bcd524527e94125189a/specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Output_Update_Blob.json
func ExampleOutputsClient_Update_updateABlobOutputWithCsvSerialization() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstreamanalytics.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewOutputsClient().Update(ctx, "sjrg5023", "sj900", "output1623", armstreamanalytics.Output{
		Properties: &armstreamanalytics.OutputProperties{
			Datasource: &armstreamanalytics.BlobOutputDataSource{
				Type: to.Ptr("Microsoft.Storage/Blob"),
				Properties: &armstreamanalytics.BlobOutputDataSourceProperties{
					Container: to.Ptr("differentContainer"),
				},
			},
			Serialization: &armstreamanalytics.CSVSerialization{
				Type: to.Ptr(armstreamanalytics.EventSerializationTypeCSV),
				Properties: &armstreamanalytics.CSVSerializationProperties{
					Encoding:       to.Ptr(armstreamanalytics.EncodingUTF8),
					FieldDelimiter: to.Ptr("|"),
				},
			},
		},
	}, &armstreamanalytics.OutputsClientUpdateOptions{IfMatch: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Output = armstreamanalytics.Output{
	// 	Name: to.Ptr("output1623"),
	// 	Type: to.Ptr("Microsoft.StreamAnalytics/streamingjobs/outputs"),
	// 	ID: to.Ptr("/subscriptions/56b5e0a9-b645-407d-99b0-c64f86013e3d/resourceGroups/sjrg5023/providers/Microsoft.StreamAnalytics/streamingjobs/sj900/outputs/output1623"),
	// 	Properties: &armstreamanalytics.OutputProperties{
	// 		Datasource: &armstreamanalytics.BlobOutputDataSource{
	// 			Type: to.Ptr("Microsoft.Storage/Blob"),
	// 			Properties: &armstreamanalytics.BlobOutputDataSourceProperties{
	// 				Container: to.Ptr("differentContainer"),
	// 				DateFormat: to.Ptr("yyyy/MM/dd"),
	// 				PathPattern: to.Ptr("{date}/{time}"),
	// 				StorageAccounts: []*armstreamanalytics.StorageAccount{
	// 					{
	// 						AccountName: to.Ptr("someAccountName"),
	// 				}},
	// 				TimeFormat: to.Ptr("HH"),
	// 			},
	// 		},
	// 		Serialization: &armstreamanalytics.CSVSerialization{
	// 			Type: to.Ptr(armstreamanalytics.EventSerializationTypeCSV),
	// 			Properties: &armstreamanalytics.CSVSerializationProperties{
	// 				Encoding: to.Ptr(armstreamanalytics.EncodingUTF8),
	// 				FieldDelimiter: to.Ptr("|"),
	// 			},
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/fa469a1157c33837a46c9bcd524527e94125189a/specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Output_Update_AzureDataLakeStore.json
func ExampleOutputsClient_Update_updateAnAzureDataLakeStoreOutputWithJsonSerialization() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstreamanalytics.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewOutputsClient().Update(ctx, "sjrg6912", "sj3310", "output5195", armstreamanalytics.Output{
		Properties: &armstreamanalytics.OutputProperties{
			Datasource: &armstreamanalytics.AzureDataLakeStoreOutputDataSource{
				Type: to.Ptr("Microsoft.DataLake/Accounts"),
				Properties: &armstreamanalytics.AzureDataLakeStoreOutputDataSourceProperties{
					AccountName: to.Ptr("differentaccount"),
				},
			},
			Serialization: &armstreamanalytics.JSONSerialization{
				Type: to.Ptr(armstreamanalytics.EventSerializationTypeJSON),
				Properties: &armstreamanalytics.JSONSerializationProperties{
					Format:   to.Ptr(armstreamanalytics.JSONOutputSerializationFormatLineSeparated),
					Encoding: to.Ptr(armstreamanalytics.EncodingUTF8),
				},
			},
		},
	}, &armstreamanalytics.OutputsClientUpdateOptions{IfMatch: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Output = armstreamanalytics.Output{
	// 	Name: to.Ptr("output5195"),
	// 	Type: to.Ptr("Microsoft.StreamAnalytics/streamingjobs/outputs"),
	// 	ID: to.Ptr("/subscriptions/56b5e0a9-b645-407d-99b0-c64f86013e3d/resourceGroups/sjrg6912/providers/Microsoft.StreamAnalytics/streamingjobs/sj3310/outputs/output5195"),
	// 	Properties: &armstreamanalytics.OutputProperties{
	// 		Datasource: &armstreamanalytics.AzureDataLakeStoreOutputDataSource{
	// 			Type: to.Ptr("Microsoft.DataLake/Accounts"),
	// 			Properties: &armstreamanalytics.AzureDataLakeStoreOutputDataSourceProperties{
	// 				TokenUserDisplayName: to.Ptr("Bob Smith"),
	// 				TokenUserPrincipalName: to.Ptr("bobsmith@contoso.com"),
	// 				AccountName: to.Ptr("differentaccount"),
	// 				DateFormat: to.Ptr("yyyy/MM/dd"),
	// 				FilePathPrefix: to.Ptr("{date}/{time}"),
	// 				TenantID: to.Ptr("cea4e98b-c798-49e7-8c40-4a2b3beb47dd"),
	// 				TimeFormat: to.Ptr("HH"),
	// 			},
	// 		},
	// 		Serialization: &armstreamanalytics.JSONSerialization{
	// 			Type: to.Ptr(armstreamanalytics.EventSerializationTypeJSON),
	// 			Properties: &armstreamanalytics.JSONSerializationProperties{
	// 				Format: to.Ptr(armstreamanalytics.JSONOutputSerializationFormatLineSeparated),
	// 				Encoding: to.Ptr(armstreamanalytics.EncodingUTF8),
	// 			},
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/fa469a1157c33837a46c9bcd524527e94125189a/specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Output_Update_DataWarehouse.json
func ExampleOutputsClient_Update_updateAnAzureDataWarehouseOutput() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstreamanalytics.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewOutputsClient().Update(ctx, "sjrg", "sjName", "dwOutput", armstreamanalytics.Output{
		Properties: &armstreamanalytics.OutputProperties{
			Datasource: &armstreamanalytics.AzureSQLDatabaseOutputDataSource{
				Type: to.Ptr("Microsoft.Sql/Server/Database"),
				Properties: &armstreamanalytics.AzureSQLDatabaseOutputDataSourceProperties{
					Table: to.Ptr("differentTable"),
				},
			},
		},
	}, &armstreamanalytics.OutputsClientUpdateOptions{IfMatch: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Output = armstreamanalytics.Output{
	// 	Name: to.Ptr("dwOutput"),
	// 	Type: to.Ptr("Microsoft.StreamAnalytics/streamingjobs/outputs"),
	// 	ID: to.Ptr("/subscriptions/56b5e0a9-b645-407d-99b0-c64f86013e3d/resourceGroups/sjrg/providers/Microsoft.StreamAnalytics/streamingjobs/sjName/outputs/dwOutput"),
	// 	Properties: &armstreamanalytics.OutputProperties{
	// 		Datasource: &armstreamanalytics.AzureSynapseOutputDataSource{
	// 			Type: to.Ptr("Microsoft.Sql/Server/DataWarehouse"),
	// 			Properties: &armstreamanalytics.AzureSynapseOutputDataSourceProperties{
	// 				Database: to.Ptr("zhayaSQLpool"),
	// 				Server: to.Ptr("asatestserver"),
	// 				Table: to.Ptr("differentTable"),
	// 				User: to.Ptr("tolladmin"),
	// 			},
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/fa469a1157c33837a46c9bcd524527e94125189a/specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Output_Update_AzureFunction.json
func ExampleOutputsClient_Update_updateAnAzureFunctionOutput() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstreamanalytics.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewOutputsClient().Update(ctx, "sjrg", "sjName", "azureFunction1", armstreamanalytics.Output{
		Properties: &armstreamanalytics.OutputProperties{
			Datasource: &armstreamanalytics.AzureFunctionOutputDataSource{
				Type: to.Ptr("Microsoft.AzureFunction"),
				Properties: &armstreamanalytics.AzureFunctionOutputDataSourceProperties{
					FunctionName: to.Ptr("differentFunctionName"),
				},
			},
		},
	}, &armstreamanalytics.OutputsClientUpdateOptions{IfMatch: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Output = armstreamanalytics.Output{
	// 	Name: to.Ptr("azureFunction1"),
	// 	Type: to.Ptr("Microsoft.StreamAnalytics/streamingjobs/outputs"),
	// 	ID: to.Ptr("/subscriptions/56b5e0a9-b645-407d-99b0-c64f86013e3d/resourceGroups/sjrg/providers/Microsoft.StreamAnalytics/streamingjobs/sjName/outputs/azureFunction1"),
	// 	Properties: &armstreamanalytics.OutputProperties{
	// 		Datasource: &armstreamanalytics.AzureFunctionOutputDataSource{
	// 			Type: to.Ptr("Microsoft.AzureFunction"),
	// 			Properties: &armstreamanalytics.AzureFunctionOutputDataSourceProperties{
	// 				FunctionAppName: to.Ptr("functionappforasaautomation"),
	// 				FunctionName: to.Ptr("differentFunctionName"),
	// 				MaxBatchCount: to.Ptr[float32](100),
	// 				MaxBatchSize: to.Ptr[float32](256),
	// 			},
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/fa469a1157c33837a46c9bcd524527e94125189a/specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Output_Update_AzureSQL.json
func ExampleOutputsClient_Update_updateAnAzureSqlDatabaseOutput() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstreamanalytics.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewOutputsClient().Update(ctx, "sjrg2157", "sj6458", "output1755", armstreamanalytics.Output{
		Properties: &armstreamanalytics.OutputProperties{
			Datasource: &armstreamanalytics.AzureSQLDatabaseOutputDataSource{
				Type: to.Ptr("Microsoft.Sql/Server/Database"),
				Properties: &armstreamanalytics.AzureSQLDatabaseOutputDataSourceProperties{
					Table: to.Ptr("differentTable"),
				},
			},
		},
	}, &armstreamanalytics.OutputsClientUpdateOptions{IfMatch: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Output = armstreamanalytics.Output{
	// 	Name: to.Ptr("output1755"),
	// 	Type: to.Ptr("Microsoft.StreamAnalytics/streamingjobs/outputs"),
	// 	ID: to.Ptr("/subscriptions/56b5e0a9-b645-407d-99b0-c64f86013e3d/resourceGroups/sjrg2157/providers/Microsoft.StreamAnalytics/streamingjobs/sj6458/outputs/output1755"),
	// 	Properties: &armstreamanalytics.OutputProperties{
	// 		Datasource: &armstreamanalytics.AzureSQLDatabaseOutputDataSource{
	// 			Type: to.Ptr("Microsoft.Sql/Server/Database"),
	// 			Properties: &armstreamanalytics.AzureSQLDatabaseOutputDataSourceProperties{
	// 				Database: to.Ptr("someDatabase"),
	// 				Server: to.Ptr("someServer"),
	// 				Table: to.Ptr("differentTable"),
	// 				User: to.Ptr("someUser"),
	// 			},
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/fa469a1157c33837a46c9bcd524527e94125189a/specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Output_Update_AzureTable.json
func ExampleOutputsClient_Update_updateAnAzureTableOutput() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstreamanalytics.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewOutputsClient().Update(ctx, "sjrg5176", "sj2790", "output958", armstreamanalytics.Output{
		Properties: &armstreamanalytics.OutputProperties{
			Datasource: &armstreamanalytics.AzureTableOutputDataSource{
				Type: to.Ptr("Microsoft.Storage/Table"),
				Properties: &armstreamanalytics.AzureTableOutputDataSourceProperties{
					PartitionKey: to.Ptr("differentPartitionKey"),
				},
			},
		},
	}, &armstreamanalytics.OutputsClientUpdateOptions{IfMatch: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Output = armstreamanalytics.Output{
	// 	Name: to.Ptr("output958"),
	// 	Type: to.Ptr("Microsoft.StreamAnalytics/streamingjobs/outputs"),
	// 	ID: to.Ptr("/subscriptions/56b5e0a9-b645-407d-99b0-c64f86013e3d/resourceGroups/sjrg5176/providers/Microsoft.StreamAnalytics/streamingjobs/sj2790/outputs/output958"),
	// 	Properties: &armstreamanalytics.OutputProperties{
	// 		Datasource: &armstreamanalytics.AzureTableOutputDataSource{
	// 			Type: to.Ptr("Microsoft.Storage/Table"),
	// 			Properties: &armstreamanalytics.AzureTableOutputDataSourceProperties{
	// 				AccountName: to.Ptr("someAccountName"),
	// 				BatchSize: to.Ptr[int32](25),
	// 				ColumnsToRemove: []*string{
	// 					to.Ptr("column1"),
	// 					to.Ptr("column2")},
	// 					PartitionKey: to.Ptr("differentPartitionKey"),
	// 					RowKey: to.Ptr("rowKey"),
	// 					Table: to.Ptr("samples"),
	// 				},
	// 			},
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/fa469a1157c33837a46c9bcd524527e94125189a/specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Output_Update_EventHub.json
func ExampleOutputsClient_Update_updateAnEventHubOutputWithJsonSerialization() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstreamanalytics.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewOutputsClient().Update(ctx, "sjrg6912", "sj3310", "output5195", armstreamanalytics.Output{
		Properties: &armstreamanalytics.OutputProperties{
			Datasource: &armstreamanalytics.EventHubOutputDataSource{
				Type: to.Ptr("Microsoft.ServiceBus/EventHub"),
				Properties: &armstreamanalytics.EventHubOutputDataSourceProperties{
					PartitionKey: to.Ptr("differentPartitionKey"),
				},
			},
			Serialization: &armstreamanalytics.JSONSerialization{
				Type: to.Ptr(armstreamanalytics.EventSerializationTypeJSON),
				Properties: &armstreamanalytics.JSONSerializationProperties{
					Format:   to.Ptr(armstreamanalytics.JSONOutputSerializationFormatLineSeparated),
					Encoding: to.Ptr(armstreamanalytics.EncodingUTF8),
				},
			},
		},
	}, &armstreamanalytics.OutputsClientUpdateOptions{IfMatch: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Output = armstreamanalytics.Output{
	// 	Name: to.Ptr("output5195"),
	// 	Type: to.Ptr("Microsoft.StreamAnalytics/streamingjobs/outputs"),
	// 	ID: to.Ptr("/subscriptions/56b5e0a9-b645-407d-99b0-c64f86013e3d/resourceGroups/sjrg6912/providers/Microsoft.StreamAnalytics/streamingjobs/sj3310/outputs/output5195"),
	// 	Properties: &armstreamanalytics.OutputProperties{
	// 		Datasource: &armstreamanalytics.EventHubOutputDataSource{
	// 			Type: to.Ptr("Microsoft.ServiceBus/EventHub"),
	// 			Properties: &armstreamanalytics.EventHubOutputDataSourceProperties{
	// 				ServiceBusNamespace: to.Ptr("sdktest"),
	// 				SharedAccessPolicyName: to.Ptr("RootManageSharedAccessKey"),
	// 				EventHubName: to.Ptr("sdkeventhub"),
	// 				PartitionKey: to.Ptr("differentPartitionKey"),
	// 			},
	// 		},
	// 		Serialization: &armstreamanalytics.JSONSerialization{
	// 			Type: to.Ptr(armstreamanalytics.EventSerializationTypeJSON),
	// 			Properties: &armstreamanalytics.JSONSerializationProperties{
	// 				Format: to.Ptr(armstreamanalytics.JSONOutputSerializationFormatLineSeparated),
	// 				Encoding: to.Ptr(armstreamanalytics.EncodingUTF8),
	// 			},
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/fa469a1157c33837a46c9bcd524527e94125189a/specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Output_Delete.json
func ExampleOutputsClient_Delete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstreamanalytics.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewOutputsClient().Delete(ctx, "sjrg2157", "sj6458", "output1755", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/fa469a1157c33837a46c9bcd524527e94125189a/specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Output_Get_DeltaLake.json
func ExampleOutputsClient_Get_getADeltaLakeOutput() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstreamanalytics.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewOutputsClient().Get(ctx, "sjrg", "sjName", "output1221", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Output = armstreamanalytics.Output{
	// 	Name: to.Ptr("output1221"),
	// 	Type: to.Ptr("Microsoft.StreamAnalytics/streamingjobs/outputs"),
	// 	ID: to.Ptr("/subscriptions/56b5e0a9-b645-407d-99b0-c64f86013e3d/resourceGroups/sjrg/providers/Microsoft.StreamAnalytics/streamingjobs/sjName/outputs/output1221"),
	// 	Properties: &armstreamanalytics.OutputProperties{
	// 		Datasource: &armstreamanalytics.BlobOutputDataSource{
	// 			Type: to.Ptr("Microsoft.Storage/Blob"),
	// 			Properties: &armstreamanalytics.BlobOutputDataSourceProperties{
	// 				Container: to.Ptr("deltaoutput"),
	// 				StorageAccounts: []*armstreamanalytics.StorageAccount{
	// 					{
	// 						AccountName: to.Ptr("someAccountName"),
	// 				}},
	// 			},
	// 		},
	// 		Serialization: &armstreamanalytics.DeltaSerialization{
	// 			Type: to.Ptr(armstreamanalytics.EventSerializationTypeDelta),
	// 			Properties: &armstreamanalytics.DeltaSerializationProperties{
	// 				DeltaTablePath: to.Ptr("/folder1/table1"),
	// 				PartitionColumns: []*string{
	// 					to.Ptr("column1")},
	// 				},
	// 			},
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/fa469a1157c33837a46c9bcd524527e94125189a/specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Output_Get_DocumentDB.json
func ExampleOutputsClient_Get_getADocumentDbOutput() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstreamanalytics.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewOutputsClient().Get(ctx, "sjrg7983", "sj2331", "output3022", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Output = armstreamanalytics.Output{
	// 	Name: to.Ptr("output3022"),
	// 	Type: to.Ptr("Microsoft.StreamAnalytics/streamingjobs/outputs"),
	// 	ID: to.Ptr("/subscriptions/56b5e0a9-b645-407d-99b0-c64f86013e3d/resourceGroups/sjrg7983/providers/Microsoft.StreamAnalytics/streamingjobs/sj2331/outputs/output3022"),
	// 	Properties: &armstreamanalytics.OutputProperties{
	// 		Datasource: &armstreamanalytics.DocumentDbOutputDataSource{
	// 			Type: to.Ptr("Microsoft.Storage/DocumentDB"),
	// 			Properties: &armstreamanalytics.DocumentDbOutputDataSourceProperties{
	// 				AccountID: to.Ptr("someAccountId"),
	// 				CollectionNamePattern: to.Ptr("collection"),
	// 				Database: to.Ptr("db01"),
	// 				DocumentID: to.Ptr("documentId"),
	// 				PartitionKey: to.Ptr("key"),
	// 			},
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/fa469a1157c33837a46c9bcd524527e94125189a/specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Output_Get_PowerBI.json
func ExampleOutputsClient_Get_getAPowerBiOutput() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstreamanalytics.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewOutputsClient().Get(ctx, "sjrg7983", "sj2331", "output3022", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Output = armstreamanalytics.Output{
	// 	Name: to.Ptr("output3022"),
	// 	Type: to.Ptr("Microsoft.StreamAnalytics/streamingjobs/outputs"),
	// 	ID: to.Ptr("/subscriptions/56b5e0a9-b645-407d-99b0-c64f86013e3d/resourceGroups/sjrg7983/providers/Microsoft.StreamAnalytics/streamingjobs/sj2331/outputs/output3022"),
	// 	Properties: &armstreamanalytics.OutputProperties{
	// 		Datasource: &armstreamanalytics.PowerBIOutputDataSource{
	// 			Type: to.Ptr("PowerBI"),
	// 			Properties: &armstreamanalytics.PowerBIOutputDataSourceProperties{
	// 				TokenUserDisplayName: to.Ptr("Bob Smith"),
	// 				TokenUserPrincipalName: to.Ptr("bobsmith@contoso.com"),
	// 				Dataset: to.Ptr("someDataset"),
	// 				GroupID: to.Ptr("ac40305e-3e8d-43ac-8161-c33799f43e95"),
	// 				GroupName: to.Ptr("MyPowerBIGroup"),
	// 				Table: to.Ptr("someTable"),
	// 			},
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/fa469a1157c33837a46c9bcd524527e94125189a/specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Output_Get_ServiceBusQueue_Avro.json
func ExampleOutputsClient_Get_getAServiceBusQueueOutputWithAvroSerialization() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstreamanalytics.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewOutputsClient().Get(ctx, "sjrg3410", "sj5095", "output3456", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Output = armstreamanalytics.Output{
	// 	Name: to.Ptr("output3456"),
	// 	Type: to.Ptr("Microsoft.StreamAnalytics/streamingjobs/outputs"),
	// 	ID: to.Ptr("/subscriptions/56b5e0a9-b645-407d-99b0-c64f86013e3d/resourceGroups/sjrg3410/providers/Microsoft.StreamAnalytics/streamingjobs/sj5095/outputs/output3456"),
	// 	Properties: &armstreamanalytics.OutputProperties{
	// 		Datasource: &armstreamanalytics.ServiceBusQueueOutputDataSource{
	// 			Type: to.Ptr("Microsoft.ServiceBus/Queue"),
	// 			Properties: &armstreamanalytics.ServiceBusQueueOutputDataSourceProperties{
	// 				ServiceBusNamespace: to.Ptr("sdktest"),
	// 				SharedAccessPolicyName: to.Ptr("RootManageSharedAccessKey"),
	// 				PropertyColumns: []*string{
	// 					to.Ptr("column1"),
	// 					to.Ptr("column2")},
	// 					QueueName: to.Ptr("sdkqueue"),
	// 				},
	// 			},
	// 			Serialization: &armstreamanalytics.AvroSerialization{
	// 				Type: to.Ptr(armstreamanalytics.EventSerializationTypeAvro),
	// 				Properties: map[string]any{
	// 				},
	// 			},
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/fa469a1157c33837a46c9bcd524527e94125189a/specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Output_Get_ServiceBusTopic_CSV.json
func ExampleOutputsClient_Get_getAServiceBusTopicOutputWithCsvSerialization() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstreamanalytics.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewOutputsClient().Get(ctx, "sjrg6450", "sj7094", "output7886", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Output = armstreamanalytics.Output{
	// 	Name: to.Ptr("output7886"),
	// 	Type: to.Ptr("Microsoft.StreamAnalytics/streamingjobs/outputs"),
	// 	ID: to.Ptr("/subscriptions/56b5e0a9-b645-407d-99b0-c64f86013e3d/resourceGroups/sjrg6450/providers/Microsoft.StreamAnalytics/streamingjobs/sj7094/outputs/output7886"),
	// 	Properties: &armstreamanalytics.OutputProperties{
	// 		Datasource: &armstreamanalytics.ServiceBusTopicOutputDataSource{
	// 			Type: to.Ptr("Microsoft.ServiceBus/Topic"),
	// 			Properties: &armstreamanalytics.ServiceBusTopicOutputDataSourceProperties{
	// 				ServiceBusNamespace: to.Ptr("sdktest"),
	// 				SharedAccessPolicyName: to.Ptr("RootManageSharedAccessKey"),
	// 				PropertyColumns: []*string{
	// 					to.Ptr("column1"),
	// 					to.Ptr("column2")},
	// 					TopicName: to.Ptr("sdktopic"),
	// 				},
	// 			},
	// 			Serialization: &armstreamanalytics.CSVSerialization{
	// 				Type: to.Ptr(armstreamanalytics.EventSerializationTypeCSV),
	// 				Properties: &armstreamanalytics.CSVSerializationProperties{
	// 					Encoding: to.Ptr(armstreamanalytics.EncodingUTF8),
	// 					FieldDelimiter: to.Ptr(","),
	// 				},
	// 			},
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/fa469a1157c33837a46c9bcd524527e94125189a/specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Output_Get_Blob_CSV.json
func ExampleOutputsClient_Get_getABlobOutputWithCsvSerialization() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstreamanalytics.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewOutputsClient().Get(ctx, "sjrg5023", "sj900", "output1623", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Output = armstreamanalytics.Output{
	// 	Name: to.Ptr("output1623"),
	// 	Type: to.Ptr("Microsoft.StreamAnalytics/streamingjobs/outputs"),
	// 	ID: to.Ptr("/subscriptions/56b5e0a9-b645-407d-99b0-c64f86013e3d/resourceGroups/sjrg5023/providers/Microsoft.StreamAnalytics/streamingjobs/sj900/outputs/output1623"),
	// 	Properties: &armstreamanalytics.OutputProperties{
	// 		Datasource: &armstreamanalytics.BlobOutputDataSource{
	// 			Type: to.Ptr("Microsoft.Storage/Blob"),
	// 			Properties: &armstreamanalytics.BlobOutputDataSourceProperties{
	// 				Container: to.Ptr("state"),
	// 				DateFormat: to.Ptr("yyyy/MM/dd"),
	// 				PathPattern: to.Ptr("{date}/{time}"),
	// 				StorageAccounts: []*armstreamanalytics.StorageAccount{
	// 					{
	// 						AccountName: to.Ptr("someAccountName"),
	// 				}},
	// 				TimeFormat: to.Ptr("HH"),
	// 			},
	// 		},
	// 		Serialization: &armstreamanalytics.CSVSerialization{
	// 			Type: to.Ptr(armstreamanalytics.EventSerializationTypeCSV),
	// 			Properties: &armstreamanalytics.CSVSerializationProperties{
	// 				Encoding: to.Ptr(armstreamanalytics.EncodingUTF8),
	// 				FieldDelimiter: to.Ptr(","),
	// 			},
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/fa469a1157c33837a46c9bcd524527e94125189a/specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Output_Get_AzureDataLakeStore_JSON.json
func ExampleOutputsClient_Get_getAnAzureDataLakeStoreOutputWithJsonSerialization() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstreamanalytics.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewOutputsClient().Get(ctx, "sjrg6912", "sj3310", "output5195", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Output = armstreamanalytics.Output{
	// 	Name: to.Ptr("output5195"),
	// 	Type: to.Ptr("Microsoft.StreamAnalytics/streamingjobs/outputs"),
	// 	ID: to.Ptr("/subscriptions/56b5e0a9-b645-407d-99b0-c64f86013e3d/resourceGroups/sjrg6912/providers/Microsoft.StreamAnalytics/streamingjobs/sj3310/outputs/output5195"),
	// 	Properties: &armstreamanalytics.OutputProperties{
	// 		Datasource: &armstreamanalytics.AzureDataLakeStoreOutputDataSource{
	// 			Type: to.Ptr("Microsoft.DataLake/Accounts"),
	// 			Properties: &armstreamanalytics.AzureDataLakeStoreOutputDataSourceProperties{
	// 				TokenUserDisplayName: to.Ptr("Bob Smith"),
	// 				TokenUserPrincipalName: to.Ptr("bobsmith@contoso.com"),
	// 				AccountName: to.Ptr("someaccount"),
	// 				DateFormat: to.Ptr("yyyy/MM/dd"),
	// 				FilePathPrefix: to.Ptr("{date}/{time}"),
	// 				TenantID: to.Ptr("cea4e98b-c798-49e7-8c40-4a2b3beb47dd"),
	// 				TimeFormat: to.Ptr("HH"),
	// 			},
	// 		},
	// 		Serialization: &armstreamanalytics.JSONSerialization{
	// 			Type: to.Ptr(armstreamanalytics.EventSerializationTypeJSON),
	// 			Properties: &armstreamanalytics.JSONSerializationProperties{
	// 				Format: to.Ptr(armstreamanalytics.JSONOutputSerializationFormatArray),
	// 				Encoding: to.Ptr(armstreamanalytics.EncodingUTF8),
	// 			},
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/fa469a1157c33837a46c9bcd524527e94125189a/specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Output_Get_DataWarehouse.json
func ExampleOutputsClient_Get_getAnAzureDataWarehouseOutput() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstreamanalytics.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewOutputsClient().Get(ctx, "sjrg", "sjName", "dwOutput", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Output = armstreamanalytics.Output{
	// 	Name: to.Ptr("dwOutput"),
	// 	Type: to.Ptr("Microsoft.StreamAnalytics/streamingjobs/outputs"),
	// 	ID: to.Ptr("/subscriptions/56b5e0a9-b645-407d-99b0-c64f86013e3d/resourceGroups/sjrg/providers/Microsoft.StreamAnalytics/streamingjobs/sjName/outputs/dwOutput"),
	// 	Properties: &armstreamanalytics.OutputProperties{
	// 		Datasource: &armstreamanalytics.AzureSynapseOutputDataSource{
	// 			Type: to.Ptr("Microsoft.Sql/Server/DataWarehouse"),
	// 			Properties: &armstreamanalytics.AzureSynapseOutputDataSourceProperties{
	// 				Database: to.Ptr("zhayaSQLpool"),
	// 				Server: to.Ptr("asatestserver"),
	// 				Table: to.Ptr("test2"),
	// 				User: to.Ptr("tolladmin"),
	// 			},
	// 		},
	// 		Etag: to.Ptr("ce3fb956-0487-4168-af20-1133a59bdc6e"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/fa469a1157c33837a46c9bcd524527e94125189a/specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Output_Get_AzureFunction.json
func ExampleOutputsClient_Get_getAnAzureFunctionOutput() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstreamanalytics.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewOutputsClient().Get(ctx, "sjrg", "sjName", "azureFunction1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Output = armstreamanalytics.Output{
	// 	Name: to.Ptr("azureFunction1"),
	// 	Type: to.Ptr("Microsoft.StreamAnalytics/streamingjobs/outputs"),
	// 	ID: to.Ptr("/subscriptions/7f31cba8-b597-4129-b158-8f21a7395bd0/resourceGroups/sjrg/providers/Microsoft.StreamAnalytics/streamingjobs/sjName/outputs/azureFunction1"),
	// 	Properties: &armstreamanalytics.OutputProperties{
	// 		Datasource: &armstreamanalytics.AzureFunctionOutputDataSource{
	// 			Type: to.Ptr("Microsoft.AzureFunction"),
	// 			Properties: &armstreamanalytics.AzureFunctionOutputDataSourceProperties{
	// 				FunctionAppName: to.Ptr("functionappforasaautomation"),
	// 				FunctionName: to.Ptr("HttpTrigger2"),
	// 				MaxBatchCount: to.Ptr[float32](100),
	// 				MaxBatchSize: to.Ptr[float32](256),
	// 			},
	// 		},
	// 		Etag: to.Ptr("7b912929-346d-432e-9495-6972dbd63179"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/fa469a1157c33837a46c9bcd524527e94125189a/specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Output_Get_AzureSQL.json
func ExampleOutputsClient_Get_getAnAzureSqlDatabaseOutput() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstreamanalytics.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewOutputsClient().Get(ctx, "sjrg2157", "sj6458", "output1755", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Output = armstreamanalytics.Output{
	// 	Name: to.Ptr("output1755"),
	// 	Type: to.Ptr("Microsoft.StreamAnalytics/streamingjobs/outputs"),
	// 	ID: to.Ptr("/subscriptions/56b5e0a9-b645-407d-99b0-c64f86013e3d/resourceGroups/sjrg2157/providers/Microsoft.StreamAnalytics/streamingjobs/sj6458/outputs/output1755"),
	// 	Properties: &armstreamanalytics.OutputProperties{
	// 		Datasource: &armstreamanalytics.AzureSQLDatabaseOutputDataSource{
	// 			Type: to.Ptr("Microsoft.Sql/Server/Database"),
	// 			Properties: &armstreamanalytics.AzureSQLDatabaseOutputDataSourceProperties{
	// 				Database: to.Ptr("someDatabase"),
	// 				Server: to.Ptr("someServer"),
	// 				Table: to.Ptr("someTable"),
	// 				User: to.Ptr("someUser"),
	// 			},
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/fa469a1157c33837a46c9bcd524527e94125189a/specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Output_Get_AzureTable.json
func ExampleOutputsClient_Get_getAnAzureTableOutput() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstreamanalytics.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewOutputsClient().Get(ctx, "sjrg5176", "sj2790", "output958", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Output = armstreamanalytics.Output{
	// 	Name: to.Ptr("output958"),
	// 	Type: to.Ptr("Microsoft.StreamAnalytics/streamingjobs/outputs"),
	// 	ID: to.Ptr("/subscriptions/56b5e0a9-b645-407d-99b0-c64f86013e3d/resourceGroups/sjrg5176/providers/Microsoft.StreamAnalytics/streamingjobs/sj2790/outputs/output958"),
	// 	Properties: &armstreamanalytics.OutputProperties{
	// 		Datasource: &armstreamanalytics.AzureTableOutputDataSource{
	// 			Type: to.Ptr("Microsoft.Storage/Table"),
	// 			Properties: &armstreamanalytics.AzureTableOutputDataSourceProperties{
	// 				AccountName: to.Ptr("someAccountName"),
	// 				BatchSize: to.Ptr[int32](25),
	// 				ColumnsToRemove: []*string{
	// 					to.Ptr("column1"),
	// 					to.Ptr("column2")},
	// 					PartitionKey: to.Ptr("partitionKey"),
	// 					RowKey: to.Ptr("rowKey"),
	// 					Table: to.Ptr("samples"),
	// 				},
	// 			},
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/fa469a1157c33837a46c9bcd524527e94125189a/specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Output_Get_EventHub_JSON.json
func ExampleOutputsClient_Get_getAnEventHubOutputWithJsonSerialization() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstreamanalytics.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewOutputsClient().Get(ctx, "sjrg6912", "sj3310", "output5195", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Output = armstreamanalytics.Output{
	// 	Name: to.Ptr("output5195"),
	// 	Type: to.Ptr("Microsoft.StreamAnalytics/streamingjobs/outputs"),
	// 	ID: to.Ptr("/subscriptions/56b5e0a9-b645-407d-99b0-c64f86013e3d/resourceGroups/sjrg6912/providers/Microsoft.StreamAnalytics/streamingjobs/sj3310/outputs/output5195"),
	// 	Properties: &armstreamanalytics.OutputProperties{
	// 		Datasource: &armstreamanalytics.EventHubOutputDataSource{
	// 			Type: to.Ptr("Microsoft.ServiceBus/EventHub"),
	// 			Properties: &armstreamanalytics.EventHubOutputDataSourceProperties{
	// 				ServiceBusNamespace: to.Ptr("sdktest"),
	// 				SharedAccessPolicyName: to.Ptr("RootManageSharedAccessKey"),
	// 				EventHubName: to.Ptr("sdkeventhub"),
	// 				PartitionKey: to.Ptr("partitionKey"),
	// 			},
	// 		},
	// 		LastOutputEventTimestamps: []*armstreamanalytics.LastOutputEventTimestamp{
	// 			{
	// 				LastOutputEventTime: to.Ptr("2009-06-15T13:45:30"),
	// 				LastUpdateTime: to.Ptr("2009-06-15T13:45:30"),
	// 			},
	// 			{
	// 				LastOutputEventTime: to.Ptr("2009-07-15T13:45:30"),
	// 				LastUpdateTime: to.Ptr("2009-06-15T13:45:30"),
	// 		}},
	// 		Serialization: &armstreamanalytics.JSONSerialization{
	// 			Type: to.Ptr(armstreamanalytics.EventSerializationTypeJSON),
	// 			Properties: &armstreamanalytics.JSONSerializationProperties{
	// 				Format: to.Ptr(armstreamanalytics.JSONOutputSerializationFormatArray),
	// 				Encoding: to.Ptr(armstreamanalytics.EncodingUTF8),
	// 			},
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/fa469a1157c33837a46c9bcd524527e94125189a/specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Output_ListByStreamingJob.json
func ExampleOutputsClient_NewListByStreamingJobPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstreamanalytics.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewOutputsClient().NewListByStreamingJobPager("sjrg2157", "sj6458", &armstreamanalytics.OutputsClientListByStreamingJobOptions{Select: nil})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.OutputListResult = armstreamanalytics.OutputListResult{
		// 	Value: []*armstreamanalytics.Output{
		// 		{
		// 			Name: to.Ptr("output1755"),
		// 			Type: to.Ptr("Microsoft.StreamAnalytics/streamingjobs/outputs"),
		// 			ID: to.Ptr("/subscriptions/56b5e0a9-b645-407d-99b0-c64f86013e3d/resourceGroups/sjrg2157/providers/Microsoft.StreamAnalytics/streamingjobs/sj6458/outputs/output1755"),
		// 			Properties: &armstreamanalytics.OutputProperties{
		// 				Datasource: &armstreamanalytics.AzureSQLDatabaseOutputDataSource{
		// 					Type: to.Ptr("Microsoft.Sql/Server/Database"),
		// 					Properties: &armstreamanalytics.AzureSQLDatabaseOutputDataSourceProperties{
		// 						Database: to.Ptr("someDatabase"),
		// 						Server: to.Ptr("someServer"),
		// 						Table: to.Ptr("differentTable"),
		// 						User: to.Ptr("someUser"),
		// 					},
		// 				},
		// 				Etag: to.Ptr("f489d6f3-fcd5-4bcb-b642-81e987ee16d6"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("output958"),
		// 			Type: to.Ptr("Microsoft.StreamAnalytics/streamingjobs/outputs"),
		// 			ID: to.Ptr("/subscriptions/56b5e0a9-b645-407d-99b0-c64f86013e3d/resourceGroups/sjrg2157/providers/Microsoft.StreamAnalytics/streamingjobs/sj6458/outputs/output958"),
		// 			Properties: &armstreamanalytics.OutputProperties{
		// 				Datasource: &armstreamanalytics.AzureTableOutputDataSource{
		// 					Type: to.Ptr("Microsoft.Storage/Table"),
		// 					Properties: &armstreamanalytics.AzureTableOutputDataSourceProperties{
		// 						AccountName: to.Ptr("someAccountName"),
		// 						BatchSize: to.Ptr[int32](25),
		// 						ColumnsToRemove: []*string{
		// 							to.Ptr("column1"),
		// 							to.Ptr("column2")},
		// 							PartitionKey: to.Ptr("differentPartitionKey"),
		// 							RowKey: to.Ptr("rowKey"),
		// 							Table: to.Ptr("samples"),
		// 						},
		// 					},
		// 					Etag: to.Ptr("ea1d20bf-6cb3-40bc-bc7b-ec3a7fd5977e"),
		// 				},
		// 			},
		// 			{
		// 				Name: to.Ptr("output1623"),
		// 				Type: to.Ptr("Microsoft.StreamAnalytics/streamingjobs/outputs"),
		// 				ID: to.Ptr("/subscriptions/56b5e0a9-b645-407d-99b0-c64f86013e3d/resourceGroups/sjrg2157/providers/Microsoft.StreamAnalytics/streamingjobs/sj6458/outputs/output1623"),
		// 				Properties: &armstreamanalytics.OutputProperties{
		// 					Datasource: &armstreamanalytics.BlobOutputDataSource{
		// 						Type: to.Ptr("Microsoft.Storage/Blob"),
		// 						Properties: &armstreamanalytics.BlobOutputDataSourceProperties{
		// 							Container: to.Ptr("differentContainer"),
		// 							DateFormat: to.Ptr("yyyy/MM/dd"),
		// 							PathPattern: to.Ptr("{date}/{time}"),
		// 							StorageAccounts: []*armstreamanalytics.StorageAccount{
		// 								{
		// 									AccountName: to.Ptr("someAccountName"),
		// 							}},
		// 							TimeFormat: to.Ptr("HH"),
		// 						},
		// 					},
		// 					Etag: to.Ptr("3a1b2023-79a9-4b33-93e8-f49fc3e573fe"),
		// 					Serialization: &armstreamanalytics.CSVSerialization{
		// 						Type: to.Ptr(armstreamanalytics.EventSerializationTypeCSV),
		// 						Properties: &armstreamanalytics.CSVSerializationProperties{
		// 							Encoding: to.Ptr(armstreamanalytics.EncodingUTF8),
		// 							FieldDelimiter: to.Ptr("|"),
		// 						},
		// 					},
		// 				},
		// 			},
		// 			{
		// 				Name: to.Ptr("output3022"),
		// 				Type: to.Ptr("Microsoft.StreamAnalytics/streamingjobs/outputs"),
		// 				ID: to.Ptr("/subscriptions/56b5e0a9-b645-407d-99b0-c64f86013e3d/resourceGroups/sjrg2157/providers/Microsoft.StreamAnalytics/streamingjobs/sj6458/outputs/output3022"),
		// 				Properties: &armstreamanalytics.OutputProperties{
		// 					Datasource: &armstreamanalytics.DocumentDbOutputDataSource{
		// 						Type: to.Ptr("Microsoft.Storage/DocumentDB"),
		// 						Properties: &armstreamanalytics.DocumentDbOutputDataSourceProperties{
		// 							AccountID: to.Ptr("someAccountId"),
		// 							CollectionNamePattern: to.Ptr("collection"),
		// 							Database: to.Ptr("db01"),
		// 							DocumentID: to.Ptr("documentId"),
		// 							PartitionKey: to.Ptr("differentPartitionKey"),
		// 						},
		// 					},
		// 					Etag: to.Ptr("7849c132-e995-4631-91c3-931606eec432"),
		// 				},
		// 			},
		// 			{
		// 				Name: to.Ptr("output5195"),
		// 				Type: to.Ptr("Microsoft.StreamAnalytics/streamingjobs/outputs"),
		// 				ID: to.Ptr("/subscriptions/56b5e0a9-b645-407d-99b0-c64f86013e3d/resourceGroups/sjrg2157/providers/Microsoft.StreamAnalytics/streamingjobs/sj6458/outputs/output5195"),
		// 				Properties: &armstreamanalytics.OutputProperties{
		// 					Datasource: &armstreamanalytics.EventHubOutputDataSource{
		// 						Type: to.Ptr("Microsoft.ServiceBus/EventHub"),
		// 						Properties: &armstreamanalytics.EventHubOutputDataSourceProperties{
		// 							ServiceBusNamespace: to.Ptr("sdktest"),
		// 							SharedAccessPolicyName: to.Ptr("RootManageSharedAccessKey"),
		// 							EventHubName: to.Ptr("sdkeventhub"),
		// 							PartitionKey: to.Ptr("differentPartitionKey"),
		// 						},
		// 					},
		// 					Etag: to.Ptr("5020de6b-5bb3-4b88-8606-f11fb3c46185"),
		// 					Serialization: &armstreamanalytics.JSONSerialization{
		// 						Type: to.Ptr(armstreamanalytics.EventSerializationTypeJSON),
		// 						Properties: &armstreamanalytics.JSONSerializationProperties{
		// 							Format: to.Ptr(armstreamanalytics.JSONOutputSerializationFormatLineSeparated),
		// 							Encoding: to.Ptr(armstreamanalytics.EncodingUTF8),
		// 						},
		// 					},
		// 				},
		// 			},
		// 			{
		// 				Name: to.Ptr("output3456"),
		// 				Type: to.Ptr("Microsoft.StreamAnalytics/streamingjobs/outputs"),
		// 				ID: to.Ptr("/subscriptions/56b5e0a9-b645-407d-99b0-c64f86013e3d/resourceGroups/sjrg2157/providers/Microsoft.StreamAnalytics/streamingjobs/sj6458/outputs/output3456"),
		// 				Properties: &armstreamanalytics.OutputProperties{
		// 					Datasource: &armstreamanalytics.ServiceBusQueueOutputDataSource{
		// 						Type: to.Ptr("Microsoft.ServiceBus/Queue"),
		// 						Properties: &armstreamanalytics.ServiceBusQueueOutputDataSourceProperties{
		// 							ServiceBusNamespace: to.Ptr("sdktest"),
		// 							SharedAccessPolicyName: to.Ptr("RootManageSharedAccessKey"),
		// 							PropertyColumns: []*string{
		// 								to.Ptr("column1"),
		// 								to.Ptr("column2")},
		// 								QueueName: to.Ptr("differentQueueName"),
		// 							},
		// 						},
		// 						Etag: to.Ptr("429adaec-a777-4750-8a39-8d0c931d801c"),
		// 						Serialization: &armstreamanalytics.JSONSerialization{
		// 							Type: to.Ptr(armstreamanalytics.EventSerializationTypeJSON),
		// 							Properties: &armstreamanalytics.JSONSerializationProperties{
		// 								Format: to.Ptr(armstreamanalytics.JSONOutputSerializationFormatLineSeparated),
		// 								Encoding: to.Ptr(armstreamanalytics.EncodingUTF8),
		// 							},
		// 						},
		// 					},
		// 				},
		// 				{
		// 					Name: to.Ptr("output7886"),
		// 					Type: to.Ptr("Microsoft.StreamAnalytics/streamingjobs/outputs"),
		// 					ID: to.Ptr("/subscriptions/56b5e0a9-b645-407d-99b0-c64f86013e3d/resourceGroups/sjrg2157/providers/Microsoft.StreamAnalytics/streamingjobs/sj6458/outputs/output7886"),
		// 					Properties: &armstreamanalytics.OutputProperties{
		// 						Datasource: &armstreamanalytics.ServiceBusTopicOutputDataSource{
		// 							Type: to.Ptr("Microsoft.ServiceBus/Topic"),
		// 							Properties: &armstreamanalytics.ServiceBusTopicOutputDataSourceProperties{
		// 								ServiceBusNamespace: to.Ptr("sdktest"),
		// 								SharedAccessPolicyName: to.Ptr("RootManageSharedAccessKey"),
		// 								PropertyColumns: []*string{
		// 									to.Ptr("column1"),
		// 									to.Ptr("column2")},
		// 									TopicName: to.Ptr("differentTopicName"),
		// 								},
		// 							},
		// 							Etag: to.Ptr("c1c2007f-45b2-419a-ae7d-4d2148998460"),
		// 							Serialization: &armstreamanalytics.CSVSerialization{
		// 								Type: to.Ptr(armstreamanalytics.EventSerializationTypeCSV),
		// 								Properties: &armstreamanalytics.CSVSerializationProperties{
		// 									Encoding: to.Ptr(armstreamanalytics.EncodingUTF8),
		// 									FieldDelimiter: to.Ptr("|"),
		// 								},
		// 							},
		// 						},
		// 					},
		// 					{
		// 						Name: to.Ptr("output3021"),
		// 						Type: to.Ptr("Microsoft.StreamAnalytics/streamingjobs/outputs"),
		// 						ID: to.Ptr("/subscriptions/56b5e0a9-b645-407d-99b0-c64f86013e3d/resourceGroups/sjrg2157/providers/Microsoft.StreamAnalytics/streamingjobs/sj6458/outputs/output3021"),
		// 						Properties: &armstreamanalytics.OutputProperties{
		// 							Datasource: &armstreamanalytics.PowerBIOutputDataSource{
		// 								Type: to.Ptr("PowerBI"),
		// 								Properties: &armstreamanalytics.PowerBIOutputDataSourceProperties{
		// 									TokenUserDisplayName: to.Ptr("Bob Smith"),
		// 									TokenUserPrincipalName: to.Ptr("bobsmith@contoso.com"),
		// 									Dataset: to.Ptr("differentDataset"),
		// 									GroupID: to.Ptr("ac40305e-3e8d-43ac-8161-c33799f43e95"),
		// 									GroupName: to.Ptr("MyPowerBIGroup"),
		// 									Table: to.Ptr("someTable"),
		// 								},
		// 							},
		// 							Etag: to.Ptr("4a492191-9672-4178-be10-043b9dbd4b9f"),
		// 						},
		// 					},
		// 					{
		// 						Name: to.Ptr("output5196"),
		// 						Type: to.Ptr("Microsoft.StreamAnalytics/streamingjobs/outputs"),
		// 						ID: to.Ptr("/subscriptions/56b5e0a9-b645-407d-99b0-c64f86013e3d/resourceGroups/sjrg2157/providers/Microsoft.StreamAnalytics/streamingjobs/sj6458/outputs/output5196"),
		// 						Properties: &armstreamanalytics.OutputProperties{
		// 							Datasource: &armstreamanalytics.AzureDataLakeStoreOutputDataSource{
		// 								Type: to.Ptr("Microsoft.DataLake/Accounts"),
		// 								Properties: &armstreamanalytics.AzureDataLakeStoreOutputDataSourceProperties{
		// 									TokenUserDisplayName: to.Ptr("Bob Smith"),
		// 									TokenUserPrincipalName: to.Ptr("bobsmith@contoso.com"),
		// 									AccountName: to.Ptr("differentaccount"),
		// 									DateFormat: to.Ptr("yyyy/MM/dd"),
		// 									FilePathPrefix: to.Ptr("{date}/{time}"),
		// 									TenantID: to.Ptr("cea4e98b-c798-49e7-8c40-4a2b3beb47dd"),
		// 									TimeFormat: to.Ptr("HH"),
		// 								},
		// 							},
		// 							Etag: to.Ptr("39ab7642-8c1e-48ed-85eb-949068d68002"),
		// 							Serialization: &armstreamanalytics.JSONSerialization{
		// 								Type: to.Ptr(armstreamanalytics.EventSerializationTypeJSON),
		// 								Properties: &armstreamanalytics.JSONSerializationProperties{
		// 									Format: to.Ptr(armstreamanalytics.JSONOutputSerializationFormatLineSeparated),
		// 									Encoding: to.Ptr(armstreamanalytics.EncodingUTF8),
		// 								},
		// 							},
		// 						},
		// 				}},
		// 			}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/fa469a1157c33837a46c9bcd524527e94125189a/specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Output_Test.json
func ExampleOutputsClient_BeginTest() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstreamanalytics.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewOutputsClient().BeginTest(ctx, "sjrg2157", "sj6458", "output1755", &armstreamanalytics.OutputsClientBeginTestOptions{Output: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ResourceTestStatus = armstreamanalytics.ResourceTestStatus{
	// 	Status: to.Ptr("TestSucceeded"),
	// }
}
