//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armstorsimple8000series

import (
	"encoding/json"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"reflect"
)

// MarshalJSON implements the json.Marshaller interface for type AccessControlRecord.
func (a AccessControlRecord) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", a.ID)
	objectMap["kind"] = "Series8000"
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AccessControlRecord.
func (a *AccessControlRecord) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &a.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AccessControlRecordList.
func (a AccessControlRecordList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AccessControlRecordList.
func (a *AccessControlRecordList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AccessControlRecordProperties.
func (a AccessControlRecordProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "initiatorName", a.InitiatorName)
	populate(objectMap, "volumeCount", a.VolumeCount)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AccessControlRecordProperties.
func (a *AccessControlRecordProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "initiatorName":
			err = unpopulate(val, "InitiatorName", &a.InitiatorName)
			delete(rawMsg, key)
		case "volumeCount":
			err = unpopulate(val, "VolumeCount", &a.VolumeCount)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AcsConfiguration.
func (a AcsConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "namespace", a.Namespace)
	populate(objectMap, "realm", a.Realm)
	populate(objectMap, "serviceUrl", a.ServiceURL)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AcsConfiguration.
func (a *AcsConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "namespace":
			err = unpopulate(val, "Namespace", &a.Namespace)
			delete(rawMsg, key)
		case "realm":
			err = unpopulate(val, "Realm", &a.Realm)
			delete(rawMsg, key)
		case "serviceUrl":
			err = unpopulate(val, "ServiceURL", &a.ServiceURL)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Alert.
func (a Alert) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", a.ID)
	objectMap["kind"] = "Series8000"
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Alert.
func (a *Alert) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &a.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AlertErrorDetails.
func (a AlertErrorDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "errorCode", a.ErrorCode)
	populate(objectMap, "errorMessage", a.ErrorMessage)
	populate(objectMap, "occurences", a.Occurences)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AlertErrorDetails.
func (a *AlertErrorDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "errorCode":
			err = unpopulate(val, "ErrorCode", &a.ErrorCode)
			delete(rawMsg, key)
		case "errorMessage":
			err = unpopulate(val, "ErrorMessage", &a.ErrorMessage)
			delete(rawMsg, key)
		case "occurences":
			err = unpopulate(val, "Occurences", &a.Occurences)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AlertFilter.
func (a AlertFilter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "appearedOnTime", a.AppearedOnTime)
	populate(objectMap, "severity", a.Severity)
	populate(objectMap, "sourceName", a.SourceName)
	populate(objectMap, "sourceType", a.SourceType)
	populate(objectMap, "status", a.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AlertFilter.
func (a *AlertFilter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "appearedOnTime":
			err = unpopulateDateTimeRFC3339(val, "AppearedOnTime", &a.AppearedOnTime)
			delete(rawMsg, key)
		case "severity":
			err = unpopulate(val, "Severity", &a.Severity)
			delete(rawMsg, key)
		case "sourceName":
			err = unpopulate(val, "SourceName", &a.SourceName)
			delete(rawMsg, key)
		case "sourceType":
			err = unpopulate(val, "SourceType", &a.SourceType)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &a.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AlertList.
func (a AlertList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AlertList.
func (a *AlertList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &a.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AlertNotificationProperties.
func (a AlertNotificationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "additionalRecipientEmailList", a.AdditionalRecipientEmailList)
	populate(objectMap, "alertNotificationCulture", a.AlertNotificationCulture)
	populate(objectMap, "emailNotification", a.EmailNotification)
	populate(objectMap, "notificationToServiceOwners", a.NotificationToServiceOwners)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AlertNotificationProperties.
func (a *AlertNotificationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalRecipientEmailList":
			err = unpopulate(val, "AdditionalRecipientEmailList", &a.AdditionalRecipientEmailList)
			delete(rawMsg, key)
		case "alertNotificationCulture":
			err = unpopulate(val, "AlertNotificationCulture", &a.AlertNotificationCulture)
			delete(rawMsg, key)
		case "emailNotification":
			err = unpopulate(val, "EmailNotification", &a.EmailNotification)
			delete(rawMsg, key)
		case "notificationToServiceOwners":
			err = unpopulate(val, "NotificationToServiceOwners", &a.NotificationToServiceOwners)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AlertProperties.
func (a AlertProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "alertType", a.AlertType)
	populateDateTimeRFC3339(objectMap, "appearedAtSourceTime", a.AppearedAtSourceTime)
	populateDateTimeRFC3339(objectMap, "appearedAtTime", a.AppearedAtTime)
	populateDateTimeRFC3339(objectMap, "clearedAtSourceTime", a.ClearedAtSourceTime)
	populateDateTimeRFC3339(objectMap, "clearedAtTime", a.ClearedAtTime)
	populate(objectMap, "detailedInformation", a.DetailedInformation)
	populate(objectMap, "errorDetails", a.ErrorDetails)
	populate(objectMap, "recommendation", a.Recommendation)
	populate(objectMap, "resolutionReason", a.ResolutionReason)
	populate(objectMap, "scope", a.Scope)
	populate(objectMap, "severity", a.Severity)
	populate(objectMap, "source", a.Source)
	populate(objectMap, "status", a.Status)
	populate(objectMap, "title", a.Title)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AlertProperties.
func (a *AlertProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "alertType":
			err = unpopulate(val, "AlertType", &a.AlertType)
			delete(rawMsg, key)
		case "appearedAtSourceTime":
			err = unpopulateDateTimeRFC3339(val, "AppearedAtSourceTime", &a.AppearedAtSourceTime)
			delete(rawMsg, key)
		case "appearedAtTime":
			err = unpopulateDateTimeRFC3339(val, "AppearedAtTime", &a.AppearedAtTime)
			delete(rawMsg, key)
		case "clearedAtSourceTime":
			err = unpopulateDateTimeRFC3339(val, "ClearedAtSourceTime", &a.ClearedAtSourceTime)
			delete(rawMsg, key)
		case "clearedAtTime":
			err = unpopulateDateTimeRFC3339(val, "ClearedAtTime", &a.ClearedAtTime)
			delete(rawMsg, key)
		case "detailedInformation":
			err = unpopulate(val, "DetailedInformation", &a.DetailedInformation)
			delete(rawMsg, key)
		case "errorDetails":
			err = unpopulate(val, "ErrorDetails", &a.ErrorDetails)
			delete(rawMsg, key)
		case "recommendation":
			err = unpopulate(val, "Recommendation", &a.Recommendation)
			delete(rawMsg, key)
		case "resolutionReason":
			err = unpopulate(val, "ResolutionReason", &a.ResolutionReason)
			delete(rawMsg, key)
		case "scope":
			err = unpopulate(val, "Scope", &a.Scope)
			delete(rawMsg, key)
		case "severity":
			err = unpopulate(val, "Severity", &a.Severity)
			delete(rawMsg, key)
		case "source":
			err = unpopulate(val, "Source", &a.Source)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &a.Status)
			delete(rawMsg, key)
		case "title":
			err = unpopulate(val, "Title", &a.Title)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AlertSettings.
func (a AlertSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", a.ID)
	objectMap["kind"] = "Series8000"
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AlertSettings.
func (a *AlertSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &a.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AlertSource.
func (a AlertSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "alertSourceType", a.AlertSourceType)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "timeZone", a.TimeZone)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AlertSource.
func (a *AlertSource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "alertSourceType":
			err = unpopulate(val, "AlertSourceType", &a.AlertSourceType)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "timeZone":
			err = unpopulate(val, "TimeZone", &a.TimeZone)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AsymmetricEncryptedSecret.
func (a AsymmetricEncryptedSecret) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "encryptionAlgorithm", a.EncryptionAlgorithm)
	populate(objectMap, "encryptionCertThumbprint", a.EncryptionCertThumbprint)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AsymmetricEncryptedSecret.
func (a *AsymmetricEncryptedSecret) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "encryptionAlgorithm":
			err = unpopulate(val, "EncryptionAlgorithm", &a.EncryptionAlgorithm)
			delete(rawMsg, key)
		case "encryptionCertThumbprint":
			err = unpopulate(val, "EncryptionCertThumbprint", &a.EncryptionCertThumbprint)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AvailableProviderOperation.
func (a AvailableProviderOperation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "display", a.Display)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "origin", a.Origin)
	populateAny(objectMap, "properties", a.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AvailableProviderOperation.
func (a *AvailableProviderOperation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "display":
			err = unpopulate(val, "Display", &a.Display)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "origin":
			err = unpopulate(val, "Origin", &a.Origin)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AvailableProviderOperationDisplay.
func (a AvailableProviderOperationDisplay) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "operation", a.Operation)
	populate(objectMap, "provider", a.Provider)
	populate(objectMap, "resource", a.Resource)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AvailableProviderOperationDisplay.
func (a *AvailableProviderOperationDisplay) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "operation":
			err = unpopulate(val, "Operation", &a.Operation)
			delete(rawMsg, key)
		case "provider":
			err = unpopulate(val, "Provider", &a.Provider)
			delete(rawMsg, key)
		case "resource":
			err = unpopulate(val, "Resource", &a.Resource)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AvailableProviderOperationList.
func (a AvailableProviderOperationList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AvailableProviderOperationList.
func (a *AvailableProviderOperationList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &a.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Backup.
func (b Backup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", b.ID)
	objectMap["kind"] = "Series8000"
	populate(objectMap, "name", b.Name)
	populate(objectMap, "properties", b.Properties)
	populate(objectMap, "type", b.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Backup.
func (b *Backup) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &b.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &b.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &b.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &b.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &b.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BackupElement.
func (b BackupElement) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "elementId", b.ElementID)
	populate(objectMap, "elementName", b.ElementName)
	populate(objectMap, "elementType", b.ElementType)
	populate(objectMap, "sizeInBytes", b.SizeInBytes)
	populate(objectMap, "volumeContainerId", b.VolumeContainerID)
	populate(objectMap, "volumeName", b.VolumeName)
	populate(objectMap, "volumeType", b.VolumeType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BackupElement.
func (b *BackupElement) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "elementId":
			err = unpopulate(val, "ElementID", &b.ElementID)
			delete(rawMsg, key)
		case "elementName":
			err = unpopulate(val, "ElementName", &b.ElementName)
			delete(rawMsg, key)
		case "elementType":
			err = unpopulate(val, "ElementType", &b.ElementType)
			delete(rawMsg, key)
		case "sizeInBytes":
			err = unpopulate(val, "SizeInBytes", &b.SizeInBytes)
			delete(rawMsg, key)
		case "volumeContainerId":
			err = unpopulate(val, "VolumeContainerID", &b.VolumeContainerID)
			delete(rawMsg, key)
		case "volumeName":
			err = unpopulate(val, "VolumeName", &b.VolumeName)
			delete(rawMsg, key)
		case "volumeType":
			err = unpopulate(val, "VolumeType", &b.VolumeType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BackupFilter.
func (b BackupFilter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "backupPolicyId", b.BackupPolicyID)
	populateDateTimeRFC3339(objectMap, "createdTime", b.CreatedTime)
	populate(objectMap, "volumeId", b.VolumeID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BackupFilter.
func (b *BackupFilter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backupPolicyId":
			err = unpopulate(val, "BackupPolicyID", &b.BackupPolicyID)
			delete(rawMsg, key)
		case "createdTime":
			err = unpopulateDateTimeRFC3339(val, "CreatedTime", &b.CreatedTime)
			delete(rawMsg, key)
		case "volumeId":
			err = unpopulate(val, "VolumeID", &b.VolumeID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BackupList.
func (b BackupList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", b.NextLink)
	populate(objectMap, "value", b.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BackupList.
func (b *BackupList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &b.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &b.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BackupPolicy.
func (b BackupPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", b.ID)
	objectMap["kind"] = "Series8000"
	populate(objectMap, "name", b.Name)
	populate(objectMap, "properties", b.Properties)
	populate(objectMap, "type", b.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BackupPolicy.
func (b *BackupPolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &b.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &b.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &b.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &b.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &b.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BackupPolicyList.
func (b BackupPolicyList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", b.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BackupPolicyList.
func (b *BackupPolicyList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &b.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BackupPolicyProperties.
func (b BackupPolicyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "backupPolicyCreationType", b.BackupPolicyCreationType)
	populateDateTimeRFC3339(objectMap, "lastBackupTime", b.LastBackupTime)
	populateDateTimeRFC3339(objectMap, "nextBackupTime", b.NextBackupTime)
	populate(objectMap, "scheduledBackupStatus", b.ScheduledBackupStatus)
	populate(objectMap, "schedulesCount", b.SchedulesCount)
	populate(objectMap, "ssmHostName", b.SsmHostName)
	populate(objectMap, "volumeIds", b.VolumeIDs)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BackupPolicyProperties.
func (b *BackupPolicyProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backupPolicyCreationType":
			err = unpopulate(val, "BackupPolicyCreationType", &b.BackupPolicyCreationType)
			delete(rawMsg, key)
		case "lastBackupTime":
			err = unpopulateDateTimeRFC3339(val, "LastBackupTime", &b.LastBackupTime)
			delete(rawMsg, key)
		case "nextBackupTime":
			err = unpopulateDateTimeRFC3339(val, "NextBackupTime", &b.NextBackupTime)
			delete(rawMsg, key)
		case "scheduledBackupStatus":
			err = unpopulate(val, "ScheduledBackupStatus", &b.ScheduledBackupStatus)
			delete(rawMsg, key)
		case "schedulesCount":
			err = unpopulate(val, "SchedulesCount", &b.SchedulesCount)
			delete(rawMsg, key)
		case "ssmHostName":
			err = unpopulate(val, "SsmHostName", &b.SsmHostName)
			delete(rawMsg, key)
		case "volumeIds":
			err = unpopulate(val, "VolumeIDs", &b.VolumeIDs)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BackupProperties.
func (b BackupProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "backupJobCreationType", b.BackupJobCreationType)
	populate(objectMap, "backupPolicyId", b.BackupPolicyID)
	populate(objectMap, "backupType", b.BackupType)
	populateDateTimeRFC3339(objectMap, "createdOn", b.CreatedOn)
	populate(objectMap, "elements", b.Elements)
	populate(objectMap, "sizeInBytes", b.SizeInBytes)
	populate(objectMap, "ssmHostName", b.SsmHostName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BackupProperties.
func (b *BackupProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backupJobCreationType":
			err = unpopulate(val, "BackupJobCreationType", &b.BackupJobCreationType)
			delete(rawMsg, key)
		case "backupPolicyId":
			err = unpopulate(val, "BackupPolicyID", &b.BackupPolicyID)
			delete(rawMsg, key)
		case "backupType":
			err = unpopulate(val, "BackupType", &b.BackupType)
			delete(rawMsg, key)
		case "createdOn":
			err = unpopulateDateTimeRFC3339(val, "CreatedOn", &b.CreatedOn)
			delete(rawMsg, key)
		case "elements":
			err = unpopulate(val, "Elements", &b.Elements)
			delete(rawMsg, key)
		case "sizeInBytes":
			err = unpopulate(val, "SizeInBytes", &b.SizeInBytes)
			delete(rawMsg, key)
		case "ssmHostName":
			err = unpopulate(val, "SsmHostName", &b.SsmHostName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BackupSchedule.
func (b BackupSchedule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", b.ID)
	objectMap["kind"] = "Series8000"
	populate(objectMap, "name", b.Name)
	populate(objectMap, "properties", b.Properties)
	populate(objectMap, "type", b.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BackupSchedule.
func (b *BackupSchedule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &b.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &b.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &b.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &b.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &b.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BackupScheduleList.
func (b BackupScheduleList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", b.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BackupScheduleList.
func (b *BackupScheduleList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &b.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BackupScheduleProperties.
func (b BackupScheduleProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "backupType", b.BackupType)
	populateDateTimeRFC3339(objectMap, "lastSuccessfulRun", b.LastSuccessfulRun)
	populate(objectMap, "retentionCount", b.RetentionCount)
	populate(objectMap, "scheduleRecurrence", b.ScheduleRecurrence)
	populate(objectMap, "scheduleStatus", b.ScheduleStatus)
	populateDateTimeRFC3339(objectMap, "startTime", b.StartTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BackupScheduleProperties.
func (b *BackupScheduleProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backupType":
			err = unpopulate(val, "BackupType", &b.BackupType)
			delete(rawMsg, key)
		case "lastSuccessfulRun":
			err = unpopulateDateTimeRFC3339(val, "LastSuccessfulRun", &b.LastSuccessfulRun)
			delete(rawMsg, key)
		case "retentionCount":
			err = unpopulate(val, "RetentionCount", &b.RetentionCount)
			delete(rawMsg, key)
		case "scheduleRecurrence":
			err = unpopulate(val, "ScheduleRecurrence", &b.ScheduleRecurrence)
			delete(rawMsg, key)
		case "scheduleStatus":
			err = unpopulate(val, "ScheduleStatus", &b.ScheduleStatus)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateDateTimeRFC3339(val, "StartTime", &b.StartTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BandwidthRateSettingProperties.
func (b BandwidthRateSettingProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "schedules", b.Schedules)
	populate(objectMap, "volumeCount", b.VolumeCount)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BandwidthRateSettingProperties.
func (b *BandwidthRateSettingProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "schedules":
			err = unpopulate(val, "Schedules", &b.Schedules)
			delete(rawMsg, key)
		case "volumeCount":
			err = unpopulate(val, "VolumeCount", &b.VolumeCount)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BandwidthSchedule.
func (b BandwidthSchedule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "days", b.Days)
	populate(objectMap, "rateInMbps", b.RateInMbps)
	populate(objectMap, "start", b.Start)
	populate(objectMap, "stop", b.Stop)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BandwidthSchedule.
func (b *BandwidthSchedule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "days":
			err = unpopulate(val, "Days", &b.Days)
			delete(rawMsg, key)
		case "rateInMbps":
			err = unpopulate(val, "RateInMbps", &b.RateInMbps)
			delete(rawMsg, key)
		case "start":
			err = unpopulate(val, "Start", &b.Start)
			delete(rawMsg, key)
		case "stop":
			err = unpopulate(val, "Stop", &b.Stop)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BandwidthSetting.
func (b BandwidthSetting) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", b.ID)
	objectMap["kind"] = "Series8000"
	populate(objectMap, "name", b.Name)
	populate(objectMap, "properties", b.Properties)
	populate(objectMap, "type", b.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BandwidthSetting.
func (b *BandwidthSetting) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &b.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &b.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &b.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &b.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &b.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BandwidthSettingList.
func (b BandwidthSettingList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", b.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BandwidthSettingList.
func (b *BandwidthSettingList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &b.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BaseModel.
func (b BaseModel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", b.ID)
	objectMap["kind"] = "Series8000"
	populate(objectMap, "name", b.Name)
	populate(objectMap, "type", b.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BaseModel.
func (b *BaseModel) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &b.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &b.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &b.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &b.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ChapSettings.
func (c ChapSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "initiatorSecret", c.InitiatorSecret)
	populate(objectMap, "initiatorUser", c.InitiatorUser)
	populate(objectMap, "targetSecret", c.TargetSecret)
	populate(objectMap, "targetUser", c.TargetUser)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ChapSettings.
func (c *ChapSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "initiatorSecret":
			err = unpopulate(val, "InitiatorSecret", &c.InitiatorSecret)
			delete(rawMsg, key)
		case "initiatorUser":
			err = unpopulate(val, "InitiatorUser", &c.InitiatorUser)
			delete(rawMsg, key)
		case "targetSecret":
			err = unpopulate(val, "TargetSecret", &c.TargetSecret)
			delete(rawMsg, key)
		case "targetUser":
			err = unpopulate(val, "TargetUser", &c.TargetUser)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ClearAlertRequest.
func (c ClearAlertRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "alerts", c.Alerts)
	populate(objectMap, "resolutionMessage", c.ResolutionMessage)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClearAlertRequest.
func (c *ClearAlertRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "alerts":
			err = unpopulate(val, "Alerts", &c.Alerts)
			delete(rawMsg, key)
		case "resolutionMessage":
			err = unpopulate(val, "ResolutionMessage", &c.ResolutionMessage)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CloneRequest.
func (c CloneRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "backupElement", c.BackupElement)
	populate(objectMap, "targetAccessControlRecordIds", c.TargetAccessControlRecordIDs)
	populate(objectMap, "targetDeviceId", c.TargetDeviceID)
	populate(objectMap, "targetVolumeName", c.TargetVolumeName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CloneRequest.
func (c *CloneRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backupElement":
			err = unpopulate(val, "BackupElement", &c.BackupElement)
			delete(rawMsg, key)
		case "targetAccessControlRecordIds":
			err = unpopulate(val, "TargetAccessControlRecordIDs", &c.TargetAccessControlRecordIDs)
			delete(rawMsg, key)
		case "targetDeviceId":
			err = unpopulate(val, "TargetDeviceID", &c.TargetDeviceID)
			delete(rawMsg, key)
		case "targetVolumeName":
			err = unpopulate(val, "TargetVolumeName", &c.TargetVolumeName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CloudAppliance.
func (c CloudAppliance) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "isVnetDnsConfigured", c.IsVnetDNSConfigured)
	populate(objectMap, "isVnetExpressConfigured", c.IsVnetExpressConfigured)
	populate(objectMap, "modelNumber", c.ModelNumber)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "storageAccountName", c.StorageAccountName)
	populate(objectMap, "storageAccountType", c.StorageAccountType)
	populate(objectMap, "subnetName", c.SubnetName)
	populate(objectMap, "vmImageName", c.VMImageName)
	populate(objectMap, "vmType", c.VMType)
	populate(objectMap, "vnetName", c.VnetName)
	populate(objectMap, "vnetRegion", c.VnetRegion)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CloudAppliance.
func (c *CloudAppliance) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "isVnetDnsConfigured":
			err = unpopulate(val, "IsVnetDNSConfigured", &c.IsVnetDNSConfigured)
			delete(rawMsg, key)
		case "isVnetExpressConfigured":
			err = unpopulate(val, "IsVnetExpressConfigured", &c.IsVnetExpressConfigured)
			delete(rawMsg, key)
		case "modelNumber":
			err = unpopulate(val, "ModelNumber", &c.ModelNumber)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "storageAccountName":
			err = unpopulate(val, "StorageAccountName", &c.StorageAccountName)
			delete(rawMsg, key)
		case "storageAccountType":
			err = unpopulate(val, "StorageAccountType", &c.StorageAccountType)
			delete(rawMsg, key)
		case "subnetName":
			err = unpopulate(val, "SubnetName", &c.SubnetName)
			delete(rawMsg, key)
		case "vmImageName":
			err = unpopulate(val, "VMImageName", &c.VMImageName)
			delete(rawMsg, key)
		case "vmType":
			err = unpopulate(val, "VMType", &c.VMType)
			delete(rawMsg, key)
		case "vnetName":
			err = unpopulate(val, "VnetName", &c.VnetName)
			delete(rawMsg, key)
		case "vnetRegion":
			err = unpopulate(val, "VnetRegion", &c.VnetRegion)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CloudApplianceConfiguration.
func (c CloudApplianceConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", c.ID)
	objectMap["kind"] = "Series8000"
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CloudApplianceConfiguration.
func (c *CloudApplianceConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &c.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CloudApplianceConfigurationList.
func (c CloudApplianceConfigurationList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CloudApplianceConfigurationList.
func (c *CloudApplianceConfigurationList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CloudApplianceConfigurationProperties.
func (c CloudApplianceConfigurationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "acsConfiguration", c.AcsConfiguration)
	populate(objectMap, "cloudPlatform", c.CloudPlatform)
	populate(objectMap, "modelNumber", c.ModelNumber)
	populate(objectMap, "supportedRegions", c.SupportedRegions)
	populate(objectMap, "supportedStorageAccountTypes", c.SupportedStorageAccountTypes)
	populate(objectMap, "supportedVmImages", c.SupportedVMImages)
	populate(objectMap, "supportedVmTypes", c.SupportedVMTypes)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CloudApplianceConfigurationProperties.
func (c *CloudApplianceConfigurationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "acsConfiguration":
			err = unpopulate(val, "AcsConfiguration", &c.AcsConfiguration)
			delete(rawMsg, key)
		case "cloudPlatform":
			err = unpopulate(val, "CloudPlatform", &c.CloudPlatform)
			delete(rawMsg, key)
		case "modelNumber":
			err = unpopulate(val, "ModelNumber", &c.ModelNumber)
			delete(rawMsg, key)
		case "supportedRegions":
			err = unpopulate(val, "SupportedRegions", &c.SupportedRegions)
			delete(rawMsg, key)
		case "supportedStorageAccountTypes":
			err = unpopulate(val, "SupportedStorageAccountTypes", &c.SupportedStorageAccountTypes)
			delete(rawMsg, key)
		case "supportedVmImages":
			err = unpopulate(val, "SupportedVMImages", &c.SupportedVMImages)
			delete(rawMsg, key)
		case "supportedVmTypes":
			err = unpopulate(val, "SupportedVMTypes", &c.SupportedVMTypes)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CloudApplianceSettings.
func (c CloudApplianceSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "channelIntegrityKey", c.ChannelIntegrityKey)
	populate(objectMap, "serviceDataEncryptionKey", c.ServiceDataEncryptionKey)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CloudApplianceSettings.
func (c *CloudApplianceSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "channelIntegrityKey":
			err = unpopulate(val, "ChannelIntegrityKey", &c.ChannelIntegrityKey)
			delete(rawMsg, key)
		case "serviceDataEncryptionKey":
			err = unpopulate(val, "ServiceDataEncryptionKey", &c.ServiceDataEncryptionKey)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConfigureDeviceRequest.
func (c ConfigureDeviceRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", c.ID)
	objectMap["kind"] = "Series8000"
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConfigureDeviceRequest.
func (c *ConfigureDeviceRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &c.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConfigureDeviceRequestProperties.
func (c ConfigureDeviceRequestProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "currentDeviceName", c.CurrentDeviceName)
	populate(objectMap, "dnsSettings", c.DNSSettings)
	populate(objectMap, "friendlyName", c.FriendlyName)
	populate(objectMap, "networkInterfaceData0Settings", c.NetworkInterfaceData0Settings)
	populate(objectMap, "timeZone", c.TimeZone)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConfigureDeviceRequestProperties.
func (c *ConfigureDeviceRequestProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "currentDeviceName":
			err = unpopulate(val, "CurrentDeviceName", &c.CurrentDeviceName)
			delete(rawMsg, key)
		case "dnsSettings":
			err = unpopulate(val, "DNSSettings", &c.DNSSettings)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &c.FriendlyName)
			delete(rawMsg, key)
		case "networkInterfaceData0Settings":
			err = unpopulate(val, "NetworkInterfaceData0Settings", &c.NetworkInterfaceData0Settings)
			delete(rawMsg, key)
		case "timeZone":
			err = unpopulate(val, "TimeZone", &c.TimeZone)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ControllerPowerStateChangeRequest.
func (c ControllerPowerStateChangeRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", c.ID)
	objectMap["kind"] = "Series8000"
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ControllerPowerStateChangeRequest.
func (c *ControllerPowerStateChangeRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &c.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ControllerPowerStateChangeRequestProperties.
func (c ControllerPowerStateChangeRequestProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "action", c.Action)
	populate(objectMap, "activeController", c.ActiveController)
	populate(objectMap, "controller0State", c.Controller0State)
	populate(objectMap, "controller1State", c.Controller1State)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ControllerPowerStateChangeRequestProperties.
func (c *ControllerPowerStateChangeRequestProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "action":
			err = unpopulate(val, "Action", &c.Action)
			delete(rawMsg, key)
		case "activeController":
			err = unpopulate(val, "ActiveController", &c.ActiveController)
			delete(rawMsg, key)
		case "controller0State":
			err = unpopulate(val, "Controller0State", &c.Controller0State)
			delete(rawMsg, key)
		case "controller1State":
			err = unpopulate(val, "Controller1State", &c.Controller1State)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DNSSettings.
func (d DNSSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "primaryDnsServer", d.PrimaryDNSServer)
	populate(objectMap, "primaryIpv6DnsServer", d.PrimaryIPv6DNSServer)
	populate(objectMap, "secondaryDnsServers", d.SecondaryDNSServers)
	populate(objectMap, "secondaryIpv6DnsServers", d.SecondaryIPv6DNSServers)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DNSSettings.
func (d *DNSSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "primaryDnsServer":
			err = unpopulate(val, "PrimaryDNSServer", &d.PrimaryDNSServer)
			delete(rawMsg, key)
		case "primaryIpv6DnsServer":
			err = unpopulate(val, "PrimaryIPv6DNSServer", &d.PrimaryIPv6DNSServer)
			delete(rawMsg, key)
		case "secondaryDnsServers":
			err = unpopulate(val, "SecondaryDNSServers", &d.SecondaryDNSServers)
			delete(rawMsg, key)
		case "secondaryIpv6DnsServers":
			err = unpopulate(val, "SecondaryIPv6DNSServers", &d.SecondaryIPv6DNSServers)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DataStatistics.
func (d DataStatistics) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "cloudData", d.CloudData)
	populate(objectMap, "processedData", d.ProcessedData)
	populate(objectMap, "throughput", d.Throughput)
	populate(objectMap, "totalData", d.TotalData)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DataStatistics.
func (d *DataStatistics) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cloudData":
			err = unpopulate(val, "CloudData", &d.CloudData)
			delete(rawMsg, key)
		case "processedData":
			err = unpopulate(val, "ProcessedData", &d.ProcessedData)
			delete(rawMsg, key)
		case "throughput":
			err = unpopulate(val, "Throughput", &d.Throughput)
			delete(rawMsg, key)
		case "totalData":
			err = unpopulate(val, "TotalData", &d.TotalData)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Device.
func (d Device) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", d.ID)
	objectMap["kind"] = "Series8000"
	populate(objectMap, "name", d.Name)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "type", d.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Device.
func (d *Device) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &d.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &d.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &d.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeviceDetails.
func (d DeviceDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "endpointCount", d.EndpointCount)
	populate(objectMap, "volumeContainerCount", d.VolumeContainerCount)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeviceDetails.
func (d *DeviceDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endpointCount":
			err = unpopulate(val, "EndpointCount", &d.EndpointCount)
			delete(rawMsg, key)
		case "volumeContainerCount":
			err = unpopulate(val, "VolumeContainerCount", &d.VolumeContainerCount)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeviceList.
func (d DeviceList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", d.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeviceList.
func (d *DeviceList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &d.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DevicePatch.
func (d DevicePatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", d.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DevicePatch.
func (d *DevicePatch) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &d.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DevicePatchProperties.
func (d DevicePatchProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "deviceDescription", d.DeviceDescription)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DevicePatchProperties.
func (d *DevicePatchProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "deviceDescription":
			err = unpopulate(val, "DeviceDescription", &d.DeviceDescription)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeviceProperties.
func (d DeviceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "activationTime", d.ActivationTime)
	populate(objectMap, "activeController", d.ActiveController)
	populate(objectMap, "agentGroupVersion", d.AgentGroupVersion)
	populate(objectMap, "availableLocalStorageInBytes", d.AvailableLocalStorageInBytes)
	populate(objectMap, "availableTieredStorageInBytes", d.AvailableTieredStorageInBytes)
	populate(objectMap, "culture", d.Culture)
	populate(objectMap, "details", d.Details)
	populate(objectMap, "deviceConfigurationStatus", d.DeviceConfigurationStatus)
	populate(objectMap, "deviceDescription", d.DeviceDescription)
	populate(objectMap, "deviceLocation", d.DeviceLocation)
	populate(objectMap, "deviceSoftwareVersion", d.DeviceSoftwareVersion)
	populate(objectMap, "deviceType", d.DeviceType)
	populate(objectMap, "friendlyName", d.FriendlyName)
	populate(objectMap, "friendlySoftwareName", d.FriendlySoftwareName)
	populate(objectMap, "friendlySoftwareVersion", d.FriendlySoftwareVersion)
	populate(objectMap, "modelDescription", d.ModelDescription)
	populate(objectMap, "networkInterfaceCardCount", d.NetworkInterfaceCardCount)
	populate(objectMap, "provisionedLocalStorageInBytes", d.ProvisionedLocalStorageInBytes)
	populate(objectMap, "provisionedTieredStorageInBytes", d.ProvisionedTieredStorageInBytes)
	populate(objectMap, "provisionedVolumeSizeInBytes", d.ProvisionedVolumeSizeInBytes)
	populate(objectMap, "rolloverDetails", d.RolloverDetails)
	populate(objectMap, "serialNumber", d.SerialNumber)
	populate(objectMap, "status", d.Status)
	populate(objectMap, "targetIqn", d.TargetIqn)
	populate(objectMap, "totalTieredStorageInBytes", d.TotalTieredStorageInBytes)
	populate(objectMap, "usingStorageInBytes", d.UsingStorageInBytes)
	populate(objectMap, "virtualMachineApiType", d.VirtualMachineAPIType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeviceProperties.
func (d *DeviceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "activationTime":
			err = unpopulateDateTimeRFC3339(val, "ActivationTime", &d.ActivationTime)
			delete(rawMsg, key)
		case "activeController":
			err = unpopulate(val, "ActiveController", &d.ActiveController)
			delete(rawMsg, key)
		case "agentGroupVersion":
			err = unpopulate(val, "AgentGroupVersion", &d.AgentGroupVersion)
			delete(rawMsg, key)
		case "availableLocalStorageInBytes":
			err = unpopulate(val, "AvailableLocalStorageInBytes", &d.AvailableLocalStorageInBytes)
			delete(rawMsg, key)
		case "availableTieredStorageInBytes":
			err = unpopulate(val, "AvailableTieredStorageInBytes", &d.AvailableTieredStorageInBytes)
			delete(rawMsg, key)
		case "culture":
			err = unpopulate(val, "Culture", &d.Culture)
			delete(rawMsg, key)
		case "details":
			err = unpopulate(val, "Details", &d.Details)
			delete(rawMsg, key)
		case "deviceConfigurationStatus":
			err = unpopulate(val, "DeviceConfigurationStatus", &d.DeviceConfigurationStatus)
			delete(rawMsg, key)
		case "deviceDescription":
			err = unpopulate(val, "DeviceDescription", &d.DeviceDescription)
			delete(rawMsg, key)
		case "deviceLocation":
			err = unpopulate(val, "DeviceLocation", &d.DeviceLocation)
			delete(rawMsg, key)
		case "deviceSoftwareVersion":
			err = unpopulate(val, "DeviceSoftwareVersion", &d.DeviceSoftwareVersion)
			delete(rawMsg, key)
		case "deviceType":
			err = unpopulate(val, "DeviceType", &d.DeviceType)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &d.FriendlyName)
			delete(rawMsg, key)
		case "friendlySoftwareName":
			err = unpopulate(val, "FriendlySoftwareName", &d.FriendlySoftwareName)
			delete(rawMsg, key)
		case "friendlySoftwareVersion":
			err = unpopulate(val, "FriendlySoftwareVersion", &d.FriendlySoftwareVersion)
			delete(rawMsg, key)
		case "modelDescription":
			err = unpopulate(val, "ModelDescription", &d.ModelDescription)
			delete(rawMsg, key)
		case "networkInterfaceCardCount":
			err = unpopulate(val, "NetworkInterfaceCardCount", &d.NetworkInterfaceCardCount)
			delete(rawMsg, key)
		case "provisionedLocalStorageInBytes":
			err = unpopulate(val, "ProvisionedLocalStorageInBytes", &d.ProvisionedLocalStorageInBytes)
			delete(rawMsg, key)
		case "provisionedTieredStorageInBytes":
			err = unpopulate(val, "ProvisionedTieredStorageInBytes", &d.ProvisionedTieredStorageInBytes)
			delete(rawMsg, key)
		case "provisionedVolumeSizeInBytes":
			err = unpopulate(val, "ProvisionedVolumeSizeInBytes", &d.ProvisionedVolumeSizeInBytes)
			delete(rawMsg, key)
		case "rolloverDetails":
			err = unpopulate(val, "RolloverDetails", &d.RolloverDetails)
			delete(rawMsg, key)
		case "serialNumber":
			err = unpopulate(val, "SerialNumber", &d.SerialNumber)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &d.Status)
			delete(rawMsg, key)
		case "targetIqn":
			err = unpopulate(val, "TargetIqn", &d.TargetIqn)
			delete(rawMsg, key)
		case "totalTieredStorageInBytes":
			err = unpopulate(val, "TotalTieredStorageInBytes", &d.TotalTieredStorageInBytes)
			delete(rawMsg, key)
		case "usingStorageInBytes":
			err = unpopulate(val, "UsingStorageInBytes", &d.UsingStorageInBytes)
			delete(rawMsg, key)
		case "virtualMachineApiType":
			err = unpopulate(val, "VirtualMachineAPIType", &d.VirtualMachineAPIType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeviceRolloverDetails.
func (d DeviceRolloverDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "authorizationEligibility", d.AuthorizationEligibility)
	populate(objectMap, "authorizationStatus", d.AuthorizationStatus)
	populate(objectMap, "inEligibilityReason", d.InEligibilityReason)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeviceRolloverDetails.
func (d *DeviceRolloverDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authorizationEligibility":
			err = unpopulate(val, "AuthorizationEligibility", &d.AuthorizationEligibility)
			delete(rawMsg, key)
		case "authorizationStatus":
			err = unpopulate(val, "AuthorizationStatus", &d.AuthorizationStatus)
			delete(rawMsg, key)
		case "inEligibilityReason":
			err = unpopulate(val, "InEligibilityReason", &d.InEligibilityReason)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DimensionFilter.
func (d DimensionFilter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "values", d.Values)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DimensionFilter.
func (d *DimensionFilter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "values":
			err = unpopulate(val, "Values", &d.Values)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EncryptionSettings.
func (e EncryptionSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", e.ID)
	objectMap["kind"] = "Series8000"
	populate(objectMap, "name", e.Name)
	populate(objectMap, "properties", e.Properties)
	populate(objectMap, "type", e.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EncryptionSettings.
func (e *EncryptionSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &e.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &e.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &e.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &e.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EncryptionSettingsProperties.
func (e EncryptionSettingsProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "encryptionStatus", e.EncryptionStatus)
	populate(objectMap, "keyRolloverStatus", e.KeyRolloverStatus)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EncryptionSettingsProperties.
func (e *EncryptionSettingsProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "encryptionStatus":
			err = unpopulate(val, "EncryptionStatus", &e.EncryptionStatus)
			delete(rawMsg, key)
		case "keyRolloverStatus":
			err = unpopulate(val, "KeyRolloverStatus", &e.KeyRolloverStatus)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FailoverRequest.
func (f FailoverRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "targetDeviceId", f.TargetDeviceID)
	populate(objectMap, "volumeContainers", f.VolumeContainers)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FailoverRequest.
func (f *FailoverRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "targetDeviceId":
			err = unpopulate(val, "TargetDeviceID", &f.TargetDeviceID)
			delete(rawMsg, key)
		case "volumeContainers":
			err = unpopulate(val, "VolumeContainers", &f.VolumeContainers)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FailoverSet.
func (f FailoverSet) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "eligibilityResult", f.EligibilityResult)
	populate(objectMap, "volumeContainers", f.VolumeContainers)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FailoverSet.
func (f *FailoverSet) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "eligibilityResult":
			err = unpopulate(val, "EligibilityResult", &f.EligibilityResult)
			delete(rawMsg, key)
		case "volumeContainers":
			err = unpopulate(val, "VolumeContainers", &f.VolumeContainers)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FailoverSetEligibilityResult.
func (f FailoverSetEligibilityResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "errorMessage", f.ErrorMessage)
	populate(objectMap, "isEligibleForFailover", f.IsEligibleForFailover)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FailoverSetEligibilityResult.
func (f *FailoverSetEligibilityResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "errorMessage":
			err = unpopulate(val, "ErrorMessage", &f.ErrorMessage)
			delete(rawMsg, key)
		case "isEligibleForFailover":
			err = unpopulate(val, "IsEligibleForFailover", &f.IsEligibleForFailover)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FailoverSetsList.
func (f FailoverSetsList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", f.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FailoverSetsList.
func (f *FailoverSetsList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &f.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FailoverTarget.
func (f FailoverTarget) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "availableLocalStorageInBytes", f.AvailableLocalStorageInBytes)
	populate(objectMap, "availableTieredStorageInBytes", f.AvailableTieredStorageInBytes)
	populate(objectMap, "dataContainersCount", f.DataContainersCount)
	populate(objectMap, "deviceId", f.DeviceID)
	populate(objectMap, "deviceLocation", f.DeviceLocation)
	populate(objectMap, "deviceSoftwareVersion", f.DeviceSoftwareVersion)
	populate(objectMap, "deviceStatus", f.DeviceStatus)
	populate(objectMap, "eligibilityResult", f.EligibilityResult)
	populate(objectMap, "friendlyDeviceSoftwareVersion", f.FriendlyDeviceSoftwareVersion)
	populate(objectMap, "modelDescription", f.ModelDescription)
	populate(objectMap, "volumesCount", f.VolumesCount)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FailoverTarget.
func (f *FailoverTarget) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "availableLocalStorageInBytes":
			err = unpopulate(val, "AvailableLocalStorageInBytes", &f.AvailableLocalStorageInBytes)
			delete(rawMsg, key)
		case "availableTieredStorageInBytes":
			err = unpopulate(val, "AvailableTieredStorageInBytes", &f.AvailableTieredStorageInBytes)
			delete(rawMsg, key)
		case "dataContainersCount":
			err = unpopulate(val, "DataContainersCount", &f.DataContainersCount)
			delete(rawMsg, key)
		case "deviceId":
			err = unpopulate(val, "DeviceID", &f.DeviceID)
			delete(rawMsg, key)
		case "deviceLocation":
			err = unpopulate(val, "DeviceLocation", &f.DeviceLocation)
			delete(rawMsg, key)
		case "deviceSoftwareVersion":
			err = unpopulate(val, "DeviceSoftwareVersion", &f.DeviceSoftwareVersion)
			delete(rawMsg, key)
		case "deviceStatus":
			err = unpopulate(val, "DeviceStatus", &f.DeviceStatus)
			delete(rawMsg, key)
		case "eligibilityResult":
			err = unpopulate(val, "EligibilityResult", &f.EligibilityResult)
			delete(rawMsg, key)
		case "friendlyDeviceSoftwareVersion":
			err = unpopulate(val, "FriendlyDeviceSoftwareVersion", &f.FriendlyDeviceSoftwareVersion)
			delete(rawMsg, key)
		case "modelDescription":
			err = unpopulate(val, "ModelDescription", &f.ModelDescription)
			delete(rawMsg, key)
		case "volumesCount":
			err = unpopulate(val, "VolumesCount", &f.VolumesCount)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FailoverTargetsList.
func (f FailoverTargetsList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", f.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FailoverTargetsList.
func (f *FailoverTargetsList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &f.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Feature.
func (f Feature) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", f.Name)
	populate(objectMap, "status", f.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Feature.
func (f *Feature) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &f.Name)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &f.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FeatureFilter.
func (f FeatureFilter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "deviceId", f.DeviceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FeatureFilter.
func (f *FeatureFilter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "deviceId":
			err = unpopulate(val, "DeviceID", &f.DeviceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FeatureList.
func (f FeatureList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", f.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FeatureList.
func (f *FeatureList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &f.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HardwareComponent.
func (h HardwareComponent) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "componentId", h.ComponentID)
	populate(objectMap, "displayName", h.DisplayName)
	populate(objectMap, "status", h.Status)
	populate(objectMap, "statusDisplayName", h.StatusDisplayName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HardwareComponent.
func (h *HardwareComponent) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "componentId":
			err = unpopulate(val, "ComponentID", &h.ComponentID)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &h.DisplayName)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &h.Status)
			delete(rawMsg, key)
		case "statusDisplayName":
			err = unpopulate(val, "StatusDisplayName", &h.StatusDisplayName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HardwareComponentGroup.
func (h HardwareComponentGroup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", h.ID)
	objectMap["kind"] = "Series8000"
	populate(objectMap, "name", h.Name)
	populate(objectMap, "properties", h.Properties)
	populate(objectMap, "type", h.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HardwareComponentGroup.
func (h *HardwareComponentGroup) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &h.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &h.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &h.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &h.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &h.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HardwareComponentGroupList.
func (h HardwareComponentGroupList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", h.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HardwareComponentGroupList.
func (h *HardwareComponentGroupList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &h.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HardwareComponentGroupProperties.
func (h HardwareComponentGroupProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "components", h.Components)
	populate(objectMap, "displayName", h.DisplayName)
	populateDateTimeRFC3339(objectMap, "lastUpdatedTime", h.LastUpdatedTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HardwareComponentGroupProperties.
func (h *HardwareComponentGroupProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "components":
			err = unpopulate(val, "Components", &h.Components)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &h.DisplayName)
			delete(rawMsg, key)
		case "lastUpdatedTime":
			err = unpopulateDateTimeRFC3339(val, "LastUpdatedTime", &h.LastUpdatedTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Job.
func (j Job) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "endTime", j.EndTime)
	populate(objectMap, "error", j.Error)
	populate(objectMap, "id", j.ID)
	objectMap["kind"] = "Series8000"
	populate(objectMap, "name", j.Name)
	populate(objectMap, "percentComplete", j.PercentComplete)
	populate(objectMap, "properties", j.Properties)
	populateDateTimeRFC3339(objectMap, "startTime", j.StartTime)
	populate(objectMap, "status", j.Status)
	populate(objectMap, "type", j.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Job.
func (j *Job) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endTime":
			err = unpopulateDateTimeRFC3339(val, "EndTime", &j.EndTime)
			delete(rawMsg, key)
		case "error":
			err = unpopulate(val, "Error", &j.Error)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &j.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &j.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &j.Name)
			delete(rawMsg, key)
		case "percentComplete":
			err = unpopulate(val, "PercentComplete", &j.PercentComplete)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &j.Properties)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateDateTimeRFC3339(val, "StartTime", &j.StartTime)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &j.Status)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &j.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JobErrorDetails.
func (j JobErrorDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", j.Code)
	populate(objectMap, "errorDetails", j.ErrorDetails)
	populate(objectMap, "message", j.Message)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JobErrorDetails.
func (j *JobErrorDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &j.Code)
			delete(rawMsg, key)
		case "errorDetails":
			err = unpopulate(val, "ErrorDetails", &j.ErrorDetails)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &j.Message)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JobErrorItem.
func (j JobErrorItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", j.Code)
	populate(objectMap, "message", j.Message)
	populate(objectMap, "recommendations", j.Recommendations)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JobErrorItem.
func (j *JobErrorItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &j.Code)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &j.Message)
			delete(rawMsg, key)
		case "recommendations":
			err = unpopulate(val, "Recommendations", &j.Recommendations)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JobFilter.
func (j JobFilter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "jobType", j.JobType)
	populateDateTimeRFC3339(objectMap, "startTime", j.StartTime)
	populate(objectMap, "status", j.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JobFilter.
func (j *JobFilter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "jobType":
			err = unpopulate(val, "JobType", &j.JobType)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateDateTimeRFC3339(val, "StartTime", &j.StartTime)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &j.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JobList.
func (j JobList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", j.NextLink)
	populate(objectMap, "value", j.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JobList.
func (j *JobList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &j.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &j.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JobProperties.
func (j JobProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "backupPointInTime", j.BackupPointInTime)
	populate(objectMap, "backupType", j.BackupType)
	populate(objectMap, "dataStats", j.DataStats)
	populate(objectMap, "deviceId", j.DeviceID)
	populate(objectMap, "entityLabel", j.EntityLabel)
	populate(objectMap, "entityType", j.EntityType)
	populate(objectMap, "isCancellable", j.IsCancellable)
	populate(objectMap, "jobStages", j.JobStages)
	populate(objectMap, "jobType", j.JobType)
	populate(objectMap, "sourceDeviceId", j.SourceDeviceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JobProperties.
func (j *JobProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backupPointInTime":
			err = unpopulateDateTimeRFC3339(val, "BackupPointInTime", &j.BackupPointInTime)
			delete(rawMsg, key)
		case "backupType":
			err = unpopulate(val, "BackupType", &j.BackupType)
			delete(rawMsg, key)
		case "dataStats":
			err = unpopulate(val, "DataStats", &j.DataStats)
			delete(rawMsg, key)
		case "deviceId":
			err = unpopulate(val, "DeviceID", &j.DeviceID)
			delete(rawMsg, key)
		case "entityLabel":
			err = unpopulate(val, "EntityLabel", &j.EntityLabel)
			delete(rawMsg, key)
		case "entityType":
			err = unpopulate(val, "EntityType", &j.EntityType)
			delete(rawMsg, key)
		case "isCancellable":
			err = unpopulate(val, "IsCancellable", &j.IsCancellable)
			delete(rawMsg, key)
		case "jobStages":
			err = unpopulate(val, "JobStages", &j.JobStages)
			delete(rawMsg, key)
		case "jobType":
			err = unpopulate(val, "JobType", &j.JobType)
			delete(rawMsg, key)
		case "sourceDeviceId":
			err = unpopulate(val, "SourceDeviceID", &j.SourceDeviceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JobStage.
func (j JobStage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "detail", j.Detail)
	populate(objectMap, "errorCode", j.ErrorCode)
	populate(objectMap, "message", j.Message)
	populate(objectMap, "stageStatus", j.StageStatus)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JobStage.
func (j *JobStage) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "detail":
			err = unpopulate(val, "Detail", &j.Detail)
			delete(rawMsg, key)
		case "errorCode":
			err = unpopulate(val, "ErrorCode", &j.ErrorCode)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &j.Message)
			delete(rawMsg, key)
		case "stageStatus":
			err = unpopulate(val, "StageStatus", &j.StageStatus)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Key.
func (k Key) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "activationKey", k.ActivationKey)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Key.
func (k *Key) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "activationKey":
			err = unpopulate(val, "ActivationKey", &k.ActivationKey)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ListFailoverTargetsRequest.
func (l ListFailoverTargetsRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "volumeContainers", l.VolumeContainers)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ListFailoverTargetsRequest.
func (l *ListFailoverTargetsRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "volumeContainers":
			err = unpopulate(val, "VolumeContainers", &l.VolumeContainers)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Manager.
func (m Manager) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", m.Etag)
	populate(objectMap, "id", m.ID)
	populate(objectMap, "location", m.Location)
	populate(objectMap, "name", m.Name)
	populate(objectMap, "properties", m.Properties)
	populate(objectMap, "tags", m.Tags)
	populate(objectMap, "type", m.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Manager.
func (m *Manager) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &m.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &m.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &m.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &m.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagerExtendedInfo.
func (m ManagerExtendedInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", m.Etag)
	populate(objectMap, "id", m.ID)
	objectMap["kind"] = "Series8000"
	populate(objectMap, "name", m.Name)
	populate(objectMap, "properties", m.Properties)
	populate(objectMap, "type", m.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagerExtendedInfo.
func (m *ManagerExtendedInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &m.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &m.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &m.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagerExtendedInfoProperties.
func (m ManagerExtendedInfoProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "algorithm", m.Algorithm)
	populate(objectMap, "encryptionKey", m.EncryptionKey)
	populate(objectMap, "encryptionKeyThumbprint", m.EncryptionKeyThumbprint)
	populate(objectMap, "integrityKey", m.IntegrityKey)
	populate(objectMap, "portalCertificateThumbprint", m.PortalCertificateThumbprint)
	populate(objectMap, "version", m.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagerExtendedInfoProperties.
func (m *ManagerExtendedInfoProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "algorithm":
			err = unpopulate(val, "Algorithm", &m.Algorithm)
			delete(rawMsg, key)
		case "encryptionKey":
			err = unpopulate(val, "EncryptionKey", &m.EncryptionKey)
			delete(rawMsg, key)
		case "encryptionKeyThumbprint":
			err = unpopulate(val, "EncryptionKeyThumbprint", &m.EncryptionKeyThumbprint)
			delete(rawMsg, key)
		case "integrityKey":
			err = unpopulate(val, "IntegrityKey", &m.IntegrityKey)
			delete(rawMsg, key)
		case "portalCertificateThumbprint":
			err = unpopulate(val, "PortalCertificateThumbprint", &m.PortalCertificateThumbprint)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &m.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagerIntrinsicSettings.
func (m ManagerIntrinsicSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "type", m.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagerIntrinsicSettings.
func (m *ManagerIntrinsicSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagerList.
func (m ManagerList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", m.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagerList.
func (m *ManagerList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &m.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagerPatch.
func (m ManagerPatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "tags", m.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagerPatch.
func (m *ManagerPatch) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "tags":
			err = unpopulate(val, "Tags", &m.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagerProperties.
func (m ManagerProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "cisIntrinsicSettings", m.CisIntrinsicSettings)
	populate(objectMap, "provisioningState", m.ProvisioningState)
	populate(objectMap, "sku", m.SKU)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagerProperties.
func (m *ManagerProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cisIntrinsicSettings":
			err = unpopulate(val, "CisIntrinsicSettings", &m.CisIntrinsicSettings)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &m.ProvisioningState)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &m.SKU)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagerSKU.
func (m ManagerSKU) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["name"] = "Standard"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagerSKU.
func (m *ManagerSKU) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MetricAvailablity.
func (m MetricAvailablity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "retention", m.Retention)
	populate(objectMap, "timeGrain", m.TimeGrain)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MetricAvailablity.
func (m *MetricAvailablity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "retention":
			err = unpopulate(val, "Retention", &m.Retention)
			delete(rawMsg, key)
		case "timeGrain":
			err = unpopulate(val, "TimeGrain", &m.TimeGrain)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MetricData.
func (m MetricData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "average", m.Average)
	populate(objectMap, "count", m.Count)
	populate(objectMap, "maximum", m.Maximum)
	populate(objectMap, "minimum", m.Minimum)
	populate(objectMap, "sum", m.Sum)
	populateDateTimeRFC3339(objectMap, "timeStamp", m.TimeStamp)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MetricData.
func (m *MetricData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "average":
			err = unpopulate(val, "Average", &m.Average)
			delete(rawMsg, key)
		case "count":
			err = unpopulate(val, "Count", &m.Count)
			delete(rawMsg, key)
		case "maximum":
			err = unpopulate(val, "Maximum", &m.Maximum)
			delete(rawMsg, key)
		case "minimum":
			err = unpopulate(val, "Minimum", &m.Minimum)
			delete(rawMsg, key)
		case "sum":
			err = unpopulate(val, "Sum", &m.Sum)
			delete(rawMsg, key)
		case "timeStamp":
			err = unpopulateDateTimeRFC3339(val, "TimeStamp", &m.TimeStamp)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MetricDefinition.
func (m MetricDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "category", m.Category)
	populate(objectMap, "dimensions", m.Dimensions)
	populate(objectMap, "metricAvailabilities", m.MetricAvailabilities)
	populate(objectMap, "name", m.Name)
	populate(objectMap, "primaryAggregationType", m.PrimaryAggregationType)
	populate(objectMap, "resourceId", m.ResourceID)
	populate(objectMap, "type", m.Type)
	populate(objectMap, "unit", m.Unit)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MetricDefinition.
func (m *MetricDefinition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "category":
			err = unpopulate(val, "Category", &m.Category)
			delete(rawMsg, key)
		case "dimensions":
			err = unpopulate(val, "Dimensions", &m.Dimensions)
			delete(rawMsg, key)
		case "metricAvailabilities":
			err = unpopulate(val, "MetricAvailabilities", &m.MetricAvailabilities)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		case "primaryAggregationType":
			err = unpopulate(val, "PrimaryAggregationType", &m.PrimaryAggregationType)
			delete(rawMsg, key)
		case "resourceId":
			err = unpopulate(val, "ResourceID", &m.ResourceID)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		case "unit":
			err = unpopulate(val, "Unit", &m.Unit)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MetricDefinitionList.
func (m MetricDefinitionList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", m.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MetricDefinitionList.
func (m *MetricDefinitionList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &m.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MetricDimension.
func (m MetricDimension) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", m.Name)
	populate(objectMap, "value", m.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MetricDimension.
func (m *MetricDimension) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &m.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MetricFilter.
func (m MetricFilter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "category", m.Category)
	populate(objectMap, "dimensions", m.Dimensions)
	populateDateTimeRFC3339(objectMap, "endTime", m.EndTime)
	populate(objectMap, "name", m.Name)
	populateDateTimeRFC3339(objectMap, "startTime", m.StartTime)
	populate(objectMap, "timeGrain", m.TimeGrain)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MetricFilter.
func (m *MetricFilter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "category":
			err = unpopulate(val, "Category", &m.Category)
			delete(rawMsg, key)
		case "dimensions":
			err = unpopulate(val, "Dimensions", &m.Dimensions)
			delete(rawMsg, key)
		case "endTime":
			err = unpopulateDateTimeRFC3339(val, "EndTime", &m.EndTime)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateDateTimeRFC3339(val, "StartTime", &m.StartTime)
			delete(rawMsg, key)
		case "timeGrain":
			err = unpopulate(val, "TimeGrain", &m.TimeGrain)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MetricList.
func (m MetricList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", m.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MetricList.
func (m *MetricList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &m.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MetricName.
func (m MetricName) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "localizedValue", m.LocalizedValue)
	populate(objectMap, "value", m.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MetricName.
func (m *MetricName) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "localizedValue":
			err = unpopulate(val, "LocalizedValue", &m.LocalizedValue)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &m.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MetricNameFilter.
func (m MetricNameFilter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", m.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MetricNameFilter.
func (m *MetricNameFilter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &m.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Metrics.
func (m Metrics) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dimensions", m.Dimensions)
	populateDateTimeRFC3339(objectMap, "endTime", m.EndTime)
	populate(objectMap, "name", m.Name)
	populate(objectMap, "primaryAggregation", m.PrimaryAggregation)
	populate(objectMap, "resourceId", m.ResourceID)
	populateDateTimeRFC3339(objectMap, "startTime", m.StartTime)
	populate(objectMap, "timeGrain", m.TimeGrain)
	populate(objectMap, "type", m.Type)
	populate(objectMap, "unit", m.Unit)
	populate(objectMap, "values", m.Values)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Metrics.
func (m *Metrics) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dimensions":
			err = unpopulate(val, "Dimensions", &m.Dimensions)
			delete(rawMsg, key)
		case "endTime":
			err = unpopulateDateTimeRFC3339(val, "EndTime", &m.EndTime)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		case "primaryAggregation":
			err = unpopulate(val, "PrimaryAggregation", &m.PrimaryAggregation)
			delete(rawMsg, key)
		case "resourceId":
			err = unpopulate(val, "ResourceID", &m.ResourceID)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateDateTimeRFC3339(val, "StartTime", &m.StartTime)
			delete(rawMsg, key)
		case "timeGrain":
			err = unpopulate(val, "TimeGrain", &m.TimeGrain)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		case "unit":
			err = unpopulate(val, "Unit", &m.Unit)
			delete(rawMsg, key)
		case "values":
			err = unpopulate(val, "Values", &m.Values)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkAdapterList.
func (n NetworkAdapterList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", n.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkAdapterList.
func (n *NetworkAdapterList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &n.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkAdapters.
func (n NetworkAdapters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "interfaceId", n.InterfaceID)
	populate(objectMap, "isDefault", n.IsDefault)
	populate(objectMap, "iscsiAndCloudStatus", n.IscsiAndCloudStatus)
	populate(objectMap, "mode", n.Mode)
	populate(objectMap, "netInterfaceStatus", n.NetInterfaceStatus)
	populate(objectMap, "nicIpv4Settings", n.NicIPv4Settings)
	populate(objectMap, "nicIpv6Settings", n.NicIPv6Settings)
	populate(objectMap, "speed", n.Speed)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkAdapters.
func (n *NetworkAdapters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "interfaceId":
			err = unpopulate(val, "InterfaceID", &n.InterfaceID)
			delete(rawMsg, key)
		case "isDefault":
			err = unpopulate(val, "IsDefault", &n.IsDefault)
			delete(rawMsg, key)
		case "iscsiAndCloudStatus":
			err = unpopulate(val, "IscsiAndCloudStatus", &n.IscsiAndCloudStatus)
			delete(rawMsg, key)
		case "mode":
			err = unpopulate(val, "Mode", &n.Mode)
			delete(rawMsg, key)
		case "netInterfaceStatus":
			err = unpopulate(val, "NetInterfaceStatus", &n.NetInterfaceStatus)
			delete(rawMsg, key)
		case "nicIpv4Settings":
			err = unpopulate(val, "NicIPv4Settings", &n.NicIPv4Settings)
			delete(rawMsg, key)
		case "nicIpv6Settings":
			err = unpopulate(val, "NicIPv6Settings", &n.NicIPv6Settings)
			delete(rawMsg, key)
		case "speed":
			err = unpopulate(val, "Speed", &n.Speed)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkInterfaceData0Settings.
func (n NetworkInterfaceData0Settings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "controllerOneIp", n.ControllerOneIP)
	populate(objectMap, "controllerZeroIp", n.ControllerZeroIP)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkInterfaceData0Settings.
func (n *NetworkInterfaceData0Settings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "controllerOneIp":
			err = unpopulate(val, "ControllerOneIP", &n.ControllerOneIP)
			delete(rawMsg, key)
		case "controllerZeroIp":
			err = unpopulate(val, "ControllerZeroIP", &n.ControllerZeroIP)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkSettings.
func (n NetworkSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", n.ID)
	objectMap["kind"] = "Series8000"
	populate(objectMap, "name", n.Name)
	populate(objectMap, "properties", n.Properties)
	populate(objectMap, "type", n.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkSettings.
func (n *NetworkSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &n.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &n.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &n.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &n.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &n.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkSettingsPatch.
func (n NetworkSettingsPatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", n.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkSettingsPatch.
func (n *NetworkSettingsPatch) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &n.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkSettingsPatchProperties.
func (n NetworkSettingsPatchProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dnsSettings", n.DNSSettings)
	populate(objectMap, "networkAdapters", n.NetworkAdapters)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkSettingsPatchProperties.
func (n *NetworkSettingsPatchProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dnsSettings":
			err = unpopulate(val, "DNSSettings", &n.DNSSettings)
			delete(rawMsg, key)
		case "networkAdapters":
			err = unpopulate(val, "NetworkAdapters", &n.NetworkAdapters)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkSettingsProperties.
func (n NetworkSettingsProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dnsSettings", n.DNSSettings)
	populate(objectMap, "networkAdapters", n.NetworkAdapters)
	populate(objectMap, "webproxySettings", n.WebproxySettings)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkSettingsProperties.
func (n *NetworkSettingsProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dnsSettings":
			err = unpopulate(val, "DNSSettings", &n.DNSSettings)
			delete(rawMsg, key)
		case "networkAdapters":
			err = unpopulate(val, "NetworkAdapters", &n.NetworkAdapters)
			delete(rawMsg, key)
		case "webproxySettings":
			err = unpopulate(val, "WebproxySettings", &n.WebproxySettings)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NicIPv4.
func (n NicIPv4) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "controller0Ipv4Address", n.Controller0IPv4Address)
	populate(objectMap, "controller1Ipv4Address", n.Controller1IPv4Address)
	populate(objectMap, "ipv4Address", n.IPv4Address)
	populate(objectMap, "ipv4Gateway", n.IPv4Gateway)
	populate(objectMap, "ipv4Netmask", n.IPv4Netmask)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NicIPv4.
func (n *NicIPv4) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "controller0Ipv4Address":
			err = unpopulate(val, "Controller0IPv4Address", &n.Controller0IPv4Address)
			delete(rawMsg, key)
		case "controller1Ipv4Address":
			err = unpopulate(val, "Controller1IPv4Address", &n.Controller1IPv4Address)
			delete(rawMsg, key)
		case "ipv4Address":
			err = unpopulate(val, "IPv4Address", &n.IPv4Address)
			delete(rawMsg, key)
		case "ipv4Gateway":
			err = unpopulate(val, "IPv4Gateway", &n.IPv4Gateway)
			delete(rawMsg, key)
		case "ipv4Netmask":
			err = unpopulate(val, "IPv4Netmask", &n.IPv4Netmask)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NicIPv6.
func (n NicIPv6) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "controller0Ipv6Address", n.Controller0IPv6Address)
	populate(objectMap, "controller1Ipv6Address", n.Controller1IPv6Address)
	populate(objectMap, "ipv6Address", n.IPv6Address)
	populate(objectMap, "ipv6Gateway", n.IPv6Gateway)
	populate(objectMap, "ipv6Prefix", n.IPv6Prefix)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NicIPv6.
func (n *NicIPv6) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "controller0Ipv6Address":
			err = unpopulate(val, "Controller0IPv6Address", &n.Controller0IPv6Address)
			delete(rawMsg, key)
		case "controller1Ipv6Address":
			err = unpopulate(val, "Controller1IPv6Address", &n.Controller1IPv6Address)
			delete(rawMsg, key)
		case "ipv6Address":
			err = unpopulate(val, "IPv6Address", &n.IPv6Address)
			delete(rawMsg, key)
		case "ipv6Gateway":
			err = unpopulate(val, "IPv6Gateway", &n.IPv6Gateway)
			delete(rawMsg, key)
		case "ipv6Prefix":
			err = unpopulate(val, "IPv6Prefix", &n.IPv6Prefix)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PublicKey.
func (p PublicKey) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "key", p.Key)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PublicKey.
func (p *PublicKey) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "key":
			err = unpopulate(val, "Key", &p.Key)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RemoteManagementSettings.
func (r RemoteManagementSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "remoteManagementCertificate", r.RemoteManagementCertificate)
	populate(objectMap, "remoteManagementMode", r.RemoteManagementMode)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RemoteManagementSettings.
func (r *RemoteManagementSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "remoteManagementCertificate":
			err = unpopulate(val, "RemoteManagementCertificate", &r.RemoteManagementCertificate)
			delete(rawMsg, key)
		case "remoteManagementMode":
			err = unpopulate(val, "RemoteManagementMode", &r.RemoteManagementMode)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RemoteManagementSettingsPatch.
func (r RemoteManagementSettingsPatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "remoteManagementMode", r.RemoteManagementMode)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RemoteManagementSettingsPatch.
func (r *RemoteManagementSettingsPatch) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "remoteManagementMode":
			err = unpopulate(val, "RemoteManagementMode", &r.RemoteManagementMode)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "location", r.Location)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "tags", r.Tags)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Resource.
func (r *Resource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &r.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &r.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ScheduleRecurrence.
func (s ScheduleRecurrence) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "recurrenceType", s.RecurrenceType)
	populate(objectMap, "recurrenceValue", s.RecurrenceValue)
	populate(objectMap, "weeklyDaysList", s.WeeklyDaysList)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ScheduleRecurrence.
func (s *ScheduleRecurrence) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "recurrenceType":
			err = unpopulate(val, "RecurrenceType", &s.RecurrenceType)
			delete(rawMsg, key)
		case "recurrenceValue":
			err = unpopulate(val, "RecurrenceValue", &s.RecurrenceValue)
			delete(rawMsg, key)
		case "weeklyDaysList":
			err = unpopulate(val, "WeeklyDaysList", &s.WeeklyDaysList)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SecondaryDNSSettings.
func (s SecondaryDNSSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "secondaryDnsServers", s.SecondaryDNSServers)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SecondaryDNSSettings.
func (s *SecondaryDNSSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "secondaryDnsServers":
			err = unpopulate(val, "SecondaryDNSServers", &s.SecondaryDNSServers)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SecuritySettings.
func (s SecuritySettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	objectMap["kind"] = "Series8000"
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SecuritySettings.
func (s *SecuritySettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &s.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SecuritySettingsPatch.
func (s SecuritySettingsPatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", s.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SecuritySettingsPatch.
func (s *SecuritySettingsPatch) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SecuritySettingsPatchProperties.
func (s SecuritySettingsPatchProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "chapSettings", s.ChapSettings)
	populate(objectMap, "cloudApplianceSettings", s.CloudApplianceSettings)
	populate(objectMap, "deviceAdminPassword", s.DeviceAdminPassword)
	populate(objectMap, "remoteManagementSettings", s.RemoteManagementSettings)
	populate(objectMap, "snapshotPassword", s.SnapshotPassword)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SecuritySettingsPatchProperties.
func (s *SecuritySettingsPatchProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "chapSettings":
			err = unpopulate(val, "ChapSettings", &s.ChapSettings)
			delete(rawMsg, key)
		case "cloudApplianceSettings":
			err = unpopulate(val, "CloudApplianceSettings", &s.CloudApplianceSettings)
			delete(rawMsg, key)
		case "deviceAdminPassword":
			err = unpopulate(val, "DeviceAdminPassword", &s.DeviceAdminPassword)
			delete(rawMsg, key)
		case "remoteManagementSettings":
			err = unpopulate(val, "RemoteManagementSettings", &s.RemoteManagementSettings)
			delete(rawMsg, key)
		case "snapshotPassword":
			err = unpopulate(val, "SnapshotPassword", &s.SnapshotPassword)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SecuritySettingsProperties.
func (s SecuritySettingsProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "chapSettings", s.ChapSettings)
	populate(objectMap, "remoteManagementSettings", s.RemoteManagementSettings)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SecuritySettingsProperties.
func (s *SecuritySettingsProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "chapSettings":
			err = unpopulate(val, "ChapSettings", &s.ChapSettings)
			delete(rawMsg, key)
		case "remoteManagementSettings":
			err = unpopulate(val, "RemoteManagementSettings", &s.RemoteManagementSettings)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SendTestAlertEmailRequest.
func (s SendTestAlertEmailRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "emailList", s.EmailList)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SendTestAlertEmailRequest.
func (s *SendTestAlertEmailRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "emailList":
			err = unpopulate(val, "EmailList", &s.EmailList)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StorageAccountCredential.
func (s StorageAccountCredential) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	objectMap["kind"] = "Series8000"
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StorageAccountCredential.
func (s *StorageAccountCredential) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &s.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StorageAccountCredentialList.
func (s StorageAccountCredentialList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StorageAccountCredentialList.
func (s *StorageAccountCredentialList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StorageAccountCredentialProperties.
func (s StorageAccountCredentialProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "accessKey", s.AccessKey)
	populate(objectMap, "endPoint", s.EndPoint)
	populate(objectMap, "sslStatus", s.SSLStatus)
	populate(objectMap, "volumesCount", s.VolumesCount)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StorageAccountCredentialProperties.
func (s *StorageAccountCredentialProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accessKey":
			err = unpopulate(val, "AccessKey", &s.AccessKey)
			delete(rawMsg, key)
		case "endPoint":
			err = unpopulate(val, "EndPoint", &s.EndPoint)
			delete(rawMsg, key)
		case "sslStatus":
			err = unpopulate(val, "SSLStatus", &s.SSLStatus)
			delete(rawMsg, key)
		case "volumesCount":
			err = unpopulate(val, "VolumesCount", &s.VolumesCount)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SymmetricEncryptedSecret.
func (s SymmetricEncryptedSecret) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "encryptionAlgorithm", s.EncryptionAlgorithm)
	populate(objectMap, "value", s.Value)
	populate(objectMap, "valueCertificateThumbprint", s.ValueCertificateThumbprint)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SymmetricEncryptedSecret.
func (s *SymmetricEncryptedSecret) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "encryptionAlgorithm":
			err = unpopulate(val, "EncryptionAlgorithm", &s.EncryptionAlgorithm)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		case "valueCertificateThumbprint":
			err = unpopulate(val, "ValueCertificateThumbprint", &s.ValueCertificateThumbprint)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TargetEligibilityErrorMessage.
func (t TargetEligibilityErrorMessage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "message", t.Message)
	populate(objectMap, "resolution", t.Resolution)
	populate(objectMap, "resultCode", t.ResultCode)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TargetEligibilityErrorMessage.
func (t *TargetEligibilityErrorMessage) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "message":
			err = unpopulate(val, "Message", &t.Message)
			delete(rawMsg, key)
		case "resolution":
			err = unpopulate(val, "Resolution", &t.Resolution)
			delete(rawMsg, key)
		case "resultCode":
			err = unpopulate(val, "ResultCode", &t.ResultCode)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TargetEligibilityResult.
func (t TargetEligibilityResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "eligibilityStatus", t.EligibilityStatus)
	populate(objectMap, "messages", t.Messages)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TargetEligibilityResult.
func (t *TargetEligibilityResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "eligibilityStatus":
			err = unpopulate(val, "EligibilityStatus", &t.EligibilityStatus)
			delete(rawMsg, key)
		case "messages":
			err = unpopulate(val, "Messages", &t.Messages)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Time.
func (t Time) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "hours", t.Hours)
	populate(objectMap, "minutes", t.Minutes)
	populate(objectMap, "seconds", t.Seconds)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Time.
func (t *Time) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "hours":
			err = unpopulate(val, "Hours", &t.Hours)
			delete(rawMsg, key)
		case "minutes":
			err = unpopulate(val, "Minutes", &t.Minutes)
			delete(rawMsg, key)
		case "seconds":
			err = unpopulate(val, "Seconds", &t.Seconds)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TimeSettings.
func (t TimeSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", t.ID)
	objectMap["kind"] = "Series8000"
	populate(objectMap, "name", t.Name)
	populate(objectMap, "properties", t.Properties)
	populate(objectMap, "type", t.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TimeSettings.
func (t *TimeSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &t.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &t.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &t.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &t.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &t.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TimeSettingsProperties.
func (t TimeSettingsProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "primaryTimeServer", t.PrimaryTimeServer)
	populate(objectMap, "secondaryTimeServer", t.SecondaryTimeServer)
	populate(objectMap, "timeZone", t.TimeZone)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TimeSettingsProperties.
func (t *TimeSettingsProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "primaryTimeServer":
			err = unpopulate(val, "PrimaryTimeServer", &t.PrimaryTimeServer)
			delete(rawMsg, key)
		case "secondaryTimeServer":
			err = unpopulate(val, "SecondaryTimeServer", &t.SecondaryTimeServer)
			delete(rawMsg, key)
		case "timeZone":
			err = unpopulate(val, "TimeZone", &t.TimeZone)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Updates.
func (u Updates) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", u.ID)
	objectMap["kind"] = "Series8000"
	populate(objectMap, "name", u.Name)
	populate(objectMap, "properties", u.Properties)
	populate(objectMap, "type", u.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Updates.
func (u *Updates) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &u.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &u.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &u.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &u.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &u.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UpdatesProperties.
func (u UpdatesProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "isUpdateInProgress", u.IsUpdateInProgress)
	populateDateTimeRFC3339(objectMap, "lastUpdatedTime", u.LastUpdatedTime)
	populate(objectMap, "maintenanceModeUpdatesAvailable", u.MaintenanceModeUpdatesAvailable)
	populate(objectMap, "regularUpdatesAvailable", u.RegularUpdatesAvailable)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UpdatesProperties.
func (u *UpdatesProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "isUpdateInProgress":
			err = unpopulate(val, "IsUpdateInProgress", &u.IsUpdateInProgress)
			delete(rawMsg, key)
		case "lastUpdatedTime":
			err = unpopulateDateTimeRFC3339(val, "LastUpdatedTime", &u.LastUpdatedTime)
			delete(rawMsg, key)
		case "maintenanceModeUpdatesAvailable":
			err = unpopulate(val, "MaintenanceModeUpdatesAvailable", &u.MaintenanceModeUpdatesAvailable)
			delete(rawMsg, key)
		case "regularUpdatesAvailable":
			err = unpopulate(val, "RegularUpdatesAvailable", &u.RegularUpdatesAvailable)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VMImage.
func (v VMImage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "offer", v.Offer)
	populate(objectMap, "publisher", v.Publisher)
	populate(objectMap, "sku", v.SKU)
	populate(objectMap, "version", v.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VMImage.
func (v *VMImage) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "offer":
			err = unpopulate(val, "Offer", &v.Offer)
			delete(rawMsg, key)
		case "publisher":
			err = unpopulate(val, "Publisher", &v.Publisher)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &v.SKU)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &v.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Volume.
func (v Volume) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", v.ID)
	objectMap["kind"] = "Series8000"
	populate(objectMap, "name", v.Name)
	populate(objectMap, "properties", v.Properties)
	populate(objectMap, "type", v.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Volume.
func (v *Volume) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &v.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &v.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &v.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &v.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VolumeContainer.
func (v VolumeContainer) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", v.ID)
	objectMap["kind"] = "Series8000"
	populate(objectMap, "name", v.Name)
	populate(objectMap, "properties", v.Properties)
	populate(objectMap, "type", v.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VolumeContainer.
func (v *VolumeContainer) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &v.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &v.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &v.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &v.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VolumeContainerFailoverMetadata.
func (v VolumeContainerFailoverMetadata) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "volumeContainerId", v.VolumeContainerID)
	populate(objectMap, "volumes", v.Volumes)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VolumeContainerFailoverMetadata.
func (v *VolumeContainerFailoverMetadata) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "volumeContainerId":
			err = unpopulate(val, "VolumeContainerID", &v.VolumeContainerID)
			delete(rawMsg, key)
		case "volumes":
			err = unpopulate(val, "Volumes", &v.Volumes)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VolumeContainerList.
func (v VolumeContainerList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", v.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VolumeContainerList.
func (v *VolumeContainerList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &v.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VolumeContainerProperties.
func (v VolumeContainerProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "bandWidthRateInMbps", v.BandWidthRateInMbps)
	populate(objectMap, "bandwidthSettingId", v.BandwidthSettingID)
	populate(objectMap, "encryptionKey", v.EncryptionKey)
	populate(objectMap, "encryptionStatus", v.EncryptionStatus)
	populate(objectMap, "ownerShipStatus", v.OwnerShipStatus)
	populate(objectMap, "storageAccountCredentialId", v.StorageAccountCredentialID)
	populate(objectMap, "totalCloudStorageUsageInBytes", v.TotalCloudStorageUsageInBytes)
	populate(objectMap, "volumeCount", v.VolumeCount)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VolumeContainerProperties.
func (v *VolumeContainerProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "bandWidthRateInMbps":
			err = unpopulate(val, "BandWidthRateInMbps", &v.BandWidthRateInMbps)
			delete(rawMsg, key)
		case "bandwidthSettingId":
			err = unpopulate(val, "BandwidthSettingID", &v.BandwidthSettingID)
			delete(rawMsg, key)
		case "encryptionKey":
			err = unpopulate(val, "EncryptionKey", &v.EncryptionKey)
			delete(rawMsg, key)
		case "encryptionStatus":
			err = unpopulate(val, "EncryptionStatus", &v.EncryptionStatus)
			delete(rawMsg, key)
		case "ownerShipStatus":
			err = unpopulate(val, "OwnerShipStatus", &v.OwnerShipStatus)
			delete(rawMsg, key)
		case "storageAccountCredentialId":
			err = unpopulate(val, "StorageAccountCredentialID", &v.StorageAccountCredentialID)
			delete(rawMsg, key)
		case "totalCloudStorageUsageInBytes":
			err = unpopulate(val, "TotalCloudStorageUsageInBytes", &v.TotalCloudStorageUsageInBytes)
			delete(rawMsg, key)
		case "volumeCount":
			err = unpopulate(val, "VolumeCount", &v.VolumeCount)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VolumeFailoverMetadata.
func (v VolumeFailoverMetadata) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "backupCreatedDate", v.BackupCreatedDate)
	populate(objectMap, "backupElementId", v.BackupElementID)
	populate(objectMap, "backupId", v.BackupID)
	populate(objectMap, "backupPolicyId", v.BackupPolicyID)
	populate(objectMap, "sizeInBytes", v.SizeInBytes)
	populate(objectMap, "volumeId", v.VolumeID)
	populate(objectMap, "volumeType", v.VolumeType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VolumeFailoverMetadata.
func (v *VolumeFailoverMetadata) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backupCreatedDate":
			err = unpopulateDateTimeRFC3339(val, "BackupCreatedDate", &v.BackupCreatedDate)
			delete(rawMsg, key)
		case "backupElementId":
			err = unpopulate(val, "BackupElementID", &v.BackupElementID)
			delete(rawMsg, key)
		case "backupId":
			err = unpopulate(val, "BackupID", &v.BackupID)
			delete(rawMsg, key)
		case "backupPolicyId":
			err = unpopulate(val, "BackupPolicyID", &v.BackupPolicyID)
			delete(rawMsg, key)
		case "sizeInBytes":
			err = unpopulate(val, "SizeInBytes", &v.SizeInBytes)
			delete(rawMsg, key)
		case "volumeId":
			err = unpopulate(val, "VolumeID", &v.VolumeID)
			delete(rawMsg, key)
		case "volumeType":
			err = unpopulate(val, "VolumeType", &v.VolumeType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VolumeList.
func (v VolumeList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", v.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VolumeList.
func (v *VolumeList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &v.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VolumeProperties.
func (v VolumeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "accessControlRecordIds", v.AccessControlRecordIDs)
	populate(objectMap, "backupPolicyIds", v.BackupPolicyIDs)
	populate(objectMap, "backupStatus", v.BackupStatus)
	populate(objectMap, "monitoringStatus", v.MonitoringStatus)
	populate(objectMap, "operationStatus", v.OperationStatus)
	populate(objectMap, "sizeInBytes", v.SizeInBytes)
	populate(objectMap, "volumeContainerId", v.VolumeContainerID)
	populate(objectMap, "volumeStatus", v.VolumeStatus)
	populate(objectMap, "volumeType", v.VolumeType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VolumeProperties.
func (v *VolumeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accessControlRecordIds":
			err = unpopulate(val, "AccessControlRecordIDs", &v.AccessControlRecordIDs)
			delete(rawMsg, key)
		case "backupPolicyIds":
			err = unpopulate(val, "BackupPolicyIDs", &v.BackupPolicyIDs)
			delete(rawMsg, key)
		case "backupStatus":
			err = unpopulate(val, "BackupStatus", &v.BackupStatus)
			delete(rawMsg, key)
		case "monitoringStatus":
			err = unpopulate(val, "MonitoringStatus", &v.MonitoringStatus)
			delete(rawMsg, key)
		case "operationStatus":
			err = unpopulate(val, "OperationStatus", &v.OperationStatus)
			delete(rawMsg, key)
		case "sizeInBytes":
			err = unpopulate(val, "SizeInBytes", &v.SizeInBytes)
			delete(rawMsg, key)
		case "volumeContainerId":
			err = unpopulate(val, "VolumeContainerID", &v.VolumeContainerID)
			delete(rawMsg, key)
		case "volumeStatus":
			err = unpopulate(val, "VolumeStatus", &v.VolumeStatus)
			delete(rawMsg, key)
		case "volumeType":
			err = unpopulate(val, "VolumeType", &v.VolumeType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WebproxySettings.
func (w WebproxySettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "authentication", w.Authentication)
	populate(objectMap, "connectionUri", w.ConnectionURI)
	populate(objectMap, "username", w.Username)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WebproxySettings.
func (w *WebproxySettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authentication":
			err = unpopulate(val, "Authentication", &w.Authentication)
			delete(rawMsg, key)
		case "connectionUri":
			err = unpopulate(val, "ConnectionURI", &w.ConnectionURI)
			delete(rawMsg, key)
		case "username":
			err = unpopulate(val, "Username", &w.Username)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

func populate(m map[string]any, k string, v any) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func populateAny(m map[string]any, k string, v any) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else {
		m[k] = v
	}
}

func unpopulate(data json.RawMessage, fn string, v any) error {
	if data == nil {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
